/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.policyOptimization;

import com.adventnet.fa.server.policyOptimization.DestPort;
import com.adventnet.fa.server.policyOptimization.DestinationIP;
import com.adventnet.fa.server.policyOptimization.Repository;
import com.adventnet.fa.server.policyOptimization.SrcPort;
import com.adventnet.fa.server.policyOptimization.ValueComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class Grouper {
    LinkedHashMap<String, DestinationIP> srcPort1 = new LinkedHashMap();
    LinkedHashMap<String, DestinationIP> srcPort2 = new LinkedHashMap();
    LinkedHashMap<String, DestinationIP> grpSrcPort = new LinkedHashMap();
    LinkedHashMap<String, DestPort> dest1 = new LinkedHashMap();
    LinkedHashMap<String, DestPort> dest2 = new LinkedHashMap();
    LinkedHashMap<String, DestPort> grpDest = new LinkedHashMap();
    LinkedHashMap<String, ArrayList> destPort1 = new LinkedHashMap();
    LinkedHashMap<String, ArrayList> destPort2 = new LinkedHashMap();
    LinkedHashMap<String, ArrayList> grpDestPort = new LinkedHashMap();
    LinkedHashMap<String, ArrayList> destPortMap = null;
    LinkedHashMap<String, DestPort> destIpMap = null;
    LinkedHashMap<String, DestinationIP> srcPortMap = null;
    LinkedHashMap<String, SrcPort> srcIpMap = null;
    LinkedHashMap sortingResult = new LinkedHashMap();
    static ThreadLocal<Grouper> grouperStore = new ThreadLocal<Grouper>(){

        @Override
        protected synchronized Grouper initialValue() {
            return new Grouper();
        }
    };

    void clearAll() {
        this.clearSrcPort();
        this.clearDestIp();
        this.clearDestPort();
    }

    void clearSrcPort() {
        this.srcPort1.clear();
        this.srcPort2.clear();
        this.grpSrcPort.clear();
    }

    void clearDestIp() {
        this.dest1.clear();
        this.dest2.clear();
        this.grpDest.clear();
    }

    void clearDestPort() {
        this.destPort1.clear();
        this.destPort2.clear();
        this.grpDestPort.clear();
    }

    Grouper() {
        this.destPortMap = new LinkedHashMap();
        this.destIpMap = new LinkedHashMap();
        this.srcPortMap = new LinkedHashMap();
        this.srcIpMap = new LinkedHashMap();
    }

    public LinkedHashMap<String, ArrayList> groupingDestPort(LinkedHashMap<String, ArrayList> map) {
        if (map.containsKey("all")) {
            ArrayList a = map.get("all");
            map.clear();
            map.put("all", a);
            return map;
        }
        this.destPortMap.clear();
        this.destPortMap.putAll(map);
        this.destPortMap = this.Sort(this.destPortMap);
        Iterator<Map.Entry<String, ArrayList>> i = this.destPortMap.entrySet().iterator();
        Map.Entry<String, ArrayList> e = i.next();
        String key1 = e.getKey();
        ArrayList<String> val1 = e.getValue();
        map.clear();
        map.put(key1, val1);
        while (i.hasNext()) {
            Map.Entry<String, ArrayList> d = i.next();
            String key2 = d.getKey();
            ArrayList val2 = d.getValue();
            if (this.canGroupPortValues(key1, key2).booleanValue()) {
                ArrayList<String> tempval = this.getUpdateRules(val1, val2);
                String tempkey = this.groupPort(key1, key2);
                map.remove(key1);
                map.put(tempkey, tempval);
                key1 = tempkey;
                val1 = tempval;
                continue;
            }
            map.put(key2, val2);
            key1 = key2;
            val1 = val2;
        }
        return map;
    }

    public LinkedHashMap<String, DestPort> groupingDestIp(LinkedHashMap<String, DestPort> map) {
        this.destIpMap.clear();
        this.destIpMap.putAll(map);
        this.destIpMap = this.Sort(this.destIpMap);
        Iterator<Map.Entry<String, DestPort>> i = this.destIpMap.entrySet().iterator();
        Map.Entry<String, DestPort> e = i.next();
        String key1 = e.getKey();
        DestPort val1 = e.getValue();
        map.clear();
        map.put((String)key1, (DestPort)val1);
        while (i.hasNext()) {
            Map.Entry<String, DestPort> d = i.next();
            String key2 = d.getKey();
            DestPort val2 = d.getValue();
            String ipCheck = this.canGroupIP(key1, key2);
            if (ipCheck != null && this.canGroupDestPort(val1, val2)) {
                String tempkey = this.groupPort(key1, key2);
                if (this.destPort1.isEmpty() && this.destPort2.isEmpty()) {
                    map.remove(key1);
                    map.put(tempkey, new DestPort(this.grpDestPort));
                } else {
                    if (!this.destPort1.isEmpty()) {
                        map.put(key1, new DestPort(this.destPort1));
                    } else {
                        map.remove(key1);
                    }
                    if (!this.destPort2.isEmpty()) {
                        map.put(key2, new DestPort(this.destPort2));
                    } else {
                        map.remove(key2);
                    }
                    if (map.containsKey(tempkey)) {
                        LinkedHashMap<String, ArrayList> modify = ((DestPort)map.get((Object)tempkey)).destPortMap;
                        modify.putAll(this.grpDestPort);
                        map.put(tempkey, new DestPort(modify));
                    } else {
                        map.put(tempkey, new DestPort(this.grpDestPort));
                    }
                }
                key1 = tempkey;
                val1 = new DestPort(this.grpDestPort);
                continue;
            }
            map.put(key2, val2);
            key1 = key2;
            val1 = val2;
        }
        map = this.Sort(map);
        this.clearAll();
        return map;
    }

    public LinkedHashMap<String, DestinationIP> groupingSrcPort(LinkedHashMap<String, DestinationIP> map) {
        this.srcPortMap.clear();
        this.srcPortMap.putAll(map);
        this.srcPortMap = this.Sort(this.srcPortMap);
        Iterator<Map.Entry<String, DestinationIP>> i = this.srcPortMap.entrySet().iterator();
        Map.Entry<String, DestinationIP> e = i.next();
        String key1 = e.getKey();
        DestinationIP val1 = e.getValue();
        map.clear();
        map.put((String)key1, (DestinationIP)val1);
        while (i.hasNext()) {
            Map.Entry<String, DestinationIP> d = i.next();
            String key2 = d.getKey();
            DestinationIP val2 = d.getValue();
            String ipCheck = this.canGroupIP(key1, key2);
            if (this.canGroupPortValues(key1, key2).booleanValue() && this.canGroupDestIp(val1, val2)) {
                String tempkey = this.groupIp(key1, key2);
                if (this.dest1.isEmpty() && this.dest2.isEmpty()) {
                    map.remove(key1);
                    map.put(tempkey, new DestinationIP(this.grpDest));
                } else {
                    if (!this.dest1.isEmpty()) {
                        map.put(key1, new DestinationIP(this.dest1));
                    } else {
                        map.remove(key1);
                    }
                    if (!this.dest2.isEmpty()) {
                        map.put(key2, new DestinationIP(this.dest2));
                    } else {
                        map.remove(key2);
                    }
                    if (map.containsKey(tempkey)) {
                        LinkedHashMap<String, DestPort> modify = ((DestinationIP)map.get((Object)tempkey)).destMap;
                        modify.putAll(this.grpDest);
                        map.put(tempkey, new DestinationIP(modify));
                    } else {
                        map.put(tempkey, new DestinationIP(this.grpDest));
                    }
                }
                key1 = tempkey;
                val1 = new DestinationIP(this.grpDest);
                continue;
            }
            map.put(key2, val2);
            key1 = key2;
            val1 = val2;
        }
        map = this.Sort(map);
        this.clearAll();
        return map;
    }

    public LinkedHashMap<String, SrcPort> groupingSrcIp(LinkedHashMap<String, SrcPort> map) {
        this.srcIpMap.clear();
        this.srcIpMap.putAll(map);
        this.srcIpMap = this.Sort(this.srcIpMap);
        Iterator<Map.Entry<String, SrcPort>> i = this.srcIpMap.entrySet().iterator();
        Map.Entry<String, SrcPort> e = i.next();
        String key1 = e.getKey();
        SrcPort val1 = e.getValue();
        map.clear();
        map.put((String)key1, (SrcPort)val1);
        while (i.hasNext()) {
            Map.Entry<String, SrcPort> d = i.next();
            String key2 = d.getKey();
            SrcPort val2 = d.getValue();
            String ipCheck = this.canGroupIP(key1, key2);
            if (ipCheck != null && this.canGroupSrcPort(val1, val2)) {
                String tempkey = this.groupIp(key1, key2);
                if (this.srcPort1.isEmpty() && this.srcPort2.isEmpty()) {
                    map.remove(key1);
                    map.put(tempkey, new SrcPort(this.grpSrcPort));
                } else {
                    if (!this.srcPort1.isEmpty()) {
                        map.put(key1, new SrcPort(this.srcPort1));
                    } else {
                        map.remove(key1);
                    }
                    if (!this.srcPort2.isEmpty()) {
                        map.put(key2, new SrcPort(this.srcPort2));
                    } else {
                        map.remove(key2);
                    }
                    if (map.containsKey(tempkey)) {
                        LinkedHashMap<String, DestinationIP> modify = ((SrcPort)map.get((Object)tempkey)).srcPortMap;
                        modify.putAll(this.grpSrcPort);
                        map.put(tempkey, new SrcPort(modify));
                    } else {
                        map.put(tempkey, new SrcPort(this.grpSrcPort));
                    }
                }
                key1 = tempkey;
                val1 = new SrcPort(this.grpSrcPort);
                continue;
            }
            map.put(key2, val2);
            key1 = key2;
            val1 = val2;
        }
        map = this.Sort(map);
        this.clearAll();
        return map;
    }

    boolean canGroupSrcPort(SrcPort val1, SrcPort val2) {
        this.clearSrcPort();
        this.srcPort1.putAll(val1.srcPortMap);
        this.srcPort2.putAll(val2.srcPortMap);
        this.srcPort1 = this.Sort(this.srcPort1);
        this.srcPort2 = this.Sort(this.srcPort2);
        for (String h1 : val1.srcPortMap.keySet()) {
            for (String h2 : val2.srcPortMap.keySet()) {
                if (!this.isEqual(h1.toString(), h2.toString()) || !this.canGroupDestIp(val1.srcPortMap.get(h1.toString()), val2.srcPortMap.get(h2.toString()))) continue;
                if (this.dest1.isEmpty() && this.dest2.isEmpty()) {
                    this.grpSrcPort.put(h1.toString(), new DestinationIP(this.grpDest));
                    this.srcPort1.remove(h1);
                    this.srcPort2.remove(h2);
                    continue;
                }
                this.grpSrcPort.put(h1.toString(), new DestinationIP(this.grpDest));
                if (this.dest1.isEmpty()) {
                    this.srcPort1.remove(h1);
                } else {
                    this.srcPort1.put(h1.toString(), new DestinationIP(this.dest1));
                }
                if (this.dest2.isEmpty()) {
                    this.srcPort2.remove(h2);
                    continue;
                }
                this.srcPort2.put(h2.toString(), new DestinationIP(this.dest2));
            }
        }
        return !this.grpSrcPort.isEmpty();
    }

    boolean canGroupDestIp(DestinationIP val1, DestinationIP val2) {
        this.clearDestIp();
        this.dest1.putAll(val1.destMap);
        this.dest2.putAll(val2.destMap);
        this.dest1 = this.Sort(this.dest1);
        this.dest2 = this.Sort(this.dest2);
        for (String h1 : val1.destMap.keySet()) {
            for (String h2 : val2.destMap.keySet()) {
                if (!this.isEqual(h1.toString(), h2.toString()) || !this.canGroupDestPort(val1.destMap.get(h1.toString()), val2.destMap.get(h2.toString()))) continue;
                if (this.destPort1.isEmpty() && this.destPort2.isEmpty()) {
                    this.grpDest.put(h1.toString(), new DestPort(this.grpDestPort));
                    this.dest1.remove(h1);
                    this.dest2.remove(h2);
                    continue;
                }
                this.grpDest.put(h1.toString(), new DestPort(this.grpDestPort));
                if (this.destPort1.isEmpty()) {
                    this.dest1.remove(h1);
                } else {
                    this.dest1.put(h1.toString(), new DestPort(this.destPort1));
                }
                if (this.destPort2.isEmpty()) {
                    this.dest2.remove(h2);
                    continue;
                }
                this.dest2.put(h2.toString(), new DestPort(this.destPort2));
            }
        }
        return !this.grpDest.isEmpty();
    }

    boolean canGroupDestPort(DestPort val1, DestPort val2) {
        this.clearDestPort();
        this.destPort1.putAll(val1.destPortMap);
        this.destPort2.putAll(val2.destPortMap);
        this.destPort1 = this.Sort(this.destPort1);
        this.destPort2 = this.Sort(this.destPort2);
        for (String one : val1.destPortMap.keySet()) {
            for (String two : val2.destPortMap.keySet()) {
                if (!this.isEqual(one.toString(), two.toString())) continue;
                ArrayList<String> update = this.getUpdateRules(this.destPort1.get(one), this.destPort2.get(one));
                this.grpDestPort.put(one.toString(), update);
                this.destPort1.remove(one);
                this.destPort2.remove(two);
            }
        }
        return !this.grpDestPort.isEmpty();
    }

    boolean isEqual(String ip1, String ip2) {
        return ip1.equals(ip2);
    }

    private String canGroupIP(String ip1, String ip2) {
        if (ip1.equals("all") || ip2.equals("all")) {
            return "3";
        }
        long min1 = Long.valueOf(ip1.split("-")[0]);
        long max1 = Long.valueOf(ip1.split("-")[1]);
        long min2 = Long.valueOf(ip2.split("-")[0]);
        long max2 = Long.valueOf(ip2.split("-")[1]);
        if (max1 + 1L >= min2 && min1 <= max2 || max2 + 1L >= min1 && min2 <= max1) {
            return "1";
        }
        return this.canGroupRule(min1 - 1L, min2 - 1L, max1 + 1L, max2 + 1L);
    }

    private String canGroupRule(long min1, long min2, long max1, long max2) {
        if (max1 + 1L >= min2 && min1 <= max2 || max2 + 1L >= min1 && min2 <= max1) {
            String ip1 = String.valueOf(min1) + "-" + String.valueOf(max1);
            String ip2 = String.valueOf(min2) + "-" + String.valueOf(max2);
            String groupIp = this.groupIp(ip1, ip2);
            long count = Long.valueOf(groupIp.split("-")[1]) - Long.valueOf(groupIp.split("-")[0]);
        }
        return null;
    }

    String groupIp(String ip1, String ip2) {
        return this.groupValues(ip1, ip2);
    }

    String groupValues(String val1, String val2) {
        if (val1.equals("all") || val2.equals("all")) {
            return "all";
        }
        String min = Long.valueOf(val1.split("-")[0]) < Long.valueOf(val2.split("-")[0]) ? val1.split("-")[0] : val2.split("-")[0];
        String max = Long.valueOf(val1.split("-")[1]) > Long.valueOf(val2.split("-")[1]) ? val1.split("-")[1] : val2.split("-")[1];
        return min + "-" + max;
    }

    String groupPort(String key1, String key2) {
        String grpPort = this.groupValues(key1, key2);
        if (grpPort.equals("0-65535")) {
            return "all";
        }
        return grpPort;
    }

    public ArrayList<String> getUpdateRules(ArrayList<String> list1, ArrayList<String> list2) {
        ArrayList<String> update = new ArrayList<String>();
        TreeMap<String, String> groupList = this.groupRuleStatus(list1);
        groupList.putAll(this.groupRuleStatus(list2));
        Iterator<Map.Entry<String, String>> itr = groupList.entrySet().iterator();
        Map.Entry<String, String> entry = itr.next();
        String groupedRule = entry.getKey();
        String groupedStatus = entry.getValue();
        while (itr.hasNext()) {
            entry = itr.next();
            groupedRule = groupedRule + "," + entry.getKey();
            groupedStatus = groupedStatus + "," + entry.getValue();
        }
        String rule1 = this.groupRule(list1.get(0));
        String rule2 = this.groupRule(list2.get(0));
        update.add(groupedRule);
        update.add(groupedStatus);
        Repository repo = Repository.getInstance();
        if (repo.repoGroupingMapStore.get().containsKey(rule1)) {
            repo.repoGroupingMapStore.get().remove(rule1);
        } else {
            repo.repoGroupingMapStore.get().remove(rule2);
        }
        repo.repoGroupingMapStore.get().put(groupedRule, groupedStatus);
        return update;
    }

    TreeMap<String, String> groupRuleStatus(ArrayList<String> list) {
        TreeMap<String, String> temp = new TreeMap<String, String>();
        String rule = list.get(0);
        String status = list.get(1);
        if (rule.contains(",")) {
            String[] rules = rule.split(",");
            String[] flags = status.split(",");
            for (int i = 0; i < rules.length; ++i) {
                temp.put(rules[i], flags[i]);
            }
        } else {
            temp.put(rule, status);
        }
        return temp;
    }

    Boolean canGroupPortValues(String key1, String key2) {
        if (key1.equals("all") || key2.equals("all")) {
            return true;
        }
        int min1 = Integer.valueOf(key1.split("-")[0]);
        int max1 = Integer.valueOf(key1.split("-")[1]);
        int min2 = Integer.valueOf(key2.split("-")[0]);
        int max2 = Integer.valueOf(key2.split("-")[1]);
        return max1 + 1 >= min2 && min1 <= max2 || max2 + 1 >= min1 && min2 <= max1;
    }

    String groupRule(String rule) {
        TreeSet<String> ruleSet = new TreeSet<String>();
        if (rule.contains(",")) {
            String[] rules = rule.split(",");
            ruleSet.addAll(Arrays.asList(rules));
            Object[] map = ruleSet.toArray();
            rule = map[0].toString();
            for (int i = 1; i < map.length; ++i) {
                rule = rule + "," + map[i].toString();
            }
        }
        return rule;
    }

    LinkedHashMap Sort(LinkedHashMap map) {
        if (map.containsKey("all")) {
            this.sortingResult.put("all", map.get("all"));
            map.remove("all");
        }
        ValueComparator bvc = new ValueComparator(map);
        TreeMap sorted_map = new TreeMap(bvc);
        sorted_map.putAll(map);
        this.sortingResult.putAll(sorted_map);
        map.clear();
        map.putAll(this.sortingResult);
        this.sortingResult.clear();
        return map;
    }
}

