/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.policyOptimization;

import com.adventnet.db.persistence.SequenceGenerator;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.policyOptimization.Anomaly;
import com.adventnet.fa.server.policyOptimization.Grouper;
import com.adventnet.fa.server.policyOptimization.Protocol;
import com.adventnet.fa.server.policyOptimization.Repository;
import com.adventnet.fa.server.policyOptimization.SourceIP;
import com.adventnet.fa.server.policyOptimization.UniqueRule;
import com.adventnet.fa.server.policyOptimizationHelper.Helper;
import com.adventnet.fa.server.policyOptimizationHelper.JSONConstructor;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.internal.SequenceGeneratorRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Loader {
    Long rID = null;
    public String deviceType = null;
    private JSONConstructor jsonConstructor = null;
    private Helper helper = null;
    private Repository repo = null;
    private Anomaly anomaly = null;
    SequenceGenerator gen = null;
    public LinkedHashMap<String, String> ruleIDMap = null;
    LinkedHashMap<String, ArrayList<LinkedHashMap>> wholeDB = null;
    TreeSet<String> anomalySet = null;
    private static final Logger LOGGER = Logger.getLogger(Loader.class.getName());
    DataObject dObj = null;

    public void clearMemory() {
        this.repo = null;
        this.anomaly = null;
        Anomaly.anomalyStore.remove();
        Grouper.grouperStore.remove();
        this.helper = null;
        this.jsonConstructor = null;
        this.wholeDB = null;
    }

    public void initValues() {
        this.helper = Helper.getInstance();
        this.repo = Repository.getInstance();
        this.anomaly = Anomaly.anomalyStore.get();
        this.jsonConstructor = JSONConstructor.getInstance();
        this.wholeDB = new LinkedHashMap();
        this.ruleIDMap = new LinkedHashMap();
        this.anomalySet = new TreeSet();
    }

    public Loader() {
        this.initValues();
    }

    public void loadRules(Long rID, String deviceType) throws DataAccessException {
        this.anomalySet.clear();
        this.ruleIDMap.clear();
        this.gen = SequenceGeneratorRepository.get((String)"AnomalyDetails.AnomalyPK");
        this.rID = rID;
        this.deviceType = deviceType;
        LOGGER.log(Level.INFO, "@@@Loader:::Connection DB to get data!!!");
        DataObject ruleObj = null;
        ruleObj = deviceType.equals("Cisco") ? this.getCiscoRuleDetailsDO() : this.getRuleDetailsDO();
        if (ruleObj == null || ruleObj.isEmpty()) {
            LOGGER.log(Level.WARNING, "@@@Loader:::Unable to load Priorities from DB!!! ");
            return;
        }
        Iterator ruleItr = ruleObj.getRows("RuleDetails");
        Row ruleRow = (Row)ruleItr.next();
        String[] values = this.helper.convertFormat(ruleRow, this);
        LOGGER.log(Level.INFO, "@@@Loader::: Loading data from DB is started!!! ");
        String[] cloneValues = (String[])values.clone();
        if (values[4].contains("&&")) {
            this.repo.splitInitial(values[4].split("&&"), values);
        } else {
            values = this.helper.extractService(values);
            this.repo.repoDBStore.get().put(values[4], new SourceIP(values));
        }
        values = cloneValues;
        this.repo.repoNonAnomalyStore.get().put(values[0], new UniqueRule(values));
        String lastRule = values[0];
        boolean isAnomalyFlag = false;
        String change = values[1];
        while (ruleItr.hasNext()) {
            ruleRow = (Row)ruleItr.next();
            values = this.helper.convertFormat(ruleRow, this);
            if (!change.equals(values[1])) {
                this.clearDB(change, lastRule);
                change = values[1];
            }
            cloneValues = (String[])values.clone();
            isAnomalyFlag = this.isAnomaly(values);
            if (!isAnomalyFlag) {
                values = (String[])cloneValues.clone();
                Protocol.updateProtocol(values, this.repo.repoDBStore.get());
                if (!this.repo.repoNonAnomalyStore.get().containsKey(values[0])) {
                    values = cloneValues;
                    this.repo.repoNonAnomalyStore.get().put(values[0], new UniqueRule(values));
                }
            }
            lastRule = values[0];
        }
        this.clearDB(change, lastRule);
        this.populateIntoDB(this.wholeDB);
        LOGGER.log(Level.INFO, "BEGIN OF JSON CONSTRUCTION");
        this.constructJSON();
        LOGGER.log(Level.INFO, "END OF JSON CONSTRUCTION");
        this.clearMemory();
    }

    private boolean isAnomaly(String[] values) {
        boolean flag = false;
        String[] cloneValues = (String[])values.clone();
        String isAnomaly = null;
        boolean isCorrelated = false;
        if (values[4].contains("&&")) {
            String[] arr$ = values[4].split("&&");
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String service;
                values[4] = service = arr$[i$];
                values = this.helper.extractService(values);
                cloneValues = (String[])values.clone();
                isAnomaly = this.anomaly.isAnomaly(values, this.repo);
                isAnomaly = this.extractAnomaly(isAnomaly, cloneValues);
                values[5] = null;
                if (isAnomaly == null) {
                    isCorrelated = true;
                    continue;
                }
                if (!"no".equals(isAnomaly)) continue;
                flag = true;
                isCorrelated = true;
            }
            if (flag && this.repo.repoAnomalyStore.get().containsKey(values[0])) {
                String value = this.repo.repoAnomalyStore.get().get(values[0]);
                String newKey = "";
                String newValue = "";
                for (String diffGen : value.split(" and ")) {
                    String ruleID = diffGen.split("@")[0];
                    newKey = ruleID + "," + values[0];
                    if (this.repo.repoGroupingMapStore.get().containsKey(newKey)) continue;
                    int len = newKey.split(",").length;
                    for (int i = 0; i < len; ++i) {
                        newValue = newValue + "," + values[7];
                    }
                    newValue = newValue.substring(1, newValue.length());
                    this.repo.repoGroupingMapStore.get().put(newKey, newValue);
                }
                this.repo.repoAnomalyStore.get().remove(values[0]);
            }
            return !isCorrelated;
        }
        values = this.helper.extractService(values);
        cloneValues = (String[])values.clone();
        isAnomaly = this.anomaly.isAnomaly(values, this.repo);
        if ((isAnomaly = this.extractAnomaly(isAnomaly, cloneValues)) == null) {
            return false;
        }
        return !"no".equals(isAnomaly);
    }

    private String extractAnomaly(String isAnomaly, String[] values) {
        String temp;
        if (isAnomaly == null) {
            return null;
        }
        String result = null;
        if ("yes".equals(isAnomaly)) {
            temp = this.anomaly.isExactEntireRule(this.anomaly.remList, values, 1);
            if (temp != null) {
                result = "yes";
                this.repo.repoAnomalyStore.get().put(values[0], temp);
                this.anomalySet.add(values[0]);
            } else {
                isAnomaly = "no";
            }
        }
        if ("no".equals(isAnomaly)) {
            if (!this.anomaly.genList.isEmpty() && (temp = this.anomaly.isExactEntireRule(this.anomaly.genList, values, 2)) != null) {
                result = "no";
                String genAlone = "";
                if (temp.contains("Reverse")) {
                    for (String diffGen : temp.split(" and ")) {
                        String[] splitAnomaly = diffGen.split("@");
                        if (splitAnomaly[1].contains("Reverse")) {
                            for (String rule : splitAnomaly[0].split(",")) {
                                String currentValue = values[0] + "@Redundancy";
                                if (this.repo.repoGenAnomalyStore.get().containsKey(rule)) {
                                    String oldVal = this.repo.repoGenAnomalyStore.get().get(rule);
                                    if (!oldVal.contains(currentValue)) {
                                        oldVal = oldVal + " and " + currentValue;
                                        this.repo.repoGenAnomalyStore.get().put(rule, oldVal);
                                    }
                                } else {
                                    this.repo.repoGenAnomalyStore.get().put(rule, currentValue);
                                }
                                this.anomalySet.add(rule.trim());
                            }
                            continue;
                        }
                        genAlone = genAlone + " and " + diffGen;
                    }
                } else {
                    this.repo.repoGenAnomalyStore.get().put(values[0], temp);
                    this.anomalySet.add(values[0]);
                }
                if (genAlone.contains("and")) {
                    genAlone = genAlone.substring(5, genAlone.length());
                    this.repo.repoGenAnomalyStore.get().put(values[0], genAlone);
                    this.anomalySet.add(values[0]);
                }
            }
            if (!this.anomaly.corList.isEmpty() && (temp = this.anomaly.isExactRule(this.anomaly.corList, values, 3)) != null) {
                result = "no";
                this.repo.repoCorAnomalyStore.get().put(values[0], temp);
                this.anomalySet.add(values[0]);
            }
        }
        this.anomaly.clearMemory();
        return result;
    }

    private void clearDB(String intface, String lastRule) {
        if (this.repo.repoNonAnomalyStore.get().containsKey(lastRule) && this.isLastRule(this.repo.repoNonAnomalyStore.get().get(lastRule))) {
            this.repo.repoGenAnomalyStore.get().remove(lastRule);
        }
        ArrayList temp = new ArrayList();
        temp.add(new LinkedHashMap(this.repo.repoAnomalyStore.get()));
        temp.add(new LinkedHashMap(this.repo.repoGenAnomalyStore.get()));
        temp.add(new LinkedHashMap(this.repo.repoCorAnomalyStore.get()));
        this.finalGroupingProcess(this.repo);
        temp.add(new LinkedHashMap(this.repo.repoGroupingMapStore.get()));
        this.wholeDB.put(intface, temp);
        this.repo.clearMemory();
        this.anomalySet.clear();
    }

    public void populateIntoDB(LinkedHashMap<String, ArrayList<LinkedHashMap>> wholeDB) {
        Set<String> keySet = wholeDB.keySet();
        try {
            this.dObj = DataAccess.constructDataObject();
            for (String key : keySet) {
                ArrayList<LinkedHashMap> temp = wholeDB.get(key);
                this.populateAnomaly(temp.get(0));
                this.populateAnomaly(temp.get(1));
                this.populateAnomaly(temp.get(2));
                this.populateGroupingSet(temp.get(3));
            }
            this.dObj = DataAccess.add((DataObject)this.dObj);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public void populateAnomalyRuleDetails(Object pk, String ruleset, String rule) {
        for (String key : ruleset.split(",")) {
            Row anomalyRuleRow = new Row("AnomalyRuleDetails");
            anomalyRuleRow.set("AnomalyPK", pk);
            anomalyRuleRow.set("RULEID", (Object)new Long(key));
            try {
                this.dObj.addRow(anomalyRuleRow);
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        }
        Row anomalyRuleRow = new Row("AnomalyRuleDetails");
        anomalyRuleRow.set("AnomalyPK", pk);
        anomalyRuleRow.set("RULEID", (Object)new Long(rule));
        try {
            this.dObj.addRow(anomalyRuleRow);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public void constructJSON() {
        this.jsonConstructor.createJSONConstructionTask(this.rID, this.deviceType);
    }

    public void populateAnomaly(LinkedHashMap<String, String> anomalySet) {
        Set<String> keySet = anomalySet.keySet();
        String[] value = new String[2];
        Object pk = null;
        for (String key : keySet) {
            for (String split : anomalySet.get(key).split(" and ")) {
                value = split.split("@");
                if (value[0].equals("")) continue;
                pk = this.gen.nextValue();
                Row anomalyRow = new Row("AnomalyDetails");
                anomalyRow.set("AnomalyPK", pk);
                anomalyRow.set("RID", (Object)this.rID);
                anomalyRow.set("RULEID", (Object)new Long(key));
                anomalyRow.set("ANOMALYTYPE", (Object)value[1]);
                anomalyRow.set("ASSOCIATEDRULES", (Object)this.anomalyDesc(key, value[1], this.getRulename(value[0])));
                anomalyRow.set("RULESET", (Object)value[0]);
                try {
                    this.dObj.addRow(anomalyRow);
                }
                catch (DataAccessException e) {
                    e.printStackTrace();
                }
                this.populateAnomalyRuleDetails(pk, value[0], key);
            }
        }
    }

    public void populateGroupingSet(LinkedHashMap<String, String> groupingSet) {
        Set<String> keySet = groupingSet.keySet();
        String ruleID = "";
        int len = 0;
        Object pk = null;
        for (String key : keySet) {
            key = this.getReqOrder(key);
            len = key.split(",").length;
            ruleID = key.split(",")[len - 1];
            pk = this.gen.nextValue();
            Row anomalyRow = new Row("AnomalyDetails");
            anomalyRow.set("AnomalyPK", pk);
            anomalyRow.set("RID", (Object)this.rID);
            anomalyRow.set("RULEID", (Object)new Long(ruleID));
            anomalyRow.set("ANOMALYTYPE", (Object)"Grouping");
            anomalyRow.set("ASSOCIATEDRULES", (Object)this.grpDesc(this.getRulename(key), groupingSet.get(key)));
            key = this.removeLastKey(ruleID, key);
            anomalyRow.set("RULESET", (Object)key);
            try {
                this.dObj.addRow(anomalyRow);
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
            this.populateAnomalyRuleDetails(pk, key, ruleID);
        }
    }

    private String getReqOrder(String key) {
        TreeSet<String> tree = new TreeSet<String>(Arrays.asList(key.split(",")));
        key = "";
        for (String t : tree) {
            key = key + "," + t;
        }
        return key.substring(1, key.length());
    }

    private String removeLastKey(String ruleID, String key) {
        if (!ruleID.equals(key)) {
            ruleID = "," + ruleID;
            key = key.replace(ruleID, "");
        }
        return key;
    }

    public String anomalyDesc(String ruleid, String type, String ruleName) {
        String res = "";
        ruleid = ruleid.trim();
        res = type.equals("Redundancy") ? "Rule " + this.getName(ruleid) + " is redundant because of rule " + ruleName : (type.equals("Shadow") ? "Rule " + this.getName(ruleid) + " is shadowed by rule " + ruleName : (type.equals("Generalization") ? "Rule " + this.getName(ruleid) + " is generalization of rule " + ruleName : "Rule " + this.getName(ruleid) + " is correlated to rule " + ruleName));
        return res;
    }

    public String getName(String r) {
        return this.ruleIDMap.get(r);
    }

    public String getRulename(String rule) {
        TreeSet<String> rules = new TreeSet<String>();
        if (rule.contains(",")) {
            for (String r : rule.split(",")) {
                rules.add(this.getName(r));
            }
        } else {
            rules.add(this.getName(rule));
        }
        rule = this.helper.join(rules, ",");
        return rule;
    }

    public String grpDesc(String ruleName, String grpType) {
        ruleName = "Rule " + ruleName + " can be grouped by grouping " + grpType;
        return ruleName;
    }

    public void printLOG(String[] values) {
        LOGGER.log(Level.INFO, "{0}\t{1}\t{2}\t{3}\t{4}\t{5}\n", new Object[]{values[0], values[1], values[2], values[3], values[4], values[5]});
    }

    private void finalGroupingProcess(Repository repo) {
        LinkedHashMap map = new LinkedHashMap(repo.repoGroupingMapStore.get());
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Set keySet = map.keySet();
        for (String key : keySet) {
            this.updateGroupingMap(key, (String)map.get(key), repo, result);
        }
        repo.repoGroupingMapStore.get().clear();
        repo.repoGroupingMapStore.get().putAll(result);
    }

    private void updateGroupingMap(String rules, String actions, Repository repo, LinkedHashMap<String, String> result) {
        String[] arr1;
        if (this.isUnEvenCase(rules)) {
            repo.repoGroupingMapStore.get().remove(rules);
            return;
        }
        String[] arr2 = arr1 = rules.split(",");
        String[] action = actions.split(",");
        int len = arr1.length;
        TreeSet<String> diffSrcList = new TreeSet<String>();
        TreeSet<String> diffDstList = new TreeSet<String>();
        TreeSet<String> diffPortList = new TreeSet<String>();
        int type = 0;
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                if (i >= j || !action[i].equals(action[j])) continue;
                type = this.getDiffField(repo.repoNonAnomalyStore.get().get(arr1[i]), repo.repoNonAnomalyStore.get().get(arr2[j]));
                if (type == 1) {
                    diffSrcList.add(arr1[i]);
                    diffSrcList.add(arr1[j]);
                    continue;
                }
                if (type == 2) {
                    diffDstList.add(arr1[i]);
                    diffDstList.add(arr1[j]);
                    continue;
                }
                if (type != 3) continue;
                diffPortList.add(arr1[i]);
                diffPortList.add(arr1[j]);
            }
        }
        if (!diffSrcList.isEmpty()) {
            result.put(this.helper.join(diffSrcList, ","), "source ips");
        }
        if (!diffDstList.isEmpty()) {
            result.put(this.helper.join(diffDstList, ","), "destination ips");
        }
        if (!diffPortList.isEmpty()) {
            result.put(this.helper.join(diffPortList, ","), "services");
        }
        repo.repoGroupingMapStore.get().remove(rules);
    }

    private int getDiffField(UniqueRule rule1, UniqueRule rule2) {
        int result = 0;
        int count = 0;
        if (rule1.src_ip.length() != rule2.src_ip.length() || !rule1.src_ip.equals(rule2.src_ip)) {
            ++count;
            result = 1;
        }
        if (rule1.dest_ip.length() != rule2.dest_ip.length() || !rule1.dest_ip.equals(rule2.dest_ip)) {
            ++count;
            result = 2;
        }
        if (rule1.portInfo.length() != rule2.portInfo.length() || !rule1.portInfo.equals(rule2.portInfo)) {
            ++count;
            result = 3;
        }
        if (count > 1) {
            return 0;
        }
        return result;
    }

    boolean isUnEvenCase(String ruleid) {
        for (String rule : ruleid.split(",")) {
            if (!this.anomalySet.contains(rule)) continue;
            return true;
        }
        return false;
    }

    private boolean isLastRule(UniqueRule rule) {
        return rule.src_ip.equals("all") && rule.dest_ip.equals("all") && rule.service.get(0).get(0).equals("all") && rule.service.get(0).get(1).equals("all") && rule.service.get(0).get(2).equals("all");
    }

    private DataObject getCiscoRuleDetailsDO() {
        SelectQueryImpl dbQuery = new SelectQueryImpl(Table.getTable((String)"RuleDetails"));
        dbQuery.addSelectColumn(new Column("RuleDetails", "RULEID"));
        dbQuery.addSelectColumn(new Column("RuleDetails", "RULENAME"));
        dbQuery.addSelectColumn(new Column("RuleDetails", "POLICYID"));
        dbQuery.addSelectColumn(new Column("RuleDetails", "GROUPED_SRCID"));
        dbQuery.addSelectColumn(new Column("RuleDetails", "GROUPED_DSTID"));
        dbQuery.addSelectColumn(new Column("RuleDetails", "GROUPED_PORTS"));
        dbQuery.addSelectColumn(new Column("RuleDetails", "ACTION"));
        Criteria c1 = new Criteria(new Column("RuleDetails", "SRC_INT"), null, 1);
        Criteria c2 = c1.and(new Criteria(new Column("RuleDetails", "DST_INT"), null, 1));
        Criteria c3 = c2.and(new Criteria(new Column("RuleDetails", "RULE_STATUS"), (Object)"Yes", 0));
        Criteria c = c3.and(new Criteria(new Column("RuleDetails", "RID"), (Object)this.rID, 0));
        Criteria c4 = new Criteria(new Column("RuleDetails", "IS_UNRESOLVED_DATA"), (Object)Boolean.FALSE, 0);
        c = c4.and(c);
        dbQuery.setCriteria(c);
        dbQuery.addSortColumn(new SortColumn("RuleDetails", "POLICYID", true));
        dbQuery.addSortColumn(new SortColumn("RuleDetails", "RULEID", true));
        try {
            DataObject doo = DataAccess.get((SelectQuery)dbQuery);
            return doo;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    private DataObject getRuleDetailsDO() {
        SelectQueryImpl dbQuery = new SelectQueryImpl(Table.getTable((String)"RuleDetails"));
        dbQuery.addSelectColumn(new Column("RuleDetails", "RULEID"));
        dbQuery.addSelectColumn(new Column("RuleDetails", "RULENAME"));
        dbQuery.addSelectColumn(new Column("RuleDetails", "SRC_INT"));
        dbQuery.addSelectColumn(new Column("RuleDetails", "DST_INT"));
        dbQuery.addSelectColumn(new Column("RuleDetails", "GROUPED_SRCID"));
        dbQuery.addSelectColumn(new Column("RuleDetails", "GROUPED_DSTID"));
        dbQuery.addSelectColumn(new Column("RuleDetails", "GROUPED_PORTS"));
        dbQuery.addSelectColumn(new Column("RuleDetails", "ACTION"));
        Criteria c1 = new Criteria(new Column("RuleDetails", "SRC_INT"), null, 1);
        Criteria c2 = c1.and(new Criteria(new Column("RuleDetails", "DST_INT"), null, 1));
        Criteria c3 = c2.and(new Criteria(new Column("RuleDetails", "RULE_STATUS"), (Object)"Yes", 0));
        Criteria c = c3.and(new Criteria(new Column("RuleDetails", "RID"), (Object)this.rID, 0));
        Criteria c4 = new Criteria(new Column("RuleDetails", "IS_UNRESOLVED_DATA"), (Object)Boolean.FALSE, 0);
        c = c4.and(c);
        Criteria c6 = new Criteria(new Column("RuleDetails", "SRC_INT"), (Object)"Any", 1);
        Criteria c7 = c6.and(new Criteria(new Column("RuleDetails", "DST_INT"), (Object)"Any", 1));
        c = c7.and(c);
        dbQuery.setCriteria(c);
        dbQuery.addSortColumn(new SortColumn("RuleDetails", "SRC_INT", true));
        dbQuery.addSortColumn(new SortColumn("RuleDetails", "DST_INT", true));
        dbQuery.addSortColumn(new SortColumn("RuleDetails", "RULEID", true));
        try {
            DataObject doo = DataAccess.get((SelectQuery)dbQuery);
            return doo;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        try {
            TableDefinition td = MetaDataUtil.getTableDefinitionByName((String)"AnomalyDetails");
            SequenceGeneratorRepository.initGeneratorValues((TableDefinition)td);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}

