/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.policyOptimizationHelper;

import com.adventnet.fa.server.policyOptimizationHelper.AnomalyRuleWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnomalyRuleRepository {
    private static final Logger LOGGER = Logger.getLogger(AnomalyRuleRepository.class.getName());
    private LinkedHashMap writers = new LinkedHashMap();
    private static AnomalyRuleRepository repo;

    private AnomalyRuleRepository() {
    }

    public static synchronized AnomalyRuleRepository getInstance() {
        if (repo == null) {
            repo = new AnomalyRuleRepository();
        }
        return repo;
    }

    public synchronized AnomalyRuleWriter getWriter(String tableName) {
        AnomalyRuleWriter obj = (AnomalyRuleWriter)this.writers.get(tableName);
        if (obj == null) {
            obj = new AnomalyRuleWriter(tableName);
            this.writers.put(tableName, obj);
        }
        return obj;
    }

    public synchronized void flushWriters() {
        for (Map.Entry entry : this.writers.entrySet()) {
            AnomalyRuleWriter writer = (AnomalyRuleWriter)entry.getValue();
            writer.flush();
        }
    }

    public void shutdown() {
        for (Map.Entry entry : this.writers.entrySet()) {
            AnomalyRuleWriter writer = (AnomalyRuleWriter)entry.getValue();
            LOGGER.log(Level.INFO, "AnomalyRuleRepository ShutDown called fr {0} ", new Object[]{writer});
            writer.shutdown();
        }
    }
}

