/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.policyOptimizationHelper;

import com.adventnet.fa.server.policyOptimization.Loader;
import com.adventnet.persistence.Row;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Helper {
    static final String PATTERN = "([^:]+):(?:(dstPort)=([^#]+))?(#)?(?:(srcPort)=([^#]+))?";
    static final Pattern R = Pattern.compile("([^:]+):(?:(dstPort)=([^#]+))?(#)?(?:(srcPort)=([^#]+))?");
    private static Helper helper;

    public static synchronized Helper getInstance() {
        if (helper == null) {
            helper = new Helper();
        }
        return helper;
    }

    private Helper() {
    }

    public String[] extractService(String[] rule) {
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(rule));
        Matcher m = R.matcher(values.get(4));
        m.find();
        values.set(4, m.group(1));
        if (values.contains(null)) {
            values.set(5, m.group(3));
            values.set(6, m.group(6));
        } else {
            values.add(5, m.group(3));
            values.add(6, m.group(6));
        }
        String[] result = new String[values.size()];
        return values.toArray(result);
    }

    public ArrayList<String> serviceToArrayList(String service) {
        Matcher m = R.matcher(service);
        m.find();
        ArrayList<String> singleList = new ArrayList<String>();
        singleList.add(m.group(1));
        singleList.add(m.group(3));
        singleList.add(m.group(6));
        return singleList;
    }

    public String[] convertFormat(Row ruleRow, Loader load) {
        String[] values = new String[6];
        values[0] = ((Long)ruleRow.get("RULEID")).toString();
        values[1] = load.deviceType.equals("Cisco") ? ((Long)ruleRow.get("POLICYID")).toString() : this.replace((String)ruleRow.get("SRC_INT")) + "$" + this.replace((String)ruleRow.get("DST_INT"));
        values[2] = this.replace((String)ruleRow.get("GROUPED_SRCID"));
        values[3] = this.replace((String)ruleRow.get("GROUPED_DSTID"));
        values[4] = this.replace((String)ruleRow.get("GROUPED_PORTS"));
        values[4] = this.sortPort(values[4]);
        values[5] = this.replace((String)ruleRow.get("ACTION"));
        load.ruleIDMap.put(values[0], (String)ruleRow.get("RULENAME"));
        return values;
    }

    public String sortPort(String ports) {
        if (ports.contains("&&")) {
            TreeSet<String> portSet = new TreeSet<String>(Arrays.asList(ports.split("&&")));
            ports = "";
            for (String port : portSet) {
                ports = ports + "&&" + port;
            }
            ports = ports.substring(2, ports.length());
        }
        return ports;
    }

    public String[] convertFormat(String rule) {
        rule = this.replace(rule);
        String[] values = rule.split(";");
        return values;
    }

    String replace(String val) {
        val = val.replace("*", "all");
        val = val.replace("ALL", "all");
        val = val.replace("All", "all");
        val = val.replace("any", "all");
        val = val.replace("ANY", "all");
        val = val.replace("Any", "all");
        return val;
    }

    public String join(Set<?> set, String separator) {
        Iterator<?> itr = set.iterator();
        return this.join(itr, separator);
    }

    public String join(Iterator<?> iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return "";
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return first.toString();
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            Object obj;
            if (separator != null) {
                buf.append(separator);
            }
            if ((obj = iterator.next()) == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public String toGroupIPInstance(String value) {
        return new Helper().toGroupIP(value);
    }

    public ArrayList<ArrayList> toGroupServicesInstance(TreeSet<String> services) {
        ArrayList<ArrayList> resultSet = new ArrayList<ArrayList>();
        ArrayList<String> firstService = this.serviceToArrayList(services.first());
        String changeProtocol = firstService.get(0);
        StringBuilder srcPort = new StringBuilder();
        StringBuilder dstPort = new StringBuilder();
        for (String service : services) {
            ArrayList<String> singleService = this.serviceToArrayList(service);
            if (!changeProtocol.equals(singleService.get(0))) {
                String sourcePort = this.toGroupIPInstance(srcPort.substring(0, srcPort.length() - 1));
                String destinationPort = this.toGroupIPInstance(dstPort.substring(0, dstPort.length() - 1));
                ArrayList<String> groupedProtocol = new ArrayList<String>();
                groupedProtocol.add(changeProtocol);
                groupedProtocol.add(destinationPort);
                groupedProtocol.add(sourcePort);
                resultSet.add(groupedProtocol);
                changeProtocol = singleService.get(0);
            }
            dstPort.append(singleService.get(1));
            dstPort.append(",");
            srcPort.append(singleService.get(2));
            srcPort.append(",");
        }
        String sourcePort = this.toGroupIPInstance(srcPort.substring(0, srcPort.length() - 1));
        String destinationPort = this.toGroupIPInstance(dstPort.substring(0, dstPort.length() - 1));
        ArrayList<String> groupedProtocol = new ArrayList<String>();
        groupedProtocol.add(changeProtocol);
        groupedProtocol.add(destinationPort);
        groupedProtocol.add(sourcePort);
        resultSet.add(groupedProtocol);
        return resultSet;
    }

    public String toGroupIP(String value) {
        if (value == null) {
            return null;
        }
        String[] values = value.split(",");
        List<String> valsToProcess = Arrays.asList(values);
        TreeSet<String> tree = new TreeSet<String>(valsToProcess);
        if (tree.contains("all")) {
            tree.clear();
            return "all";
        }
        ArrayList<String> result = new ArrayList<String>(tree);
        Collections.sort(result, new SortComparator());
        result = this.groupingSet(result);
        StringBuilder sb = new StringBuilder();
        for (String s : result) {
            sb.append(s);
            sb.append(",");
        }
        String res = sb.substring(0, sb.length() - 1);
        return res;
    }

    public ArrayList<String> groupingSet(ArrayList<String> list) {
        Iterator<String> itr = list.iterator();
        String val1 = itr.next();
        ArrayList<String> result = new ArrayList<String>();
        result.add(val1);
        String[] set1 = new String[2];
        String[] set2 = new String[2];
        String min = "";
        String max = "";
        while (itr.hasNext()) {
            String val2 = itr.next();
            if (this.canGroup(val1, val2)) {
                result.remove(val1);
                set1 = val1.split("-");
                set2 = val2.split("-");
                min = Long.valueOf(set1[0]) < Long.valueOf(set2[0]) ? set1[0] : set2[0];
                max = Long.valueOf(set1[1]) > Long.valueOf(set2[1]) ? set1[1] : set2[1];
                val1 = min + "-" + max;
            } else {
                val1 = val2;
            }
            result.add(val1);
        }
        return result;
    }

    private boolean canGroup(String oldValue, String newValue) {
        long min1 = Long.valueOf(oldValue.split("-")[0]);
        long max1 = Long.valueOf(oldValue.split("-")[1]);
        long min2 = Long.valueOf(newValue.split("-")[0]);
        long max2 = Long.valueOf(newValue.split("-")[1]);
        return max1 + 1L >= min2 && min1 <= max2;
    }

    class SortComparator
    implements Comparator<String> {
        SortComparator() {
        }

        @Override
        public int compare(String a, String b) {
            String[] arr1 = a.split("-");
            String[] arr2 = b.split("-");
            if (Long.valueOf(arr1[0]) > Long.valueOf(arr2[0])) {
                return 1;
            }
            if (Long.valueOf(arr1[0]) == Long.valueOf(arr2[0])) {
                if (Long.valueOf(arr1[1]) > Long.valueOf(arr2[1])) {
                    return 1;
                }
                return -1;
            }
            return -1;
        }
    }
}

