/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.policyOptimizationHelper;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.QueryConstructionException;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.ComplianceGenerator;
import com.adventnet.fa.server.FACacheManager;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.util.ProductBundle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONConstructor
extends ComplianceGenerator {
    private static final Logger LOGGER = Logger.getLogger(JSONConstructor.class.getName());
    private ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(3);
    private static JSONConstructor jsonConstructor;

    public static JSONConstructor getInstance() {
        if (jsonConstructor == null) {
            jsonConstructor = new JSONConstructor();
        }
        return jsonConstructor;
    }

    private JSONConstructor() {
    }

    public void createJSONConstructionTask(Long rID, String deviceType) {
        LOGGER.info("@@JSONConstructor::: inside creating new JSONConstructionTask for the anomaly JSON ");
        JSONConstructionTask ppt = new JSONConstructionTask(rID, deviceType);
        ScheduledFuture<?> sf = this.scheduler.schedule(ppt, 1L, TimeUnit.SECONDS);
    }

    class JSONConstructionTask
    implements Runnable {
        private Long rID;
        private String deviceType;
        ResourceBundle bundle = ProductBundle.getInstance().getBundle();
        Connection con = null;
        Statement stmt = null;

        JSONConstructionTask(Long rID, String deviceType) {
            this.deviceType = deviceType;
            this.rID = rID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ResultSet queryResult = null;
            try {
                String resourceName = (String)LaCacheManager.getInstance().getResourceName(this.rID);
                String displayName = FACacheManager.getInstance().getDisplayName(this.rID);
                String query = this.getQuery();
                queryResult = this.getQueryResult(query);
                JSONObject finalJSON = this.constructJSON(queryResult);
                this.saveJSONToFlatFile(this.rID, finalJSON.toString(), displayName, resourceName);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            finally {
                if (queryResult != null) {
                    try {
                        queryResult.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JSONObject constructJSON(ResultSet queryResult) throws Exception {
            JSONObject finalJSON = new JSONObject();
            finalJSON.put("selectedDevice", (Object)"DeviceName");
            ArrayList<String> anomalyList = new ArrayList<String>();
            anomalyList.add("Redundancy");
            anomalyList.add("Generalization");
            anomalyList.add("Correlation");
            anomalyList.add("Shadow");
            anomalyList.add("Grouping");
            JSONArray anomalyListArray = new JSONArray(anomalyList);
            finalJSON.put("anomalyList", (Object)anomalyListArray);
            if (queryResult == null) {
                LOGGER.info("ResultSet is empty ");
            }
            String currentPolicyName = "";
            String oldPolicyName = "";
            String ruleID = "";
            String ruleSet = "";
            long currentAnomalyPK = 0L;
            long oldAnomalyPK = 0L;
            ArrayList<JSONObject> dataList = new ArrayList<JSONObject>();
            String typeKey = "";
            String description = "";
            HashMap<String, Integer> ddiMap = new HashMap<String, Integer>();
            int ddiTempCount = 0;
            String ddiMapKey = "";
            String objValue = "";
            String details = "";
            String value = "";
            String detailValue = "";
            String displayName = "";
            try {
                JSONObject policyJSON;
                JSONObject anomalyJSON;
                JSONArray dataArray;
                if (queryResult.next()) {
                    oldPolicyName = currentPolicyName = queryResult.getString(11);
                    oldAnomalyPK = currentAnomalyPK = queryResult.getLong(12);
                    JSONObject dataJSON = new JSONObject();
                    dataJSON.put("Rule", (Object)queryResult.getString(2));
                    value = queryResult.getString(3);
                    detailValue = queryResult.getString(4);
                    value = JSONConstructor.this.generateLink(value, detailValue, this.rID, displayName, "RULE_SRC", this.deviceType);
                    dataJSON.put("Source", (Object)value);
                    value = queryResult.getString(5);
                    detailValue = queryResult.getString(6);
                    value = JSONConstructor.this.generateLink(value, detailValue, this.rID, displayName, "Destination", this.deviceType);
                    dataJSON.put("Destination", (Object)value);
                    value = queryResult.getString(7);
                    detailValue = queryResult.getString(8);
                    value = JSONConstructor.this.generateLink(value, detailValue, this.rID, displayName, "SERVICE", this.deviceType);
                    dataJSON.put("Service", (Object)value);
                    dataJSON.put("Action", (Object)queryResult.getString(9));
                    description = queryResult.getString(15);
                    ruleID = queryResult.getString(1);
                    ruleSet = queryResult.getString(14);
                    if (!ruleSet.contains(ruleID)) {
                        dataJSON.put("highlight", (Object)"true");
                        typeKey = queryResult.getString(2) + "_" + queryResult.getString(13);
                    }
                    dataList.add(dataJSON);
                }
                JSONObject resultJSON = new JSONObject();
                JSONObject typeJSON = new JSONObject();
                while (queryResult.next()) {
                    currentAnomalyPK = queryResult.getLong(12);
                    if (currentAnomalyPK != oldAnomalyPK) {
                        dataArray = new JSONArray(dataList);
                        anomalyJSON = new JSONObject();
                        anomalyJSON.put("description", (Object)description);
                        anomalyJSON.put("data", (Object)dataArray);
                        dataList = null;
                        dataList = new ArrayList();
                        oldAnomalyPK = currentAnomalyPK;
                        ddiMapKey = oldPolicyName + "_" + typeKey;
                        if (ddiMap.containsKey(ddiMapKey)) {
                            ddiTempCount = (Integer)ddiMap.get(ddiMapKey);
                            typeKey = typeKey + "_" + ++ddiTempCount;
                            ddiMap.put(ddiMapKey, new Integer(ddiTempCount));
                        } else {
                            typeKey = typeKey + "_" + 1;
                            ddiMap.put(ddiMapKey, new Integer(1));
                        }
                        typeJSON.put(typeKey, (Object)anomalyJSON);
                        currentPolicyName = queryResult.getString(11);
                        if (!currentPolicyName.equals(oldPolicyName)) {
                            policyJSON = new JSONObject(typeJSON.toString());
                            resultJSON.put(oldPolicyName, (Object)policyJSON);
                            typeJSON = null;
                            typeJSON = new JSONObject();
                            oldPolicyName = currentPolicyName;
                        }
                    }
                    JSONObject dataJSON = new JSONObject();
                    dataJSON.put("Rule", (Object)queryResult.getString(2));
                    value = queryResult.getString(3);
                    detailValue = queryResult.getString(4);
                    value = JSONConstructor.this.generateLink(value, detailValue, this.rID, displayName, "RULE_SRC", this.deviceType);
                    dataJSON.put("Source", (Object)value);
                    value = queryResult.getString(5);
                    detailValue = queryResult.getString(6);
                    value = JSONConstructor.this.generateLink(value, detailValue, this.rID, displayName, "Destination", this.deviceType);
                    dataJSON.put("Destination", (Object)value);
                    value = queryResult.getString(7);
                    detailValue = queryResult.getString(8);
                    value = JSONConstructor.this.generateLink(value, detailValue, this.rID, displayName, "SERVICE", this.deviceType);
                    dataJSON.put("Service", (Object)value);
                    dataJSON.put("Action", (Object)queryResult.getString(9));
                    description = queryResult.getString(15);
                    ruleID = queryResult.getString(1);
                    ruleSet = queryResult.getString(14);
                    if (!ruleSet.contains(ruleID)) {
                        dataJSON.put("highlight", (Object)"true");
                        typeKey = queryResult.getString(2) + "_" + queryResult.getString(13);
                    }
                    dataList.add(dataJSON);
                }
                dataArray = new JSONArray(dataList);
                anomalyJSON = new JSONObject();
                anomalyJSON.put("description", (Object)description);
                anomalyJSON.put("data", (Object)dataArray);
                dataList.clear();
                oldAnomalyPK = currentAnomalyPK;
                ddiMapKey = oldPolicyName + "_" + typeKey;
                if (ddiMap.containsKey(ddiMapKey)) {
                    ddiTempCount = (Integer)ddiMap.get(ddiMapKey);
                    typeKey = typeKey + "_" + ++ddiTempCount;
                    ddiMap.put(ddiMapKey, new Integer(ddiTempCount));
                } else {
                    typeKey = typeKey + "_" + 1;
                    ddiMap.put(ddiMapKey, new Integer(1));
                }
                typeJSON.put(typeKey, (Object)anomalyJSON);
                policyJSON = new JSONObject(typeJSON.toString());
                resultJSON.put(oldPolicyName, (Object)policyJSON);
                finalJSON.put("results", (Object)resultJSON);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (this.stmt != null) {
                        this.stmt.close();
                    }
                    if (this.con != null) {
                        this.con.close();
                    }
                    if (queryResult != null) {
                        queryResult.close();
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            ArrayList<String> allColList = new ArrayList<String>();
            allColList.add(this.bundle.getString("Anomaly.rule"));
            allColList.add(this.bundle.getString("Anomaly.source"));
            allColList.add(this.bundle.getString("Anomaly.destination"));
            allColList.add(this.bundle.getString("Anomaly.service"));
            allColList.add(this.bundle.getString("Anomaly.action"));
            JSONArray allColJSONArray = new JSONArray(allColList);
            finalJSON.put("allColumn", (Object)allColJSONArray);
            return finalJSON;
        }

        private String getQuery() {
            try {
                SelectQueryImpl resSQL = new SelectQueryImpl(new Table("RuleDetails"));
                resSQL.addSelectColumn(new Column("RuleDetails", "RULEID"));
                resSQL.addSelectColumn(new Column("RuleDetails", "RULENAME"));
                resSQL.addSelectColumn(new Column("RuleDetails", "RULE_SRC"));
                resSQL.addSelectColumn(new Column("RuleDetails", "DETAILED_SRC"));
                resSQL.addSelectColumn(new Column("RuleDetails", "RULE_DST"));
                resSQL.addSelectColumn(new Column("RuleDetails", "DETAILED_DST"));
                resSQL.addSelectColumn(new Column("RuleDetails", "SERVICE"));
                resSQL.addSelectColumn(new Column("RuleDetails", "DETAILED_SERVICE"));
                resSQL.addSelectColumn(new Column("RuleDetails", "ACTION"));
                Join join1 = new Join("RuleDetails", "PolicyDetails", new String[]{"POLICYID"}, new String[]{"POLICYID"}, 2);
                resSQL.addJoin(join1);
                resSQL.addSelectColumn(new Column("PolicyDetails", "POLICYID"));
                resSQL.addSelectColumn(new Column("PolicyDetails", "POLICYNAME"));
                resSQL.addSortColumn(new SortColumn("PolicyDetails", "POLICYID", true));
                Join join2 = new Join("RuleDetails", "AnomalyRuleDetails", new String[]{"RULEID"}, new String[]{"RULEID"}, 2);
                resSQL.addJoin(join2);
                Join join3 = new Join("AnomalyRuleDetails", "AnomalyDetails", new String[]{"AnomalyPK"}, new String[]{"AnomalyPK"}, 2);
                resSQL.addJoin(join3);
                resSQL.addSelectColumn(new Column("AnomalyDetails", "AnomalyPK"));
                resSQL.addSelectColumn(new Column("AnomalyDetails", "ANOMALYTYPE"));
                resSQL.addSelectColumn(new Column("AnomalyDetails", "RULESET"));
                resSQL.addSelectColumn(new Column("AnomalyDetails", "ASSOCIATEDRULES"));
                resSQL.addSortColumn(new SortColumn("AnomalyDetails", "AnomalyPK", true));
                Criteria c = new Criteria(new Column("AnomalyDetails", "RID"), (Object)this.rID, 0);
                resSQL.setCriteria(c);
                resSQL.addSortColumn(new SortColumn("AnomalyRuleDetails", "RULEID", true));
                return RelationalAPI.getInstance().getSelectSQL((Query)resSQL);
            }
            catch (QueryConstructionException e) {
                e.printStackTrace();
                return null;
            }
        }

        private ResultSet getQueryResult(String query) {
            this.con = null;
            this.stmt = null;
            ResultSet resultSet = null;
            try {
                RelationalAPI rapi = RelationalAPI.getInstance();
                this.con = rapi.getConnection();
                this.stmt = this.con.createStatement();
                resultSet = this.stmt.executeQuery(query);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return resultSet;
        }

        private void saveJSONToFlatFile(Long rID, String mainJson, String displayName, String resourceName) throws Exception {
            FileOutputStream fop = null;
            try {
                String filePath;
                File file;
                String dirPath = System.getProperty("server.dir") + File.separator + "server" + File.separator + "configData" + File.separator + rID;
                File fileDirPath = new File(dirPath);
                if (!fileDirPath.exists()) {
                    fileDirPath.mkdirs();
                }
                if (!(file = new File(filePath = dirPath + File.separator + resourceName + "_Anomaly_JSON.txt")).exists()) {
                    file.createNewFile();
                }
                fop = new FileOutputStream(file);
                byte[] contentInBytes = mainJson.getBytes();
                fop.write(contentInBytes);
                fop.flush();
                fop.close();
            }
            catch (IOException ee) {
                throw new Exception("ComplianceGenerator:::Exception while saving JSON to flatfile...for the firewall " + displayName + " and for the report::", ee);
            }
            finally {
                try {
                    if (fop != null) {
                        fop.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

