/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.rules;

import com.adventnet.la.util.pe.Attribute;
import com.adventnet.la.util.pe.ParserRule;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeviceCommandParser {
    private static DeviceCommandParser dcp = null;
    private Map<String, ArrayList<String>> deviceTypeToTFTPRunningComplicanceCmds = new HashMap<String, ArrayList<String>>();
    private Map<String, ArrayList<String>> deviceTypeToTFTPStartupComplicanceCmds = new HashMap<String, ArrayList<String>>();
    private Map<String, ArrayList<String>> deviceTypeToSCPRunningComplicanceCmds = null;
    private Map<String, ArrayList<String>> deviceTypeToSCPStartupComplicanceCmds = null;
    private Map<String, ArrayList<String>> deviceTypeToTFTPVdomRunningComplicanceCmds = new HashMap<String, ArrayList<String>>();
    private Map<String, ArrayList<String>> deviceTypeToTFTPVdomStartupComplicanceCmds = new HashMap<String, ArrayList<String>>();
    private Map<String, ArrayList<String>> deviceTypeToSCPVdomRunningComplicanceCmds = null;
    private Map<String, ArrayList<String>> deviceTypeToSCPVdomStartupComplicanceCmds = null;
    private Map deviceTypeToRunningComplicanceCmds = null;
    private Map deviceTypeToVdomRunningComplicanceCmds = null;
    private Map deviceTypeToStartupComplicanceCmds = null;
    private Map deviceTypeToVdomStartupComplicanceCmds = null;
    private Map deviceTypeToRuleCmds = null;
    private Map deviceTypeToVdomRuleCmds = null;
    private Map deviceToCmdIndex = null;
    private Map vdomDeviceToCmdIndex = null;
    private String supportedDevicesForRules = "";
    private String supportedDevicesForConfig = "";
    private String supportedDevicesForTFTP = "";
    private String supportedDevicesForSCP = "";
    private Document document;
    private Map deviceToConfiguration = null;

    public static synchronized DeviceCommandParser getInstance() {
        if (dcp == null) {
            dcp = new DeviceCommandParser();
        }
        return dcp;
    }

    private DeviceCommandParser() {
        this.deviceTypeToSCPRunningComplicanceCmds = new HashMap<String, ArrayList<String>>();
        this.deviceTypeToSCPStartupComplicanceCmds = new HashMap<String, ArrayList<String>>();
        this.deviceTypeToSCPVdomRunningComplicanceCmds = new HashMap<String, ArrayList<String>>();
        this.deviceTypeToSCPVdomStartupComplicanceCmds = new HashMap<String, ArrayList<String>>();
        this.deviceToConfiguration = new HashMap();
        this.deviceTypeToRunningComplicanceCmds = new HashMap();
        this.deviceTypeToVdomRunningComplicanceCmds = new HashMap();
        this.deviceTypeToStartupComplicanceCmds = new HashMap();
        this.deviceTypeToVdomStartupComplicanceCmds = new HashMap();
        this.deviceTypeToRuleCmds = new HashMap();
        this.deviceTypeToVdomRuleCmds = new HashMap();
        this.deviceToCmdIndex = new HashMap();
        this.vdomDeviceToCmdIndex = new HashMap();
        this.parseFile();
    }

    private void populateRuleCmds(String deviceType, String cmd) {
        ArrayList<String> ruleCmds = (ArrayList<String>)this.deviceTypeToRuleCmds.get(deviceType);
        if (ruleCmds == null) {
            ruleCmds = new ArrayList<String>();
            this.deviceTypeToRuleCmds.put(deviceType, ruleCmds);
        }
        ruleCmds.add(cmd);
    }

    private void populateVdomRuleCmds(String deviceType, String cmd) {
        ArrayList<String> ruleCmds = (ArrayList<String>)this.deviceTypeToVdomRuleCmds.get(deviceType);
        if (ruleCmds == null) {
            ruleCmds = new ArrayList<String>();
            this.deviceTypeToVdomRuleCmds.put(deviceType, ruleCmds);
        }
        ruleCmds.add(cmd);
    }

    private void populateComplianceCommands(String deviceType, String cmd, String configType) {
        if (configType.equals("startup")) {
            ArrayList<String> startupConfigCmds = (ArrayList<String>)this.deviceTypeToStartupComplicanceCmds.get(deviceType);
            if (startupConfigCmds == null) {
                startupConfigCmds = new ArrayList<String>();
                this.deviceTypeToStartupComplicanceCmds.put(deviceType, startupConfigCmds);
            }
            startupConfigCmds.add(cmd);
        } else {
            ArrayList<String> runningConfigCmds = (ArrayList<String>)this.deviceTypeToRunningComplicanceCmds.get(deviceType);
            if (runningConfigCmds == null) {
                runningConfigCmds = new ArrayList<String>();
                this.deviceTypeToRunningComplicanceCmds.put(deviceType, runningConfigCmds);
            }
            runningConfigCmds.add(cmd);
        }
    }

    private void populateTFTPComplianceCommands(String deviceType, String cmd, String configType) {
        if (configType.equals("startup")) {
            ArrayList<String> startupConfigCmds = this.deviceTypeToTFTPStartupComplicanceCmds.get(deviceType);
            if (startupConfigCmds == null) {
                startupConfigCmds = new ArrayList();
                this.deviceTypeToTFTPStartupComplicanceCmds.put(deviceType, startupConfigCmds);
            }
            startupConfigCmds.add(cmd);
        } else {
            ArrayList<String> runningConfigCmds = this.deviceTypeToTFTPRunningComplicanceCmds.get(deviceType);
            if (runningConfigCmds == null) {
                runningConfigCmds = new ArrayList();
                this.deviceTypeToTFTPRunningComplicanceCmds.put(deviceType, runningConfigCmds);
                this.supportedDevicesForTFTP = this.supportedDevicesForTFTP + deviceType + ",";
            }
            runningConfigCmds.add(cmd);
        }
    }

    private void populateSCPComplianceCommands(String deviceType, String cmd, String configType) {
        if (configType.equals("startup")) {
            ArrayList<String> startupConfigCmds = this.deviceTypeToSCPStartupComplicanceCmds.get(deviceType);
            if (startupConfigCmds == null) {
                startupConfigCmds = new ArrayList();
                this.deviceTypeToSCPStartupComplicanceCmds.put(deviceType, startupConfigCmds);
            }
            startupConfigCmds.add(cmd);
        } else {
            ArrayList<String> runningConfigCmds = this.deviceTypeToSCPRunningComplicanceCmds.get(deviceType);
            if (runningConfigCmds == null) {
                runningConfigCmds = new ArrayList();
                this.deviceTypeToSCPRunningComplicanceCmds.put(deviceType, runningConfigCmds);
                this.supportedDevicesForSCP = this.supportedDevicesForSCP + deviceType + ",";
            }
            runningConfigCmds.add(cmd);
        }
    }

    private void populateTFTPVdomComplianceCommands(String deviceType, String cmd, String configType) {
        if (configType.equals("startup")) {
            ArrayList<String> startupConfigCmds = this.deviceTypeToTFTPVdomStartupComplicanceCmds.get(deviceType);
            if (startupConfigCmds == null) {
                startupConfigCmds = new ArrayList();
                this.deviceTypeToTFTPVdomStartupComplicanceCmds.put(deviceType, startupConfigCmds);
            }
            startupConfigCmds.add(cmd);
        } else {
            ArrayList<String> runningConfigCmds = this.deviceTypeToTFTPVdomRunningComplicanceCmds.get(deviceType);
            if (runningConfigCmds == null) {
                runningConfigCmds = new ArrayList();
                this.deviceTypeToTFTPVdomRunningComplicanceCmds.put(deviceType, runningConfigCmds);
            }
            runningConfigCmds.add(cmd);
        }
    }

    private void populateSCPVdomComplianceCommands(String deviceType, String cmd, String configType) {
        if (configType.equals("startup")) {
            ArrayList<String> startupConfigCmds = this.deviceTypeToSCPVdomStartupComplicanceCmds.get(deviceType);
            if (startupConfigCmds == null) {
                startupConfigCmds = new ArrayList();
                this.deviceTypeToSCPVdomStartupComplicanceCmds.put(deviceType, startupConfigCmds);
            }
            startupConfigCmds.add(cmd);
        } else {
            ArrayList<String> runningConfigCmds = this.deviceTypeToSCPVdomRunningComplicanceCmds.get(deviceType);
            if (runningConfigCmds == null) {
                runningConfigCmds = new ArrayList();
                this.deviceTypeToSCPVdomRunningComplicanceCmds.put(deviceType, runningConfigCmds);
            }
            runningConfigCmds.add(cmd);
        }
    }

    private void populateVdomComplianceCommands(String deviceType, String cmd, String configType) {
        if (configType.equals("startup")) {
            ArrayList<String> startupConfigCmds = (ArrayList<String>)this.deviceTypeToVdomStartupComplicanceCmds.get(deviceType);
            if (startupConfigCmds == null) {
                startupConfigCmds = new ArrayList<String>();
                this.deviceTypeToVdomStartupComplicanceCmds.put(deviceType, startupConfigCmds);
            }
            startupConfigCmds.add(cmd);
        } else {
            ArrayList<String> runningConfigCmds = (ArrayList<String>)this.deviceTypeToVdomRunningComplicanceCmds.get(deviceType);
            if (runningConfigCmds == null) {
                runningConfigCmds = new ArrayList<String>();
                this.deviceTypeToVdomRunningComplicanceCmds.put(deviceType, runningConfigCmds);
            }
            runningConfigCmds.add(cmd);
        }
    }

    private void populate(String deviceType, String key, Object value) {
        HashMap<String, Object> configMap = (HashMap<String, Object>)this.deviceToConfiguration.get(deviceType);
        if (configMap == null) {
            configMap = new HashMap<String, Object>();
            this.deviceToConfiguration.put(deviceType, configMap);
        }
        configMap.put(key, value);
    }

    public void parseFile() {
        DocumentBuilder dBuild = null;
        Document doc = null;
        try {
            String start = System.getProperty("server.home");
            String end = File.separator + "server" + File.separator + "conf" + File.separator + "DeviceCommand.xml";
            File fileName = new File(start + end);
            FileInputStream is = new FileInputStream(fileName);
            DocumentBuilderFactory dBuildFac = DocumentBuilderFactory.newInstance();
            dBuild = dBuildFac.newDocumentBuilder();
            this.document = doc = dBuild.parse(is);
            this.visitDocument();
            Object unknowWELFConfig = this.deviceToConfiguration.get("Unknown (WELF)");
            if (unknowWELFConfig != null) {
                this.deviceToConfiguration.put("FortiGate", unknowWELFConfig);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    private String get(String deviceType, String key) {
        Map configs = (Map)this.deviceToConfiguration.get(deviceType);
        if (configs == null) {
            return null;
        }
        return (String)configs.get(key);
    }

    public String getCommand(String type) {
        return this.get(type, "ruleCmd");
    }

    public String getBannerCommand(String type) {
        return this.get(type, "bc");
    }

    public boolean isEnableModeRequired(String type) {
        String enableMode = this.get(type, "em");
        return "true".equals(enableMode);
    }

    public Map getConfigForType(String deviceType) {
        return (Map)this.deviceToConfiguration.get(deviceType.trim());
    }

    public String getInvalidCmdMsg(String deviceType) {
        return this.get(deviceType, "errorMessage");
    }

    public int getTimeout(String deviceType) {
        int toReturn = 10;
        String time = this.get(deviceType, "timeout");
        if (time != null) {
            try {
                toReturn = Integer.parseInt(time);
                toReturn = toReturn < 0 ? 3 : toReturn;
            }
            catch (NumberFormatException nfe) {
                toReturn = 3;
            }
        }
        return toReturn;
    }

    public List getRunningComplianceCommands(String deviceType) {
        return (List)this.deviceTypeToRunningComplicanceCmds.get(deviceType);
    }

    public Map getRunningConfigDetailsMap() {
        return this.deviceTypeToRunningComplicanceCmds;
    }

    public List getStartupComplianceCommands(String deviceType) {
        return (List)this.deviceTypeToStartupComplicanceCmds.get(deviceType);
    }

    public List getRuleCmds(String deviceType) {
        return (List)this.deviceTypeToRuleCmds.get(deviceType);
    }

    public ArrayList<String> getVdomTFTPStartupCommands(String deviceType) {
        return this.deviceTypeToTFTPVdomStartupComplicanceCmds.get(deviceType);
    }

    public ArrayList<String> getTFTPStartupCommands(String deviceType) {
        return this.deviceTypeToTFTPStartupComplicanceCmds.get(deviceType);
    }

    public ArrayList<String> getVdomTFTPRunningCommands(String deviceType) {
        return this.deviceTypeToTFTPVdomRunningComplicanceCmds.get(deviceType);
    }

    public ArrayList<String> getTFTPRunningCommands(String deviceType) {
        return this.deviceTypeToTFTPRunningComplicanceCmds.get(deviceType);
    }

    public ArrayList<String> getVdomSCPStartupCommands(String deviceType) {
        return this.deviceTypeToSCPVdomStartupComplicanceCmds.get(deviceType);
    }

    public ArrayList<String> getSCPStartupCommands(String deviceType) {
        return this.deviceTypeToSCPStartupComplicanceCmds.get(deviceType);
    }

    public ArrayList<String> getVdomSCPRunningCommands(String deviceType) {
        return this.deviceTypeToSCPVdomRunningComplicanceCmds.get(deviceType);
    }

    public ArrayList<String> getSCPRunningCommands(String deviceType) {
        return this.deviceTypeToSCPRunningComplicanceCmds.get(deviceType);
    }

    public int getKeyCmdIndex(String deviceType) {
        String cmdIndex = (String)this.deviceToCmdIndex.get(deviceType);
        int index = Integer.parseInt(cmdIndex);
        return index;
    }

    public List getVdomRuleCmds(String deviceType) {
        return (List)this.deviceTypeToVdomRuleCmds.get(deviceType);
    }

    public List getVdomRunningComplianceCommands(String deviceType) {
        return (List)this.deviceTypeToVdomRunningComplicanceCmds.get(deviceType);
    }

    public List getVdomStartupComplianceCommands(String deviceType) {
        return (List)this.deviceTypeToVdomStartupComplicanceCmds.get(deviceType);
    }

    public int getVdomKeyCmdIndex(String deviceType) {
        String cmdIndex = (String)this.vdomDeviceToCmdIndex.get(deviceType);
        int index = Integer.parseInt(cmdIndex);
        return index;
    }

    public String getSupportedDevForRules() {
        return this.supportedDevicesForRules;
    }

    public String getSupportedDevicesForConfig() {
        return this.supportedDevicesForConfig;
    }

    public String getSupportedDevForTFTP() {
        return this.supportedDevicesForTFTP;
    }

    public String getSupportedDevForSCP() {
        return this.supportedDevicesForSCP;
    }

    public void visitDocument() {
        Element element = this.document.getDocumentElement();
        if (element != null && element.getTagName().equals("DeviceCommands")) {
            this.visitElement_DeviceCommands(element);
        }
    }

    void visitElement_DeviceCommands(Element element) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("Device")) continue block4;
                    this.visitElement_Device(nodeElement);
                    continue block4;
                }
            }
        }
    }

    void visitElement_Device(Element element) {
        String type = element.getAttribute("type");
        String enableMode = element.getAttribute("enableMode");
        this.populate(type, "em", enableMode);
        String enableCommand = element.getAttribute("bannerCommand");
        this.populate(type, "bc", enableCommand);
        String errorMessage = element.getAttribute("errorMessage");
        this.populate(type, "errorMessage", errorMessage);
        String multiPromptAction = element.getAttribute("multiPromptAction");
        this.populate(type, "multiPromptAction", multiPromptAction);
        String timeout = element.getAttribute("timeout");
        timeout = timeout != null && !"".equals(timeout) ? timeout : "3";
        this.populate(type, "timeout", timeout);
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    String tagName = nodeElement.getTagName();
                    if (tagName.equals("RuleName") || tagName.equals("Connection")) {
                        this.visitElement_Regex(nodeElement, type);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("RuleDescription")) {
                        this.visitElement_RuleDescription(nodeElement, type);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("RuleDescriptionSet")) {
                        this.visitElement_RuleDescriptionSet(nodeElement, type);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("Command")) {
                        this.supportedDevicesForRules = this.supportedDevicesForRules + type + ",";
                        this.visitElement_Cmd(nodeElement, type);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("RuleCommands")) {
                        this.visitElement_RuleCmds(nodeElement, type);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("RunningCommands")) {
                        this.supportedDevicesForConfig = this.supportedDevicesForConfig + type + ",";
                        this.visitElement_RunningCmds(nodeElement, type);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("StartupCommands")) {
                        this.visitElement_StartupCmds(nodeElement, type);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("keyCmdIndex")) {
                        this.visitElement_keyCmdIndex(nodeElement, type);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("TFTPRunningConfigCommands")) {
                        this.visitElement_TFTPCmds(nodeElement, type, "running");
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("TFTPStartupConfigCommands")) {
                        this.visitElement_TFTPCmds(nodeElement, type, "startup");
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("SCPRunningConfigCommands")) {
                        this.visitElement_SCPCmds(nodeElement, type, "running");
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("SCPStartupConfigCommands")) {
                        this.visitElement_SCPCmds(nodeElement, type, "startup");
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("VdomRuleCommands")) {
                        this.visitElement_VdomRuleCmds(nodeElement, type);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("VdomRunningCommands")) {
                        this.visitElement_VdomRunningCmds(nodeElement, type);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("VdomStartupCommands")) {
                        this.visitElement_VdomStartupCmds(nodeElement, type);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("VdomKeyCmdIndex")) {
                        this.visitElement_VdomkeyCmdIndex(nodeElement, type);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("VdomTFTPRunningConfigCommands")) {
                        this.visitElement_VdomTFTPCmds(nodeElement, type, "running");
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("VdomTFTPStartupConfigCommands")) {
                        this.visitElement_VdomTFTPCmds(nodeElement, type, "startup");
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("SCPVdomRunningConfigCommands")) {
                        this.visitElement_VdomSCPCmds(nodeElement, type, "running");
                        continue block4;
                    }
                    if (!nodeElement.getTagName().equals("SCPVdomStartupConfigCommands")) continue block4;
                    this.visitElement_VdomSCPCmds(nodeElement, type, "startup");
                    continue block4;
                }
            }
        }
    }

    void visitElement_Regex(Element element, String type) {
        String regEx = null;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!attr.getName().equals("regEx")) continue;
            regEx = attr.getValue();
        }
        ParserRule pr = new ParserRule();
        String tagName = element.getTagName();
        pr.setName(tagName);
        pr.setRegex(regEx);
        if ("RuleName".equals(tagName)) {
            this.populate(type, "rnp", pr);
        } else if ("Connection".equals(tagName)) {
            this.populate(type, "cp", pr);
        }
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("Attributes")) continue block5;
                    this.visitElement_Attributes(nodeElement, pr);
                    continue block5;
                }
            }
        }
    }

    void visitElement_Cmd(Element element, String type) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("Attributes")) continue block4;
                    String key = nodeElement.getAttribute("name");
                    String value = nodeElement.getAttribute("value");
                    this.populate(type, key, value);
                    continue block4;
                }
            }
        }
    }

    void visitElement_Attributes(Element element, ParserRule pr) {
        String group = null;
        String name = null;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("group")) {
                group = attr.getValue();
            }
            if (!attr.getName().equals("name")) continue;
            name = attr.getValue();
        }
        Attribute attr = new Attribute(name, new Integer(group));
        pr.addAttribute(attr);
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    continue block5;
                }
            }
        }
    }

    void visitElement_RuleDescription(Element element, String type) {
        String regEx = null;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!attr.getName().equals("regEx")) continue;
            regEx = attr.getValue();
        }
        ParserRule pr = new ParserRule();
        pr.setName("RuleDescription");
        pr.setRegex(regEx);
        this.populate(type, "rdp", pr);
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("Attributes")) continue block5;
                    this.visitElement_Attributes(nodeElement, pr);
                    continue block5;
                }
            }
        }
    }

    void visitElement_RuleDescriptionSet(Element element, String type) {
        Vector<ParserRule> prSet = this.getParserRuleSet(element);
        this.populate(type, "rdpSet", prSet);
    }

    Vector<ParserRule> getParserRuleSet(Element element) {
        Vector<ParserRule> prs = new Vector<ParserRule>();
        NodeList nodes = element.getElementsByTagName("Parser-Rule");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement = (Element)nodes.item(i);
            prs.addElement(this.getParserRule(nodeElement));
        }
        return prs;
    }

    ParserRule getParserRule(Element element) {
        ParserRule pr = new ParserRule();
        NodeList regexNodes = element.getElementsByTagName("regex");
        for (int j = 0; j < regexNodes.getLength(); ++j) {
            Element nodeElement = (Element)regexNodes.item(j);
            pr.setRegex(this.processRegexBlock(nodeElement));
        }
        NodeList nodes = element.getElementsByTagName("Attributes");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Attr attr;
            Element nodeElement = (Element)nodes.item(i);
            NamedNodeMap attrs2 = nodeElement.getAttributes();
            String name = null;
            String groupNumber = null;
            for (int j = 0; j < attrs2.getLength(); ++j) {
                attr = (Attr)attrs2.item(j);
                if (attr.getName().equals("name")) {
                    name = attr.getValue();
                    pr.setName(name);
                    continue;
                }
                if (!attr.getName().equals("group")) continue;
                groupNumber = attr.getValue();
            }
            Integer groupInteger = new Integer(0);
            try {
                groupInteger = Integer.valueOf(groupNumber);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
            attr = new Attribute(name, groupInteger);
            pr.addAttribute((Attribute)attr);
        }
        return pr;
    }

    String processRegexBlock(Element element) {
        String exp = null;
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    exp = ((CDATASection)node).getData();
                    continue block5;
                }
                case 1: {
                    continue block5;
                }
                case 7: {
                    continue block5;
                }
            }
        }
        if (exp != null) {
            exp = exp.trim();
        }
        return exp;
    }

    void visitElement_RuleCmds(Element element, String type) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("Command")) continue block4;
                    String command = nodeElement.getAttribute("cmd");
                    this.populateRuleCmds(type, command);
                    continue block4;
                }
            }
        }
    }

    void visitElement_VdomRuleCmds(Element element, String type) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("Command")) continue block4;
                    String command = nodeElement.getAttribute("cmd");
                    this.populateVdomRuleCmds(type, command);
                    continue block4;
                }
            }
        }
    }

    void visitElement_RunningCmds(Element element, String type) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("Command")) continue block4;
                    String command = nodeElement.getAttribute("cmd");
                    this.populateComplianceCommands(type, command, "running");
                    continue block4;
                }
            }
        }
    }

    void visitElement_VdomRunningCmds(Element element, String type) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("Command")) continue block4;
                    String command = nodeElement.getAttribute("cmd");
                    this.populateVdomComplianceCommands(type, command, "running");
                    continue block4;
                }
            }
        }
    }

    void visitElement_StartupCmds(Element element, String type) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("Command")) continue block4;
                    String command = nodeElement.getAttribute("cmd");
                    this.populateComplianceCommands(type, command, "startup");
                    continue block4;
                }
            }
        }
    }

    void visitElement_TFTPCmds(Element element, String type, String configType) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("Command")) continue block4;
                    String command = nodeElement.getAttribute("cmd");
                    this.populateTFTPComplianceCommands(type, command, configType);
                    continue block4;
                }
            }
        }
    }

    void visitElement_SCPCmds(Element element, String type, String configType) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("Command")) continue block4;
                    String command = nodeElement.getAttribute("cmd");
                    this.populateSCPComplianceCommands(type, command, configType);
                    continue block4;
                }
            }
        }
    }

    void visitElement_VdomTFTPCmds(Element element, String type, String configType) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("Command")) continue block4;
                    String command = nodeElement.getAttribute("cmd");
                    this.populateTFTPVdomComplianceCommands(type, command, configType);
                    continue block4;
                }
            }
        }
    }

    void visitElement_VdomSCPCmds(Element element, String type, String configType) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("Command")) continue block4;
                    String command = nodeElement.getAttribute("cmd");
                    this.populateSCPVdomComplianceCommands(type, command, configType);
                    continue block4;
                }
            }
        }
    }

    void visitElement_VdomStartupCmds(Element element, String type) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("Command")) continue block4;
                    String command = nodeElement.getAttribute("cmd");
                    this.populateVdomComplianceCommands(type, command, "startup");
                    continue block4;
                }
            }
        }
    }

    void visitElement_keyCmdIndex(Element element, String type) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("CommandIndex")) continue block4;
                    String cmdIndex = nodeElement.getAttribute("index");
                    this.deviceToCmdIndex.put(type, cmdIndex);
                    continue block4;
                }
            }
        }
    }

    void visitElement_VdomkeyCmdIndex(Element element, String type) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("CommandIndex")) continue block4;
                    String cmdIndex = nodeElement.getAttribute("index");
                    this.vdomDeviceToCmdIndex.put(type, cmdIndex);
                    continue block4;
                }
            }
        }
    }

    public static void main(String[] args) {
        new DeviceCommandParser().parseFile();
        DeviceCommandParser.getInstance();
    }
}

