/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.rules;

import com.adventnet.fa.server.rules.FirewallPolicyFormat;
import com.adventnet.fa.server.rules.FirewallPolicyParserRule;
import com.adventnet.fa.server.rules.FirewallPolicyParserRuleAttribute;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FWAPolicyParserRulesLoader {
    private static final Logger LOGGER = Logger.getLogger(FWAPolicyParserRulesLoader.class.getName());
    private static FWAPolicyParserRulesLoader prl = null;
    private String policyParsingSupportedDevices = null;

    public static synchronized FWAPolicyParserRulesLoader getInstance() {
        if (prl == null) {
            prl = new FWAPolicyParserRulesLoader();
        }
        return prl;
    }

    private FWAPolicyParserRulesLoader() {
        LOGGER.info("@@FWAPolicyParserRulesLoader:::: Before Parsing PolicyReportPatternFile.xml file...");
        long start = System.currentTimeMillis();
        this.parseFile();
        long totalTimeTaken = System.currentTimeMillis() - start;
        LOGGER.info("@@FWAPolicyParserRulesLoader:::: Finished Parsing PolicyReportPatternFile.xml file....time taken is::" + totalTimeTaken);
    }

    private void parseFile() {
        DocumentBuilder dBuild = null;
        Document doc = null;
        Element rootNode = null;
        try {
            String start = System.getProperty("server.home");
            String end = File.separator + "server" + File.separator + "conf" + File.separator + "PolicyReportPatternFile.xml";
            File fileName = new File(start + end);
            FileInputStream is = new FileInputStream(fileName);
            DocumentBuilderFactory dBuildFac = DocumentBuilderFactory.newInstance();
            dBuild = dBuildFac.newDocumentBuilder();
            doc = dBuild.parse(is);
            rootNode = doc.getDocumentElement();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        FirewallPolicyFormat.setFWAPolicyParserRules(this.getPolicyReportPatterns(rootNode));
    }

    Vector<FirewallPolicyFormat> getPolicyReportPatterns(Element element) {
        Vector<FirewallPolicyFormat> formats = new Vector<FirewallPolicyFormat>();
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("Device")) continue block4;
                    formats.addElement(this.getFormat(nodeElement));
                    continue block4;
                }
            }
        }
        return formats;
    }

    FirewallPolicyFormat getFormat(Element element) {
        Element nodeElement;
        int i;
        FirewallPolicyFormat fpf = new FirewallPolicyFormat();
        NamedNodeMap attrs = element.getAttributes();
        for (int i2 = 0; i2 < attrs.getLength(); ++i2) {
            Attr attr = (Attr)attrs.item(i2);
            if (attr.getName().equals("type")) {
                String devType = attr.getValue();
                fpf.setDeviceType(devType);
                String string = this.policyParsingSupportedDevices = this.policyParsingSupportedDevices == null ? devType : this.policyParsingSupportedDevices + "," + devType;
            }
            if (attr.getName().equals("policyStartPattern")) {
                fpf.setPolicyStartPattern(attr.getValue());
            }
            if (attr.getName().equals("netObjStartPattern")) {
                fpf.setNetObjStartPattern(attr.getValue());
            }
            if (attr.getName().equals("nameObjStartPattern")) {
                fpf.setASANameObjectStartPattern(attr.getValue());
            }
            if (attr.getName().equals("netObjGroupStartPattern")) {
                fpf.setNetObjGroupStartPattern(attr.getValue());
            }
            if (attr.getName().equals("staticNATObjStartPattern")) {
                fpf.setStaticNATObjStartPattern(attr.getValue());
            }
            if (attr.getName().equals("staticNATObjGroupStartPattern")) {
                fpf.setStaticNATObjGroupStartPattern(attr.getValue());
            }
            if (attr.getName().equals("serviceObjStartPattern")) {
                fpf.setServiceObjStartPattern(attr.getValue());
            }
            if (attr.getName().equals("serviceObjGroupStartPattern")) {
                fpf.setServiceObjGroupStartPattern(attr.getValue());
            }
            if (attr.getName().equals("interfaceStartPattern")) {
                fpf.setInterfaceStartPattern(attr.getValue());
            }
            if (attr.getName().equals("pixInterfaceIPStartPattern")) {
                fpf.setPixInterfaceIPStartPattern(attr.getValue());
            }
            if (attr.getName().equals("endPattern")) {
                fpf.setEndPattern(attr.getValue());
            }
            if (attr.getName().equals("endDecidePattern")) {
                fpf.setEndDecidePattern(attr.getValue());
            }
            if (attr.getName().equals("protocolObjStartPattern")) {
                fpf.setProtocolObjStartPattern(attr.getValue());
            }
            if (attr.getName().equals("protocolObjGroupStartPattern")) {
                fpf.setProtocolObjGroupStartPattern(attr.getValue());
            }
            if (attr.getName().equals("icmpObjStartPattern")) {
                fpf.setIcmpObjStartPattern(attr.getValue());
            }
            if (attr.getName().equals("icmpObjGroupStartPattern")) {
                fpf.setIcmpObjGroupStartPattern(attr.getValue());
            }
            if (attr.getName().equals("accessListConfigStartPattern")) {
                fpf.setAccessListConfigStartPattern(attr.getValue());
            }
            if (attr.getName().equals("SNMPStartPattern")) {
                fpf.setSNMPConfigStartPattern(attr.getValue());
            }
            if (attr.getName().equals("HTTPStartPattern")) {
                fpf.setHTTPConfigStartPattern(attr.getValue());
            }
            if (attr.getName().equals("TelnetStartPattern")) {
                fpf.setTelnetConfigStartPattern(attr.getValue());
            }
            if (attr.getName().equals("SSHStartPattern")) {
                fpf.setSSHConfigStartPattern(attr.getValue());
            }
            if (attr.getName().equals("UserAccessStartPattern")) {
                fpf.setUserAccessConfigStartPattern(attr.getValue());
            }
            if (attr.getName().equals("NTPStartPattern")) {
                fpf.setNTPConfigStartPattern(attr.getValue());
            }
            if (attr.getName().equals("staticNATConfigStartPattern")) {
                fpf.setStaticNATConfigStartPattern(attr.getValue());
            }
            if (attr.getName().equals("dynamicNATConfigStartPattern")) {
                fpf.setDynamicNATConfigStartPattern(attr.getValue());
            }
            if (attr.getName().equals("asaMultiNATStartPattern")) {
                fpf.setASAMultiNATStartPattern(attr.getValue());
            }
            if (attr.getName().equals("asaSourceNATStartPattern")) {
                fpf.setASASourceNATStartPattern(attr.getValue());
            }
            if (attr.getName().equals("loggingConfigStartPattern")) {
                fpf.setSyslogConfigStartPattern(attr.getValue());
            }
            if (attr.getName().equals("staticRouteStartPattern")) {
                fpf.setStaticRouteConfigStartPattern(attr.getValue());
            }
            if (attr.getName().equals("defaultStaticRouteStartPattern")) {
                fpf.setDefaultStaticRouteConfigStartPattern(attr.getValue());
            }
            if (attr.getName().equals("siteToSiteVPNStartPattern")) {
                fpf.setSiteToSiteVPNStartPattern(attr.getValue());
            }
            if (attr.getName().equals("groupPolicyStartPattern")) {
                fpf.setGroupPolicyStartPattern(attr.getValue());
            }
            if (attr.getName().equals("tunnelGroupStartPattern")) {
                fpf.setTunnelGroupStartPattern(attr.getValue());
            }
            if (attr.getName().equals("ipPoolStartpattern")) {
                fpf.setIPPoolConfigStartPattern(attr.getValue());
            }
            if (!attr.getName().equals("dapRecordStartPattern")) continue;
            fpf.setDAPRecordStartPattern(attr.getValue());
        }
        NodeList nodes = element.getElementsByTagName("PolicyName");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setPolicyNameParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("RuleName");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setRuleNameParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("RuleElementsSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setRuleElementsParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("RuleCommentSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setRuleCommentsParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("ObjectTypeDetection");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setObjectTypeDetectionParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("NameObjectParserRule");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setASANameObjectConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("NetworkObjectName");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setNetworkObjectNameParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("NetworkObjectElementsSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setNetworkObjectElementsParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("StaticNatObjName");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setStaticNATObjectNameParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("StaticNatObjElementsSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setStaticNATObjectElementsParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("ServiceObjName");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setServiceObjectNameParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("ServiceObjElementsSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setServiceObjectElementsParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("ObjectGroupTypeDetection");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setObjectGroupTypeDetectionParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("NetworkObjectGroupName");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setNetworkObjectGroupNameParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("NetworkObjectGroupElementsSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setNetworkObjectGroupElementsParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("StaticNATObjGroupName");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setStaticNATObjectGroupNameParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("StaticNATObjGroupElementsSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setStaticNATObjectGroupElementsParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("ServiceObjectGroupName");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setServiceObjectGroupNameParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("ServiceObjectGroupElementsSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setServiceObjectGroupElementsParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("InterfaceName");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setInterfaceNameParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("InterfaceElementsSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setInterfaceElementsParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("InterfaceNameASA");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setASAInterfaceNameParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("InterfaceElementsSetForASA");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setASAInterfaceElementsParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("InterfaceDetailsForPIX");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setPIXInterfaceDetailsParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("IPDetailsOfInterfaceForPIX");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setPIXInterfaceIPDetailsParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("StaticNATParserRuleSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setStaticNATConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("DynamicNATParserRuleSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setDynamicNATConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("DefaultStaticRouteParserRuleSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setDefaultStaticRouteConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("StaticRouteParserRuleSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setStaticRouteConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("ASANATSourceObjName");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setASASourceNATObjNameParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("ASASourceNATParserRuleSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setASASourceNATConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("ASAMultiNATParserRuleSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setASAMultiNATConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("SNMPServerDetails");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setSNMPConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("HTTPServerDetails");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setHTTPConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("TelnetServerDetails");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setTelnetConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("SSHServerDetails");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setSSHConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("UserAccessConfig");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setUserAccessConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("NTPConfig");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setNTPConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("LoggingConfig");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setSyslogLoggingConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("ProtocolObjectName");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setProtocolObjectNameParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("ProtocolObjectElementsSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setProtocolObjectElementsParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("ProtocolObjectGroupName");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setProtocolObjectGroupNameParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("ProtocolObjectGroupElementsSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setProtocolObjectGroupElementsParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("ICMPObjectName");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setICMPObjectNameParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("ICMPObjectElementsSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setICMPObjectElementsParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("ICMPObjectGroupName");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setICMPObjectGroupNameParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("ICMPObjectGroupElementsSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setICMPObjectGroupElementsParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("ACLInterfaceDetails");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setACLInterfaceConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("SiteToSiteVPNConfig");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setSiteToSiteVPNConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("GroupPolicyConfig");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setGroupPolicyConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("TunnelGroupConfig");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setTunnelGroupConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("IPPoolConfig");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setIPPoolConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("DynamicAccessPolicy");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            fpf.setDAPRecordConfigParserRules(this.getParserRuleSet(nodeElement));
        }
        return fpf;
    }

    public String getPolicyParsingSupportedDevices() {
        return this.policyParsingSupportedDevices;
    }

    Vector<FirewallPolicyParserRule> getParserRuleSet(Element element) {
        Vector<FirewallPolicyParserRule> prs = new Vector<FirewallPolicyParserRule>();
        NodeList nodes = element.getElementsByTagName("Parser-Rule");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement = (Element)nodes.item(i);
            prs.addElement(this.getParserRule(nodeElement));
        }
        return prs;
    }

    FirewallPolicyParserRule getParserRule(Element element) {
        FirewallPolicyParserRule pr = new FirewallPolicyParserRule();
        NodeList regexNodes = element.getElementsByTagName("regex");
        for (int j = 0; j < regexNodes.getLength(); ++j) {
            Element nodeElement = (Element)regexNodes.item(j);
            pr.setRegex(this.processRegexBlock(nodeElement));
        }
        NodeList nodes = element.getElementsByTagName("Attributes");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Object attr;
            Element nodeElement = (Element)nodes.item(i);
            NamedNodeMap attrs2 = nodeElement.getAttributes();
            String name = null;
            String groupNumber = null;
            for (int j = 0; j < attrs2.getLength(); ++j) {
                attr = (Attr)attrs2.item(j);
                if (attr.getName().equals("name")) {
                    name = attr.getValue();
                    pr.setName(name);
                    continue;
                }
                if (!attr.getName().equals("group")) continue;
                groupNumber = attr.getValue();
            }
            Integer groupInteger = new Integer(0);
            try {
                groupInteger = Integer.valueOf(groupNumber);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
            attr = new FirewallPolicyParserRuleAttribute(name, groupInteger);
            pr.addAttribute((FirewallPolicyParserRuleAttribute)attr);
        }
        return pr;
    }

    String processRegexBlock(Element element) {
        String exp = null;
        NodeList nodes = element.getChildNodes();
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    exp = ((CDATASection)node).getData();
                    continue block5;
                }
                case 1: {
                    continue block5;
                }
                case 7: {
                    continue block5;
                }
            }
        }
        if (exp != null) {
            exp = exp.trim();
        }
        return exp;
    }
}

