/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.rules;

import com.adventnet.cli.CLISession;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.rules.DeviceCommandParser;
import com.adventnet.fa.server.rules.DeviceConnection;
import com.adventnet.fa.server.rules.FwConfigMgmt;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.util.EncryptionAPI;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuleFetcherTask
implements Task {
    private static final Logger LOGGER = Logger.getLogger(RuleFetcherTask.class.getName());
    private DataObject obj = null;
    private DeviceConnection dCon = DeviceConnection.getInstance();
    private DeviceCommandParser dcp = DeviceCommandParser.getInstance();
    List complianceCmds = new ArrayList();
    private String startupConfigData = null;
    private String runningConfigData = null;
    private EncryptionAPI encryptionObj = EncryptionAPI.getEncryptionObj();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask(TaskContext context) {
        block34: {
            String errMsg;
            boolean gotException;
            Long baseRID;
            CLISession cli;
            DataObject doo;
            block33: {
                String dummyKey;
                String rules = null;
                doo = null;
                cli = null;
                Long rID = null;
                baseRID = null;
                String tempResName = null;
                Properties prop = null;
                gotException = false;
                errMsg = null;
                try {
                    doo = this.getDO(context);
                    boolean isDIPBased = doo.getTableNames().contains("DIPToResourcesMapping");
                    prop = !isDIPBased ? this.dCon.getPropertiesFromDO(doo) : this.dCon.getPropertiesFromDO(doo, "DIPCredentials");
                    String mode = prop.getProperty("mode");
                    String deviceType = prop.getProperty("deviceType");
                    baseRID = rID = new Long(prop.getProperty("resourceID"));
                    tempResName = (String)LaCacheManager.getInstance().getResourceName(rID);
                    LOGGER.info("RuleFetcherTask::::::: Executing task for the resource ::: " + (String)LaCacheManager.getInstance().getResourceName(rID) + " with RID :::" + rID);
                    List vdomDevicesList = FAServerUtil.getVdomDevicesList();
                    String ipAddress = (String)doo.getFirstValue("Resources", "IPADDRESS");
                    boolean isVdom = vdomDevicesList.contains(ipAddress);
                    cli = this.dCon.createSession(prop);
                    if (isVdom) {
                        Iterator itr = doo.getRows("DDSchedules");
                        while (itr.hasNext()) {
                            try {
                                Row ddSchRow = (Row)itr.next();
                                rID = (Long)ddSchRow.get("RID");
                                String vdomName = (String)LaCacheManager.getInstance().getResourceName(rID);
                                prop.put("vdomName", vdomName);
                                Long schID = (Long)ddSchRow.get("SCHEDULEID");
                                if ("true".equals(prop.getProperty("fetchRules", "false"))) {
                                    LOGGER.log(Level.FINE, " Handling rules fetching for UnUsed Rules Report....");
                                    LOGGER.log(Level.FINE, " RuleFetcherTask :::::::::::::::::: device type is :::::: {0} ", deviceType);
                                    rules = this.dCon.fetchRules(prop, cli, Boolean.TRUE);
                                    this.dCon.setEnableModeStatus(cli, Boolean.TRUE);
                                    Map rulesVsDescription = this.dCon.parseRules(rules, deviceType, rID);
                                    DataAccess.delete((Criteria)new Criteria(new Column("DeviceRules", "RID"), (Object)rID, 0));
                                    Long frid = (Long)doo.getFirstValue("DeviceDetails", "DDID");
                                    this.dCon.updateDB(rID, frid, rulesVsDescription);
                                    LOGGER.log(Level.FINE, " RuleFetcherTask.RuleHandling Completed for resID::{0}", rID);
                                }
                                if ("true".equals(prop.getProperty("genCompRpt", "false"))) {
                                    LOGGER.log(Level.FINE, " About to call RuleFetcherTask's handleComplianceReportGeneration() method ");
                                    this.handleComplianceReportGeneration(prop, deviceType, rID, cli, isVdom);
                                    this.dCon.setEnableModeStatus(cli, Boolean.TRUE);
                                    LOGGER.log(Level.FINE, " RuleFetcherTask.handleComplianceReportGeneration() Completed for resID:::{0}", rID);
                                }
                                if (!"true".equals(prop.getProperty("genConfMgmtReport", "false"))) continue;
                                LOGGER.log(Level.FINE, " About to execute RuleFetcherTask's change management related for resID:::{0}", rID);
                                FwConfigMgmt confMgmt = FwConfigMgmt.getInstance();
                                Long maxVersion = new Long(0L);
                                if ("Cisco".equals(deviceType)) {
                                    LOGGER.log(Level.FINE, " It is Cisco Device and hence executing startup config related stuff....");
                                    maxVersion = confMgmt.getMaxConfigVersion(rID, "startup");
                                    this.complianceCmds = this.dcp.getVdomStartupComplianceCommands(deviceType);
                                    this.startupConfigData = this.dCon.reteriveConfigurationData(prop, "auto", this.complianceCmds, rID, "startup", Boolean.TRUE, cli, Boolean.TRUE);
                                    this.dCon.setEnableModeStatus(cli, Boolean.TRUE);
                                    if (this.startupConfigData != null) {
                                        if (maxVersion > 0L) {
                                            confMgmt.checkInNewVersionIfDiffExists(this.startupConfigData, rID, "startup", "N/A", prop, Boolean.FALSE, maxVersion);
                                        } else {
                                            this.insertWithOutDiff(this.startupConfigData, rID, "startup");
                                        }
                                    }
                                }
                                maxVersion = confMgmt.getMaxConfigVersion(rID, "running");
                                this.complianceCmds = this.dcp.getVdomRunningComplianceCommands(deviceType);
                                this.runningConfigData = this.dCon.reteriveConfigurationData(prop, "auto", this.complianceCmds, rID, "running", Boolean.TRUE, cli, Boolean.TRUE);
                                this.dCon.setEnableModeStatus(cli, Boolean.TRUE);
                                if (this.runningConfigData == null) continue;
                                if (maxVersion > 0L) {
                                    confMgmt.checkInNewVersionIfDiffExists(this.runningConfigData, rID, "running", "N/A", prop, Boolean.FALSE, maxVersion);
                                    continue;
                                }
                                this.insertWithOutDiff(this.runningConfigData, rID, "running");
                                if (!"Cisco".equals(deviceType)) continue;
                                this.handleConflict(this.runningConfigData, this.startupConfigData, rID);
                            }
                            catch (Exception ee) {
                                ee.printStackTrace();
                                gotException = true;
                                errMsg = ee.getMessage();
                                errMsg = errMsg + " for rid::" + rID.toString();
                            }
                        }
                    } else {
                        if (!"2".equals(mode) && "true".equals(prop.getProperty("fetchRules", "false"))) {
                            LOGGER.log(Level.FINE, " Handling rules fetching for UnUsed Rules Report....");
                            LOGGER.log(Level.FINE, " RuleFetcherTask :::::::::::::::::: device type is :::::: {0} ", deviceType);
                            rules = this.dCon.fetchRules(prop, cli, Boolean.FALSE);
                            this.dCon.setEnableModeStatus(cli, Boolean.TRUE);
                            Map rulesVsDescription = this.dCon.parseRules(rules, deviceType, rID);
                            DataAccess.delete((Criteria)new Criteria(new Column("DeviceRules", "RID"), (Object)rID, 0));
                            this.dCon.updateDB(doo, rulesVsDescription);
                            LOGGER.log(Level.FINE, " RuleFetcherTask.RuleHandling Completed ");
                        }
                        if (!"3".equals(mode) && "true".equals(prop.getProperty("genCompRpt", "false"))) {
                            LOGGER.log(Level.FINE, " About to call RuleFetcherTask's handleComplianceReportGeneration() method ");
                            this.handleComplianceReportGeneration(prop, deviceType, rID, cli, isVdom);
                            this.dCon.setEnableModeStatus(cli, Boolean.TRUE);
                            LOGGER.log(Level.FINE, " RuleFetcherTask.handleComplianceReportGeneration() Completed ");
                        }
                        if ("true".equals(prop.getProperty("genConfMgmtReport", "false"))) {
                            LOGGER.log(Level.FINE, " About to execute RuleFetcherTask's change management related ");
                            FwConfigMgmt confMgmt = FwConfigMgmt.getInstance();
                            Long maxVersion = new Long(0L);
                            if ("Cisco".equals(deviceType)) {
                                LOGGER.log(Level.FINE, " It is Cisco Device and hence executing startup config related stuff....");
                                maxVersion = confMgmt.getMaxConfigVersion(rID, "startup");
                                this.complianceCmds = this.dcp.getStartupComplianceCommands(deviceType);
                                this.startupConfigData = this.dCon.reteriveConfigurationData(prop, "auto", this.complianceCmds, rID, "startup", Boolean.TRUE, cli, Boolean.FALSE);
                                this.dCon.setEnableModeStatus(cli, Boolean.TRUE);
                                if (this.startupConfigData != null) {
                                    if (maxVersion > 0L) {
                                        confMgmt.checkInNewVersionIfDiffExists(this.startupConfigData, rID, "startup", "N/A", prop, Boolean.FALSE, maxVersion);
                                    } else {
                                        this.insertWithOutDiff(this.startupConfigData, rID, "startup");
                                    }
                                }
                            }
                            maxVersion = confMgmt.getMaxConfigVersion(rID, "running");
                            this.complianceCmds = this.dcp.getRunningComplianceCommands(deviceType);
                            this.runningConfigData = this.dCon.reteriveConfigurationData(prop, "auto", this.complianceCmds, rID, "running", Boolean.TRUE, cli, Boolean.FALSE);
                            this.dCon.setEnableModeStatus(cli, Boolean.TRUE);
                            if (this.runningConfigData != null) {
                                if (maxVersion > 0L) {
                                    confMgmt.checkInNewVersionIfDiffExists(this.runningConfigData, rID, "running", "N/A", prop, Boolean.FALSE, maxVersion);
                                } else {
                                    this.insertWithOutDiff(this.runningConfigData, rID, "running");
                                    if ("Cisco".equals(deviceType)) {
                                        this.handleConflict(this.runningConfigData, this.startupConfigData, rID);
                                    }
                                }
                            }
                        }
                    }
                    if (prop == null) break block33;
                    dummyKey = baseRID.toString() + prop.getProperty("loginName");
                    LOGGER.fine("@@RuleFetcherTask:::: before closing session, updating the lastFetchTimeMap for the key:::" + dummyKey);
                }
                catch (Exception exp) {
                    LOGGER.log(Level.INFO, " RulesFetcherTask: Got Exception while executing the task for device with RID {0} ", rID);
                    exp.printStackTrace();
                    gotException = true;
                    errMsg = exp.getMessage();
                    break block34;
                }
                finally {
                    if (prop != null) {
                        String dummyKey2 = baseRID.toString() + prop.getProperty("loginName");
                        LOGGER.fine("@@RuleFetcherTask:::: before closing session, updating the lastFetchTimeMap for the key:::" + dummyKey2);
                        FwConfigMgmt.updateConfigFetcherMap(dummyKey2);
                    }
                    this.dCon.cleanUp(cli, baseRID);
                    if (gotException) {
                        this.updateStatus(doo, -1, errMsg);
                    } else {
                        this.updateStatus(doo, 1, null);
                    }
                    LOGGER.log(Level.INFO, " RulesFetcherTask: Task completed for device with RID {0} ", baseRID);
                }
                FwConfigMgmt.updateConfigFetcherMap(dummyKey);
            }
            this.dCon.cleanUp(cli, baseRID);
            if (gotException) {
                this.updateStatus(doo, -1, errMsg);
            } else {
                this.updateStatus(doo, 1, null);
            }
            LOGGER.log(Level.INFO, " RulesFetcherTask: Task completed for device with RID {0} ", baseRID);
        }
    }

    private void insertWithOutDiff(String configData, Long rID, String configType) throws Exception {
        String encryptedConfigFile = this.encryptionObj.encryptLog(configData);
        ByteArrayInputStream is = new ByteArrayInputStream(encryptedConfigFile.getBytes("UTF-8"));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = format.format(new Date());
        long time = format.parse(date).getTime();
        Timestamp timestamp = new Timestamp(time);
        Row confRow = new Row("ConfigVersions");
        confRow.set("VERSION_NO", (Object)new Long(1L));
        confRow.set("RID", (Object)rID);
        confRow.set("FILE_CONTENTS", (Object)is);
        confRow.set("CHANGED_BY", (Object)"N/A");
        confRow.set("ANNOTATION", (Object)"-");
        confRow.set("CONFIG_TYPE", (Object)configType);
        confRow.set("MODIFIED_TIME", (Object)timestamp);
        confRow.set("DIFF_CONTENTS", (Object)"-");
        confRow.set("DIFF_COUNT", (Object)new Integer(0));
        DataObject confDo = DataAccess.constructDataObject();
        confDo.addRow(confRow);
        DataAccess.add((DataObject)confDo);
        Row latestConfRow = new Row("LatestConfig");
        latestConfRow.set("RID", (Object)rID);
        latestConfRow.set("VERSION_NO", (Object)new Long(1L));
        latestConfRow.set("CONFIG_TYPE", (Object)configType);
        DataObject doo = DataAccess.constructDataObject();
        doo.addRow(latestConfRow);
        DataAccess.add((DataObject)doo);
    }

    private void handleConflict(String runningConfig, String startupConfig, Long rID) throws Exception {
        HashMap conflictContents;
        byte[] startupContents = this.startupConfigData.getBytes();
        byte[] runningContents = this.runningConfigData.getBytes();
        FwConfigMgmt confMgmt = FwConfigMgmt.getInstance();
        boolean conflictExists = confMgmt.checkForDiff(conflictContents = confMgmt.getDiff(startupContents, runningContents, "Cisco"));
        if (conflictExists) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String date = format.format(new Date());
            long time = format.parse(date).getTime();
            Timestamp timestamp = new Timestamp(time);
            String conflictContentData = confMgmt.getDiffContentsOnly(conflictContents);
            String[] dbContents = conflictContentData.split("<->");
            String dbDiffContents = dbContents[0];
            String diffCount = dbContents[1];
            int tempCount = Integer.parseInt(diffCount);
            Integer diff_count = new Integer(tempCount);
            try {
                DataObject conflictDO = DataAccess.constructDataObject();
                Row conflictRow = new Row("StartupRunningConflict");
                conflictRow.set("RID", (Object)rID);
                conflictRow.set("STARTUP_VNO", (Object)new Long(1L));
                conflictRow.set("RUNNING_VNO", (Object)new Long(1L));
                conflictRow.set("CHANGED_BY", (Object)"N/A");
                conflictRow.set("ANNOTATION", (Object)"-");
                conflictRow.set("MODIFIED_TIME", (Object)timestamp);
                conflictRow.set("DIFF_CONTENTS", (Object)dbDiffContents);
                conflictRow.set("DIFF_COUNT", (Object)diff_count);
                conflictDO.addRow(conflictRow);
                DataAccess.add((DataObject)conflictDO);
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "*** Exception while putting an entry in conflict table as conflict table has an entry with resourceID--->" + rID);
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleComplianceReportGeneration(Properties prop, String deviceType, Long rID, CLISession cli, Boolean isVdom) {
        FileOutputStream fOut = null;
        try {
            String resourceID = rID.toString();
            String configData = "";
            if (isVdom.booleanValue()) {
                this.complianceCmds = this.dcp.getVdomRunningComplianceCommands(deviceType);
                configData = this.dCon.reteriveConfigurationData(prop, "auto", this.complianceCmds, rID, "running", Boolean.FALSE, cli, Boolean.TRUE);
            } else {
                this.complianceCmds = this.dcp.getRunningComplianceCommands(deviceType);
                configData = this.dCon.reteriveConfigurationData(prop, "auto", this.complianceCmds, rID, "running", Boolean.FALSE, cli, Boolean.FALSE);
            }
            String dirPath = System.getProperty("server.home") + File.separator + "server" + File.separator + "configData" + File.separator + resourceID;
            String resourceName = LaCacheManager.getInstance().getResourceName(resourceID);
            String fileName = resourceName + "_ConfigFile.txt";
            String storagePath = dirPath + File.separator + fileName;
            File f = new File(dirPath, fileName);
            if (!f.exists()) {
                LOGGER.log(Level.INFO, " DeviceConnection: File does not exists ... creating new one .... !!");
                new File(dirPath).mkdirs();
                f.createNewFile();
            }
            fOut = new FileOutputStream(f, false);
            fOut.write(configData.getBytes());
            if (fOut != null) {
                fOut.close();
            }
            LOGGER.log(Level.FINE, " RuleFetcherTask :::: Configuration data for the device stored @ location :::: {0} ", storagePath);
            this.dCon.generateComplianceReport(storagePath, rID);
            LOGGER.log(Level.FINE, " RuleFetcherTask.generateComplianceReport() Completed .... !!!");
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (fOut != null) {
                    fOut.close();
                }
            }
            catch (Exception exp) {
                fOut = null;
            }
        }
    }

    private DataObject getDO(TaskContext context) throws Exception {
        DataObject tInput = context.getTaskInputDO();
        Row row = tInput.getFirstRow("Task_Input");
        Long scheduleId = (Long)row.get("SCHEDULE_ID");
        SelectQueryImpl sql = new SelectQueryImpl(new Table("DDSchedules"));
        String[] frsVsfriCol = new String[]{"DDID"};
        Join frsVsfri = new Join("DDSchedules", "DeviceDetails", frsVsfriCol, frsVsfriCol, 2);
        Join friVsDC = new Join("DeviceDetails", "DeviceCredentials", frsVsfriCol, frsVsfriCol, 1);
        Join friVsResources = new Join("DeviceDetails", "Resources", new String[]{"RID"}, new String[]{"RESOURCEID"}, 1);
        Join friVsDDNotifications = new Join("DeviceDetails", "DDNotifications", frsVsfriCol, frsVsfriCol, 1);
        String[] jCols = new String[]{"RID"};
        Join ddToMappingTable = new Join("DeviceDetails", "DIPToResourcesMapping", frsVsfriCol, frsVsfriCol, 1);
        String[] jCols_1 = new String[]{"DIPID"};
        Join dipToMappingTable = new Join("DIPToResourcesMapping", "DeviceInfoProfiles", jCols_1, jCols_1, 1);
        Join dpcToMappingTable = new Join("DeviceInfoProfiles", "DIPCredentials", jCols_1, jCols_1, 1);
        sql.addJoin(frsVsfri);
        sql.addJoin(friVsDC);
        sql.addJoin(friVsResources);
        sql.addJoin(friVsDDNotifications);
        sql.addJoin(ddToMappingTable);
        sql.addJoin(dipToMappingTable);
        sql.addJoin(dpcToMappingTable);
        sql.addSelectColumn(new Column("DDSchedules", "*"));
        sql.addSelectColumn(new Column("Resources", "*"));
        sql.addSelectColumn(new Column("DeviceDetails", "*"));
        sql.addSelectColumn(new Column("DeviceCredentials", "*"));
        sql.addSelectColumn(new Column("DDNotifications", "*"));
        sql.addSelectColumn(new Column("DIPToResourcesMapping", "*"));
        sql.addSelectColumn(new Column("DeviceInfoProfiles", "*"));
        sql.addSelectColumn(new Column("DIPCredentials", "*"));
        sql.setCriteria(new Criteria(new Column("DDSchedules", "SCHEDULEID"), (Object)scheduleId, 0));
        return DataAccess.get((SelectQuery)sql);
    }

    private void updateStatus(DataObject doo, int status, String errorMsg) {
        try {
            Row fri = doo.getFirstRow("DeviceDetails");
            fri.set("ERRORSTRING", (Object)errorMsg);
            fri.set("STATUS", (Object)new Integer(status));
            fri.set("LAST_UPDATED_ON", (Object)new Timestamp(System.currentTimeMillis()));
            doo.updateRow(fri);
            DataAccess.update((DataObject)doo);
        }
        catch (DataAccessException dExp) {
            dExp.printStackTrace();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public void stopTask() {
    }
}

