/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.fa.server.FACacheManager;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.la.util.ServerUtil;
import com.adventnet.mfw.bean.BeanUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.taskengine.Scheduler;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AFConfManager {
    private static ResourceBundle rb = ProductBundle.getInstance().getBundle();
    private static HashMap scheduleIdMap = new HashMap();
    private static Pattern findPattern = null;
    private static String mailString = null;
    private static String smsString = null;
    private static Pattern timePattern = null;
    private static HashMap notiTimeMap = new HashMap();
    private static HashMap calendarTimeMap = new HashMap();
    static Scheduler scheduler = null;

    public static synchronized void addScheduledProfile(DataObject obj, Object scheduleId) {
        scheduleIdMap.put(scheduleId, obj);
    }

    public static synchronized void deleteScheduledProfile(Object scheduleId) {
        scheduleIdMap.remove(scheduleId);
    }

    public static synchronized void deleteAnomalyProfile(String filterName) {
        try {
            Iterator iter = scheduleIdMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                DataObject obj = (DataObject)entry.getValue();
                String fName = (String)obj.getFirstValue("AnomalyFilters", "FILTER_NAME");
                if (!filterName.equals(fName)) continue;
                iter.remove();
                AFConfManager.removeCalendarTimeVal(fName);
                return;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static synchronized void deleteAnomalyProfile(Long afid) {
        try {
            Iterator iter = scheduleIdMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                DataObject obj = (DataObject)entry.getValue();
                Long id = (Long)obj.getFirstValue("AnomalyFilters", "AF_ID");
                if (!id.equals(afid)) continue;
                iter.remove();
                String fName = (String)obj.getFirstValue("AnomalyFilters", "FILTER_NAME");
                AFConfManager.removeCalendarTimeVal(fName);
                return;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static synchronized DataObject getAnomalyProfile(Long afid) {
        DataObject result = AFConfManager.findAnomalyProfile(afid, "AF_ID");
        if (result == null) {
            Criteria fCrit = new Criteria(new Column("AnomalyFilters", "AF_ID"), (Object)afid, 0);
            result = AFConfManager.loadAnomalyObject(fCrit);
        }
        return result;
    }

    public static synchronized DataObject getAnomalyProfile(String name) {
        DataObject result = AFConfManager.findAnomalyProfile(name, "FILTER_NAME");
        if (result == null) {
            Criteria fCrit = new Criteria(new Column("AnomalyFilters", "FILTER_NAME"), (Object)name, 0);
            result = AFConfManager.loadAnomalyObject(fCrit);
        }
        return result;
    }

    private static DataObject findAnomalyProfile(Object toBeChecked, String colName) {
        try {
            for (Map.Entry entry : scheduleIdMap.entrySet()) {
                DataObject obj = (DataObject)entry.getValue();
                Object result = obj.getFirstValue("AnomalyFilters", colName);
                if (!toBeChecked.equals(result)) continue;
                return obj;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return null;
    }

    public static synchronized DataObject getScheduledProfile(Object scheduleId) {
        DataObject result = (DataObject)scheduleIdMap.get(scheduleId);
        if (result == null) {
            Criteria fCrit = new Criteria(new Column("Schedule", "SCHEDULE_ID"), scheduleId, 0);
            result = AFConfManager.loadAnomalyObject(fCrit);
        }
        return result;
    }

    private static DataObject loadAnomalyObject(Criteria crit) {
        Table ent = new Table("Schedule");
        SelectQueryImpl selectquery = new SelectQueryImpl(ent);
        selectquery.addSelectColumn(new Column("Schedule", "*"));
        selectquery.setCriteria(crit);
        Column selectAtt = new Column("AnomalyFilters", "*");
        selectquery.addSelectColumn(selectAtt);
        Column selectAtt2 = new Column("AF2Criteria", "*");
        selectquery.addSelectColumn(selectAtt2);
        Column selectAtt3 = new Column("LACriteria", "*");
        selectquery.addSelectColumn(selectAtt3);
        Column selectAtt4 = new Column("LACriteria2Expressions", "*");
        selectquery.addSelectColumn(selectAtt4);
        Column selectAtt5 = new Column("LAExpression", "*");
        selectquery.addSelectColumn(selectAtt5);
        Column selectAtt6 = new Column("AFToMailSettings", "*");
        selectquery.addSelectColumn(selectAtt6);
        Column selectAtt7 = new Column("MailSettings", "*");
        selectquery.addSelectColumn(selectAtt7);
        Column selectAtt8 = new Column("AFToScriptSettings", "*");
        selectquery.addSelectColumn(selectAtt8);
        Column selectAtt9 = new Column("ScriptSettings", "*");
        selectquery.addSelectColumn(selectAtt9);
        Column selectAtt10 = new Column("AFToSmsSettings", "*");
        selectquery.addSelectColumn(selectAtt10);
        Column selectAtt11 = new Column("SmsSettings", "*");
        selectquery.addSelectColumn(selectAtt11);
        selectquery.addJoin(new Join("Schedule", "AnomalyFilters", new String[]{"SCHEDULE_NAME"}, new String[]{"FILTER_NAME"}, 2));
        selectquery.addJoin(new Join("AnomalyFilters", "AF2Criteria", new String[]{"AF_ID"}, new String[]{"AF_ID"}, 2));
        selectquery.addJoin(new Join("AF2Criteria", "LACriteria", new String[]{"CRIT_ID"}, new String[]{"CRIT_ID"}, 2));
        selectquery.addJoin(new Join("LACriteria", "LACriteria2Expressions", new String[]{"CRIT_ID"}, new String[]{"CRIT_ID"}, 2));
        selectquery.addJoin(new Join("LACriteria2Expressions", "LAExpression", new String[]{"EXP_ID"}, new String[]{"EXP_ID"}, 2));
        selectquery.addJoin(new Join("AnomalyFilters", "AFToMailSettings", new String[]{"AF_ID"}, new String[]{"AF_ID"}, 1));
        selectquery.addJoin(new Join("AFToMailSettings", "MailSettings", new String[]{"MAILSETTINGSID"}, new String[]{"MAILSETTINGSID"}, 1));
        selectquery.addJoin(new Join("AnomalyFilters", "AFToScriptSettings", new String[]{"AF_ID"}, new String[]{"AF_ID"}, 1));
        selectquery.addJoin(new Join("AFToScriptSettings", "ScriptSettings", new String[]{"SCRIPTID"}, new String[]{"SCRIPTID"}, 1));
        selectquery.addJoin(new Join("AnomalyFilters", "AFToSmsSettings", new String[]{"AF_ID"}, new String[]{"AF_ID"}, 1));
        selectquery.addJoin(new Join("AFToSmsSettings", "SmsSettings", new String[]{"SMSSETTINGSID"}, new String[]{"SMSSETTINGSID"}, 1));
        try {
            String query = RelationalAPI.getInstance().getSelectSQL((Query)selectquery);
        }
        catch (Exception ee) {
            // empty catch block
        }
        try {
            DataObject result = DataAccess.get((SelectQuery)selectquery);
            if (result != null) {
                if (result.containsTable("Schedule")) {
                    Object scheduleId = result.getFirstValue("Schedule", "SCHEDULE_ID");
                    scheduleIdMap.put(scheduleId, result);
                }
                return result;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return null;
    }

    public static synchronized void deleteFromDB(String profileName) throws Exception {
        AFConfManager.deleteAnomalyProfile(profileName);
        Criteria cr = new Criteria(new Column("AnomalyFilters", "FILTER_NAME"), (Object)profileName, 0);
        FAServerUtil.getPersistence().delete(cr);
        AFConfManager.getScheduler().unscheduleTask(profileName, "AFWorkFlow");
        Criteria crt = new Criteria(new Column("Schedule", "SCHEDULE_NAME"), (Object)profileName, 0);
        DataAccess.delete((String)"Schedule", (Criteria)crt);
        AFConfManager.deleteLastOccurCount(profileName);
    }

    public static synchronized void deleteFromDB(Long afid) throws Exception {
        DataObject obj = AFConfManager.getAnomalyProfile(afid);
        String scheduleName = obj.getFirstValue("AnomalyFilters", "FILTER_NAME").toString();
        AFConfManager.deleteFromDB(scheduleName);
    }

    private static Scheduler getScheduler() throws Exception {
        if (scheduler == null) {
            scheduler = (Scheduler)BeanUtil.lookup((String)"Scheduler");
        }
        return scheduler;
    }

    public static void changeAnomalyStatus(Long afid, boolean newValue) throws Exception {
        DataObject obj = AFConfManager.getAnomalyProfile(afid);
        boolean currentValue = (Boolean)obj.getFirstValue("AnomalyFilters", "ENABLED");
        String scheduleName = obj.getFirstValue("AnomalyFilters", "FILTER_NAME").toString();
        if (currentValue != newValue) {
            UpdateQueryImpl query = new UpdateQueryImpl("AnomalyFilters");
            query.setUpdateColumn("ENABLED", (Object)new Boolean(newValue));
            Criteria cr = new Criteria(new Column("AnomalyFilters", "AF_ID"), (Object)afid, 0);
            query.setCriteria(cr);
            DataAccess.update((UpdateQuery)query);
            int adminStatus = 3;
            if (!newValue) {
                adminStatus = 4;
            }
            AFConfManager.getScheduler().setScheduledTaskAdminStatus(scheduleName, "AFWorkFlow", adminStatus);
        }
        AFConfManager.deleteAnomalyProfile(afid);
    }

    public static void fillFromLAExpression(StringBuffer resources, StringBuffer criteria, DataObject obj) {
        try {
            HashMap<String, StringBuffer> props = new HashMap<String, StringBuffer>();
            HashMap<String, String> conditions = new HashMap<String, String>();
            Iterator iter = obj.getRows("LAExpression");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                String colName = (String)row.get("COLUMN_NAME");
                String comp = (String)row.get("COMPARATOR");
                String value = (String)row.get("VALUE");
                if ("RID".equals(colName)) {
                    String fwName = FACacheManager.getInstance().getDisplayName(new Long(value));
                    if (fwName == null) {
                        fwName = value;
                    }
                    resources.append(fwName.toString());
                    resources.append(",");
                    continue;
                }
                StringBuffer temp = (StringBuffer)props.get(colName);
                if (temp == null) {
                    temp = new StringBuffer(value);
                    props.put(colName, temp);
                } else {
                    temp.append(",");
                    temp.append(value);
                }
                conditions.put(colName, comp);
            }
            for (Map.Entry entry : props.entrySet()) {
                String key = (String)entry.getKey();
                String dummy_key = null;
                try {
                    dummy_key = rb.getString("Anomaly.Criteria." + key);
                }
                catch (Exception e) {
                    dummy_key = key;
                }
                criteria.append(dummy_key);
                criteria.append(" ");
                criteria.append((String)conditions.get(key));
                criteria.append(" ");
                criteria.append(entry.getValue().toString());
                criteria.append("<br>");
            }
            if (resources.length() == 0) {
                String dummy_device = null;
                try {
                    dummy_device = rb.getString("Anomaly.Devices.All Devices");
                    resources.append(dummy_device);
                }
                catch (Exception e) {
                    resources.append(" All Devices ");
                }
            } else {
                resources.deleteCharAt(resources.length() - 1);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static String getTimeString(String unit, String queryInterval) {
        Matcher m;
        StringBuffer buffer = new StringBuffer(" " + rb.getString("Search.Between") + " ");
        if (timePattern == null) {
            timePattern = Pattern.compile("(\\d+)\\s+(\\S+)");
        }
        if ((m = timePattern.matcher(unit)).find()) {
            int number = Integer.parseInt(m.group(1));
            String string = m.group(2);
            AFConfManager.prepareTimeString(rb, queryInterval, number, string, buffer);
        } else if (unit.indexOf("This") > -1) {
            AFConfManager.prepareTimeString(rb, queryInterval, -1, unit, buffer);
        }
        return buffer.toString();
    }

    private static void prepareTimeString(ResourceBundle rb, String queryInterval, int thresholdNumber, String thresholdString, StringBuffer buffer) {
        SimpleDateFormat format = new SimpleDateFormat("EEE d MMM yyyy HH:mm");
        GregorianCalendar cal = new GregorianCalendar();
        String endTime = format.format(cal.getTime());
        if (thresholdString.indexOf("This Week") > -1) {
            cal.set(7, 1);
            AFConfManager.tuneCalendarTime(cal);
        } else if (thresholdString.indexOf("This Month") > -1) {
            cal.set(5, 1);
            AFConfManager.tuneCalendarTime(cal);
        } else if (thresholdString.indexOf("Day") > -1) {
            ((Calendar)cal).add(5, -thresholdNumber);
        } else {
            int seconds = (int)AFConfManager.getTimeLong(queryInterval) / 1000;
            if (seconds <= 1800) {
                ((Calendar)cal).add(13, -seconds);
                endTime = format.format(cal.getTime());
            }
            ((Calendar)cal).add(10, -thresholdNumber);
        }
        String startTime = format.format(cal.getTime());
        buffer.append(startTime);
        buffer.append(" " + rb.getString("DWS.And") + " ");
        buffer.append(endTime);
    }

    private static void tuneCalendarTime(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
    }

    public static long getTimeLong(String unit) {
        if (timePattern == null) {
            timePattern = Pattern.compile("(\\d+)\\s+(\\S+)");
        }
        Matcher m = timePattern.matcher(unit);
        long result = 0L;
        if (m.find()) {
            int number = Integer.parseInt(m.group(1));
            String string = m.group(2);
            if (string.indexOf("Min") > -1) {
                result = (long)(number * 60) * 1000L;
            } else if (string.indexOf("Hour") > -1) {
                result = (long)(number * 3600) * 1000L;
            } else if (string.indexOf("Day") > -1) {
                result = (long)(number * 86400) * 1000L;
            }
        }
        return result;
    }

    public static Integer getLastOccurCount(Object scheduleName) {
        Integer occurCount = (Integer)notiTimeMap.get(scheduleName);
        if (occurCount == null) {
            return new Integer(1);
        }
        return occurCount;
    }

    public static void putLastOccurCount(Object scheduleName, Integer occurCount) {
        notiTimeMap.put(scheduleName, occurCount);
    }

    public static void deleteLastOccurCount(Object scheduleName) {
        notiTimeMap.remove(scheduleName);
    }

    public static void putCalendarTimeVal(Object scheduleName, Integer calendarVal) {
        calendarTimeMap.put(scheduleName, calendarVal);
    }

    public static void removeCalendarTimeVal(Object scheduleName) {
        calendarTimeMap.remove(scheduleName);
    }

    public static Integer getCalendarTimeVal(Object scheduleName) {
        Integer val = calendarTimeMap.get(scheduleName) != null ? (Integer)calendarTimeMap.get(scheduleName) : Integer.valueOf(-1);
        return val;
    }

    public static boolean doNotify(DataObject taskDataObj) {
        block5: {
            try {
                String[] valArr;
                Row anomalyFilterRow = taskDataObj.getRow("AnomalyFilters");
                Object filterId = anomalyFilterRow.get("AF_ID");
                String advNotifierVal = (String)anomalyFilterRow.get("ADV_NOTIFIER");
                String notiWaitTime = null;
                long nextNotiTime = -1L;
                if (advNotifierVal == null || (valArr = advNotifierVal.split("_")).length != 2) break block5;
                notiWaitTime = valArr[0];
                nextNotiTime = Long.parseLong(valArr[1]);
                if (System.currentTimeMillis() > nextNotiTime) {
                    try {
                        nextNotiTime = ServerUtil.calculateNextNotificationTime((String)notiWaitTime);
                        anomalyFilterRow.set("ADV_NOTIFIER", (Object)(notiWaitTime + "_" + nextNotiTime));
                        taskDataObj.updateRow(anomalyFilterRow);
                        DataAccess.update((DataObject)taskDataObj);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

