/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.persistence.DataAccessException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FirewallSequenceGenerator {
    private static final Logger LOGGER = Logger.getLogger(FirewallSequenceGenerator.class.getName());
    protected int batchSize = 100000;
    protected long currentPointer = 0L;
    private String tableName;
    private String columnName;
    private String query;
    private String metaTableQu;
    private String masterquery = "select max(toBeReplacedColName) as MAXID from toBeReplacedTableName";
    private String metaTableQuery = "select lookup_tablename from MetaTable where lookup_tablename like 'toBeReplacedTableName_%' order by start_time";
    private String cruncherQuery = "select cruncher_pointer as MAXID from CruncherState where table_name='toBeReplacedTableName'";
    private RelationalAPI api = RelationalAPI.getInstance();

    public FirewallSequenceGenerator(String tableName, String columnName) {
        try {
            this.tableName = tableName;
            this.columnName = columnName;
            this.query = this.masterquery.replaceAll("toBeReplacedTableName", tableName);
            this.cruncherQuery = this.cruncherQuery.replaceAll("toBeReplacedTableName", tableName);
            this.query = this.query.replaceAll("toBeReplacedColName", columnName);
            this.metaTableQu = this.metaTableQuery.replaceAll("toBeReplacedTableName", tableName);
            this.setCurrentPointer(this.findMax());
            LOGGER.log(Level.INFO, "setting the pk ID for " + this.tableName + "---->" + this.currentPointer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setCurrentPointer(long currentPointer) {
        this.currentPointer = currentPointer;
    }

    public synchronized long getNext() {
        return this.currentPointer++;
    }

    private void triggerUpdate() {
    }

    private long findMax() throws DataAccessException {
        long maxid = 0L;
        long collectorID = -1L;
        try {
            maxid = this.getId(this.query);
            if (maxid == 0L) {
                maxid = this.checkForMetaTableEntry(this.tableName);
            }
            maxid = maxid > (collectorID = this.getId(this.cruncherQuery)) ? maxid : collectorID;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return maxid + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long checkForMetaTableEntry(String tableName) {
        String lookuptableName1 = null;
        long checkLatest1 = 0L;
        long maxid = 0L;
        ResultSet set = null;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.api.getConnection();
            stmt = conn.createStatement();
            set = this.getDbSet(this.metaTableQu, conn, stmt);
            while (set.next()) {
                String lookuptableName = set.getString("lookup_tablename");
                long checkLatest = new Long(lookuptableName.substring(lookuptableName.indexOf("_") + 1));
                if (checkLatest <= checkLatest1) continue;
                lookuptableName1 = lookuptableName;
                checkLatest1 = checkLatest;
            }
            if (lookuptableName1 != null) {
                String metaQuery = this.masterquery.replaceAll("toBeReplacedTableName", lookuptableName1);
                metaQuery = metaQuery.replaceAll("toBeReplacedColName", this.columnName);
                maxid = this.getId(metaQuery);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                set.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return maxid;
    }

    private ResultSet getDbSet(String query, Connection conn, Statement stmt) throws Exception {
        ResultSet set = null;
        try {
            set = stmt.executeQuery(query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getId(String query) throws Exception {
        long maxid = 0L;
        ResultSet set = null;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.api.getConnection();
            stmt = conn.createStatement();
            set = this.getDbSet(query, conn, stmt);
            ResultSetMetaData rsmd = set.getMetaData();
            while (set.next()) {
                maxid = set.getLong("MAXID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                set.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return maxid;
    }

    public static void main(String[] args) {
        FirewallSequenceGenerator fsg = new FirewallSequenceGenerator("FirewallRecords", "LRID");
    }
}

