/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.mfw.ConsoleOut;
import com.adventnet.mfw.Server;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class FirewallStartupChecker
extends Server {
    public void startServer(Properties startupNotifyProps) throws Throwable {
        this.CheckEnterpriseStartup();
        super.startServer(startupNotifyProps);
    }

    private void CheckEnterpriseStartup() {
        String homeDir = System.getProperty("server.home");
        File f = new File(homeDir, "enterprise.txt");
        if (f.exists()) {
            this.checkForError(homeDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForError(String fileLoc) {
        FileInputStream fIn = null;
        try {
            String serverType;
            File enterpriseFile = new File(fileLoc, "enterprise.txt");
            if (!enterpriseFile.exists()) {
                ConsoleOut.println((String)"Configuration file for Enterprise Edition doesn't exists. Hence quitting !!");
                System.exit(1);
            }
            fIn = new FileInputStream(enterpriseFile);
            Properties prop = new Properties();
            prop.load(fIn);
            if (prop.size() == 0) {
                ConsoleOut.println((String)"Enterprise Edition: Problem while loading properties from configuration file.");
                System.exit(1);
            }
            if ("AS".equals(serverType = prop.getProperty("server.type"))) {
                return;
            }
            String error = prop.getProperty("error");
            String startID = prop.getProperty("server.startidrange");
            String deleted = prop.getProperty("isDeleted");
            if (deleted != null) {
                this.printReregisterDetails(fileLoc);
            }
            if (error != null || startID == null) {
                this.printErrorDetails(fileLoc, error);
            }
        }
        catch (FileNotFoundException fExp) {
            this.printErrorDetails(fileLoc);
        }
        catch (IOException ioExp) {
            ConsoleOut.println((String)"Enterprise Edition: Unable to load properties from configuration file.");
            System.exit(1);
        }
        finally {
            try {
                if (fIn != null) {
                    fIn.close();
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
    }

    private void printErrorDetails(String fileLoc) {
        this.printErrorDetails(fileLoc, null);
    }

    private void printErrorDetails(String fileLoc, String errorMsg) {
        StringBuffer sb = new StringBuffer("Enterprise Edition: Problem encountered while registering with Admin Server. ");
        sb.append("Kindly execute ");
        if ("Database Type mismatch unable to register".equals(errorMsg)) {
            sb.append(fileLoc + File.separator + "tools" + File.separator + "changeDBServer.bat");
            sb.append(" to change the required database type and execute ");
        }
        sb.append(fileLoc + File.separator + "troubleshooting" + File.separator + "registerWithAdminServer.bat/sh");
        sb.append(" to register with Admin Server again. ");
        ConsoleOut.println((String)sb.toString());
        System.exit(1);
    }

    private void printReregisterDetails(String fileLoc) {
        StringBuffer sb = new StringBuffer("You have deleted this server from Admin Server collector settings.\n To start data collection again, kindly execute ");
        sb.append(fileLoc + File.separator + "bin" + File.separator + "reinitializeDB.bat/sh");
        sb.append(" and then execute ");
        sb.append(fileLoc + File.separator + "troubleshooting" + File.separator + "registerWithAdminServer.bat/sh");
        ConsoleOut.println((String)sb.toString());
        System.exit(1);
    }

    private void printUsage() {
        ConsoleOut.println((String)"Usage: java com.adventnet.fa.server.FirewallStartupChecker $HOME_DIR");
        System.exit(1);
    }
}

