/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.fa.server.FACacheManager;
import com.adventnet.fa.server.FAServerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceDetails {
    private static final Logger LOGGER = Logger.getLogger(FACacheManager.class.getName());
    private HashMap<String, String> origVsMod = new HashMap();
    private String physicalDevName = null;
    private String ipAddress = null;

    public ResourceDetails(String ipAddress, String resName, String name) {
        LOGGER.log(Level.INFO, "ResourceDetails:::inside ResourceDetails constr...ip->" + ipAddress + " @nd reeName->" + resName + " @nd physicaldevname is->" + name);
        this.addVdom(resName, name);
        this.setPhysicalDevName(name);
        this.setIPAddress(ipAddress);
    }

    public void addVdom(String resName, String name) {
        LOGGER.log(Level.INFO, "ResourceDetails:::inside addVdom method...resname is:::" + resName + " @nd physicaldevname is:::" + name);
        String origName = resName;
        if (resName.startsWith(name) && !resName.equals(name)) {
            String[] splitValues = resName.split(name + "-");
            origName = splitValues[1];
        }
        this.origVsMod.put(origName, resName);
    }

    public void removeVdom(String resName) {
        LOGGER.log(Level.INFO, "ResourceDetails:::inside removeVdom method...resname is:::" + resName + " @nd physicaldevname is:::" + this.physicalDevName);
        String origName = resName;
        if (resName.startsWith(this.physicalDevName) && !resName.equals(this.physicalDevName)) {
            String[] splitValues = resName.split(this.physicalDevName + "-");
            origName = splitValues[1];
        }
        this.origVsMod.remove(origName);
    }

    public int getResCount() {
        return this.origVsMod.size();
    }

    private void setPhysicalDevName(String name) {
        LOGGER.log(Level.INFO, "ResourceDetails:::inside setting physicaldevname is::" + name);
        this.physicalDevName = name;
    }

    public void setIPAddress(String ipAddress) {
        LOGGER.log(Level.INFO, "ResourceDetails:::inside setting physicaldevip is::" + ipAddress);
        this.ipAddress = ipAddress;
    }

    public String getPhysicalDevName() {
        return this.physicalDevName;
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public String getModResName(String origResName) {
        String modRes = this.origVsMod.get(origResName);
        if (modRes == null) {
            List resList = FAServerUtil.getResList();
            modRes = resList.contains(origResName) ? this.physicalDevName + "-" + origResName : origResName;
        }
        LOGGER.log(Level.FINER, "ResourceDetails:::the origres is:::" + origResName + " @nd the resname returning is:::" + modRes);
        return modRes;
    }
}

