/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.dc.AbstractLogUnifier;
import com.adventnet.fa.server.dc.PIXVPNObject;
import com.adventnet.la.util.FixedHashMap;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PaloaltoUnifier
extends AbstractLogUnifier {
    private static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private static final Logger LOGGER = Logger.getLogger(PaloaltoUnifier.class.getName());
    private static final Integer TYPE = new Integer(34);
    private Pattern vpnPattern = null;
    private Pattern vpnLogoutPattern = null;
    private Map resourceMap = new FixedHashMap(100);

    public PaloaltoUnifier() {
        this.vpnPattern = Pattern.compile("succeeded\\.?\\s*User name:\\s*(\\w*).*Private IP:\\s*(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})");
        this.vpnLogoutPattern = Pattern.compile("released\\.?\\s*User name:\\s*(\\w*).*Private IP:\\s*(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})");
    }

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        boolean badlog;
        String newDate = (String)data.get("DATE_FORMAT");
        if (newDate == null) {
            data.put("DATE_FORMAT", DATE_FORMAT);
        } else {
            data.put("DATE_FORMAT", newDate);
        }
        data.put("SYSLOGIP", host);
        data.put("RESOURCE", host);
        data.put("FW", host);
        data.put("FW_TYPE", "Paloalto");
        data.put("LOG_FORMAT", "Paloalto");
        data.put("rtype", TYPE);
        this.checkPriority(data);
        String[] datum = this.splitLog((String)data.get("CompleteLog"));
        boolean bl = badlog = datum == null || datum.length < 4;
        if (badlog) {
            return null;
        }
        data.put("DATE_STRING", datum[1]);
        this.localTimeHandler(data);
        if ("SYSTEM".equals(datum[3]) && this.handleVPN(data, datum, host)) {
            return null;
        }
        this.localLogHandle(data, datum);
        this.handleBytes(data);
        String[] strtoInt = new String[]{"SRC_PORT", "DEST_PORT", "EVENT_TYPE"};
        this.strToInt(strtoInt, data);
        String[] strtoLong = new String[]{"SENT", "RECEIVED", "DURATION"};
        this.strToLong(strtoLong, data);
        if (data.get("SRC") == null || data.get("DEST") == null) {
            return null;
        }
        return data;
    }

    private void localHandleNull(Hashtable data) {
        if (data.get("SENT") == null) {
            data.put("SENT", new Long(0L));
        }
        if (data.get("RECEIVED") == null) {
            data.put("RECEIVED", new Long(0L));
        }
        if (data.get("DURATION") == null) {
            data.put("DURATION", new Long(0L));
        }
    }

    private String[] splitLog(String log) {
        if (log != null) {
            String[] myTable = log.split(",");
            return myTable;
        }
        return null;
    }

    private String localPriorityHandler(String priorit) {
        if (priorit != null && !"Unknown".equalsIgnoreCase(priorit)) {
            int priority = Integer.parseInt(priorit);
            try {
                priority %= 8;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Integer.toString(priority);
        }
        return null;
    }

    private void handleBytes(Hashtable data) {
        String bytes = (String)data.get("BYTES");
        if (bytes != null) {
            Long byteInfo = Long.valueOf(bytes);
            Long total = Long.valueOf((String)data.get("SENT")) + Long.valueOf((String)data.get("RECEIVED"));
            if (byteInfo < total) {
                data.remove("SENT");
                data.remove("RECEIVED");
                String protoco = (String)data.get("PROTOCOL");
                if ("smtp".equalsIgnoreCase(protoco) || "smtps".equalsIgnoreCase(protoco)) {
                    data.put("SENT", byteInfo);
                } else {
                    data.put("RECEIVED", byteInfo);
                }
            }
        }
    }

    private void localTimeHandler(Hashtable data) {
        try {
            String dateFormat = (String)data.get("DATE_FORMAT");
            String dateString = (String)data.get("DATE_STRING");
            if (dateString != null && dateFormat != null) {
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                if (data.get("NO_YEAR") != null) {
                    GregorianCalendar cal = new GregorianCalendar();
                    int year = cal.get(1);
                    cal.setTime(sdf.parse(dateString));
                    cal.set(1, year);
                    data.put("TIME", new Timestamp(cal.getTime().getTime()));
                } else {
                    long time = sdf.parse(dateString).getTime();
                    Timestamp timeModified = new Timestamp(time);
                    data.put("TIME", timeModified);
                }
            } else {
                long currentTime = System.currentTimeMillis();
                Timestamp currentTimeModified = new Timestamp(currentTime);
                data.put("TIME", currentTimeModified);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void checkPriority(Hashtable data) {
        super.checkPriority(data);
        if (data == null) {
            return;
        }
        try {
            int pri = Integer.parseInt((String)data.get("PRIORITY"));
            if (pri > 7) {
                data.put("PRIORITY", "" + (pri %= 8));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void localLogHandle(Hashtable data, String[] datum) {
        try {
            if ("TRAFFIC".equals(datum[3]) || "THREAT".equals(datum[3])) {
                data.put("SRC", datum[7]);
                data.put("DEST", datum[8]);
                data.put("RULE", datum[11]);
                data.put("SRC_INTERFACE", datum[18]);
                data.put("DST_INTERFACE", datum[19]);
                data.put("USERNAME", datum[12]);
                data.put("TRAN_PORT", datum[14]);
                data.put("SRC_PORT", datum[24]);
                data.put("DEST_PORT", datum[25]);
                if ("allow".equalsIgnoreCase(datum[30]) || "alert".equalsIgnoreCase(datum[30])) {
                    data.put("STATUS", "permit");
                } else {
                    data.put("STATUS", "deny");
                }
                String proto = datum[25] + "/" + datum[29];
                data.put("PROTOCOL", proto);
                data.put("L3_PROTOCOL", datum[29]);
                this.checkForLearnMe(data);
                if (datum[3].equals("TRAFFIC")) {
                    int datumLength = datum.length;
                    data.put("BYTES", datum[31]);
                    data.put("SENT", datum[32]);
                    data.put("RECEIVED", datum[33]);
                    data.put("DURATION", Long.valueOf(datum[36]));
                    data.put("EVENT_TYPE", new Integer(0));
                    data.put("REQUEST", datum[14]);
                    data.put("CATEGORY", datum[37]);
                    data.put("POLICY_ID", datum[37]);
                    if (datum[16] != null && datum[16].toLowerCase().indexOf("vpn") > -1) {
                        data.put("VPN", "SSLVPN");
                        data.put("li", "1");
                        if (datum[12] == null || "".equals(datum[12])) {
                            try {
                                data.put("USERNAME", ((PIXVPNObject)((FixedHashMap)this.resourceMap.get(data.get("RESOURCE"))).get((Object)datum[7])).getUser());
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                    if (datumLength > 41) {
                        data.put("SRC_CNTRY", datum[41]);
                        data.put("DST_CNTRY", datum[42]);
                    }
                } else {
                    String typeCheck = datum[4];
                    if ("url".equalsIgnoreCase(typeCheck)) {
                        int datumLength = datum.length;
                        int falseComma = 33;
                        data.put("EVENT_TYPE", new Integer(6));
                        if (datumLength > 36) {
                            falseComma = 33 + datumLength - 36;
                        }
                        data.put("CATEGORY", datum[falseComma]);
                        data.put("REQUEST", datum[31]);
                    } else if ("virus".equalsIgnoreCase(typeCheck)) {
                        data.put("EVENT_TYPE", new Integer(4));
                        String virus = datum[31];
                        if (virus.indexOf("\"") > -1) {
                            virus = virus.replaceAll("\"", "");
                        }
                        data.put("VIRUS", virus);
                        data.put("RECORD_TYPE", "virus");
                    } else {
                        data.put("EVENT_TYPE", new Integer(3));
                        data.put("RECORD_TYPE", "attack");
                        data.put("VIRUS", datum[31]);
                    }
                    data.put("li", "1");
                }
                this.checkSrcDstInterfaces(data, "FW");
            }
            if ("CONFIG".equals(datum[3])) {
                data.put("SRC", datum[7]);
                data.put("FILENAME", datum[9]);
                data.put("USERNAME", datum[10]);
                data.put("RECORD_TYPE", "mgmt");
                data.put("STATUS", datum[12]);
                data.put("EVENT_TYPE", new Integer(1));
                if ("sucess".equalsIgnoreCase(datum[12]) || "Succeeded".equalsIgnoreCase(datum[12])) {
                    data.put("SUBTYPE", "1");
                } else {
                    data.put("FILENAME", datum[9]);
                    data.put("SUBTYPE", "4");
                }
                data.put("li", "1");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, " Error while Processing Paloalto");
            this.localHandleNull(data);
        }
    }

    private boolean handleVPN(Hashtable data, String[] datum, String host) {
        block7: {
            try {
                this.handleDoubleQuotes(datum, 14);
                Matcher matcher = this.vpnPattern.matcher(datum[14]);
                Matcher logOutMatch = this.vpnLogoutPattern.matcher(datum[14]);
                if (matcher.find()) {
                    String username = matcher.group(1);
                    String privateIP = matcher.group(2);
                    data.put("TRAN_IP", privateIP);
                    data.put("SRC", privateIP);
                    data.put("USER", username);
                    data.put("VPN", "SSLVPN");
                    if (!this.resourceMap.containsKey(host)) {
                        this.resourceMap.put(host, new FixedHashMap(1000));
                    }
                    FixedHashMap hm = (FixedHashMap)this.resourceMap.get(host);
                    if (privateIP != null && username != null) {
                        hm.put(privateIP, new PIXVPNObject(data));
                    }
                    break block7;
                }
                if (logOutMatch.find()) {
                    String username = logOutMatch.group(1);
                    String privateIP = logOutMatch.group(2);
                    if (this.resourceMap.containsKey(host)) {
                        FixedHashMap hm = (FixedHashMap)this.resourceMap.get(host);
                        hm.remove(privateIP);
                    }
                    break block7;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        return true;
    }

    private void handleDoubleQuotes(String[] datum, int no) {
        if (datum[no].startsWith("\"") && !datum[no].endsWith("\"")) {
            int x;
            String tmp = "";
            for (x = 1; x < 5 && !datum[no + x].endsWith("\""); ++x) {
                tmp = tmp + datum[no + x];
            }
            tmp = tmp + datum[no + x];
            datum[no] = datum[no] + tmp;
        }
    }

    @Override
    public Map getLiveData(String resource) {
        TreeMap liveVPNUserMap = new TreeMap();
        this.populateMasterVPNMap(resource, this.resourceMap, liveVPNUserMap);
        return liveVPNUserMap;
    }

    private void populateMasterVPNMap(String resource, Map vpnMap, Map liveVPNUserMap) {
        Map vpnObjMap = (Map)vpnMap.get(resource);
        if (vpnObjMap != null) {
            for (String key : vpnObjMap.keySet()) {
                PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.get(key);
                Timestamp time = vpnObj.getVPNTime();
                liveVPNUserMap.put(time, vpnObj);
            }
        }
    }
}

