/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.FirewallConstants;
import com.adventnet.fa.server.PureFirewallConstants;
import com.adventnet.fa.server.ResourceDetails;
import com.adventnet.fa.server.dc.AbstractLogUnifier;
import com.adventnet.fa.server.dc.FwaunifierDBwrapper;
import com.adventnet.fa.server.dc.PIXVPNObject;
import com.adventnet.fa.server.rules.FwConfigMgmt;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.util.FixedHashMap;
import com.adventnet.persistence.DataAccess;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WELFLogUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(WELFLogUnifier.class.getName());
    String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final Integer TYPE = new Integer(1);
    private Pattern protocolPattern = null;
    private Pattern attack_msg = null;
    private List l3ProtocolList = new ArrayList();
    private Map fwToVpnMap = new HashMap();
    private Hashtable tempMem = new Hashtable();
    private Map tempWebfilterMem = Collections.synchronizedMap(new FixedHashMap(500));
    private Map resMap = new HashMap();
    private Map temp = new HashMap();
    private static Map sonicAPPMap = new HashMap();
    private static Map sonicDeniedApp = new HashMap();
    private Map tempVPN = new HashMap();
    private List actionList = Arrays.asList("login", "logout", "add", "delete", "edit");
    private Pattern p = Pattern.compile("((?:[\\w])+)=(?:(?:\"([^\"]+)\")|([^\\,\\s\"]+))");
    private Pattern sonicWallsrc = Pattern.compile("([^:]*)(:(\\d+):([^:^\\s]+))?(:([^\\s]+))?");
    private Pattern sWAdminDeni = Pattern.compile("(Administrator|User)\\s+login (denied|failed).*?");
    private Pattern sWAdminLogout = Pattern.compile("(Administrator|User)\\s+logged out.*?");
    private Pattern sWAdminLogin = Pattern.compile(".*(Administrator|User)\\s+login.*?");
    private Pattern sWwatchDenied = Pattern.compile(".*?(?i)( drop|denied).*?");
    private Pattern sWAttack2 = Pattern.compile("(?!Application Control).*Alert:\\s*([^\"]*)");
    private Pattern sWAttack1 = Pattern.compile("(.*?)\\s*(?i)( attack).*?");
    private Pattern sWAttack = Pattern.compile("(.*(spoof|fragment|death|scan|Syn).*)\\s+(dropped|detected)");
    private Pattern sWApplication = Pattern.compile("\"*(Application Control.*:\\s([\\S+]+)\\s+([^\\s].*)\\s--\\s([^\"]*))\"*");
    private Pattern sWserialNo = Pattern.compile("([A-Z0-9]{12})");
    private Hashtable<String, String> dbwrapper = FwaunifierDBwrapper.DBNAMESVSLOGNAMES;
    private FwConfigMgmt configMgmt = null;

    public WELFLogUnifier() {
        this.l3ProtocolList.add("tcp");
        this.l3ProtocolList.add("udp");
        this.protocolPattern = Pattern.compile("(\\D+)/(port:)?(\\d*)?(.*)");
        this.configMgmt = FwConfigMgmt.getInstance();
        this.populateMailProtocols();
        this.attack_msg = Pattern.compile(":\\s+([^\\,^\\[^\"]+)");
    }

    private void includeOpenAttributes(Hashtable data) {
        if (data.get("FW_NAME") != null) {
            this.checkforSecondaryFW(data);
        }
        if (data.get("ALERT_TYPE") != null) {
            this.checkforAlerttype(data);
        }
        if (data.get("ARKOON_ATTACK") != null) {
            this.checkforArkoonatt(data);
        }
        if (data.get("VIRUS") != null) {
            this.checkforVirus(data);
        }
        if (data.get("ATTACK_NAME") != null) {
            this.checkforAttackName(data);
        }
        if (data.get("ATTACK") != null) {
            this.checkforAttack(data);
        }
        if (data.get("LOG_TYPE") != null) {
            this.checkforSubtype(data);
        }
        if (data.get("RECORD_TYPE") != null) {
            this.checkforType(data);
        }
        if (data.get("VPNPOLICY") != null) {
            this.checkforvpnPolicy(data);
        }
        if (data.get("SM") != null) {
            this.checkforSM(data);
        }
        if (data.get("SN") != null) {
            this.checkforSonicWall(data);
        }
        if (data.get("ACTION") != null) {
            this.checkforAction(data);
        }
    }

    private void checkforSecondaryFW(Hashtable data) {
        String fgtDeviceName = (String)data.get("FW_NAME");
        Object rid = LaCacheManager.getInstance().getFirewallId(fgtDeviceName);
        if (rid != null) {
            data.put("FW", fgtDeviceName);
        }
    }

    private void checkforAttackName(Hashtable data) {
        data.put("ATTACK", data.get("ATTACK_NAME"));
        data.put("RECORD_TYPE", "attack");
    }

    private void checkforAction(Hashtable data) {
        if (((String)data.get("ACTION")).equalsIgnoreCase("block")) {
            data.put("RULE", "default");
            data.put("STATUS", "deny");
            data.put("li", "1");
        }
    }

    private void checkforAlerttype(Hashtable data) {
        if (((String)data.get("ALERT_TYPE")).indexOf("Attack") > -1) {
            data.put("li", "1");
            data.put("SRC", "0.0.0.0");
            data.put("EVENT_TYPE", "3");
            data.put("MSG", (String)data.get("ALERT_TYPE"));
        }
    }

    private void checkforArkoonatt(Hashtable data) {
        data.put("VIRUS", data.get("ARKOON_ATTACK"));
        data.put("RECORD_TYPE", "attack");
    }

    private void checkforAttack(Hashtable data) {
        if (!"N/A".equalsIgnoreCase((String)data.get("ATTACK"))) {
            data.put("li", "1");
            data.put("EVENT_TYPE", "3");
            data.put("RECORD_TYPE", "attack");
            data.put("VIRUS", data.get("ATTACK"));
        }
    }

    private void checkforVirus(Hashtable data) {
        data.put("li", "1");
        data.put("EVENT_TYPE", "4");
        data.put("RECORD_TYPE", "virus");
    }

    private void checkforSubtype(Hashtable data) {
        String temp = (String)data.get("LOG_TYPE");
        if (temp.equalsIgnoreCase("dlp")) {
            data.put("li", "1");
        }
        if (temp.equalsIgnoreCase("sslvpn") || temp.equalsIgnoreCase("ppp") || temp.equalsIgnoreCase("ipsec") || temp.equalsIgnoreCase("pppoe") || temp.equalsIgnoreCase("vpn")) {
            data.put("Is_VPNLOG", "true");
        }
        if (temp.equalsIgnoreCase("emailfilter")) {
            data.put("li", "1");
            data.put("EVENT_TYPE", "7");
            data.put("RECORD_TYPE", "spam");
        }
    }

    private void checkforType(Hashtable data) {
        String temp = (String)data.get("RECORD_TYPE");
        if (temp.equalsIgnoreCase("vpn")) {
            data.put("VPN", "Unknown");
        } else if (temp.equalsIgnoreCase("emailfilter")) {
            data.put("li", "1");
            data.put("EVENT_TYPE", "7");
            data.put("RECORD_TYPE", "spam");
        }
    }

    private void checkforvpnPolicy(Hashtable data) {
        data.put("VPN", (String)data.get("VPNPOLICY"));
        data.put("li", "1");
    }

    private void checkforSM(Hashtable data) {
        String temp = (String)data.get("SM");
        if (temp.equals("537") || temp.equals("97") || temp.equals("98")) {
            data.put("LTYPE", "Traffic");
        }
    }

    private void checkforNullAttribute(Matcher m, int groupNo, Hashtable data, String key) {
        if (m.group(groupNo) != null) {
            data.put(key, m.group(groupNo));
        }
    }

    private void checkforSonicWall(Hashtable data) {
        Matcher sm = this.sWserialNo.matcher((String)data.get("SN"));
        if (sm.find()) {
            Matcher m;
            data.put("FW_TYPE", "SonicWall");
            if (data.get("SRC") != null && (m = this.sonicWallsrc.matcher((String)data.get("SRC"))).find()) {
                this.checkforNullAttribute(m, 1, data, "SRC");
                this.checkforNullAttribute(m, 3, data, "SRC_PORT");
                this.checkforNullAttribute(m, 4, data, "SRC_INTERFACE");
                this.checkforNullAttribute(m, 6, data, "SRC_NAME");
            }
            if (data.get("DEST") != null && (m = this.sonicWallsrc.matcher((String)data.get("DEST"))).find()) {
                this.checkforNullAttribute(m, 1, data, "DEST");
                this.checkforNullAttribute(m, 3, data, "DEST_PORT");
                this.checkforNullAttribute(m, 4, data, "DST_INTERFACE");
                this.checkforNullAttribute(m, 6, data, "DEST_NAME");
            }
            if (data.get("MSG") != null) {
                String temp = (String)data.get("MSG");
                Matcher matcher = this.sWAttack.matcher(temp);
                if (matcher.find()) {
                    data.put("li", "1");
                    data.put("EVENT_TYPE", "3");
                    data.put("RECORD_TYPE", "attack");
                    data.put("VIRUS", matcher.group(1));
                }
                if (this.sWwatchDenied.matcher(temp).find()) {
                    data.put("RULE", "default");
                    data.put("STATUS", "deny");
                    data.put("li", "1");
                }
                if ((matcher = this.sWAttack1.matcher(temp)).find()) {
                    data.put("RECORD_TYPE", "attack");
                    data.put("EVENT_TYPE", "3");
                    data.put("li", "1");
                    data.put("VIRUS", matcher.group(1));
                }
                if ((matcher = this.sWAttack2.matcher(temp)).find()) {
                    data.put("RECORD_TYPE", "attack");
                    data.put("EVENT_TYPE", "3");
                    data.put("li", "1");
                    data.put("VIRUS", matcher.group(1));
                }
                if (this.sWAdminLogin.matcher(temp).find()) {
                    data.put("EVENT_TYPE", "1");
                    data.put("SUBTYPE", "1");
                    data.put("li", "1");
                }
                if (this.sWAdminLogout.matcher(temp).find()) {
                    data.put("EVENT_TYPE", "1");
                    data.put("SUBTYPE", "2");
                    data.put("li", "1");
                }
                if (this.sWAdminDeni.matcher(temp).find()) {
                    data.put("EVENT_TYPE", "1");
                    data.put("SUBTYPE", "3");
                    data.put("li", "1");
                }
                if ((matcher = this.sWApplication.matcher(temp)).find()) {
                    data.put("MSG", matcher.group(1));
                    data.put("APP", matcher.group(3));
                }
            }
        } else {
            data.remove("SN");
        }
    }

    private void parseLog(Hashtable data) {
        String rawLog = (String)data.remove("RawLog");
        Matcher m = this.p.matcher(rawLog);
        while (m.find()) {
            String val = m.group(3);
            String key = this.dbwrapper.get(m.group(1).toLowerCase());
            if (key != null && !"".equals(key)) {
                data.put(key, val == null ? m.group(2) : val);
                continue;
            }
            data.put(m.group(1).toUpperCase(), val == null ? m.group(2) : val);
        }
        boolean isFortigate = false;
        String logid = (String)data.get("LOG_ID");
        logid = logid == null ? (String)data.get("LOGID") : logid;
        boolean bl = isFortigate = logid != null;
        if (!isFortigate) {
            String[] keys;
            for (String tKey : keys = new String[]{"DEVICE_ID", "FW", "DEVID"}) {
                String val = (String)data.get(tKey);
                if (val == null || !val.startsWith("FG")) continue;
                data.put("LOG_FORMAT", "FortiGate");
                data.put("FW_TYPE", "FortiGate");
                break;
            }
        } else {
            data.put("LOG_FORMAT", "FortiGate");
            data.put("FW_TYPE", "FortiGate");
        }
    }

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        this.parseLog(data);
        this.includeOpenAttributes(data);
        data.put("rtype", TYPE);
        this.handleResources(data);
        this.handleDate(data);
        this.handleTime(data);
        this.handleAllowedStatus(data);
        String vdomName = (String)data.get("VDOM");
        List nonVdomList = FAServerUtil.getExcludedDevList();
        List vdomList = FAServerUtil.getVdomDevicesList();
        String considerAsVdom = (String)data.remove("considerAsVdom");
        String recordType = (String)data.get("RECORD_TYPE");
        boolean isFortiGate = "FortiGate".equals((String)data.get("LOG_FORMAT"));
        if (isFortiGate) {
            data.put("physicalDeviceName", (String)data.get("FW"));
            this.handleSecurityLog(data, recordType);
        }
        if (isFortiGate && vdomName != null && !"root".equals(vdomName) && !nonVdomList.contains(host) && !"false".equals(considerAsVdom)) {
            if ("true".equals((String)data.get("fromLoadArchive"))) {
                LaCacheManager lac = LaCacheManager.getInstance();
                host = lac.getResourceIp(host);
                if (!nonVdomList.contains(host)) {
                    this.setResourceName(data, host, vdomName, nonVdomList, vdomList);
                }
            } else {
                this.setResourceName(data, host, vdomName, nonVdomList, vdomList);
            }
        }
        String status = (String)data.get("STATUS");
        if (this.dropNotification(data, recordType)) {
            if (isFortiGate) {
                String resource = (String)data.get("FW");
                data.clear();
                data.put("FW", resource);
                return data;
            }
            return null;
        }
        this.checkArgument(data);
        if (this.webFilterLogHandling(data, recordType, status)) {
            if (isFortiGate) {
                String resource = (String)data.get("FW");
                data.clear();
                data.put("FW", resource);
                return data;
            }
            return null;
        }
        data.put("SYSLOGIP", host);
        data.put("rtype", new Integer(1));
        this.checkAdminSupport(data, host);
        String vpnLog = (String)data.get("Is_VPNLOG");
        if (data.get("SN") != null) {
            boolean drop;
            if ("Traffic".equals(data.get("LTYPE")) && (drop = this.getSonicLiveData(data))) {
                if (isFortiGate) {
                    String resource = (String)data.get("FW");
                    data.clear();
                    data.put("FW", resource);
                    return data;
                }
                return null;
            }
            String mess = (String)data.get("MSG");
            if (data.get("NOTE") != null || data.get("USERNAME") != null || mess != null && mess.indexOf("logout") > -1) {
                this.checkSonicwallVPN(data, host);
            }
            data.remove("TRAN_PORT");
            if (data.get("APPID") != null) {
                boolean dropAppLog = this.checkSonicwallApplication(data);
                if (dropAppLog) {
                    data.clear();
                    return null;
                }
                data.remove("APPID");
            }
            data.put("FW_TYPE", "SonicWall");
            FAServerUtil.setIpfixDevices((String)data.get("FW"));
        } else {
            boolean dropVPN = this.handleVPN(data, host, vpnLog);
            if (dropVPN) {
                if (isFortiGate) {
                    String resource = (String)data.get("FW");
                    data.clear();
                    data.put("FW", resource);
                    return data;
                }
                return null;
            }
            if (data.get("VPN") != null && "traffic".equals(recordType) && ((String)data.get("VPN")).indexOf("sslvpn") > -1) {
                this.handleIntermitantLog(data, host);
            }
        }
        if ("blocked".equals(status) && data.get("REQUEST") != null) {
            data.put("EVENT_TYPE", "6");
        }
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT", "EVENT_TYPE"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "RECEIVED", "BYTES", "DURATION", "SENT_PKT", "RECEIVED_PKT", "STATUS_CODE"};
        this.strToLong(strToLong, data);
        String fw_type = (String)data.get("FW_TYPE");
        if (fw_type == null) {
            data.put("FW_TYPE", "Unknown (WELF)");
        }
        if (data.get("LOG_FORMAT") == null) {
            data.put("LOG_FORMAT", "WELF");
        }
        this.checkVPN(data);
        this.checkProtocolSyntax(data);
        this.checkPriority(data);
        this.assignNameForAttack(data, "portscan");
        if ("Cisco".equals(fw_type)) {
            data.put("RECEIVED", data.get("BYTES"));
            data.put("RCVD", data.get("BYTES"));
            String xlate_dest = (String)data.get("XLATE_DEST");
            String xlate_dport = (String)data.get("XLATE_DPORT");
            if (xlate_dest != null && !"".equals(xlate_dest.trim())) {
                data.put("DEST", xlate_dest);
            }
            if (xlate_dport != null && !"".equals(xlate_dport.trim())) {
                data.put("DEST_PORT", xlate_dport);
            }
            this.handleMail(data);
        }
        if (!"IPFIX".equals(data.get("LOG_FORMAT"))) {
            this.checkSrcDstInterfaces(data, "FW");
        } else {
            data.put("SRC_INT", new Long((String)data.remove("SRC_INTERFACE")));
            data.put("DST_INT", new Long((String)data.remove("DST_INTERFACE")));
        }
        if ("ha".equalsIgnoreCase((String)data.get("LOG_TYPE"))) {
            data.put("li", "1");
            data.put("SRC", "0.0.0.0");
        }
        if (data.get("SRC") == null && data.get("DEST") == null) {
            if (isFortiGate) {
                String resource = (String)data.get("FW");
                data.clear();
                data.put("FW", resource);
                return data;
            }
            return null;
        }
        return data;
    }

    private void setResourceName(Hashtable data, String host, String vdomName, List nonVdomList, List vdomList) {
        String deviceID = (String)data.get("FW");
        data.put("FW", vdomName);
        boolean isFromLoadArchive = "true".equals((String)data.get("fromLoadArchive"));
        ResourceDetails resObj = FAServerUtil.getResObject(deviceID);
        if (resObj != null) {
            String oldIP;
            String resName = resObj.getModResName(vdomName);
            data.put("FW", resName);
            if (!(vdomList.contains(host) || nonVdomList.contains(host) || isFromLoadArchive || (oldIP = resObj.getIPAddress()).equals(host))) {
                this.updateIPRelatedStuff(oldIP, host, deviceID, Boolean.TRUE);
                resObj.setIPAddress(host);
            }
        } else if (!isFromLoadArchive) {
            String memIP;
            Hashtable deviceIDToIPMap = FAServerUtil.getPhysicalDevToIPMap();
            if (deviceIDToIPMap.containsKey(deviceID) && nonVdomList.contains(memIP = (String)deviceIDToIPMap.get(deviceID))) {
                data.put("FW", deviceID);
                this.updateIPRelatedStuff(memIP, host, deviceID, Boolean.FALSE);
                return;
            }
            List resList = FAServerUtil.getResList();
            if (resList.contains(vdomName)) {
                String resName = deviceID + "-" + vdomName;
                data.put("FW", resName);
            } else {
                data.put("FW", vdomName);
            }
        }
    }

    private void updateIPRelatedStuff(String oldIP, String newIP, String deviceID, Boolean vdomIPChange) {
        LOGGER.log(Level.INFO, "Firewall IP Got Changed : \t vdomIPChange Name: \"{0}\"\t Old IP : \"{1}\"\t New IP: \"{2}\"\t MainDevname : \"{3}\"", new Object[]{vdomIPChange, oldIP, newIP, deviceID});
        String resourcesWithIP = FAServerUtil.getIPResMap(oldIP);
        FAServerUtil.updateIPResMap(oldIP, newIP);
        FAServerUtil.updatePhysicalDevToIPMap(newIP, deviceID);
        if (vdomIPChange.booleanValue()) {
            FAServerUtil.removeDeviceFromVdomDevicesList(oldIP);
            FAServerUtil.addDeviceToVdomDevicesList(newIP);
        } else {
            List nonVdomList = FAServerUtil.getExcludedDevList();
            if (nonVdomList.contains(oldIP)) {
                FAServerUtil.removeDevFrmExcludeList(oldIP);
                FAServerUtil.addToExcludedDevicesList(newIP);
                FAServerUtil.updateSysConf();
            }
        }
        try {
            UpdateQueryImpl update = new UpdateQueryImpl("Resources");
            Criteria crit = new Criteria(new Column("Resources", "IPADDRESS"), (Object)oldIP, 0);
            update.setCriteria(crit);
            update.setUpdateColumn("IPADDRESS", (Object)newIP);
            DataAccess.update((UpdateQuery)update);
            update = new UpdateQueryImpl("Resources");
            crit = new Criteria(new Column("Resources", "PHYSICALDEVIP"), (Object)oldIP, 0);
            update.setCriteria(crit);
            update.setUpdateColumn("PHYSICALDEVIP", (Object)newIP);
            DataAccess.update((UpdateQuery)update);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        LaCacheManager lac = LaCacheManager.getInstance();
        String[] rids = resourcesWithIP.split(",");
        for (int i = 0; i < rids.length; ++i) {
            String rid = rids[i];
            String resource = (String)lac.getResourceName(new Long(rid));
            lac.updateIpToResource(newIP, resource);
            lac.removeFromMem(Long.valueOf(rid));
        }
    }

    @Override
    protected void handleSpecialChars(Hashtable data, String[] fields) {
        super.handleSpecialChars(data, fields);
    }

    protected void checkVPN(Hashtable data) {
        String vpn = (String)data.get("VPN");
        if (vpn == null) {
            return;
        }
        if ("n/a".equalsIgnoreCase(vpn.trim())) {
            data.remove("VPN");
        }
    }

    private boolean handleVPN(Hashtable data, String host, String vpnLog) {
        String src = host + data.get("SRC");
        String logType = (String)data.get("LOG_TYPE");
        String status = (String)data.get("STATUS");
        boolean dropLog = false;
        if ("start".equalsIgnoreCase(status)) {
            dropLog = true;
        } else if (this.tempVPN.containsKey(src) && !"vpn".equals(logType)) {
            String str = (String)this.tempVPN.get(src);
            String[] vpnInfo = str.split(",");
            data.put("SRC", vpnInfo[0]);
            data.put("TRAN_IP", vpnInfo[1]);
            data.put("USERNAME", vpnInfo[2]);
            data.put("VPN", "SSLVPN");
            this.handleIntermitantLog(data, host);
        } else if ("true".equals(vpnLog)) {
            String action = (String)data.get("ACTION");
            String duration = (String)data.get("DURATION");
            String tunnelIP = (String)data.get("TUNNEL_IP");
            data.put("li", "1");
            if ("sslvpn-user".equalsIgnoreCase(logType) && (action.indexOf("fail") > -1 || "failure".equalsIgnoreCase(status))) {
                data.put("VPN", "SSLVPN");
                data.put("EVENT_TYPE", new Integer(10));
                data.put("DEST", host);
                data.put("TRAN_IP", (String)data.get("SRC"));
            } else if ("vpn".equalsIgnoreCase(logType) && action.indexOf("fail") > -1) {
                data.put("VPN", "SSLVPN");
                data.put("EVENT_TYPE", new Integer(10));
                data.put("DEST", host);
                data.put("TRAN_IP", (String)data.get("SRC"));
            } else if ("sslvpn-user".equalsIgnoreCase(logType) && ("login".equalsIgnoreCase(action) || "tunnel-up".equalsIgnoreCase(action))) {
                data.put("VPN", "SSLVPN");
                this.addVPNObject(data, host);
            } else if ("sslvpn-user".equalsIgnoreCase(logType) && ("logout".equalsIgnoreCase(action) || "tunnel-down".equalsIgnoreCase(action))) {
                data.put("VPN", "SSLVPN");
                this.removeVPNObject(data, host);
            } else if ("sslvpn-session".equalsIgnoreCase(logType) && "tunnel-down".equalsIgnoreCase(action)) {
                data.put("VPN", "SSLVPN");
                this.handleIntermitantLog(data, host);
            } else if ("vpn".equalsIgnoreCase(logType) && "tunnel-up".equalsIgnoreCase(action) && tunnelIP != null && !"null".equals(tunnelIP) && !"".equals(tunnelIP)) {
                data.put("VPN", "SSLVPN");
                data.put("TRAN_IP", tunnelIP);
                this.tempVPN.put(host + data.get("SRC"), data.get("SRC") + "," + tunnelIP + "," + data.get("USERNAME"));
                this.tempVPN.put(host + tunnelIP, data.get("SRC") + "," + tunnelIP + "," + data.get("USERNAME"));
                this.addVPNObject(data, host);
            } else if ("vpn".equalsIgnoreCase(logType) && "tunnel-down".equalsIgnoreCase(action) && tunnelIP != null && !"null".equals(tunnelIP) && !"".equals(tunnelIP)) {
                data.put("VPN", "SSLVPN");
                this.tempVPN.remove(host + data.get("SRC"));
                this.tempVPN.remove(host + tunnelIP);
                this.removeVPNObject(data, host);
            } else if ("ppp".equalsIgnoreCase(logType) && action.indexOf("success") > -1) {
                data.put("VPN", "PPTP");
                data.put("PROTOCOL", "PPTP");
            } else if ("ppp".equalsIgnoreCase(logType) && action.indexOf("fail") > -1) {
                data.put("VPN", "PPTP");
                data.put("EVENT_TYPE", new Integer(10));
            } else if ("ipsec".equalsIgnoreCase(logType) && "tunnel-up".equalsIgnoreCase(action)) {
                data.remove("DEST");
                data.put("SUBTYPE", "7");
            } else if ("ipsec".equalsIgnoreCase(logType) && "tunnel-down".equalsIgnoreCase(action)) {
                data.put("USERNAME", "Unknown");
                data.put("TRAN_IP", (String)data.get("SRC"));
            } else {
                dropLog = true;
            }
        }
        return dropLog;
    }

    protected void checkArgument(Hashtable data) {
        String req = (String)data.get("REQUEST");
        if (req != null && req.startsWith("/")) {
            String dstName = (String)data.get("DEST_NAME");
            if (dstName == null) {
                dstName = (String)data.get("DEST");
            }
            data.put("REQUEST", dstName + req);
        }
    }

    protected void checkProtocolSyntax(Hashtable data) {
        String proto = (String)data.get("PROTO");
        if (proto != null && proto.indexOf("47") > -1) {
            data.put("PROTOCOL", "gre");
        } else {
            String protocol = (String)data.get("PROTOCOL");
            if (protocol != null) {
                Matcher matcher = this.protocolPattern.matcher(protocol);
                if (matcher.find()) {
                    String l3Protocol = matcher.group(1);
                    data.put("L3_PROTOCOL", l3Protocol);
                    String tempProtocol = matcher.group(4);
                    String port = matcher.group(3);
                    if (port == null || port.trim().equals("")) {
                        data.put("PROTOCOL", tempProtocol);
                    } else {
                        data.put("PROTOCOL", port + "/" + l3Protocol);
                    }
                } else {
                    String destPort;
                    if ((protocol.equalsIgnoreCase("UDP") || protocol.equalsIgnoreCase("TCP")) && (destPort = data.get("DEST_PORT").toString()) != null) {
                        protocol = destPort + "/" + protocol;
                        data.put("PROTOCOL", protocol);
                    }
                    int slaIndex = protocol.indexOf("/");
                    int lastIndex = protocol.length() - 1;
                    if (slaIndex > -1 && slaIndex < lastIndex) {
                        String l3Protocol = protocol.substring(slaIndex + 1);
                        if (!this.l3ProtocolList.contains(l3Protocol.toLowerCase())) {
                            data.put("PROTOCOL", l3Protocol);
                        } else {
                            data.put("L3_PROTOCOL", l3Protocol);
                        }
                    }
                }
            } else {
                String port = ((Integer)data.get("DEST_PORT")).toString();
                if (port != null) {
                    protocol = port + "/tcp";
                    data.put("PROTOCOL", protocol);
                }
            }
        }
        super.checkForLearnMe(data);
    }

    private boolean dropNotification(Hashtable data, String recordType) {
        if (PureFirewallConstants.getPerlVM()) {
            return false;
        }
        if (FirewallConstants.dropNotification()) {
            Object sent = data.get("SENT");
            Object rcvd = data.get("RECEIVED");
            String status = (String)data.get("STATUS");
            if (status != null && "deny".equals(status.trim())) {
                data.put("li", "1");
                if ("traffic".equals(recordType)) {
                    data.put("EVENT_TYPE", PureFirewallConstants.FIREWALL_DENIED_LOG);
                }
            }
            if ("app-ctrl-all".equals(data.get("LOG_TYPE")) && "pass".equals(data.get("ACTION"))) {
                return true;
            }
            if (sent == null || rcvd == null || !"permit".equals(status)) {
                return false;
            }
            if ("0".equals(sent.toString()) && "0".equals(rcvd.toString())) {
                String priority = (String)data.get("PRIORITY");
                if (priority != null) {
                    priority.trim();
                }
                if (("5".equals(priority) || "Notification".equals(priority)) && !"dlp".equals(recordType)) {
                    return true;
                }
            }
        }
        return false;
    }

    private void handleDate(Hashtable data) {
        String date = null;
        date = (String)data.get("DATE");
        if (date != null) {
            String time = (String)data.get("TIME");
            if (time == null) {
                return;
            }
            time = date + " " + time;
            data.put("TIME", time);
        } else if (data.get("DATE_STRING") != null) {
            this.assignPreParserTime(data);
        }
    }

    private void handleTime(Hashtable data) {
        try {
            String date_format = this.DATE_FORMAT;
            if (data.get("TIME_ZONE") != null) {
                date_format = (String)data.get("DATE_FORMAT");
            }
            if (data.get("DATE_STRING") == null) {
                String time = (String)data.remove("TIME");
                SimpleDateFormat sdf = new SimpleDateFormat(date_format);
                if (time != null) {
                    data.put("TIME", new Timestamp(sdf.parse(time).getTime()));
                } else {
                    data.put("TIME", new Timestamp(System.currentTimeMillis()));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void checkAdminSupport(Hashtable data, String host) {
        String adminAction = (String)data.get("ACTION");
        if (data.get("ACTION") != null && this.actionList.contains(adminAction)) {
            data.put("EVENT_TYPE", "1");
            data.put("DEST", host);
            data.put("li", "1");
            if (data.get("PROTOCOL") == null) {
                data.put("PROTOCOL", "Unknown");
            }
            if (data.get("MSG") != null) {
                String paramValue = (String)data.get("MSG");
                String ipRegEx = ".*?(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}).*";
                Pattern p = Pattern.compile(ipRegEx);
                Matcher m = p.matcher(paramValue);
                String srcIP = "0.0.0.0";
                while (m.find()) {
                    srcIP = m.group(1);
                }
                data.put("SRC", srcIP);
            } else {
                data.put("SRC", "0.0.0.0");
            }
            String adminStatus = (String)data.get("STATUS");
            if ("login".equalsIgnoreCase(adminAction) && "success".equalsIgnoreCase(adminStatus)) {
                data.put("SUBTYPE", "1");
            } else if ("logout".equalsIgnoreCase(adminAction) && "success".equalsIgnoreCase(adminStatus)) {
                data.put("SUBTYPE", "2");
                try {
                    if ("FortiGate".equalsIgnoreCase((String)data.get("LOG_FORMAT")) && !"true".equals((String)data.get("fromLoadArchive"))) {
                        String changedBy = (String)data.get("USERNAME");
                        String resource = (String)data.get("FW");
                        Long rID = (Long)LaCacheManager.getInstance().getFirewallId(resource);
                        this.configMgmt.initiateConfigFetching("FortiGate", resource, changedBy, rID);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if ("login".equalsIgnoreCase(adminAction) && "failed".equalsIgnoreCase(adminStatus)) {
                data.put("SUBTYPE", "3");
            } else if ("add".equalsIgnoreCase(adminAction) || "delete".equalsIgnoreCase(adminAction) || "edit".equalsIgnoreCase(adminAction)) {
                data.put("SUBTYPE", "4");
                data.put("FILENAME", data.get("MSG"));
            }
        }
    }

    private void addVPNObject(Hashtable data, String host) {
        try {
            String resource = (String)data.get("FW");
            String user = (String)data.get("USERNAME");
            String src = (String)data.get("SRC");
            String dummyKey = user + src;
            PIXVPNObject vpnObj = new PIXVPNObject(data);
            vpnObj.setResource(resource);
            vpnObj.setUser(user);
            Map<String, PIXVPNObject> vpnObjMap = (Map<String, PIXVPNObject>)this.fwToVpnMap.get(resource);
            if (vpnObjMap == null) {
                vpnObjMap = Collections.synchronizedMap(new FixedHashMap(800));
                this.fwToVpnMap.put(resource, vpnObjMap);
            }
            data.remove("VPN");
            vpnObjMap.put(dummyKey, vpnObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleIntermitantLog(Hashtable data, String host) {
        PIXVPNObject vpnObj;
        data.put("li", "1");
        data.put("SUBTYPE", "7");
        if (data.get("DEST") == null) {
            data.put("DEST", host);
        }
        String resource = (String)data.get("FW");
        String user = (String)data.get("USERNAME");
        String src = (String)data.get("SRC");
        String dummyKey = user + src;
        Map vpnObjMap = (Map)this.fwToVpnMap.get(resource);
        if (vpnObjMap != null && (vpnObj = (PIXVPNObject)vpnObjMap.get(dummyKey)) != null) {
            this.aggregateSentAndRcvd(vpnObj, data);
            if (data.get("TRAN_IP") != null) {
                String tranKey = dummyKey + "tranIp";
                this.tempMem.put(tranKey, (String)data.get("TRAN_IP"));
            } else {
                data.put("TRAN_IP", src);
            }
            if (data.get("SN") != null) {
                vpnObj.setVPNName((String)data.get("VPN"));
            }
        }
    }

    private void removeVPNObject(Hashtable data, String host) {
        try {
            String resource = (String)data.get("FW");
            String user = (String)data.get("USERNAME");
            String src = (String)data.get("SRC");
            long sentByte = Long.parseLong(data.get("SENT").toString());
            long rcvdByte = Long.parseLong(data.get("RECEIVED").toString());
            String dummyKey = user + src;
            Map vpnObjMap = (Map)this.fwToVpnMap.get(resource);
            if (vpnObjMap != null) {
                String tranKey;
                PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.remove(dummyKey);
                if (vpnObj != null && vpnObj.getSentBytes() != null) {
                    long sent = vpnObj.getSentBytes();
                    long rcvd = vpnObj.getRcvdBytes();
                    data.put("SENT", sentByte == 0L ? sent : sentByte);
                    data.put("RECEIVED", rcvdByte == 0L ? rcvd : rcvdByte);
                }
                if (this.tempMem.get(tranKey = dummyKey + "tranIp") != null) {
                    data.put("TRAN_IP", (String)this.tempMem.remove(tranKey));
                } else {
                    data.put("TRAN_IP", src);
                }
                String duration = (String)data.get("DURATION");
                if (duration == null) {
                    long logTime = ((Timestamp)data.get("TIME")).getTime();
                    if (vpnObj != null) {
                        long startTime = vpnObj.getVPNTime().getTime();
                        duration = Long.toString((logTime - startTime) / 1000L);
                        data.put("DURATION", duration);
                    }
                    data.put("DEST", host);
                    data.put("EVENT_TYPE", "0");
                } else {
                    data.remove("DEST");
                }
                if (data.get("SN") != null) {
                    data.put("VPN", vpnObj.getVPNName());
                    data.remove("DEST");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Timestamp getTimeStamp(Hashtable data) {
        SimpleDateFormat sdf = new SimpleDateFormat(this.DATE_FORMAT);
        long time = System.currentTimeMillis();
        try {
            time = sdf.parse((String)data.get("TIME")).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Timestamp(time);
    }

    @Override
    public Map getLiveData(String resource) {
        TreeMap<Timestamp, PIXVPNObject> liveVPNUserMap = new TreeMap<Timestamp, PIXVPNObject>();
        Map vpnObjMap = (Map)this.fwToVpnMap.get(resource);
        if (vpnObjMap != null) {
            for (String key : vpnObjMap.keySet()) {
                PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.get(key);
                Timestamp time = vpnObj.getVPNTime();
                liveVPNUserMap.put(time, vpnObj);
            }
        }
        return liveVPNUserMap;
    }

    protected void handleAllowedStatus(Hashtable data) {
        String status = (String)data.get("STATUS");
        if (status != null && ((status = status.toLowerCase().trim()).startsWith("allow") || status.startsWith("accept"))) {
            data.put("STATUS", "permit");
        }
    }

    private boolean getSonicLiveData(Hashtable data) {
        String src = (String)data.get("SRC");
        String dst = (String)data.get("DEST");
        String sPort = (String)data.get("SRC_PORT");
        String msg = (String)data.get("MSG");
        String resource = (String)data.get("FW");
        String key = src + sPort + dst;
        Map liveMap = (Map)this.resMap.get(resource);
        if (liveMap == null) {
            liveMap = Collections.synchronizedMap(new FixedHashMap(15000));
            this.resMap.put(resource, liveMap);
        }
        if (msg != null && msg.indexOf(" Opened") > -1) {
            liveMap.put(key, data.get("TIME"));
            return true;
        }
        if (liveMap.get(key) != null) {
            Timestamp startTime = (Timestamp)liveMap.remove(key);
            long duration = ((Timestamp)data.get("TIME")).getTime() - startTime.getTime();
            data.put("DURATION", duration / 1000L);
        }
        return false;
    }

    private boolean webFilterLogHandling(Hashtable data, String recordType, String status) {
        String src = (String)data.get("SRC");
        String srcPort = (String)data.get("SRC_PORT");
        String logType = (String)data.get("LOG_TYPE");
        String webfilterKey = src + srcPort;
        String webfilterURLKey = webfilterKey + "url";
        String webfilterCatKey = webfilterKey + "cat";
        if (("webfilter".equals(recordType) || "webfilter".equals(logType)) && !"blocked".equals(status)) {
            if (data.get("REQUEST") != null) {
                String url = (String)data.get("REQUEST");
                this.tempWebfilterMem.put(webfilterURLKey, url);
                if (data.get("CATEGORY") != null) {
                    String cat = (String)data.get("CATEGORY");
                    this.tempWebfilterMem.put(webfilterCatKey, cat);
                }
                return true;
            }
        } else if ("traffic".equals(recordType)) {
            String url = (String)this.tempWebfilterMem.remove(webfilterURLKey);
            String cat = (String)this.tempWebfilterMem.remove(webfilterCatKey);
            if (url != null) {
                data.put("REQUEST", url);
            }
            if (cat != null) {
                data.put("CATEGORY", cat);
            }
        }
        return false;
    }

    private void checkSonicwallVPN(Hashtable data, String host) {
        String msg;
        String usrName = (String)data.get("USERNAME");
        String src = (String)this.temp.get(host + usrName);
        String string = msg = data.get("MSG") != null ? (String)data.get("MSG") : "noMsg";
        if (msg.indexOf("XAUTH Succeeded") > -1 || msg.matches("L2TP.*Authentication Suc.*")) {
            data.put("USERNAME", data.remove("NOTE"));
            this.temp.put(host + (String)data.get("USERNAME"), data.get("SRC"));
            data.put("VPN", "IPSec");
            this.addVPNObject(data, host);
        } else if (data.get("SENT") != null && src != null) {
            data.put("TRAN_IP", data.get("SRC"));
            data.put("SRC", src);
            String vpn = (String)data.get("VPN");
            if (vpn == null) {
                data.put("VPN", "SSLVPN");
            }
            this.handleIntermitantLog(data, host);
        } else if (msg.matches("User\\s+logged\\s+out.*") && src != null) {
            data.put("SRC", src);
            data.remove("SUBTYPE");
            this.removeVPNObject(data, host);
            this.temp.remove(host + usrName);
        } else if (msg.indexOf("XAUTH Failed") > -1) {
            data.put("EVENT_TYPE", "10");
        } else if (msg.matches("SSLVPN.*login allowed")) {
            this.temp.put(host + (String)data.get("USERNAME"), data.get("SRC"));
            data.put("USERNAME", data.get("USERNAME"));
            data.put("VPN", "SSLVPN");
            this.addVPNObject(data, host);
        } else if (msg.matches("User.*logout")) {
            String usr = null;
            Matcher m = Pattern.compile("(\\s(.*?)\\s)").matcher(msg);
            if (m.find()) {
                usr = m.group(1);
                usr = usr.trim();
            }
            data.put("SRC", this.temp.get(host + usr));
            data.put("USERNAME", usr);
            data.put("VPN", "SSLVPN");
            this.removeVPNObject(data, host);
            this.temp.remove(host + usr);
        } else if (msg.matches(".*login denied.*")) {
            data.put("EVENT_TYPE", "10");
        }
        data.put("li", "1");
    }

    private boolean checkSonicwallApplication(Hashtable data) {
        String msg = data.get("MSG") != null ? (String)data.get("MSG") : "noMsg";
        int appID = Integer.parseInt((String)data.get("APPID"));
        if (msg.indexOf("Application Control Detection") > -1 && !sonicAPPMap.containsKey(appID)) {
            sonicAPPMap.put(appID, (String)data.get("APP") + "," + (String)data.get("POLICY_ID"));
        } else if (msg.indexOf("Application Control Prevention") > -1 && !sonicDeniedApp.containsKey(appID)) {
            sonicDeniedApp.put(appID, appID);
        } else {
            if (msg.equals("noMsg") && sonicAPPMap.containsKey(appID)) {
                String str = (String)sonicAPPMap.get(appID);
                String[] appValue = str.split(",");
                data.put("TRAN_PORT", appValue[0]);
                data.put("POLICY_ID", appValue[1]);
                return false;
            }
            if (msg.equals("noMsg") && sonicDeniedApp.containsKey(appID)) {
                data.put("li", "1");
                data.put("EVENT_TYPE", PureFirewallConstants.FIREWALL_DENIED_LOG);
                data.remove("POLICY_ID");
                return false;
            }
            data.remove("TRAN_PORT");
            data.remove("POLICY_ID");
            return false;
        }
        return true;
    }

    private void handleResources(Hashtable data) {
        try {
            if (data.get("SN") != null) {
                String sn = (String)data.get("SN");
                String resName = FirewallConstants.getWanIPfromMap(sn);
                if (resName != null) {
                    data.put("FW", resName);
                } else {
                    FirewallConstants.addToWanIPMap(sn, data.get("FW").toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleSecurityLog(Hashtable data, String recordType) {
        try {
            Matcher matcher;
            if ("virus".equals(recordType) && "N/A".equals(data.get("VIRUS"))) {
                data.remove("VIRUS");
                data.remove("RECORD_TYPE");
            }
            if ("attack".equals(recordType) && ((String)data.get("VIRUS")).matches("\\d+") && (matcher = this.attack_msg.matcher((String)data.get("MSG"))).find()) {
                data.put("VIRUS", matcher.group(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        WELFLogUnifier wf = new WELFLogUnifier();
        try {
            File ft = new File(args[0]);
            Hashtable<String, String> ht = new Hashtable<String, String>();
            BufferedReader br = new BufferedReader(new FileReader(ft));
            String line = null;
            while ((line = br.readLine()) != null) {
                ht.put("RawLog", line);
                wf.unifyData("192.268.26.71", ht);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

