/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.dc.AbstractLogUnifier;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;

public class ZywallUnifier
extends AbstractLogUnifier {
    private static final Integer TYPE = new Integer(1);
    private HashMap l3ProtocolMap = new HashMap();

    public ZywallUnifier() {
        this.l3ProtocolMap.put("17", "udp");
        this.l3ProtocolMap.put("6", "tcp");
        this.l3ProtocolMap.put("1", "icmp");
    }

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        this.checkForDuration(data, host);
        data.put("rtype", TYPE);
        this.handleTime(data);
        this.handleAllowedStatus(data);
        data.put("SYSLOGIP", host);
        data.put("rtype", new Integer(1));
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT", "EVENT_TYPE"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "RECEIVED", "BYTES", "DURATION", "SENT_PKT", "RECEIVED_PKT", "STATUS_CODE"};
        this.strToLong(strToLong, data);
        data.put("FW_TYPE", "ZYWALL");
        data.put("LOG_FORMAT", "WELF");
        this.checkProtocolSyntax(data);
        this.checkPriority(data);
        return data;
    }

    public void checkProtocolSyntax(Hashtable data) {
        String l3Proto = (String)data.get("L3_PROTOCOL");
        if (l3Proto != null) {
            if (l3Proto.equals("47")) {
                data.put("PROTOCOL", "gre");
            } else {
                l3Proto = this.getStringL3Protocol(l3Proto);
                data.put("L3_PROTOCOL", l3Proto);
                Object destPort = data.get("DEST_PORT");
                if (destPort != null) {
                    l3Proto = destPort.toString() + "/" + l3Proto;
                }
                data.put("PROTOCOL", l3Proto);
            }
        }
        super.checkForLearnMe(data);
    }

    private void checkForDuration(Hashtable data, String host) {
        String startTime = (String)data.get("BEGIN_TIME");
        String endTime = (String)data.get("END_TIME");
        if (startTime != null && endTime != null) {
            try {
                data.put("FW", host);
                SimpleDateFormat format = new SimpleDateFormat("MMddyyyyHHmmss");
                Date sDate = format.parse(startTime);
                Date eDate = format.parse(endTime);
                long sTime = sDate.getTime();
                long eTime = eDate.getTime();
                long duration = (eTime - sTime) / 1000L;
                data.put("DURATION", duration);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void handleTime(Hashtable data) {
        if (data.get("DATE_STRING") != null) {
            this.assignPreParserTime(data);
        }
    }

    private void handleAllowedStatus(Hashtable data) {
        String status = (String)data.get("STATUS");
        if (status != null && ((status = status.toLowerCase().trim()).startsWith("allow") || status.startsWith("accept"))) {
            data.put("STATUS", "permit");
        }
    }
}

