/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.enterprise.dc;

import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.la.enterprise.EnterpriseException;
import com.adventnet.la.enterprise.EnterpriseStartUpUtil;
import com.adventnet.la.enterprise.dc.DataRetriver;
import com.adventnet.la.enterprise.dc.DefaultDataSynchronizer;
import com.adventnet.la.enterprise.dc.SyncUtil;
import java.io.OutputStream;
import java.util.HashMap;

public class FWADataSynchronizer
extends DefaultDataSynchronizer {
    private HashMap insertTableVsQueryMap = null;

    public FWADataSynchronizer(DataRetriver dataRetriver) {
        super(dataRetriver);
        if ("DS".equals(System.getProperty("server.type"))) {
            this.loadDefaultInfo();
        }
    }

    public void sync(String toProcess, OutputStream out) throws EnterpriseException {
        super.sync(toProcess, out);
        if ("sData".equals(toProcess)) {
            String flowRateStr = FAServerUtil.getFlowRate();
            String rate = flowRateStr.substring(0, flowRateStr.indexOf(44));
            try {
                out.write("flowRate=Start".getBytes());
                out.write(10);
                out.write(rate.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadDefaultInfo() {
        try {
            boolean isConvCollector = EnterpriseStartUpUtil.isConvertedCollector();
            if (!isConvCollector) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, String> delUpdateFKMap = new HashMap<String, String>();
        delUpdateFKMap.put("Resources", "RESOURCEID");
        delUpdateFKMap.put("ResourcesToReportConfig", "RESOURCEID");
        delUpdateFKMap.put("ResToDept", "RID");
        delUpdateFKMap.put("ComplianceDashboardInfo", "RID");
        delUpdateFKMap.put("ComplianceStatusSummary", "RID");
        delUpdateFKMap.put("ComplianceUserInputs", "RID");
        this.duListener.setFKTableVsColumnMap(delUpdateFKMap);
        this.insertTableVsQueryMap = new HashMap();
        String[] insertTables = new String[]{"Resources", "ResourcesToReportConfig", "FAArchivedFiles", "ResToDept", "DeviceDetails", "DIPToResourcesMapping", "ComplianceUserInputs", "ComplianceStatusSummary", "ComplianceDashboardInfo"};
        String[] insertColumns = new String[]{"RESOURCEID", "RESOURCEID", "RID", "RID", "RID", "RID", "RID", "RID", "RID"};
        try {
            SyncUtil sUtil = SyncUtil.getInstance();
            for (int i = 0; i < insertTables.length; ++i) {
                String query = sUtil.getSyncInsertQuery(insertTables[i], insertColumns[i]);
                this.insertTableVsQueryMap.put(insertTables[i], query);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void handleSelectDataToOutfile(String tableName, String columnName, long[] range, String fileName) {
        try {
            if (this.insertTableVsQueryMap == null || this.insertTableVsQueryMap.get(tableName) == null) {
                this.dataRetriver.selectDataToOutfile(tableName, columnName, range, fileName);
            } else {
                String query = (String)this.insertTableVsQueryMap.get(tableName);
                this.dataRetriver.selectDataToOutfile(query, tableName, columnName, range, fileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

