/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.imp;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.FirewallConstants;
import com.adventnet.fa.server.FirewallLicenseManager;
import com.adventnet.fa.server.ResourceDetails;
import com.adventnet.fa.server.imp.ArchiveFile;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.LuceneUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.la.util.RawExtracter;
import com.adventnet.la.util.ServerUtil;
import com.adventnet.la.util.TimeStampingAPI;
import com.adventnet.la.util.pe.DataArchiverInterface;
import com.adventnet.la.util.pe.LogFormat;
import com.adventnet.la.util.pe.ParserEngineContext;
import com.adventnet.la.util.pe.ParserRule;
import com.adventnet.la.util.pe.Record;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.security.Signature;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class DataArchiver
extends Thread
implements DataArchiverInterface {
    private static final Logger LOGGER = Logger.getLogger(DataArchiver.class.getName());
    ResourceBundle rb = ProductBundle.getInstance().getBundle();
    private Integer waitObject = new Integer(0);
    private boolean shutdown = false;
    private int lazyIndexall = 0;
    private Hashtable firewallRecordMap = new Hashtable();
    private Hashtable archiveFileMap = new Hashtable();
    private HashSet firewallList = new HashSet();
    private ParserEngineContext context = null;
    private int fileDay = 0;
    private int fileMonth = 0;
    private int fileYear = 0;
    private long lastFileCreatedTime = 0L;
    private long lastZipFileCreatedTime = 0L;
    public static String BASE_ARCHIVE_DIRECTORY = null;
    public static String HOT_DIRECTORY_NAME = "hot";
    public static String COLD_DIRECTORY_NAME = "cold";
    public static String WARM_DIRECTORY_NAME = "warm";
    public static long startTime = System.currentTimeMillis();
    public static long archiveCount = 1L;
    public TreeSet sort = null;

    public static void setBaseArchiveDirectory(String newDirectory) {
        BASE_ARCHIVE_DIRECTORY = newDirectory + File.separator;
        ServerUtil.setArchiveFileLocation((String)newDirectory);
        LOGGER.log(Level.FINER, " UPDATED BASE ARCHIVE DIRECTORY IS ==={0}", BASE_ARCHIVE_DIRECTORY);
    }

    public DataArchiver(ParserEngineContext context) {
        super("DATA ARCHIVER");
        this.context = context;
        this.lastFileCreatedTime = System.currentTimeMillis();
        this.lastZipFileCreatedTime = System.currentTimeMillis();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                this.storeRecord();
                this.lazyIndexall = 0;
                Integer n = this.waitObject;
                synchronized (n) {
                    try {
                        this.waitObject.wait(FirewallConstants.getArchiveLoggingTime());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception eee) {
                eee.printStackTrace();
            }
        }
    }

    private void updateLuceneBatch() {
        try {
            LogIndexingAPI.getInstance().updateDocToIndex();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private void storeRecord() {
        if (!FirewallConstants.needToArchive()) {
            return;
        }
        ArchiveFile file = this.flushAllArchivedRecords();
        this.checkForFileCreation(file);
    }

    public ArchiveFile flushAllArchivedRecords() {
        Iterator iter = this.archiveFileMap.entrySet().iterator();
        ArchiveFile file = null;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String host = (String)entry.getKey();
            file = (ArchiveFile)entry.getValue();
            try {
                file.flushLogs();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, " Got Concurrent Modification Exception during flushLogs. Going to close this Archive File {0}", file.getFileName());
                iter.remove();
                file.close();
            }
        }
        return file;
    }

    private void checkForFileCreation(ArchiveFile file) {
        long fileDiff = System.currentTimeMillis() - this.lastFileCreatedTime;
        if (file == null) {
            return;
        }
        boolean newInitialCompressTime = FirewallConstants.getNewInitialCompressTime();
        if (!newInitialCompressTime) {
            this.getInitialCompressTimeFromDB();
        }
        long firstZipCreationTime = (long)FirewallConstants.getFirstZipCreationTime();
        long zipTime = firstZipCreationTime - this.lastZipFileCreatedTime;
        long zipDiff = System.currentTimeMillis() - this.lastZipFileCreatedTime;
        if ((float)fileDiff > FirewallConstants.getArchiveFileLong() || zipTime > 0L && zipDiff > zipTime || zipDiff > FirewallConstants.getArchiveZipLong()) {
            boolean needToCloseFile = this.checkForZipFileCreation();
            long currentTime = System.currentTimeMillis();
            if (needToCloseFile) {
                this.closeFiles();
                this.lastFileCreatedTime = currentTime;
            }
        }
    }

    private HashMap closeFiles() {
        HashMap<String, ArchiveFile> tempMap = new HashMap<String, ArchiveFile>();
        for (Map.Entry entry : this.archiveFileMap.entrySet()) {
            String ip = (String)entry.getKey();
            ArchiveFile file = (ArchiveFile)entry.getValue();
            file.close();
            tempMap.put(ip, file);
        }
        this.archiveFileMap.clear();
        this.updateLuceneBatch();
        return tempMap;
    }

    public void disableArchiving() {
        for (ArchiveFile file : this.archiveFileMap.values()) {
            file.close();
        }
    }

    public void enableArchiving() {
        for (Map.Entry entry : this.archiveFileMap.entrySet()) {
            String hostName = (String)entry.getKey();
            ArchiveFile file = (ArchiveFile)entry.getValue();
            file.reopen(hostName);
        }
    }

    private boolean checkForZipFileCreation() {
        long zipDiff = System.currentTimeMillis() - this.lastZipFileCreatedTime;
        long firstZipCreationTime = (long)FirewallConstants.getFirstZipCreationTime();
        long zipTime = firstZipCreationTime - this.lastZipFileCreatedTime;
        if (zipTime > 0L && zipDiff > zipTime || zipDiff > FirewallConstants.getArchiveZipLong()) {
            HashMap tempMap = this.closeFiles();
            this.lastFileCreatedTime = System.currentTimeMillis();
            this.lastZipFileCreatedTime = System.currentTimeMillis();
            for (Map.Entry entry : tempMap.entrySet()) {
                String resName = (String)entry.getKey();
                ArchiveFile file = (ArchiveFile)entry.getValue();
                String dnsName = file.getDNSName();
                String directoryName = BASE_ARCHIVE_DIRECTORY + resName;
                try {
                    String zipFileName = this.createZipFile(directoryName, resName, dnsName);
                    String resourceIP = file.getIPAddress();
                    if (!resName.equals(resourceIP)) {
                        this.fwIPChange(resourceIP, resName);
                    }
                    this.deleteWarmFiles(directoryName);
                    if (zipFileName == null) {
                        LOGGER.log(Level.FINER, " Unable to create zip for =={0}", directoryName);
                        continue;
                    }
                    if (zipFileName == null) continue;
                    this.updateDatabase(new File(zipFileName), resName);
                }
                catch (Exception ee) {
                    LOGGER.log(Level.FINER, " Exception while searching file =={0}", directoryName);
                    ee.printStackTrace();
                }
            }
            return false;
        }
        return true;
    }

    private void fwIPChange(String resourceIP, String resName) throws Exception {
        LaCacheManager lac = LaCacheManager.getInstance();
        String memIP = lac.getResourceIp(resName);
        boolean isVdom = false;
        ArrayList<String> ipList = new ArrayList<String>();
        ipList.add(memIP);
        ipList.add(this.rb.getString("DontChange.IP4IP"));
        ipList.add(this.rb.getString("DontChange.IP6IP"));
        LOGGER.log(Level.FINE, "ipList is::" + ipList);
        if (!ipList.contains(resourceIP)) {
            List nonVdomList;
            List vdomList;
            LOGGER.log(Level.INFO, "Firewall IP Got Changed : \t Firewall Name: \"{0}\"\t Old IP : \"{1}\"\t New IP: \"{2}\"", new Object[]{resName, memIP, resourceIP});
            String resourcesWithIP = FAServerUtil.getIPResMap(memIP);
            FAServerUtil.updateIPResMap(memIP, resourceIP);
            UpdateQueryImpl update = new UpdateQueryImpl("Resources");
            Criteria crit = new Criteria(new Column("Resources", "RESOURCENAME"), (Object)resName, 0);
            update.setCriteria(crit);
            update.setUpdateColumn("IPADDRESS", (Object)resourceIP);
            DataAccess.update((UpdateQuery)update);
            update = new UpdateQueryImpl("Resources");
            crit = new Criteria(new Column("Resources", "PHYSICALDEVIP"), (Object)memIP, 0);
            update.setCriteria(crit);
            update.setUpdateColumn("PHYSICALDEVIP", (Object)resourceIP);
            DataAccess.update((UpdateQuery)update);
            String physicalDevicename = FAServerUtil.getPhysicalDeviceName(memIP);
            if (physicalDevicename != null) {
                String deviceType = this.getDeviceType(resName);
                if ("Cisco".equals(deviceType) && physicalDevicename.equals(memIP)) {
                    update = new UpdateQueryImpl("Resources");
                    crit = new Criteria(new Column("Resources", "PHYSICALDEVICENAME"), (Object)memIP, 0);
                    update.setCriteria(crit);
                    update.setUpdateColumn("PHYSICALDEVICENAME", (Object)resourceIP);
                    DataAccess.update((UpdateQuery)update);
                    ResourceDetails resObj = FAServerUtil.getResObject(memIP);
                    if (resObj != null) {
                        resObj.setIPAddress(resourceIP);
                        FAServerUtil.updateResObjHashForCisco(memIP, resourceIP);
                    }
                    physicalDevicename = resourceIP;
                }
                FAServerUtil.updatePhysicalDevToIPMap(resourceIP, physicalDevicename);
            }
            if ((vdomList = FAServerUtil.getVdomDevicesList()).contains(memIP)) {
                FAServerUtil.removeDeviceFromVdomDevicesList(memIP);
                FAServerUtil.addDeviceToVdomDevicesList(resourceIP);
                isVdom = true;
            }
            if ((nonVdomList = FAServerUtil.getExcludedDevList()).contains(memIP)) {
                FAServerUtil.removeDevFrmExcludeList(memIP);
                FAServerUtil.addToExcludedDevicesList(resourceIP);
                FAServerUtil.updateSysConf();
            }
            if (isVdom) {
                update = new UpdateQueryImpl("Resources");
                crit = new Criteria(new Column("Resources", "IPADDRESS"), (Object)memIP, 0);
                update.setCriteria(crit);
                update.setUpdateColumn("IPADDRESS", (Object)resourceIP);
                DataAccess.update((UpdateQuery)update);
                String[] rids = resourcesWithIP.split(",");
                for (int i = 0; i < rids.length; ++i) {
                    String rid = rids[i];
                    String resource = (String)lac.getResourceName(new Long(rid));
                    lac.updateIpToResource(resourceIP, resource);
                    lac.removeFromMem(Long.valueOf(rid));
                }
            } else {
                lac.updateIpToResource(resourceIP, resName);
                Long resID = (Long)lac.getFirewallId(resName);
                lac.removeFromMem(resID);
            }
        }
    }

    private String getDeviceType(String resName) {
        String deviceType = null;
        try {
            Criteria crit = new Criteria(new Column("Resources", "RESOURCENAME"), (Object)resName, 0);
            DataObject doo = DataAccess.get((String)"Resources", (Criteria)crit);
            if (!doo.isEmpty()) {
                deviceType = (String)doo.getFirstValue("Resources", "VENDOR_TYPE");
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return deviceType;
    }

    private void deleteWarmFiles(String directoryName) {
        File directory = new File(directoryName);
        if (!directory.isDirectory()) {
            return;
        }
        File warmDirectory = new File(directoryName + File.separator + WARM_DIRECTORY_NAME);
        if (!warmDirectory.exists() || !warmDirectory.isDirectory()) {
            return;
        }
        File[] array = warmDirectory.listFiles();
        for (int i = 0; i < array.length; ++i) {
            array[i].delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createInstantZipFile() {
        Integer n = this.waitObject;
        synchronized (n) {
            this.lastFileCreatedTime = 0L;
            this.lastZipFileCreatedTime = 0L;
            this.waitObject.notify();
        }
    }

    public void createInstantZipFile(int lazyVar) {
        this.lazyIndexall = lazyVar;
        this.createInstantZipFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryToFlush() {
        Integer n = this.waitObject;
        synchronized (n) {
            this.waitObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String compressZipFile(String zipFileName, String originalDirectory) {
        BufferedInputStream bis = null;
        FilterOutputStream output = null;
        FileInputStream fis = null;
        File file = null;
        try {
            int bytesRead;
            file = new File(zipFileName);
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            SimpleDateFormat format = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
            String dateString = format.format(new Date());
            originalDirectory = originalDirectory + "_" + dateString + ".gz";
            output = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(originalDirectory)));
            byte[] buffer = new byte[8192];
            while ((bytesRead = bis.read(buffer)) != -1) {
                ((BufferedOutputStream)output).write(buffer, 0, bytesRead);
            }
            LOGGER.log(Level.FINER, " Successfully created compressed file =={0}", originalDirectory);
        }
        catch (Exception e) {
            System.err.println("Exception while creating gunzip for " + zipFileName);
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (fis != null) {
                    fis.close();
                }
                if (output != null) {
                    output.close();
                }
                if (file != null) {
                    file.delete();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
                return null;
            }
        }
        return originalDirectory;
    }

    private Object getResourceId(Criteria crit) {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("Resources"));
            query.addSelectColumn(new Column("Resources", "RESOURCEID"));
            query.setCriteria(crit);
            SortColumn sortCol = new SortColumn(new Column("Resources", "RESOURCEID"), false);
            query.addSortColumn(sortCol);
            DataObject idObject = DataAccess.get((SelectQuery)query);
            Object rid = null;
            if (idObject.containsTable("Resources")) {
                rid = idObject.getFirstValue("Resources", "RESOURCEID");
            }
            return rid;
        }
        catch (Exception ee) {
            LOGGER.log(Level.INFO, " Error while fetching criteria ", new Object[]{crit});
            ee.printStackTrace();
            return null;
        }
    }

    public void updateResource(Object rid, String ipaddress) {
        try {
            UpdateQueryImpl query = new UpdateQueryImpl("Resources");
            query.setUpdateColumn("IPADDRESS", (Object)ipaddress);
            Criteria crit = new Criteria(new Column("Resources", "RESOURCEID"), rid, 0);
            query.setCriteria(crit);
            FAServerUtil.getPersistence().update((UpdateQuery)query);
        }
        catch (Exception ee) {
            LOGGER.log(Level.INFO, " Error while updating rid =={0} for ipaddress =={1}", new Object[]{rid, ipaddress});
            ee.printStackTrace();
        }
    }

    private void updateDatabase(File gzFile, String ipaddress) {
        try {
            Criteria crit = new Criteria(new Column("Resources", "RESOURCENAME"), (Object)ipaddress, 0);
            Object rid = this.getResourceId(crit);
            Long status = new Long(0L);
            if (rid == null && (rid = this.getResourceId(crit = new Criteria(new Column("Resources", "IPADDRESS"), (Object)ipaddress, 0))) == null) {
                status = new Long(-1L);
            }
            long currentTime = System.currentTimeMillis();
            DataObject dObject = DataAccess.constructDataObject();
            Row row = new Row("FAArchivedFiles");
            row.set("RID", rid);
            row.set("START_TIME", this.sort.first());
            row.set("ARCHIVED_TIME", (Object)new Long(gzFile.lastModified()));
            row.set("SIZE", (Object)new Long(gzFile.length()));
            row.set("FILE_NAME", (Object)gzFile.getAbsolutePath());
            row.set("STATUS", (Object)status);
            if (FirewallConstants.getTrafficIndex() && this.lazyIndexall == 0 || this.lazyIndexall == 1) {
                row.set("INDEXALL_STATUS", (Object)1);
                row.set("LOG_STARTTIME", (Object)(System.currentTimeMillis() - FirewallConstants.getArchiveZipLong() + ""));
                row.set("LOG_ENDTIME", (Object)(System.currentTimeMillis() + ""));
                row.set("STATUS", (Object)2);
            }
            dObject.addRow(row);
            LOGGER.log(Level.INFO, " Database is updated for Logged =={0} length =={1}", new Object[]{gzFile, new Long(gzFile.length())});
            DataAccess.add((DataObject)dObject);
        }
        catch (Exception ee) {
            LOGGER.log(Level.INFO, " EXCEPTION WHILE Archiving File in database ========={0} IpAddress =={1}", new Object[]{gzFile.toString(), ipaddress});
            ee.printStackTrace();
        }
    }

    private String getZipComment(String host) {
        StringBuffer buffer = new StringBuffer();
        int index = this.context.findFormatFromLearnings(host);
        LogFormat format = this.context.getLogFormat(index);
        if (format == null) {
            return null;
        }
        buffer.append("parserName=");
        buffer.append(format.getName());
        if (format.preParserRulesAvailable()) {
            index = this.context.findPreFormatFromLearnings(host);
            ParserRule rule = format.getPreParserRule(index);
            if (rule == null) {
                return buffer.toString();
            }
            buffer.append(";preParserName=");
            buffer.append(rule.getName());
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createZipFile(String directoryName, String resName, String dnsName) {
        File directory = new File(directoryName);
        if (!directory.isDirectory()) {
            return null;
        }
        File hotDirectory = new File(directoryName + File.separator + HOT_DIRECTORY_NAME);
        if (!hotDirectory.exists() || !hotDirectory.isDirectory()) {
            return null;
        }
        File[] files = hotDirectory.listFiles();
        if (files.length == 0) {
            return null;
        }
        ArrayList<String> fileList = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            fileList.add(files[i].getAbsolutePath());
        }
        Collections.sort(fileList);
        ArrayList<File> luceneList = new ArrayList<File>();
        ArrayList<Long> arr = new ArrayList<Long>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String dateString = format.format(new Date());
        String zipFileName = directory.getAbsolutePath() + File.separator + COLD_DIRECTORY_NAME + File.separator + resName + "_" + dateString + ".zip";
        FileOutputStream dest = null;
        BufferedInputStream origin = null;
        ZipOutputStream out = null;
        FileInputStream fi = null;
        try {
            dest = new FileOutputStream(zipFileName);
            out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[FirewallConstants.getArchiveBufferSize()];
            Signature sign = null;
            TimeStampingAPI timeStamping = null;
            if (FirewallConstants.isTimeStampingEnabled()) {
                timeStamping = TimeStampingAPI.getInstance();
                sign = timeStamping.getSignatureObjToSign();
            }
            File file = null;
            for (int i = 0; i < fileList.size(); ++i) {
                int count;
                ArchiveFile currentFile;
                file = new File((String)fileList.get(i));
                String filename = file.getName();
                long time = -1L;
                try {
                    time = format.parse(filename).getTime();
                }
                catch (Exception ee) {
                    // empty catch block
                }
                if (time > 0L) {
                    arr.add(new Long(time));
                }
                if ((currentFile = (ArchiveFile)this.archiveFileMap.get(resName)) != null && currentFile.getFileName().equals(file.getAbsolutePath())) continue;
                LOGGER.log(Level.FINER, "ADDING  {0} To zip {1}", new Object[]{filename, zipFileName});
                fi = new FileInputStream(file);
                origin = new BufferedInputStream(fi, FirewallConstants.getArchiveBufferSize());
                ZipEntry entry = new ZipEntry(filename);
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, FirewallConstants.getArchiveBufferSize())) != -1) {
                    out.write(data, 0, count);
                    if (sign == null) continue;
                    timeStamping.updateDataIntoSignature(sign, data, 0, count);
                }
                fi.close();
                origin.close();
                luceneList.add(file);
            }
            if (sign != null) {
                String signatureStr = timeStamping.getSignedString(sign);
                if (signatureStr != null) {
                    ZipEntry entry = new ZipEntry(resName + "_" + dateString + ".sgn");
                    out.putNextEntry(entry);
                    out.write(signatureStr.getBytes());
                }
                sign = null;
            }
            this.sort = new TreeSet(arr);
            this.updateLucenePath(luceneList, zipFileName);
        }
        catch (Exception ee) {
            LOGGER.log(Level.FINER, " Exception while creating Zip file {0}", zipFileName);
            ee.printStackTrace();
        }
        finally {
            try {
                if (origin != null) {
                    origin.close();
                }
                if (out != null) {
                    out.close();
                }
                if (dest != null) {
                    dest.close();
                }
                if (fi != null) {
                    fi.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return zipFileName;
    }

    private void updateLucenePath(List array, String zipFileName) {
        for (File file : array) {
            String fileName = file.getName();
            String absName = file.getAbsolutePath();
            try {
                String pathId = RawExtracter.getFileId((String)absName);
                LOGGER.log(Level.FINER, "updatingPathDetails with " + new File(zipFileName).getAbsolutePath() + " pathId " + pathId);
                RawExtracter.updatePath((String)pathId, (String)(new File(zipFileName).getAbsolutePath() + "#" + fileName));
                file.delete();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archiveRecord(Record record) {
        int size;
        ArchiveFile file;
        if (!FirewallConstants.needToArchive()) {
            return;
        }
        String host = record.getResource();
        ++archiveCount;
        String resourceName = FirewallLicenseManager.getInstance().getResourceNameFromDevice(host);
        if (resourceName == null) {
            resourceName = host;
        }
        if ((file = (ArchiveFile)this.archiveFileMap.get(resourceName)) == null) {
            String header = FAServerUtil.getHeader(host);
            if (host.equals(record.getHost()) && header != null) {
                return;
            }
            file = new ArchiveFile(resourceName, record.getHost());
            this.archiveFileMap.put(resourceName, file);
        }
        if ((size = file.logBufferSize()) > FirewallConstants.getMaximumArchiveRecords()) {
            return;
        }
        record.setIndex(file.getFileLength());
        file.writeLog(record);
        record.setArchivedFile(file.getFileId());
        if (size >= FirewallConstants.getArchiveRecords()) {
            Integer n = this.waitObject;
            synchronized (n) {
                this.waitObject.notify();
            }
        }
    }

    private void getInitialCompressTimeFromDB() {
        int hour = 0;
        int min = 0;
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("SystemConfigurations"));
            query.addSelectColumn(new Column("SystemConfigurations", "*"));
            DataObject obj = DataAccess.get((SelectQuery)query);
            Iterator iter = obj.getRows("SystemConfigurations");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                String confName = (String)row.get("CONF_NAME");
                Object confValue = row.get("CONF_VALUE");
                if (confValue == null) continue;
                if (confName.equals("firstArchiveZipCreationHour")) {
                    String tempHour = confValue.toString();
                    hour = Integer.parseInt(tempHour);
                }
                if (!confName.equals("firstArchiveZipCreationMin")) continue;
                String tempMin = confValue.toString();
                min = Integer.parseInt(tempMin);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GregorianCalendar gc = new GregorianCalendar();
        int today = gc.get(5);
        int year = gc.get(1);
        int month = gc.get(2);
        gc.set(year, month, today, hour, min);
        long tempTimeInMillis = gc.getTimeInMillis();
        FirewallConstants.setFirstZipCreationTime(tempTimeInMillis);
        FirewallConstants.setNewInitialCompressTime(true);
    }

    public void shutdown() {
        this.shutdown = true;
    }

    static {
        BASE_ARCHIVE_DIRECTORY = FirewallConstants.getArchiveLocation() + File.separator;
        ServerUtil.setArchiveFileLocation((String)FirewallConstants.getArchiveLocation());
        LuceneUtil.initForFWA();
    }
}

