/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.imp;

import com.maverick.sftp.SftpFile;
import com.maverick.ssh.HostKeyVerification;
import com.maverick.ssh.LicenseManager;
import com.maverick.ssh.PasswordAuthentication;
import com.maverick.ssh.SshAuthentication;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshConnector;
import com.maverick.ssh.SshTransport;
import com.maverick.ssh.components.SshPublicKey;
import com.maverick.ssh1.Ssh1Client;
import com.maverick.ssh2.Ssh2Client;
import com.maverick.ssh2.Ssh2Context;
import com.sshtools.net.SocketTransport;
import com.sshtools.sftp.SftpClient;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SFTPUtil {
    private static final Logger LOGGER;
    private static Logger log;

    public static SftpClient getSFTPClient(String hostName, String userName, String password, boolean binaryFile) throws Exception {
        return SFTPUtil.getSFTPClient(hostName, userName, password, binaryFile, 22);
    }

    public static SftpClient getSFTPClient(String hostName, String userName, String password, boolean binaryFile, int sftpPort) throws Exception {
        log.info("Connecting ::");
        try {
            SshConnector con = SshConnector.getInstance();
            HostKeyVerification hkv = new HostKeyVerification(){

                public boolean verifyHost(String hostName, SshPublicKey key) {
                    try {
                        log.info("In SFTPUtil The connected host's key (" + key.getAlgorithm() + ") is" + key.getFingerprint());
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            };
            Ssh2Context ssh2Context = (Ssh2Context)con.getContext(2);
            ssh2Context.setHostKeyVerification(hkv);
            ssh2Context.setPreferredPublicKey("ssh-dss");
            SocketTransport t = new SocketTransport(hostName, sftpPort);
            t.setTcpNoDelay(true);
            SshClient ssh = con.connect((SshTransport)t, userName);
            if (ssh instanceof Ssh1Client) {
                log.info(hostName + " is an SSH1 server!! SFTP is not supported");
                ssh.disconnect();
                return null;
            }
            log.info(hostName + " is an SSH2 server");
            Ssh2Client ssh2 = (Ssh2Client)ssh;
            PasswordAuthentication pwd = new PasswordAuthentication();
            pwd.setPassword(password);
            if (ssh2.authenticate((SshAuthentication)pwd) == 1 && ssh2.isConnected()) {
                if (ssh.isAuthenticated()) {
                    SftpClient sftp = new SftpClient((SshClient)ssh2);
                    if (binaryFile) {
                        log.info("Setting up BINARY MODE transfers");
                        sftp.setTransferMode(1);
                    } else {
                        log.info("Setting up TEXT MODE transfers");
                        sftp.setRemoteEOL(2);
                        sftp.setTransferMode(2);
                    }
                    return sftp;
                }
                log.info("SSH is not Authenticated");
                return null;
            }
            if (ssh2.authenticate((SshAuthentication)pwd) == 2) {
                log.info("Authentication Failed");
                return null;
            }
            log.info("Authentication Not Succeeded");
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String doSFTP(SftpClient sftp, String baseDirectory, String remoteDir, String fileName) throws Exception {
        try {
            String remoteFile;
            log.info("Change the dir");
            if (remoteDir != null) {
                sftp.cd(remoteDir);
            }
            log.info("Getting file");
            StringBuffer tmpBuf = new StringBuffer();
            if (baseDirectory == null) {
                tmpBuf.append(System.getProperty("server.dir"));
                tmpBuf.append(File.separator);
                tmpBuf.append("server");
                tmpBuf.append(File.separator);
                tmpBuf.append("imported_files");
                tmpBuf.append(File.separator);
                tmpBuf.append(fileName);
                tmpBuf.append(File.separator);
            } else {
                tmpBuf.append(baseDirectory);
            }
            LOGGER.log(Level.FINER, "creating directory<->{0}", tmpBuf);
            File wd = new File(tmpBuf.toString());
            if (!wd.exists()) {
                wd.mkdirs();
            }
            tmpBuf.append(File.separator);
            tmpBuf.append(fileName);
            String string = remoteFile = remoteDir != null ? remoteDir : fileName;
            if (remoteDir != null && !remoteDir.endsWith(fileName)) {
                if (remoteDir.indexOf("/") >= 0) {
                    remoteFile = remoteFile + "/";
                } else if (remoteDir.indexOf("\\") >= 0) {
                    remoteFile = remoteFile + "\\";
                }
                remoteFile = remoteFile + fileName;
                LOGGER.log(Level.FINER, "remoteFile <->{0}", remoteFile);
            }
            try {
                sftp.get(remoteFile, tmpBuf.toString());
                return tmpBuf.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SftpFile[] getList(String dir, SftpClient sftp) throws Exception {
        LOGGER.log(Level.FINER, " Getting list for  {0}", sftp);
        if (dir != null) {
            sftp.cd(dir);
        }
        try {
            ArrayList<SftpFile> modifiedList = new ArrayList<SftpFile>();
            String currentDir = sftp.pwd();
            SftpFile[] list = sftp.ls(currentDir);
            for (int i = 0; i < list.length; ++i) {
                if (".".equals(list[i].getFilename()) || "..".equals(list[i].getFilename())) continue;
                modifiedList.add(list[i]);
            }
            SftpFile[] nwlist = new SftpFile[modifiedList.size()];
            modifiedList.toArray(nwlist);
            return nwlist;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void logOut(SftpClient sftp) throws Exception {
        if (sftp == null) {
            return;
        }
        log.info("Quitting client");
        sftp.quit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getParentDir(String origDir, SftpClient sftp) throws Exception {
        String parentDir = null;
        try {
            sftp.cd(" ..");
            parentDir = sftp.pwd();
        }
        catch (Exception e) {
            try {
                parentDir = sftp.pwd();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        finally {
            try {
                sftp.cd(origDir);
            }
            catch (Exception eee) {
                eee.printStackTrace();
            }
        }
        return parentDir;
    }

    static {
        LicenseManager.addLicense((String)"----BEGIN 3SP LICENSE----\r\nProduct : J2SSH Maverick\r\nLicensee: AdventNet\r\nComments: Subramanian T\r\nType    : Global OEM License\r\nCreated : 23-Oct-2008\r\n\r\n3787201462803E5BA600F3CF9CCEF4C842E8680925CF713A\r\nCDBC5388D8B90E239F79CBAC95C69C70CA42AAB72D6926CE\r\n11AD592013C13176CE53DB6A4E54C720078425CB58D7D1A8\r\nBF7C21ABB7B09A0FE7AF7B1463CBFF19BE2949308E35CA57\r\nCA2A8163759E4BBDA1F8D31ACFA4C3AE0391CEEE5F848904\r\nA97D6D20743869F553F0BE75ADFA31B1A793912AA006516B\r\n----END 3SP LICENSE----\r\n");
        LOGGER = Logger.getLogger(SFTPUtil.class.getName());
        log = Logger.getLogger(SFTPUtil.class.getName());
    }
}

