/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.lc.IPFIXTemplate;
import com.adventnet.fa.server.lc.IPFixStaticFlowThread;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IPFIXStaticFlowHandler {
    private static final Logger LOGGER = Logger.getLogger(IPFIXStaticFlowHandler.class.getName());
    private static IPFIXTemplate.IPFIX_IDS ipfix_ids;
    private static IPFIXStaticFlowHandler ipfixHandler;
    private Map idMap = new HashMap();
    private Map objMap = new HashMap();
    private String name = null;
    private int sig_id;
    private String table = null;
    private String signame = null;

    public IPFIXStaticFlowHandler() {
        this.idMap.put(261, "IPFIXApplications");
        this.idMap.put(264, "IPFIXAttacks");
        this.idMap.put(265, "IPFIXViruses");
        this.idMap.put(266, "IPFIXSpywares");
        this.loadDBinMemory();
    }

    public static IPFIXStaticFlowHandler getInstance() {
        if (ipfixHandler == null) {
            ipfixHandler = new IPFIXStaticFlowHandler();
        }
        return ipfixHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDBinMemory() {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        if (this.idMap != null) {
            try {
                con = RelationalAPI.getInstance().getConnection();
                stmt = con.createStatement();
                for (String table : this.idMap.values()) {
                    String query = "SELECT DISTINCT(ENT_ID) FROM " + table;
                    rs = stmt.executeQuery(query);
                    if (!rs.isBeforeFirst()) continue;
                    IPFixStaticFlowThread thrd = new IPFixStaticFlowThread(table);
                    this.objMap.put(table, thrd);
                    while (rs.next()) {
                        DataObject doo = this.getRowsFromDB(table, rs.getInt(1));
                        if (doo.isEmpty()) continue;
                        thrd.populateDataMap(table, doo);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (con != null) {
                        con.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
    }

    private DataObject getRowsFromDB(String tableName, int ent_id) {
        DataObject dbData = null;
        try {
            SelectQueryImpl selectquery = new SelectQueryImpl(new Table(tableName));
            selectquery.addSelectColumn(new Column(tableName, "*"));
            selectquery.setCriteria(new Criteria(new Column(tableName, "ENT_ID"), (Object)ent_id, 0));
            selectquery.setRange(new Range(1, IPFixStaticFlowThread.MAX_CAP));
            dbData = DataAccess.get((SelectQuery)selectquery);
        }
        catch (Exception exp) {
            String msg = "Exception while load details from table " + tableName;
            LOGGER.log(Level.WARNING, msg, exp);
        }
        return dbData;
    }

    private void callFlowThread(int flowSetId, int id, String name, int entId) {
        this.table = (String)this.idMap.get(flowSetId);
        if (this.table == null) {
            return;
        }
        IPFixStaticFlowThread thrd = (IPFixStaticFlowThread)this.objMap.get(this.table);
        if (thrd == null) {
            thrd = new IPFixStaticFlowThread(this.table);
            this.objMap.put(this.table, thrd);
        }
        thrd.updateSignatures(flowSetId, id, name, entId);
    }

    public void handleAppFlow(String[] data, int flowSetId, int entId) {
        this.sig_id = new Integer(data[IPFIXTemplate.IPFIX_IDS.APP_SIG_ID.ordinal()]);
        this.name = data[IPFIXTemplate.IPFIX_IDS.APP_NAME.ordinal()] + "," + data[IPFIXTemplate.IPFIX_IDS.APP_CAT.ordinal()];
        this.callFlowThread(flowSetId, this.sig_id, this.name, entId);
    }

    public void handleAttackFlow(String[] data, int flowSetId, int entId) {
        this.sig_id = new Integer(data[IPFIXTemplate.IPFIX_IDS.IPS_SIG_ID.ordinal()]);
        this.name = data[IPFIXTemplate.IPFIX_IDS.IPS_NAME.ordinal()];
        this.callFlowThread(flowSetId, this.sig_id, this.name, entId);
    }

    public void handleVirusFlow(String[] data, int flowSetId, int entId) {
        this.sig_id = new Integer(data[IPFIXTemplate.IPFIX_IDS.GAV_SIG_ID.ordinal()]);
        this.name = data[IPFIXTemplate.IPFIX_IDS.VIRUS_NAME.ordinal()];
        this.callFlowThread(flowSetId, this.sig_id, this.name, entId);
    }

    public void handleSpywareFlow(String[] data, int flowSetId, int entId) {
        this.sig_id = new Integer(data[IPFIXTemplate.IPFIX_IDS.ASPY_SIG_ID.ordinal()]);
        this.name = data[IPFIXTemplate.IPFIX_IDS.ASPY_NAME.ordinal()];
        this.callFlowThread(flowSetId, this.sig_id, this.name, entId);
    }

    public String getApplName(int id, int entId) {
        this.signame = null;
        try {
            IPFixStaticFlowThread flowThrd = (IPFixStaticFlowThread)this.objMap.get("IPFIXApplications");
            if (flowThrd != null) {
                this.signame = flowThrd.getSigName(id, entId);
                if (this.signame == null) {
                    Criteria crt = new Criteria(new Column("IPFIXApplications", "APPLICATION_ID"), (Object)id, 0);
                    DataObject doo = DataAccess.get((String)"IPFIXApplications", (Criteria)(crt = crt.and(new Criteria(new Column("IPFIXApplications", "ENT_ID"), (Object)entId, 0))));
                    if (!doo.isEmpty()) {
                        this.signame = doo.getFirstValue("IPFIXApplications", "APPLICATION_NAME") + "," + doo.getFirstValue("IPFIXApplications", "APPLICATION_CAT");
                        flowThrd.updateMap(id, this.signame, entId);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.signame;
    }

    public String getAttackName(int id, int entId) {
        this.signame = null;
        try {
            IPFixStaticFlowThread flowThrd = (IPFixStaticFlowThread)this.objMap.get("IPFIXAttacks");
            if (flowThrd != null) {
                this.signame = flowThrd.getSigName(id, entId);
                if (this.signame == null) {
                    Criteria crt = new Criteria(new Column("IPFIXAttacks", "ATTACK_SIG_ID"), (Object)id, 0);
                    DataObject doo = DataAccess.get((String)"IPFIXAttacks", (Criteria)(crt = crt.and(new Criteria(new Column("IPFIXAttacks", "ENT_ID"), (Object)entId, 0))));
                    if (!doo.isEmpty()) {
                        this.signame = (String)doo.getFirstValue("IPFIXAttacks", "ATTACK_NAME");
                        flowThrd.updateMap(id, this.signame, entId);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.signame;
    }

    public String getVirusName(int id, int entId) {
        this.signame = null;
        try {
            IPFixStaticFlowThread flowThrd = (IPFixStaticFlowThread)this.objMap.get("IPFIXViruses");
            if (flowThrd != null) {
                this.signame = flowThrd.getSigName(id, entId);
                if (this.signame == null) {
                    Criteria crt = new Criteria(new Column("IPFIXViruses", "VIRUS_SIG_ID"), (Object)id, 0);
                    DataObject doo = DataAccess.get((String)"IPFIXViruses", (Criteria)(crt = crt.and(new Criteria(new Column("IPFIXViruses", "ENT_ID"), (Object)entId, 0))));
                    if (!doo.isEmpty()) {
                        this.signame = (String)doo.getFirstValue("IPFIXViruses", "VIRUS_NAME");
                        flowThrd.updateMap(id, this.signame, entId);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.signame;
    }

    public String getSpywareName(int id, int entId) {
        this.signame = null;
        try {
            IPFixStaticFlowThread flowThrd = (IPFixStaticFlowThread)this.objMap.get("IPFIXSpywares");
            if (flowThrd != null) {
                this.signame = flowThrd.getSigName(id, entId);
                if (this.signame == null) {
                    Criteria crt = new Criteria(new Column("IPFIXSpywares", "SPY_SIG_ID"), (Object)id, 0);
                    DataObject doo = DataAccess.get((String)"IPFIXSpywares", (Criteria)(crt = crt.and(new Criteria(new Column("IPFIXSpywares", "ENT_ID"), (Object)entId, 0))));
                    if (!doo.isEmpty()) {
                        this.signame = (String)doo.getFirstValue("IPFIXSpywares", "SPY_NAME");
                        flowThrd.updateMap(id, this.signame, entId);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.signame;
    }

    public void shutdown() {
        for (IPFixStaticFlowThread thrd : this.objMap.values()) {
            thrd.shutdown();
        }
    }

    static {
        ipfixHandler = null;
    }
}

