/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.la.util.FixedHashMap;
import com.adventnet.la.util.ResourceCheckerUtil;
import com.adventnet.la.util.ServerUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IPFixStaticFlowThread
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(IPFixStaticFlowThread.class.getName());
    protected static int MAX_CAP = Integer.parseInt(System.getProperty("IPFIXMapSize", "10000"));
    private PrintWriter pWriter = null;
    private FileWriter writer = null;
    private boolean shutdown = false;
    boolean isMssql = "mssql".equals(System.getProperty("DBType", "mysql"));
    boolean isPostgres = "postgres".equals(System.getProperty("DBType"));
    private static boolean isWinAuthType = "true".equals(System.getProperty("isWinAuthType", "false"));
    private String dbserver = "";
    private String dbname = "";
    private String dbuser = "";
    private String dbpass = "";
    private String commandToExecute = null;
    Object flowObj = new Object();
    Object dumpObj = new Object();
    private Map tempMap = new HashMap();
    private Map vendorMap = Collections.synchronizedMap(new FixedHashMap(100));
    private int waitBeforeDump = 300000;
    File file = null;
    private String table = null;
    String tempfile = null;
    String fileName = null;
    private static String tmpDir = System.getProperty("server.home") + File.separator + "server" + File.separator + "tmp";
    private int fileCount = 0;

    public IPFixStaticFlowThread(String table) {
        LOGGER.log(Level.FINER, "IPFixStaticFlowThread for table {0} ", table);
        this.table = table;
        this.createTempFile();
        this.generateMssqlParams();
        this.start();
    }

    private void createTempFile() {
        try {
            this.fileCount = this.fileCount == 0 ? 1 : 0;
            this.fileName = this.table + "_" + this.fileCount + ".CSV";
            this.writer = new FileWriter(tmpDir + File.separator + this.fileName, false);
            this.pWriter = new PrintWriter((Writer)new BufferedWriter(this.writer), false);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, " Exception while opening file to log flows: {0}", e);
        }
    }

    private void generateMssqlParams() {
        if (this.isMssql) {
            String osName;
            String xmlFilePath = System.getProperty("server.home") + File.separator + "conf" + File.separator + "database_params.conf";
            HashMap DBParams = ResourceCheckerUtil.getConstraints((String)xmlFilePath, (String)"firewall");
            if (DBParams != null) {
                this.dbserver = (String)DBParams.get("DBServer");
                this.dbname = (String)DBParams.get("DBName");
                this.dbuser = (String)DBParams.get("DBUser");
                this.dbpass = (String)DBParams.get("DBPass");
                if (this.dbpass == null) {
                    this.dbpass = "";
                }
            }
            if ((osName = System.getProperty("os.name")).toLowerCase().indexOf("windows nt") > -1 || osName.equalsIgnoreCase("windows 2000") || osName.equalsIgnoreCase("windows xp") || osName.equalsIgnoreCase("Windows 2003") || osName.equalsIgnoreCase("windows vista")) {
                this.commandToExecute = "cmd  /c ";
            } else if (osName.indexOf("95") >= 0 || osName.indexOf("98") >= 0) {
                this.commandToExecute = "command.com /c ";
            }
        }
    }

    public void populateDataMap(String table, DataObject dobj) {
        try {
            LOGGER.log(Level.FINER, " populateDataMap for {0}", table);
            int ent_id = (Integer)dobj.getFirstValue(table, "ENT_ID");
            Map<Object, String> dataMap = Collections.synchronizedMap(new FixedHashMap(MAX_CAP, 0.75f, true));
            this.vendorMap.put(ent_id, dataMap);
            String value = null;
            boolean isAppl = "IPFIXApplications".equals(table);
            Iterator itr = dobj.getRows(table);
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                value = isAppl ? row.get(2) + "," + row.get(3) : (String)row.get(2);
                dataMap.put(row.get(1), value);
            }
            LOGGER.log(Level.FINER, " dataMap size {0}", dataMap.size());
        }
        catch (Exception ee) {
            LOGGER.log(Level.INFO, " Exception while inserting into mem : {0}", ee);
        }
    }

    public void updateSignatures(int flowSetId, int key, String value, int entId) {
        Map<Integer, String> dataMap = (Map<Integer, String>)this.vendorMap.get(entId);
        if (dataMap == null) {
            dataMap = Collections.synchronizedMap(new FixedHashMap(MAX_CAP, 0.75f, true));
            this.vendorMap.put(entId, dataMap);
        }
        if (dataMap.size() < MAX_CAP) {
            dataMap.put(key, value);
        }
        this.loadDatainFile(key, value, entId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDatainFile(int id, String name, int entId) {
        block8: {
            try {
                String data = id + "," + name + "," + entId;
                Object object = this.flowObj;
                synchronized (object) {
                    this.tempMap.put(id + entId, name);
                    this.pWriter.println(data);
                }
                if (this.tempMap.size() <= 1000) break block8;
                object = this.dumpObj;
                synchronized (object) {
                    this.dumpObj.notify();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                this.dumpToFile();
                this.updateDatabase();
                Object object = this.dumpObj;
                synchronized (object) {
                    try {
                        this.dumpObj.wait(this.waitBeforeDump);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
            }
            catch (Exception eee) {
                eee.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void dumpToFile() {
        LOGGER.log(Level.FINER, "inside dumpToFile ;;;;;;;;;;;;; " + this.tempMap.size());
        this.waitBeforeDump = 0;
        if (this.tempMap.size() == 0) {
            return;
        }
        if (this.tempMap.size() >= 1000) {
            this.waitBeforeDump = 300000;
        }
        Object object = this.flowObj;
        synchronized (object) {
            this.pWriter.flush();
            this.closeWriters();
            this.tempMap = new HashMap();
        }
    }

    private void closeWriters() {
        try {
            this.pWriter.close();
            this.writer.close();
            this.pWriter = null;
            this.writer = null;
            this.tempfile = this.fileName;
            this.fileName = null;
            this.createTempFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDatabase() {
        Connection con = null;
        Statement stmt = null;
        try {
            if (this.tempfile != null) {
                String file = tmpDir + File.separator + this.tempfile;
                file = file.replace("\\", "/");
                if (this.isMssql) {
                    this.loadDataInMssql(file);
                } else {
                    RelationalAPI relAPI = RelationalAPI.getInstance();
                    con = relAPI.getConnection();
                    stmt = con.createStatement();
                    if (this.isPostgres) {
                        con.setAutoCommit(false);
                        String temp_table = this.table + "_Temp";
                        stmt.addBatch("CREATE TEMP TABLE " + temp_table + " (LIKE " + this.table + ") ON COMMIT DROP");
                        stmt.addBatch("COPY " + temp_table + " FROM '" + file + "' DELIMITER ','");
                        stmt.addBatch("INSERT INTO " + this.table + " SELECT * FROM " + temp_table + " EXCEPT SELECT * FROM " + this.table);
                        stmt.executeBatch();
                        con.commit();
                    } else {
                        String query = "LOAD DATA INFILE '" + file + "' IGNORE INTO TABLE " + this.table + " FIELDS TERMINATED BY ',' LINES TERMINATED BY '\r\n'";
                        stmt.execute(query);
                    }
                }
                this.deleteFile(this.tempfile);
                this.tempfile = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (con != null) {
                    stmt.close();
                    con.close();
                }
            }
            catch (Exception ee) {
                stmt = null;
                con = null;
                ee.printStackTrace();
            }
        }
    }

    private void loadDataInMssql(String file) throws Exception {
        ServerUtil.BCPLOCK.lock();
        String command = null;
        BufferedReader in = null;
        FileOutputStream fos = null;
        try {
            int c;
            command = isWinAuthType ? this.commandToExecute + " ..\\bin\\bcp.exe " + this.dbname + ".dbo." + this.table + " in " + file + " -S " + this.dbserver + " -T -t \",\" -r \"\\n\" -e ..\\logs\\ipfixMssqlerr.txt -c -q" : this.commandToExecute + " ..\\bin\\bcp.exe " + this.dbname + ".dbo." + this.table + " in " + file + " -S " + this.dbserver + " -U " + this.dbuser + " -P \"" + this.dbpass + "\" -t \",\" -r \"\\n\" -e ..\\logs\\ipfixMssqlerr.txt -c -q";
            fos = new FileOutputStream(System.getProperty("server.home") + File.separator + "logs" + File.separator + "loadIpfixData.log");
            Process p = Runtime.getRuntime().exec(command);
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((c = in.read()) != -1) {
                fos.write(c);
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            ServerUtil.BCPLOCK.unlock();
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ee) {
                    LOGGER.log(Level.INFO, " Exception while closing buffer reader ::: {0} ", ee);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception ee) {
                    LOGGER.log(Level.INFO, " Exception while closing fos ::: {0} ", ee);
                }
            }
        }
    }

    private void deleteFile(String file) {
        try {
            if (file != null) {
                File f = new File(tmpDir + File.separator + file);
                f.delete();
                f = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSigName(int id, int entId) {
        String sig = null;
        if (this.vendorMap.get(entId) != null) {
            Map dataMap = (Map)this.vendorMap.get(entId);
            sig = (String)dataMap.get(id);
            if (sig == null) {
                sig = (String)this.tempMap.get(id + entId);
            }
            LOGGER.log(Level.FINER, " Signature Name for ID {0} is {1}", new Object[]{id, sig});
        }
        return sig;
    }

    public void updateMap(int id, String name, int entId) {
        if (name != null) {
            Map dataMap = (Map)this.vendorMap.get(entId);
            dataMap.put(id, name);
        }
    }

    public Map getMap() {
        return this.vendorMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        Object object = this.flowObj;
        synchronized (object) {
            this.pWriter.flush();
            this.closeWriters();
            this.updateDatabase();
        }
    }
}

