/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.lc.LCManager;
import com.adventnet.mfw.bean.BeanUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.WritableDataObject;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LCConfigHandler {
    private static final Logger LOGGER = Logger.getLogger(LCConfigHandler.class.getName());
    public Persistence persistence = null;
    DataObject lcConfig = null;
    private static LCConfigHandler handler = null;

    public LCConfigHandler() {
        this.loadConfiguration();
    }

    public static LCConfigHandler getInstance() {
        if (handler == null) {
            handler = new LCConfigHandler();
        }
        return handler;
    }

    void loadConfiguration() {
        Table ent = new Table("DServers");
        SelectQueryImpl selectquery = new SelectQueryImpl(ent);
        Column selectAtt = new Column("DServers", "*");
        selectquery.addSelectColumn(selectAtt);
        Column selectAtt2 = new Column("LeaServers", "*");
        selectquery.addSelectColumn(selectAtt2);
        Column selectAtt4 = new Column("SyslogCollectors", "*");
        selectquery.addSelectColumn(selectAtt4);
        selectquery.addJoin(new Join("DServers", "SyslogCollectors", new String[]{"DSERVER_ID"}, new String[]{"DSERVER_ID"}, 1));
        selectquery.addJoin(new Join("DServers", "LeaServers", new String[]{"DSERVER_ID"}, new String[]{"DSERVER_ID"}, 1));
        try {
            this.lcConfig = this.getPersistence().get((SelectQuery)selectquery);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        LOGGER.log(Level.FINER, " AFTER EXECUTING SELECT QUERY :: {0}", this.lcConfig);
    }

    void populateConfiguration() {
        try {
            List dos = ((WritableDataObject)this.lcConfig).getDataObjects();
            for (DataObject d : dos) {
                Row syRow;
                Row fw = d.getFirstRow("DServers");
                String dServerName = (String)fw.get("DSERVER_NAME");
                String dServerIpAddress = (String)fw.get("DSERVER_IP");
                Object ds_id = fw.get("DSERVER_ID");
                Column dsCol = new Column("SyslogCollectors", "DSERVER_ID");
                Criteria dsCrit = new Criteria(dsCol, ds_id, 0);
                Iterator it = d.getRows("SyslogCollectors", dsCrit);
                while (it.hasNext()) {
                    syRow = (Row)it.next();
                    Long sy_port = (Long)syRow.get("PORT");
                    Long sys_id = (Long)syRow.get("SYSLOGCOLLECTOR_ID");
                    String status = (String)syRow.get("STATUS");
                    if (!"UP".equals(status)) continue;
                    LCManager.getInstance().addSyslogCollector(sys_id, sy_port.intValue());
                }
                dsCol = new Column("LeaServers", "DSERVER_ID");
                dsCrit = new Criteria(dsCol, ds_id, 0);
                it = d.getRows("LeaServers", dsCrit);
                while (it.hasNext()) {
                    syRow = (Row)it.next();
                    String fwName = (String)syRow.get("FIREWALL_NAME");
                    String fwIpAddress = (String)syRow.get("FIREWALL_IP");
                    Long port = (Long)syRow.get("LEA_PORT");
                    String recIp = (String)syRow.get("RECEIVER_IP");
                    Long recPort = (Long)syRow.get("RECEIVER_PORT");
                    boolean auth = (Boolean)syRow.get("AUTH_LOGIN");
                    LCManager.getInstance().addLeaLogCollector(fwName, fwIpAddress, port.intValue(), recIp, recPort.intValue(), auth);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    Persistence getPersistence() {
        try {
            this.persistence = (Persistence)BeanUtil.lookup((String)"Persistence");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.persistence;
    }
}

