/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.lc.ArchiveLog;
import com.adventnet.fa.server.lc.PacketUtil;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.util.EncryptionAPI;
import com.adventnet.la.util.TimeStampingAPI;
import com.adventnet.la.util.pe.FormatIdentifier;
import com.adventnet.la.util.pe.ParserEngineContext;
import com.adventnet.la.util.pe.ParserEngineHandler;
import com.adventnet.la.util.pe.ParserNotifier;
import com.adventnet.la.util.pe.Record;
import com.adventnet.la.util.pe.RecordParser;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.logsearch.index.api.LuceneData;
import com.adventnet.logsearch.index.api.LuceneRecord;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LoadArchiveHandler
implements Runnable {
    public ParserEngineContext context;
    public FormatIdentifier formatIdentifier;
    public RecordParser recordParser;
    public ParserNotifier parserNotifier;
    private long trafficBatchCount = 0L;
    private boolean ignoreUnParsedRecord = true;
    private static final Logger LOGGER = Logger.getLogger(LoadArchiveHandler.class.getName());
    private LogIndexingAPI indexingAPI = LogIndexingAPI.getInstance();
    private String fileName;
    private String hostName;
    private long fileSize = 0L;
    private long totalRecords = 0L;
    private static LoadArchiveHandler handler = null;
    private long startTime = 0L;
    private long recordCount = 0L;
    private int status = 0;
    private Object logStartTime;
    private Object logEndTime;
    private long afid = -1L;
    private boolean isEncryptedFile = false;
    private int infoNo = -1;
    private long archivedTime = -1L;
    private Long dbStatus = null;
    private static final Long NOT_LOADED = new Long(0L);
    private static final Long PROCESSING = new Long(1L);
    private static final Long LOAD_COMPLETED = new Long(2L);
    private static final Long INTEGRITY_VERIFIED = new Long(3L);
    private static final Long INTEGRITY_FAILED = new Long(4L);
    private static final int FILE_NOT_FOUND = 4;
    private static int lineSeparatorLength = 1;

    public LoadArchiveHandler() {
        this.context = new ParserEngineContext(System.getProperty("server.home") + File.separator + "server" + File.separator + "conf" + File.separator + "FirewallLogParserRules.xml");
        this.formatIdentifier = new FormatIdentifier(this.context);
        this.recordParser = new RecordParser(this.context);
        this.parserNotifier = new ParserNotifier(this.context);
    }

    public void init(long afid, String fileName, String hostName, long fileSize, long archivedTime) {
        this.reset();
        this.afid = afid;
        this.fileName = fileName;
        this.hostName = hostName;
        this.fileSize = fileSize;
        if (fileSize > 0L) {
            this.totalRecords = fileSize / 200L;
        }
        this.archivedTime = archivedTime;
        this.dbStatus = LOAD_COMPLETED;
    }

    private void reset() {
        this.afid = -1L;
        this.status = 0;
        this.startTime = 0L;
        this.totalRecords = 0L;
        this.recordCount = 0L;
        this.trafficBatchCount = 0L;
        this.logStartTime = null;
        this.logEndTime = null;
    }

    public static LoadArchiveHandler getInstance() {
        if (handler == null) {
            handler = new LoadArchiveHandler();
        }
        return handler;
    }

    @Override
    public void run() {
        this.status = 1;
        this.startTime = System.currentTimeMillis();
        this.updateToDB(PROCESSING);
        this.parseAndLoadArchivedData();
        this.status = 2;
        this.afid = -1L;
        FAServerUtil.doRemoveLearning(this.hostName, this.context);
    }

    private void updateToDB(Long loadStatus) {
        try {
            UpdateQueryImpl query = new UpdateQueryImpl("FAArchivedFiles");
            Criteria crt = new Criteria(new Column("FAArchivedFiles", "FILE_NAME"), (Object)this.fileName, 0);
            query.setCriteria(crt);
            query.setUpdateColumn("STATUS", (Object)loadStatus);
            if (this.logStartTime != null && this.logEndTime != null) {
                query.setUpdateColumn("LOG_STARTTIME", (Object)Long.valueOf(this.logStartTime + ""));
                query.setUpdateColumn("LOG_ENDTIME", (Object)Long.valueOf(this.logEndTime + ""));
                query.setUpdateColumn("TABLE_NAME", (Object)new String());
            }
            FAServerUtil.getPersistence().update((UpdateQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public long getIndexedRecordsCount() {
        return this.recordCount;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getLogStartTime() {
        return this.logStartTime + "";
    }

    public String getLogEndTime() {
        return this.logEndTime + "";
    }

    public int getInfoNo() {
        return this.infoNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseAndLoadArchivedData() {
        File location = new File(this.fileName);
        BufferedReader reader = null;
        try {
            boolean success;
            if (!location.exists()) {
                LOGGER.log(Level.WARNING, "No log file found in location:{0}", location);
                this.infoNo = 4;
                this.updateToDB(NOT_LOADED);
                return;
            }
            File tempGZFileName = new File(System.getProperty("server.home") + File.separator + "server" + File.separator + "tmp" + File.separator + "loadedFile.zip");
            if (this.fileName.endsWith(".gz")) {
                this.loadGUNZipContent(location, tempGZFileName);
                location = tempGZFileName;
            }
            if (!(success = this.loadData(location))) {
                this.updateToDB(this.dbStatus != LOAD_COMPLETED ? this.dbStatus : NOT_LOADED);
                return;
            }
            if (tempGZFileName.exists()) {
                tempGZFileName.delete();
            }
            this.indexingAPI.fflush();
            if (this.logStartTime == null) {
                this.logStartTime = System.currentTimeMillis() + "";
                this.logEndTime = System.currentTimeMillis() + "";
            } else if (this.logEndTime == null) {
                this.logEndTime = this.logStartTime;
            }
            this.checkTimeValues();
            this.updateToDB(this.dbStatus);
            LOGGER.log(Level.INFO, this.trafficBatchCount + " Traffic Records are indexed out of " + this.recordCount);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.log(Level.INFO, "unable to close Load Archive reader handle");
                }
            }
        }
    }

    private String findFormatAndGetTime(Object time) {
        String logTime = System.currentTimeMillis() + "";
        try {
            if (time == null) {
                return logTime;
            }
            logTime = time instanceof Timestamp ? String.valueOf(((Timestamp)time).getTime() / 1000L * 1000L) : String.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse((String)time).getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logTime;
    }

    private void checkTimeValues() {
        if (Long.parseLong(this.logStartTime + "") > Long.parseLong(this.logEndTime + "")) {
            String temp = this.logEndTime + "";
            this.logEndTime = this.logStartTime;
            this.logStartTime = temp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadData(File location) {
        ZipFile zipFile = null;
        try {
            long lastModifTime;
            Enumeration<? extends ZipEntry> enu = null;
            BufferedReader reader = null;
            if (location.getName().endsWith(".zip")) {
                zipFile = new ZipFile(location);
                enu = zipFile.entries();
            }
            if (enu == null) {
                LOGGER.log(Level.WARNING, "{0} is not a zip file", location);
                this.infoNo = 4;
                boolean bl = false;
                return bl;
            }
            String zipFileName = location.getName();
            String signatureFileName = zipFileName.substring(0, zipFileName.lastIndexOf(".zip")) + ".sgn";
            ZipEntry signZipEntry = zipFile.getEntry(signatureFileName);
            long l = lastModifTime = "true".equals(System.getProperty("checkSignatureOnly")) ? -1L : this.archivedTime;
            if (signZipEntry != null) {
                int signStatus;
                this.infoNo = signStatus = TimeStampingAPI.getInstance().verify(zipFile, signatureFileName, location.getAbsolutePath(), lastModifTime);
                System.out.println("Signature Verification Status = " + signStatus);
                if (signStatus > 0) {
                    this.dbStatus = INTEGRITY_FAILED;
                    boolean bl = false;
                    return bl;
                }
                this.dbStatus = INTEGRITY_VERIFIED;
            }
            while (enu.hasMoreElements()) {
                ZipEntry entry = enu.nextElement();
                String zipEntryFileName = entry.getName();
                if (zipEntryFileName.endsWith(".sgn")) continue;
                String archiveFileName = this.fileName.replaceAll("\\\\", "\\\\\\\\") + "#" + zipEntryFileName;
                LOGGER.log(Level.INFO, "Indexing the file {0}", archiveFileName);
                InputStream in = zipFile.getInputStream(entry);
                try {
                    reader = new BufferedReader(new InputStreamReader(in));
                    if (!reader.ready()) {
                        LOGGER.log(Level.WARNING, "{0} file is empty", archiveFileName);
                        continue;
                    }
                    if (entry.getName().endsWith(".enc")) {
                        this.isEncryptedFile = true;
                    }
                    this.indexData(reader, archiveFileName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (Exception exp) {
                        exp.printStackTrace();
                    }
                    this.isEncryptedFile = false;
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return true;
    }

    private String getRecord(BufferedReader br) throws IOException {
        String record = null;
        if (br == null) {
            return record;
        }
        record = this.isEncryptedFile ? EncryptionAPI.readEncryptedLine((BufferedReader)br) : br.readLine();
        return record;
    }

    public void indexData(BufferedReader reader, String archiveFileName) {
        try {
            String host;
            String pathID = "";
            pathID = this.getArchiveFileID(archiveFileName, 0);
            String data = null;
            long fileLength = 0L;
            long pathIndex = 0L;
            String string = host = this.hostName.indexOf("_PROXY") > -1 ? this.hostName.substring(0, this.hostName.indexOf("_PROXY")) : this.hostName;
            while ((data = this.getRecord(reader)) != null) {
                Object rid;
                Integer formatId;
                Record record;
                Hashtable table;
                if (data.trim().equals("")) continue;
                ++this.recordCount;
                if (this.recordCount >= this.totalRecords) {
                    this.totalRecords += 5000L;
                }
                pathIndex = fileLength;
                if (this.isEncryptedFile) {
                    fileLength += (long)(data.length() + 1);
                    data = EncryptionAPI.getDecryptionObj().decryptLog(data);
                } else {
                    fileLength += (long)(data.getBytes().length + lineSeparatorLength);
                }
                if ((table = this.parseRecord(record = new Record(this.hostName, "1", data))) == null || (formatId = (Integer)table.get("FORMAT_ID")) == null) continue;
                String fgtDevName = (String)table.get("FW_NAME");
                if (fgtDevName != null && (rid = LaCacheManager.getInstance().getFirewallId(fgtDevName)) != null) {
                    table.put("FW", fgtDevName);
                }
                Vector handlers = this.parserNotifier.getHandlersForFormat(formatId.intValue());
                for (int i = 0; i < handlers.size(); ++i) {
                    ParserEngineHandler handler = (ParserEngineHandler)handlers.elementAt(i);
                    table.put("fromLoadArchive", "true");
                    table = handler.recordParsed(this.context, host, table);
                }
                if (table == null || table.size() == 1) continue;
                Object timeVal = table.get("TIME");
                if (timeVal != null) {
                    long logTimeVal = Long.parseLong(this.findFormatAndGetTime(timeVal));
                    if (this.logStartTime == null || Long.parseLong(this.logStartTime + "") > logTimeVal) {
                        this.logStartTime = logTimeVal + "";
                    } else if (this.logEndTime == null || Long.parseLong(this.logEndTime + "") < logTimeVal) {
                        this.logEndTime = logTimeVal;
                    }
                }
                if ("1".equals(table.get("li"))) continue;
                record.setLogType("t");
                table = this.getConsolidatedTable(table);
                ArchiveLog impl = new ArchiveLog(table);
                record.setRawLogPointer(pathID + "_" + pathIndex);
                record.setRelationalData((LuceneData)impl);
                ++this.trafficBatchCount;
                if (this.trafficBatchCount % 500L == 0L) {
                    record.setUpdateBatch(true);
                }
                this.indexingAPI.indexRecordInBatch((LuceneRecord)record);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Hashtable getConsolidatedTable(Hashtable table) {
        String[] keys = new String[]{"DST", "RCVD", "DSTNAME"};
        String[] tableKeys = new String[]{"DEST", "RECEIVED", "DEST_NAME"};
        String[] defaultVals = new String[]{"unknown", "0", "unknown"};
        for (int i = 0; i < keys.length; ++i) {
            if (table.get(keys[i]) != null) continue;
            String val = defaultVals[i];
            if (table.get(tableKeys[i]) != null) {
                val = table.get(tableKeys[i]).toString();
            }
            table.put(keys[i], val);
        }
        if (table.get("RESOURCE") == null) {
            if (table.get("FW") != null) {
                table.put("RESOURCE", (String)table.get("FW"));
            } else {
                table.put("RESOURCE", this.hostName);
            }
        }
        if (table.get("USER") == null) {
            table.put("USER", table.get("USERNAME") == null ? "Unknown" : table.get("USERNAME"));
        }
        if (table.get("PROTOCOL") == null) {
            table.put("PROTOCOL", "Unknown");
        }
        return table;
    }

    private String getArchiveFileID(String pathName, int queryCondition) {
        String archiveFileID = "-1";
        try {
            SelectQueryImpl impl = new SelectQueryImpl(new Table("PathInfo"));
            Column cols = new Column("PathInfo", "*");
            impl.addSelectColumn(cols);
            Criteria crt = new Criteria(new Column("PathInfo", "PATHVALUE"), (Object)pathName, queryCondition);
            impl.setCriteria(crt);
            DataObject dObj = DataAccess.get((SelectQuery)impl);
            Row row = dObj.getRow("PathInfo");
            if (row != null && row.get("PATHID") != null) {
                archiveFileID = ((Integer)row.get("PATHID")).toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER.log(Level.FINER, "PATH ID is " + archiveFileID + " for PathName " + pathName);
        return archiveFileID;
    }

    public Hashtable parseRecord(Record record) {
        Hashtable<String, Object> unifiedOutput = new Hashtable<String, Object>();
        String data = record.getData();
        String host = record.getHost();
        if (data == null || "".equals(data)) {
            return null;
        }
        int formatIndex = this.formatIdentifier.getFormatIndex(data, host);
        if (formatIndex == -2) {
            LOGGER.log(Level.FINER, " UNABLE TO IDENTIFY THE LOG FORMAT FOR : {0}", host);
        } else {
            boolean success;
            int formatID;
            if (this.ignoreUnParsedRecord && (formatID = this.formatIdentifier.getFormatID(formatIndex)) == -1) {
                this.formatIdentifier.removeLearnings(host);
                if (PacketUtil.getCount(host) <= 0L) {
                    return null;
                }
            }
            if (!(success = this.recordParser.parseRecord(data, formatIndex, unifiedOutput, host))) {
                int previousFormatIndex = formatIndex;
                int previousPreLogFormatIndex = this.formatIdentifier.getPreLogFormatForHost(host);
                LOGGER.log(Level.FINER, " POSSIBLE CHANGE IN THE LOG FORMAT. RELEARNING THE NEW FORMAT FOR Log :{0} received from Host : {1}", new Object[]{data, host});
                formatIndex = this.formatIdentifier.relearnLogFormat(data, host);
                LOGGER.log(Level.FINER, "After Relearning the format obtained is {0} ", new Object[]{new Integer(formatIndex)});
                int formatID2 = this.formatIdentifier.getFormatID(formatIndex);
                if (formatID2 == -1) {
                    this.formatIdentifier.removeLearnings(host);
                    this.formatIdentifier.updateLearnings(host, previousFormatIndex, previousPreLogFormatIndex);
                    return null;
                }
                if (formatIndex == -2) {
                    LOGGER.log(Level.FINER, " UNABLE TO RELEARN THE LOG FORMAT FOR : {0}", host);
                } else {
                    success = this.recordParser.parseRecord(data, formatIndex, unifiedOutput, host);
                    if (!success) {
                        LOGGER.log(Level.FINER, " UNABLE TO PARSE THE LOGS EVEN AFTER LEARNING AGAIN FOR : {0} data :: {1}", new Object[]{host, data});
                    } else {
                        String syslogServer = record.getSyslogServer();
                        if (syslogServer != null) {
                            unifiedOutput.put("SYSLOG_SERVER", syslogServer);
                        }
                        unifiedOutput.put("FORMAT_ID", new Integer(formatIndex));
                    }
                }
            } else {
                String syslogServer = record.getSyslogServer();
                if (syslogServer != null) {
                    unifiedOutput.put("SYSLOG_SERVER", syslogServer);
                }
                unifiedOutput.put("FORMAT_ID", new Integer(formatIndex));
            }
        }
        return unifiedOutput.size() > 0 ? unifiedOutput : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGUNZipContent(File inputGZFile, File tempZipFile) {
        GZIPInputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new GZIPInputStream(new FileInputStream(inputGZFile));
            out = new FileOutputStream(tempZipFile);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        finally {
            try {
                in.close();
                out.close();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    public long getIDVal() {
        return this.afid;
    }

    static {
        lineSeparatorLength = System.getProperty("line.separator").length();
    }
}

