/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.fa.server.PureFirewallConstants;
import com.adventnet.fa.server.dc.ConsolidatorTask;
import com.adventnet.la.util.pe.ParserEngineContext;
import com.adventnet.la.util.pe.ParserEngineHandler;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Logger;

public class PerlRecordHandler {
    private HashMap handlers = new HashMap();
    private String handlerclassName = null;
    private ParserEngineHandler handler;
    private static final Logger LOGGER = Logger.getLogger(PerlRecordHandler.class.getName());
    private static ConsolidatorTask ctask = new ConsolidatorTask();

    public PerlRecordHandler(String handlerclassName) {
        this.handlerclassName = handlerclassName;
        PureFirewallConstants.setPerlVM(true);
        System.setProperty("perlVM", "true");
        if (this.handlerclassName != null) {
            try {
                Class<?> handlerclass = Class.forName(handlerclassName);
                this.handler = (ParserEngineHandler)handlerclass.newInstance();
            }
            catch (Exception ex) {
                System.err.println("[PerlRecordHandler] PerlRecordHandler cannot instantiate  Handler. Class is " + handlerclassName);
            }
        }
    }

    public PerlRecordHandler() {
    }

    public String unifyData(String keys, String values) {
        try {
            Hashtable data = new Hashtable();
            String findPattern = "\\|\\*\\*\\|";
            String[] keysArray = keys.split(findPattern);
            String[] valuesArray = values.split(findPattern);
            if (keysArray.length != valuesArray.length) {
                System.err.println("Lengths not matched keys " + keysArray.length + " values " + valuesArray.length);
                return "";
            }
            for (int i = 0; i < keysArray.length; ++i) {
                if (keysArray[i] == null || valuesArray[i] == null) continue;
                data.put(keysArray[i], valuesArray[i]);
            }
            data = this.handler.recordParsed((ParserEngineContext)null, "localhost", data);
            return this.getRecordAsString(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "FAILED";
        }
    }

    private String getRecordAsString(Hashtable data) {
        if (data == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int type = (Integer)data.get("rtype");
        String[] keys = null;
        String[] defaultValues = null;
        switch (type) {
            case 6: {
                String[] keys1 = new String[]{"RECORD_ID", "RESOURCE", "TIME", "DURATION", "SRC", "RESULT_CODE", "STATUS_CODE", "BYTES", "OPERATION", "REQUEST", "USERNAME", "HIERARCHY_CODE", "DEST", "CONTENT_TYPE", "EXTENSION", "TIMEOUT", "PROTOCOL", "RESULT", "SYSLOGIP", "SYSLOG_SERVER", "START_TIME", "LAST_UPDATE_TIME"};
                String[] defaultValues1 = new String[]{"0", "-", "0", "0", "-", "-", "-", "0", "-", "-", "-", "-", "-", "-", "-", "0", "-", "-", "-", "-", "0", "0"};
                keys = keys1;
                defaultValues = defaultValues1;
                break;
            }
            case 1: 
            case 2: {
                String[] keys2 = new String[]{"RECORD_ID", "FW", "LOG_FORMAT", "FW_TYPE", "USER", "TIME", "PROTOCOL", "PRIORITY", "RECORD_TYPE", "SUBTYPE", "SRC", "SRC_NAME", "SRC_PORT", "DEST", "DESTNAME", "DEST_PORT", "DURATION", "REQUEST", "OPERATION", "STATUS", "FILENAME", "SENT", "RECEIVED", "SENT_PKT", "RECEIVED_PKT", "STATUS_CODE", "RULE", "EVENT_CODE", "EVENT_TYPE", "MSG", "VPN", "GATEWAY", "VIRUS", "CATEGORY", "POLICY_ID", "SRC_INT", "DEST_INT", "TRAN_IP", "TRAN_PORT"};
                String[] defaultValues2 = new String[]{"0", "-", "WELF", "Unknown WELF", "-", "0", "-", "-", "-", "-", "-", "-", "0", "-", "-", "0", "0", "-", "-", "0", "-", "0", "0", "0", "0", "0", "0", "-", "-", "-", "-", "-", "-", "-", "0", "0", "0", "-", "0"};
                keys = keys2;
                defaultValues = defaultValues2;
                break;
            }
            case 3: {
                String[] keys2 = new String[]{"RECORD_ID", "RESOURCE", "LOG_FORMAT", "FW_TYPE", "USER", "TIME", "PROTOCOL", "PRI", "RECORD_TYPE", "SUBTYPE", "SRC", "SRCNAME", "SRC_PORT", "DST", "DSTNAME", "DST_PORT", "DURATION", "REQUEST", "OP", "STATUS", "FILENAME", "SENT", "RCVD", "SENT_PKT", "RCVD_PKT", "HTTPSTATUS", "RULE", "EVENT_CODE", "EVENT_TYPE", "MSG", "VPN", "GATEWAY", "VIRUS", "CATEGORY", "POLICY_ID", "SRC_INT", "DST_INT", "TRAN_IP", "TRAN_PORT"};
                String[] defaultValues2 = new String[]{"0", "-", "WELF", "Unknown WELF", "-", "0", "-", "-", "-", "-", "-", "-", "0", "-", "-", "0", "0", "-", "-", "0", "-", "0", "0", "0", "0", "0", "0", "-", "-", "-", "-", "-", "-", "-", "0", "0", "0", "-", "0"};
                keys = keys2;
                defaultValues = defaultValues2;
                break;
            }
        }
        if (keys != null && defaultValues != null) {
            for (int i = 0; i < keys.length; ++i) {
                Object value = data.get(keys[i]);
                if (value == null || value.toString().equalsIgnoreCase("")) {
                    value = defaultValues[i];
                }
                sb.append(value.toString());
                sb.append("|**|");
            }
        }
        return sb.toString();
    }
}

