/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.FirewallConstants;
import com.adventnet.fa.server.FirewallLicenseManager;
import com.adventnet.fa.server.FwParserEngine;
import com.adventnet.fa.server.ProtocolUtility;
import com.adventnet.fa.server.ReportFilter;
import com.adventnet.fa.server.ResourceDetails;
import com.adventnet.fa.server.lc.RecordHandler;
import com.adventnet.fa.server.lc.SyslogServer;
import com.adventnet.la.DefaultDataFormatter;
import com.adventnet.la.LaUtil;
import com.adventnet.la.LuceneUtil;
import com.adventnet.la.QueryHandler;
import com.adventnet.la.util.DNSResolverThread;
import com.adventnet.la.util.FixedHashMap;
import com.adventnet.la.util.IPRange;
import com.adventnet.la.util.pe.ParserEngineContext;
import com.adventnet.la.util.pe.ParserEngineHandler;
import com.adventnet.mfw.bean.BeanUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.WritableDataObject;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FAServerUtil {
    private static final Logger LOGGER = Logger.getLogger(FAServerUtil.class.getName());
    private static String serverPort = null;
    private static String serverProtocol = null;
    private static String serverIP = null;
    private static HashSet dhcpServers = null;
    private static long startTime;
    private static HashMap<String, ResourceDetails> resObjHash;
    private static List<String> resList;
    private static Hashtable<String, String> physicalDevToIPMap;
    private static HashMap<String, String> ipToPhysicalDevname;
    private static HashMap<String, String> ipToDeviceType;
    private static HashMap<String, ArrayList> ipToResList;
    private static Hashtable<String, String> ipResMap;
    private static Hashtable<Long, List> ddidToResMap;
    private static List vdomList;
    private static List excludedVdomList;
    private static FixedHashMap ipfixDevices;
    private static FirewallLicenseManager fwaLic;
    private static HashMap<Long, Boolean> ridVsPolicyProcessFlagMap;
    private static HashSet<Long> currentPolicyProcesses;
    private static Vector<Long> currentComplianceProcesses;
    private static Vector<Long> currentUserInputProcesses;
    private static Vector<Long> currentExcludeServiceProcessingList;
    private static Vector<Long> currentNonServiceFalsePositiveProcessingList;
    private static Vector<String> policyParsingThreadWaitList;
    private static String localIPAddress;
    public static final Object GLOBALCOMPLIANCELOCK;
    public static final Object GLOBALEXCLUDESERVICELOCK;
    public static final Object GLOBALNONSERVICEFALSEPOSITIVELOCK;

    public static void addToPolicyParsingThreadWaitList(String threadName) {
        policyParsingThreadWaitList.add(threadName);
    }

    public static void removeFromPolicyParsingThreadWaitList(String threadName) {
        policyParsingThreadWaitList.remove(threadName);
    }

    public static boolean shouldWaitTillPolicyParsing(String threadName) {
        return policyParsingThreadWaitList.contains(threadName);
    }

    public static void setFlagForPolicyProcess(Long rid, Boolean status) {
        ridVsPolicyProcessFlagMap.put(rid, status);
    }

    public static boolean getFlagForPolicyProcess(Long rid) {
        if (ridVsPolicyProcessFlagMap.containsKey(rid)) {
            return ridVsPolicyProcessFlagMap.get(rid);
        }
        return false;
    }

    public static void addToCurrentPolicyProcesses(Long rid) {
        currentPolicyProcesses.add(rid);
    }

    public static void removeFromCurrentPolicyProcesses(Long rid) {
        currentPolicyProcesses.remove(rid);
    }

    public static boolean isPolicyProcessing(Long rid) {
        return currentPolicyProcesses.contains(rid);
    }

    public static void addToCurrentComplianceProcesses(Long rid) {
        currentComplianceProcesses.add(rid);
    }

    public static void removeFromCurrentComplianceProcesses(Long rid) {
        currentComplianceProcesses.remove(rid);
    }

    public static boolean isComplianceGeneratingNow() {
        return !currentComplianceProcesses.isEmpty();
    }

    public static boolean isComplianceGeneratingNowForDevice(Long rid) {
        return currentComplianceProcesses.contains(rid);
    }

    public static void addToCurrentUserInputProcesses(Long rid) {
        currentUserInputProcesses.add(rid);
    }

    public static void removeFromCurrentUserInputProcesses(Long rid) {
        currentUserInputProcesses.remove(rid);
    }

    public static boolean isUserInputsProcessingNow() {
        return !currentUserInputProcesses.isEmpty();
    }

    public static boolean isUserInputsProcessingNowForDevice(Long rid) {
        return currentUserInputProcesses.contains(rid);
    }

    public static void addToCurrentExcludeServicesProcessesingList(Long rid) {
        currentExcludeServiceProcessingList.add(rid);
    }

    public static void removeFromCurrentExcludeServicesProcessesingList(Long rid) {
        currentExcludeServiceProcessingList.remove(rid);
    }

    public static boolean isExcludeServicesProcessingNow() {
        return !currentExcludeServiceProcessingList.isEmpty();
    }

    public static void addToCurrentNonServiceFalsePositiveProcessesingList(Long rid) {
        currentNonServiceFalsePositiveProcessingList.add(rid);
    }

    public static void removeFromCurrentNonServiceFalsePositiveProcessesingList(Long rid) {
        currentNonServiceFalsePositiveProcessingList.remove(rid);
    }

    public static boolean isNonServiceFalsePositivesProcessingNow() {
        return !currentNonServiceFalsePositiveProcessingList.isEmpty();
    }

    public static void setServerPort(String port) {
        serverPort = port;
    }

    public static void setServerProtocol(String protocol) {
        serverProtocol = protocol;
    }

    public static void setServerIP(String ip) {
        serverIP = ip;
    }

    public static String getServerPort() {
        return serverPort;
    }

    public static String getServerProtocol() {
        return serverProtocol;
    }

    public static String getServerIP() {
        return serverIP;
    }

    public static DataObject getFwAvailConfig() {
        return FAServerUtil.getFwAvailConfig(null);
    }

    public static DataObject getFwAvailConfig(Long uid) {
        return FAServerUtil.getFwAvailConfig(uid, null);
    }

    public static DataObject getFwAvailConfig(Long uid, String collDown) {
        Criteria crit;
        String deviceID;
        String mapTableName;
        String tableName;
        boolean isAdminServer = "true".equals(System.getProperty("isAdminServer"));
        String mapID = "";
        if (isAdminServer) {
            tableName = "Collectors";
            mapTableName = "FWAAToCollectors";
            deviceID = "CID";
            mapID = "CID";
        } else {
            tableName = "Resources";
            mapTableName = "FWAAToResources";
            deviceID = "RESOURCEID";
            mapID = "RID";
        }
        SelectQueryImpl squery = new SelectQueryImpl(new Table("FWAvailabilityAlert"));
        squery.addSelectColumn(new Column("FWAvailabilityAlert", "*"));
        squery.addSelectColumn(new Column(mapTableName, "*"));
        squery.addSelectColumn(new Column(tableName, "*"));
        if (isAdminServer && collDown != null) {
            crit = new Criteria(new Column("Collectors", "COLLECTOR_STATUS"), (Object)new Long("0"), 0);
            squery.setCriteria(crit);
        }
        squery.addSelectColumn(new Column("AaaLogin", "*"));
        if (uid != null) {
            crit = new Criteria(new Column("FWAvailabilityAlert", "USER_ID"), (Object)uid, 0);
            squery.setCriteria(crit);
        }
        String[] colName1 = new String[]{"FAA_ID"};
        squery.addJoin(new Join("FWAvailabilityAlert", mapTableName, colName1, colName1, 2));
        colName1 = new String[]{mapID};
        String[] colName2 = new String[]{deviceID};
        squery.addJoin(new Join(mapTableName, tableName, colName1, colName2, 2));
        squery.addJoin(new Join("FWAvailabilityAlert", "AaaLogin", new String[]{"USER_ID"}, new String[]{"USER_ID"}, 2));
        WritableDataObject dobj = new WritableDataObject();
        try {
            dobj = DataAccess.get((SelectQuery)squery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dobj;
    }

    public static void doRemoveLearning(String hostIP) {
        ParserEngineContext context = FwParserEngine.getInstance().getContext();
        FAServerUtil.doRemoveLearning(hostIP, context);
    }

    public static void doRemoveLearning(String hostIP, ParserEngineContext context) {
        int index = context.findFormatFromLearnings(hostIP);
        if (index > -1) {
            Vector handlers = context.getHandlerInstances(index);
            if (handlers != null) {
                for (int i = 0; i < handlers.size(); ++i) {
                    ParserEngineHandler noti = (ParserEngineHandler)handlers.elementAt(i);
                    noti.flushMemory(hostIP);
                }
            }
            context.removeLearnings(hostIP);
        }
    }

    public static String getHeader(String hostIP) {
        ParserEngineContext context = FwParserEngine.getInstance().getContext();
        return FAServerUtil.getHeader(hostIP, context);
    }

    public static String getHeader(String hostIP, ParserEngineContext context) {
        Vector handlers;
        int index = context.findFormatFromLearnings(hostIP);
        if (index > -1 && (handlers = context.getHandlerInstances(index)) != null) {
            for (int i = 0; i < handlers.size(); ++i) {
                ParserEngineHandler noti = (ParserEngineHandler)handlers.elementAt(i);
                String header = noti.getHeader(hostIP);
                if (header == null) continue;
                return header;
            }
        }
        return null;
    }

    public static Format changeProtoToId(StringBuffer result, Format format) {
        String value = result.toString();
        int i = value.indexOf("-->");
        if (i > 0) {
            value = "'" + ProtocolUtility.changeProtoToID(value.substring(0, i)) + "' and  '" + ProtocolUtility.changeProtoToID(value.substring(i + 3)) + "'";
            format = Format.RANGE;
        } else {
            Long id = ProtocolUtility.changeProtoToID(value);
            if (id != null) {
                value = "" + id;
                format = Format.ID;
            }
        }
        result.delete(0, result.length());
        result.append(value);
        return format;
    }

    public static Format changeIPToId(StringBuffer result, Format format) {
        String value = result.toString();
        int i = (value = value.trim()).indexOf("-->");
        if (i > 0) {
            value = "'" + IPRange.getAddrLong((String)value.substring(0, i)) + "' and  '" + IPRange.getAddrLong((String)value.substring(i + 3)) + "'";
            format = Format.RANGE;
        } else if (value.indexOf("/") > 0) {
            long[] range = IPRange.getSlashRange((String)value);
            value = "'" + range[0] + "' and  '" + range[1] + "'";
            format = Format.CIDR;
        } else {
            long l = IPRange.getAddrLong((String)value);
            if (l > 0L) {
                value = String.valueOf(IPRange.getAddrLong((String)value));
                format = Format.ID;
            } else if (value.indexOf("%") != -1) {
                format = Format.WILDCARD;
            }
        }
        result.delete(0, result.length());
        result.append(value);
        return format;
    }

    public static void addFilterDataToMem(Long reportId, String[] src, String[] dest, String[] proto, String srcComparator, String destComparator, String protoComparator) {
        LOGGER.log(Level.FINER, "FAServerUtil: Processing ReportId for ReportFilter ::::" + reportId);
        HashMap memMap = new HashMap();
        if (src != null) {
            FAServerUtil.addToMem(src, memMap, "SRC", srcComparator);
        }
        if (dest != null) {
            FAServerUtil.addToMem(dest, memMap, "DEST", destComparator);
        }
        if (proto != null) {
            FAServerUtil.addToMem(proto, memMap, "PROTOCOL", protoComparator);
        }
        ReportFilter.setExclusionMap(reportId, memMap);
    }

    private static void addToMem(String[] val, Map map, String key, String comparator) {
        String comp;
        String allExp = "";
        String singleIPs = "";
        String protoNames = "";
        for (int i = 0; i < val.length; ++i) {
            String comp2;
            String colName = key;
            String oldValue = val[i].trim();
            StringBuffer value = new StringBuffer(oldValue);
            Format format = Format.STRING;
            if (colName.equals("PROTOCOL")) {
                protoNames = protoNames + "'" + value + "',";
                format = FAServerUtil.changeProtoToId(value, format);
            } else {
                format = FAServerUtil.changeIPToId(value, format);
            }
            if (format.equals((Object)Format.STRING)) {
                if (colName.startsWith("PROTOCOL")) {
                    colName = colName + "_NAME";
                }
                allExp = allExp + colName + "$" + comparator + "$" + value + "$$";
                continue;
            }
            if (format.equals((Object)Format.RANGE)) {
                colName = colName + "_ID";
                comp2 = comparator.indexOf("!") > -1 ? " NOT BETWEEN " : " BETWEEN ";
                allExp = allExp + colName + "$" + comp2 + "$" + value + "$$";
                continue;
            }
            if (format.equals((Object)Format.WILDCARD)) {
                comp2 = comparator.indexOf("!") > -1 ? " NOT LIKE " : " LIKE ";
                allExp = allExp + colName + "$" + comp2 + "$" + value + "$$";
                continue;
            }
            singleIPs = singleIPs + value + ",";
        }
        String string = comp = comparator.indexOf("!") > -1 ? " NOT IN " : " IN ";
        if (!"".equals(singleIPs)) {
            singleIPs = singleIPs.substring(0, singleIPs.length() - 1);
            allExp = allExp + key + "_ID" + "$" + comp + "$" + singleIPs + "$$";
        }
        String[] exp = allExp.split("\\$\\$");
        if (key.equals("PROTOCOL")) {
            protoNames = "PROTOCOL$ " + comp + " $" + protoNames.substring(0, protoNames.length() - 1) + "$$";
            map.put(key + "_NAME", protoNames.split("\\$\\$"));
            LOGGER.log(Level.INFO, "FAServerUtil: Expression added in memory ::::::::::  key ::" + key + "_NAME Value ::" + protoNames);
            map.put(key + "_ID", exp);
            LOGGER.log(Level.INFO, "FAServerUtil: Expression added in memory ::::::::::  key ::" + key + "_ID Value ::" + allExp);
        } else {
            map.put(key, exp);
            LOGGER.log(Level.INFO, "FAServerUtil: Expression added in memory ::::::::::  key ::" + key + " Value ::" + allExp);
        }
    }

    public static Persistence getPersistence() {
        Persistence persistence = null;
        try {
            persistence = (Persistence)BeanUtil.lookup((String)"Persistence");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return persistence;
    }

    public static String getFlowRate() {
        long currentTime = System.currentTimeMillis();
        long timeDiff = currentTime - startTime;
        String strTimeDiff = new DefaultDataFormatter().formatDuration((int)timeDiff / 1000);
        long rate = 0L;
        long logCount = 0L;
        if (timeDiff != 0L) {
            logCount = SyslogServer.getAndResetLogCount();
            rate = logCount * 1000L / timeDiff;
        }
        String strRate = rate + "," + logCount + "," + strTimeDiff;
        startTime = currentTime;
        return strRate;
    }

    public static void loadReportFilter() {
        try {
            SelectQueryImpl squery = new SelectQueryImpl(new Table("Filters"));
            squery.addSelectColumn(new Column("Filters", "*"));
            Criteria crit = new Criteria(new Column("Filters", "FILTERNAME"), (Object)"*_ReportFilter", 2);
            squery.setCriteria(crit);
            DataObject doo = DataAccess.get((SelectQuery)squery);
            Iterator iter = doo.getRows("Filters");
            ArrayList<Object> filterNames = new ArrayList<Object>();
            while (iter.hasNext()) {
                Row r = (Row)iter.next();
                filterNames.add(r.get("FILTERNAME"));
            }
            for (int k = 0; k < filterNames.size(); ++k) {
                String[] proto;
                squery = new SelectQueryImpl(new Table("FilterToLAExpression"));
                crit = new Criteria(new Column("FilterToLAExpression", "FILTERNAME"), filterNames.get(k), 0);
                squery.setCriteria(crit);
                Join join1 = new Join("FilterToLAExpression", "LAExpression", new String[]{"EXP_ID"}, new String[]{"EXP_ID"}, 2);
                squery.addJoin(join1);
                squery.addSelectColumn(new Column("FilterToLAExpression", "*"));
                squery.addSelectColumn(new Column("LAExpression", "*"));
                doo = DataAccess.get((SelectQuery)squery);
                iter = doo.getRows("LAExpression");
                String protoComp = "";
                String destComp = "";
                String srcComp = "";
                String protoList = "";
                String destList = "";
                String srcList = "";
                int j = 0;
                while (iter.hasNext()) {
                    Row r = (Row)iter.next();
                    String col = (String)r.get("COLUMN_NAME");
                    if (col.equals("SRC")) {
                        srcList = srcList + r.get("VALUE") + "$$";
                        srcComp = (String)r.get("COMPARATOR");
                    } else if (col.equals("DEST")) {
                        destList = destList + r.get("VALUE") + "$$";
                        destComp = (String)r.get("COMPARATOR");
                    } else if (col.equals("PROTOCOL_NAME")) {
                        protoList = protoList + r.get("VALUE") + "$$";
                        protoComp = (String)r.get("COMPARATOR");
                    }
                    ++j;
                }
                String[] src = "".equals(srcList) ? null : srcList.split("\\$\\$");
                String[] dest = "".equals(destList) ? null : destList.split("\\$\\$");
                String[] stringArray = proto = "".equals(protoList) ? null : protoList.split("\\$\\$");
                if (src == null && dest == null && proto == null) continue;
                SelectQueryImpl squery1 = new SelectQueryImpl(new Table("ReportConfigToFilters"));
                squery1.addSelectColumn(new Column("ReportConfigToFilters", "REPORTID"));
                crit = new Criteria(new Column("ReportConfigToFilters", "FILTERNAME"), filterNames.get(k), 0);
                squery1.setCriteria(crit);
                doo = DataAccess.get((SelectQuery)squery1);
                Long reportId = (Long)doo.getFirstValue("ReportConfigToFilters", "REPORTID");
                FAServerUtil.addFilterDataToMem(reportId, src, dest, proto, srcComp, destComp, protoComp);
            }
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
        }
        LaUtil.setDynamicQueryHandler((QueryHandler)new ReportFilter());
    }

    public static void handleNewDHCPServer(String dhcpServerName) {
        if (dhcpServers == null) {
            FAServerUtil.loadDHCPServerDetails();
        }
        if (!dhcpServers.contains(dhcpServerName.trim())) {
            FAServerUtil.addDHCPServerDetail(dhcpServerName.trim());
        }
    }

    private static void loadDHCPServerDetails() {
        try {
            dhcpServers = new HashSet();
            SelectQueryImpl query = new SelectQueryImpl(new Table("DHCPConfigurations"));
            query.addSelectColumn(new Column("DHCPConfigurations", "*"));
            DataObject dobj = DataAccess.get((SelectQuery)query);
            Iterator itr = dobj.getRows("DHCPConfigurations");
            while (itr.hasNext()) {
                String dhcpServerName = (String)((Row)itr.next()).get("SERVER");
                dhcpServers.add(dhcpServerName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addDHCPServerDetail(String serverName) {
        try {
            DataObject dobj = DataAccess.constructDataObject();
            Row row = new Row("DHCPConfigurations");
            row.set("SERVER", (Object)serverName);
            dobj.addRow(row);
            DataAccess.add((DataObject)dobj);
            dhcpServers.add(serverName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void handleDHCPServerDelete(String serverName) {
        try {
            Criteria crit = new Criteria(new Column("DHCPConfigurations", "SERVER"), (Object)serverName, 0);
            DataAccess.delete((Criteria)crit);
            if (dhcpServers != null) {
                dhcpServers.remove(serverName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteUserIPConfigData(String serverName) {
        String query = "delete from UserMACDetails where SERVERNAME='" + serverName + "'";
        Connection con = null;
        Statement stmt = null;
        try {
            RelationalAPI rapi = RelationalAPI.getInstance();
            con = rapi.getConnection();
            stmt = con.createStatement();
            stmt.execute(query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    public static void populateMemoryDetails() {
        FAServerUtil.populateResList();
        FAServerUtil.populatePhysicalDevToIPMap();
        FAServerUtil.populateVirtualFirewallList();
        FAServerUtil.populateResObj();
        FAServerUtil.populateDDIDToResMap();
        FAServerUtil.populateIpfixDevices();
    }

    private static void populateResList() {
        try {
            SelectQueryImpl resQuery = new SelectQueryImpl(new Table("Resources"));
            resQuery.addSelectColumn(new Column("Resources", "*"));
            DataObject resObj = DataAccess.get((SelectQuery)resQuery);
            Iterator resIter = resObj.getRows("Resources");
            while (resIter.hasNext()) {
                Row row = (Row)resIter.next();
                resList.add((String)row.get("RESOURCENAME"));
                String ip = (String)row.get("IPADDRESS");
                Long rID = (Long)row.get("RESOURCEID");
                String resID = rID.toString();
                String mappedRids = ipResMap.remove(ip);
                if (mappedRids == null) {
                    ipResMap.put(ip, resID);
                    continue;
                }
                mappedRids = mappedRids + "," + resID;
                ipResMap.put(ip, mappedRids);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private static void populatePhysicalDevToIPMap() {
        try {
            SelectQueryImpl resQuery = new SelectQueryImpl(new Table("Resources"));
            resQuery.addSelectColumn(new Column("Resources", "*"));
            resQuery.setCriteria(new Criteria(new Column("Resources", "VENDOR_TYPE"), (Object)new String[]{"FortiGate", "Cisco"}, 8));
            DataObject resObj = DataAccess.get((SelectQuery)resQuery);
            Iterator resIter = resObj.getRows("Resources");
            while (resIter.hasNext()) {
                Row row = (Row)resIter.next();
                String ipAddress = (String)row.get("IPADDRESS");
                String resource = (String)row.get("RESOURCENAME");
                String physicalDevName = (String)row.get("PHYSICALDEVICENAME");
                String physicalDevIP = (String)row.get("PHYSICALDEVIP");
                String devType = (String)row.get("VENDOR_TYPE");
                physicalDevToIPMap.put(physicalDevName, ipAddress);
                if (!devType.equals("Cisco") && physicalDevIP == null) continue;
                ipToPhysicalDevname.put(ipAddress, physicalDevName);
                ipToDeviceType.put(ipAddress, devType);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private static void populateVirtualFirewallList() {
        try {
            SelectQueryImpl sql = new SelectQueryImpl(new Table("Resources"));
            sql.addSelectColumn(new Column("Resources", "*"));
            Criteria crit = new Criteria(new Column("Resources", "PHYSICALDEVIP"), (Object)"", 0);
            if (excludedVdomList != null) {
                crit = crit.and(new Criteria(new Column("Resources", "IPADDRESS"), (Object)excludedVdomList.toArray(), 9));
            }
            sql.setCriteria(crit);
            DataObject doo = DataAccess.get((SelectQuery)sql);
            Iterator itr = doo.getRows("Resources");
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                vdomList.add((String)row.get("IPADDRESS"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void populateResObj() {
        FAServerUtil.populateIPToResList();
        for (String ip : ipToResList.keySet()) {
            String physicalDevName = ipToPhysicalDevname.get(ip);
            if (physicalDevName == null) continue;
            ArrayList devList = ipToResList.get(ip);
            String devType = ipToDeviceType.get(ip);
            ResourceDetails resObj = new ResourceDetails(ip, (String)devList.get(0), physicalDevName);
            String resObjKey = "FortiGate".equals(devType) ? physicalDevName : ip;
            FAServerUtil.setResObjHash(resObjKey, resObj);
            if (devList.size() <= 1) continue;
            for (int i = 1; i < devList.size(); ++i) {
                resObj.addVdom((String)devList.get(i), physicalDevName);
            }
        }
        ipToResList.clear();
        ipToPhysicalDevname.clear();
        ipToDeviceType.clear();
    }

    private static void populateIPToResList() {
        try {
            SelectQueryImpl resQuery = new SelectQueryImpl(new Table("Resources"));
            resQuery.addSelectColumn(new Column("Resources", "*"));
            resQuery.setCriteria(new Criteria(new Column("Resources", "VENDOR_TYPE"), (Object)new String[]{"FortiGate", "Cisco"}, 8));
            DataObject resObj = DataAccess.get((SelectQuery)resQuery);
            Iterator resIter = resObj.getRows("Resources");
            while (resIter.hasNext()) {
                Row row = (Row)resIter.next();
                String ipAddress = (String)row.get("IPADDRESS");
                String resource = (String)row.get("RESOURCENAME");
                ArrayList<String> devList = ipToResList.get(ipAddress);
                if (devList == null) {
                    devList = new ArrayList<String>();
                    ipToResList.put(ipAddress, devList);
                }
                devList.add(resource);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static void populateDDIDToResMap() {
        try {
            SelectQueryImpl ddQuery = new SelectQueryImpl(new Table("DeviceDetails"));
            ddQuery.addSelectColumn(new Column("DeviceDetails", "*"));
            DataObject ddObj = DataAccess.get((SelectQuery)ddQuery);
            Iterator ddIter = ddObj.getRows("DeviceDetails");
            while (ddIter.hasNext()) {
                Row row = (Row)ddIter.next();
                Long ddid = (Long)row.get("DDID");
                Long rid = (Long)row.get("RID");
                Boolean isProfBased = (Boolean)row.get("ISPROFILEBASED");
                if (isProfBased.booleanValue()) {
                    FAServerUtil.populateFromDIPToResMapping(ddid);
                    continue;
                }
                SelectQueryImpl resQuery = new SelectQueryImpl(new Table("Resources"));
                resQuery.addSelectColumn(new Column("Resources", "*"));
                resQuery.setCriteria(new Criteria(new Column("Resources", "RESOURCEID"), (Object)rid, 0));
                DataObject resObj = DataAccess.get((SelectQuery)resQuery);
                String ip = (String)resObj.getFirstValue("Resources", "IPADDRESS");
                String mappedRIDS = FAServerUtil.getIPResMap(ip);
                String[] temp = mappedRIDS.split(",");
                String excludedRIDs = (String)row.get("EXCLUDED_VDOMS");
                List<Object> excludeList = new ArrayList();
                ArrayList<Long> resList = new ArrayList<Long>();
                if (excludedRIDs != null) {
                    String[] excludedVdoms = excludedRIDs.split(",");
                    excludeList = Arrays.asList(excludedVdoms);
                }
                for (int i = 0; i < temp.length; ++i) {
                    String tt = temp[i];
                    if (excludeList.contains(tt)) continue;
                    resList.add(new Long(tt));
                }
                ddidToResMap.put(ddid, resList);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static void populateFromDIPToResMapping(Long ddid) {
        try {
            ArrayList<Long> resList = new ArrayList<Long>();
            SelectQueryImpl dipToResQuery = new SelectQueryImpl(new Table("DIPToResourcesMapping"));
            dipToResQuery.addSelectColumn(new Column("DIPToResourcesMapping", "*"));
            dipToResQuery.setCriteria(new Criteria(new Column("DIPToResourcesMapping", "DDID"), (Object)ddid, 0));
            DataObject dipToResObj = DataAccess.get((SelectQuery)dipToResQuery);
            Iterator dipToResIter = dipToResObj.getRows("DIPToResourcesMapping");
            while (dipToResIter.hasNext()) {
                Row row = (Row)dipToResIter.next();
                Long rid = (Long)row.get("RID");
                resList.add(rid);
            }
            ddidToResMap.put(ddid, resList);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static void addResListForDDID(Long ddid, List resList) {
        ddidToResMap.put(ddid, resList);
    }

    public static void addToResourceList(String resource) {
        resList.add(resource);
    }

    public static void addDeviceToVdomDevicesList(String ipAddress) {
        if (!vdomList.contains(ipAddress)) {
            vdomList.add(ipAddress);
        }
    }

    public static void addToExcludedDevicesList(String ipAddress) {
        if (!excludedVdomList.contains(ipAddress)) {
            excludedVdomList.add(ipAddress);
        }
    }

    public static void setResObjHash(String resObjKey, ResourceDetails resObj) {
        resObjHash.put(resObjKey, resObj);
    }

    public static List getResForDDID(Long ddid) {
        return ddidToResMap.get(ddid);
    }

    public static Hashtable getDDIDToResMap() {
        return ddidToResMap;
    }

    public static String getIPResMap(String ipAdd) {
        return ipResMap.get(ipAdd);
    }

    public static List getResList() {
        return resList;
    }

    public static Hashtable getPhysicalDevToIPMap() {
        return physicalDevToIPMap;
    }

    public static String getPhysicalDeviceName(String ip) {
        String toReturn = null;
        boolean contains = physicalDevToIPMap.containsValue(ip);
        if (!contains) {
            try {
                Criteria crit = new Criteria(new Column("Resources", "IPADDRESS"), (Object)ip, 0);
                DataObject doo = DataAccess.get((String)"Resources", (Criteria)crit);
                if (!doo.isEmpty()) {
                    toReturn = (String)doo.getFirstValue("Resources", "PHYSICALDEVICENAME");
                    return toReturn;
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        Object[] keys = physicalDevToIPMap.keySet().toArray();
        int keyLength = keys.length;
        for (int i = 0; i < keyLength; ++i) {
            String key = (String)keys[i];
            String value = physicalDevToIPMap.get(key);
            if (ip.compareTo(value) != 0) continue;
            toReturn = key;
            break;
        }
        return toReturn;
    }

    public static void removeFromPhysicalDevToIPMap(String physicalDevname) {
        if (physicalDevname != null && physicalDevToIPMap.containsKey(physicalDevname)) {
            physicalDevToIPMap.remove(physicalDevname);
        }
    }

    public static void getExcludedFirewallList(String excludedIPs) {
        if (excludedIPs != null) {
            String[] array = excludedIPs.split(",");
            for (int i = 0; i < array.length; ++i) {
                FAServerUtil.addToExcludedDevicesList(array[i]);
            }
        }
    }

    public static List getVdomDevicesList() {
        return vdomList;
    }

    public static List getExcludedDevList() {
        return excludedVdomList;
    }

    public static ResourceDetails getResObject(String resObjKey) {
        return resObjHash.get(resObjKey);
    }

    public static void updateResObjHashForCisco(String oldIP, String newIP) {
        ResourceDetails resObj = resObjHash.remove(oldIP);
        resObjHash.put(newIP, resObj);
    }

    public static void updatePhysicalDevToIPMap(String newIP, String physicalDevname) {
        physicalDevToIPMap.put(physicalDevname, newIP);
    }

    public static void updateIPResMap(String oldIP, String newIP) {
        String mappedRIDs = ipResMap.remove(oldIP);
        ipResMap.put(newIP, mappedRIDs);
    }

    public static void updateIPResMap(String ip, String resID, Boolean isAdd) {
        String mappedRids = ipResMap.remove(ip);
        if (mappedRids == null && isAdd.booleanValue()) {
            ipResMap.put(ip, resID);
        } else if (isAdd.booleanValue()) {
            mappedRids = mappedRids + "," + resID;
            ipResMap.put(ip, mappedRids);
        } else {
            String[] rids = mappedRids.split(",");
            String tempResList = "";
            String tempRID = null;
            for (int i = 0; i < rids.length; ++i) {
                tempRID = rids[i];
                if (resID.equals(tempRID)) continue;
                tempResList = tempResList.equals("") ? tempRID : tempResList + "," + tempRID;
            }
            if (!tempResList.equals("")) {
                ipResMap.put(ip, tempResList);
            } else {
                FAServerUtil.removeDeviceFromVdomDevicesList(ip);
                FAServerUtil.removeDevFrmExcludeList(ip);
                String physicalDevName = FAServerUtil.getPhysicalDeviceName(ip);
                FAServerUtil.removeFromPhysicalDevToIPMap(physicalDevName);
            }
        }
    }

    public static void removeResObject(String resObjKey) {
        resObjHash.remove(resObjKey);
    }

    public static void removeResListForDDID(Long ddid) {
        ddidToResMap.remove(ddid);
    }

    public static void removeResForDDID(Long ddid, Long rid) {
        List resList = ddidToResMap.get(ddid);
        if (resList.contains(rid)) {
            resList.remove(rid);
        }
        ddidToResMap.put(ddid, resList);
        if (resList.size() == 0) {
            try {
                Criteria crt = new Criteria(new Column("DeviceDetails", "DDID"), (Object)ddid, 0);
                DataAccess.delete((Criteria)crt);
                ddidToResMap.remove(ddid);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    public static void removeFromResourceList(String resource) {
        resList.remove(resource);
    }

    public static void removeDeviceFromVdomDevicesList(String ipAddress) {
        if (vdomList.contains(ipAddress)) {
            vdomList.remove(ipAddress);
        }
    }

    public static void removeDevFrmExcludeList(String ipAddress) {
        if (excludedVdomList.contains(ipAddress)) {
            excludedVdomList.remove(ipAddress);
        }
    }

    public static void updateSysConf() {
        List nonVdom = FAServerUtil.getExcludedDevList();
        String ipAddr = null;
        if (nonVdom.size() > 0) {
            ipAddr = (String)nonVdom.get(0);
            for (int i = 1; i < nonVdom.size(); ++i) {
                ipAddr = ipAddr + "," + nonVdom.get(i);
            }
        }
        FirewallConstants.updateConfValue("ExvirtualFirewalls", ipAddr);
    }

    public static String resolveDNSNow(String ip) {
        DNSResolverThread dnsThread = DNSResolverThread.getInstance();
        String dnsName = dnsThread.getDNSName(ip, true);
        return dnsName;
    }

    public static void calculateTimeGap(Hashtable myMap) {
        Date date = new Date();
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        int hourofDay = calendar.get(11);
        int minofHour = calendar.get(12);
        String hrVal = (String)myMap.get("timeTostartHour");
        String minVal = (String)myMap.get("timeTostartMins");
        if ("---".equals(hrVal) && "---".equals(minVal)) {
            return;
        }
        if ("---".equals(hrVal) && !"---".equals(minVal)) {
            hrVal = "0";
        } else if (!"---".equals(hrVal) && "---".equals(minVal)) {
            minVal = "0";
        }
        int hour = Integer.parseInt(hrVal);
        int minu = Integer.parseInt(minVal);
        String combinedtoStore = hour + ":";
        combinedtoStore = "0".equals(minVal) ? combinedtoStore + "0" : combinedtoStore + (String)myMap.get("timeTostartMins");
        myMap.put("IMPORT_STIME", combinedtoStore);
        hour = hour > hourofDay || hour == hourofDay ? (hour -= hourofDay) : 24 + hour - hourofDay;
        if (minu > minofHour || minofHour == minu) {
            minu -= minofHour;
        } else {
            minu = 60 + minu - minofHour;
            --hour;
        }
        LOGGER.log(Level.WARNING, " delayfinder in seconds :: " + (long)(hour * 60 + minu) * 60L);
        myMap.put("DELAY_TIME", (long)(hour * 60 + minu) * 60L);
    }

    public static void indexTrafficChanges(boolean valu) {
        LOGGER.log(Level.WARNING, "Indexing Traffic changes " + valu);
        FirewallConstants.setTrafficIndex(valu);
        LuceneUtil.setAllIndexing((boolean)valu);
        RecordHandler.setIndexall(valu);
    }

    private static void populateIpfixDevices() {
        try {
            SelectQueryImpl resQuery = new SelectQueryImpl(new Table("Resources"));
            resQuery.addSelectColumn(new Column("Resources", "*"));
            Criteria crit1 = new Criteria(new Column("Resources", "RESOURCENAME"), (Object)"*-IPFIX", 2);
            Criteria crit2 = new Criteria(new Column("Resources", "VENDOR_TYPE"), (Object)"SonicWall", 0);
            crit2 = crit2.and(new Criteria(new Column("Resources", "LOG_FORMAT"), (Object)"WELF", 0));
            resQuery.setCriteria(crit1.or(crit2));
            DataObject resObj = DataAccess.get((SelectQuery)resQuery);
            Iterator resIter = resObj.getRows("Resources");
            while (resIter.hasNext()) {
                Row row = (Row)resIter.next();
                String resource = (String)row.get("RESOURCENAME");
                if (resource.indexOf("IPFIX") > -1) {
                    ipfixDevices.put((Object)((String)row.get("IPADDRESS")), (Object)resource);
                    continue;
                }
                ipfixDevices.put((Object)resource, (Object)(resource + "-IPFIX"));
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static String getIpfixDevices(String ipfix_ip) {
        if (ipfixDevices.get((Object)ipfix_ip) != null) {
            return (String)ipfixDevices.get((Object)ipfix_ip);
        }
        LOGGER.log(Level.FINER, "FAServerUtil: getIpfixDevices ::::" + ipfixDevices);
        return ipfix_ip;
    }

    public static void setIpfixDevices(String ipfix_ip) {
        if (ipfixDevices.get((Object)ipfix_ip) == null) {
            ipfixDevices.put((Object)ipfix_ip, (Object)(ipfix_ip + "-IPFIX"));
        }
    }

    public static void removeIpfixDevices(String resName, String ip) {
        if (ipfixDevices.get((Object)resName) != null && fwaLic.getDeviceObject(resName + "-IPFIX") == null) {
            ipfixDevices.remove((Object)resName);
        }
        LOGGER.log(Level.FINER, "FAServerUtil: removeIpfixDevices ::::" + ipfixDevices);
    }

    public static String getServerIPAddress() throws Exception {
        if (localIPAddress != null) {
            LOGGER.log(Level.FINER, "FAServerUtil: LocalIPAddress ::::" + localIPAddress);
            return localIPAddress;
        }
        InetAddress[] addr = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
        for (int i = 0; i < addr.length; ++i) {
            if (addr[i].isLoopbackAddress() || !addr[i].isReachable(5000)) continue;
            localIPAddress = addr[i].getHostAddress();
            break;
        }
        if (localIPAddress != null) {
            LOGGER.log(Level.FINER, "FAServerUtil: LocalIPAddress1 ::::" + localIPAddress);
            return localIPAddress;
        }
        LOGGER.log(Level.FINER, "FAServerUtil: loopback address issue. trying to get IP address in other possible ways.");
        NetworkInterface nic = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface nic1 = en.nextElement();
            Enumeration<InetAddress> en1 = nic1.getInetAddresses();
            while (en1.hasMoreElements()) {
                InetAddress inet1 = en1.nextElement();
                if (!(inet1 instanceof Inet4Address) || inet1.isLoopbackAddress()) continue;
                localIPAddress = inet1.getHostAddress();
                LOGGER.log(Level.FINER, "FAServerUtil: LocalIPAddress2 ::::" + localIPAddress);
                return localIPAddress;
            }
        }
        throw new Exception("No proper IPAddress is returned from the system");
    }

    public static ArrayList<String> populateVirtualFirewallList(DataObject doo) {
        ArrayList<String> collVdomList = new ArrayList<String>();
        try {
            Criteria crit = new Criteria(new Column("Resources", "PHYSICALDEVIP"), (Object)"", 0);
            crit = crit.or(new Criteria(new Column("Resources", "PHYSICALDEVIP"), (Object)" ", 0));
            Iterator itr = doo.getRows("Resources", crit);
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                collVdomList.add((String)row.get("IPADDRESS"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return collVdomList;
    }

    public static Row getDDRow(Long resID, String ip) {
        try {
            Criteria crit = new Criteria(new Column("DIPToResourcesMapping", "RID"), (Object)resID, 0);
            Object ddidObj = FAServerUtil.getFromDB("DIPToResourcesMapping", crit, "DDID");
            if (ddidObj != null) {
                crit = new Criteria(new Column("DeviceDetails", "DDID"), (Object)((Long)ddidObj), 0);
                return (Row)FAServerUtil.getFromDB("DeviceDetails", crit, null);
            }
            Criteria ipCrit = new Criteria(new Column("Resources", "IPADDRESS"), (Object)ip, 0);
            crit = ipCrit.and(new Criteria(new Column("Resources", "PHYSICALDEVIP"), (Object)"", 0));
            Long baseRID = (Long)FAServerUtil.getFromDB("Resources", crit, "RESOURCEID");
            if (baseRID != null) {
                crit = new Criteria(new Column("DeviceDetails", "RID"), (Object)baseRID, 0);
                return (Row)FAServerUtil.getFromDB("DeviceDetails", crit, null);
            }
            return null;
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return null;
        }
    }

    public static Object getFromDB(String tableName, Criteria crit, String reqCol) throws Exception {
        DataObject doo = DataAccess.get((String)tableName, (Criteria)crit);
        if (!doo.isEmpty()) {
            if (reqCol != null) {
                return doo.getFirstValue(tableName, reqCol);
            }
            return doo.getFirstRow(tableName);
        }
        return null;
    }

    static {
        resObjHash = new HashMap();
        resList = new ArrayList<String>();
        physicalDevToIPMap = new Hashtable();
        ipToPhysicalDevname = new HashMap();
        ipToDeviceType = new HashMap();
        ipToResList = new HashMap();
        ipResMap = new Hashtable();
        ddidToResMap = new Hashtable();
        vdomList = new ArrayList();
        excludedVdomList = new ArrayList();
        ipfixDevices = new FixedHashMap(100);
        fwaLic = FirewallLicenseManager.getInstance();
        ridVsPolicyProcessFlagMap = new HashMap();
        currentPolicyProcesses = new HashSet();
        currentComplianceProcesses = new Vector();
        currentUserInputProcesses = new Vector();
        currentExcludeServiceProcessingList = new Vector();
        currentNonServiceFalsePositiveProcessingList = new Vector();
        policyParsingThreadWaitList = new Vector();
        localIPAddress = null;
        GLOBALCOMPLIANCELOCK = new Object();
        GLOBALEXCLUDESERVICELOCK = new Object();
        GLOBALNONSERVICEFALSEPOSITIVELOCK = new Object();
        startTime = System.currentTimeMillis();
    }

    static enum Format {
        STRING(0),
        ID(1),
        WILDCARD(2),
        RANGE(3),
        CIDR(4);

        int index;

        private Format(int index) {
            this.index = index;
        }

        int getIndex() {
            return this.index;
        }
    }
}

