/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.ad;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.fa.server.ad.AbstractUserIPHandler;
import com.adventnet.la.util.FixedHashMap;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.util.HashMap;
import java.util.logging.Logger;

public class ProxyUserHandler
extends AbstractUserIPHandler {
    private static final Logger LOGGER = Logger.getLogger(ProxyUserHandler.class.getName());
    private HashMap serverNameVsIdMap = null;

    @Override
    public synchronized void init() {
        this.configTableName = "ProxyConfigurations";
        this.dataColumnName = "USER";
        this.configurationMap = new HashMap();
        this.dataMap = new FixedHashMap(50000);
        this.serverNameVsIdMap = new HashMap();
        this.loadConfigurationDetails();
    }

    @Override
    protected String getServerName(DataObject resDO, Object server) {
        String serverName = null;
        try {
            Row row = resDO.getRow("Resources", new Criteria(new Column("Resources", "RESOURCEID"), (Object)((Long)server), 0));
            if (row != null) {
                serverName = (String)row.get("RESOURCENAME");
                this.serverNameVsIdMap.put(serverName, server + "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serverName;
    }

    @Override
    protected void handleEmptyServer(Object serverId, String serverName) {
        try {
            Criteria crit = new Criteria(new Column(this.configTableName, "SERVER"), serverId, 0);
            DataAccess.delete((Criteria)crit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

