/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.dc.AbstractLogUnifier;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnchivaLogUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(AnchivaLogUnifier.class.getName());
    private static final Integer TYPE = new Integer(24);

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        String ipType;
        if (data.get("FW") == null) {
            data.put("FW", host);
        }
        data.put("FW_TYPE", "ANCHIVA");
        data.put("LOG_FORMAT", "ANCHIVA");
        data.put("rtype", TYPE);
        String logType = (String)data.get("LTYPE");
        if (logType == null && "Client_IP".equals(ipType = (String)data.get("IP_type"))) {
            String clientIP = (String)data.remove("DEST");
            data.put("SRC", clientIP);
        }
        if (data.get("DEST") == null) {
            String fw = (String)data.get("FW");
            data.put("DEST", fw);
        }
        String status = (String)data.get("STATUS");
        if ("Webfilter_Alert".equals(logType)) {
            if (data.get("FILENAME") != null) {
                String url = data.remove("FILENAME").toString();
                int slashIndex = url.indexOf("/");
                url = url.substring(0, slashIndex);
                data.put("REQUEST", url);
                if ("blocked".equalsIgnoreCase(status)) {
                    data.put("STATUS", "deny");
                    data.put("RULE", "default");
                    data.put("EVENT_TYPE", "6");
                }
            } else if ("blocked".equalsIgnoreCase(status)) {
                data.put("STATUS", "deny");
                data.put("RULE", "default");
            }
        }
        this.handleTime(data);
        this.checkAdminSupport(data, host);
        this.checkPriority(data);
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT", "EVENT_TYPE"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "RECEIVED", "DURATION", "SENT_PKT", "RECEIVED_PKT", "TRAN_PORT", "STATUS_CODE", "POLICY_ID"};
        this.strToLong(strToLong, data);
        this.checkForLearnMe(data);
        return data;
    }

    private void handleTime(Hashtable data) {
        String dateString = (String)data.get("DATE_STRING");
        String dateFormat = (String)data.get("DATE_FORMAT");
        try {
            if (dateString == null || dateFormat == null) {
                data.put("TIME", new Timestamp(System.currentTimeMillis()));
                return;
            }
            SimpleDateFormat format = new SimpleDateFormat(dateFormat);
            data.put("TIME", new Timestamp(format.parse(dateString).getTime()));
        }
        catch (Exception ee) {
            ee.printStackTrace();
            LOGGER.log(Level.FINER, " Exception while parsing Cisco Date String :: {0} Date Format ::{1}", new Object[]{dateString, dateFormat});
            data.put("TIME", new Timestamp(System.currentTimeMillis()));
        }
    }

    private void checkAdminSupport(Hashtable data, String host) {
        if (data.get("USERNAME") != null) {
            data.put("EVENT_TYPE", "1");
            String action = (String)data.get("MSG");
            if (action.indexOf("logged in") > -1) {
                data.put("SUBTYPE", "1");
                data.put("STATUS", "Success");
            } else if (action.indexOf("logged off") > -1) {
                data.put("SUBTYPE", "2");
                data.put("STATUS", "Success");
            } else if (action.indexOf("failed to login") > -1 || action.indexOf("authentication failed") > -1 || action.indexOf("login failure") > -1) {
                data.put("SUBTYPE", "3");
                data.put("STATUS", "Failed");
            } else {
                data.put("SUBTYPE", "4");
                data.put("FILENAME", data.get("MSG"));
            }
        }
    }
}

