/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.PureFirewallConstants;
import com.adventnet.fa.server.dc.AbstractLogUnifier;
import com.adventnet.fa.server.dc.CyberoamTraffic;
import com.adventnet.fa.server.dc.PIXVPNObject;
import com.adventnet.la.util.FixedHashMap;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CyberoamUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(AbstractLogUnifier.class.getName());
    private static final Integer TYPE = new Integer(1);
    private Map globalConnectionTable = new Hashtable();
    private Map resourMap = Collections.synchronizedMap(new FixedHashMap(200));

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        String ltype = (String)data.get("LTYPE");
        String logComp = (String)data.get("LOG_COMP");
        if (ltype == null) {
            return null;
        }
        String resource = (String)data.get("FW");
        if (resource == null) {
            resource = host;
            data.put("FW", host);
        }
        this.handleTime(data);
        if (ltype.startsWith("F") || logComp.indexOf("VPN") > -1) {
            if (this.dropTrafficLog(data, resource)) {
                return null;
            }
            if ("deny".equals(data.get("STATUS"))) {
                data.put("EVENT_TYPE", PureFirewallConstants.FIREWALL_DENIED_LOG);
            }
            if (this.checkVPN(data)) {
                return null;
            }
            this.checkPriority(data);
            if (this.dropInfoEvents(data)) {
                return null;
            }
        } else if (ltype.startsWith("I")) {
            this.removeRule(data);
            data.remove("REQUEST");
            logComp = (String)data.get("LOG_COMP");
            if (logComp != null) {
                data.put("SUBTYPE", logComp);
            }
            data.put("li", "1");
            data.put("EVENT_TYPE", PureFirewallConstants.ATTACK_LOG);
            this.nullifyTraffic(data);
        } else if (ltype.startsWith("C")) {
            data.put("RECORD_TYPE", "webfilter");
            if ("denied".equals(data.get("STATUS"))) {
                data.put("STATUS", "deny");
                data.put("li", 1);
                this.nullifyTraffic(data);
            }
        } else if (ltype.indexOf("Virus") > -1) {
            if (!"Virus".equals(data.get("STATUS"))) {
                if (data.get("REQUEST") == null) {
                    return null;
                }
                data.remove("RECORD_TYPE");
            } else {
                data.remove("REQUEST");
                data.put("li", "1");
            }
            this.removeRule(data);
            this.nullifyTraffic(data);
            data.put("EVENT_TYPE", PureFirewallConstants.VIRUS_LOG);
        } else if (ltype.startsWith("A")) {
            data.put("PROTOCOL", data.get("LOG_COMP"));
            data.put("RECORD_TYPE", "spam");
            data.put("li", "1");
            this.trimToAddress(data);
        } else {
            return null;
        }
        String[] strToLong = new String[]{"SENT", "RECEIVED", "DURATION"};
        this.strToLong(strToLong, data);
        data.put("rtype", TYPE);
        data.put("SYSLOGIP", host);
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT"};
        this.strToInt(strToInt, data);
        this.checkForLearnMe(data);
        if (data.get("DST_INTERFACE") != null && !"".equals(data.get("DST_INTERFACE")) && data.get("SRC_INTERFACE") != null && !"".equals(data.get("SRC_INTERFACE"))) {
            this.checkSrcDstInterfaces(data, "FW");
        }
        if (this.checksrcdstnull(data)) {
            return null;
        }
        return data;
    }

    private void trimToAddress(Hashtable data) {
        String temp = (String)data.get("TO_EMAIL");
        int i = temp.indexOf(",");
        if (i != -1) {
            data.put("TO_EMAIL", temp.substring(0, i));
        }
    }

    private boolean dropTrafficLog(Hashtable data, String resource) {
        String connectionType = (String)data.get("CTYPE");
        if (connectionType == null) {
            return false;
        }
        Map firewallConnectionTable = (Map)this.globalConnectionTable.get(resource);
        if (firewallConnectionTable == null) {
            firewallConnectionTable = new FixedHashMap(10000);
            this.globalConnectionTable.put(resource, firewallConnectionTable);
        }
        if (connectionType.endsWith("t")) {
            String vid = (String)data.get("VID");
            if (vid == null) {
                String cid = (String)data.get("CID");
                if (cid == null) {
                    return true;
                }
                CyberoamTraffic traffic = new CyberoamTraffic(cid, (String)data.get("SRC"), (String)data.get("DEST"));
                firewallConnectionTable.put(cid, traffic);
            } else {
                CyberoamTraffic traffic = (CyberoamTraffic)firewallConnectionTable.get(vid);
                if (traffic == null) {
                    return true;
                }
                traffic.setProxyStarted(true);
            }
            return true;
        }
        String vid = (String)data.get("VID");
        if (vid == null) {
            String cid = (String)data.get("CID");
            if (cid == null) {
                return true;
            }
            CyberoamTraffic traffic = (CyberoamTraffic)firewallConnectionTable.get(cid);
            if (traffic == null) {
                return true;
            }
            if (traffic.isProxyStarted()) {
                if (traffic.isProxyEnded()) {
                    traffic.setFirewallTraffic((String)data.get("SENT"), (String)data.get("RECEIVED"));
                    this.populateTrafficValues(traffic, data);
                    firewallConnectionTable.remove(cid);
                    return false;
                }
                traffic.setFirewallTraffic((String)data.get("SENT"), (String)data.get("RECEIVED"));
                traffic.setFirewallEnded(true);
                return true;
            }
            traffic.setFirewallTraffic((String)data.get("SENT"), (String)data.get("RECEIVED"));
            this.populateTrafficValues(traffic, data);
            firewallConnectionTable.remove(cid);
            return false;
        }
        CyberoamTraffic traffic = (CyberoamTraffic)firewallConnectionTable.get(vid);
        if (traffic == null) {
            return true;
        }
        if (traffic.isFirewallEnded()) {
            traffic.setProxyTraffic((String)data.get("SENT"), (String)data.get("RECEIVED"));
            this.populateTrafficValues(traffic, data);
            firewallConnectionTable.remove(vid);
            return false;
        }
        traffic.setProxyTraffic((String)data.get("SENT"), (String)data.get("RECEIVED"));
        traffic.setProxyEnded(true);
        return true;
    }

    private void populateTrafficValues(CyberoamTraffic traffic, Hashtable data) {
        data.put("SENT", new Long(traffic.getSent()));
        data.put("RECEIVED", new Long(traffic.getRcvd()));
    }

    private void nullifyTraffic(Hashtable data) {
        data.put("SENT", new Long(0L));
        data.put("RECEIVED", new Long(0L));
        data.put("DURATION", new Long(0L));
    }

    private void removeRule(Hashtable data) {
        data.remove("RULE");
    }

    @Override
    public void checkForLearnMe(Hashtable data) {
        String protocol = (String)data.get("PROTOCOL");
        if (protocol == null) {
            protocol = (String)data.get("L3_PROTO");
            data.put("L3_PROTOCOL", protocol);
            String destPort = data.get("DEST_PORT").toString();
            if (destPort != null && !"0".equals(destPort)) {
                data.put("PROTOCOL", destPort + "/" + protocol);
            }
        }
        super.checkForLearnMe(data);
    }

    private void handleTime(Hashtable data) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-ddHH:mm:ssz");
        String dateString = (String)data.get("DATE") + (String)data.get("TIME") + (String)data.get("TZ");
        dateFormat.setTimeZone(TimeZone.getTimeZone((String)data.get("TZ")));
        try {
            data.put("TIME", new Timestamp(dateFormat.parse(dateString).getTime()));
        }
        catch (Exception ee) {
            ee.printStackTrace();
            LOGGER.log(Level.FINER, " Exception while parsing Cisco Date String :: {0} Date Format ::{1}", new Object[]{dateString, dateFormat});
            data.put("TIME", new Timestamp(System.currentTimeMillis()));
        }
    }

    private boolean checkVPN(Hashtable data) {
        String logComp = (String)data.get("LOG_COMP");
        if (logComp.indexOf("VPN") > -1) {
            data.put("li", "1");
            data.put("VPN", "SSL VPN");
            String status = (String)data.get("STATUS1");
            String resource = (String)data.get("FW");
            data.put("USER", (String)data.get("USERNAME"));
            String vpnobjkey = (String)data.get("USERNAME") + (String)data.get("SRC");
            Map<String, PIXVPNObject> fwvpnMap = (Map<String, PIXVPNObject>)this.resourMap.get(resource);
            if (data.get("PROTOCOL") == null) {
                data.put("PROTOCOL", "VPN");
            }
            if (data.get("DEST") == null) {
                String tmp = "0.0.";
                data.put("DEST", tmp + "0.0");
            }
            if (status.equalsIgnoreCase("Successful")) {
                PIXVPNObject obj = new PIXVPNObject(data);
                if (fwvpnMap == null) {
                    fwvpnMap = Collections.synchronizedMap(new FixedHashMap(1000));
                    this.resourMap.put(resource, fwvpnMap);
                }
                fwvpnMap.put(vpnobjkey, obj);
                return true;
            }
            if (status.equalsIgnoreCase("Terminated")) {
                if (fwvpnMap != null && fwvpnMap.containsKey(vpnobjkey)) {
                    PIXVPNObject ob = (PIXVPNObject)fwvpnMap.remove(vpnobjkey);
                    long duration = 0L;
                    if (ob != null) {
                        Timestamp startTime = ob.getVPNTime();
                        duration = startTime == null ? 1L : (((Timestamp)data.get("TIME")).getTime() - startTime.getTime()) / 1000L;
                        this.putString("DURATION", new Long(duration), data);
                    }
                }
                return false;
            }
            if (status.equalsIgnoreCase("Failed")) {
                data.put("EVENT_TYPE", new Integer(10));
                data.put("STATUS", "deny");
                if (data.get("USERNAME") != null && "".equals(((String)data.get("USERNAME")).trim())) {
                    data.put("USERNAME", (String)data.get("SRC"));
                }
            }
        }
        return false;
    }

    @Override
    public Map getLiveData(String resource) {
        TreeMap<Timestamp, PIXVPNObject> liveVPNUserMap = new TreeMap<Timestamp, PIXVPNObject>();
        Map vpnObjMap = (Map)this.resourMap.get(resource);
        if (vpnObjMap != null) {
            for (String key : vpnObjMap.keySet()) {
                PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.get(key);
                Timestamp time = vpnObj.getVPNTime();
                liveVPNUserMap.put(time, vpnObj);
            }
        }
        return liveVPNUserMap;
    }

    private boolean checksrcdstnull(Hashtable data) {
        if ("Deny".equalsIgnoreCase((String)data.get("STATUS"))) {
            data.put("li", "1");
            if (data.get("SRC") == null && data.get("src_mac") != null) {
                data.put("MESSAGE", "src_mac=" + (String)data.get("src_mac"));
                String tmp = "0.0.";
                data.put("SRC", tmp + "0.0");
                return false;
            }
            if (data.get("SRC") == null || data.get("DEST") == null) {
                return true;
            }
        } else if (data.get("SRC") == null || data.get("DEST") == null) {
            return true;
        }
        return false;
    }

    private void putString(Object key, Object value, Hashtable data) {
        if (key == null || value == null) {
            LOGGER.log(Level.FINER, " REJECTION SRC DST SWAP REQUESTS ==={0} VALUE {1} DATA =={2}", new Object[]{key, value, data});
            return;
        }
        data.put(key, value);
    }
}

