/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.adventnet.fa.server.dc.CacheManager;
import com.adventnet.fa.server.dc.ConsolidatorTask;
import com.adventnet.la.util.pe.ParserEngineContext;
import com.adventnet.mfw.bean.BeanUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.xml.Do2XmlConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataConsolidator {
    private static final Logger LOGGER = Logger.getLogger(DataConsolidator.class.getName());
    private int recordCount = 0;
    private int exceptionCount = 0;
    public static final int MAX_BUFFER_SIZE = 100;
    public static final int MIN_THREADS = 1;
    public static final int INIT_THREADS = 1;
    public static final int MAX_THREADS = 3;
    public static final int THREAD_IDLE_TIME = 360000;
    public static final String TABLE_NAME = "ConsolidatedRecords";
    public DataObject dataCache = null;
    private DataObject exceptionCache = null;
    public Object synObject = new Object();
    private PooledExecutor executor = null;
    private static Persistence persistence = null;
    private SimpleDateFormat format = null;
    int maxRecordCount = -1;
    ClockDaemon cd = new ClockDaemon();
    boolean updateDB = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataConsolidator() {
        Object object = this.synObject;
        synchronized (object) {
            try {
                this.dataCache = DataConsolidator.getPersistence().constructDataObject();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.synObject.notifyAll();
            }
        }
        this.initializeExecutor();
        this.initializeDateFormat();
        CacheManager.getInstance().initialize();
    }

    private void initializeDateFormat() {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        this.format = new SimpleDateFormat("HH:mm:ss_dd-MM-yyyy");
        this.format.setTimeZone(TimeZone.getDefault());
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    private void initializeExecutor() {
        this.executor = new PooledExecutor((Channel)new LinkedQueue());
        this.executor.setMinimumPoolSize(1);
        this.executor.setKeepAliveTime(360000L);
        this.executor.waitWhenBlocked();
        this.executor.createThreads(1);
    }

    public void shutdown() {
        this.executor.shutdownNow();
        CacheManager.getInstance().shutdown();
    }

    public void consolidateData(Hashtable data, ParserEngineContext context) {
        try {
            this.executor.execute((Runnable)new ConsolidatorTask(this, data, context));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToDO(List rowList) {
        if (rowList.size() <= 0) {
            return;
        }
        Object object = this.synObject;
        synchronized (object) {
            int size = rowList.size();
            for (int i = 0; i < size; ++i) {
                ++this.recordCount;
                Row toAdd = null;
                try {
                    toAdd = (Row)rowList.get(i);
                    this.add(toAdd);
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINER, " Exception while adding Row {0}", toAdd);
                    ex.printStackTrace();
                    this.synObject.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToDO(Row row) {
        Object object = this.synObject;
        synchronized (object) {
            ++this.recordCount;
            try {
                this.add(row);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, " Exception while adding Row {0}", row);
                ex.printStackTrace();
                this.synObject.notifyAll();
            }
        }
    }

    private void add(Row toAdd) throws Exception {
        this.dataCache.addRow(toAdd);
    }

    public void notifyEngine(DataObject data) {
        try {
            List rawTableList = data.getTableNames();
            for (int i = 0; i < rawTableList.size(); ++i) {
                String tableName = (String)rawTableList.get(i);
                if (!data.containsTable(tableName)) continue;
                Iterator rows = data.getRows(tableName);
                while (rows.hasNext()) {
                    Row row = (Row)rows.next();
                }
            }
        }
        catch (Exception ee) {
            LOGGER.log(Level.FINER, " Exception while notifying {0}", data);
            ee.printStackTrace();
        }
    }

    public static Persistence getPersistence() {
        if (persistence != null) {
            return persistence;
        }
        try {
            persistence = (Persistence)BeanUtil.lookup((String)"Persistence");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return persistence;
    }

    private void checkIfUpdateDO(int recordCount) {
        if (this.maxRecordCount != -1 && recordCount == this.maxRecordCount) {
            this.updateDB = false;
            this.dumpDOToDB();
        }
    }

    public void scheduleDOUpdate(int maxRecordCount, int interval) {
        this.maxRecordCount = maxRecordCount;
        ConditionalDOUpdateTask dumpTask = new ConditionalDOUpdateTask(this.cd, interval);
        Object updater = this.cd.executeAfterDelay((long)interval, (Runnable)dumpTask);
    }

    public void scheduleDOUpdate(int interval) {
        DOUpdateTask dumpTask = new DOUpdateTask();
        Object updater = this.cd.executePeriodically((long)interval, (Runnable)dumpTask, false);
    }

    public void dumpDOToDB() {
        DOUpdateTask dumpTask = new DOUpdateTask();
        Thread dt = new Thread(dumpTask);
        dt.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeExceptionData(DataObject data) {
        OutputStream stream = null;
        try {
            String time = this.format.format(new Date());
            String micHome = System.getProperty("server.home");
            String fileName = micHome + File.separator + "server" + File.separator + "state";
            File file = new File(fileName);
            if (!file.exists()) {
                file.mkdirs();
            }
            fileName = fileName + File.separator + time + ".xml";
            stream = new FileOutputStream(fileName);
            Do2XmlConverter.transform((DataObject)data, (OutputStream)stream, (String)"DATA");
        }
        catch (Exception ee) {
            LOGGER.log(Level.FINER, " Exception while storing DataObjects");
            ee.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.flush();
                    ((FileOutputStream)stream).close();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
    }

    class ConditionalDOUpdateTask
    implements Runnable {
        int interval = 0;
        ClockDaemon cd = null;

        public ConditionalDOUpdateTask(ClockDaemon cd, int interval) {
            this.interval = interval;
            this.cd = cd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = DataConsolidator.this.synObject;
            synchronized (object) {
                if (DataConsolidator.this.recordCount == 0) {
                    this.rescheduleTask(this.interval);
                    return;
                }
                if (DataConsolidator.this.updateDB) {
                    DataObject backup = null;
                    try {
                        backup = (DataObject)DataConsolidator.this.dataCache.clone();
                        DataConsolidator.getPersistence().add(DataConsolidator.this.dataCache);
                        DataConsolidator.this.notifyEngine(DataConsolidator.this.dataCache);
                        DataConsolidator.this.dataCache = DataConsolidator.getPersistence().constructDataObject();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        try {
                            DataConsolidator.this.dataCache = DataConsolidator.getPersistence().constructDataObject();
                            long startTime = System.currentTimeMillis();
                            if (DataConsolidator.this.exceptionCache == null) {
                                DataConsolidator.this.exceptionCache = backup;
                            } else {
                                DataConsolidator.this.exceptionCache.merge(backup);
                            }
                            DataConsolidator.this.exceptionCount++;
                            if (DataConsolidator.this.exceptionCount >= 10) {
                                DataConsolidator.this.storeExceptionData(DataConsolidator.this.exceptionCache);
                                DataConsolidator.this.exceptionCache = DataConsolidator.getPersistence().constructDataObject();
                                DataConsolidator.this.exceptionCount = 0;
                            }
                        }
                        catch (Exception ee) {
                            ee.printStackTrace();
                        }
                        DataConsolidator.this.synObject.notifyAll();
                    }
                    DataConsolidator.this.recordCount = 0;
                    this.rescheduleTask(this.interval);
                }
            }
        }

        private void rescheduleTask(int interval) {
            this.cd.executeAfterDelay((long)interval, (Runnable)this);
        }
    }

    class DOUpdateTask
    implements Runnable {
        DOUpdateTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = DataConsolidator.this.synObject;
            synchronized (object) {
                if (DataConsolidator.this.recordCount == 0) {
                    return;
                }
                DataObject backup = null;
                try {
                    backup = (DataObject)DataConsolidator.this.dataCache.clone();
                    DataConsolidator.getPersistence().add(DataConsolidator.this.dataCache);
                    DataConsolidator.this.notifyEngine(DataConsolidator.this.dataCache);
                    DataConsolidator.this.dataCache = DataConsolidator.getPersistence().constructDataObject();
                    DataConsolidator.this.recordCount = 0;
                    DataConsolidator.this.updateDB = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DataConsolidator.this.dataCache = DataConsolidator.getPersistence().constructDataObject();
                        long startTime = System.currentTimeMillis();
                        if (DataConsolidator.this.exceptionCache == null) {
                            DataConsolidator.this.exceptionCache = backup;
                        } else {
                            DataConsolidator.this.exceptionCache.merge(backup);
                        }
                        DataConsolidator.this.exceptionCount++;
                        if (DataConsolidator.this.exceptionCount >= 10) {
                            DataConsolidator.this.storeExceptionData(DataConsolidator.this.exceptionCache);
                            DataConsolidator.this.exceptionCache = DataConsolidator.getPersistence().constructDataObject();
                            DataConsolidator.this.exceptionCount = 0;
                        }
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                    DataConsolidator.this.recordCount = 0;
                    DataConsolidator.this.synObject.notifyAll();
                }
            }
        }
    }
}

