/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.FirewallConstants;
import com.adventnet.fa.server.FirewallLicenseManager;
import com.adventnet.fa.server.ad.UserMACHandler;
import com.adventnet.fa.server.dc.AbstractLogUnifier;
import com.adventnet.fa.server.dc.ISAUtil;
import com.adventnet.fa.server.dc.PIXVPNObject;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.util.FixedHashMap;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ISAUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(ISAUnifier.class.getName());
    private static final Integer TYPE2 = new Integer(12);
    private static final Integer TYPE1 = new Integer(13);
    private String dateFormat = "yyyy-MM-ddHH:mm:ss";
    private String dbType = System.getProperty("DBType", "mysql");
    private List statusCode = Arrays.asList("13301", "blocked", "0xc004000d", "00x80074e23", "denied", "0xc0040014");
    private Hashtable htable = new Hashtable();
    private Map fwToVpnMap = new HashMap();
    private Pattern pattern = Pattern.compile("\\\\");

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        if (data.get("DELIMITER") != null) {
            this.identifyParams(host, data);
            return null;
        }
        this.checkForISACSV(host, data);
        if (!this.getRealData(host, data)) {
            return null;
        }
        if (host != null) {
            data.put("SYSLOGIP", host);
        }
        if (data.get("SRC") == null || data.get("DEST") == null && data.get("RESOURCE") != null) {
            return null;
        }
        this.checkArgument(data);
        if (data.get("FW") == null && data.get("RESOURCE") != null) {
            data.put("FW", data.get("RESOURCE"));
        }
        return data;
    }

    protected void checkArgument(Hashtable data) {
        String req = (String)data.get("REQUEST");
        if (req != null) {
            String dstName;
            if (req.endsWith("\\") && !"mssql".equals(this.dbType)) {
                req = this.pattern.matcher(req).replaceAll("\\\\\\\\");
                data.put("REQUEST", req);
            }
            if (req.startsWith("/") && (dstName = (String)data.get("DEST_NAME")) == null) {
                dstName = (String)data.get("DEST");
                req = dstName + req;
            }
            if (req.length() >= 2500) {
                req = req.substring(0, 2400) + "...";
            }
            data.put("REQUEST", req);
        }
    }

    private void checkForISACSV(String host, Hashtable data) {
        if (data.get("ISA") == null) {
            return;
        }
        if (this.htable.get(host) != null) {
            return;
        }
        List<String> header = Arrays.asList("SRC", "USERNAME", "AGENT", "AUTHUSER", "DATE", "TIME", "SERVICENAME", "FW", "REFERER", "DEST_NAME", "DEST", "DEST_PORT", "DURATION", "SENT", "RECEIVED", "PROTOCOL", "L3PROTOCOL", "OPERATION", "REQUEST", "MIME", "RESULT_CODE", "STATUS", "S_CACHE_INFO", "RULE", "FILTERINFO", "CS-NETWORK", "SC-NETWORK", "ERROR-INFO", "ACTION", "GMTLOGTIME", "AUTHENTICATIONSERVER");
        Vector<String> defHeader = new Vector<String>(header);
        this.populateMemory(host, defHeader, ",", TYPE1, null, null);
    }

    private boolean getRealData(String host, Hashtable data) {
        String sourceNetwork;
        String fw;
        ISAUtil utilObj = (ISAUtil)this.htable.get(host);
        if (utilObj == null) {
            return false;
        }
        String log = (String)data.remove("LOG");
        if (log == null) {
            return false;
        }
        if (utilObj.getDelimiter() == null) {
            return false;
        }
        String[] tokens = log.split(utilObj.getDelimiter() + "+");
        int keyLocation = 0;
        StringBuffer multiParam = new StringBuffer();
        for (int i = 0; i < tokens.length; ++i) {
            String param = tokens[i];
            String key = null;
            if (param.startsWith("\"") && param.endsWith("\"")) {
                param = this.getTrimmedData(param);
            } else {
                if (param.startsWith("\"")) {
                    multiParam.append(this.getTrimmedData(param));
                    continue;
                }
                if (param.endsWith("\"")) {
                    multiParam.append(this.getTrimmedData(param));
                    param = multiParam.toString();
                } else {
                    if (multiParam.length() > 0) {
                        multiParam.append(param);
                        continue;
                    }
                    param = this.getTrimmedData(param);
                }
            }
            if (utilObj.getParameters().size() <= keyLocation) continue;
            key = (String)utilObj.getParameters().get(keyLocation);
            ++keyLocation;
            multiParam = new StringBuffer();
            if (key == null || param == null || param.trim().length() == 0) continue;
            data.put(key, param);
        }
        String action = (String)data.get("ACTION");
        if ("Establish".equalsIgnoreCase(action) || "0xc0040041".equals(data.get("STATUS"))) {
            return false;
        }
        data.put("rtype", utilObj.getResourceType());
        data.put("FW_TYPE", "ISA");
        data.put("LOG_FORMAT", "ISA");
        this.handleTime(data, utilObj.getTZ());
        this.handleDest(data);
        this.handleProtocol(data);
        this.handleStrings(data);
        this.checkForLearnMe(data);
        if (data.get("FW_IP") != null && LaCacheManager.getInstance().getFirewallId(host + "_PROXY") == null) {
            data.put("FW", data.get("FW_IP"));
        }
        if ((fw = (String)data.get("FW")) == null || "-".equals(fw)) {
            data.put("FW", host);
        }
        if (data.get("source network") != null && (sourceNetwork = (String)data.get("source network")).indexOf("VPN") > -1) {
            data.put("li", "1");
            if ("Successful Connection".equalsIgnoreCase(action)) {
                this.addVPNObject(data, host);
                return false;
            }
            if ("Terminate".equalsIgnoreCase(action)) {
                this.handleDataLog(data, host);
            } else if ("Denied".equalsIgnoreCase(action)) {
                data.put("VPN", "ISAVPN");
                data.put("SUBTYPE", "7");
            } else if ("Disconnection".equalsIgnoreCase(action)) {
                this.removeVPNObject(data, host);
            } else {
                return false;
            }
        }
        if (utilObj.getResourceType() == 13) {
            UserMACHandler proxyHandler;
            this.handleObjectSource(data);
            Long temp = (Long)data.get("SENT");
            long bytes = 0L;
            if (temp != null) {
                bytes = temp;
            }
            if ((temp = (Long)data.get("RECEIVED")) != null) {
                bytes += temp.longValue();
            }
            data.put("BYTES", new Long(bytes));
            data.put("RESOURCE", data.get("FW") + "_PROXY");
            data.put("FW", data.get("RESOURCE"));
            String tempStatus = (String)data.get("STATUS");
            if (tempStatus != null) {
                data.put("STATUS_CODE", tempStatus);
            }
            if ("-".equals(data.get("VIRUS"))) {
                data.remove("VIRUS");
            }
            this.populateSquidCodes(data);
            data.put("Proxy", "true");
            boolean isUnManagedDevice = FirewallLicenseManager.getInstance().isUnManagedDevice((String)data.get("RESOURCE"));
            if (!isUnManagedDevice && FirewallConstants.getUserIPConfigValue() == 1 && (proxyHandler = FirewallConstants.getUserMACHandlerInstance()).isConfiguredServer((String)data.get("RESOURCE")) && !"-".equals(data.get("USERNAME"))) {
                proxyHandler.putData((String)data.get("RESOURCE"), (String)data.get("SRC"), (String)data.get("USERNAME"));
            }
        }
        this.handleStatus(data);
        this.assignDuration(data);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleDest(Hashtable data) {
        String destName = (String)data.remove("DEST_NAME");
        try {
            if (destName == null) {
                return;
            }
            if (destName.equals("-")) {
                return;
            }
            data.put("DEST", destName);
        }
        finally {
            super.handleDest(data);
        }
    }

    private void identifyParams(String host, Hashtable data) {
        String delimiter = (String)data.get("DELIMITER");
        String log = (String)data.remove("LOG");
        String headerLog = (String)data.remove("HEADER");
        if (log == null || headerLog == null) {
            return;
        }
        if (data.get("DATE_FORMAT") != null) {
            this.dateFormat = (String)data.get("DATE_FORMAT");
        }
        LOGGER.log(Level.INFO, " ISAUNIFIER IMPORTANT DELIMITER RESULT ::: {0} :: Log :::  {1}", new Object[]{delimiter, log});
        Vector<String> parameters = new Vector<String>();
        String[] tokens = log.split(delimiter);
        String tz = (String)data.get("TZ");
        for (int i = 0; i < tokens.length; ++i) {
            String param = tokens[i];
            parameters.add(this.getDatabaseParam(param));
        }
        Integer TYPE = log.indexOf("cs-uri") > 1 || log.indexOf("Object name") > 1 ? TYPE1 : TYPE2;
        this.populateMemory(host, parameters, delimiter, TYPE, tz, headerLog);
    }

    private void populateMemory(String host, Vector parameters, String delimiter, Integer TYPE, String tz, String headerLog) {
        ISAUtil utilObj = new ISAUtil();
        utilObj.setParameters(parameters);
        utilObj.setDelimiter(delimiter);
        utilObj.setResourceType(TYPE);
        utilObj.setHeaderLog(headerLog);
        utilObj.setTZ(tz);
        this.htable.put(host, utilObj);
        LOGGER.log(Level.INFO, " ISAUNIFIER PARAMETERS ::: {0} :: SIZE :::  {1} TYPE={2}", new Object[]{parameters, parameters.size() + "", TYPE});
    }

    private String getDatabaseParam(String param) {
        String result = this.getTrimmedData(param);
        if (result.equalsIgnoreCase("date")) {
            return "DATE";
        }
        if (result.equalsIgnoreCase("time")) {
            return "TIME";
        }
        if (result.equalsIgnoreCase("localtime")) {
            return "LOCAL_TIME";
        }
        if (result.equalsIgnoreCase("s-object-source") || result.equalsIgnoreCase("Object source") || result.equalsIgnoreCase("s-action")) {
            return "RESULT_CODE";
        }
        if (result.equalsIgnoreCase("sc-status") || result.equalsIgnoreCase("Result Code") || result.equalsIgnoreCase("filter-rule") || result.equals("Interface") || result.equalsIgnoreCase("status")) {
            return "STATUS";
        }
        if (result.equals("interface") || result.equalsIgnoreCase("Interface IP address")) {
            return "INTERFACE";
        }
        if (result.equalsIgnoreCase("Proxy name") || result.equalsIgnoreCase("computer") || result.equalsIgnoreCase("s-computername") || result.equalsIgnoreCase("Computer name")) {
            return "FW";
        }
        if (result.equalsIgnoreCase("s-ip")) {
            return "FW_IP";
        }
        if (result.equalsIgnoreCase("c-ip") || result.equalsIgnoreCase("Client IP") || result.equalsIgnoreCase("source-ip") || result.equalsIgnoreCase("Source IP") || result.equalsIgnoreCase("source")) {
            return "SRC";
        }
        if (result.equalsIgnoreCase("r-ip") || result.equalsIgnoreCase("destination-ip") || result.equalsIgnoreCase("Destination IP") || result.equalsIgnoreCase("destination")) {
            return "DEST";
        }
        if (result.equalsIgnoreCase("cs-protocol") || result.equalsIgnoreCase("Protocol name") || result.equalsIgnoreCase("application protocol") || result.equalsIgnoreCase("cs-uri-scheme")) {
            return "PROTOCOL";
        }
        if (result.equalsIgnoreCase("cs-uri") || result.equalsIgnoreCase("Object name") || result.equalsIgnoreCase("cs-uri-path")) {
            return "REQUEST";
        }
        if (result.equalsIgnoreCase("s-port") || result.equalsIgnoreCase("Source Port") || result.equalsIgnoreCase("param#1")) {
            return "SRC_PORT";
        }
        if (result.equalsIgnoreCase("r-port") || result.equalsIgnoreCase("param#2") || result.equalsIgnoreCase("Destination port") || result.equalsIgnoreCase("cs-uri-port")) {
            return "DEST_PORT";
        }
        if (result.equalsIgnoreCase("rule") || result.equalsIgnoreCase("rule#1") || result.equalsIgnoreCase("rule#2") || result.equalsIgnoreCase("Rule #2") || result.equalsIgnoreCase("Rule #1")) {
            return "RULE";
        }
        if (result.equalsIgnoreCase("time-taken") || result.equalsIgnoreCase("Processing time") || result.equalsIgnoreCase("connection time")) {
            return "DURATION";
        }
        if (result.equalsIgnoreCase("cs-bytes") || result.equalsIgnoreCase("Bytes sent")) {
            return "SENT";
        }
        if (result.equalsIgnoreCase("sc-bytes") || result.equalsIgnoreCase("Bytes received")) {
            return "RECEIVED";
        }
        if (result.equalsIgnoreCase("s-operation") || result.equalsIgnoreCase("Operation") || result.equalsIgnoreCase("cs-method")) {
            return "OPERATION";
        }
        if (result.equalsIgnoreCase("cs-username") || result.equalsIgnoreCase("Client user name") || result.equalsIgnoreCase("username")) {
            return "USERNAME";
        }
        if (result.equalsIgnoreCase("r-host") || result.equalsIgnoreCase("Destination name") || result.equalsIgnoreCase("cs-host")) {
            return "DEST_NAME";
        }
        if (result.equalsIgnoreCase("connectionid") || result.equalsIgnoreCase("Connection ID")) {
            return "CONNECTION_ID";
        }
        if (result.equalsIgnoreCase("sc-authenticated") || result.equalsIgnoreCase("Authorization status") || result.equalsIgnoreCase("Authentication status")) {
            return "AUTH_USER";
        }
        if (result.equalsIgnoreCase("cs-transport") || result.equalsIgnoreCase("protocol") || result.equalsIgnoreCase("Transport") || result.equalsIgnoreCase("IP Protocol")) {
            return "L3PROTOCOL";
        }
        if (result.equalsIgnoreCase("s-hierarchy")) {
            return "HIERARCHY_CODE";
        }
        if (result.equalsIgnoreCase("action")) {
            return "ACTION";
        }
        if (result.equalsIgnoreCase("URL Category") || result.equalsIgnoreCase("UrlCategory") || result.equalsIgnoreCase("cs-categories") || result.equalsIgnoreCase("cs-category")) {
            return "CATEGORY";
        }
        if (result.equalsIgnoreCase("x-virus-id")) {
            return "VIRUS";
        }
        return result;
    }

    protected void handleProtocol(Hashtable data) {
        String destPort = (String)data.get("DEST_PORT");
        String l3Protocol = (String)data.get("L3PROTOCOL");
        if (destPort != null && l3Protocol != null) {
            data.put("L3_PROTOCOL", l3Protocol);
            data.put("PROTOCOL", destPort + "/" + l3Protocol);
        }
    }

    protected void handleTime(Hashtable data, String tz) {
        String date = (String)data.get("DATE");
        String time = (String)data.get("TIME");
        String localtime = (String)data.get("LOCAL_TIME");
        SimpleDateFormat sdf = null;
        String temp = (String)data.get("DATE_FORMAT");
        sdf = temp != null ? new SimpleDateFormat(temp) : new SimpleDateFormat(this.dateFormat);
        sdf.setTimeZone(TimeZone.getDefault());
        if (localtime != null) {
            if (localtime.startsWith("[")) {
                localtime = localtime.substring(1, localtime.length() - 1);
            }
            try {
                data.put("TIME", new Timestamp(sdf.parse(localtime).getTime()));
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            return;
        }
        if (time == null || date == null) {
            return;
        }
        try {
            if (tz != null) {
                data.put("TIME", new Timestamp(sdf.parse(date + time + tz).getTime()));
            } else {
                data.put("TIME", new Timestamp(sdf.parse(date + time).getTime()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void handleStrings(Hashtable data) {
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT"};
        for (int i = 0; i <= 1; ++i) {
            String k = (String)data.get(strToInt[i]);
            if (k == null || k.compareTo("-") != 0) continue;
            data.put(strToInt[i], new Long(0L));
        }
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "RECEIVED", "STATUS_CODE"};
        for (int i = 0; i <= 2; ++i) {
            String k1 = (String)data.get(strToLong[i]);
            if (k1 == null || k1.compareTo("-") != 0) continue;
            data.put(strToLong[i], new Long(0L));
        }
        this.strToLong(strToLong, data);
    }

    protected void assignDuration(Hashtable data) {
        String elapsed = (String)data.get("DURATION");
        if (elapsed != "0" && elapsed != null) {
            try {
                int d = Integer.parseInt(elapsed);
                long duration = d / 1000;
                if (duration == 0L) {
                    duration = 1L;
                }
                data.put("DURATION", new Long(duration));
                return;
            }
            catch (Exception ee) {
                LOGGER.log(Level.FINER, " EXCEPTION WHILE PARSING DURATION TIME {0}", new Object[]{elapsed});
                data.put("DURATION", new Long(0L));
                return;
            }
        }
    }

    private String getData(String key, Hashtable data) {
        String value = (String)data.get(key);
        if (value == null) {
            return null;
        }
        return this.getTrimmedData(value);
    }

    protected void handleStatus(Hashtable data) {
        String statusvalue = (String)data.get("STATUS");
        String action = (String)data.get("ACTION");
        if (statusvalue != null && data.get("Proxy") == null) {
            if (this.statusCode.contains(statusvalue = statusvalue.toLowerCase()) || "Denied".equals(action)) {
                data.put("STATUS", "deny");
                data.put("li", "1");
                String r = (String)data.get("RULE");
                if (r == null || r.equals("-") || r != null && r.indexOf("None") > -1) {
                    data.put("RULE", "default");
                }
            } else if (statusvalue.compareTo("0xc004002a") == 0) {
                data.put("TYPE", "attack");
                data.put("li", "1");
                data.put("VIRUS", "FWX_E_SYN_ATTACK_START");
            } else if (statusvalue.compareTo("0xc004002b") == 0) {
                data.put("TYPE", "attack");
                data.put("li", "1");
                data.put("VIRUS", "FWX_E_SYN_ATTACK_END");
            } else if (statusvalue.compareTo("0xc004001c") == 0) {
                data.put("TYPE", "attack");
                data.put("li", "1");
                data.put("VIRUS", "FWX_E_LAND_ATTACK_DROPPED");
            } else {
                data.put("STATUS", "permit");
            }
        }
    }

    protected void handleObjectSource(Hashtable data) {
        try {
            String objectSource = (String)data.get("RESULT_CODE");
            String action = (String)data.get("ACTION");
            String L3P = (String)data.get("L3PROTOCOL");
            if (action != null && action.indexOf("Denied") > -1) {
                data.put("RESULT_CODE", "TCP_DENIED");
                return;
            }
            if ("udp".equalsIgnoreCase(L3P) && "Cache".equals(objectSource)) {
                data.put("RESULT_CODE", "UDP_HIT");
                return;
            }
            if ("Cache".equals(objectSource)) {
                data.put("RESULT_CODE", "TCP_HIT");
                return;
            }
            if ("Inet".equals(objectSource)) {
                data.put("RESULT_CODE", "TCP_MISS");
                return;
            }
            if ("NotModified".equals(objectSource)) {
                data.put("RESULT_CODE", "TCP_REFRESH_HIT");
                return;
            }
            if ("NVCache".equals(objectSource)) {
                data.put("RESULT_CODE", "TCP_SWAPFAIL");
                return;
            }
            if ("Vcache".equals(objectSource)) {
                data.put("RESULT_CODE", "TCP_IMS_HIT");
                return;
            }
            if ("VFInet".equals(objectSource)) {
                data.put("RESULT_CODE", "TCP_REFRESH_MISS");
                return;
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void flushMemory(String host) {
        this.htable.remove(host);
    }

    @Override
    public String getHeader(String host) {
        ISAUtil util = (ISAUtil)this.htable.get(host);
        if (util != null) {
            return util.getHeaderLog();
        }
        return null;
    }

    private String getTrimmedData(String value) {
        value = value.replaceAll("\"", "");
        value = value.trim();
        return value;
    }

    private void addVPNObject(Hashtable data, String host) {
        try {
            String resource = (String)data.get("FW");
            String user = (String)data.get("USERNAME");
            String src = (String)data.get("SRC");
            PIXVPNObject vpnObj = new PIXVPNObject(data);
            vpnObj.setResource(resource);
            vpnObj.setUser(user);
            Map<String, PIXVPNObject> vpnObjMap = (Map<String, PIXVPNObject>)this.fwToVpnMap.get(resource);
            if (vpnObjMap == null) {
                vpnObjMap = Collections.synchronizedMap(new FixedHashMap(800));
                this.fwToVpnMap.put(resource, vpnObjMap);
            }
            data.remove("VPN");
            vpnObjMap.put(src, vpnObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleDataLog(Hashtable data, String host) {
        PIXVPNObject vpnObj;
        data.put("VPN", "ISAVPN");
        String resource = (String)data.get("FW");
        String src = (String)data.get("SRC");
        Map vpnObjMap = (Map)this.fwToVpnMap.get(resource);
        if (vpnObjMap != null && (vpnObj = (PIXVPNObject)vpnObjMap.get(src)) != null) {
            String user;
            this.aggregateSentAndRcvd(vpnObj, data);
            String tranIP = (String)data.get("TRAN_IP");
            if (tranIP != null) {
                vpnObj.setTranIp(tranIP);
            }
            if ((user = vpnObj.getUser()) != null) {
                data.put("USERNAME", user);
            }
        }
    }

    private void removeVPNObject(Hashtable data, String host) {
        try {
            PIXVPNObject vpnObj;
            data.put("VPN", "ISAVPN");
            data.remove("DEST");
            String resource = (String)data.get("FW");
            String user = (String)data.get("USERNAME");
            String src = (String)data.get("SRC");
            Map vpnObjMap = (Map)this.fwToVpnMap.get(resource);
            if (vpnObjMap != null && (vpnObj = (PIXVPNObject)vpnObjMap.remove(src)) != null) {
                if (vpnObj.getSentBytes() != null) {
                    data.put("SENT", vpnObj.getSentBytes());
                    data.put("RECEIVED", vpnObj.getRcvdBytes());
                }
                if (vpnObj.getTranIp() != null) {
                    data.put("TRAN_IP", vpnObj.getTranIp());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void handleUserIPIntegration(String host, Hashtable data) {
    }
}

