/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.dc.WELFLogUnifier;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.logging.Logger;

public class JuniperIDPLogUnifier
extends WELFLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(JuniperIDPLogUnifier.class.getName());
    private static final Integer TYPE = new Integer(1);
    String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private boolean addSensorAsResource = Boolean.valueOf(System.getProperty("addSensorAsResource", "true"));

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        boolean isSensorLog;
        String source = (String)data.get("logsource");
        boolean bl = isSensorLog = "s".equals(source);
        if (!isSensorLog) {
            data = this.populateEntries(data, host);
        }
        if (data == null) {
            System.out.println("WARNING: Unable to process the log. Returning null !!");
            return null;
        }
        data.put("FW_TYPE", "Juniper IDP");
        data.put("FW", host);
        data.put("rtype", TYPE);
        data.put("SYSLOGIP", host);
        data.put("LOG_FORMAT", "Juniper Native Syslog");
        String sensor = (String)data.get("SENSOR_NAME");
        String sensorIP = (String)data.get("SENSOR_IP");
        String string = sensor = sensor != null && !"".equals(sensor) ? sensor : sensorIP;
        if (!isSensorLog && this.addSensorAsResource && sensor != null) {
            data.put("FW", sensor);
        }
        this.checkForMgmtRecords(data);
        this.checkSrcDstInterfaces(data, "FW");
        this.updateRule(data);
        this.updateTime(data);
        this.checkPriority(data);
        this.updateStatus(data);
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT", "EVENT_TYPE"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "RECEIVED", "DURATION", "SENT_PKT", "RECEIVED_PKT", "TRAN_PORT", "STATUS_CODE", "POLICY_ID"};
        this.strToLong(strToLong, data);
        this.updateProtocol(data);
        return data;
    }

    private Hashtable populateEntries(Hashtable passedData, String host) {
        String log = (String)passedData.get("log");
        if (log == null) {
            return null;
        }
        String[] attributes = log.split(",");
        int size = attributes.length;
        Hashtable myData = new Hashtable();
        myData.put("FORMAT_ID", passedData.get("FORMAT_ID"));
        myData.put("SYSLOG_SERVER", passedData.get("SYSLOG_SERVER"));
        for (String key : passedData.keySet()) {
            Object val = passedData.get(key);
            if (!(val instanceof String)) continue;
            String value = null;
            try {
                if (key.startsWith("OPEN_")) {
                    String newKey = key.substring(5, key.length());
                    myData.put(newKey, passedData.get(key));
                    continue;
                }
                int index = Integer.parseInt((String)val);
                if (index > size) {
                    System.out.println("WARNING: JuniperIDPLogUnifier Unable to obtain value for " + key);
                    continue;
                }
                value = attributes[index];
                if (value == null || "".equals(value) || "(NULL)".equals(value.trim())) continue;
                myData.put(key, value.trim());
            }
            catch (NumberFormatException nfe) {
                if (value == null || "".equals(value) || "(NULL)".equals(value.trim())) continue;
                myData.put(key, value);
            }
        }
        return myData;
    }

    private void updateProtocol(Hashtable data) {
        String protocol = (String)data.get("PROTOCOL");
        String dst_port = data.get("DEST_PORT").toString();
        if (protocol != null && !"".equals(protocol) && dst_port != null && !"".equals(dst_port)) {
            String proto = protocol.trim() + "/" + dst_port.trim();
            data.put("PROTOCOL", proto);
            super.checkProtocolSyntax(data);
        }
    }

    private void updateStatus(Hashtable data) {
        this.handleAllowedStatus(data);
        String status = (String)data.get("STATUS");
        if (status != null && !"".equals(status)) {
            status = "dismiss".equals(status) ? "deny" : status;
            data.put("STATUS", status);
        }
    }

    private void updateTime(Hashtable data) {
        String time = (String)data.get("TIME");
        if (time != null && !"".equals(time)) {
            SimpleDateFormat sdf = new SimpleDateFormat(this.DATE_FORMAT);
            sdf.setTimeZone(TimeZone.getDefault());
            try {
                data.put("TIME", new Timestamp(sdf.parse(time).getTime()));
            }
            catch (Exception exp) {
                exp.printStackTrace();
                data.put("TIME", new Timestamp(System.currentTimeMillis()));
            }
        }
    }

    private void updateRule(Hashtable data) {
        String ruleBase = (String)data.get("RULEBASE");
        String ruleNo = (String)data.get("RULENO");
        if (ruleBase != null && ruleNo != null) {
            String rule = ruleBase + "-" + ruleNo;
            data.put("RULE", rule);
        }
    }

    private void checkForMgmtRecords(Hashtable data) {
        String category = (String)data.get("CATEGORY");
        if ("Config".equals(category)) {
            data.remove("VIRUS");
        }
    }
}

