/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.FirewallConstants;
import com.adventnet.fa.server.PureFirewallConstants;
import com.adventnet.fa.server.dc.PIXVPNObject;
import com.adventnet.fa.server.dc.WELFLogUnifier;
import com.adventnet.la.util.FixedHashMap;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class JuniperSSLVPNLogUnifier
extends WELFLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(JuniperSSLVPNLogUnifier.class.getName());
    private static final Integer TYPE = new Integer(23);
    private Map fwToVpnMap = new HashMap();
    private String adminUserGroup = "Admin Users,Employee_Administrator";
    private ArrayList adminUserGroupList = new ArrayList();

    public JuniperSSLVPNLogUnifier() {
        try {
            this.adminUserGroup = FirewallConstants.getAdminUserGroup();
            if (this.adminUserGroup == null || "".equals(this.adminUserGroup)) {
                this.adminUserGroup = "Admin Users,Employee_Administrator";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.adminUserGroup = "Admin Users,Employee_Administrator";
        }
        if (this.adminUserGroup.indexOf(",") > 0) {
            String[] groups = this.adminUserGroup.split(",");
            for (int i = 0; i < groups.length; ++i) {
                this.adminUserGroupList.add(groups[i]);
            }
        } else {
            this.adminUserGroupList.add(this.adminUserGroup);
        }
    }

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        if (data.get("FW") == null || "ive".equalsIgnoreCase((String)data.get("FW"))) {
            data.put("FW", host);
            data.put("VPN", "SSLVPN");
        }
        this.checkPriority(data);
        if ("true".equals((String)data.get("DROP_LOG")) || "127.0.0.1".equals(data.get("SRC")) && "System".equals(data.get("USERNAME"))) {
            int pri = 6;
            try {
                pri = Integer.parseInt((String)data.get("PRIORITY"));
                data.put("PRIORITY", "" + (pri %= 8));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (pri > 4) {
                return null;
            }
            data.put("EVENT_TYPE", PureFirewallConstants.HIGH_SEVERITY_LOG);
            data.put("li", "1");
            data.remove("VPN");
        }
        data.put("li", "1");
        data.put("rtype", TYPE);
        data.put("FW_TYPE", "Juniper SSL VPN");
        data.put("LOG_FORMAT", "Juniper SSL VPN");
        this.handleUserName(data);
        this.handleTime(data);
        boolean dropLog = this.addVpnSupport(data, host);
        if (dropLog) {
            return null;
        }
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT", "EVENT_TYPE"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "RECEIVED", "DURATION"};
        this.strToLong(strToLong, data);
        this.handleProtocol(data);
        return data;
    }

    @Override
    public void checkPriority(Hashtable data) {
        super.checkPriority(data);
        if (data == null) {
            return;
        }
        try {
            int pri = Integer.parseInt((String)data.get("PRIORITY"));
            if (pri > 7) {
                data.put("PRIORITY", "" + (pri %= 8));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void handleProtocol(Hashtable data) {
        String proto = "tcp";
        data.put("L3_PROTOCOL", proto);
        if (data.get("PROTOCOL") == null) {
            String dstPort = data.get("DEST_PORT").toString();
            proto = dstPort + "/" + proto;
            data.put("PROTOCOL", proto);
        }
        super.checkProtocolSyntax(data);
    }

    private void handleUserName(Hashtable data) {
        String user = (String)data.get("USERNAME");
        if (user != null) {
            int slashIndex = user.indexOf("\\");
            user = slashIndex <= 0 ? user : user.substring(slashIndex + 1);
            data.put("USERNAME", user);
        }
    }

    private void handleTime(Hashtable data) {
        String time = (String)data.get("DATE_STRING");
        String dateFormat = (String)data.get("DATE_FORMAT");
        if (time == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        try {
            data.put("TIME", new Timestamp(sdf.parse(time).getTime()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean addVpnSupport(Hashtable data, String host) {
        boolean dropLog = false;
        if (data.get("VPN") != null) {
            String uname = "";
            String key = (String)data.get("KEY");
            String userGroup = (String)data.get("USER_GROUP");
            if (key != null) {
                userGroup = userGroup.trim();
                String loginStatus = (String)data.get("LOGIN_STATUS");
                if (key.equalsIgnoreCase("Login") && loginStatus != null) {
                    if (loginStatus.indexOf("succeeded") > -1) {
                        if (this.adminUserGroupList.contains(userGroup)) {
                            data.put("EVENT_TYPE", "1");
                            data.put("SUBTYPE", "1");
                            data.remove("VPN");
                        } else {
                            this.addVPNObject(data, host);
                        }
                    }
                    if (loginStatus.indexOf("failed") > -1) {
                        if (this.adminUserGroupList.contains(userGroup)) {
                            data.put("EVENT_TYPE", "1");
                            data.put("SUBTYPE", "3");
                            data.remove("VPN");
                        } else {
                            data.put("EVENT_TYPE", new Integer(10));
                            data.put("li", "1");
                        }
                    }
                } else if (key.equals("Logout")) {
                    if (this.adminUserGroupList.contains(userGroup)) {
                        data.put("EVENT_TYPE", "1");
                        data.put("SUBTYPE", "2");
                        data.remove("VPN");
                    } else {
                        this.removeVPNObject(data, host);
                    }
                } else if (key.equals("Session")) {
                    String sessionTimeStatus = (String)data.get("FIELD1");
                    String sessionTerminateStatus = (String)data.get("FIELD2");
                    String sessionStatus = "active";
                    if (sessionTimeStatus != null) {
                        sessionStatus = sessionTimeStatus;
                    } else if (sessionTerminateStatus != null) {
                        sessionStatus = sessionTerminateStatus;
                    } else {
                        dropLog = true;
                    }
                    if (sessionStatus.equals("timed out") || sessionStatus.equals("terminated")) {
                        if (this.adminUserGroupList.contains(userGroup)) {
                            data.put("EVENT_TYPE", "1");
                            data.put("SUBTYPE", "2");
                            data.remove("VPN");
                        } else {
                            this.removeVPNObject(data, host);
                        }
                    }
                }
            } else {
                PIXVPNObject vpnObj;
                String resource = (String)data.get("FW");
                String user = (String)data.get("USERNAME");
                String src = (String)data.get("SRC");
                String dummyKey = user + src;
                Map vpnObjMap = (Map)this.fwToVpnMap.get(resource);
                if (vpnObjMap != null && (vpnObj = (PIXVPNObject)vpnObjMap.get(dummyKey)) != null) {
                    long old = 0L;
                    if (vpnObj.getSentBytes() != null) {
                        old = vpnObj.getSentBytes();
                    }
                    long temp = Long.parseLong((String)data.get("SENT"));
                    long total = old + temp;
                    Long totalSent = new Long(total);
                    vpnObj.setSentBytes(totalSent);
                    old = vpnObj.getRcvdBytes() != null ? vpnObj.getRcvdBytes() : 0L;
                    temp = Long.parseLong((String)data.get("RECEIVED"));
                    total = old + temp;
                    Long totalRcvd = new Long(total);
                    vpnObj.setRcvdBytes(totalRcvd);
                    String dest = (String)data.get("DEST");
                    if (dest.indexOf("Meeting_ID") > -1) {
                        data.put("PROTOCOL", "netmeeting");
                        data.put("DEST", host);
                    }
                }
            }
        }
        return dropLog;
    }

    private void addVPNObject(Hashtable data, String host) {
        try {
            String resource = (String)data.get("FW");
            String user = (String)data.get("USERNAME");
            String src = (String)data.get("SRC");
            String dummyKey = user + src;
            PIXVPNObject vpnObj = new PIXVPNObject(data);
            vpnObj.setResource(resource);
            vpnObj.setUser(user);
            vpnObj.setVPNName((String)data.remove("VPN"));
            Map<String, PIXVPNObject> vpnObjMap = (Map<String, PIXVPNObject>)this.fwToVpnMap.get(resource);
            if (vpnObjMap == null) {
                vpnObjMap = Collections.synchronizedMap(new FixedHashMap(800));
                this.fwToVpnMap.put(resource, vpnObjMap);
            }
            vpnObjMap.put(dummyKey, vpnObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeVPNObject(Hashtable data, String host) {
        try {
            data.remove("DEST");
            String resource = (String)data.get("FW");
            String user = (String)data.get("USERNAME");
            String src = (String)data.get("SRC");
            String dummyKey = user + src;
            Map vpnObjMap = (Map)this.fwToVpnMap.get(resource);
            if (vpnObjMap != null) {
                PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.remove(dummyKey);
                long duration = 0L;
                if (vpnObj != null) {
                    if (vpnObj.getSentBytes() != null) {
                        data.put("SENT", vpnObj.getSentBytes());
                        data.put("RECEIVED", vpnObj.getRcvdBytes());
                    }
                    Timestamp startTime = vpnObj.getVPNTime();
                    Timestamp endTime = (Timestamp)data.get("TIME");
                    duration = endTime.getTime() - startTime.getTime();
                    duration /= 1000L;
                }
                data.put("DURATION", new Long(duration));
            } else {
                data.put("DURATION", new Long(0L));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map getLiveData(String resource) {
        TreeMap<Timestamp, PIXVPNObject> liveVPNUserMap = new TreeMap<Timestamp, PIXVPNObject>();
        Map vpnObjMap = (Map)this.fwToVpnMap.get(resource);
        if (vpnObjMap != null) {
            for (String key : vpnObjMap.keySet()) {
                PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.get(key);
                Timestamp time = vpnObj.getVPNTime();
                liveVPNUserMap.put(time, vpnObj);
            }
        }
        return liveVPNUserMap;
    }
}

