/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.FirewallConstants;
import com.adventnet.fa.server.FirewallLicenseManager;
import com.adventnet.fa.server.ad.UserMACHandler;
import com.adventnet.fa.server.dc.AbstractLogUnifier;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SquidLogUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(SquidLogUnifier.class.getName());
    private static final Integer TYPE = new Integer(6);
    private static Pattern pattern = Pattern.compile("(.*?://)?([^:|/]*)");
    private static Pattern regex = Pattern.compile("\\s([a-zA-Z]+\\s*&?\\s*[a-zA-Z]*)$");

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        UserMACHandler proxyHandler;
        Matcher dstMatcher;
        Matcher cat;
        String url;
        String userName;
        String method;
        if ("true".equals((String)data.get("DROP_LOG"))) {
            return null;
        }
        data.put("Proxy", "true");
        data.put("ResourceType", "Squid");
        data.put("rtype", TYPE);
        if (host != null) {
            data.put("SYSLOGIP", host);
        }
        if ((method = (String)data.remove("METHOD")) != null) {
            data.put("OPERATION", method);
        } else {
            data.put("OPERATION", "-");
        }
        data.put("RESOURCE", host);
        data.put("FW", host);
        this.handleTime(data);
        if (data.get("Host") == null) {
            data.put("Host", host);
        }
        if (data.get("RFC931") != null) {
            userName = (String)data.remove("RFC931");
            String userNameTemp = this.checkUser(userName);
            if (userNameTemp.equals("-")) {
                userName = (String)data.remove("AUTH_USER");
                if (userName != null) {
                    data.put("USERNAME", this.checkUser(userName));
                } else {
                    data.put("USERNAME", userNameTemp);
                }
            } else {
                data.put("USERNAME", userNameTemp);
            }
        } else {
            userName = (String)data.remove("AUTH_USER");
            data.put("USERNAME", this.checkUser(userName));
        }
        userName = (String)data.get("USERNAME");
        String userGroup = (String)data.get("USERGROUP");
        if (userName != null && userName != "-" && userGroup != null) {
            data.put("USERNAME", userName + "-" + userGroup);
        }
        if ((url = (String)data.remove("URL")).length() > 2000) {
            url = url.substring(0, 2000);
        }
        data.put("REQUEST", url);
        int index_proto = url.indexOf(":");
        if (index_proto > 0 && index_proto <= 5) {
            String proto = url.substring(0, url.indexOf(":"));
            data.put("PROTOCOL", proto);
        } else {
            data.put("PROTOCOL", "http");
        }
        if (data.get("MSG") != null && (cat = regex.matcher((String)data.get("MSG"))).find() && cat.groupCount() >= 1) {
            String category = cat.group(1);
            data.put("CATEGORY", category);
        }
        if ((dstMatcher = pattern.matcher(url)).find() && dstMatcher.groupCount() >= 2) {
            String dest = dstMatcher.group(2);
            data.put("DEST", dest);
        }
        this.handleDuration(data);
        this.handleStatus(data);
        this.populateSquidCodes(data);
        String[] strToLong = new String[]{"STATUS_CODE", "BYTES"};
        this.strToLong(strToLong, data);
        boolean isUnManagedDevice = FirewallLicenseManager.getInstance().isUnManagedDevice(host);
        if (!isUnManagedDevice && FirewallConstants.getUserIPConfigValue() == 1 && (proxyHandler = FirewallConstants.getUserMACHandlerInstance()).isConfiguredServer(host) && !"-".equals(data.get("USERNAME"))) {
            proxyHandler.putData(host, (String)data.get("SRC"), (String)data.get("USERNAME"));
        }
        return data;
    }

    private void handleTime(Hashtable data) {
        String time = (String)data.remove("TIME_SEC");
        String timeMS = (String)data.remove("TIME_MS");
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        if (time != null) {
            time = timeMS == null ? time + "000" : time + timeMS;
            try {
                data.put("TIME", sdf.format(new Date(new Long(time))));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (data.get("TIME") != null) {
            time = (String)data.remove("TIME");
            String format = (String)data.get("DATE_FORMAT");
            if (format == null) {
                data.put("TIME", new Timestamp(System.currentTimeMillis()));
                return;
            }
            SimpleDateFormat df = new SimpleDateFormat(format);
            try {
                data.put("TIME", new Timestamp(df.parse(time).getTime()));
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        } else {
            data.put("TIME", new Timestamp(System.currentTimeMillis()));
        }
    }

    private void handleDuration(Hashtable data) {
        Object toBeChangedObj = data.get("DURATION");
        if (toBeChangedObj == null) {
            data.put("DURATION", new Long(0L));
            return;
        }
        long duraVal = 0L;
        Long changed = null;
        String durationStr = (String)toBeChangedObj;
        int dotPoint = durationStr.indexOf(".");
        duraVal = dotPoint == -1 ? Long.parseLong(durationStr) : new Long(durationStr.substring(0, dotPoint)) * 1000L + new Long(durationStr.substring(dotPoint + 1, durationStr.length()));
        try {
            if ((duraVal /= 1000L) <= 0L) {
                duraVal = 1L;
            }
            changed = new Long(duraVal);
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(Level.INFO, " Unable to parse as Long {0} :: {1}", new Object[]{"DURATION", durationStr});
        }
        data.put("DURATION", changed);
    }

    private String checkUser(String invalue) {
        if (invalue != null) {
            int len = invalue.length();
            if (len > 1 || len == 0) {
                return invalue;
            }
            if (invalue.equals("\\")) {
                return "-";
            }
            return invalue;
        }
        return "-";
    }

    @Override
    protected void handleUserIPIntegration(String host, Hashtable data) {
    }

    private void handleStatus(Hashtable data) {
        String status = (String)data.get("STATUS");
        if (status != null) {
            if ("B".equals(status)) {
                data.put("STATUS", "denied");
                data.put("RESULT_CODE", "TCP_DENIED");
            } else {
                data.put("STATUS", "permit");
            }
        }
    }
}

