/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.fa.server.FirewallConstants;
import com.adventnet.fa.server.lc.PacketUtil;
import com.adventnet.la.util.ResourceCheckerUtil;
import com.adventnet.la.util.ServerUtil;
import com.adventnet.persistence.Row;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class RecordWriter
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(RecordWriter.class.getName());
    private int fileCount = 0;
    private String tableName = null;
    private FileWriter fWriter = null;
    private PrintWriter writer = null;
    private String fileName = null;
    private String fileToDump = null;
    private static Row firewallrecords = new Row("FirewallRecords");
    private static Row squidrecords = new Row("SquidRecords");
    Object writeObj = new Object();
    Object dumper = new Object();
    private int flowCount = 0;
    boolean shutdown = false;
    private static String tmpFileDir = System.getProperty("server.home") + File.separator + "server" + File.separator + "tmp";
    private static boolean dbType = "mssql".equals(System.getProperty("DBType", "mysql"));
    private static boolean isPostgres = "postgres".equals(System.getProperty("DBType"));
    private static boolean isWinAuthType = "true".equals(System.getProperty("isWinAuthType", "false"));
    private String dbserver = "";
    private String dbname = "";
    private String dbuser = "";
    private String dbpass = "";
    private String commandToExecute = null;
    private String bcpPerfParams = "";
    String delimiter = isPostgres ? "\t" : "|**|";
    private static final boolean DUMP_INTO_DB = Boolean.valueOf(System.getProperty("dumpintodb", "true"));

    public RecordWriter(String tableName) {
        super("LoadThread for " + tableName);
        LOGGER.log(Level.INFO, "RecordWriter Constructor Called for  {0}", tableName);
        this.tableName = tableName;
        LOGGER.log(Level.FINE, "RecordWriter abt to call initTempFile()");
        this.initTempFile();
        this.populateMSSQLDBValues();
        this.populateBcpPerfParams(tableName);
        this.start();
    }

    private void populateMSSQLDBValues() {
        if (dbType) {
            String osName;
            String xmlFilePath = System.getProperty("server.home") + File.separator + "conf" + File.separator + "database_params.conf";
            HashMap DBParams = ResourceCheckerUtil.getConstraints((String)xmlFilePath, (String)"firewall");
            if (DBParams != null) {
                this.dbserver = (String)DBParams.get("DBServer");
                this.dbname = (String)DBParams.get("DBName");
                this.dbuser = (String)DBParams.get("DBUser");
                this.dbpass = (String)DBParams.get("DBPass");
                if (this.dbpass == null) {
                    this.dbpass = "";
                }
            }
            if ((osName = System.getProperty("os.name")).equalsIgnoreCase("windows nt") || osName.equalsIgnoreCase("windows 2000") || osName.equalsIgnoreCase("windows xp") || osName.equalsIgnoreCase("Windows 2003") || osName.equalsIgnoreCase("windows vista") || osName.startsWith("Win") && (osName.indexOf("95") < 0 || osName.indexOf("98") >= 0)) {
                this.commandToExecute = "cmd  /c ";
            } else if (osName.indexOf("95") >= 0 || osName.indexOf("98") >= 0) {
                this.commandToExecute = "command.com /c ";
            }
        }
    }

    private void populateBcpPerfParams(String tableName) {
        if (dbType) {
            String bcpBatchSize = System.getProperty("bcpBatchSize", "1000");
            String bcpNetPacketSize = System.getProperty("bcpNetSize", "4096");
            String bcpOrderBy = "\"ORDER (LRID ASC)\"";
            String lowerTable = tableName.toLowerCase();
            if (lowerTable.startsWith("squid")) {
                bcpOrderBy = "\"ORDER (SQID ASC)\"";
            }
            this.bcpPerfParams = " -a " + bcpNetPacketSize + " -b " + bcpBatchSize + " -h " + bcpOrderBy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Hashtable unifiedOutput, String ip, Boolean fromImport, Boolean considerAsVdom, String physicalDevName) {
        boolean writeData = PacketUtil.incrementCount((String)unifiedOutput.get("FW"), ip, unifiedOutput, fromImport, considerAsVdom, physicalDevName);
        if (!writeData) {
            return;
        }
        String data = this.getData(unifiedOutput);
        Object object = this.writeObj;
        synchronized (object) {
            ++this.flowCount;
            this.writer.println(data);
        }
        if (this.flowCount > 50000 && System.getProperty("DUMP_NOTIFY") != null) {
            object = this.dumper;
            synchronized (object) {
                this.dumper.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Row row) {
        LOGGER.log(Level.FINER, "[RecordWriter.save()] Inside RecordWriter's save() method **** for table::" + this.tableName);
        String data = this.getData(row);
        Object object = this.writeObj;
        synchronized (object) {
            ++this.flowCount;
            this.writer.println(data);
        }
        if (this.flowCount > 300 && System.getProperty("DUMP_NOTIFY") != null) {
            LOGGER.log(Level.FINER, "[RecordWriter.save()] flowCount greater than or eq to 300 for table:::" + this.tableName);
            object = this.dumper;
            synchronized (object) {
                this.dumper.notifyAll();
            }
        }
    }

    private String getData(Row row) {
        List values = row.getValues();
        StringBuffer sb = new StringBuffer();
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            Object value;
            if (i > 0) {
                sb.append(this.delimiter);
            }
            if ((value = values.get(i)) != null) {
                if (isPostgres && value instanceof String) {
                    sb.append(Matcher.quoteReplacement(value.toString()));
                    continue;
                }
                sb.append(values.get(i));
                continue;
            }
            if (value != null || dbType) continue;
            sb.append("\\N");
        }
        if (!isPostgres) {
            sb.append(this.delimiter);
        }
        return sb.toString();
    }

    public synchronized void flush() {
        this.writeToFile();
        this.dumpToDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                LOGGER.log(Level.FINER, " FILE TO DUMP FROM RECORD WRITER =={0}", this.fileToDump);
                this.writeToFile();
                this.dumpToDatabase();
            }
            catch (Exception exp) {
                LOGGER.log(Level.WARNING, "Exception occured while Saving data to file or dumping data into DB ", exp);
            }
            finally {
                try {
                    Object exp = this.dumper;
                    synchronized (exp) {
                        this.dumper.wait(FirewallConstants.getRawDumpingTime());
                    }
                }
                catch (Exception exp) {
                    LOGGER.log(Level.WARNING, "Exception while waiting ", exp);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void dumpToDatabase() {
        RelationalAPI rapi = RelationalAPI.getInstance();
        Connection con = null;
        Statement stmt = null;
        if (this.fileToDump != null) {
            try {
                File tmpFile = new File(tmpFileDir + File.separator + this.fileToDump);
                String filePath = tmpFile.getCanonicalPath();
                filePath = filePath.replace('\\', '/');
                if (isPostgres) {
                    this.lock();
                    con = rapi.getConnection();
                    stmt = con.createStatement();
                    LOGGER.log(Level.FINER, "Dropping Table Indexes");
                    stmt.addBatch("copy " + this.tableName + " from  '" + filePath + "' delimiter '\t'");
                    stmt.executeBatch();
                    this.unlock();
                    LOGGER.log(Level.FINER, "Index recreation is finished");
                } else if (dbType) {
                    this.lock();
                    if (isWinAuthType) {
                        this.loadDataInToMSSQL(this.commandToExecute + " ..\\bin\\bcp.exe " + this.dbname + ".dbo." + this.tableName + " in " + filePath + " -S " + this.dbserver + " -T -t \"|**|\" -r \"|**|\\n\" -e ..\\logs\\loaddataerr.txt " + this.bcpPerfParams + " -c -q");
                    } else {
                        this.loadDataInToMSSQL(this.commandToExecute + " ..\\bin\\bcp.exe " + this.dbname + ".dbo." + this.tableName + " in " + filePath + " -S " + this.dbserver + " -U " + this.dbuser + " -P \"" + this.dbpass + "\" -t \"|**|\" -r \"|**|\\n\" -e ..\\logs\\loaddataerr.txt " + this.bcpPerfParams + " -c -q");
                    }
                    this.unlock();
                } else {
                    String sql = "load data local infile '" + filePath + "' into table " + this.tableName + " fields terminated by '|**|' ";
                    con = rapi.getConnection();
                    stmt = con.createStatement();
                    this.lock();
                    int recordCount = stmt.executeUpdate(sql);
                    this.unlock();
                    LOGGER.log(Level.INFO, recordCount + " Records written");
                    LOGGER.log(Level.FINER, "Loaded {0} rows to Table {1}", new Object[]{new Integer(recordCount), this.tableName});
                }
                this.deleteTempFiles(this.fileToDump);
                this.fileToDump = null;
            }
            catch (BatchUpdateException exp) {
                LOGGER.log(Level.FINER, "[RecordWriter.run()] Exception while loading data to table {0}", this.tableName);
                exp.printStackTrace();
                for (SQLException ex = exp.getNextException(); ex != null; ex = ex.getNextException()) {
                    ex.printStackTrace();
                }
                this.clearInterrupt();
            }
            catch (Exception exp) {
                LOGGER.log(Level.FINER, "[RecordWriter.run()] Exception while loading data to table {0}", this.tableName);
                exp.printStackTrace();
                this.clearInterrupt();
            }
            finally {
                try {
                    stmt.close();
                    con.close();
                }
                catch (Exception exp) {
                    stmt = null;
                    con = null;
                }
            }
        }
    }

    private void loadDataInToMSSQL(String command) throws Exception {
        ServerUtil.BCPLOCK.lock();
        BufferedReader in = null;
        FileOutputStream fos = null;
        try {
            int c;
            fos = new FileOutputStream(System.getProperty("server.home") + File.separator + "logs" + File.separator + "loadData.log");
            Process p = Runtime.getRuntime().exec(command);
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((c = in.read()) != -1) {
                fos.write(c);
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            ServerUtil.BCPLOCK.unlock();
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ee) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception ee) {}
            }
        }
    }

    private String getData(Hashtable unifiedOutput) {
        List columns = "FirewallRecords".equalsIgnoreCase((String)unifiedOutput.get("tableName")) ? firewallrecords.getColumns() : squidrecords.getColumns();
        StringBuffer sb = new StringBuffer();
        int size = columns.size();
        Object value = null;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(this.delimiter);
            }
            if (unifiedOutput == null) {
                LOGGER.log(Level.WARNING, "Unified output is null");
            } else {
                value = unifiedOutput.get(columns.get(i));
            }
            if (value != null) {
                if (isPostgres && value instanceof String) {
                    sb.append(Matcher.quoteReplacement(value.toString()));
                    continue;
                }
                sb.append(value);
                continue;
            }
            if (value != null || dbType) continue;
            sb.append("\\N");
        }
        if (!isPostgres) {
            sb.append(this.delimiter);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeToFile() {
        if (this.flowCount == 0) {
            return;
        }
        Object object = this.writeObj;
        synchronized (object) {
            this.writer.flush();
            this.closeTempFileWriters();
            this.flowCount = 0;
        }
    }

    private void closeTempFileWriters() {
        this.closeFlowWriters();
        this.writer = null;
        this.fWriter = null;
        this.fileToDump = this.fileName;
        this.fileName = null;
        this.initTempFile();
    }

    private void closeFlowWriters() {
        try {
            this.writer.close();
            this.fWriter.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, " Exception while closing file {0}", e.getMessage());
        }
    }

    private void initTempFile() {
        try {
            this.fileCount = this.fileCount == 0 ? 1 : 0;
            this.fileName = this.tableName + "_" + this.fileCount + ".txt";
            this.fWriter = new FileWriter(tmpFileDir + File.separator + this.fileName, false);
            this.writer = new PrintWriter((Writer)new BufferedWriter(this.fWriter), false);
            LOGGER.log(Level.FINER, "[RecordWriter.initTempFile()] Created new temp file as {0}{1}{2}", new Object[]{tmpFileDir, File.separator, this.fileName});
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, " Exception while opening file for table: {0}", this.tableName);
            LOGGER.log(Level.WARNING, " Exception while opening file to log flows: {0}", e);
        }
    }

    public String getTempFileName() {
        return this.fileName;
    }

    public String getTableName() {
        return this.tableName;
    }

    private void deleteTempFiles(String fileName) {
        try {
            if (fileName == null) {
                return;
            }
            File tmpFile = new File(tmpFileDir + File.separator + fileName);
            boolean del = tmpFile.delete();
            tmpFile = null;
            LOGGER.log(Level.FINER, " Deleted tmp file {0} when closing service{1}", new Object[]{fileName, new Boolean(del)});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        Object object = this.writeObj;
        synchronized (object) {
            this.writer.flush();
            this.closeFlowWriters();
        }
    }

    private void clearInterrupt() {
        Thread th = Thread.currentThread();
        if (th.isInterrupted()) {
            LOGGER.log(Level.FINER, "[RecordWriter.clearInterrupt()] Thread was interrupted while running loading File {0}", this.fileToDump);
            th.interrupted();
            LOGGER.log(Level.FINER, "[RecordWriter.clearInterrupt()] Interruption cleared ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backUpTheFile() {
        boolean renamed = false;
        try {
            File tmpFile = new File(tmpFileDir + File.separator + this.fileToDump);
            String newName = System.currentTimeMillis() + "_" + this.fileToDump;
            LOGGER.log(Level.FINER, "[RecordWriter.backUpTheFile] {0}", newName);
            renamed = tmpFile.renameTo(new File(newName));
            LOGGER.log(Level.FINER, "Rename Status :  {0}", new Boolean(renamed));
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            if (!renamed) {
                this.deleteTempFiles(this.fileToDump);
            }
        }
    }

    private void lock() {
        PacketUtil.baseTableLock.get().lock();
    }

    private void unlock() {
        PacketUtil.baseTableLock.get().unlock();
    }
}

