/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.fa.server.lc.Flow;
import com.adventnet.fa.server.lc.FlowCreate;
import com.adventnet.fa.server.lc.PacketUtil;
import com.adventnet.fa.server.lc.V9Template;
import com.adventnet.la.util.FixedHashMap;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public class V9Flow
extends Flow {
    private static Map conn_map = Collections.synchronizedMap(new FixedHashMap(10000));
    private static V9Template.V9_IDS v9_ids;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    protected String conn_id;
    protected String src;
    protected String dst;
    protected String xlate_src;
    protected String xlate_dst;
    protected String proto;
    protected String srcPort;
    protected String dstPort;
    protected String xlate_srcPort;
    protected String xlate_dstPort;
    protected String src_if;
    protected String dst_if;
    protected String bytes;
    protected String ingressACL;
    protected String egressACL;
    protected String user = "Unknown";
    protected String ruleHash = "0";
    protected String hostIP;
    protected String fw_type;
    protected int event_code;
    protected int ext_event_code;
    Long event_occur_time;
    Long create_event_time;
    long duration = 0L;

    V9Flow() {
    }

    V9Flow(String[] v9_data, String hostIP) {
        this.hostIP = hostIP;
        this.fw_type = "Cisco";
        this.event_occur_time = new Long(v9_data[V9Template.V9_IDS.NF_F_EVENT_TIME_MSEC.ordinal()]);
        this.event_code = new Integer(v9_data[V9Template.V9_IDS.NF_F_FW_EVENT.ordinal()]);
        this.ext_event_code = new Integer(v9_data[V9Template.V9_IDS.NF_F_FW_EXT_EVENT.ordinal()]);
        switch (this.event_code) {
            default: {
                return;
            }
            case 1: {
                this.conn_id = v9_data[V9Template.V9_IDS.NF_F_CONN_ID.ordinal()];
                this.parseFlowCreateData(v9_data, this.event_occur_time);
                this.storeFlowCreate(hostIP);
                return;
            }
            case 2: {
                this.conn_id = v9_data[V9Template.V9_IDS.NF_F_CONN_ID.ordinal()];
                if (v9_data[V9Template.V9_IDS.NF_F_FLOW_CREATE_TIME_MSEC.ordinal()] != null) {
                    this.parseFlowCreateData(v9_data, new Long(v9_data[V9Template.V9_IDS.NF_F_FLOW_CREATE_TIME_MSEC.ordinal()]));
                } else {
                    this.fetchFlowCreate(hostIP);
                }
                this.duration = (this.event_occur_time - this.create_event_time) / 1000L;
                break;
            }
            case 3: {
                this.assignAcl(v9_data, this.event_code);
            }
        }
        String temp = v9_data[V9Template.V9_IDS.NF_F_SRC_ADDR_IPV4.ordinal()];
        this.src = PacketUtil.str_addr(new Long(temp));
        temp = v9_data[V9Template.V9_IDS.NF_F_DST_ADDR_IPV4.ordinal()];
        this.dst = PacketUtil.str_addr(new Long(temp));
        temp = v9_data[V9Template.V9_IDS.NF_F_XLATE_SRC_ADDR_IPV4.ordinal()];
        if (temp != null) {
            this.xlate_src = PacketUtil.str_addr(new Long(temp));
        }
        if ((temp = v9_data[V9Template.V9_IDS.NF_F_XLATE_DST_ADDR_IPV4.ordinal()]) != null) {
            this.xlate_dst = PacketUtil.str_addr(new Long(temp));
        }
        this.xlate_srcPort = v9_data[V9Template.V9_IDS.NF_F_XLATE_SRC_PORT.ordinal()];
        this.xlate_dstPort = v9_data[V9Template.V9_IDS.NF_F_XLATE_DST_PORT.ordinal()];
        this.src_if = v9_data[V9Template.V9_IDS.NF_F_SRC_INTF_ID.ordinal()];
        this.dst_if = v9_data[V9Template.V9_IDS.NF_F_DST_INTF_ID.ordinal()];
        this.proto = v9_data[V9Template.V9_IDS.NF_F_PROTOCOL.ordinal()];
        this.srcPort = v9_data[V9Template.V9_IDS.NF_F_SRC_PORT.ordinal()];
        this.dstPort = v9_data[V9Template.V9_IDS.NF_F_DST_PORT.ordinal()];
        this.bytes = v9_data[V9Template.V9_IDS.NF_F_FLOW_BYTES.ordinal()];
    }

    private void storeFlowCreate(String hostIP) {
        FlowCreate fc = new FlowCreate(this.create_event_time, this.user, this.ruleHash);
        String key = hostIP + "_" + this.conn_id;
        conn_map.put(key, fc);
    }

    private void parseFlowCreateData(String[] v9_data, Long create_event_time) {
        this.create_event_time = create_event_time;
        this.user = v9_data[V9Template.V9_IDS.NF_F_USERNAME.ordinal()];
        this.assignAcl(v9_data, this.event_code);
    }

    private void fetchFlowCreate(String hostIP) {
        String key = hostIP + "_" + this.conn_id;
        FlowCreate fc = (FlowCreate)conn_map.get(key);
        if (fc != null) {
            this.user = fc.user;
            this.create_event_time = fc.create_event_time;
            this.ruleHash = fc.ruleHash;
        } else {
            this.create_event_time = this.event_occur_time;
        }
    }

    private void assignAcl(String[] v9_data, int event_code) {
        String ingress_acl = v9_data[V9Template.V9_IDS.NF_F_INGRESS_ACL_ID.ordinal()];
        String egress_acl = v9_data[V9Template.V9_IDS.NF_F_EGRESS_ACL_ID.ordinal()];
        if (ingress_acl == null && egress_acl == null) {
            return;
        }
        if (event_code == 3) {
            String string = this.ruleHash = this.ext_event_code == 1001 ? ingress_acl : egress_acl;
        }
        if ("0".equals(this.ruleHash)) {
            this.ruleHash = "0".equals(egress_acl) ? ingress_acl : egress_acl;
        }
        this.ruleHash = Long.toHexString(Long.parseLong(this.ruleHash));
    }

    @Override
    public String getFwType() {
        return this.fw_type;
    }

    @Override
    public String getSrcInt() {
        return this.src_if;
    }

    @Override
    public String getDstInt() {
        return this.dst_if;
    }

    @Override
    public String getSrcPort() {
        return this.srcPort;
    }

    @Override
    public String getDstPort() {
        return this.dstPort;
    }

    @Override
    public String getXlateSrcPort() {
        return this.xlate_srcPort;
    }

    @Override
    public String getXlateDstPort() {
        return this.xlate_dstPort;
    }

    @Override
    public String getUser() {
        if ("".equals(this.user)) {
            return null;
        }
        return this.user;
    }

    @Override
    public String getBytes() {
        return this.bytes;
    }

    @Override
    public String getRule() {
        String hash = this.hostIP + "_" + this.ruleHash;
        String temp = V9Template.getRuleName(hash);
        if (temp == null) {
            return this.ruleHash;
        }
        return temp;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public String getProtocol() {
        String protoStr = (String)this.protoNumberVsName.get(this.proto);
        if (this.l3_protocols.contains(protoStr)) {
            String port = this.dstPort != null && !this.dstPort.equals("0") ? this.dstPort : (this.srcPort != null ? this.srcPort : "0");
            protoStr = port + "/" + protoStr;
        }
        return protoStr;
    }

    public int getEventCode() {
        return this.event_code;
    }

    public int getExtEventCode() {
        return this.ext_event_code;
    }

    @Override
    public String getHostIP() {
        return this.hostIP;
    }

    @Override
    public String getTime() {
        Date time = new Date(new Long(this.event_occur_time));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(time);
    }

    @Override
    public String getConnId() {
        return this.conn_id;
    }

    @Override
    public String getSrc() {
        return this.src;
    }

    @Override
    public String getDst() {
        return this.dst;
    }

    @Override
    public String getXlateSrc() {
        return this.xlate_src;
    }

    @Override
    public String getXlateDst() {
        return this.xlate_dst;
    }
}

