/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.rules;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Vector;
import jlibdiff.Diff;
import jlibdiff.Hunk;
import jlibdiff.HunkAdd;
import jlibdiff.HunkChange;
import jlibdiff.HunkDel;

public class DiffUtil {
    Vector arr1 = new Vector();
    Vector arr2 = new Vector();
    Vector firstFile = new Vector();
    Vector secondFile = new Vector();
    int count1 = 0;
    int count2 = 0;
    Vector changed = new Vector();
    Vector added = new Vector();
    Vector deleted = new Vector();
    int noOfLinesAddedInFirstFile = 0;
    int noOfLinesAddedInSecondFile = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDiff(byte[] fileContents1, byte[] fileContents2) {
        InputStream stream1 = null;
        InputStream stream2 = null;
        try {
            this.arr1 = new Vector();
            this.arr2 = new Vector();
            this.firstFile = new Vector();
            this.secondFile = new Vector();
            stream1 = new ByteArrayInputStream(fileContents1);
            stream2 = new ByteArrayInputStream(fileContents2);
            this.initializeVectors(stream1, stream2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            try {
                stream1.close();
                stream2.close();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        ByteArrayInputStream file1 = null;
        ByteArrayInputStream file2 = null;
        BufferedReader in = null;
        BufferedReader inn = null;
        try {
            file1 = new ByteArrayInputStream(fileContents1);
            file2 = new ByteArrayInputStream(fileContents2);
            in = new BufferedReader(new InputStreamReader(file1));
            inn = new BufferedReader(new InputStreamReader(file2));
            this.getAddDelChangedVectors(in, inn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
                inn.close();
                ((InputStream)file1).close();
                ((InputStream)file2).close();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    private void getAddDelChangedVectors(BufferedReader file1, BufferedReader file2) throws IOException {
        this.added = new Vector();
        this.deleted = new Vector();
        this.changed = new Vector();
        int[] arr = new int[4];
        Diff d = new Diff();
        d.diffBuffer(file1, file2);
        Vector hunks = d.getHunks();
        int size = hunks.size();
        for (int i = 0; i < size; ++i) {
            arr = new int[4];
            Object k = hunks.elementAt(i);
            if (!(k instanceof Hunk)) continue;
            arr[0] = ((Hunk)k).lowLine(0);
            arr[1] = ((Hunk)k).highLine(0);
            arr[2] = ((Hunk)k).lowLine(1);
            arr[3] = ((Hunk)k).highLine(1);
            if (k instanceof HunkAdd) {
                this.added.add(arr);
                this.handleAddedLines(arr);
            }
            if (k instanceof HunkDel) {
                this.deleted.add(arr);
                this.handleDeletedLines(arr);
            }
            if (!(k instanceof HunkChange)) continue;
            this.changed.add(arr);
            this.handleModifiedLines(arr);
        }
    }

    private void initializeVectors(InputStream file1, InputStream file2) throws IOException {
        int i;
        this.count1 = 0;
        this.count2 = 0;
        this.firstFile = new Vector();
        this.secondFile = new Vector();
        this.arr1 = new Vector();
        this.arr2 = new Vector();
        LineNumberReader reader1 = new LineNumberReader(new InputStreamReader(file1));
        LineNumberReader reader2 = new LineNumberReader(new InputStreamReader(file2));
        String line = "";
        while ((line = reader1.readLine()) != null) {
            this.firstFile.add(line);
            ++this.count1;
        }
        while ((line = reader2.readLine()) != null) {
            this.secondFile.add(line);
            ++this.count2;
        }
        for (i = 0; i < this.count1; ++i) {
            this.arr1.add("0");
        }
        for (i = 0; i < this.count2; ++i) {
            this.arr2.add("0");
        }
        reader1.close();
        reader2.close();
    }

    private void handleAddedLines(int[] add) {
        int index1 = 0;
        for (int i = add[2]; i <= add[3]; ++i) {
            this.arr2.set(i - 1 + this.noOfLinesAddedInSecondFile, "1");
            index1 = add[0] + this.noOfLinesAddedInFirstFile;
            this.arr1.add(index1, "5");
            this.firstFile.add(index1, "");
            ++this.noOfLinesAddedInFirstFile;
        }
    }

    private void handleDeletedLines(int[] del) {
        int index1 = 0;
        int index2 = 0;
        for (int i = del[0]; i <= del[1]; ++i) {
            index1 = i - 1 + this.noOfLinesAddedInFirstFile;
            this.arr1.set(index1, "2");
            index2 = del[3] + this.noOfLinesAddedInSecondFile;
            this.arr2.add(index2, "5");
            this.secondFile.add(index2, "");
            ++this.noOfLinesAddedInSecondFile;
        }
    }

    private void handleModifiedLines(int[] add) {
        int index0 = 0;
        if (add[1] - add[0] == add[3] - add[2]) {
            int k;
            for (k = add[0]; k <= add[1]; ++k) {
                index0 = k - 1 + this.noOfLinesAddedInFirstFile;
                this.arr1.set(index0, "3");
            }
            index0 = 0;
            for (k = add[2]; k <= add[3]; ++k) {
                index0 = k - 1 + this.noOfLinesAddedInSecondFile;
                this.arr2.set(index0, "3");
            }
        } else if (add[1] - add[0] > add[3] - add[2]) {
            index0 = 0;
            for (int k = add[0]; k <= add[1]; ++k) {
                index0 = k - 1 + this.noOfLinesAddedInFirstFile;
                this.arr1.set(index0, "3");
            }
            int index1 = 0;
            int curAddedLines = 0;
            int noOfLinesAddedSoFar = 0;
            for (int k = 0; k <= add[1] - add[0]; ++k) {
                index1 = add[2] + k + this.noOfLinesAddedInSecondFile;
                if (curAddedLines >= add[3] - add[2] + 1) {
                    this.arr2.add(index1 - 1, "3");
                    this.secondFile.add(index1 - 1, "");
                    ++curAddedLines;
                    ++noOfLinesAddedSoFar;
                    continue;
                }
                this.arr2.set(index1 - 1, "3");
                ++curAddedLines;
            }
            this.noOfLinesAddedInSecondFile += noOfLinesAddedSoFar;
        } else {
            index0 = 0;
            for (int k = add[2]; k <= add[3]; ++k) {
                index0 = k - 1 + this.noOfLinesAddedInSecondFile;
                this.arr2.set(index0, "3");
            }
            int index1 = 0;
            int curAddedLines = 0;
            int noOfLinesAddedSoFar = 0;
            for (int k = 0; k <= add[3] - add[2]; ++k) {
                index1 = add[0] + k + this.noOfLinesAddedInFirstFile;
                if (curAddedLines >= add[1] - add[0] + 1) {
                    this.arr1.add(index1 - 1, "3");
                    this.firstFile.add(index1 - 1, "");
                    ++curAddedLines;
                    ++noOfLinesAddedSoFar;
                    continue;
                }
                this.arr1.set(index1 - 1, "3");
                ++curAddedLines;
            }
            this.noOfLinesAddedInFirstFile += noOfLinesAddedSoFar;
        }
    }

    public Vector getFirstDiff() {
        return this.arr1;
    }

    public Vector getSecondDiff() {
        return this.arr2;
    }

    public Vector getFirstFile() {
        return this.firstFile;
    }

    public Vector getSecondFile() {
        return this.secondFile;
    }
}

