/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.rules;

import com.adventnet.cli.CLIResourceManager;
import com.adventnet.cli.CLISession;
import com.adventnet.cli.util.CLILogMgr;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.FACacheManager;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.FirewallConstants;
import com.adventnet.fa.server.FirewallLicenseManager;
import com.adventnet.fa.server.rules.CLIConnectionManager;
import com.adventnet.fa.server.rules.CiscoPolicyProcessor;
import com.adventnet.fa.server.rules.DeviceCommandParser;
import com.adventnet.fa.server.rules.DeviceConnection;
import com.adventnet.fa.server.rules.DiffUtil;
import com.adventnet.fa.server.rules.FortiGatePolicyProcessor;
import com.adventnet.fa.server.rules.PolicyParserManager;
import com.adventnet.fa.server.rules.PolicyProcessor;
import com.adventnet.fa.server.rules.SRXPolicyProcessor;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.LaUtil;
import com.adventnet.la.util.EncryptionAPI;
import com.adventnet.la.util.HTMLFileReader;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.la.util.SmtpMailer;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.constant.Constable;
import java.net.InetAddress;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FwConfigMgmt {
    private static final Logger LOGGER = Logger.getLogger(FwConfigMgmt.class.getName());
    private static FwConfigMgmt confMgmt = null;
    private DeviceConnection dCon = null;
    private DeviceCommandParser dcp = null;
    private CLIConnectionManager cliConnMgr = null;
    private PolicyParserManager policyParseMgr = null;
    private EncryptionAPI encryptionObj = null;
    private EncryptionAPI decryptionObj = null;
    private String from = "firewallreport@localdomain.com";
    private String mailHost = "smtp";
    private String mailPort = "25";
    private String user = null;
    private String password = null;
    private String tls = "no";
    private String smsPort = "COM1";
    private Map<String, String> runningConfigMemMap = null;
    private String runningCnfgPattern = ".*Last configuration.*by (\\S+).*";
    private String startupCnfgPattern = ".*NVRAM config last updated .*by (\\S+).*";
    private static Map<String, Long> lastFetchTimeMap = null;
    private static final ReentrantLock DELETELOCK = new ReentrantLock();
    ResourceBundle bundle = ProductBundle.getInstance().getBundle();

    private FwConfigMgmt() {
        this.dCon = DeviceConnection.getInstance();
        this.dcp = DeviceCommandParser.getInstance();
        this.cliConnMgr = CLIConnectionManager.getInstance();
        this.policyParseMgr = PolicyParserManager.getInstance();
        this.encryptionObj = EncryptionAPI.getEncryptionObj();
        this.decryptionObj = EncryptionAPI.getDecryptionObj();
        this.runningConfigMemMap = new HashMap<String, String>(50);
        lastFetchTimeMap = new HashMap<String, Long>(100);
    }

    public static synchronized FwConfigMgmt getInstance() {
        if (confMgmt == null) {
            confMgmt = new FwConfigMgmt();
        }
        return confMgmt;
    }

    public Hashtable insertIfDiffExists_dummy(String resourceName, String changedBy, Long rID, String threadName) {
        try {
            String configData = this.dCon.reteriveConfigurationData(null, "auto", null, rID, "running", Boolean.TRUE, null, Boolean.FALSE);
            this.initiatePolicyProcessing(rID, "Cisco", configData, "running", new Long("25"), threadName);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return null;
    }

    public Hashtable insertIfDiffExists(String resourceName, String changedBy, Long rID) {
        return this.insertIfDiffExists(resourceName, changedBy, rID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable insertIfDiffExists(String resourceName, String changedBy, Long rID, String threadName) {
        LOGGER.log(Level.FINE, " FWConfigMgmt:::Inside insertIfDiffExists method...resourceID -->{0} changedBy -->{1} resourceName -->{2}", new Object[]{rID, changedBy, resourceName});
        Hashtable reqDetails = new Hashtable();
        DataObject dObj = null;
        Properties prop = null;
        boolean isVdom = false;
        Long baseRID = new Long(0L);
        String configMemKey = null;
        CLISession cli = null;
        try {
            Vector fetchingTaskDetails = this.getConfigFetchDetails(resourceName, changedBy, rID, Boolean.FALSE);
            if (fetchingTaskDetails.size() > 1) {
                String vdomName;
                dObj = (DataObject)fetchingTaskDetails.get(1);
                prop = (Properties)fetchingTaskDetails.get(2);
                isVdom = (Boolean)fetchingTaskDetails.get(3);
                baseRID = (Long)fetchingTaskDetails.get(4);
                cli = this.dCon.createSession(prop);
                String resID = rID.toString();
                configMemKey = resID + changedBy;
                List complianceCmds = null;
                String configData = null;
                DiffUtil diffUtil = new DiffUtil();
                String deviceType = prop.getProperty("deviceType");
                Long maxVersion = this.getMaxConfigVersion(rID, "running");
                if (isVdom) {
                    vdomName = (String)LaCacheManager.getInstance().getResourceName(rID);
                    prop.put("vdomName", vdomName);
                    complianceCmds = this.dcp.getVdomRunningComplianceCommands(deviceType);
                    configData = this.dCon.reteriveConfigurationData(prop, "auto", complianceCmds, rID, "running", Boolean.TRUE, cli, Boolean.TRUE);
                    this.dCon.setEnableModeStatus(cli, Boolean.TRUE);
                } else {
                    complianceCmds = this.dcp.getRunningComplianceCommands(deviceType);
                    configData = this.dCon.reteriveConfigurationData(prop, "auto", complianceCmds, rID, "running", Boolean.TRUE, cli, Boolean.FALSE);
                    this.dCon.setEnableModeStatus(cli, Boolean.TRUE);
                }
                if (configData == null) {
                    reqDetails = null;
                    LOGGER.info("@@FWConfigMgmt::: inside insertIfDiffExists method...didn't get running config...hence setting the return details to null and proceeding for startup config fetching...for rid::" + rID);
                } else if (maxVersion.equals(new Long(0L))) {
                    Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                    this.insertNewVersion(rID, maxVersion, changedBy, timestamp, "-", configData, "running", "-", new Integer(0));
                    if ("Cisco".equalsIgnoreCase(deviceType)) {
                        this.runningConfigMemMap.put(configMemKey, configData);
                    }
                    reqDetails = null;
                } else {
                    reqDetails = this.checkInNewVersionIfDiffExists(configData, rID, "running", changedBy, prop, Boolean.FALSE, maxVersion, threadName);
                }
                if ("Cisco".equalsIgnoreCase(deviceType)) {
                    if (isVdom) {
                        vdomName = (String)LaCacheManager.getInstance().getResourceName(rID);
                        prop.put("vdomName", vdomName);
                        complianceCmds = this.dcp.getVdomStartupComplianceCommands(deviceType);
                        configData = this.dCon.reteriveConfigurationData(prop, "auto", complianceCmds, rID, "startup", Boolean.TRUE, cli, Boolean.TRUE);
                    } else {
                        complianceCmds = this.dcp.getStartupComplianceCommands(deviceType);
                        configData = this.dCon.reteriveConfigurationData(prop, "auto", complianceCmds, rID, "startup", Boolean.TRUE, cli, Boolean.FALSE);
                    }
                    String runningConfig = this.runningConfigMemMap.remove(configMemKey);
                    if (configData == null) {
                        LOGGER.info("@@FWConfigMgmt ::: inside insertIfDiffExists method:::: got null startup config for rid ::::" + rID);
                    } else if (maxVersion.equals(new Long(0L))) {
                        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                        this.insertNewVersion(rID, maxVersion, changedBy, timestamp, "-", configData, "startup", "-", new Integer(0));
                        byte[] startupContents = configData.getBytes();
                        byte[] runningContents = runningConfig.getBytes();
                        HashMap conflictContents = this.getDiff(startupContents, runningContents, deviceType);
                        boolean conflictExists = this.checkForDiff(conflictContents);
                        if (conflictExists) {
                            LOGGER.fine("inside conflict exists...for the very first insert ...");
                            String conflictContentData = this.getDiffContentsOnly(conflictContents);
                            int realCont = conflictContentData.lastIndexOf("<->");
                            String diffCount = conflictContentData.substring(realCont + 3);
                            String dbDiffContents = conflictContentData.substring(0, realCont);
                            int tempCount = Integer.parseInt(diffCount);
                            Integer diff_count = new Integer(tempCount);
                            try {
                                DataObject conflictDO = DataAccess.constructDataObject();
                                Row conflictRow = new Row("StartupRunningConflict");
                                conflictRow.set("RID", (Object)rID);
                                conflictRow.set("STARTUP_VNO", (Object)new Long(1L));
                                conflictRow.set("RUNNING_VNO", (Object)new Long(1L));
                                conflictRow.set("CHANGED_BY", (Object)changedBy);
                                conflictRow.set("ANNOTATION", (Object)"-");
                                conflictRow.set("MODIFIED_TIME", (Object)timestamp);
                                conflictRow.set("DIFF_CONTENTS", (Object)dbDiffContents);
                                conflictRow.set("DIFF_COUNT", (Object)diff_count);
                                conflictDO.addRow(conflictRow);
                                DataAccess.add((DataObject)conflictDO);
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.INFO, " Exception while putting an entry in conflict table as conflict table has an entry with resourceID--->" + rID);
                                e.printStackTrace();
                            }
                        }
                    } else {
                        this.checkInNewVersionIfDiffExists(configData, rID, "startup", changedBy, prop, Boolean.FALSE, maxVersion);
                    }
                }
                this.updateStatus(dObj, 1, null);
            } else {
                reqDetails = null;
            }
        }
        catch (Exception ee) {
            LOGGER.warning("@@FWConfigMgmt:::: Got exception in insertIfDiffExists method for the resource::: " + resourceName);
            ee.printStackTrace();
            this.updateStatus(dObj, -1, ee.getMessage());
        }
        finally {
            LOGGER.fine("@@FWConfigMgmt:::: Inside closing the CLI Session for ondemand config fetch.....");
            if (prop != null) {
                String dummyKey = rID.toString() + prop.getProperty("loginName");
                LOGGER.info("@@FWConfigMgmt:::: before closing session for ondemand config fetch, updating the lastFetchTimeMap for the key:::" + dummyKey);
                lastFetchTimeMap.put(dummyKey, new Long(System.currentTimeMillis()));
                if (isVdom && !rID.equals(baseRID)) {
                    dummyKey = baseRID.toString() + prop.getProperty("loginName");
                    LOGGER.info("@@FWConfigMgmt:::: updating the lastFetchTimeMap for the base vdom rid...and the key is :::" + dummyKey);
                    lastFetchTimeMap.put(dummyKey, new Long(System.currentTimeMillis()));
                    rID = baseRID;
                }
            }
            this.dCon.cleanUp(cli, rID);
        }
        return reqDetails != null && reqDetails.size() > 0 ? reqDetails : null;
    }

    private Vector getConfigFetchDetails(String resourceName, String changedBy, Long rID, Boolean checkForLastFetch) {
        Vector<Serializable> fetchingTaskDetails = new Vector<Serializable>();
        try {
            Long lastFetchTime;
            long lastFetchinMS;
            DataObject dObj = null;
            FirewallLicenseManager fwaLic = FirewallLicenseManager.getInstance();
            if (!fwaLic.showPremiumFeatures()) {
                LOGGER.info("@@FWConfigMgmt::: inside getConfigFetchDetails method...returning null...as because of professional license..");
                fetchingTaskDetails.add(Boolean.FALSE);
                return fetchingTaskDetails;
            }
            if (rID == null || rID.equals(new Long(0L))) {
                rID = (Long)LaCacheManager.getInstance().getFirewallId(resourceName);
            }
            String dummyKey = rID.toString() + changedBy;
            long timeNow = System.currentTimeMillis();
            if (checkForLastFetch.booleanValue() && lastFetchTimeMap.get(dummyKey) != null && timeNow - (lastFetchinMS = (lastFetchTime = lastFetchTimeMap.get(dummyKey)).longValue()) < 180000L) {
                LOGGER.info("@@FWConfigMgmt::: As CLISession has created less than 3 mins ago, returning null....for rid::" + rID);
                fetchingTaskDetails.add(Boolean.FALSE);
                return fetchingTaskDetails;
            }
            String ip = (String)LaCacheManager.getInstance().getResourceIp(rID);
            List vdomList = FAServerUtil.getVdomDevicesList();
            boolean isVdom = vdomList.contains(ip);
            Long tempRID = rID;
            if (isVdom) {
                SelectQueryImpl sql = new SelectQueryImpl(new Table("DeviceDetails"));
                sql.addSelectColumn(new Column("DeviceDetails", "*"));
                Join devRuleToRes = new Join("DeviceDetails", "Resources", new String[]{"RID"}, new String[]{"RESOURCEID"}, 2);
                sql.addJoin(devRuleToRes);
                sql.addSelectColumn(new Column("Resources", "*"));
                sql.setCriteria(new Criteria(new Column("Resources", "IPADDRESS"), (Object)ip, 0));
                DataObject tempDO = DataAccess.get((SelectQuery)sql);
                if (!tempDO.isEmpty()) {
                    tempRID = (Long)tempDO.getFirstValue("DeviceDetails", "RID");
                }
            }
            boolean isProfileBased = false;
            String temp = this.isProfBased(tempRID);
            if (temp == null) {
                LOGGER.info("@@FWConfigMgmt::: inside getConfigFetchDetails method...returning null...as DeviceRule not configured.." + rID);
                fetchingTaskDetails.add(Boolean.FALSE);
                return fetchingTaskDetails;
            }
            Boolean isProfTemp = Boolean.valueOf(temp);
            isProfileBased = isProfTemp;
            LOGGER.fine("isprofbased val in getConfigFetchDetails method is:::" + isProfileBased);
            dObj = isProfileBased ? this.getProfileDO(tempRID) : this.getDO(tempRID);
            LOGGER.fine("@@FWConfigMgmt::: inside getConfigFetchDetails method::::dataobject based on rid is:::" + dObj);
            String tableName = isProfileBased ? "DIPCredentials" : "DeviceCredentials";
            Properties prop = this.dCon.getPropertiesFromDO(dObj, tableName);
            LOGGER.fine("@@FWConfigMgmt::: inside getConfigFetchDetails method::::properties from DO is:::" + prop);
            String cmEnabled = (String)prop.get("genConfMgmtReport");
            if (!"true".equals(cmEnabled)) {
                LOGGER.info("Change Mgmt is not configured...returning null...for ddid -> " + (Long)prop.get("DDID"));
                fetchingTaskDetails.add(Boolean.FALSE);
                return fetchingTaskDetails;
            }
            fetchingTaskDetails.add(Boolean.TRUE);
            fetchingTaskDetails.add((Serializable)dObj);
            fetchingTaskDetails.add(prop);
            fetchingTaskDetails.add(Boolean.valueOf(isVdom));
            fetchingTaskDetails.add(tempRID);
            return fetchingTaskDetails;
        }
        catch (Exception ee) {
            LOGGER.info("@@FWConfigMgmt::: Exception while getting FetchingTaskDetails for rid :: " + rID);
            ee.printStackTrace();
            fetchingTaskDetails.add(Boolean.FALSE);
            return fetchingTaskDetails;
        }
    }

    public void initiatePolicyProcessing(Long rID, String deviceType, String configData, String configType, Long versionNo, String currentThreadName) {
        LOGGER.log(Level.FINE, " FWConfigMgmt:::Inside initiatePolicyProcessing method...deviceType --> {0},resourceID -->{1}", new Object[]{deviceType, rID});
        if ("running".equals(configType)) {
            String displayName = FACacheManager.getInstance().getDisplayName(rID);
            this.policyParseMgr.createPolicyParserTask(displayName, rID, deviceType, configData, versionNo, currentThreadName);
        }
    }

    public void initiateConfigFetching(String deviceType, String resourceName, String changedBy, Long rID) {
        LOGGER.log(Level.FINE, " FWConfigMgmt:::Inside initiateConfigFetching method...deviceType --> {0},resourceID -->{1} changedBy -->{2}", new Object[]{deviceType, rID, changedBy});
        Vector fetchingTaskDetails = this.getConfigFetchDetails(resourceName, changedBy, rID, Boolean.TRUE);
        if (fetchingTaskDetails.size() > 1) {
            DataObject dObj = (DataObject)fetchingTaskDetails.get(1);
            Properties prop = (Properties)fetchingTaskDetails.get(2);
            Boolean isVdom = (Boolean)fetchingTaskDetails.get(3);
            Long baseRID = (Long)fetchingTaskDetails.get(4);
            this.cliConnMgr.createConfigFetcherTask(dObj, prop, resourceName, changedBy, rID, isVdom, baseRID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void logoutSyslogConfigFetchHandling(DataObject dObj, Properties prop, String resourceName, String changedBy, Long rID, Boolean isVdom, Long baseRID) {
        LOGGER.log(Level.INFO, " FWConfigMgmt:::Inside logoutSyslogConfigFetchHandling method...prop --> {0},resourceName -->{1} changedBy -->{2} rID -->{3} baseRID -->{4} ", new Object[]{prop, resourceName, changedBy, rID, baseRID});
        String dummyKey = null;
        String configMemKey = null;
        CLISession cli = null;
        boolean gotException = false;
        String errMsg = null;
        try {
            if (rID.equals(new Long(0L))) {
                rID = (Long)LaCacheManager.getInstance().getFirewallId(resourceName);
            }
            dummyKey = rID.toString() + changedBy;
            List<Long> resList = new ArrayList<Long>();
            if (isVdom.booleanValue()) {
                Long frid;
                if (!dObj.isEmpty() && (resList = FAServerUtil.getResForDDID(frid = (Long)dObj.getFirstValue("DeviceDetails", "DDID"))) == null) {
                    FAServerUtil.populateDDIDToResMap();
                    resList = FAServerUtil.getResForDDID(frid);
                }
            } else {
                resList.add(rID);
            }
            long timeNow = System.currentTimeMillis();
            cli = this.dCon.createSession(prop);
            for (Long rid : resList) {
                Long maxVersion;
                String deviceType;
                String configData;
                block30: {
                    String vdomName;
                    List complianceCmds;
                    block29: {
                        String resID = rid.toString();
                        configMemKey = resID + changedBy;
                        complianceCmds = null;
                        configData = null;
                        DiffUtil diffUtil = new DiffUtil();
                        deviceType = prop.getProperty("deviceType");
                        maxVersion = this.getMaxConfigVersion(rid, "running");
                        if (isVdom.booleanValue()) {
                            vdomName = (String)LaCacheManager.getInstance().getResourceName(rid);
                            prop.put("vdomName", vdomName);
                            complianceCmds = this.dcp.getVdomRunningComplianceCommands(deviceType);
                            configData = this.dCon.reteriveConfigurationData(prop, "auto", complianceCmds, rid, "running", Boolean.TRUE, cli, Boolean.TRUE);
                            this.dCon.setEnableModeStatus(cli, Boolean.TRUE);
                        } else {
                            complianceCmds = this.dcp.getRunningComplianceCommands(deviceType);
                            configData = this.dCon.reteriveConfigurationData(prop, "auto", complianceCmds, rid, "running", Boolean.TRUE, cli, Boolean.FALSE);
                            this.dCon.setEnableModeStatus(cli, Boolean.TRUE);
                        }
                        if (configData != null) break block29;
                        LOGGER.info("@@FWConfigMgmt:::: Inside closing the CLI Session (Logout Syslog)...before that updating the lastFetchTimeMap for the key:::" + dummyKey);
                        lastFetchTimeMap.put(dummyKey, new Long(System.currentTimeMillis()));
                        this.dCon.cleanUp(cli, rID);
                        if (gotException) {
                            this.updateStatus(dObj, -1, errMsg);
                            return;
                        }
                        this.updateStatus(dObj, 1, null);
                        return;
                    }
                    if (maxVersion.equals(new Long(0L))) {
                        Timestamp timestamp = new Timestamp(timeNow);
                        this.insertNewVersion(rid, maxVersion, changedBy, timestamp, "-", configData, "running", "-", new Integer(0));
                        if ("Cisco".equalsIgnoreCase(deviceType)) {
                            this.runningConfigMemMap.put(configMemKey, configData);
                        }
                    } else {
                        this.checkInNewVersionIfDiffExists(configData, rid, "running", changedBy, prop, Boolean.TRUE, maxVersion);
                    }
                    if (!"Cisco".equalsIgnoreCase(deviceType)) continue;
                    if (isVdom.booleanValue()) {
                        vdomName = (String)LaCacheManager.getInstance().getResourceName(rid);
                        prop.put("vdomName", vdomName);
                        complianceCmds = this.dcp.getVdomStartupComplianceCommands(deviceType);
                        configData = this.dCon.reteriveConfigurationData(prop, "auto", complianceCmds, rid, "startup", Boolean.TRUE, cli, Boolean.TRUE);
                    } else {
                        complianceCmds = this.dcp.getStartupComplianceCommands(deviceType);
                        configData = this.dCon.reteriveConfigurationData(prop, "auto", complianceCmds, rid, "startup", Boolean.TRUE, cli, Boolean.FALSE);
                    }
                    if (configData != null) break block30;
                    LOGGER.info("@@FWConfigMgmt:::: Inside closing the CLI Session (Logout Syslog)...before that updating the lastFetchTimeMap for the key:::" + dummyKey);
                    lastFetchTimeMap.put(dummyKey, new Long(System.currentTimeMillis()));
                    this.dCon.cleanUp(cli, rID);
                    if (gotException) {
                        this.updateStatus(dObj, -1, errMsg);
                        return;
                    }
                    this.updateStatus(dObj, 1, null);
                    return;
                }
                try {
                    String runningConfig = this.runningConfigMemMap.remove(configMemKey);
                    if (maxVersion.equals(new Long(0L))) {
                        byte[] runningContents;
                        Timestamp timestamp = new Timestamp(timeNow);
                        this.insertNewVersion(rid, maxVersion, changedBy, timestamp, "-", configData, "startup", "-", new Integer(0));
                        byte[] startupContents = configData.getBytes();
                        HashMap conflictContents = this.getDiff(startupContents, runningContents = runningConfig.getBytes(), deviceType);
                        boolean conflictExists = this.checkForDiff(conflictContents);
                        if (!conflictExists) continue;
                        LOGGER.fine("inside conflict exists...for the very first insert which has came through logout syslog...");
                        String conflictContentData = this.getDiffContentsOnly(conflictContents);
                        int realCont = conflictContentData.lastIndexOf("<->");
                        String diffCount = conflictContentData.substring(realCont + 3);
                        String dbDiffContents = conflictContentData.substring(0, realCont);
                        int tempCount = Integer.parseInt(diffCount);
                        Integer diff_count = new Integer(tempCount);
                        try {
                            DataObject conflictDO = DataAccess.constructDataObject();
                            Row conflictRow = new Row("StartupRunningConflict");
                            conflictRow.set("RID", (Object)rid);
                            conflictRow.set("STARTUP_VNO", (Object)new Long(1L));
                            conflictRow.set("RUNNING_VNO", (Object)new Long(1L));
                            conflictRow.set("CHANGED_BY", (Object)changedBy);
                            conflictRow.set("ANNOTATION", (Object)"-");
                            conflictRow.set("MODIFIED_TIME", (Object)timestamp);
                            conflictRow.set("DIFF_CONTENTS", (Object)dbDiffContents);
                            conflictRow.set("DIFF_COUNT", (Object)diff_count);
                            conflictDO.addRow(conflictRow);
                            DataAccess.add((DataObject)conflictDO);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.INFO, " Exception while putting an entry in conflict table as conflict table has an entry with resourceID--->" + rid);
                            e.printStackTrace();
                        }
                        continue;
                    }
                    this.checkInNewVersionIfDiffExists(configData, rid, "startup", changedBy, prop, Boolean.TRUE, maxVersion);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    errMsg = ex.getMessage();
                    errMsg = errMsg + " for rid::" + rid.toString();
                    gotException = true;
                }
            }
            LOGGER.info("@@FWConfigMgmt:::: Inside closing the CLI Session (Logout Syslog)...before that updating the lastFetchTimeMap for the key:::" + dummyKey);
            lastFetchTimeMap.put(dummyKey, new Long(System.currentTimeMillis()));
        }
        catch (Exception ee) {
            try {
                LOGGER.warning("@@FWConfigMgmt:::: Got exception in logoutSyslogConfigFetchHandling method for the resource::: " + resourceName);
                ee.printStackTrace();
                gotException = true;
                errMsg = ee.getMessage();
                LOGGER.info("@@FWConfigMgmt:::: Inside closing the CLI Session (Logout Syslog)...before that updating the lastFetchTimeMap for the key:::" + dummyKey);
                lastFetchTimeMap.put(dummyKey, new Long(System.currentTimeMillis()));
            }
            catch (Throwable throwable) {
                LOGGER.info("@@FWConfigMgmt:::: Inside closing the CLI Session (Logout Syslog)...before that updating the lastFetchTimeMap for the key:::" + dummyKey);
                lastFetchTimeMap.put(dummyKey, new Long(System.currentTimeMillis()));
                this.dCon.cleanUp(cli, rID);
                if (gotException) {
                    this.updateStatus(dObj, -1, errMsg);
                    throw throwable;
                }
                this.updateStatus(dObj, 1, null);
                throw throwable;
            }
            this.dCon.cleanUp(cli, rID);
            if (gotException) {
                this.updateStatus(dObj, -1, errMsg);
                return;
            }
            this.updateStatus(dObj, 1, null);
            return;
        }
        this.dCon.cleanUp(cli, rID);
        if (gotException) {
            this.updateStatus(dObj, -1, errMsg);
            return;
        }
        this.updateStatus(dObj, 1, null);
        return;
    }

    public static void updateConfigFetcherMap(String dummyKey) {
        LOGGER.info(" FWConfigMgmt::::: updating lastFetchTimeMap for the key::: " + dummyKey + " with value -> " + System.currentTimeMillis());
        lastFetchTimeMap.put(dummyKey, new Long(System.currentTimeMillis()));
    }

    private void updateStatus(DataObject doo, int status, String errorMsg) {
        try {
            Row fri = doo.getFirstRow("DeviceDetails");
            fri.set("ERRORSTRING", (Object)errorMsg);
            fri.set("STATUS", (Object)new Integer(status));
            fri.set("LAST_UPDATED_ON", (Object)new Timestamp(System.currentTimeMillis()));
            doo.updateRow(fri);
            DataAccess.update((DataObject)doo);
        }
        catch (DataAccessException dExp) {
            dExp.printStackTrace();
        }
    }

    public DataObject getDO(Long resourceId) throws Exception {
        SelectQueryImpl sql = new SelectQueryImpl(new Table("DeviceDetails"));
        sql.addSelectColumn(new Column("DeviceDetails", "*"));
        String[] jCols1 = new String[]{"DDID"};
        Join j1 = new Join("DeviceDetails", "DeviceCredentials", jCols1, jCols1, 1);
        sql.addJoin(j1);
        sql.addSelectColumn(new Column("DeviceCredentials", "*"));
        Join j2 = new Join("DeviceDetails", "DDNotifications", jCols1, jCols1, 1);
        sql.addJoin(j2);
        sql.addSelectColumn(new Column("DDNotifications", "*"));
        Join j3 = new Join("DeviceDetails", "Resources", new String[]{"RID"}, new String[]{"RESOURCEID"}, 1);
        sql.addJoin(j3);
        sql.addSelectColumn(new Column("Resources", "*"));
        sql.setCriteria(new Criteria(new Column("Resources", "RESOURCEID"), (Object)resourceId, 0));
        return DataAccess.get((SelectQuery)sql);
    }

    public DataObject getProfileDO(Long resourceId) throws Exception {
        SelectQueryImpl sql = new SelectQueryImpl(new Table("DeviceInfoProfiles"));
        sql.addSelectColumn(new Column("DeviceInfoProfiles", "*"));
        String[] joinColumn = new String[]{"DIPID"};
        Join dipTodipCred = new Join("DeviceInfoProfiles", "DIPCredentials", joinColumn, joinColumn, 2);
        sql.addJoin(dipTodipCred);
        sql.addSelectColumn(new Column("DIPCredentials", "*"));
        String[] j1Cols = new String[]{"DIPID"};
        Join j1 = new Join("DeviceInfoProfiles", "DIPToResourcesMapping", j1Cols, j1Cols, 2);
        sql.addJoin(j1);
        sql.addSelectColumn(new Column("DIPToResourcesMapping", "*"));
        String[] j2Cols = new String[]{"DDID"};
        Join j2 = new Join("DIPToResourcesMapping", "DeviceDetails", j2Cols, j2Cols, 2);
        sql.addJoin(j2);
        sql.addSelectColumn(new Column("DeviceDetails", "*"));
        Join j3 = new Join("DIPToResourcesMapping", "Resources", new String[]{"RID"}, new String[]{"RESOURCEID"}, 2);
        sql.addJoin(j3);
        sql.addSelectColumn(new Column("Resources", "*"));
        Join j4 = new Join("DeviceDetails", "DeviceCredentials", j2Cols, j2Cols, 1);
        sql.addJoin(j4);
        sql.addSelectColumn(new Column("DeviceCredentials", "*"));
        Join j5 = new Join("DeviceDetails", "DDNotifications", j2Cols, j2Cols, 1);
        sql.addJoin(j5);
        sql.addSelectColumn(new Column("DDNotifications", "*"));
        sql.setCriteria(new Criteria(new Column("Resources", "RESOURCEID"), (Object)resourceId, 0));
        return DataAccess.get((SelectQuery)sql);
    }

    public Long getMaxConfigVersion(Long rID, String configType) {
        try {
            SelectQueryImpl sql = new SelectQueryImpl(new Table("LatestConfig"));
            sql.addSelectColumn(new Column("LatestConfig", "*"));
            Criteria crit = new Criteria(new Column("LatestConfig", "RID"), (Object)rID, 0);
            crit = crit.and(new Criteria(new Column("LatestConfig", "CONFIG_TYPE"), (Object)configType, 0));
            sql.setCriteria(crit);
            DataObject rDobj = DataAccess.get((SelectQuery)sql);
            if (rDobj.isEmpty()) {
                return new Long(0L);
            }
            long versionNo = (Long)rDobj.getFirstValue("LatestConfig", "VERSION_NO");
            Long maxVersionNo = new Long(versionNo);
            return maxVersionNo;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new Long(0L);
        }
    }

    public String isProfBased(Long rID) {
        try {
            SelectQueryImpl sql = new SelectQueryImpl(new Table("DeviceDetails"));
            sql.addSelectColumn(new Column("DeviceDetails", "*"));
            Criteria crit = new Criteria(new Column("DeviceDetails", "RID"), (Object)rID, 0);
            sql.setCriteria(crit);
            DataObject dObj = DataAccess.get((SelectQuery)sql);
            String isProfileBased = null;
            if (!dObj.isEmpty()) {
                isProfileBased = ((Boolean)dObj.getFirstValue("DeviceDetails", "ISPROFILEBASED")).toString();
            }
            return isProfileBased;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public DataObject getLatestConfigFromDB(Long maxVersion, String configType, Long rID) {
        try {
            SelectQueryImpl sql = new SelectQueryImpl(new Table("ConfigVersions"));
            sql.addSelectColumn(new Column("ConfigVersions", "*"));
            Criteria crit = new Criteria(new Column("ConfigVersions", "VERSION_NO"), (Object)maxVersion, 0);
            crit = crit.and(new Criteria(new Column("ConfigVersions", "CONFIG_TYPE"), (Object)configType, 0));
            crit = crit.and(new Criteria(new Column("ConfigVersions", "RID"), (Object)rID, 0));
            sql.setCriteria(crit);
            return DataAccess.get((SelectQuery)sql);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public HashMap getDiff(byte[] fileContents1, byte[] fileContents2, String deviceType) {
        DiffUtil diffUtil = new DiffUtil();
        diffUtil.doDiff(fileContents1, fileContents2);
        HashMap diffDetails = new HashMap();
        Vector firstDiff = diffUtil.getFirstDiff();
        diffDetails.put("firstDiff", firstDiff);
        Vector secondDiff = diffUtil.getSecondDiff();
        diffDetails.put("secondDiff", secondDiff);
        Vector firstFile = diffUtil.getFirstFile();
        diffDetails.put("firstFile", firstFile);
        Vector secondFile = diffUtil.getSecondFile();
        diffDetails.put("secondFile", secondFile);
        diffDetails.put("firstFileBytes", fileContents1);
        diffDetails.put("secondFileBytes", fileContents2);
        diffDetails = this.getDiffWithDiscardedComments(diffDetails, deviceType);
        return diffDetails;
    }

    private HashMap getDiffWithDiscardedComments(HashMap diffDetails, String deviceType) {
        try {
            if (deviceType != null) {
                DataObject excludeCriteriaDO = this.getExcludeCriteriaDO(deviceType);
                if (deviceType.contains("Cisco")) {
                    this.updateCertificateDiff(diffDetails, deviceType, null, null);
                }
                if (deviceType.contains("FortiGate")) {
                    this.updateCertificateDiff(diffDetails, deviceType, "BEGIN CERTIFICATE", "END CERTIFICATE");
                    this.updateCertificateDiff(diffDetails, deviceType, "set private-key", "set certificate");
                }
                Vector firstFile = (Vector)diffDetails.get("firstFile");
                Vector firstDiff = (Vector)diffDetails.get("firstDiff");
                Vector secondFile = (Vector)diffDetails.get("secondFile");
                Vector secondDiff = (Vector)diffDetails.get("secondDiff");
                Object criteriaRegex = null;
                String firstContent = null;
                String secondContent = null;
                ArrayList<Integer> modifyIndexList = new ArrayList<Integer>();
                HashMap map = new HashMap();
                Object criteriaRow = null;
                String diffValue = null;
                for (int i = 0; i < firstDiff.size(); ++i) {
                    diffValue = (String)firstDiff.get(i);
                    if (diffValue.equals("0")) continue;
                    firstContent = (String)firstFile.get(i);
                    secondContent = (String)secondFile.get(i);
                    boolean isFirstContentEmpty = firstContent == null || firstContent.trim().length() == 0;
                    boolean isSecondContentEmpty = secondContent == null || secondContent.trim().length() == 0;
                    boolean isFirstContainsCriteria = this.containsExclusionCriteria(firstContent, excludeCriteriaDO);
                    boolean isSecondContainsCriteria = this.containsExclusionCriteria(secondContent, excludeCriteriaDO);
                    if (!(isFirstContainsCriteria && isSecondContainsCriteria || isFirstContainsCriteria && isSecondContentEmpty || isFirstContentEmpty && isSecondContainsCriteria) && (!isFirstContentEmpty || !isSecondContentEmpty)) continue;
                    modifyIndexList.add(new Integer(i));
                }
                int index = -1;
                Iterator itr = modifyIndexList.iterator();
                while (itr.hasNext()) {
                    index = (Integer)itr.next();
                    firstDiff.remove(index);
                    secondDiff.remove(index);
                    firstDiff.add(index, "0");
                    secondDiff.add(index, "0");
                }
                diffDetails.put("firstDiff", firstDiff);
                diffDetails.put("secondDiff", secondDiff);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while discard the comments.", e);
        }
        return diffDetails;
    }

    private DataObject getExcludeCriteriaDO(String deviceType) throws Exception {
        SelectQueryImpl sql = new SelectQueryImpl(new Table("ExcludeRuleCriteria"));
        String[] critIDCol = new String[]{"CRIT_ID"};
        Join exdRuleCrit2DevType = new Join("ExcludeRuleCriteria", "DevTypeToExdCritMap", critIDCol, critIDCol, 2);
        Join devTypeToExdRule = new Join("DevTypeToExdCritMap", "ExcludeRule", critIDCol, critIDCol, 2);
        sql.addJoin(exdRuleCrit2DevType);
        sql.addJoin(devTypeToExdRule);
        sql.addSelectColumn(new Column("ExcludeRuleCriteria", "*"));
        sql.addSelectColumn(new Column("DevTypeToExdCritMap", "*"));
        sql.addSelectColumn(new Column("ExcludeRule", "*"));
        Criteria crt = new Criteria(new Column("DevTypeToExdCritMap", "VENDOR_TYPE"), (Object)deviceType, 0);
        crt = crt.and(new Criteria(new Column("ExcludeRule", "ENABLE"), (Object)1, 0));
        sql.setCriteria(crt);
        sql.addSortColumn(new SortColumn("ExcludeRuleCriteria", "CRIT_ID", true));
        sql.addSortColumn(new SortColumn("ExcludeRuleCriteria", "SEQUENCE", true));
        return DataAccess.get((SelectQuery)sql);
    }

    private boolean containsExclusionCriteria(String content, DataObject excludeCriteriaDO) throws Exception {
        boolean isEmpty;
        boolean containsCriteria = false;
        boolean bl = isEmpty = content == null || content.trim().length() == 0;
        if (isEmpty) {
            return false;
        }
        content = content.trim();
        Iterator ruleItr = excludeCriteriaDO.getRows("ExcludeRule");
        Row ruleRow = null;
        while (ruleItr.hasNext()) {
            ruleRow = (Row)ruleItr.next();
            Iterator ruleCriteriaItr = excludeCriteriaDO.getRows("ExcludeRuleCriteria", ruleRow);
            containsCriteria = this.validateExcludeCriteria(ruleCriteriaItr, content);
            if (!containsCriteria) continue;
            return containsCriteria;
        }
        return containsCriteria;
    }

    private boolean validateExcludeCriteria(Iterator ruleCriteriaItr, String content) throws Exception {
        boolean match = false;
        Row ruleCritRow = null;
        String op = null;
        int condition = 10;
        String pattern = null;
        ArrayList<String> operatorList = new ArrayList<String>();
        ArrayList<Boolean> conResultList = new ArrayList<Boolean>();
        while (ruleCriteriaItr.hasNext()) {
            ruleCritRow = (Row)ruleCriteriaItr.next();
            op = (String)ruleCritRow.get("OPERATOR");
            condition = (Integer)ruleCritRow.get("CRIT_CONDITION");
            pattern = (String)ruleCritRow.get("CRITERIA");
            if (condition == 20) {
                pattern = "^\\s*" + pattern.trim();
            }
            Pattern p = Pattern.compile(pattern.trim());
            Matcher m = p.matcher(content);
            match = m.find();
            LOGGER.fine("pattern : " + pattern.trim() + " content : " + content + " match  result : " + match);
            operatorList.add(op);
            conResultList.add(match);
        }
        boolean containsCriteria = conResultList.size() > 1 ? this.evaluateCriteriaOp(operatorList, conResultList) : match;
        return containsCriteria;
    }

    private boolean evaluateCriteriaOp(ArrayList<String> operatorList, ArrayList<Boolean> conResultList) throws Exception {
        LOGGER.fine("Inside evaluateCriteriaOp....Operator List : " + operatorList + " Result List : " + conResultList);
        int conCount = conResultList.size();
        boolean resultSoFar = false;
        for (int i = 0; i < conCount; ++i) {
            String currOp = operatorList.get(i);
            boolean currResult = conResultList.get(i);
            if (currOp.equals("and")) {
                resultSoFar = resultSoFar && currResult;
                continue;
            }
            if (currOp.equals("or")) {
                resultSoFar = resultSoFar || currResult;
                continue;
            }
            if (!currOp.equals("NA")) continue;
            resultSoFar = currResult;
        }
        return resultSoFar;
    }

    private void updateCertificateDiff(HashMap diffDetails, String deviceType, String matchString, String endString) throws Exception {
        if (deviceType.contains("Cisco")) {
            matchString = "pki certificate ";
            endString = "quit";
        }
        String singleLineRegEx = "\\s*certificate .*cer";
        String firstFileString = new String((byte[])diffDetails.get("firstFileBytes"));
        String secondFileString = new String((byte[])diffDetails.get("secondFileBytes"));
        if (firstFileString.contains(matchString) && secondFileString.contains(matchString)) {
            LOGGER.log(Level.FINE, "Both the files contains the match string '" + matchString + "'.");
            Pattern patternSLRX = Pattern.compile(singleLineRegEx, 40);
            Vector firstFile = (Vector)diffDetails.get("firstFile");
            Vector secondFile = (Vector)diffDetails.get("secondFile");
            boolean isFirstContainsSLRX = patternSLRX.matcher(firstFileString).find();
            boolean isSecondContainsSLRX = patternSLRX.matcher(secondFileString).find();
            boolean isFirstContainsMLRX = this.containsMLRX(firstFile, matchString, endString, deviceType);
            boolean isSecondContainsMLRX = this.containsMLRX(secondFile, matchString, endString, deviceType);
            if (isFirstContainsSLRX && isSecondContainsMLRX || isFirstContainsMLRX && isSecondContainsSLRX) {
                LOGGER.log(Level.FINE, "Entered into the Certificate elemination block.");
                Vector firstDiff = (Vector)diffDetails.get("firstDiff");
                Vector secondDiff = (Vector)diffDetails.get("secondDiff");
                int fromIndex = 0;
                HashMap<String, Object> infoMap = new HashMap<String, Object>();
                infoMap.put("IS_FIRST_CONTAINS_MLRX", isFirstContainsMLRX);
                infoMap.put("FROM_INDEX", new Integer(0));
                infoMap.put("MATCH_STRING", matchString);
                infoMap.put("END_STRING", endString);
                while (fromIndex < secondDiff.size()) {
                    HashMap certificateInfo = this.getCertificatePositionDetails(diffDetails, infoMap, deviceType);
                    LOGGER.log(Level.FINEST, "Certificate Info is " + certificateInfo + " for index=" + fromIndex);
                    int multiLineStartIndex = (Integer)certificateInfo.get("MULTILINE_START_INDEX");
                    int multiLineEndIndex = (Integer)certificateInfo.get("MULTILINE_END_INDEX");
                    boolean isMultiLineStarted = (Boolean)certificateInfo.get("IS_MULTILINE_STARTED");
                    int searchEndIndex = (Integer)certificateInfo.get("SEACH_END_INDEX");
                    if (isMultiLineStarted && multiLineEndIndex >= multiLineStartIndex) {
                        for (int index = multiLineStartIndex; index <= searchEndIndex; ++index) {
                            firstDiff.remove(index);
                            secondDiff.remove(index);
                            firstDiff.add(index, "0");
                            secondDiff.add(index, "0");
                        }
                        diffDetails.put("firstDiff", firstDiff);
                        diffDetails.put("secondDiff", secondDiff);
                        LOGGER.log(Level.FINEST, "Multiline sentence diff successfully updated for the index=" + fromIndex);
                    }
                    fromIndex = searchEndIndex;
                    infoMap.put("FROM_INDEX", new Integer(fromIndex));
                }
            }
        }
    }

    private HashMap getCertificatePositionDetails(HashMap diffDetails, HashMap infoMap, String deviceType) throws Exception {
        boolean isFirstContainsMLRX = (Boolean)infoMap.get("IS_FIRST_CONTAINS_MLRX");
        int fromIndex = (Integer)infoMap.get("FROM_INDEX");
        String matchString = (String)infoMap.get("MATCH_STRING");
        String endString = (String)infoMap.get("END_STRING");
        String firstFileContent = null;
        String secondFileContent = null;
        int multiLineStartIndex = -1;
        int multiLineEndIndex = -1;
        int searchEndIndex = -1;
        boolean isMultiLineStarted = false;
        Vector firstFile = (Vector)diffDetails.get("firstFile");
        Vector secondFile = (Vector)diffDetails.get("secondFile");
        if (fromIndex == -1) {
            HashMap<String, Constable> certificateInfo = new HashMap<String, Constable>();
            certificateInfo.put("MULTILINE_START_INDEX", new Integer(multiLineStartIndex));
            certificateInfo.put("MULTILINE_END_INDEX", new Integer(multiLineEndIndex));
            certificateInfo.put("IS_MULTILINE_STARTED", Boolean.valueOf(isMultiLineStarted));
            certificateInfo.put("SEACH_END_INDEX", new Integer(secondFile.size()));
            return certificateInfo;
        }
        for (int i = fromIndex; i < secondFile.size(); ++i) {
            firstFileContent = (String)firstFile.get(i);
            secondFileContent = (String)secondFile.get(i);
            firstFileContent = firstFileContent == null || firstFileContent.trim().length() == 0 ? "" : firstFileContent;
            String string = secondFileContent = secondFileContent == null || secondFileContent.trim().length() == 0 ? "" : secondFileContent;
            if (!isMultiLineStarted) {
                isMultiLineStarted = firstFileContent.contains(matchString) && secondFileContent.contains(matchString) || firstFileContent.equals("") && secondFileContent.contains(matchString) || firstFileContent.contains(matchString) && secondFileContent.equals("");
                int n = multiLineStartIndex = isMultiLineStarted ? i : -1;
            }
            if (!isMultiLineStarted) continue;
            String multiLineMLRXContent = isFirstContainsMLRX ? firstFileContent : secondFileContent;
            try {
                String nextLineMLRXContent;
                String string2 = nextLineMLRXContent = isFirstContainsMLRX ? (String)firstFile.get(i + 1) : (String)secondFile.get(i + 1);
                if (!multiLineMLRXContent.contains(endString) || nextLineMLRXContent.contains("certificate")) continue;
                searchEndIndex = multiLineEndIndex = i;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        HashMap<String, Constable> certificateInfo = new HashMap<String, Constable>();
        certificateInfo.put("MULTILINE_START_INDEX", new Integer(multiLineStartIndex));
        certificateInfo.put("MULTILINE_END_INDEX", new Integer(multiLineEndIndex));
        certificateInfo.put("IS_MULTILINE_STARTED", Boolean.valueOf(isMultiLineStarted));
        certificateInfo.put("SEACH_END_INDEX", new Integer(searchEndIndex));
        return certificateInfo;
    }

    private boolean containsMLRX(Vector fileContent, String startString, String endString, String deviceType) throws Exception {
        String content = null;
        boolean isStartStrIdentified = false;
        boolean isEndStrIdentified = false;
        for (int i = 0; i < fileContent.size(); ++i) {
            content = (String)fileContent.get(i);
            String string = content = content == null || content.trim().length() == 0 ? "" : content;
            if (!isStartStrIdentified && content.contains(startString)) {
                isStartStrIdentified = true;
            }
            if (isStartStrIdentified && !isEndStrIdentified) {
                String certContent;
                if (deviceType.contains("Cisco")) {
                    if (i + 1 < fileContent.size()) {
                        certContent = fileContent.get(i + 1).toString();
                        if (content.trim().equals(endString) && !certContent.contains("certificate")) {
                            isEndStrIdentified = true;
                        }
                    }
                } else if (i + 1 < fileContent.size()) {
                    certContent = fileContent.get(i + 1).toString();
                    if (content.trim().contains(endString)) {
                        isEndStrIdentified = true;
                    }
                }
            }
            if (isStartStrIdentified && isEndStrIdentified) break;
        }
        return isStartStrIdentified && isEndStrIdentified;
    }

    public boolean checkForDiff(HashMap diffMap) {
        boolean isEqual = true;
        Vector firstDiff = (Vector)diffMap.get("firstDiff");
        Vector secondDiff = (Vector)diffMap.get("secondDiff");
        String diff1 = null;
        String diff2 = null;
        for (int i = 0; i < firstDiff.size(); ++i) {
            diff1 = (String)firstDiff.get(i);
            if (diff1.equals(diff2 = (String)secondDiff.get(i)) && diff1.equals(new String("0"))) continue;
            isEqual = false;
            break;
        }
        return !isEqual;
    }

    public void insertNewVersion(Long rID, Long maxVersion, String changedBy, Timestamp timestamp, String annotation, String configData, String configType, String dbDiffContents, Integer diffCount) {
        try {
            long newVersion = maxVersion;
            maxVersion = new Long(++newVersion);
            String encryptedConfigFile = this.encryptionObj.encryptLog(configData);
            ByteArrayInputStream is = new ByteArrayInputStream(encryptedConfigFile.getBytes("UTF-8"));
            changedBy = changedBy.equalsIgnoreCase("Unknown") || "".equals(changedBy) ? "N/A" : changedBy;
            LOGGER.log(Level.FINER, "@FWConfigMgmt:::inserting new row in ConfigVersions table....");
            DataObject dObj1 = DataAccess.constructDataObject();
            Row configVersionRow = new Row("ConfigVersions");
            configVersionRow.set("VERSION_NO", (Object)maxVersion);
            configVersionRow.set("RID", (Object)rID);
            configVersionRow.set("FILE_CONTENTS", (Object)is);
            configVersionRow.set("CHANGED_BY", (Object)changedBy);
            configVersionRow.set("ANNOTATION", (Object)"-");
            configVersionRow.set("CONFIG_TYPE", (Object)configType);
            configVersionRow.set("MODIFIED_TIME", (Object)timestamp);
            configVersionRow.set("DIFF_CONTENTS", (Object)dbDiffContents);
            configVersionRow.set("DIFF_COUNT", (Object)diffCount);
            dObj1.addRow(configVersionRow);
            DataAccess.add((DataObject)dObj1);
            if (maxVersion.equals(new Long(1L))) {
                Row latestConfRow = new Row("LatestConfig");
                latestConfRow.set("RID", (Object)rID);
                latestConfRow.set("VERSION_NO", (Object)maxVersion);
                latestConfRow.set("CONFIG_TYPE", (Object)configType);
                DataObject dObj2 = DataAccess.constructDataObject();
                dObj2.addRow(latestConfRow);
                DataAccess.add((DataObject)dObj2);
            } else {
                SelectQueryImpl sql = new SelectQueryImpl(new Table("LatestConfig"));
                sql.addSelectColumn(new Column("LatestConfig", "*"));
                Criteria crit = new Criteria(new Column("LatestConfig", "RID"), (Object)rID, 0);
                crit = crit.and(new Criteria(new Column("LatestConfig", "CONFIG_TYPE"), (Object)configType, 0));
                sql.setCriteria(crit);
                DataObject dObj2 = DataAccess.get((SelectQuery)sql);
                Row row = dObj2.getFirstRow("LatestConfig");
                row.set("VERSION_NO", (Object)maxVersion);
                dObj2.updateRow(row);
                DataAccess.update((DataObject)dObj2);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Hashtable checkInNewVersionIfDiffExists(String configData, Long rID, String configType, String changedBy, Properties prop, Boolean isSyslogBased, Long maxVersion) {
        return this.checkInNewVersionIfDiffExists(configData, rID, configType, changedBy, prop, isSyslogBased, maxVersion, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable checkInNewVersionIfDiffExists(String configData, Long rID, String configType, String changedBy, Properties prop, Boolean isSyslogBased, Long maxVersion, String threadName) {
        Hashtable<String, Object> reqDetails = new Hashtable<String, Object>();
        try {
            maxVersion = this.getMaxConfigVersion(rID, configType);
            DataObject confDo = this.getLatestConfigFromDB(maxVersion, configType, rID);
            LOGGER.fine("@FWConfigMgmt...*** After getting dataobject for maxversion ****" + confDo);
            InputStream dbConfigDataStream = (InputStream)confDo.getFirstValue("ConfigVersions", "FILE_CONTENTS");
            String dbConfigData = new String();
            if (dbConfigDataStream != null) {
                StringWriter writer = new StringWriter();
                char[] buffer = new char[1024];
                try {
                    int n;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(dbConfigDataStream, "UTF-8"));
                    while ((n = reader.read(buffer)) != -1) {
                        ((Writer)writer).write(buffer, 0, n);
                    }
                }
                finally {
                    dbConfigDataStream.close();
                }
                dbConfigData = ((Object)writer).toString();
            }
            dbConfigData = this.decryptionObj.decryptLog(dbConfigData);
            byte[] fileContents = configData.getBytes();
            byte[] existingContents = dbConfigData.getBytes();
            String deviceType = prop.getProperty("deviceType");
            HashMap diffContents = this.getDiff(existingContents, fileContents, deviceType);
            boolean diffExists = this.checkForDiff(diffContents);
            LOGGER.fine("@FWConfigMgmt...diffExists:::" + diffExists);
            String annotation = "-";
            if (diffExists) {
                String diffContentData = this.getDiffContentsOnly(diffContents);
                int realCont = diffContentData.lastIndexOf("<->");
                String diffCount = diffContentData.substring(realCont + 3);
                String dbDiffContents = diffContentData.substring(0, realCont);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String date = format.format(new Date());
                long time = format.parse(date).getTime();
                Timestamp timestamp = new Timestamp(time);
                boolean isFromSyslog = isSyslogBased;
                changedBy = isSyslogBased == false && "cisco".equalsIgnoreCase(deviceType) ? this.getChangedByFromFile(configData, configType) : changedBy;
                this.insertNewVersion(rID, maxVersion, changedBy, timestamp, annotation, configData, configType, dbDiffContents, new Integer(diffCount));
                reqDetails.put("CREATED_ON", timestamp);
                long newVersion = maxVersion + 1L;
                maxVersion = new Long(newVersion);
                reqDetails.put("MAXVERSION", maxVersion);
                reqDetails.put("diffContents", diffContents);
                if ("Cisco".equals(deviceType)) {
                    this.updateConflictTable(rID, configType, fileContents, maxVersion, changedBy, timestamp, annotation);
                }
                if (threadName != null) {
                    FAServerUtil.addToPolicyParsingThreadWaitList(threadName);
                }
                this.initiatePolicyProcessing(rID, deviceType, configData, configType, maxVersion, threadName);
                this.triggerAlertTask(prop, diffContents, configType, rID, changedBy);
                return reqDetails;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private String getChangedByFromFile(String configData, String configType) {
        Pattern pattern = "running".equals(configType) ? Pattern.compile(this.runningCnfgPattern) : Pattern.compile(this.startupCnfgPattern);
        String changedBy = "N/A";
        BufferedReader br = new BufferedReader(new StringReader(configData));
        String str = null;
        try {
            for (int i = 0; (str = br.readLine()) != null && i <= 40; ++i) {
                Matcher matcher = pattern.matcher(str);
                if (!matcher.find()) continue;
                changedBy = matcher.group(1);
                break;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return changedBy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConflictTable(Long rID, String configType, byte[] fileContents, Long maxVersion, String changedBy, Timestamp timestamp, String annotation) {
        LOGGER.fine("FWConfigMgmt:::updating conflict table ****");
        Long maxDBVersion = new Long(1L);
        Long startupVersion = new Long(1L);
        Long runningVersion = new Long(1L);
        DataObject doo = null;
        Object existingConfigData = null;
        byte[] existingContents = null;
        try {
            int n;
            BufferedReader reader;
            char[] buffer;
            StringWriter writer;
            String dbConfigData;
            InputStream dbConfigDataStream;
            if ("running".equals(configType)) {
                runningVersion = maxVersion;
                startupVersion = this.getMaxConfigVersion(rID, "startup");
                doo = this.getLatestConfigFromDB(startupVersion, "startup", rID);
                dbConfigDataStream = (InputStream)doo.getFirstValue("ConfigVersions", "FILE_CONTENTS");
                dbConfigData = new String();
                if (dbConfigDataStream != null) {
                    writer = new StringWriter();
                    buffer = new char[1024];
                    try {
                        reader = new BufferedReader(new InputStreamReader(dbConfigDataStream, "UTF-8"));
                        while ((n = reader.read(buffer)) != -1) {
                            ((Writer)writer).write(buffer, 0, n);
                        }
                    }
                    finally {
                        dbConfigDataStream.close();
                    }
                    dbConfigData = ((Object)writer).toString();
                }
                dbConfigData = this.decryptionObj.decryptLog(dbConfigData);
                existingContents = dbConfigData.getBytes();
            } else {
                startupVersion = maxVersion;
                runningVersion = this.getMaxConfigVersion(rID, "running");
                doo = this.getLatestConfigFromDB(runningVersion, "running", rID);
                dbConfigDataStream = (InputStream)doo.getFirstValue("ConfigVersions", "FILE_CONTENTS");
                dbConfigData = new String();
                if (dbConfigDataStream != null) {
                    writer = new StringWriter();
                    buffer = new char[1024];
                    try {
                        reader = new BufferedReader(new InputStreamReader(dbConfigDataStream, "UTF-8"));
                        while ((n = reader.read(buffer)) != -1) {
                            ((Writer)writer).write(buffer, 0, n);
                        }
                    }
                    finally {
                        dbConfigDataStream.close();
                    }
                    dbConfigData = ((Object)writer).toString();
                }
                dbConfigData = this.decryptionObj.decryptLog(dbConfigData);
                existingContents = dbConfigData.getBytes();
            }
            HashMap conflictContents = this.getDiff(existingContents, fileContents, "Cisco");
            boolean conflictExists = this.checkForDiff(conflictContents);
            LOGGER.fine("conflict exists::::" + conflictExists);
            if (conflictExists) {
                String conflictContentData = this.getDiffContentsOnly(conflictContents);
                int realCont = conflictContentData.lastIndexOf("<->");
                String diff_Count = conflictContentData.substring(realCont + 3);
                String diff_Contents = conflictContentData.substring(0, realCont);
                int tempCount = Integer.parseInt(diff_Count);
                Integer diffCount = new Integer(tempCount);
                SelectQueryImpl select = new SelectQueryImpl(new Table("StartupRunningConflict"));
                select.addSelectColumn(new Column("StartupRunningConflict", "*"));
                Criteria crt = new Criteria(new Column("StartupRunningConflict", "RID"), (Object)rID, 0);
                select.setCriteria(crt);
                doo = DataAccess.get((SelectQuery)select);
                if (!doo.isEmpty()) {
                    Row row = doo.getFirstRow("StartupRunningConflict");
                    row.set("RUNNING_VNO", (Object)runningVersion);
                    row.set("STARTUP_VNO", (Object)startupVersion);
                    row.set("CHANGED_BY", (Object)changedBy);
                    row.set("ANNOTATION", (Object)annotation);
                    row.set("MODIFIED_TIME", (Object)timestamp);
                    row.set("DIFF_COUNT", (Object)diffCount);
                    row.set("DIFF_CONTENTS", (Object)diff_Contents);
                    doo.updateRow(row);
                    DataAccess.update((DataObject)doo);
                } else {
                    doo = DataAccess.constructDataObject();
                    Row conflictRow = new Row("StartupRunningConflict");
                    conflictRow.set("RID", (Object)rID);
                    conflictRow.set("STARTUP_VNO", (Object)startupVersion);
                    conflictRow.set("RUNNING_VNO", (Object)runningVersion);
                    conflictRow.set("CHANGED_BY", (Object)changedBy);
                    conflictRow.set("ANNOTATION", (Object)annotation);
                    conflictRow.set("MODIFIED_TIME", (Object)timestamp);
                    conflictRow.set("DIFF_CONTENTS", (Object)diff_Contents);
                    conflictRow.set("DIFF_COUNT", (Object)diff_Count);
                    doo.addRow(conflictRow);
                    DataAccess.add((DataObject)doo);
                }
            } else {
                LOGGER.info("FWConfigMgmt ::::inside no conflict and hence deleting entry in table.....");
                DataAccess.delete((Criteria)new Criteria(new Column("StartupRunningConflict", "RID"), (Object)rID, 0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getDiffContentsOnly(HashMap diffContents) {
        int changeCount = 0;
        String addDetails = "";
        String delDetails = "";
        String modDetails = "";
        boolean added = false;
        boolean modified = false;
        boolean deleted = false;
        String consolidateChanges = "";
        StringBuffer addBuffer = new StringBuffer();
        StringBuffer delBuffer = new StringBuffer();
        StringBuffer modBuffer = new StringBuffer();
        addBuffer.append("\n" + this.bundle.getString("ChangeMgmtMail.AddedContentsString") + "\n");
        modBuffer.append("\n" + this.bundle.getString("ChangeMgmtMail.ModifiedContentsString") + "\n");
        delBuffer.append("\n" + this.bundle.getString("ChangeMgmtMail.DeletedContentsString") + "\n");
        Vector firstDiff = (Vector)diffContents.get("firstDiff");
        Vector secondDiff = (Vector)diffContents.get("secondDiff");
        Vector firstFile = (Vector)diffContents.get("firstFile");
        Vector secondFile = (Vector)diffContents.get("secondFile");
        String secondFileContent = "";
        for (int i = 0; i < secondDiff.size(); ++i) {
            int secondDiffCode;
            int firstDiffCode = Integer.parseInt((String)firstDiff.get(i));
            if (firstDiffCode == (secondDiffCode = Integer.parseInt((String)secondDiff.get(i))) && secondDiffCode == 0) continue;
            secondFileContent = (String)secondFile.get(i);
            secondFileContent = secondFileContent.replaceAll("&lt;", "<");
            secondFileContent = secondFileContent.replaceAll("&gt;", ">");
            if (secondDiffCode == 5 && firstDiffCode != 5) {
                secondFileContent = (String)firstFile.get(i);
                secondFileContent = secondFileContent.replaceAll("&lt;", "<");
                secondFileContent = secondFileContent.replaceAll("&gt;", ">");
                delBuffer.append(secondFileContent + "\n");
                deleted = true;
                ++changeCount;
            }
            if (secondDiffCode == 1) {
                addBuffer.append(secondFileContent + "\n");
                added = true;
                ++changeCount;
            }
            if (firstDiffCode != 3 || secondDiffCode != 3) continue;
            modBuffer.append(secondFileContent + "\n");
            modified = true;
            ++changeCount;
        }
        addBuffer.append("\n");
        delBuffer.append("\n");
        modBuffer.append("\n");
        addDetails = addBuffer.toString();
        delDetails = delBuffer.toString();
        modDetails = modBuffer.toString();
        if (added) {
            consolidateChanges = addDetails;
        }
        if (modified) {
            consolidateChanges = consolidateChanges + modDetails;
        }
        if (deleted) {
            consolidateChanges = consolidateChanges + delDetails;
        }
        consolidateChanges = consolidateChanges + "<->" + changeCount;
        return consolidateChanges;
    }

    public static HashMap getContextSpecificDiff(HashMap diffData, String personality) {
        Vector firstDiff = (Vector)diffData.get("firstDiff");
        Vector secondDiff = (Vector)diffData.get("secondDiff");
        Vector firstFile = (Vector)diffData.get("firstFile");
        Vector secondFile = (Vector)diffData.get("secondFile");
        Vector<String> toShow = new Vector<String>();
        for (int i = 0; i < firstDiff.size(); ++i) {
            int secondDiffCode;
            int firstDiffCode = Integer.parseInt((String)firstDiff.get(i));
            if (firstDiffCode != (secondDiffCode = Integer.parseInt((String)secondDiff.get(i))) || secondDiffCode != 0) {
                String secondFileContent = (String)secondFile.get(i);
                if (secondDiffCode == 5 && firstDiffCode != 5) {
                    secondFileContent = (String)firstFile.get(i);
                }
                if (secondFileContent.trim().length() > 0 && secondFileContent.charAt(0) == ' ' && !secondFileContent.trim().startsWith("edit")) {
                    int[] modules = FwConfigMgmt.getStartAndEndModules(secondFile, i, firstDiff);
                    int startOfModule = modules[0];
                    int endOfModule = modules[1];
                    int isBlock = modules[2];
                    if (startOfModule != endOfModule) {
                        for (int k = startOfModule; k <= endOfModule; ++k) {
                            if (isBlock == 1 && toShow.size() > k) {
                                toShow.set(k, "yes");
                                continue;
                            }
                            toShow.add("yes");
                        }
                    }
                    if (endOfModule <= i) continue;
                    i = endOfModule;
                    continue;
                }
                toShow.add("yes");
                continue;
            }
            if (toShow.size() > i) {
                toShow.set(i, "no");
                continue;
            }
            toShow.add("no");
        }
        diffData.put("showStatus", toShow);
        return diffData;
    }

    public void triggerAlertTask(Properties prop, HashMap diffContents, String configType, Long resourceID, String changedBy) {
        LOGGER.fine("FWConfigMgmt::::inside triggerAlerttask method and properties are-->" + prop);
        Long ddId = (Long)prop.get("DDID");
        String deviceName = FACacheManager.getInstance().getDisplayName(resourceID);
        String alertType = prop.getProperty("alertType");
        String notiEnabled = prop.getProperty("enableNotify");
        if (alertType != null) {
            if (alertType.indexOf("sms") > -1 && this.getSmsSettings()) {
                String toNo = prop.getProperty("toNo");
                String smsMsg = this.composeSmsMsg(prop, diffContents, deviceName, changedBy);
                String test = LaUtil.getInstance().sendSms(this.smsPort, toNo, smsMsg);
            }
            if ((alertType.equals("bothMails") || alertType.equals("notiMail")) && "true".equals(notiEnabled) && this.getMailSettings()) {
                this.sendMail(prop, diffContents, configType, ddId, deviceName, changedBy);
            }
        }
    }

    private void sendMail(Properties prop, HashMap diffContents, String configType, Long ddId, String deviceName, String changedBy) {
        String errMsg = null;
        try {
            String to = prop.getProperty("toMailId");
            if (to != null) {
                String[] mailIds = to.split("##");
                to = mailIds[0].toString();
            }
            LOGGER.fine("finally mailid to which sending the notification is:::" + to);
            Timestamp timestamp = new Timestamp(new Date().getTime());
            String modifiedTime = timestamp.toString();
            String sub = deviceName + " " + this.bundle.getString("CMMail.Subject") + " " + modifiedTime;
            SmtpMailer mailer = new SmtpMailer(this.mailHost, this.from, to, sub, null, this.user, this.password, this.mailPort, this.tls);
            String contextBasedNotification = FirewallConstants.getNotificationType();
            boolean isContextBased = Boolean.valueOf(contextBasedNotification);
            HashMap map = FwConfigMgmt.prepareMessageBody(prop, diffContents, ddId, deviceName, changedBy, isContextBased);
            map.put("configType", configType);
            String clickHereString = this.bundle.getString("ManualDNS.ClickLink");
            map.put("clickHere", clickHereString);
            errMsg = isContextBased ? mailer.sendMessage(HTMLFileReader.getMailContent((int)HTMLFileReader.change_Mgmt_ContextBased_MAIL_INDEX, (Map)map)) : mailer.sendMessage(HTMLFileReader.getMailContent((int)HTMLFileReader.change_Mgmt_MAIL_INDEX, (Map)map));
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        if (errMsg != null) {
            LOGGER.log(Level.INFO, "error msg while sending mail is:::" + errMsg);
        }
    }

    public static HashMap prepareMessageBody(Properties prop, HashMap diffContents, Long ddId, String deviceName, String changedBy, boolean isContextBased) throws IOException {
        int i;
        HashMap<String, String> result = new HashMap<String, String>();
        String addDetails = "";
        String delDetails = "";
        String modDetails = "";
        StringBuffer addBuffer = new StringBuffer();
        StringBuffer delBuffer = new StringBuffer();
        StringBuffer modBuffer = new StringBuffer();
        String changedDetails = "";
        StringBuffer changedBuffer = new StringBuffer();
        result.put("deviceName", deviceName);
        result.put("changedBy", changedBy);
        Timestamp timestamp = new Timestamp(new Date().getTime());
        String modifiedTime = timestamp.toString();
        result.put("modTime", modifiedTime);
        Vector firstDiff = (Vector)diffContents.get("firstDiff");
        Vector secondDiff = (Vector)diffContents.get("secondDiff");
        Vector firstFile = (Vector)diffContents.get("firstFile");
        Vector secondFile = (Vector)diffContents.get("secondFile");
        String secondFileContent = "";
        String firstFileContent = "";
        int firstDiffCode = 0;
        int secondDiffCode = 0;
        int startOfModule = 0;
        int endOfModule = 0;
        if (!isContextBased) {
            for (i = 0; i < secondDiff.size(); ++i) {
                firstDiffCode = Integer.parseInt((String)firstDiff.get(i));
                if (firstDiffCode == (secondDiffCode = Integer.parseInt((String)secondDiff.get(i))) && secondDiffCode == 0) continue;
                secondFileContent = (String)secondFile.get(i);
                if (secondDiffCode == 5 && firstDiffCode != 5) {
                    secondFileContent = (String)firstFile.get(i);
                    delBuffer.append(secondFileContent);
                    delBuffer.append("<br>");
                }
                if (secondDiffCode == 1) {
                    addBuffer.append(secondFileContent);
                    addBuffer.append("<br>");
                }
                if (firstDiffCode != 3 || secondDiffCode != 3) continue;
                firstFileContent = (String)firstFile.get(i);
                firstFileContent = firstFileContent.equals("") || firstFileContent.equals(" ") ? firstFileContent : firstFileContent.trim();
                secondFileContent = secondFileContent.equals("") || secondFileContent.equals(" ") ? secondFileContent : secondFileContent.trim();
                String[] contents = FwConfigMgmt.highlightDiff(firstFileContent, secondFileContent);
                firstFileContent = contents[0];
                secondFileContent = contents[1];
                modBuffer.append("<tr><td style='border-bottom:1px solid #e7e7e7;padding-left:8px;font-family:Arial, Verdana, Helvetica, sans-serif;color:#000; font-size:12px; font-weight:normal;'>");
                modBuffer.append(firstFileContent);
                modBuffer.append("</td><td style='border-bottom:1px solid #e7e7e7;padding-left:8px;font-family:Arial, Verdana, Helvetica, sans-serif;color:#000; font-size:12px; font-weight:normal;'>");
                modBuffer.append(secondFileContent);
                modBuffer.append("</td></tr>");
            }
            addDetails = addBuffer.toString();
            delDetails = delBuffer.toString();
            modDetails = modBuffer.toString();
            if (!addDetails.equals("") && addDetails != null) {
                result.put("addDisplay", "display:block");
                result.put("addedContents", addDetails);
            } else {
                result.put("addDisplay", "display:none");
            }
            if (!delDetails.equals("") && delDetails != null) {
                result.put("delDisplay", "display:block");
                result.put("delContents", delDetails);
            } else {
                result.put("delDisplay", "display:none");
            }
            if (!modDetails.equals("") && modDetails != null) {
                result.put("modDisplay", "display:block");
                result.put("modContents", modDetails);
            } else {
                result.put("modDisplay", "display:none");
            }
        } else {
            for (i = 0; i < secondDiff.size(); ++i) {
                int[] modules;
                firstDiffCode = Integer.parseInt((String)firstDiff.get(i));
                if (firstDiffCode == (secondDiffCode = Integer.parseInt((String)secondDiff.get(i))) && secondDiffCode == 0) continue;
                secondFileContent = (String)secondFile.get(i);
                firstFileContent = (String)firstFile.get(i);
                if (secondDiffCode == 5 && firstDiffCode != 5) {
                    secondFileContent = (String)firstFile.get(i);
                    if (secondFileContent.trim().length() > 0 && secondFileContent.charAt(0) == ' ' && !secondFileContent.trim().startsWith("edit")) {
                        modules = FwConfigMgmt.getStartAndEndModules(secondFile, i, firstDiff);
                        startOfModule = modules[0];
                        endOfModule = modules[1];
                        FwConfigMgmt.handleDiffBetweenStartAndEndModules(firstDiff, secondDiff, firstFile, secondFile, startOfModule, endOfModule, changedBuffer);
                        i = endOfModule;
                        continue;
                    }
                    changedBuffer.append("<tr><td style='border-bottom:1px solid #e7e7e7;padding-left:8px;font-family:Arial, Verdana, Helvetica, sans-serif;color:#000; font-size:12px; font-weight:normal;background:#FAC1C1;'>");
                    changedBuffer.append(firstFileContent);
                    changedBuffer.append("</td><td style='border-bottom:1px solid #e7e7e7;padding-left:8px;font-family:Arial, Verdana, Helvetica, sans-serif;color:#000; font-size:12px; font-weight:normal;background:#FAC1C1;'>");
                    changedBuffer.append("&nbsp;&nbsp;");
                    continue;
                }
                if (secondDiffCode == 1) {
                    if (secondFileContent.trim().length() > 0 && secondFileContent.charAt(0) == ' ' && !secondFileContent.trim().startsWith("edit")) {
                        modules = FwConfigMgmt.getStartAndEndModules(secondFile, i, firstDiff);
                        startOfModule = modules[0];
                        endOfModule = modules[1];
                        FwConfigMgmt.handleDiffBetweenStartAndEndModules(firstDiff, secondDiff, firstFile, secondFile, startOfModule, endOfModule, changedBuffer);
                        i = endOfModule;
                        continue;
                    }
                    changedBuffer.append("<tr><td style='border-bottom:1px solid #e7e7e7;padding-left:8px;font-family:Arial, Verdana, Helvetica, sans-serif;color:#000; font-size:12px; font-weight:normal;background:#C5EEAF;'>");
                    changedBuffer.append("&nbsp;&nbsp;");
                    changedBuffer.append("</td><td style='border-bottom:1px solid #e7e7e7;padding-left:8px;font-family:Arial, Verdana, Helvetica, sans-serif;color:#000; font-size:12px; font-weight:normal;background:#C5EEAF;'>");
                    changedBuffer.append(secondFileContent);
                    continue;
                }
                if (firstDiffCode != 3 || secondDiffCode != 3) continue;
                if (secondFileContent.trim().length() > 0 && secondFileContent.charAt(0) == ' ' && !secondFileContent.trim().startsWith("edit")) {
                    modules = FwConfigMgmt.getStartAndEndModules(secondFile, i, firstDiff);
                    startOfModule = modules[0];
                    endOfModule = modules[1];
                    FwConfigMgmt.handleDiffBetweenStartAndEndModules(firstDiff, secondDiff, firstFile, secondFile, startOfModule, endOfModule, changedBuffer);
                    i = endOfModule;
                    continue;
                }
                String[] contents = FwConfigMgmt.highlightDiff(firstFileContent, secondFileContent);
                firstFileContent = contents[0];
                secondFileContent = contents[1];
                changedBuffer.append("<tr><td style='border-bottom:1px solid #e7e7e7;padding-left:8px;font-family:Arial, Verdana, Helvetica, sans-serif;color:#000; font-size:12px; font-weight:normal;background:#BAC1FF;'>");
                changedBuffer.append(firstFileContent);
                changedBuffer.append("</td><td style='border-bottom:1px solid #e7e7e7;padding-left:8px;font-family:Arial, Verdana, Helvetica, sans-serif;color:#000; font-size:12px; font-weight:normal;background:#BAC1FF;'>");
                changedBuffer.append(secondFileContent);
            }
            changedDetails = changedBuffer.toString();
            result.put("changedContents", changedDetails);
        }
        String disableUrl = FwConfigMgmt.getDisableLink(ddId);
        result.put("disableUrl", disableUrl);
        return result;
    }

    private static String[] highlightDiff(String firstFileContent, String secondFileContent) {
        int k;
        String[] result = new String[2];
        String[] split1 = firstFileContent.split("\\s");
        String[] split2 = secondFileContent.split("\\s");
        List<String> list1 = Arrays.asList(split1);
        List<String> list2 = Arrays.asList(split2);
        int len1 = split1.length;
        int len2 = split2.length;
        String[] commonStrings = new String[len1];
        int j = 0;
        for (int i = 0; i < len1; ++i) {
            if (!list2.contains(split1[i])) continue;
            commonStrings[j] = split1[i];
            ++j;
        }
        List<String> commonStringList = Arrays.asList(commonStrings);
        StringBuffer sb1 = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        for (k = 0; k < len2; ++k) {
            if (commonStringList.contains(split2[k])) {
                sb2.append(split2[k]);
            } else {
                sb2.append("<b>");
                sb2.append(split2[k]);
                sb2.append("</b>");
            }
            sb2.append(" ");
        }
        for (k = 0; k < len1; ++k) {
            if (commonStringList.contains(split1[k])) {
                sb1.append(split1[k]);
            } else {
                sb1.append("<b>");
                sb1.append(split1[k]);
                sb1.append("</b>");
            }
            sb1.append(" ");
        }
        result[0] = sb1.toString();
        result[1] = sb2.toString();
        return result;
    }

    private static void handleDiffBetweenStartAndEndModules(Vector firstDiff, Vector secondDiff, Vector firstFile, Vector secondFile, int som, int eom, StringBuffer changedBuffer) {
        String firstFileContent = "";
        String secondFileContent = "";
        int firstDiffCode = 0;
        int secondDiffCode = 0;
        if (som != eom) {
            firstDiffCode = Integer.parseInt((String)firstDiff.get(som));
            if (firstDiffCode != (secondDiffCode = Integer.parseInt((String)secondDiff.get(som))) || secondDiffCode != 0) {
                ++som;
            }
            for (int k = som; k <= eom; ++k) {
                secondFileContent = (String)secondFile.get(k);
                firstFileContent = (String)firstFile.get(k);
                firstDiffCode = Integer.parseInt((String)firstDiff.get(k));
                secondDiffCode = Integer.parseInt((String)secondDiff.get(k));
                if (firstDiffCode == 5 && secondDiffCode == 1) {
                    changedBuffer.append("<tr><td style='border-bottom:1px solid #e7e7e7;padding-left:8px;font-family:Arial, Verdana, Helvetica, sans-serif;color:#000; font-size:12px; font-weight:normal;background:#C5EEAF;'>");
                    changedBuffer.append("&nbsp;&nbsp;");
                    changedBuffer.append("</td><td style='border-bottom:1px solid #e7e7e7;padding-left:8px;font-family:Arial, Verdana, Helvetica, sans-serif;color:#000; font-size:12px; font-weight:normal;background:#C5EEAF;'>");
                    changedBuffer.append(secondFileContent);
                    continue;
                }
                if (firstDiffCode == 2 && secondDiffCode == 5) {
                    changedBuffer.append("<tr><td style='border-bottom:1px solid #e7e7e7;padding-left:8px;font-family:Arial, Verdana, Helvetica, sans-serif;color:#000; font-size:12px; font-weight:normal;background:#FAC1C1;'>");
                    changedBuffer.append(firstFileContent);
                    changedBuffer.append("</td><td style='border-bottom:1px solid #e7e7e7;padding-left:8px;font-family:Arial, Verdana, Helvetica, sans-serif;color:#000; font-size:12px; font-weight:normal;background:#FAC1C1;'>");
                    changedBuffer.append("&nbsp;&nbsp;");
                    continue;
                }
                if (firstDiffCode == 3 && secondDiffCode == 3) {
                    String[] contents = FwConfigMgmt.highlightDiff(firstFileContent, secondFileContent);
                    firstFileContent = contents[0];
                    secondFileContent = contents[1];
                    changedBuffer.append("<tr><td style='border-bottom:1px solid #e7e7e7;padding-left:8px;font-family:Arial, Verdana, Helvetica, sans-serif;color:#000; font-size:12px; font-weight:normal;background:#BAC1FF;'>");
                    changedBuffer.append(firstFileContent);
                    changedBuffer.append("</td><td style='border-bottom:1px solid #e7e7e7;padding-left:8px;font-family:Arial, Verdana, Helvetica, sans-serif;color:#000; font-size:12px; font-weight:normal;background:#BAC1FF;'>");
                    changedBuffer.append(secondFileContent);
                    continue;
                }
                changedBuffer.append("<tr><td style='border-bottom:1px solid #e7e7e7;padding-left:8px;font-family:Arial, Verdana, Helvetica, sans-serif;color:#000; font-size:12px; font-weight:normal;'>");
                changedBuffer.append(firstFileContent);
                changedBuffer.append("</td><td style='border-bottom:1px solid #e7e7e7;padding-left:8px;font-family:Arial, Verdana, Helvetica, sans-serif;color:#000; font-size:12px; font-weight:normal;'>");
                changedBuffer.append(secondFileContent);
            }
        }
    }

    private static int[] getStartAndEndModules(Vector secondFile, int i, Vector firstDiff) {
        int startOfModule;
        int[] modules = new int[3];
        int endOfModule = i;
        String tmpLine = null;
        String trimmedLine = null;
        for (startOfModule = i - 1; startOfModule >= 0; --startOfModule) {
            tmpLine = (String)secondFile.get(startOfModule);
            trimmedLine = tmpLine.trim();
            if (tmpLine.length() > 0 && (tmpLine.charAt(0) != ' ' || trimmedLine.startsWith("edit"))) break;
        }
        while (endOfModule < secondFile.size()) {
            tmpLine = (String)secondFile.get(endOfModule);
            trimmedLine = tmpLine.trim();
            if (tmpLine.length() > 0) {
                if (tmpLine.charAt(0) != ' ') {
                    --endOfModule;
                    break;
                }
                if (trimmedLine.startsWith("next")) break;
            }
            ++endOfModule;
        }
        boolean isBlock = true;
        if (startOfModule == -1) {
            isBlock = false;
            startOfModule = i;
        }
        if (endOfModule == firstDiff.size()) {
            isBlock = false;
            startOfModule = i + 1;
        }
        modules[0] = startOfModule;
        modules[1] = --endOfModule;
        modules[2] = isBlock ? 1 : 0;
        return modules;
    }

    public static String getDisableLink(Long ddId) {
        String protocol = FAServerUtil.getServerProtocol();
        String hostName = "localhost";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ee) {
            ee.printStackTrace();
            hostName = "localhost";
        }
        String port = FAServerUtil.getServerPort();
        String message = "";
        if (protocol != null && port != null) {
            message = protocol + "://" + hostName + ":" + port + "/fw/addDevCrd.do?mode=disableEmail&ddId=" + ddId;
        }
        return message;
    }

    private String composeSmsMsg(Properties prop, HashMap diffContents, String deviceName, String changedBy) {
        String message = "";
        Timestamp timestamp = new Timestamp(new Date().getTime());
        String modifiedTime = timestamp.toString();
        message = this.bundle.getString("CMSms.HeadString") + " " + deviceName + " " + this.bundle.getString("CMSms.ModTime") + " " + modifiedTime + " " + this.bundle.getString("CMSms.User") + " " + changedBy;
        return message;
    }

    private boolean getMailSettings() {
        boolean mailSet = false;
        try {
            SelectQueryImpl sql = new SelectQueryImpl(new Table("MailServerSettings"));
            Column col = new Column("MailServerSettings", "*");
            Criteria crt = new Criteria(new Column("MailServerSettings", "TYPE"), (Object)"FIREWALL", 0);
            sql.addSelectColumn(col);
            sql.setCriteria(crt);
            DataObject doo = DataAccess.get((SelectQuery)sql);
            Row r = doo.getFirstRow("MailServerSettings");
            this.from = (String)r.get("SENDER_MAILID");
            this.mailHost = (String)r.get("SMTPSERVER");
            this.mailPort = ((Long)r.get("SMTPSERVERPORT")).toString();
            this.user = (String)r.get("USERNAME");
            this.password = (String)r.get("PASSWORD");
            this.tls = (String)r.get("ACTIVE_TLS");
            mailSet = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mailSet;
    }

    private boolean getSmsSettings() {
        boolean smsSet = false;
        try {
            SelectQueryImpl sql = new SelectQueryImpl(new Table("SmsServerSettings"));
            Column col = new Column("SmsServerSettings", "*");
            Criteria crt = new Criteria(new Column("SmsServerSettings", "TYPE"), (Object)"FIREWALL", 0);
            sql.addSelectColumn(col);
            sql.setCriteria(crt);
            DataObject doo = DataAccess.get((SelectQuery)sql);
            Row r = doo.getFirstRow("SmsServerSettings");
            this.smsPort = (String)r.get("PORT");
            smsSet = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return smsSet;
    }

    public String getLatestConfigFile(String resourceID) {
        Long rID = new Long(resourceID);
        Long maxVersion = this.getMaxConfigVersion(rID, "running");
        if (maxVersion > 1L) {
            try {
                SelectQueryImpl sql = new SelectQueryImpl(new Table("ConfigVersions"));
                sql.addSelectColumn(new Column("ConfigVersions", "*"));
                Criteria crit = new Criteria(new Column("ConfigVersions", "RID"), (Object)rID, 0);
                crit = crit.and(new Criteria(new Column("ConfigVersions", "VERSION_NO"), (Object)maxVersion, 0));
                sql.setCriteria(crit);
                DataObject latestFileDO = DataAccess.get((SelectQuery)sql);
                if (latestFileDO.isEmpty()) {
                    return null;
                }
                String latestDiffFile = latestFileDO.getFirstValue("ConfigVersions", "MODIFIED_TIME").toString();
                int colonIndex = latestDiffFile.lastIndexOf(":");
                latestDiffFile = latestDiffFile.substring(0, colonIndex);
                return latestDiffFile;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyProcessor deleteExistingAndProcessLatestConfig(Long rID, String deviceType, String displayName, String configData, Long versionNo) throws Exception {
        block10: {
            boolean error = false;
            Exception exp = null;
            try {
                DELETELOCK.lock();
                Criteria delCrit = new Criteria(new Column("PolicyDetails", "RID"), (Object)rID, 0);
                DataAccess.delete((Criteria)delCrit);
                delCrit = new Criteria(new Column("RuleDetails", "RID"), (Object)rID, 0);
                DataAccess.delete((Criteria)delCrit);
                delCrit = new Criteria(new Column("FirewallObjects", "RID"), (Object)rID, 0);
                DataAccess.delete((Criteria)delCrit);
                delCrit = new Criteria(new Column("InterfaceDetails", "RID"), (Object)rID, 0);
                DataAccess.delete((Criteria)delCrit);
            }
            catch (Exception ee) {
                ee.printStackTrace();
                error = true;
                exp = ee;
                return exp;
            }
            finally {
                DELETELOCK.unlock();
                if (!error) break block10;
                throw exp;
            }
        }
        LOGGER.info("@@FwConfigMgmt:::: Before Processing Firewall Rules....");
        long start = System.currentTimeMillis();
        PolicyProcessor pp = null;
        if ("FortiGate".equals(deviceType)) {
            pp = new FortiGatePolicyProcessor(rID, displayName, configData, versionNo);
        } else if ("Cisco".equals(deviceType)) {
            pp = new CiscoPolicyProcessor(rID, displayName, configData, versionNo);
        } else if ("SRX Log Format".equals(deviceType)) {
            pp = new SRXPolicyProcessor(rID, displayName, configData, versionNo);
        }
        pp.startParsing();
        long totalTimeTaken = System.currentTimeMillis() - start;
        LOGGER.info("@@FwConfigMgmt:::: Finished Parsing Firewall Rules for the firewall:::" + displayName + " and the time taken is::" + totalTimeTaken);
        return pp;
    }

    static {
        CLIResourceManager.getInstance().setMaxConnections(10);
        CLIResourceManager.getInstance().setSystemWideMaxConnections(50);
        boolean debug = "true".equals(System.getProperty("FWA_CLI_DEBUG"));
        CLILogMgr.setDebugOption((boolean)debug);
    }
}

