/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.cli.CLISession;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.fa.server.DynamicLocks;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.rules.DeviceCommandParser;
import com.adventnet.fa.server.rules.DeviceConnection;
import com.adventnet.fa.server.rules.FWAPolicyParserRulesLoader;
import com.adventnet.fa.server.rules.PolicyProcessorUtilityClass;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.util.EncryptionAPI;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.json.JSONArray;

public class ComlianceScheduleUtility {
    private static final Logger LOGGER = Logger.getLogger(ComlianceScheduleUtility.class.getName());
    EncryptionAPI decryptionObj = EncryptionAPI.getDecryptionObj();
    private static final ReentrantLock EXCLUDE_SERVICE_SYNC_LOCK = new ReentrantLock();
    private static final ReentrantLock USER_INPUT_SYNC_LOCK = new ReentrantLock();
    private static ComlianceScheduleUtility csu = null;

    public static synchronized ComlianceScheduleUtility getInstance() {
        if (csu == null) {
            csu = new ComlianceScheduleUtility();
        }
        return csu;
    }

    public boolean checkForParsing(Long latestConfigVersionNo, Long rID, String displayName, String complianceReportName) throws Exception {
        try {
            String complianceVersionNo;
            Long versionNO;
            Criteria crit = new Criteria(new Column("ComplianceDashboardInfo", "RID"), (Object)rID, 0);
            crit = crit.and(new Criteria(new Column("ComplianceDashboardInfo", "COMPLIANCE_TYPE"), (Object)complianceReportName, 0));
            DataObject complianceDO = DataAccess.get((String)"ComplianceDashboardInfo", (Criteria)crit);
            return !complianceDO.isEmpty() && (versionNO = new Long(complianceVersionNo = (String)complianceDO.getFirstValue("ComplianceDashboardInfo", "VERSION_NO"))) > 0L && versionNO.compareTo(latestConfigVersionNo) == 0;
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Exception while checking for latest config parsed results..for the firewall " + displayName, ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpUserInputsIntoDB(Long rID, HashMap<String, String> userInputs, String deviceType, String displayName) throws Exception {
        block20: {
            boolean error = false;
            Exception exp = null;
            try {
                USER_INPUT_SYNC_LOCK.lock();
                if (FAServerUtil.isPolicyProcessing(rID)) {
                    LOGGER.info("ComplianceScheduleUtility::: Waiting to dump interface based user inputs for the device " + displayName + " because policy processing has already triggerred for this device..");
                    try {
                        Object userInputLock;
                        Object object = userInputLock = DynamicLocks.getLockFor(rID + "_userInput");
                        synchronized (object) {
                            userInputLock.wait();
                        }
                    }
                    catch (Exception lockExp) {
                        throw new Exception("ComlianceScheduleUtility ::: dumpUserInputsIntoDB method::: Exception while waiting on rid specific userInputLock process lock...for firewall " + displayName, lockExp);
                    }
                }
                FAServerUtil.addToCurrentUserInputProcesses(rID);
                String lanInterfaces = userInputs.get("LAN");
                String wanInterfaces = userInputs.get("WAN");
                String dmzInterfaces = userInputs.get("DMZ");
                String pciZoneInterfaces = userInputs.get("PCIZone");
                String excludedServices = userInputs.get("ServiceExclude");
                Criteria userInputDelCrit = new Criteria(new Column("ComplianceUserInputs", "RID"), (Object)rID, 0);
                FAServerUtil.getPersistence().delete(userInputDelCrit);
                Row complianceUserInputsRow = new Row("ComplianceUserInputs");
                complianceUserInputsRow.set("RID", (Object)rID);
                complianceUserInputsRow.set("LAN_INTERFACE", (Object)lanInterfaces);
                complianceUserInputsRow.set("DMZ_INTERFACE", (Object)dmzInterfaces);
                complianceUserInputsRow.set("PCIZone_INTERFACE", (Object)pciZoneInterfaces);
                complianceUserInputsRow.set("WAN_INTERFACE", (Object)wanInterfaces);
                complianceUserInputsRow.set("SERVICES_ALLOWED", (Object)excludedServices);
                DataObject dObj = DataAccess.constructDataObject();
                dObj.addRow(complianceUserInputsRow);
                DataAccess.add((DataObject)dObj);
                HashMap<String, String> interfaceVsZoneMap = new HashMap<String, String>();
                if (lanInterfaces != null) {
                    String[] lanInterfaceArray;
                    for (String interfaceName : lanInterfaceArray = lanInterfaces.split(",")) {
                        interfaceVsZoneMap.put(interfaceName, "LAN");
                    }
                }
                if (dmzInterfaces != null) {
                    String[] dmzInterfaceArray;
                    for (String interfaceName : dmzInterfaceArray = dmzInterfaces.split(",")) {
                        interfaceVsZoneMap.put(interfaceName, "DMZ");
                    }
                }
                if (pciZoneInterfaces != null) {
                    String[] pciInterfaceArray;
                    for (String interfaceName : pciInterfaceArray = pciZoneInterfaces.split(",")) {
                        interfaceVsZoneMap.put(interfaceName, "PCI");
                    }
                }
                if (wanInterfaces != null) {
                    String[] wanInterfaceArray;
                    for (String interfaceName : wanInterfaceArray = wanInterfaces.split(",")) {
                        interfaceVsZoneMap.put(interfaceName, "WAN");
                    }
                }
                PolicyProcessorUtilityClass.setResourceSpecificInterfaceVsZoneMap(rID, interfaceVsZoneMap);
            }
            catch (Exception ee) {
                error = true;
                exp = ee;
            }
            finally {
                USER_INPUT_SYNC_LOCK.unlock();
                if (!error) break block20;
                FAServerUtil.removeFromCurrentUserInputProcesses(rID);
                throw new Exception("ComplianceGenerator:::Exception while processing and dumping User Inputs..for the firewall " + displayName, exp);
            }
        }
    }

    private void putInfoIntoUserInputTable(Long rID, String excludedServices, String displayName) throws Exception {
        try {
            String supportedDevices = FWAPolicyParserRulesLoader.getInstance().getPolicyParsingSupportedDevices();
            String[] supportedDevicesList = supportedDevices.split(",");
            ArrayList<Long> noServiceRIDList = new ArrayList<Long>();
            ArrayList<Long> serviceUpdateRIDList = new ArrayList<Long>();
            SelectQueryImpl resSQL = new SelectQueryImpl(new Table("Resources"));
            resSQL.addSelectColumn(new Column("Resources", "*"));
            Join join1 = new Join("Resources", "ComplianceUserInputs", new String[]{"RESOURCEID"}, new String[]{"RID"}, 1);
            resSQL.addJoin(join1);
            resSQL.addSelectColumn(new Column("ComplianceUserInputs", "*"));
            Criteria noServiceCrt = new Criteria(new Column("Resources", "VENDOR_TYPE"), (Object)supportedDevicesList, 8);
            noServiceCrt = noServiceCrt.and(new Criteria(new Column("ComplianceUserInputs", "SERVICES_ALLOWED"), null, 0));
            resSQL.setCriteria(noServiceCrt);
            DataObject noServiceDO = DataAccess.get((SelectQuery)resSQL);
            if (!noServiceDO.isEmpty()) {
                Iterator itr = noServiceDO.getRows("Resources");
                while (itr.hasNext()) {
                    Row noServiceRow = (Row)itr.next();
                    noServiceRIDList.add((Long)noServiceRow.get("RESOURCEID"));
                }
            }
            SelectQueryImpl userInputSQL = new SelectQueryImpl(new Table("ComplianceUserInputs"));
            userInputSQL.addSelectColumn(new Column("ComplianceUserInputs", "*"));
            DataObject userInputDO = DataAccess.get((SelectQuery)userInputSQL);
            if (!userInputDO.isEmpty()) {
                Iterator itr = userInputDO.getRows("ComplianceUserInputs");
                while (itr.hasNext()) {
                    Row userInputRow = (Row)itr.next();
                    Long tempRID = (Long)userInputRow.get("RID");
                    noServiceRIDList.remove(tempRID);
                    serviceUpdateRIDList.add(tempRID);
                }
            }
            if (!noServiceRIDList.isEmpty()) {
                this.insertExcludeServiceInfo(noServiceRIDList, excludedServices);
            }
            if (!serviceUpdateRIDList.isEmpty()) {
                Long[] serviceUpdateRIDs = new Long[serviceUpdateRIDList.size()];
                int i = 0;
                Iterator i$ = serviceUpdateRIDList.iterator();
                while (i$.hasNext()) {
                    Long rid;
                    serviceUpdateRIDs[i] = rid = (Long)i$.next();
                    ++i;
                }
                this.updateExcludeServiceInfo(serviceUpdateRIDs, excludedServices);
            }
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Exception while updating excluded services into UserInput Table...for the firewall " + displayName, ee);
        }
    }

    public boolean checkForUserInputs(Long rID, String displayName) throws Exception {
        try {
            Criteria crit = new Criteria(new Column("ComplianceUserInputs", "RID"), (Object)rID, 0);
            DataObject doo = DataAccess.get((String)"ComplianceUserInputs", (Criteria)crit);
            return !doo.isEmpty();
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Exception while checking for User Inputs..for the firewall " + displayName, ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleExcludeServices(Long rID, String excludedServices, String displayName, boolean ignoreComplianceGeneration) throws Exception {
        block17: {
            excludedServices = excludedServices != null ? excludedServices.toUpperCase() : null;
            boolean error = false;
            Exception exp = null;
            try {
                EXCLUDE_SERVICE_SYNC_LOCK.lock();
                if (!ignoreComplianceGeneration && FAServerUtil.isComplianceGeneratingNow()) {
                    try {
                        Object globalExcludeServiceLock;
                        Object object = globalExcludeServiceLock = FAServerUtil.GLOBALEXCLUDESERVICELOCK;
                        synchronized (object) {
                            globalExcludeServiceLock.wait();
                        }
                    }
                    catch (Exception lockExp) {
                        throw new Exception("ComlianceScheduleUtility:::Exception while waiting on Global Exclude Service Lock while handling exclude services...", lockExp);
                    }
                }
                FAServerUtil.addToCurrentExcludeServicesProcessesingList(rID);
                if (excludedServices != null) {
                    excludedServices = excludedServices.trim();
                    this.putInfoIntoUserInputTable(rID, excludedServices, displayName);
                    if ("".equals(excludedServices)) {
                        this.makeAllCheckListEnable(displayName);
                    } else {
                        String[] tempExcludeServiceArray = excludedServices.split(",");
                        String[] excludeServiceArray = new String[tempExcludeServiceArray.length];
                        int i = 0;
                        for (String service : tempExcludeServiceArray) {
                            excludeServiceArray[i] = service.trim();
                            ++i;
                        }
                        Long[] excludeServiceGenericIDArray = this.getExcludeServiceCheckListIDList(excludeServiceArray, displayName);
                        this.disableExcludedServicesAndEnableRest(excludeServiceGenericIDArray, displayName);
                        this.deleteExcludeServicesEntriesFromSummaryTable(excludeServiceGenericIDArray, displayName);
                    }
                } else {
                    this.makeAllCheckListEnable(displayName);
                }
                FAServerUtil.removeFromCurrentExcludeServicesProcessesingList(rID);
                this.releaseGlobalLock();
            }
            catch (Exception ee) {
                error = true;
                exp = ee;
            }
            finally {
                EXCLUDE_SERVICE_SYNC_LOCK.unlock();
                if (!error) break block17;
                FAServerUtil.removeFromCurrentExcludeServicesProcessesingList(rID);
                throw new Exception("ComplianceGenerator:::Exception while handling exclude services...for the firewall " + displayName, exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseGlobalLock() {
        Object waitLock = FAServerUtil.GLOBALCOMPLIANCELOCK;
        try {
            Object object = waitLock;
            synchronized (object) {
                waitLock.notifyAll();
            }
        }
        catch (Exception ee) {
            LOGGER.info("ComlianceScheduleUtility:::Exception while releasing global compliance lock...");
            ee.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRuleDetailsBasedOnUserInput(Long rID, String displayName, String deviceType, Long versionNo) throws Exception {
        block20: {
            Exception exp = null;
            boolean isLocked = false;
            try {
                DataObject rulesDO;
                USER_INPUT_SYNC_LOCK.lock();
                isLocked = true;
                if (FAServerUtil.isPolicyProcessing(rID)) {
                    LOGGER.info("ComplianceScheduleUtility::: Waiting to Update RuleDetails table info based on new interface based user inputs for the device " + displayName + " because policy processing has already triggerred for this device..");
                    try {
                        Object userInputLock;
                        Object object = userInputLock = DynamicLocks.getLockFor(rID + "_userInput");
                        synchronized (object) {
                            userInputLock.wait();
                        }
                    }
                    catch (Exception lockExp) {
                        USER_INPUT_SYNC_LOCK.unlock();
                        isLocked = false;
                        throw new Exception("ComlianceScheduleUtility ::: updateRuleDetailsBasedOnUserInput method::: Exception while waiting on rid specific userInputLock process lock...for firewall " + displayName, lockExp);
                    }
                }
                if ((rulesDO = this.getRuleDetailsDO(rID, displayName)).isEmpty()) {
                    USER_INPUT_SYNC_LOCK.unlock();
                    isLocked = false;
                    throw new Exception("NoRulesToUpdate");
                }
                HashMap<String, String> interfaceVsZoneMap = PolicyProcessorUtilityClass.getResourceSpecificInterfaceVsZoneMap(rID);
                if (interfaceVsZoneMap == null || interfaceVsZoneMap.isEmpty()) {
                    USER_INPUT_SYNC_LOCK.unlock();
                    isLocked = false;
                    throw new Exception("NoInterfaceVsZoneMapping");
                }
                Iterator itr = rulesDO.getRows("RuleDetails");
                while (itr.hasNext()) {
                    Row ruleDetailsRow = (Row)itr.next();
                    String dInt = (String)ruleDetailsRow.get("DST_INT");
                    String sInt = (String)ruleDetailsRow.get("SRC_INT");
                    if (sInt != null && !"any".equals(sInt.toLowerCase())) {
                        String srcZone = interfaceVsZoneMap.get(sInt);
                        ruleDetailsRow.set("SRC_ZONE", (Object)srcZone);
                    }
                    if (dInt != null && !"any".equals(dInt.toLowerCase())) {
                        String dstZone = interfaceVsZoneMap.get(dInt);
                        ruleDetailsRow.set("DST_ZONE", (Object)dstZone);
                    }
                    rulesDO.updateRow(ruleDetailsRow);
                }
                DataAccess.update((DataObject)rulesDO);
                DataObject interfaceDO = this.getInterfaceDetailsDO(rID, displayName);
                if (interfaceDO.isEmpty()) {
                    USER_INPUT_SYNC_LOCK.unlock();
                    isLocked = false;
                    throw new Exception("NoInterfacesToUpdate");
                }
                itr = interfaceDO.getRows("InterfaceDetails");
                while (itr.hasNext()) {
                    Row interfaceDetailsRow = (Row)itr.next();
                    String aliasName = (String)interfaceDetailsRow.get("ALIAS_NAME");
                    String interfaceZone = interfaceVsZoneMap.get(aliasName);
                    interfaceDetailsRow.set("INTERFACE_NETWORK_ZONE", (Object)interfaceZone);
                    interfaceDO.updateRow(interfaceDetailsRow);
                }
                DataAccess.update((DataObject)interfaceDO);
            }
            catch (Exception ee) {
                exp = ee;
            }
            finally {
                if (isLocked) {
                    USER_INPUT_SYNC_LOCK.unlock();
                }
                if (exp == null) break block20;
                FAServerUtil.removeFromCurrentUserInputProcesses(rID);
                throw new Exception("ComplianceGenerator:::Exception while updating ruledetails based on UserInput....for the firewall " + displayName, exp);
            }
        }
    }

    private void insertExcludeServiceInfo(ArrayList<Long> noServiceRIDList, String excludedServices) throws Exception {
        DataObject doo = DataAccess.constructDataObject();
        for (Long rID : noServiceRIDList) {
            Row userInputRow = new Row("ComplianceUserInputs");
            userInputRow.set("RID", (Object)rID);
            userInputRow.set("SERVICES_ALLOWED", (Object)excludedServices);
            doo.addRow(userInputRow);
        }
        DataAccess.add((DataObject)doo);
    }

    private void updateExcludeServiceInfo(Long[] serviceUpdateRIDs, String excludedServices) throws Exception {
        UpdateQueryImpl uq = new UpdateQueryImpl("ComplianceUserInputs");
        Criteria crit = new Criteria(new Column("ComplianceUserInputs", "RID"), (Object)serviceUpdateRIDs, 8);
        uq.setCriteria(crit);
        uq.setUpdateColumn("SERVICES_ALLOWED", (Object)excludedServices);
        FAServerUtil.getPersistence().update((UpdateQuery)uq);
    }

    private void makeAllCheckListEnable(String displayName) throws Exception {
        try {
            UpdateQueryImpl uq = new UpdateQueryImpl("FWAConfigCheckListDetails");
            uq.setUpdateColumn("ENABLE", (Object)Boolean.TRUE);
            DataAccess.update((UpdateQuery)uq);
            uq = new UpdateQueryImpl("ComplianceUserInputs");
            uq.setUpdateColumn("SERVICES_ALLOWED", null);
            FAServerUtil.getPersistence().update((UpdateQuery)uq);
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Exception while enabling all checklist in FWAConfigCheckListDetails table...for the firewall " + displayName, ee);
        }
    }

    private Long[] getExcludeServiceCheckListIDList(String[] excludeServiceArray, String displayName) throws Exception {
        try {
            Criteria crit = new Criteria(new Column("FWAConfigCheckListDetails", "SERVICENAME"), (Object)excludeServiceArray, 8);
            DataObject checkListDO = DataAccess.get((String)"FWAConfigCheckListDetails", (Criteria)crit);
            if (!checkListDO.isEmpty()) {
                Long[] excludeServiceCheckListIDArray = new Long[excludeServiceArray.length];
                Iterator checkListItr = checkListDO.getRows("FWAConfigCheckListDetails");
                int i = 0;
                while (checkListItr.hasNext()) {
                    Row row = (Row)checkListItr.next();
                    excludeServiceCheckListIDArray[i] = (Long)row.get("GENERIC_SECTION_ID");
                    ++i;
                }
                return excludeServiceCheckListIDArray;
            }
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Exception while getting excluded services checklist IDs...for the firewall " + displayName, ee);
        }
        return null;
    }

    public void deleteExcludeServicesEntriesFromSummaryTable(Long[] excludeServiceGenericIDArray, String displayName) throws Exception {
        try {
            Criteria crit = new Criteria(new Column("ConfigCheckListStatusSummary", "GENERIC_SECTION_ID"), (Object)excludeServiceGenericIDArray, 8);
            DataAccess.delete((Criteria)crit);
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Exception while deleting exclude service entries from summary table...for the firewall " + displayName, ee);
        }
    }

    private void disableExcludedServicesAndEnableRest(Long[] excludeServiceGenericIDArray, String displayName) throws Exception {
        try {
            UpdateQueryImpl uq = new UpdateQueryImpl("FWAConfigCheckListDetails");
            Criteria crit = new Criteria(new Column("FWAConfigCheckListDetails", "GENERIC_SECTION_ID"), (Object)excludeServiceGenericIDArray, 8);
            uq.setCriteria(crit);
            uq.setUpdateColumn("ENABLE", (Object)Boolean.FALSE);
            DataAccess.update((UpdateQuery)uq);
            uq = new UpdateQueryImpl("FWAConfigCheckListDetails");
            crit = new Criteria(new Column("FWAConfigCheckListDetails", "GENERIC_SECTION_ID"), (Object)excludeServiceGenericIDArray, 9);
            uq.setCriteria(crit);
            uq.setUpdateColumn("ENABLE", (Object)Boolean.TRUE);
            DataAccess.update((UpdateQuery)uq);
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Exception while disabling excluded services and enabling rest...for the firewall " + displayName, ee);
        }
    }

    public DataObject getRuleDetailsDO(Long rID, String displayName) throws Exception {
        try {
            Criteria crit = new Criteria(new Column("RuleDetails", "RID"), (Object)rID, 0);
            return DataAccess.get((String)"RuleDetails", (Criteria)crit);
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Exception while getting RuleDetailsDO..for the firewall " + displayName, ee);
        }
    }

    private DataObject getInterfaceDetailsDO(Long rID, String displayName) throws Exception {
        try {
            Criteria crit = new Criteria(new Column("InterfaceDetails", "RID"), (Object)rID, 0);
            return DataAccess.get((String)"InterfaceDetails", (Criteria)crit);
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Exception while getting InterfaceDetailsDO..for the firewall " + displayName, ee);
        }
    }

    public String getConfigByconnectingToDevice(Long rID, String deviceType) {
        try {
            DeviceConnection dCon = DeviceConnection.getInstance();
            DeviceCommandParser dcp = DeviceCommandParser.getInstance();
            Criteria crit = new Criteria(new Column("DeviceDetails", "RID"), (Object)rID, 0);
            DataObject devRuleDO = DataAccess.get((String)"DeviceDetails", (Criteria)crit);
            if (!devRuleDO.isEmpty()) {
                Long ddid = (Long)devRuleDO.getFirstValue("DeviceDetails", "DDID");
                boolean isProfileBased = (Boolean)devRuleDO.getFirstValue("DeviceDetails", "ISPROFILEBASED");
                DataObject doo = isProfileBased ? dCon.getProfileDO(ddid, true) : dCon.getDO(ddid);
                List tableNames = doo.getTableNames();
                String tableName = tableNames.contains("DIPCredentials") ? "DIPCredentials" : "DeviceCredentials";
                Properties props = dCon.getPropertiesFromDO(doo, tableName);
                List vdomList = FAServerUtil.getVdomDevicesList();
                String ip = (String)LaCacheManager.getInstance().getResourceIp(rID);
                boolean isVdom = vdomList.contains(ip);
                List complianceCmds = isVdom ? dcp.getVdomRunningComplianceCommands(deviceType) : dcp.getRunningComplianceCommands(deviceType);
                Boolean isVDOM = isVdom ? Boolean.TRUE : Boolean.FALSE;
                CLISession cli = dCon.createSession(props);
                String configFromDevice = dCon.reteriveConfigurationData(props, "auto", complianceCmds, rID, "running", Boolean.FALSE, cli, isVDOM);
                dCon.cleanUp(cli, rID);
                return configFromDevice;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLatestConfigFromDB(Long rID, String displayName, Long latestConfigVersionNo) {
        String dbConfigData;
        block7: {
            dbConfigData = null;
            try {
                Criteria crit = new Criteria(new Column("ConfigVersions", "RID"), (Object)rID, 0);
                crit = crit.and(new Criteria(new Column("ConfigVersions", "CONFIG_TYPE"), (Object)"running", 0));
                crit = crit.and(new Criteria(new Column("ConfigVersions", "VERSION_NO"), (Object)latestConfigVersionNo, 0));
                DataObject configDO = DataAccess.get((String)"ConfigVersions", (Criteria)crit);
                if (configDO.isEmpty()) break block7;
                InputStream dbConfigDataStream = (InputStream)configDO.getFirstValue("ConfigVersions", "FILE_CONTENTS");
                if (dbConfigDataStream != null) {
                    StringWriter writer = new StringWriter();
                    char[] buffer = new char[1024];
                    try {
                        int n;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(dbConfigDataStream, "UTF-8"));
                        while ((n = reader.read(buffer)) != -1) {
                            ((Writer)writer).write(buffer, 0, n);
                        }
                    }
                    finally {
                        dbConfigDataStream.close();
                    }
                    dbConfigData = ((Object)writer).toString();
                }
                dbConfigData = this.decryptionObj.decryptLog(dbConfigData);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return dbConfigData;
    }

    public HashMap<String, String> parseUserInput(String userInput) throws Exception {
        HashMap<String, String> toSend = new HashMap<String, String>();
        String[] userInputArray = userInput.split("&");
        int i = 0;
        for (String value : userInputArray) {
            if (!value.endsWith("=")) {
                String[] tmpArr = value.split("=");
                value = tmpArr[1];
            } else {
                value = null;
            }
            switch (i) {
                case 0: {
                    if (value == null) break;
                    toSend.put("LAN", value);
                    break;
                }
                case 1: {
                    if (value == null) break;
                    toSend.put("DMZ", value);
                    break;
                }
                case 2: {
                    if (value == null) break;
                    toSend.put("WAN", value);
                    break;
                }
                case 3: {
                    if (value == null) break;
                    toSend.put("PCIZone", value);
                    break;
                }
                case 4: {
                    if (value == null) break;
                    value = value.trim();
                    toSend.put("ServiceExclude", value);
                }
            }
            ++i;
        }
        return toSend;
    }

    public Long getLatestConfigVersionNo(Long rID, String displayName) throws Exception {
        Long latestConfigVersionNo = null;
        try {
            Criteria crit = new Criteria(new Column("LatestConfig", "RID"), (Object)rID, 0);
            crit = crit.and(new Criteria(new Column("LatestConfig", "CONFIG_TYPE"), (Object)"running", 0));
            DataObject latestConfigDO = DataAccess.get((String)"LatestConfig", (Criteria)crit);
            if (!latestConfigDO.isEmpty()) {
                latestConfigVersionNo = (Long)latestConfigDO.getFirstValue("LatestConfig", "VERSION_NO");
            }
            return latestConfigVersionNo;
        }
        catch (Exception ee) {
            throw new Exception("ComplianceGenerator:::Exception while checking for latest config parsed results..for the firewall " + displayName, ee);
        }
    }

    public JSONArray getActiveInterfaceJSONArray(Long rID) {
        ArrayList<String> activeInterfaceList = new ArrayList<String>();
        try {
            Criteria interfaceCrit = new Criteria(new Column("InterfaceDetails", "RID"), (Object)rID, 0);
            DataObject interfaceDetailsDO = DataAccess.get((String)"InterfaceDetails", (Criteria)interfaceCrit);
            if (!interfaceDetailsDO.isEmpty()) {
                Iterator interfaceDetailItr = interfaceDetailsDO.getRows("InterfaceDetails");
                String interfaceName = null;
                while (interfaceDetailItr.hasNext()) {
                    Row row = (Row)interfaceDetailItr.next();
                    interfaceName = (String)row.get("ALIAS_NAME");
                    interfaceName = interfaceName == null ? (String)row.get("INTERFACE_NAME") : interfaceName;
                    if (activeInterfaceList.contains(interfaceName) || "-".equals(interfaceName)) continue;
                    activeInterfaceList.add(interfaceName);
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return new JSONArray(activeInterfaceList);
    }
}

