/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import java.util.ArrayList;
import java.util.List;

public class ProtocolIdentifierRange {
    List rangeList = new ArrayList();
    List protocolIndexList = new ArrayList();

    private boolean add(int[] range, String protocol) {
        int position = this.findInsertPosition(range[0], range[1]);
        if (position >= 0) {
            this.rangeList.add(position, range);
            this.protocolIndexList.add(position, protocol);
            return true;
        }
        return false;
    }

    private boolean add(int start, int end, String protocol) {
        return this.add(new int[]{start, end}, protocol);
    }

    private int findInsertPosition(int start, int end) {
        int[] nextElement;
        int[] preElement;
        int startIndex = 0;
        int endIndex = this.rangeList.size() - 1;
        while (endIndex >= startIndex) {
            int middleIndex = (startIndex + endIndex) / 2;
            int[] array = (int[])this.rangeList.get(middleIndex);
            if (start > array[0]) {
                startIndex = middleIndex + 1;
                continue;
            }
            endIndex = middleIndex - 1;
        }
        int myIndex = startIndex;
        int prevIndex = myIndex - 1;
        if (prevIndex >= 0 && (preElement = (int[])this.rangeList.get(prevIndex))[1] >= start) {
            return -1;
        }
        int nextIndex = myIndex;
        if (nextIndex < this.rangeList.size() && (nextElement = (int[])this.rangeList.get(nextIndex))[0] <= end) {
            return -1;
        }
        return myIndex;
    }

    public boolean contains(String identifier) {
        int slaIndex = identifier.indexOf("/");
        if (slaIndex > 0) {
            int value;
            int index;
            String slaPrefix = identifier.substring(0, slaIndex);
            boolean isNumber = false;
            char checkFirstDigit = slaPrefix.charAt(0);
            isNumber = Character.isDigit(checkFirstDigit);
            if (isNumber && (index = this.findMyPosition(value = Integer.parseInt(slaPrefix))) > 0) {
                return true;
            }
        }
        return false;
    }

    private int getMatchedRangeIndex(int value) {
        int index = this.findMyPosition(value);
        if (index < 0) {
            return -1;
        }
        return index;
    }

    public String getProtocolFromRangeList(String portNo) {
        try {
            int value = Integer.parseInt(portNo);
            int protocolIndex = this.getMatchedRangeIndex(value);
            if (protocolIndex < 0) {
                return null;
            }
            return (String)this.protocolIndexList.get(protocolIndex);
        }
        catch (Exception ee) {
            return null;
        }
    }

    public boolean updateRange(String identifier, String protocol) {
        int hiIndex = identifier.indexOf("-");
        int slaIndex = identifier.indexOf("/");
        int rangeFrom = Integer.parseInt(identifier.substring(0, hiIndex));
        int rangeTo = Integer.parseInt(identifier.substring(hiIndex + 1, slaIndex));
        boolean result = this.add(rangeFrom, rangeTo, protocol);
        return result;
    }

    public void clearMemory() {
        this.rangeList.clear();
        this.protocolIndexList.clear();
    }

    private int findMyPosition(int value) {
        int startIndex = 0;
        int endIndex = this.rangeList.size() - 1;
        while (endIndex >= startIndex) {
            int middleIndex = (startIndex + endIndex) / 2;
            int[] array = (int[])this.rangeList.get(middleIndex);
            if (value >= array[0] && value <= array[1]) {
                return middleIndex;
            }
            if (value > array[0]) {
                startIndex = middleIndex + 1;
                continue;
            }
            endIndex = middleIndex - 1;
        }
        return -1;
    }

    public static void main(String[] a) {
        System.out.println(" after deleting 6,7");
    }
}

