/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.dc.AbstractLogUnifier;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IDFLogUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(IDFLogUnifier.class.getName());
    private static final Integer TYPE = new Integer(1);
    private String dateFormat = "yyyy-MM-dd HH:mm:ss";
    private HashMap l3ProtocolMap = new HashMap();
    private HashMap msgIdMap = new HashMap();
    private HashMap typeMap = new HashMap();

    public IDFLogUnifier() {
        this.l3ProtocolMap.put("17", "udp");
        this.l3ProtocolMap.put("6", "tcp");
        this.l3ProtocolMap.put("1", "icmp");
        this.loadXML();
    }

    private void loadXML() {
        DocumentBuilder dBuild = null;
        Document doc = null;
        Element rootNode = null;
        try {
            DocumentBuilderFactory dBuildFac = DocumentBuilderFactory.newInstance();
            dBuild = dBuildFac.newDocumentBuilder();
            String fileName = System.getProperty("server.home") + File.separator + "server" + File.separator + "conf" + File.separator + "idf-ids.xml";
            File fwRules = new File(fileName);
            FileInputStream is = new FileInputStream(fwRules);
            doc = dBuild.parse(is);
            rootNode = doc.getDocumentElement();
            NodeList typeList = rootNode.getElementsByTagName("type");
            this.parseIdElementList(typeList, this.typeMap);
            NodeList msgList = rootNode.getElementsByTagName("msgid");
            this.parseIdElementList(msgList, this.msgIdMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void parseIdElementList(NodeList typeList, HashMap map) {
        for (int i = 0; i < typeList.getLength(); ++i) {
            Element type = (Element)typeList.item(i);
            NodeList idList = type.getElementsByTagName("id");
            int length = idList.getLength();
            for (int j = 0; j < length; ++j) {
                Element idElement = (Element)idList.item(j);
                String id = idElement.getAttribute("id");
                Properties prop = new Properties();
                NodeList paramList = idElement.getElementsByTagName("param");
                int pLength = paramList.getLength();
                for (int k = 0; k < pLength; ++k) {
                    Element paramElement = (Element)paramList.item(k);
                    prop.put(paramElement.getAttribute("key"), paramElement.getAttribute("value"));
                }
                map.put(id, prop);
            }
        }
    }

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        if (data.get("FW") == null) {
            data.put("FW", host);
        }
        if ("true".equals((String)data.get("DROP_LOG"))) {
            return null;
        }
        data.put("rtype", TYPE);
        this.loadXMLData(data);
        this.handleTime(data);
        this.handleBytes(data);
        data.put("SYSLOGIP", host);
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT", "EVENT_TYPE"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "RECEIVED"};
        this.strToLong(strToLong, data);
        this.checkForLearnMe(data);
        this.checkPriority(data);
        if (data.get("SRC") == null) {
            return null;
        }
        data.put("FW_TYPE", "IDF");
        data.put("LOG_FORMAT", "IDF");
        return data;
    }

    @Override
    public void checkForLearnMe(Hashtable data) {
        String service = (String)data.get("SERVICE");
        String proto = (String)data.get("PROTOCOL");
        if (proto != null && proto.equals("47")) {
            data.put("PROTOCOL", "gre");
        } else if (service == null) {
            if (proto != null) {
                proto = this.getStringL3Protocol(proto);
                data.put("L3_PROTOCOL", proto);
                Object destPort = data.get("DEST_PORT");
                if (destPort != null) {
                    proto = destPort.toString() + "/" + proto;
                }
                data.put("PROTOCOL", proto);
            }
        } else {
            int index = service.indexOf("/");
            if (index > 0) {
                String l3Proto = service.substring(0, index);
                data.put("L3_PROTOCOL", l3Proto);
                if (service.length() > index) {
                    String port = service.substring(index + 1);
                    service = port + "/" + l3Proto;
                }
            }
            data.put("PROTOCOL", service);
        }
        super.checkForLearnMe(data);
    }

    private void handleBytes(Hashtable data) {
        String bytes = (String)data.get("BYTES");
        if (bytes != null) {
            data.put("RECEIVED", bytes);
        }
    }

    private void loadXMLData(Hashtable data) {
        Properties temp;
        String msgid;
        Properties temp2;
        String type = (String)data.get("TYPE");
        if (type != null && (temp2 = (Properties)this.typeMap.get(type)) != null) {
            data.putAll(temp2);
            data.put("li", "1");
        }
        if ((msgid = (String)data.get("MSGID")) != null && (temp = (Properties)this.typeMap.get(msgid)) != null) {
            data.putAll(temp);
            data.put("li", "1");
        }
    }

    private void handleTime(Hashtable data) {
        String time = (String)data.get("TIME");
        if (time == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
        sdf.setTimeZone(TimeZone.getDefault());
        try {
            data.put("TIME", new Timestamp(sdf.parse(time).getTime()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

