/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.PureFirewallConstants;
import com.adventnet.fa.server.dc.AbstractLogUnifier;
import com.adventnet.fa.server.dc.PIXVPNObject;
import com.adventnet.la.util.FixedHashMap;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LEALogUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(LEALogUnifier.class.getName());
    String DATE_FORMAT = "ddMMMyyyy HH:mm:ss";
    private static final Integer TYPE = new Integer(2);
    private Map fwToVpnMap = new HashMap();

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        String ruleName;
        this.handleNewLine(data);
        data.put("rtype", TYPE);
        if (host != null) {
            data.put("SYSLOGIP", host);
        }
        if (data.get("SRC") == null) {
            String resource = (String)data.get("FW");
            data.clear();
            data.put("FW", resource);
            return data;
        }
        if (data.get("DEST") == null || "".equals(data.get("DEST"))) {
            data.put("DEST", "N/A");
        }
        Properties parameters = new Properties();
        String tempDateFormat = (String)data.get("DATE_FORMAT");
        if (tempDateFormat != null) {
            this.DATE_FORMAT = tempDateFormat;
        }
        if (data.get("RULE_NAME") != null && !"".equals(ruleName = (String)data.get("RULE_NAME"))) {
            data.put("RULE", ruleName);
        }
        this.handleFW(host, data);
        this.handleTime(data);
        this.handleTransfer(data);
        this.handleProtocol(data);
        boolean attack = this.handleAttack(data);
        String[] strToInt = new String[]{"SRC_PORT", "EVENT_TYPE", "DEST_PORT"};
        this.strToInt(strToInt, data);
        data.put("FW_TYPE", "Check Point");
        data.put("LOG_FORMAT", "LEA");
        this.assignDuration(data);
        this.checkForLearnMe(data);
        this.checkPriority(data);
        this.assignNameForAttack(data, "scan");
        this.checkAdminSupport(data);
        if (data.get("VPN") != null) {
            this.handleVPN(host, data);
            if (data.get("li") == null && data.get("CLIENT_INBOUND_BYTES") == null) {
                String resource = (String)data.get("FW");
                data.clear();
                data.put("FW", resource);
                return data;
            }
            if ("deny".equals(data.get("STATUS")) && data.get("EVENT_TYPE") != PureFirewallConstants.FAILED_VPN_LOG) {
                data.remove("VPN");
            }
        }
        this.checkSrcDstInterfaces(data, "FW");
        return data;
    }

    private void handleNewLine(Hashtable data) {
        try {
            for (Object key : data.keySet()) {
                Object obj = data.get(key);
                if (!(obj instanceof String) || ((String)obj).indexOf("\n") <= -1) continue;
                String temp = ((String)obj).replaceAll("\n", ",");
                data.put(key, temp.substring(0, temp.length() - 1));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Exception while handling newline char" + data);
        }
    }

    private void checkAdminSupport(Hashtable data) {
        String operation = (String)data.get("OPN");
        if (operation == null) {
            return;
        }
        data.put("li", "1");
        data.put("DEST", data.get("FW"));
        data.put("EVENT_TYPE", new Integer(1));
        data.put("RECORD_TYPE", "mgmt");
        if ("10".equals(operation)) {
            data.put("SUBTYPE", "1");
        } else if ("12".equals(operation)) {
            data.put("SUBTYPE", "2");
        } else if ("11".equals(operation)) {
            data.put("SUBTYPE", "3");
        } else {
            data.put("SUBTYPE", "4");
        }
    }

    private void handleFW(String host, Hashtable data) {
        if (data.get("ORIG_NAME") != null) {
            data.put("FW", (String)data.get("ORIG_NAME"));
        }
        if ("true".equals(System.getProperty("SINGLE_DEVICE"))) {
            data.put("FW", host);
        }
    }

    protected void assignDuration(Hashtable data) {
        String elapsed = (String)data.get("DURATION");
        if (elapsed == null) {
            data.put("DURATION", new Long(0L));
            return;
        }
        int hour = 0;
        int min = 0;
        int sec = 0;
        try {
            StringTokenizer token = new StringTokenizer(elapsed, ":");
            while (token.hasMoreTokens()) {
                hour = Integer.parseInt(token.nextToken());
                min = Integer.parseInt(token.nextToken());
                sec = Integer.parseInt(token.nextToken());
            }
            long duration = hour * 3600 + min * 60 + sec;
            if (duration == 0L) {
                duration = 1L;
            }
            data.put("DURATION", new Long(duration));
            return;
        }
        catch (Exception ee) {
            LOGGER.log(Level.FINER, " EXCEPTION WHILE PARSING DURATION TIME {0}", new Object[]{elapsed});
            ee.printStackTrace();
            data.put("DURATION", new Long(0L));
            return;
        }
    }

    protected boolean handleAttack(Hashtable data) {
        String attack = (String)data.get("ATTACK");
        if (attack != null) {
            data.put("VIRUS", attack);
            data.put("RECORD_TYPE", "attack");
            String attackInfo = (String)data.get("ATTACK_INFO");
            if (attackInfo != null) {
                data.put("MSG", attackInfo + " " + data.get("MSG"));
            }
            data.put("li", "1");
            return true;
        }
        return false;
    }

    protected void handleProtocol(Hashtable data) {
        String service = (String)data.get("SERVICE");
        if (service != null) {
            if (Character.isDigit(service.charAt(0))) {
                data.put("PROTOCOL", service + "/" + (String)data.get("PROTOCOL"));
            } else {
                data.put("PROTOCOL", service);
            }
        }
    }

    protected void handleTime(Hashtable data) {
        String time = (String)data.remove("TIME");
        if (time == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(this.DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getDefault());
        try {
            data.put("TIME", new Timestamp(sdf.parse(time).getTime()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void handleTransfer(Hashtable data) {
        String ifDir = (String)data.remove("IFDIR");
        String stringBytes = (String)data.remove("BYTES");
        String src = (String)data.get("SRC");
        long bytes = 0L;
        if (stringBytes != null) {
            try {
                bytes = Math.abs(Long.parseLong(stringBytes));
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
        String clientInString = (String)data.get("CLIENT_INBOUND_BYTES");
        String clientOutString = (String)data.get("CLIENT_OUTBOUND_BYTES");
        long clientInBytes = 0L;
        long clientOutBytes = 0L;
        try {
            if (clientInString != null) {
                clientInBytes = Math.abs(Long.parseLong(clientInString));
            }
            clientOutBytes = clientOutString != null ? Math.abs(Long.parseLong(clientOutString)) : Math.abs(bytes - clientInBytes);
        }
        catch (Exception ee) {
            System.out.println(ee + " clientInString ::" + clientInString + " clientOutString " + clientOutString);
        }
        data.put("RECEIVED", new Long(clientOutBytes));
        data.put("SENT", new Long(clientInBytes));
    }

    @Override
    public Map getLiveData(String resource) {
        TreeMap<Timestamp, PIXVPNObject> liveVPNUserMap = new TreeMap<Timestamp, PIXVPNObject>();
        Map vpnObjMap = (Map)this.fwToVpnMap.get(resource);
        if (vpnObjMap != null) {
            for (String key : vpnObjMap.keySet()) {
                PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.get(key);
                Timestamp time = vpnObj.getVPNTime();
                liveVPNUserMap.put(time, vpnObj);
            }
        }
        return liveVPNUserMap;
    }

    private void addVPNObject(Hashtable data, String host) {
        try {
            String resource = (String)data.get("FW");
            String user = (String)data.get("USERNAME");
            Map<String, PIXVPNObject> vpnObjMap = (Map<String, PIXVPNObject>)this.fwToVpnMap.get(resource);
            if (vpnObjMap == null) {
                vpnObjMap = Collections.synchronizedMap(new FixedHashMap(800));
                this.fwToVpnMap.put(resource, vpnObjMap);
            }
            if (vpnObjMap.get(user) != null) {
                PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.get(user);
                vpnObj.setTranIp((String)data.get("TRAN_IP"));
            } else {
                PIXVPNObject vpnObj = new PIXVPNObject(data);
                vpnObj.setResource(resource);
                vpnObj.setUser(user);
                vpnObjMap.put(user, vpnObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeVPNObject(Hashtable data, String host) {
        try {
            String resource = (String)data.get("FW");
            String user = (String)data.get("USERNAME");
            Map vpnObjMap = (Map)this.fwToVpnMap.get(resource);
            if (vpnObjMap != null) {
                PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.remove(user);
                long duration = 0L;
                if (vpnObj != null) {
                    Timestamp startTime = vpnObj.getVPNTime();
                    Timestamp endTime = (Timestamp)data.get("TIME");
                    duration = endTime.getTime() - startTime.getTime();
                    duration /= 1000L;
                    if (vpnObj.getSentBytes() != null) {
                        data.put("SENT", vpnObj.getSentBytes());
                        data.put("RECEIVED", vpnObj.getRcvdBytes());
                    }
                }
                data.put("DURATION", new Long(duration));
            } else {
                data.put("DURATION", new Long(0L));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleVPN(String host, Hashtable data) {
        PIXVPNObject vpnObj;
        Map vpnObjMap;
        String msg = (String)data.get("VPN_MSG");
        String user = (String)data.get("USERNAME");
        if (msg != null) {
            if (msg.indexOf("Authenticated") > -1 || msg.startsWith("connected")) {
                this.addVPNObject(data, host);
                data.put("VPN", "RemoteAccess");
            } else if (msg.indexOf("disconnected") > -1) {
                this.removeVPNObject(data, host);
                data.remove("DEST");
                data.put("VPN", "RemoteAccess");
                data.put("li", "1");
                data.put("PROTOCOL", "ike");
            }
        }
        if (data.get("CLIENT_INBOUND_BYTES") != null && (vpnObjMap = (Map)this.fwToVpnMap.get(data.get("FW"))) != null && (vpnObj = (PIXVPNObject)vpnObjMap.get(user)) != null) {
            this.aggregateSentAndRcvd(vpnObj, data);
            data.put("TRAN_IP", (String)data.get("SRC"));
            data.put("SRC", (String)data.get("GATEWAY"));
            data.put("VPN", "RemoteAccess");
        }
    }
}

