/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.dc.AbstractLogUnifier;
import java.util.Hashtable;
import java.util.logging.Logger;

public class OpzoonUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(OpzoonUnifier.class.getName());
    private static final Integer TYPE = new Integer(35);

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        data.put("rtype", TYPE);
        data.put("SYSLOGIP", host);
        String resource = (String)data.get("FW");
        data.put("RESOURCE", resource);
        data.put("FW_TYPE", "Opzoon");
        data.put("LOG_FORMAT", "Opzoon");
        this.handleDate(data);
        String recordType = (String)data.get("RECORD_TYPE");
        if (!"LOG_CM".equals(recordType)) {
            return null;
        }
        this.checkAdminSupport(data, host);
        return data;
    }

    private void handleDate(Hashtable data) {
        String date = (String)data.get("DATE");
        if (date != null) {
            String time = (String)data.get("TIME");
            time = date + " " + time;
            data.put("TIME", time);
        }
    }

    private void checkAdminSupport(Hashtable data, String host) {
        String action = (String)data.get("ACTION");
        if ((action = action.trim()) != null) {
            data.put("EVENT_TYPE", 1);
            data.put("DEST", host);
            data.put("li", "1");
            if (data.get("PROTOCOL") == null) {
                data.put("PROTOCOL", "Unknown");
            }
            String status = (String)data.get("STATUS");
            if ("login".equals(action) && "Success".equals(status)) {
                data.put("SUBTYPE", "1");
            } else if ("logout".equals(action) && "Success".equals(status)) {
                data.put("SUBTYPE", "2");
            } else if ("login".equals(action) && "Failed".equals(status)) {
                data.put("SUBTYPE", "3");
            } else if (!"login".equals(action) && !"logout".equals(action)) {
                data.put("SUBTYPE", "4");
                data.put("FILENAME", action);
            }
        }
    }
}

