/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.dc.AbstractLogUnifier;
import java.util.Hashtable;
import java.util.logging.Logger;

public class SnortUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(SnortUnifier.class.getName());
    private static final Integer TYPE = new Integer(16);
    private String dateFormat;

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        if (!this.handleAlerts(host, data)) {
            return null;
        }
        if (host != null) {
            data.put("SYSLOGIP", host);
        }
        if (data.get("SRC") == null) {
            return null;
        }
        if (data.get("VIRUS") != null) {
            data.put("EVENT_TYPE", 3);
        }
        return data;
    }

    private boolean handleAlerts(String host, Hashtable data) {
        data.put("rtype", TYPE);
        data.put("FW_TYPE", "Snort");
        data.put("LOG_FORMAT", "Snort");
        this.assignPreParserTime(data);
        this.handleDest(data);
        this.handleProtocol(data);
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "RECEIVED"};
        this.strToLong(strToLong, data);
        this.checkForLearnMe(data);
        String fw = (String)data.get("FW");
        if (fw == null) {
            data.put("FW", host);
        }
        return true;
    }

    protected void handleProtocol(Hashtable data) {
        try {
            String L3P = (String)data.get("L3PROTOCOL");
            data.put("L3_PROTOCOL", L3P);
            String dport = (String)data.get("DEST_PORT");
            if (dport != null) {
                data.put("PROTOCOL", dport + "/" + L3P);
            } else {
                data.put("PROTOCOL", L3P);
            }
            return;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return;
        }
    }
}

