/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.dc.PIXVPNObject;
import com.adventnet.fa.server.dc.WELFLogUnifier;
import com.adventnet.la.util.FixedHashMap;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WatchGuardLogUnifier
extends WELFLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(WatchGuardLogUnifier.class.getName());
    private static final Integer TYPE = new Integer(15);
    String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private Hashtable sslVpnMap = new Hashtable();
    private String protocolNamePattern = "([^\\d]+)/([\\S]*)";
    private Pattern protocolPattern = Pattern.compile(this.protocolNamePattern);
    private Map resToVpnMap = Collections.synchronizedMap(new FixedHashMap(500));
    private String ipSecKey = null;
    private Map categoryMap = Collections.synchronizedMap(new FixedHashMap(1000));

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        String module;
        String version = (String)data.get("VERSION");
        if (!(!"8.0".equals(version) || "FWAllow".equals(module = (String)data.get("MODULE")) || "FWDeny".equals(module) || module.startsWith("ProxySMTPR") || "ProxyMatch".equals(module) || "ProxyHTTPReq".equals(module))) {
            return null;
        }
        String resource = (String)data.get("RESOURCE");
        if (resource == null) {
            data.put("FW", host);
            data.put("RESOURCE", host);
        }
        this.checkWebFilter(data);
        if ("true".equals((String)data.get("DROP_LOG"))) {
            return null;
        }
        String status = (String)data.get("STATUS");
        if ("deny".equalsIgnoreCase(status)) {
            data.put("STATUS", "deny");
            data.put("li", "1");
        }
        if ("rejected".equals(data.get("VPN_STATUS"))) {
            data.put("STATUS", "deny");
            data.put("EVENT_TYPE", "10");
            data.remove("VPN");
            data.put("li", "1");
        }
        this.checkAdminLog(data);
        this.handleSecurityLog(data);
        this.handleTime(data);
        this.updateBytesInfo(data);
        this.updateRequest(data);
        data.put("rtype", TYPE);
        data.put("SYSLOGIP", host);
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT", "EVENT_TYPE"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "RECEIVED"};
        this.strToLong(strToLong, data);
        String duration = (String)data.get("DURATION");
        if (duration != null) {
            BigDecimal decimal = new BigDecimal(duration).setScale(4, 4);
            data.put("DURATION", new Long(decimal.longValue()));
        } else {
            data.put("DURATION", new Long(0L));
        }
        data.put("FW_TYPE", "WatchGuard Firewall");
        data.put("LOG_FORMAT", "WatchGuard Native Format");
        this.checkProtocolSyntax(data);
        this.checkArgument(data);
        this.checkPriority(data);
        Hashtable hashtable = data = "SSL".equals(data.get("VPN")) || data.get("TUNNEL_ID") != null ? this.handleSSL(data) : this.checkForVPN(data, host);
        if (status != null && ((status = status.toLowerCase()).startsWith("allow") || status.startsWith("accept"))) {
            data.put("STATUS", "permit");
        }
        return data;
    }

    @Override
    public void checkPriority(Hashtable data) {
        super.checkPriority(data);
        if (data == null) {
            return;
        }
        try {
            int pri = Integer.parseInt((String)data.get("PRIORITY"));
            if (pri > 7) {
                data.put("PRIORITY", "" + (pri %= 8));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void checkWebFilter(Hashtable data) {
        if ("http-proxy".equals(data.get("MODULE"))) {
            String key = data.get("RESOURCE").toString() + data.get("SRC_PORT");
            String cat = (String)data.get("CATEGORY");
            try {
                if (data.get("CAT_INT") != null && cat != null) {
                    if (cat.indexOf("&amp;") > 0) {
                        cat = cat.replaceAll("\\s&amp;\\s", ",");
                    }
                    if (cat.indexOf(",cache-hit") > 0) {
                        cat = cat.replace(",cache-hit", "");
                    }
                    this.categoryMap.put(key + "_cat", cat);
                    return;
                }
                if (data.get("TRAN_PORT") != null) {
                    this.categoryMap.put(key + "_app", data.get("TRAN_PORT"));
                    this.categoryMap.put(key + "_appcat", data.get("POLICY_ID"));
                    return;
                }
                if (this.categoryMap.containsKey(key + "_cat")) {
                    data.put("CATEGORY", (String)this.categoryMap.remove(key + "_cat"));
                }
                if (this.categoryMap.containsKey(key + "_app")) {
                    data.put("TRAN_PORT", (String)this.categoryMap.remove(key + "_app"));
                    data.put("POLICY_ID", (String)this.categoryMap.remove(key + "_appcat"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void handleSecurityLog(Hashtable data) {
        String msg = (String)data.get("MSG");
        if (msg != null && (msg.contains("SPAM") || msg.contains("bulk"))) {
            data.put("EVENT_TYPE", "7");
            data.put("RECORD_TYPE", "spam");
            data.put("li", "1");
        } else if ("attack".equals((String)data.get("RECORD_TYPE"))) {
            if (data.get("VIRUS") == null) {
                data.put("VIRUS", "Unknown");
            }
            if ("sender".equals(data.get("SENDER"))) {
                data.put("FROM_EMAIL", (String)data.get("DEST_NAME"));
                data.remove("DEST_NAME");
            }
        }
    }

    private Hashtable handleSSL(Hashtable data) {
        String status = (String)data.get("VPN_STATUS");
        String resource = (String)data.get("RESOURCE");
        Map<String, PIXVPNObject> connections = (Map<String, PIXVPNObject>)this.resToVpnMap.get(resource);
        if ("in".equals(status) || "Add".equals(data.get("CONN"))) {
            this.sslVpnMap.putAll(data);
            if (this.sslVpnMap.get("USERNAME") != null && this.sslVpnMap.get("TUNNEL_ID") != null) {
                String tunId = (String)this.sslVpnMap.get("TUNNEL_ID");
                if (connections == null) {
                    connections = Collections.synchronizedMap(new FixedHashMap(500));
                    this.resToVpnMap.put(resource, connections);
                }
                PIXVPNObject obj = new PIXVPNObject(this.sslVpnMap);
                obj.setUser((String)this.sslVpnMap.get("USERNAME"));
                obj.setTranIp((String)this.sslVpnMap.get("TUNNEL_IP"));
                connections.put(tunId, obj);
                this.sslVpnMap.clear();
            }
        } else if ("Del".equals(data.get("CONN"))) {
            PIXVPNObject obj;
            String key = (String)data.get("TUNNEL_ID");
            if (connections != null && (obj = (PIXVPNObject)connections.get(key)) != null) {
                long duration = ((Timestamp)data.get("TIME")).getTime() - obj.getVPNTime().getTime();
                data.put("DURATION", new Long(duration /= 1000L));
                data.put("SRC", obj.getSource());
                data.put("USERNAME", obj.getUser());
                data.put("TRAN_IP", data.get("TUNNEL_IP"));
                data.put("PRIORITY", "5");
                data.put("VPN", "SSL");
                connections.remove(key);
            }
            return data;
        }
        return null;
    }

    private Hashtable checkForVPN(Hashtable data, String host) {
        String type = (String)data.get("MODULENAME");
        if ("iked".equals(type)) {
            data.put("DURATION", new Long(0L));
            data.put("PRIORITY", "5");
            return data;
        }
        String status = (String)data.get("VPN_STATUS");
        String resource = (String)data.get("RESOURCE");
        String key = data.get("TRAN_IP") != null ? (String)data.get("TRAN_IP") + host : (String)data.get("SRC") + host;
        Map<String, PIXVPNObject> connections = (Map<String, PIXVPNObject>)this.resToVpnMap.get(resource);
        if ("in".equals(status)) {
            if (connections == null) {
                connections = Collections.synchronizedMap(new FixedHashMap(500));
                this.resToVpnMap.put(resource, connections);
            }
            PIXVPNObject obj = new PIXVPNObject(data);
            obj.setUser((String)data.get("USERNAME"));
            if ("IPSec".equals(data.get("VPN"))) {
                this.ipSecKey = key;
            }
            connections.put(key, obj);
            return null;
        }
        if ("out".equals(status)) {
            if (connections == null) {
                LOGGER.log(Level.WARNING, "Unable to retrive vpn connections for key ", key);
                return data;
            }
            PIXVPNObject obj = (PIXVPNObject)connections.get(key);
            if (obj == null) {
                LOGGER.log(Level.WARNING, "Unable to retrive start time for key ", key);
                return data;
            }
            long duration = ((Timestamp)data.get("TIME")).getTime() - obj.getVPNTime().getTime();
            data.put("DURATION", new Long(duration /= 1000L));
            data.put("TRAN_IP", obj.getTranIp());
            data.put("PRIORITY", "5");
            connections.remove(key);
        } else if (data.get("TRAN_IP") != null) {
            if (connections != null && this.ipSecKey != null) {
                PIXVPNObject obj = (PIXVPNObject)connections.get(this.ipSecKey);
                obj.setTranIp((String)data.get("TRAN_IP"));
            }
            return null;
        }
        if (data.get("RECEIVED") != null && connections != null && connections.get(key) != null) {
            this.handleIntermitant(data, host, connections, key);
        }
        return data;
    }

    private void handleIntermitant(Hashtable data, String host, Map connections, String key) {
        Map vpnObjMap = (Map)this.resToVpnMap.get(data.get("RESOURCE"));
        if (vpnObjMap != null) {
            PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.get(key);
            this.aggregateSentAndRcvd(vpnObj, data);
            data.put("TRAN_IP", (String)data.get("SRC"));
            data.put("VPN", "IPSEC");
        }
    }

    @Override
    public Map getLiveData(String resource) {
        TreeMap<Timestamp, PIXVPNObject> liveVPNUserMap = new TreeMap<Timestamp, PIXVPNObject>();
        Map vpnObjMap = (Map)this.resToVpnMap.get(resource);
        if (vpnObjMap != null) {
            for (String key : vpnObjMap.keySet()) {
                PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.get(key);
                Timestamp time = vpnObj.getVPNTime();
                liveVPNUserMap.put(time, vpnObj);
            }
        }
        return liveVPNUserMap;
    }

    private void updateBytesInfo(Hashtable data) {
        String headerLength = (String)data.get("HEADER_LENGTH");
        String packetLength = (String)data.get("PACKET_LENGHT");
        try {
            if (headerLength != null && packetLength != null) {
                long total = Long.parseLong(headerLength) + Long.parseLong(packetLength);
                String direction = (String)data.get("DIRECTION");
                data.put("RECEIVED", new Long(total));
            }
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(Level.WARNING, "Unable to obtain bytes information for {0} ", data);
        }
        super.handleMail(data);
    }

    private void updateRequest(Hashtable data) {
        String url = (String)data.get("URL");
        String dest = (String)data.get("DEST");
        String destPort = (String)data.get("DEST_PORT");
        String dest_name = (String)data.get("DEST_NAME");
        if (url != null) {
            if (dest_name != null) {
                data.put("REQUEST", dest_name + url);
            } else if (dest != null && destPort != null) {
                String request = dest + ":" + destPort + "/" + url;
                data.put("REQUEST", request);
            }
        }
    }

    private void checkAdminLog(Hashtable data) {
        if ("mgmt".equals(data.get("RECORD_TYPE"))) {
            String type;
            String string = type = data.get("SUBTYPE") != null ? (String)data.get("SUBTYPE") : "false";
            if (type.contains("logged in")) {
                data.put("SUBTYPE", "1");
            } else if (type.contains("logged out")) {
                data.put("SUBTYPE", "2");
            } else if (type.contains("rejected")) {
                data.put("SUBTYPE", "3");
                data.put("STATUS", "deny");
            } else {
                data.put("FILENAME", type);
                data.put("SUBTYPE", "4");
            }
        }
    }

    @Override
    public void checkProtocolSyntax(Hashtable data) {
        String protocol = (String)data.get("PROTOCOL");
        if (protocol != null) {
            Matcher match = this.protocolPattern.matcher(protocol);
            if (match.find()) {
                protocol = match.group(1);
                data.put("PROTOCOL", protocol);
            }
        } else {
            String l3Proto = (String)data.get("L3_PROTOCOL");
            if (l3Proto != null) {
                Object destPort = data.get("DEST_PORT");
                if (destPort != null) {
                    l3Proto = destPort.toString() + "/" + l3Proto;
                }
                data.put("PROTOCOL", l3Proto);
            }
        }
        super.checkProtocolSyntax(data);
    }

    private void handleTime(Hashtable data) {
        try {
            String dateFormat = (String)data.get("DATE_FORMAT");
            String dateString = (String)data.get("DATE_STRING");
            if (dateString != null && dateFormat != null) {
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                if (data.get("NO_YEAR") != null) {
                    GregorianCalendar cal = new GregorianCalendar();
                    int year = cal.get(1);
                    cal.setTime(sdf.parse(dateString));
                    cal.set(1, year);
                    data.put("TIME", new Timestamp(cal.getTime().getTime()));
                } else {
                    long time = sdf.parse(dateString).getTime();
                    Timestamp timeModified = new Timestamp(time);
                    data.put("TIME", timeModified);
                }
            } else {
                long currentTime = System.currentTimeMillis();
                Timestamp currentTimeModified = new Timestamp(currentTime);
                data.put("TIME", currentTimeModified);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

