/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.imp;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.FirewallConstants;
import com.adventnet.fa.server.FirewallLicenseManager;
import com.adventnet.fa.server.FirewallStatusNotifier;
import com.adventnet.fa.server.imp.DataArchiver;
import com.adventnet.la.util.EncryptionAPI;
import com.adventnet.la.util.pe.Record;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArchiveFile {
    private static final Logger LOGGER = Logger.getLogger(ArchiveFile.class.getName());
    private BufferedWriter writer = null;
    private String fileName = null;
    private Vector logBuffer = new Vector();
    private long fileLength = 0L;
    private static int lineSeparatorLength = 1;
    public static boolean archiveWrite = FirewallConstants.archiveWrite;
    private String fileId = null;
    private String hostName = null;
    private String dnsName = null;
    private String ipAddress = null;
    private EncryptionAPI encryptionObj = null;
    private boolean isEncryptedArchive = false;
    FirewallStatusNotifier statusNotifier = FirewallStatusNotifier.getInstance();

    public ArchiveFile(String host, String ipAddress) {
        try {
            if (FirewallConstants.isEncryptionEnabled()) {
                this.encryptionObj = EncryptionAPI.getEncryptionObj();
                this.isEncryptedArchive = true;
            }
            LOGGER.log(Level.INFO, "inside archive file creation...file name is->" + host + " ip is->" + ipAddress);
            this.assignArchiveFileName(host, ipAddress);
            this.writer = new BufferedWriter(new FileWriter(this.fileName));
            this.updatedb();
            LOGGER.log(Level.FINER, " New Archive File Opened for Writing =={0}", this.fileName);
        }
        catch (Exception ee) {
            LOGGER.log(Level.FINER, " Exception while creating file for host =={0}:: on{1}", new Object[]{host, this.fileName});
            ee.printStackTrace();
        }
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    private void updatedb() {
        try {
            DataObject dObject = DataAccess.constructDataObject();
            Row row = new Row("PathInfo");
            row.set("PATHVALUE", (Object)this.fileName);
            dObject.addRow(row);
            DataAccess.add((DataObject)dObject);
            this.fileId = row.get("PATHID").toString();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public String getFileId() {
        return this.fileId;
    }

    public void writeLog(Record record) {
        if (this.isEncryptedArchive) {
            String encryptedLog = this.encryptionObj.encryptLog(record.getData());
            this.logBuffer.add(encryptedLog);
            this.fileLength += (long)(encryptedLog.length() + 1);
        } else {
            this.logBuffer.add(record.getData());
            this.fileLength += (long)(record.getData().getBytes().length + lineSeparatorLength);
        }
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDNSName() {
        return this.dnsName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int logBufferSize() {
        return this.logBuffer.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushLogs() throws Exception {
        boolean isUnManaged = FirewallLicenseManager.getInstance().isUnManagedDevice(this.hostName);
        if (isUnManaged) {
            return;
        }
        Vector tempLogs = null;
        Vector vector = this.logBuffer;
        synchronized (vector) {
            tempLogs = this.logBuffer;
            this.logBuffer = new Vector();
        }
        this.writeInFile(tempLogs);
    }

    public void writeInFile(Vector recordList) throws Exception {
        try {
            for (Object recordObj : recordList) {
                if (this.isEncryptedArchive) {
                    this.writer.write((String)recordObj);
                    this.writer.write(EncryptionAPI.getLogDelimiter());
                    continue;
                }
                this.writer.write((String)recordObj);
                this.writer.newLine();
            }
            this.writer.flush();
            if (!archiveWrite) {
                archiveWrite = true;
                FirewallConstants.setArchiveWriteStatus(archiveWrite);
                this.updateSystemConfigurations("archivetrue");
            }
        }
        catch (ConcurrentModificationException exp) {
            throw exp;
        }
        catch (Exception eee) {
            if (eee instanceof IOException && archiveWrite) {
                archiveWrite = false;
                FirewallConstants.setArchiveWriteStatus(archiveWrite);
                this.updateSystemConfigurations("archivefalse");
            }
            LOGGER.log(Level.INFO, " Exeption while writing file {0}", this.fileName);
            eee.printStackTrace();
        }
    }

    private void assignArchiveFileName(String host, String ipAddress) {
        String dateString = null;
        Object newFileName = null;
        try {
            this.hostName = host;
            this.ipAddress = ipAddress;
            File directory = new File(DataArchiver.BASE_ARCHIVE_DIRECTORY + this.hostName);
            File hotDir = new File(directory.getAbsolutePath() + File.separator + DataArchiver.HOT_DIRECTORY_NAME);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if (!hotDir.exists()) {
                hotDir.mkdirs();
                new File(directory.getAbsolutePath() + File.separator + DataArchiver.COLD_DIRECTORY_NAME).mkdir();
                new File(directory.getAbsolutePath() + File.separator + DataArchiver.WARM_DIRECTORY_NAME).mkdir();
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
            dateString = format.format(new Date());
            String fileExtension = "";
            if (this.isEncryptedArchive) {
                fileExtension = ".enc";
            }
            this.fileName = hotDir.getAbsolutePath() + File.separator + dateString + fileExtension;
            this.fileLength = 0L;
            String header = FAServerUtil.getHeader(ipAddress);
            if (header != null) {
                Record rec = new Record(host, "1", header);
                this.writeLog(rec);
            }
        }
        catch (Exception ee) {
            LOGGER.log(Level.INFO, " Exeption while writing file {0}", (Object)newFileName);
            ee.printStackTrace();
        }
    }

    public void reopen(String hostName) {
        this.assignArchiveFileName(hostName, this.ipAddress);
        try {
            this.writer = new BufferedWriter(new FileWriter(this.fileName));
            this.updatedb();
        }
        catch (Exception ee) {
            LOGGER.log(Level.INFO, " Exeption while reopening file {0}", this.fileName);
            ee.printStackTrace();
        }
    }

    public void close() {
        try {
            try {
                this.flushLogs();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, " Concurrent modification Exeption while closing  file {0}", this.fileName);
            }
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception ee) {
            LOGGER.log(Level.INFO, " Exeption while closing file {0}", this.fileName);
            ee.printStackTrace();
        }
    }

    private void updateSystemConfigurations(String archParam) {
        String confName = "statusAlertConfig";
        String alertOptions = this.statusNotifier.getStatusConfigurations(confName);
        if (alertOptions != null && alertOptions.contains("archive")) {
            StringBuffer notifyOpt = new StringBuffer();
            StringTokenizer stoken = new StringTokenizer(alertOptions, ",");
            int count = stoken.countTokens();
            int i = 0;
            while (stoken.hasMoreTokens()) {
                ++i;
                String token = stoken.nextToken();
                if ((token = token.trim()).contains("archive") && !token.equals(archParam)) {
                    token = archParam;
                }
                notifyOpt.append(token);
                notifyOpt.append(",");
            }
            String notifyOptions = notifyOpt.toString();
            int index = notifyOptions.lastIndexOf(",");
            if (!alertOptions.equals(notifyOptions = notifyOptions.substring(0, index))) {
                try {
                    Criteria crit = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)confName, 0);
                    DataAccess.delete((Criteria)crit);
                    DataObject doo = DataAccess.constructDataObject();
                    Row row = new Row("SystemConfigurations");
                    row.set("CONF_NAME", (Object)confName);
                    row.set("CONF_VALUE", (Object)notifyOptions);
                    doo.addRow(row);
                    DataAccess.add((DataObject)doo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.statusNotifier.run();
        }
    }

    static {
        lineSeparatorLength = System.getProperty("line.separator").length();
    }
}

