/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.policyOptimization;

import com.adventnet.fa.server.policyOptimization.Repository;
import com.adventnet.fa.server.policyOptimization.SourceIP;
import com.adventnet.fa.server.policyOptimization.UniqueRule;
import com.adventnet.fa.server.policyOptimizationHelper.Helper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class Anomaly {
    LinkedHashMap<String, UniqueRule> nonanomaly;
    ArrayList<String> genList;
    ArrayList<String> remList;
    ArrayList<String> corList;
    ArrayList<String> bothList;
    ArrayList<String> tempgenList;
    ArrayList<String> tempremList;
    ArrayList<String> tempcorList;
    ArrayList<String> tempbothList;
    boolean unEven;
    boolean isCorrelated;
    String isRemovable;
    ThreadLocal<ArrayList<String>> anomalyBothList = new ThreadLocal<ArrayList<String>>(){

        @Override
        protected synchronized ArrayList<String> initialValue() {
            return new ArrayList<String>();
        }
    };
    static ThreadLocal<Anomaly> anomalyStore = new ThreadLocal<Anomaly>(){

        @Override
        protected synchronized Anomaly initialValue() {
            return new Anomaly();
        }
    };

    public void clearMemory() {
        this.genList.clear();
        this.remList.clear();
        this.corList.clear();
        this.bothList.clear();
        this.tempgenList.clear();
        this.tempremList.clear();
        this.tempcorList.clear();
        this.tempbothList.clear();
        this.nonanomaly = null;
        this.isRemovable = null;
        this.isCorrelated = false;
        this.unEven = false;
        this.isRemovable = "no";
    }

    private Anomaly() {
        this.initValues();
    }

    public void initValues() {
        this.genList = new ArrayList();
        this.remList = new ArrayList();
        this.corList = new ArrayList();
        this.bothList = new ArrayList();
        this.tempgenList = new ArrayList();
        this.tempremList = new ArrayList();
        this.tempcorList = new ArrayList();
        this.tempbothList = new ArrayList();
        this.isCorrelated = false;
        this.unEven = false;
        this.isRemovable = "no";
    }

    public String isAnomaly(String[] val, Repository repo) {
        String[] cloneVal = (String[])val.clone();
        LinkedHashMap<String, SourceIP> db = repo.repoDBStore.get();
        this.nonanomaly = (LinkedHashMap)repo.repoNonAnomalyStore.get().clone();
        String res = this.isProtocolAnomaly(db, val);
        if (res == null) {
            this.clearMemory();
            return null;
        }
        ArrayList temp = this.cloneArrayList();
        this.clear();
        res = this.isSrcIpAnomaly(db, val, temp);
        if (res == null) {
            this.clearMemory();
            return null;
        }
        this.removeDuplicate();
        val = (String[])cloneVal.clone();
        temp = this.cloneArrayList();
        this.clear();
        res = this.isSrcPortAnomaly(db, val, temp);
        if (res == null) {
            this.clearMemory();
            return null;
        }
        this.removeDuplicate();
        val = (String[])cloneVal.clone();
        temp = this.cloneArrayList();
        this.clear();
        res = this.isDestIpAnomaly(db, val, temp);
        if (res == null) {
            this.clearMemory();
            return null;
        }
        this.removeDuplicate();
        val = (String[])cloneVal.clone();
        temp = this.cloneArrayList();
        this.clear();
        res = this.isDestPortAnomaly(db, val, temp);
        if (res == null) {
            this.clearMemory();
            return null;
        }
        this.remList.addAll(this.bothList);
        this.removeDuplicate();
        if (!this.remList.isEmpty()) {
            this.isRemovable = "yes";
        }
        return this.isRemovable;
    }

    private String isProtocolAnomaly(LinkedHashMap<String, SourceIP> db, String[] values) {
        String result = null;
        if (db.containsKey("all")) {
            this.remList.add("all");
            result = "Success";
        }
        if (db.containsKey(values[4])) {
            this.bothList.add(values[4]);
            result = "Success";
            if (values[4].equals("all")) {
                this.remList.clear();
                this.genList.addAll(db.keySet());
                this.genList.remove("all");
            }
        } else if (values[4].equals("all")) {
            this.genList.addAll(db.keySet());
            result = "Success";
        }
        return result;
    }

    private String isDestIpAnomaly(LinkedHashMap<String, SourceIP> db, String[] values, ArrayList<ArrayList<String>> list) {
        String res = "";
        if (values[3].contains(",")) {
            String[] ips;
            ArrayList<ArrayList<String>> finalList = this.createArrayList();
            boolean result = false;
            String[] arr$ = ips = values[3].split(",");
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String singleIp;
                values[3] = singleIp = arr$[i$];
                res = this.singleDestIpAnomaly(db, values, list);
                if (res != null) {
                    finalList = this.appendList(finalList);
                    this.clear();
                    result = true;
                    continue;
                }
                this.unEven = true;
            }
            if (result) {
                this.moveToOriginalList(finalList);
                res = "Success";
            } else {
                res = null;
            }
        } else {
            res = this.singleDestIpAnomaly(db, values, list);
        }
        if (res == null) {
            return res;
        }
        return res;
    }

    private String singleDestIpAnomaly(LinkedHashMap<String, SourceIP> db, String[] values, ArrayList<ArrayList<String>> list) {
        int count = 1;
        ArrayList<String> details = new ArrayList<String>();
        details.add("destIp");
        details.add(values[3]);
        for (ArrayList<String> temp : list) {
            if (!temp.isEmpty()) {
                this.subsetUpdate(db, details, temp, count);
            }
            ++count;
        }
        if (this.bothList.isEmpty() && this.remList.isEmpty() && this.genList.isEmpty() && this.corList.isEmpty()) {
            return null;
        }
        return "Success";
    }

    private String isSrcIpAnomaly(LinkedHashMap<String, SourceIP> db, String[] values, ArrayList<ArrayList<String>> list) {
        String res = "";
        if (values[2].contains(",")) {
            String[] ips;
            ArrayList<ArrayList<String>> finalList = this.createArrayList();
            boolean result = false;
            String[] arr$ = ips = values[2].split(",");
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String singleIp;
                values[2] = singleIp = arr$[i$];
                res = this.singleSrcIpAnomaly(db, values, list);
                if (res != null) {
                    finalList = this.appendList(finalList);
                    this.clear();
                    result = true;
                    continue;
                }
                this.unEven = true;
            }
            if (result) {
                this.moveToOriginalList(finalList);
                res = "Success";
            } else {
                res = null;
            }
        } else {
            res = this.singleSrcIpAnomaly(db, values, list);
        }
        if (res == null) {
            return res;
        }
        return res;
    }

    private String singleSrcIpAnomaly(LinkedHashMap<String, SourceIP> db, String[] values, ArrayList<ArrayList<String>> list) {
        int count = 1;
        ArrayList<String> details = new ArrayList<String>();
        details.add("srcIp");
        details.add(values[2]);
        for (ArrayList<String> temp : list) {
            if (!temp.isEmpty()) {
                this.subsetUpdate(db, details, temp, count);
            }
            ++count;
        }
        if (this.bothList.isEmpty() && this.remList.isEmpty() && this.genList.isEmpty() && this.corList.isEmpty()) {
            return null;
        }
        return "Success";
    }

    private String isSrcPortAnomaly(LinkedHashMap<String, SourceIP> db, String[] values, ArrayList<ArrayList<String>> list) {
        String res = "";
        if (values[6].contains(",")) {
            String[] ports;
            ArrayList<ArrayList<String>> finalList = this.createArrayList();
            boolean result = false;
            String[] arr$ = ports = values[6].split(",");
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String singlePort;
                values[6] = singlePort = arr$[i$];
                res = this.singleSrcPortAnomaly(db, values, list);
                if (res != null) {
                    finalList = this.appendList(finalList);
                    this.clear();
                    result = true;
                    continue;
                }
                this.unEven = true;
            }
            if (result) {
                this.moveToOriginalList(finalList);
                res = "Success";
            } else {
                res = null;
            }
        } else {
            res = this.singleSrcPortAnomaly(db, values, list);
        }
        if (res == null) {
            return res;
        }
        return res;
    }

    private String singleSrcPortAnomaly(LinkedHashMap<String, SourceIP> db, String[] values, ArrayList<ArrayList<String>> list) {
        int count = 1;
        ArrayList<String> details = new ArrayList<String>();
        details.add("srcPort");
        details.add(values[6]);
        for (ArrayList<String> temp : list) {
            if (!temp.isEmpty()) {
                this.subsetUpdate(db, details, temp, count);
            }
            ++count;
        }
        if (this.bothList.isEmpty() && this.remList.isEmpty() && this.genList.isEmpty() && this.corList.isEmpty()) {
            return null;
        }
        return "Success";
    }

    private String isDestPortAnomaly(LinkedHashMap<String, SourceIP> db, String[] values, ArrayList<ArrayList<String>> list) {
        String res = "";
        if (values[5].contains(",")) {
            String[] destPort;
            ArrayList<ArrayList<String>> finalList = this.createArrayList();
            boolean result = false;
            String[] arr$ = destPort = values[5].split(",");
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String singlePort;
                values[5] = singlePort = arr$[i$];
                res = this.singleDestPortAnomaly(db, values, list);
                if (res != null) {
                    finalList = this.appendList(finalList);
                    this.clear();
                    result = true;
                    continue;
                }
                this.unEven = true;
            }
            if (result) {
                this.moveToOriginalList(finalList);
                res = "Success";
            } else {
                res = null;
            }
        } else {
            res = this.singleDestPortAnomaly(db, values, list);
        }
        if (res == null) {
            return res;
        }
        return res;
    }

    private String singleDestPortAnomaly(LinkedHashMap<String, SourceIP> db, String[] values, ArrayList<ArrayList<String>> list) {
        int count = 1;
        for (ArrayList<String> temp : list) {
            if (!temp.isEmpty()) {
                this.isDestPortSubset(db, values[5], temp, count);
            }
            ++count;
        }
        if (this.bothList.isEmpty() && this.remList.isEmpty() && this.genList.isEmpty() && this.corList.isEmpty()) {
            return null;
        }
        return "Success";
    }

    private ArrayList<ArrayList<String>> createArrayList() {
        ArrayList<ArrayList<String>> finalList = new ArrayList<ArrayList<String>>();
        ArrayList newBoth = new ArrayList();
        ArrayList newRem = new ArrayList();
        ArrayList newGen = new ArrayList();
        ArrayList newCor = new ArrayList();
        finalList.add(newBoth);
        finalList.add(newRem);
        finalList.add(newGen);
        finalList.add(newCor);
        return finalList;
    }

    private ArrayList<ArrayList<String>> appendList(ArrayList<ArrayList<String>> list) {
        ArrayList<Object> temp = new ArrayList();
        ArrayList<String> arrayList = list.get(0);
        temp = arrayList;
        temp.addAll(this.bothList);
        list.set(0, temp);
        temp = list.get(1);
        temp.addAll(this.remList);
        list.set(1, temp);
        temp = list.get(2);
        temp.addAll(this.genList);
        list.set(2, temp);
        temp = list.get(3);
        temp.addAll(this.corList);
        list.set(3, temp);
        return list;
    }

    private void moveToOriginalList(ArrayList<ArrayList<String>> finalList) {
        this.bothList.addAll((Collection<String>)finalList.get(0));
        this.remList.addAll((Collection<String>)finalList.get(1));
        this.genList.addAll((Collection<String>)finalList.get(2));
        this.corList.addAll((Collection<String>)finalList.get(3));
    }

    private void isDestPortSubset(LinkedHashMap<String, SourceIP> db, String value, ArrayList<String> temp, int type) {
        for (int i = 0; i < temp.size(); ++i) {
            int k;
            String[] arr = temp.get(i).split("#");
            LinkedHashMap<String, ArrayList> tempDestPortMap = db.get((Object)arr[0]).sourceIPMap.get((Object)arr[1]).srcPortMap.get((Object)arr[2]).destMap.get((Object)arr[3]).destPortMap;
            String res = this.isSubsetIp(tempDestPortMap, value);
            if (res == null) continue;
            if (this.unEven) {
                if (!this.tempbothList.isEmpty()) {
                    type = 3;
                }
                if (!this.tempremList.isEmpty()) {
                    type = 4;
                    this.isCorrelated = true;
                }
            }
            if (this.isCorrelated) {
                type = 4;
            }
            if (type == 1 && !this.tempbothList.isEmpty()) {
                for (k = 0; k < this.tempbothList.size(); ++k) {
                    this.bothList.add(temp.get(i) + "#" + this.tempbothList.get(0) + "#" + tempDestPortMap.get(this.tempbothList.get(0)).get(0));
                    if (!tempDestPortMap.containsKey("all")) continue;
                    this.bothList.add(temp.get(i) + "#" + this.tempbothList.get(0) + "#" + tempDestPortMap.get("all").get(0));
                }
            }
            if (type == 2 && !this.tempbothList.isEmpty()) {
                for (k = 0; k < this.tempbothList.size(); ++k) {
                    this.remList.add(temp.get(i) + "#" + this.tempbothList.get(0) + "#" + tempDestPortMap.get(this.tempbothList.get(0)).get(0));
                    if (!tempDestPortMap.containsKey("all")) continue;
                    this.remList.add(temp.get(i) + "#" + this.tempbothList.get(0) + "#" + tempDestPortMap.get("all").get(0));
                }
            }
            if (type == 3 && !this.tempbothList.isEmpty()) {
                for (k = 0; k < this.tempbothList.size(); ++k) {
                    this.genList.add(temp.get(i) + "#" + this.tempbothList.get(0) + "#" + tempDestPortMap.get(this.tempbothList.get(0)).get(0));
                    if (!tempDestPortMap.containsKey("all")) continue;
                    this.genList.add(temp.get(i) + "#" + this.tempbothList.get(0) + "#" + tempDestPortMap.get("all").get(0));
                }
            }
            if (!(type != 1 && type != 2 || this.tempremList.isEmpty())) {
                for (k = 0; k < this.tempremList.size(); ++k) {
                    this.remList.add(temp.get(i) + "#" + this.tempremList.get(0) + "#" + tempDestPortMap.get(this.tempremList.get(0)).get(0));
                    if (!tempDestPortMap.containsKey("all")) continue;
                    this.remList.add(temp.get(i) + "#" + this.tempremList.get(0) + "#" + tempDestPortMap.get("all").get(0));
                }
            }
            if (!(type != 1 && type != 3 || this.tempgenList.isEmpty())) {
                for (k = 0; k < this.tempgenList.size(); ++k) {
                    this.genList.add(temp.get(i) + "#" + this.tempgenList.get(0) + "#" + tempDestPortMap.get(this.tempgenList.get(0)).get(0));
                    if (!tempDestPortMap.containsKey("all")) continue;
                    this.genList.add(temp.get(i) + "#" + this.tempgenList.get(0) + "#" + tempDestPortMap.get("all").get(0));
                }
            }
            if (type == 4 && !this.tempbothList.isEmpty()) {
                for (k = 0; k < this.tempbothList.size(); ++k) {
                    this.corList.add(temp.get(i) + "#" + this.tempbothList.get(0) + "#" + tempDestPortMap.get(this.tempbothList.get(0)).get(0));
                    if (!tempDestPortMap.containsKey("all")) continue;
                    this.corList.add(temp.get(i) + "#" + this.tempbothList.get(0) + "#" + tempDestPortMap.get("all").get(0));
                }
            }
            if (!(type != 2 && type != 4 || this.tempgenList.isEmpty())) {
                for (k = 0; k < this.tempgenList.size(); ++k) {
                    this.corList.add(temp.get(i) + "#" + this.tempgenList.get(0) + "#" + tempDestPortMap.get(this.tempgenList.get(0)).get(0));
                    if (!tempDestPortMap.containsKey("all")) continue;
                    this.corList.add(temp.get(i) + "#" + this.tempgenList.get(0) + "#" + tempDestPortMap.get("all").get(0));
                }
            }
            if (!(type != 3 && type != 4 || this.tempremList.isEmpty())) {
                for (k = 0; k < this.tempremList.size(); ++k) {
                    this.corList.add(temp.get(i) + "#" + this.tempremList.get(0) + "#" + tempDestPortMap.get(this.tempremList.get(0)).get(0));
                    if (!tempDestPortMap.containsKey("all")) continue;
                    this.corList.add(temp.get(i) + "#" + this.tempremList.get(0) + "#" + tempDestPortMap.get("all").get(0));
                }
            }
            if (!this.tempcorList.isEmpty()) {
                for (k = 0; k < this.tempcorList.size(); ++k) {
                    this.corList.add(temp.get(i) + "#" + this.tempcorList.get(0) + "#" + tempDestPortMap.get(this.tempcorList.get(0)).get(0));
                    if (!tempDestPortMap.containsKey("all")) continue;
                    this.corList.add(temp.get(i) + "#" + this.tempcorList.get(0) + "#" + tempDestPortMap.get("all").get(0));
                }
            }
            this.tempClear();
        }
    }

    private void subsetUpdate(LinkedHashMap<String, SourceIP> db, ArrayList<String> details, ArrayList<String> temp, int type) {
        for (int i = 0; i < temp.size(); ++i) {
            int k;
            String[] arr = temp.get(i).split("#");
            String res = null;
            if (details.get(0).equals("srcIp")) {
                res = this.isSubsetIp(db.get((Object)temp.get((int)i)).sourceIPMap, details.get(1));
            }
            if (details.get(0).equals("srcPort")) {
                res = this.isSubsetIp(db.get((Object)arr[0]).sourceIPMap.get((Object)arr[1]).srcPortMap, details.get(1));
            }
            if (details.get(0).equals("destIp")) {
                res = this.isSubsetIp(db.get((Object)arr[0]).sourceIPMap.get((Object)arr[1]).srcPortMap.get((Object)arr[2]).destMap, details.get(1));
            }
            if (res == null) continue;
            if (this.unEven) {
                if (!this.tempbothList.isEmpty()) {
                    type = 3;
                }
                if (!this.tempremList.isEmpty()) {
                    type = 4;
                    this.isCorrelated = true;
                }
            }
            if (type == 1 && !this.tempbothList.isEmpty()) {
                for (k = 0; k < this.tempbothList.size(); ++k) {
                    this.bothList.add(temp.get(i) + "#" + this.tempbothList.get(k));
                }
            }
            if (type == 2 && !this.tempbothList.isEmpty()) {
                for (k = 0; k < this.tempbothList.size(); ++k) {
                    this.remList.add(temp.get(i) + "#" + this.tempbothList.get(k));
                }
            }
            if (type == 3 && !this.tempbothList.isEmpty()) {
                for (k = 0; k < this.tempbothList.size(); ++k) {
                    this.genList.add(temp.get(i) + "#" + this.tempbothList.get(k));
                }
            }
            if (!(type != 1 && type != 2 || this.tempremList.isEmpty())) {
                for (k = 0; k < this.tempremList.size(); ++k) {
                    this.remList.add(temp.get(i) + "#" + this.tempremList.get(k));
                }
            }
            if (!(type != 1 && type != 3 || this.tempgenList.isEmpty())) {
                for (k = 0; k < this.tempgenList.size(); ++k) {
                    this.genList.add(temp.get(i) + "#" + this.tempgenList.get(k));
                }
            }
            if (type == 4 && !this.tempbothList.isEmpty()) {
                for (k = 0; k < this.tempbothList.size(); ++k) {
                    this.corList.add(temp.get(i) + "#" + this.tempbothList.get(k));
                }
            }
            if (!(type != 2 && type != 4 || this.tempgenList.isEmpty())) {
                for (k = 0; k < this.tempgenList.size(); ++k) {
                    this.corList.add(temp.get(i) + "#" + this.tempgenList.get(k));
                }
            }
            if (!(type != 3 && type != 4 || this.tempremList.isEmpty())) {
                for (k = 0; k < this.tempremList.size(); ++k) {
                    this.corList.add(temp.get(i) + "#" + this.tempremList.get(k));
                }
            }
            if (!this.tempcorList.isEmpty()) {
                for (k = 0; k < this.tempcorList.size(); ++k) {
                    this.corList.add(temp.get(i) + "#" + this.tempcorList.get(k));
                }
            }
            this.tempClear();
        }
    }

    public String isSubsetPort(LinkedHashMap map, String port) {
        Iterator i = map.entrySet().iterator();
        boolean flag = false;
        boolean isString = this.isString(port);
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String key = (String)e.getKey();
            if (isString || this.isString(key)) {
                if (key.equals(port)) {
                    this.tempbothList.add(key);
                    flag = true;
                    continue;
                }
                if (port.equals("all")) {
                    this.tempgenList.add(key);
                    flag = true;
                    continue;
                }
                if (!port.equals("all")) continue;
                this.tempremList.add(key);
                flag = true;
                continue;
            }
            if (isString || this.isString(key)) continue;
            if (key.equals(port)) {
                this.tempbothList.add(key);
                flag = true;
                continue;
            }
            if (this.isContain(port, key, "1")) {
                this.tempgenList.add(key);
                flag = true;
                continue;
            }
            if (this.isContain(key, port, "1")) {
                this.tempremList.add(key);
                flag = true;
                continue;
            }
            if (!this.isCorrelated(key, port)) continue;
            this.tempcorList.add(key);
            flag = true;
        }
        if (!flag) {
            return null;
        }
        return "Success";
    }

    String valueAllCase(LinkedHashMap map, String ip) {
        Iterator i = map.entrySet().iterator();
        Map.Entry e = i.next();
        String key = (String)e.getKey();
        if (key.equals(ip)) {
            this.tempbothList.add(key);
        } else {
            this.tempgenList.add(key);
        }
        while (i.hasNext()) {
            e = i.next();
            key = (String)e.getKey();
            this.tempgenList.add(key);
        }
        return "Success";
    }

    public boolean keyAllChecking(String key, String ip) {
        boolean flag = false;
        if (key.equals("all")) {
            this.tempremList.add(key);
            flag = true;
        } else if (key.equals(ip)) {
            this.tempbothList.add(key);
            flag = true;
        } else if (this.isInitial(ip, key)) {
            if (this.isContain(ip, key, "1")) {
                this.tempgenList.add(key);
                flag = true;
            } else if (this.isContain(key, ip, "1")) {
                this.tempremList.add(key);
                flag = true;
            } else if (this.isCorrelated(key, ip)) {
                this.tempcorList.add(key);
                flag = true;
            }
        }
        return flag;
    }

    public String isSubsetIp(LinkedHashMap map, String ip) {
        if (ip.equals("all")) {
            return this.valueAllCase(map, ip);
        }
        if (!this.isPossible(map, ip)) {
            return null;
        }
        boolean flag = false;
        boolean breakPoint = false;
        boolean block = false;
        Iterator i = map.entrySet().iterator();
        Map.Entry e = i.next();
        String key = (String)e.getKey();
        flag = this.keyAllChecking(key, ip);
        if (flag && !this.tempremList.isEmpty()) {
            block = true;
        }
        while (i.hasNext()) {
            e = i.next();
            key = (String)e.getKey();
            if (key.equals(ip)) {
                this.tempbothList.add(key);
                flag = true;
                continue;
            }
            if (!block && !this.isInitial(ip, key)) continue;
            block = true;
            if (this.isFinal(ip, key)) break;
            if (this.isContain(ip, key, "1")) {
                this.tempgenList.add(key);
                flag = true;
                continue;
            }
            if (this.isContain(key, ip, "1")) {
                this.tempremList.add(key);
                flag = true;
                continue;
            }
            if (!this.isCorrelated(key, ip)) continue;
            this.tempcorList.add(key);
            flag = true;
        }
        if (!flag) {
            return null;
        }
        return "Success";
    }

    boolean isFinal(String value, String key) {
        return Long.valueOf(key.split("-")[0]) > Long.valueOf(value.split("-")[1]);
    }

    boolean isInitial(String value, String key) {
        return Long.valueOf(key.split("-")[1]) >= Long.valueOf(value.split("-")[0]);
    }

    boolean isPossible(LinkedHashMap map, String value) {
        if (map.containsKey("all")) {
            return true;
        }
        ArrayList keySet = new ArrayList(map.keySet());
        String mapKey = ((String)keySet.get(0)).split("-")[0] + "-" + ((String)keySet.get(keySet.size() - 1)).split("-")[1];
        return this.isCorrelated(mapKey, value) || this.isCorrelated(value, mapKey);
    }

    private boolean isCorrelated(String ip1, String ip2) {
        if (ip1.contains("all") || ip2.contains("all")) {
            return true;
        }
        return this.isContain(ip1, ip2, "2");
    }

    private boolean isContain(String oldValue, String newValue, String type) {
        if (oldValue.equals("all")) {
            return true;
        }
        if (newValue.equals("all")) {
            return false;
        }
        long min1 = Long.valueOf(oldValue.split("-")[0]);
        long max1 = Long.valueOf(oldValue.split("-")[1]);
        long min2 = Long.valueOf(newValue.split("-")[0]);
        long max2 = Long.valueOf(newValue.split("-")[1]);
        if (type.equals("1")) {
            return min1 <= min2 && max1 >= max2;
        }
        return min1 <= min2 && min2 <= max1 || min1 <= max2 && max2 <= max1;
    }

    private void clear() {
        this.remList.clear();
        this.bothList.clear();
        this.corList.clear();
        this.genList.clear();
    }

    private void tempClear() {
        this.tempbothList.clear();
        this.tempgenList.clear();
        this.tempremList.clear();
        this.tempcorList.clear();
    }

    private void removeDuplicate() {
        this.bothList = this.removeIndividual(this.bothList);
        this.remList = this.removeIndividual(this.remList);
        this.genList = this.removeIndividual(this.genList);
        this.corList = this.removeIndividual(this.corList);
    }

    private ArrayList<String> removeIndividual(ArrayList<String> list) {
        HashSet<String> duplicate = new HashSet<String>(list);
        list.clear();
        list.addAll(duplicate);
        return list;
    }

    private ArrayList cloneArrayList() {
        ArrayList<ArrayList> cloneFinal = new ArrayList<ArrayList>();
        ArrayList cloneBoth = (ArrayList)this.bothList.clone();
        ArrayList cloneRem = (ArrayList)this.remList.clone();
        ArrayList cloneGen = (ArrayList)this.genList.clone();
        ArrayList cloneCor = (ArrayList)this.corList.clone();
        cloneFinal.add(cloneBoth);
        cloneFinal.add(cloneRem);
        cloneFinal.add(cloneGen);
        cloneFinal.add(cloneCor);
        return cloneFinal;
    }

    boolean isString(String value) {
        if (value.contains("-")) {
            return false;
        }
        return !value.matches("\\d+");
    }

    public String isExactRule(ArrayList<String> list, String[] values, int method) {
        TreeSet<String> action = new TreeSet<String>();
        values[7] = values[7].trim();
        TreeSet<String> finalList = new TreeSet<String>();
        HashSet<String> processSet = new HashSet<String>();
        for (String rules : list) {
            processSet.addAll(Arrays.asList(rules.split("#")[5].split(",")));
        }
        String result = null;
        for (String ruleID : processSet) {
            result = this.isNotDisjoint(ruleID, values);
            if (result == null) continue;
            action.add(values[7]);
            action.add(result);
            if (action.size() == 2 && action.contains("deny")) {
                finalList.add(ruleID + "@Correlation");
            } else {
                this.updateGrouping(values[0], values[7].trim(), ruleID);
            }
            action.clear();
        }
        if (finalList.isEmpty()) {
            return null;
        }
        String res = Helper.getInstance().join(finalList, " and ");
        return res;
    }

    public String isExactEntireRule(ArrayList<String> list, String[] values, int method) {
        String listString = "";
        TreeSet<String> action = new TreeSet<String>();
        action.add(values[7].trim());
        TreeSet<String> finalList = new TreeSet<String>();
        boolean isCor = false;
        HashSet<String> processSet = new HashSet<String>();
        for (String rules : list) {
            listString = "";
            String ruleID = rules.split("#")[5];
            if (processSet.contains(ruleID)) continue;
            processSet.add(ruleID);
            String result = "";
            boolean isContainsComma = false;
            if (ruleID.contains(",")) {
                isContainsComma = true;
                for (String splitRule : ruleID.split(",")) {
                    result = this.isNotDisjoint(splitRule, values);
                    if (result == null) continue;
                    listString = listString + "," + splitRule;
                    action.add(result);
                }
                if ((listString = listString.substring(1, listString.length())).contains(",")) {
                    boolean splCase = false;
                    String[] allRules = listString.split(",");
                    listString = "";
                    for (String singleRule : allRules) {
                        result = this.isExactRule(singleRule, values, method);
                        if (result != null) {
                            String type = this.getAnomalyType(singleRule, values[7], method);
                            finalList.add(singleRule + "@" + type);
                            splCase = true;
                            continue;
                        }
                        listString = listString + "," + singleRule;
                    }
                    if (!listString.equals("")) {
                        if (!(listString = listString.substring(1, listString.length())).contains(",")) {
                            isContainsComma = false;
                            rules = rules.replace(ruleID, listString);
                            ruleID = listString;
                            listString = "";
                        } else if (this.specialExactRule(listString, values, method)) {
                            if (splCase) {
                                action.clear();
                                action.add(values[7]);
                                for (String r : listString.split(",")) {
                                    UniqueRule uni = this.nonanomaly.get(r);
                                    action.add(uni.condn);
                                }
                            }
                            action.add(values[7]);
                        } else {
                            isCor = true;
                            this.corList.add(rules.replace(ruleID, listString));
                            listString = "";
                        }
                    }
                } else {
                    isContainsComma = false;
                    rules = rules.replace(ruleID, listString);
                    ruleID = listString;
                    listString = "";
                }
            }
            if (!isContainsComma) {
                result = this.isExactRule(ruleID, values, method);
                if (result != null) {
                    listString = ruleID;
                    action.add(result);
                } else {
                    isCor = true;
                    this.corList.add(rules);
                }
            }
            String type = null;
            if (!listString.equals("")) {
                type = action.size() == 2 && action.contains("deny") ? (method == 1 ? "Shadow" : "Generalization") : (method == 1 ? "Redundancy" : "Reverse");
            }
            action.clear();
            action.add(values[7].trim());
            if (type == null) continue;
            listString = listString.trim() + "@" + type;
            finalList.add(listString.trim());
        }
        if (isCor) {
            this.removeDuplicate();
        }
        if (finalList.isEmpty()) {
            return null;
        }
        String res = Helper.getInstance().join(finalList, " and ");
        return res;
    }

    private String getAnomalyType(String rule, String currentAction, int method) {
        UniqueRule unique = this.nonanomaly.get(rule);
        TreeSet<String> actions = new TreeSet<String>();
        actions.add(currentAction);
        actions.add(unique.condn);
        if (actions.size() == 2 && actions.contains("deny")) {
            if (method == 1) {
                return "Shadow";
            }
            return "Generalization";
        }
        if (method == 1) {
            return "Redundancy";
        }
        return "Reverse";
    }

    private boolean specialExactRule(String rules, String[] values, int method) {
        StringBuilder srcIp = new StringBuilder();
        StringBuilder destIp = new StringBuilder();
        TreeSet<String> service = new TreeSet<String>();
        for (String rule : rules.split(",")) {
            UniqueRule unique = this.nonanomaly.get(rule);
            srcIp.append(unique.src_ip);
            srcIp.append(",");
            destIp.append(unique.dest_ip);
            destIp.append(",");
            for (String s : unique.portInfo.split("&&")) {
                service.add(s);
            }
        }
        Helper helper = Helper.getInstance();
        String source = helper.toGroupIPInstance(srcIp.substring(0, srcIp.length() - 1));
        String destination = helper.toGroupIPInstance(destIp.substring(0, destIp.length() - 1));
        ArrayList<ArrayList> services = helper.toGroupServicesInstance(service);
        return method == 1 ? this.containsALLRule(source, values[2]) && this.containsALLRule(destination, values[3]) && this.containServiceRem(services, values) : (method == 2 ? this.containsALLRule(values[2], source) && this.containsALLRule(values[3], destination) && this.containService(values, services) : this.isCorrelatedIp(source, values[2]) && this.isCorrelatedIp(destination, values[3]) && this.isCorrelatedService(services, values));
    }

    private String isNotDisjoint(String rule, String[] values) {
        if (!this.nonanomaly.containsKey(rule)) {
            return null;
        }
        UniqueRule unique = this.nonanomaly.get(rule);
        if (!this.canGoFurther(unique.src_ip, values[2])) {
            return null;
        }
        if (!this.canGoFurther(unique.dest_ip, values[3])) {
            return null;
        }
        if (!this.canGoService(unique.service, values)) {
            return null;
        }
        if (this.isCorrelatedIp(unique.src_ip, values[2]) && this.isCorrelatedIp(unique.dest_ip, values[3]) && this.isCorrelatedService(unique.service, values)) {
            return unique.condn;
        }
        return null;
    }

    private boolean canGoService(ArrayList<ArrayList> newService, String[] values) {
        for (ArrayList tempNew : newService) {
            if (!((String)tempNew.get(0)).equals("all") && !values[4].equals("all") && !values[4].equals(tempNew.get(0)) || !this.canGoFurther((String)tempNew.get(1), values[5]) || !this.canGoFurther((String)tempNew.get(2), values[6])) continue;
            return true;
        }
        return false;
    }

    boolean canGoFurther(String value1, String value2) {
        if ("all".equals(value1) || "all".equals(value2)) {
            return true;
        }
        if (value1.contains(",")) {
            String[] splitValue1 = value1.split(",");
            value1 = splitValue1[0].split("-")[0] + "-" + splitValue1[splitValue1.length - 1].split("-")[1];
        }
        if (value2.contains(",")) {
            String[] splitValue2 = value2.split(",");
            value2 = splitValue2[0].split("-")[0] + "-" + splitValue2[splitValue2.length - 1].split("-")[1];
        }
        return this.isCorrelated(value1, value2) || this.isCorrelated(value2, value1);
    }

    private void updateGrouping(String currentRule, String action, String rules) {
        Repository repo = Repository.getInstance();
        TreeMap<String, String> groupList = new TreeMap<String, String>();
        if (repo.repoGroupingMapStore.get().containsKey(rules)) {
            String oldActions = repo.repoGroupingMapStore.get().get(rules);
            repo.repoGroupingMapStore.get().remove(rules);
            repo.repoGroupingMapStore.get().put(rules + "," + currentRule, oldActions + "," + action);
        } else {
            for (String rule : rules.split(",")) {
                UniqueRule unique = this.nonanomaly.get(rule);
                groupList.put(rule, unique.condn);
            }
            groupList.put(currentRule, action);
            Iterator itr = groupList.entrySet().iterator();
            Map.Entry entry = itr.next();
            String groupedRule = (String)entry.getKey();
            String groupedStatus = (String)entry.getValue();
            while (itr.hasNext()) {
                entry = itr.next();
                groupedRule = groupedRule + "," + (String)entry.getKey();
                groupedStatus = groupedStatus + "," + (String)entry.getValue();
            }
            repo.repoGroupingMapStore.get().put(groupedRule, groupedStatus);
        }
    }

    private String isExactRule(String rule, String[] values, int method) {
        if (!this.nonanomaly.containsKey(rule)) {
            return values[7];
        }
        UniqueRule unique = this.nonanomaly.get(rule);
        if (method == 1 ? this.containsALLRule(unique.src_ip, values[2]) && this.containsALLRule(unique.dest_ip, values[3]) && this.containServiceRem(unique.service, values) : (method == 2 ? this.containsALLRule(values[2], unique.src_ip) && this.containsALLRule(values[3], unique.dest_ip) && this.containService(values, unique.service) : this.isCorrelatedIp(unique.src_ip, values[2]) && this.isCorrelatedIp(unique.dest_ip, values[3]) && this.isCorrelatedService(unique.service, values))) {
            return unique.condn;
        }
        return null;
    }

    private boolean isCorrelatedService(ArrayList<ArrayList> newService, String[] values) {
        for (ArrayList tempNew : newService) {
            if (!((String)tempNew.get(0)).equals("all") && !values[4].equals("all") && !values[4].equals(tempNew.get(0)) || !this.isCorrelatedIp((String)tempNew.get(1), values[5]) || !this.isCorrelatedIp((String)tempNew.get(2), values[6])) continue;
            return true;
        }
        return false;
    }

    private boolean isCorrelatedIp(String oldValues, String newValues) {
        if (oldValues.contains(",") || newValues.contains(",")) {
            for (String oldValue : oldValues.split(",")) {
                for (String newValue : newValues.split(",")) {
                    if (!this.isCorrelatedIp(oldValue, newValue)) continue;
                    return true;
                }
            }
        } else {
            if (oldValues.equals("all") || newValues.equals("all")) {
                return true;
            }
            if (oldValues.equals(newValues)) {
                return true;
            }
            return this.isContain(oldValues, newValues, "2") || this.isContain(newValues, oldValues, "2");
        }
        return false;
    }

    private boolean containsALLRule(String valueOne, String valueTwo) {
        if (valueOne.equals("all")) {
            return true;
        }
        if (valueTwo.equals("all")) {
            return false;
        }
        boolean flag = false;
        boolean res = false;
        for (String str2 : valueTwo.split(",")) {
            flag = false;
            for (String str1 : valueOne.split(",")) {
                if (flag) continue;
                flag = str1.equals(str2) ? true : this.isContain(str1, str2, "1");
            }
            if (!flag) {
                return false;
            }
            res = true;
        }
        return res;
    }

    private boolean containServiceRem(ArrayList<ArrayList> newService, String[] values) {
        for (ArrayList tempNew : newService) {
            if (!((String)tempNew.get(0)).equals("all") && !values[4].equals(tempNew.get(0)) || !this.containsALLRule((String)tempNew.get(1), values[5]) || !this.containsALLRule((String)tempNew.get(2), values[6])) continue;
            return true;
        }
        return false;
    }

    private boolean containService(String[] values, ArrayList<ArrayList> oldService) {
        for (ArrayList tempOld : oldService) {
            if (!values[4].equals("all") && !values[4].equals(tempOld.get(0)) || !this.containsALLRule(values[5], (String)tempOld.get(1)) || !this.containsALLRule(values[6], (String)tempOld.get(2))) continue;
            return true;
        }
        return false;
    }
}

