/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.policyOptimizationHelper;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.la.util.ResourceCheckerUtil;
import com.adventnet.la.util.ServerUtil;
import com.adventnet.persistence.Row;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class AnomalyRuleWriter
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(AnomalyRuleWriter.class.getName());
    private int mahiObjMapFileCount = 0;
    private int fileCount = 0;
    private String tableName = null;
    private FileWriter fWriter = null;
    private PrintWriter writer = null;
    private String fileName = null;
    private String fileToDump = null;
    Object writeObj = new Object();
    Object dumper = new Object();
    private int flowCount = 0;
    boolean shutdown = false;
    private static String tmpFileDir = System.getProperty("server.home") + File.separator + "server" + File.separator + "tmp";
    private static boolean dbType = "mssql".equals(System.getProperty("DBType", "mysql"));
    private static boolean isPostgres = "postgres".equals(System.getProperty("DBType"));
    private static boolean isWinAuthType = "true".equals(System.getProperty("isWinAuthType", "false"));
    private String dbserver = "";
    private String dbname = "";
    private String dbuser = "";
    private String dbpass = "";
    private String commandToExecute = null;
    private String bcpPerfParams = "";
    String delimiter = isPostgres ? "\t" : "|**|";

    public AnomalyRuleWriter(String tableName) {
        super("LoadThread for " + tableName);
        LOGGER.log(Level.INFO, "AnomalyRuleWriter Constructor Called for  {0}", tableName);
        this.tableName = tableName;
        LOGGER.log(Level.FINE, "AnomalyRuleWriter abt to call initTempFile()");
        this.initTempFile();
        this.populateMSSQLDBValues();
        this.populateBcpPerfParams(tableName);
        this.start();
    }

    private void populateMSSQLDBValues() {
        if (dbType) {
            String osName;
            String xmlFilePath = System.getProperty("server.home") + File.separator + "conf" + File.separator + "database_params.conf";
            HashMap DBParams = ResourceCheckerUtil.getConstraints((String)xmlFilePath, (String)"firewall");
            if (DBParams != null) {
                this.dbserver = (String)DBParams.get("DBServer");
                this.dbname = (String)DBParams.get("DBName");
                this.dbuser = (String)DBParams.get("DBUser");
                this.dbpass = (String)DBParams.get("DBPass");
                if (this.dbpass == null) {
                    this.dbpass = "";
                }
            }
            if ((osName = System.getProperty("os.name")).equalsIgnoreCase("windows nt") || osName.equalsIgnoreCase("windows 2000") || osName.equalsIgnoreCase("windows xp") || osName.equalsIgnoreCase("Windows 2003") || osName.equalsIgnoreCase("windows vista") || osName.startsWith("Win") && (osName.indexOf("95") < 0 || osName.indexOf("98") >= 0)) {
                this.commandToExecute = "cmd  /c ";
            } else if (osName.indexOf("95") >= 0 || osName.indexOf("98") >= 0) {
                this.commandToExecute = "command.com /c ";
            }
        }
    }

    private void populateBcpPerfParams(String tableName) {
        if (dbType) {
            String bcpBatchSize = System.getProperty("bcpBatchSize", "1000");
            String bcpNetPacketSize = System.getProperty("bcpNetSize", "4096");
            String lowerTable = tableName.toLowerCase();
            String bcpOrderBy = "";
            if (lowerTable.equals("firewallobjects")) {
                bcpOrderBy = "\"ORDER (OBJID ASC)\"";
            } else if (lowerTable.equals("objecttochildonetonmapping")) {
                bcpOrderBy = "\"ORDER (ObjToChildMapID ASC)\"";
            } else if (lowerTable.equals("ruledetails")) {
                bcpOrderBy = "\"ORDER (RULEID ASC)\"";
            } else if (lowerTable.equals("ruletoobjonetonmapping")) {
                bcpOrderBy = "\"ORDER (RuleToObjMapID ASC)\"";
            } else if (lowerTable.equals("anomalydetails")) {
                bcpOrderBy = "\"ORDER (AnomalyPK ASC)\"";
            } else if (lowerTable.equals("anomalyruledetails")) {
                bcpOrderBy = "\"ORDER (AnomalyPK ASC)\"";
            }
            this.bcpPerfParams = " -a " + bcpNetPacketSize + " -b " + bcpBatchSize + " -h " + bcpOrderBy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAnomaly(ArrayList<String> values) {
        String data = this.getValue(values);
        Object object = this.writeObj;
        synchronized (object) {
            ++this.flowCount;
            this.writer.println(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAnomalyRule(ArrayList<String> values) {
        String data = this.getValue(values);
        Object object = this.writeObj;
        synchronized (object) {
            ++this.flowCount;
            this.writer.println(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Row row) {
        LOGGER.log(Level.FINER, "[AnomalyRuleWriter.save()] Inside AnomalyRuleWriter's save() method **** for table::" + this.tableName);
        String data = this.getData(row);
        Object object = this.writeObj;
        synchronized (object) {
            ++this.flowCount;
            this.writer.println(data);
        }
    }

    private String getData(Row row) {
        List values = row.getValues();
        StringBuffer sb = new StringBuffer();
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            Object value;
            if (i > 0) {
                sb.append(this.delimiter);
            }
            if ((value = values.get(i)) != null) {
                if (isPostgres && value instanceof String) {
                    sb.append(Matcher.quoteReplacement(value.toString()));
                    continue;
                }
                if (dbType && value instanceof Boolean) {
                    Boolean boolObj = (Boolean)value;
                    boolean val = boolObj;
                    if (val) {
                        sb.append("1");
                        continue;
                    }
                    sb.append("0");
                    continue;
                }
                sb.append(values.get(i));
                continue;
            }
            if (value != null || dbType) continue;
            sb.append("\\N");
        }
        if (!isPostgres) {
            sb.append(this.delimiter);
        }
        return sb.toString();
    }

    public synchronized void flush() {
        this.writeToFile();
        this.dumpToDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                LOGGER.log(Level.FINER, " FILE TO DUMP FROM RECORD WRITER =={0}", this.fileToDump);
                this.writeToFile();
                this.dumpToDatabase();
            }
            catch (Exception exp) {
                LOGGER.log(Level.WARNING, "Exception occured while Saving data to file or dumping data into DB ", exp);
            }
            finally {
                try {
                    Object exp = this.dumper;
                    synchronized (exp) {
                        this.dumper.wait();
                    }
                }
                catch (Exception exp) {
                    LOGGER.log(Level.WARNING, "Exception while waiting ", exp);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void dumpToDatabase() {
        RelationalAPI rapi = RelationalAPI.getInstance();
        Connection con = null;
        Statement stmt = null;
        boolean problem = false;
        if (this.fileToDump != null) {
            try {
                File tmpFile = new File(tmpFileDir + File.separator + this.fileToDump);
                String filePath = tmpFile.getCanonicalPath();
                filePath = filePath.replace('\\', '/');
                if (isPostgres) {
                    con = rapi.getConnection();
                    stmt = con.createStatement();
                    LOGGER.log(Level.FINER, "Dropping Table Indexes");
                    stmt.addBatch("copy " + this.tableName + " from  '" + filePath + "' delimiter E'\t'");
                    try {
                        stmt.executeBatch();
                    }
                    catch (Exception ee) {
                        problem = true;
                        ee.printStackTrace();
                    }
                    LOGGER.log(Level.FINER, "Index recreation is finished");
                } else if (dbType) {
                    if (isWinAuthType) {
                        this.loadDataInToMSSQL(this.commandToExecute + " ..\\bin\\bcp.exe " + this.dbname + ".dbo." + this.tableName + " in " + filePath + " -S " + this.dbserver + " -T -t \"|**|\" -r \"|**|\\n\" -e ..\\logs\\loaddataerr.txt " + this.bcpPerfParams + " -c -q");
                    } else {
                        this.loadDataInToMSSQL(this.commandToExecute + " ..\\bin\\bcp.exe " + this.dbname + ".dbo." + this.tableName + " in " + filePath + " -S " + this.dbserver + " -U " + this.dbuser + " -P \"" + this.dbpass + "\" -t \"|**|\" -r \"|**|\\n\" -e ..\\logs\\loaddataerr.txt " + this.bcpPerfParams + " -c -q");
                    }
                } else {
                    String sql = "load data local infile '" + filePath + "' into table " + this.tableName + " fields terminated by '|**|' ";
                    con = rapi.getConnection();
                    stmt = con.createStatement();
                    int recordCount = stmt.executeUpdate(sql);
                    LOGGER.log(Level.INFO, recordCount + " Records written");
                    LOGGER.log(Level.FINER, "Loaded {0} rows to Table {1}", new Object[]{new Integer(recordCount), this.tableName});
                }
                if (problem) {
                    AnomalyRuleWriter.copyFileUsingFileStreams(filePath);
                }
                this.deleteTempFiles(this.fileToDump);
                this.fileToDump = null;
            }
            catch (Exception exp) {
                LOGGER.log(Level.FINER, "[AnomalyRuleWriter.run()] Exception while loading data to table {0}", this.tableName);
                exp.printStackTrace();
                this.clearInterrupt();
            }
            finally {
                try {
                    stmt.close();
                    con.close();
                }
                catch (Exception exp) {
                    stmt = null;
                    con = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileUsingFileStreams(String old) throws IOException {
        File source = new File(old);
        File dest = new File(old + "_bckup");
        InputStream input = null;
        OutputStream output = null;
        try {
            int bytesRead;
            input = new FileInputStream(source);
            output = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            while ((bytesRead = input.read(buf)) > 0) {
                output.write(buf, 0, bytesRead);
            }
        }
        finally {
            input.close();
            output.close();
        }
    }

    private void loadDataInToMSSQL(String command) throws Exception {
        ServerUtil.BCPLOCK.lock();
        BufferedReader in = null;
        FileOutputStream fos = null;
        try {
            int c;
            fos = new FileOutputStream(System.getProperty("server.home") + File.separator + "logs" + File.separator + "loadData.log");
            Process p = Runtime.getRuntime().exec(command);
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((c = in.read()) != -1) {
                fos.write(c);
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            ServerUtil.BCPLOCK.unlock();
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ee) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception ee) {}
            }
        }
    }

    private String getValue(ArrayList<String> data) {
        ArrayList<String> values = data;
        StringBuffer sb = new StringBuffer();
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            String value;
            if (i > 0) {
                sb.append(this.delimiter);
            }
            if ((value = values.get(i)) != null) {
                if (isPostgres && value instanceof String) {
                    sb.append(Matcher.quoteReplacement(value.toString()));
                    continue;
                }
                sb.append(values.get(i));
                continue;
            }
            if (value != null || dbType) continue;
            sb.append("\\N");
        }
        if (!isPostgres) {
            sb.append(this.delimiter);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeToFile() {
        if (this.flowCount == 0) {
            return;
        }
        Object object = this.writeObj;
        synchronized (object) {
            this.writer.flush();
            this.closeTempFileWriters();
            this.flowCount = 0;
        }
    }

    private void closeTempFileWriters() {
        this.closeFlowWriters();
        this.writer = null;
        this.fWriter = null;
        this.fileToDump = this.fileName;
        this.fileName = null;
        this.initTempFile();
    }

    private void closeFlowWriters() {
        try {
            this.writer.close();
            this.fWriter.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, " Exception while closing file {0}", e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile() {
        InputStream input = null;
        OutputStream output = null;
        try {
            int bytesRead;
            String mahiFileName = "MahiFile_" + this.mahiObjMapFileCount + ".txt";
            File source = new File(tmpFileDir + File.separator + this.fileName);
            File dest = new File(tmpFileDir + File.separator + mahiFileName);
            dest.createNewFile();
            input = new FileInputStream(source);
            output = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            while ((bytesRead = input.read(buf)) > 0) {
                output.write(buf, 0, bytesRead);
            }
            ++this.mahiObjMapFileCount;
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        finally {
            try {
                input.close();
                output.close();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    private void initTempFile() {
        try {
            this.fileCount = this.fileCount == 0 ? 1 : 0;
            this.fileName = this.tableName + "_" + this.fileCount + ".txt";
            this.fWriter = new FileWriter(tmpFileDir + File.separator + this.fileName, false);
            this.writer = new PrintWriter((Writer)new BufferedWriter(this.fWriter), false);
            LOGGER.log(Level.FINER, "[AnomalyRuleWriter.initTempFile()] Created new temp file as {0}{1}{2}", new Object[]{tmpFileDir, File.separator, this.fileName});
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, " Exception while opening file for table: {0}", this.tableName);
            LOGGER.log(Level.WARNING, " Exception while opening file to log flows: {0}", e);
        }
    }

    public String getTempFileName() {
        return this.fileName;
    }

    public String getTableName() {
        return this.tableName;
    }

    private void deleteTempFiles(String fileName) {
        try {
            if (fileName == null) {
                return;
            }
            File tmpFile = new File(tmpFileDir + File.separator + fileName);
            boolean del = tmpFile.delete();
            tmpFile = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        Object object = this.writeObj;
        synchronized (object) {
            this.writer.flush();
            this.closeFlowWriters();
        }
    }

    private void clearInterrupt() {
        Thread th = Thread.currentThread();
        if (th.isInterrupted()) {
            LOGGER.log(Level.FINER, "[AnomalyRuleWriter.clearInterrupt()] Thread was interrupted while running loading File {0}", this.fileToDump);
            th.interrupted();
            LOGGER.log(Level.FINER, "[AnomalyRuleWriter.clearInterrupt()] Interruption cleared ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backUpTheFile() {
        boolean renamed = false;
        try {
            File tmpFile = new File(tmpFileDir + File.separator + this.fileToDump);
            String newName = System.currentTimeMillis() + "_" + this.fileToDump;
            LOGGER.log(Level.FINER, "[AnomalyRuleWriter.backUpTheFile] {0}", newName);
            renamed = tmpFile.renameTo(new File(newName));
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            if (!renamed) {
                this.deleteTempFiles(this.fileToDump);
            }
        }
    }

    public int getFlowCount() {
        return this.flowCount;
    }
}

