/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.rules;

import com.adventnet.fa.server.rules.FwConfigMgmt;
import com.adventnet.persistence.DataObject;
import java.util.Properties;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class CLIConnectionManager {
    private static final Logger LOGGER = Logger.getLogger(CLIConnectionManager.class.getName());
    private ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
    private static CLIConnectionManager cliConnMgr;
    private static final long INIT_DELAY = 120L;

    public static CLIConnectionManager getInstance() {
        if (cliConnMgr == null) {
            cliConnMgr = new CLIConnectionManager();
        }
        return cliConnMgr;
    }

    private CLIConnectionManager() {
    }

    public void createConfigFetcherTask(DataObject dObj, Properties prop, String resourceName, String changedBy, Long rID, Boolean isVdom, Long baseRID) {
        LOGGER.info("@@CLIConnectionManager::: inside creating new COnfigFetcherTask for the resource <-> " + resourceName + " with RID <-> " + rID);
        ConfigFetcherTask cft = new ConfigFetcherTask(dObj, prop, resourceName, changedBy, rID, isVdom);
        ScheduledFuture<?> sf = this.scheduler.schedule(cft, 1L, TimeUnit.SECONDS);
    }

    class ConfigFetcherTask
    implements Runnable {
        private String resourceName;
        private String changedBy;
        private Long rID;
        private Long baseRID;
        private FwConfigMgmt configMgmt = null;
        private DataObject dObj = null;
        private Properties prop = null;
        private Boolean isVdom = Boolean.FALSE;

        ConfigFetcherTask(DataObject dObj, Properties prop, String resourceName, String changedBy, Long rID, Boolean isVdom) {
            this.resourceName = resourceName;
            this.changedBy = changedBy;
            this.rID = rID;
            this.baseRID = this.baseRID;
            this.configMgmt = FwConfigMgmt.getInstance();
            this.dObj = dObj;
            this.prop = prop;
            this.isVdom = isVdom;
        }

        @Override
        public void run() {
            LOGGER.info("@@ConfigFetcherTask::: inside ConfigFetcherTask run method...for rID::" + this.rID + " and for user:::" + this.changedBy);
            this.configMgmt.logoutSyslogConfigFetchHandling(this.dObj, this.prop, this.resourceName, this.changedBy, this.rID, this.isVdom, this.baseRID);
            LOGGER.info("@@ConfigFetcherTask::: finished ConfigFetcherTask for rID::" + this.rID + " and for user:::" + this.changedBy);
        }
    }
}

