/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.rules;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.fa.server.FWAEnumConstants;
import com.adventnet.fa.server.rules.FirewallGroupObject;
import com.adventnet.fa.server.rules.FirewallPolicyFormat;
import com.adventnet.fa.server.rules.FirewallPolicyParserRule;
import com.adventnet.fa.server.rules.FirewallPolicyParserRuleAttribute;
import com.adventnet.fa.server.rules.FwConfigMgmt;
import com.adventnet.fa.server.rules.InterfaceDetails;
import com.adventnet.fa.server.rules.NetworkObject;
import com.adventnet.fa.server.rules.PolicyProcessor;
import com.adventnet.fa.server.rules.PolicyProcessorUtilityClass;
import com.adventnet.fa.server.rules.RuleObject;
import com.adventnet.fa.server.rules.ServiceObject;
import com.adventnet.la.util.EncryptionAPI;
import com.adventnet.la.util.IPRange;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CiscoPolicyProcessor
implements PolicyProcessor {
    ResourceBundle bundle = ProductBundle.getInstance().getBundle();
    private NetworkObject currentNetworkObject = null;
    private String currentNATObjName = null;
    private ServiceObject currentServiceObject = null;
    private InterfaceDetails currentInterfaceDetailsObject = null;
    private FirewallGroupObject currentGroupObject = null;
    private String currentServiceProtocol = null;
    private String currentPolicyName = null;
    private String currentACEComment = null;
    private Long rID = null;
    private String deviceType = "Cisco";
    private String resourceName = null;
    private String configData = null;
    private Long versionNo = null;
    private LinkedHashMap<String, NetworkObject> netObjMap = null;
    private LinkedHashMap<String, ServiceObject> serviceObjMap = null;
    private LinkedHashMap<String, ServiceObject> icmpObjMap = null;
    private LinkedHashMap<String, Vector<RuleObject>> policyObjMap = null;
    private HashMap<String, String> nameObjMap = null;
    private LinkedHashMap<String, ArrayList<String>> netObjGroupMemberDetailsMap = null;
    private LinkedHashMap<String, HashSet<String>> objGroupUnResolvedMembers = null;
    private HashMap<String, String> netObjInfoMap = null;
    private HashMap<String, String> serviceObjInfoMap = null;
    private HashMap<String, String> protocolObjInfoMap = null;
    private HashMap<String, String> icmpObjInfoMap = null;
    private ArrayList<String> netObjList = null;
    private ArrayList<String> serviceObjList = null;
    private LinkedHashMap<String, FirewallGroupObject> netObjGroupMap = null;
    private LinkedHashMap<String, FirewallGroupObject> protoObjGroupMap = null;
    private LinkedHashMap<String, FirewallGroupObject> serviceObjGroupMap = null;
    private LinkedHashMap<String, FirewallGroupObject> icmpObjGroupMap = null;
    private ArrayList<String> allObjects = null;
    private Set<String> usedObjects = null;
    private HashMap<String, Long> policyNameVsIDMap = null;
    private LinkedHashMap<String, InterfaceDetails> interfaceDetailsObjMap = null;
    private HashMap<String, String> aclInterfaceConfigMap = null;
    private HashMap<String, String> interfaceAliasVsOriginalNamesMap = null;
    private HashMap<String, String> interfaceVsZoneMap = null;
    private HashMap<String, String> interfaceVsIPAddrMap = null;
    private HashMap<String, Integer> interfaceVsSecurityLevel = null;
    private ArrayList<String> allInterfaces = null;
    private Set<String> usedInterfaces = null;
    private List<String> wanInterfaceList = null;
    private HashSet<String> vpnACLs = null;
    private HashSet<String> siteToSiteVPNACLs = null;
    private HashMap<String, String> groupPolicyVsACLMap = null;
    private HashMap<String, String> ipPoolMap = null;
    private ArrayList<String> vpnIPPoolList = null;
    private ArrayList<long[]> vpnIPPoolDetails = null;
    private HashSet<String> unIdentifiedIPList = null;
    private HashSet<String> unIdentifiedIPIDList = null;
    private HashMap<String, ArrayList<String[]>> staticNATConfig = null;
    private HashMap<String, ArrayList<String[]>> dynamicNATConfig = null;
    private HashMap<String, ArrayList<String[]>> dynamicGlobalNATConfig = null;
    private HashMap<String, TreeMap<Integer, Set<String>>> dynamicLocalNATConfig = null;
    private HashMap<String, TreeMap<Integer, Set<String>>> dynamicOutsideNATLocalConfig = null;
    private ArrayList<String> natIPPool = null;
    private HashMap<String, String> staticRouteTable = null;
    private HashMap<String, Long> defaultStaticRouteTable = null;
    private static final Logger LOGGER = Logger.getLogger(CiscoPolicyProcessor.class.getName());
    private EncryptionAPI decryptionObj = null;
    private boolean isPIX = false;
    private boolean oldASA = false;
    private static byte[] completeSubnetAddr = new byte[]{-1, -1, -1, -1};
    private PolicyProcessorUtilityClass policyProcessorUtilityObject = null;
    private FirewallPolicyFormat fpf = null;
    private static Pattern asaVersionPattern = Pattern.compile("ASA\\s+Version\\s+(\\d+)\\.(\\d+).*");
    private static Pattern srcAndDstObjExtractPatternFromRuleService = Pattern.compile("^Source:(\\S+)\\s*(?:and\\s+Destination:(\\S+))?");
    private static Pattern fwaCustomObjNameExractPattern = Pattern.compile("fwaCreatedCustomObject_(.*)");
    private static Pattern bracketExtractPattern = Pattern.compile(".*\\(([^\\)]+)\\)");
    private static Pattern tcpudpPortExtractPattern = Pattern.compile("(?:\\S+\\(Group\\):\\s*)?(?i)(tcp|udp)\\s+(?:srcPort(=|!=|<|>)([^\\,]+)(?:\\,)?)?(?:dstPort(=|!=|<|>)([^\\,]+))?");
    private static Pattern icmpPortExtractPattern = Pattern.compile("(?:\\S+\\(Group\\):\\s*)?(?i)(icmp|icmp6)\\s+(?:dstPort(?:=|<|>|!=))?(\\S+)(?:\\s+(\\S+))?");
    private static Pattern anyProtocolExtractPattern = Pattern.compile("(?:\\S+\\(Group\\):\\s*)?(?i)(?:Any)\\s+(\\S+)");
    private static Pattern otherProtocolPortExtractPattern = Pattern.compile("(?:\\S+\\(Group\\):\\s*)?(\\S+)(?:\\s+(\\S+))?");
    private static Pattern srcAndDstPortOperatorPattern = Pattern.compile("^(<|>|!=)(.*)");
    private ArrayList<Pattern> portExtractPatternList = null;
    private HashMap<String, String> portOperatorMap = null;
    private HashMap<String, String> serviceToPortMap = null;
    private HashSet<String> unFoundDstInterfaceSet = null;
    private HashSet<String> unFoundSrcInterfaceSet = null;
    private HashSet<String> nonAppliedPolicySet = null;
    public HashSet<String> unknownPorts = null;
    private boolean isInDebugMode = false;
    private boolean hasInterfaceVsZoneMap = false;
    private boolean hasUnknownPorts = false;
    private HashSet<String> unResolvedObjectsSet = null;
    private final String[] anyIPArray = new String[]{"any", "any4", "any6", "all"};
    private final List<String> anyIPList = Arrays.asList(this.anyIPArray);
    HashMap<String, String> ruleDetailsDataMap = null;
    HashMap<String, String> ruleMappingDataMap = null;
    HashMap<String, String> firewallObjDataMap = null;
    HashMap<String, String> objMappingDataMap = null;

    public CiscoPolicyProcessor(Long rID, String resourceName, String configData, Long versionNo) {
        Level loggerLevel = LOGGER.getLevel();
        if (loggerLevel != null && loggerLevel.intValue() < 0) {
            this.isInDebugMode = true;
        }
        this.initialize();
        this.decryptionObj = EncryptionAPI.getDecryptionObj();
        this.rID = rID;
        this.resourceName = resourceName;
        this.configData = configData;
        this.versionNo = versionNo;
        this.policyProcessorUtilityObject = PolicyProcessorUtilityClass.getInstance();
        this.serviceToPortMap = this.policyProcessorUtilityObject.getServiceToPortMap("Cisco");
        this.fpf = this.policyProcessorUtilityObject.getVendorSpecificPolicyFormat("Cisco");
        this.interfaceVsZoneMap = PolicyProcessorUtilityClass.getResourceSpecificInterfaceVsZoneMap(rID);
        if (this.interfaceVsZoneMap == null) {
            this.interfaceVsZoneMap = this.policyProcessorUtilityObject.populateInterfaceVsZoneMapFromDB(rID);
        }
        if (this.interfaceVsZoneMap != null && !this.interfaceVsZoneMap.isEmpty()) {
            this.hasInterfaceVsZoneMap = true;
        }
        this.portExtractPatternList = new ArrayList();
        this.portExtractPatternList.add(tcpudpPortExtractPattern);
        this.portExtractPatternList.add(icmpPortExtractPattern);
        this.portExtractPatternList.add(anyProtocolExtractPattern);
        this.portExtractPatternList.add(otherProtocolPortExtractPattern);
        this.portOperatorMap = new HashMap();
        this.portOperatorMap.put("eq", "=");
        this.portOperatorMap.put("lt", "<");
        this.portOperatorMap.put("gt", ">");
        this.portOperatorMap.put("neq", "!=");
    }

    public CiscoPolicyProcessor(Long rID, String resourceName, String configData, Long versionNo, Boolean noDefaultInitialization) {
        this.rID = rID;
        this.resourceName = resourceName;
        this.configData = configData;
        this.versionNo = versionNo;
        this.policyProcessorUtilityObject = PolicyProcessorUtilityClass.getInstance();
        this.fpf = this.policyProcessorUtilityObject.getVendorSpecificPolicyFormat("Cisco");
    }

    private void initialize() {
        this.netObjMap = new LinkedHashMap(50);
        this.serviceObjMap = new LinkedHashMap(50);
        this.icmpObjMap = new LinkedHashMap(20);
        this.policyObjMap = new LinkedHashMap(25);
        this.nameObjMap = new HashMap(50);
        this.netObjGroupMemberDetailsMap = new LinkedHashMap(50);
        this.objGroupUnResolvedMembers = new LinkedHashMap();
        this.netObjInfoMap = new HashMap(50);
        this.serviceObjInfoMap = new HashMap(50);
        this.protocolObjInfoMap = new HashMap(50);
        this.icmpObjInfoMap = new HashMap(20);
        this.netObjList = new ArrayList(30);
        this.serviceObjList = new ArrayList(30);
        this.netObjGroupMap = new LinkedHashMap(50);
        this.protoObjGroupMap = new LinkedHashMap(50);
        this.serviceObjGroupMap = new LinkedHashMap(50);
        this.icmpObjGroupMap = new LinkedHashMap(50);
        this.allObjects = new ArrayList(100);
        this.usedObjects = new HashSet<String>(100);
        this.policyNameVsIDMap = new HashMap();
        this.interfaceDetailsObjMap = new LinkedHashMap(25);
        this.aclInterfaceConfigMap = new HashMap(25);
        this.interfaceAliasVsOriginalNamesMap = new HashMap();
        this.interfaceVsZoneMap = new HashMap();
        this.interfaceVsIPAddrMap = new HashMap();
        this.interfaceVsSecurityLevel = new HashMap();
        this.allInterfaces = new ArrayList();
        this.usedInterfaces = new HashSet<String>();
        this.wanInterfaceList = new ArrayList<String>();
        this.vpnACLs = new HashSet();
        this.siteToSiteVPNACLs = new HashSet();
        this.groupPolicyVsACLMap = new HashMap();
        this.ipPoolMap = new HashMap();
        this.vpnIPPoolList = new ArrayList();
        this.vpnIPPoolDetails = new ArrayList();
        this.unIdentifiedIPList = new HashSet();
        this.unIdentifiedIPIDList = new HashSet();
        this.dynamicGlobalNATConfig = new HashMap();
        this.dynamicLocalNATConfig = new HashMap();
        this.dynamicOutsideNATLocalConfig = new HashMap();
        this.staticNATConfig = new HashMap();
        this.dynamicNATConfig = new HashMap();
        this.natIPPool = new ArrayList();
        this.staticRouteTable = new HashMap();
        this.defaultStaticRouteTable = new HashMap();
        this.unFoundDstInterfaceSet = new HashSet();
        this.unFoundSrcInterfaceSet = new HashSet();
        this.nonAppliedPolicySet = new HashSet();
        this.unknownPorts = new HashSet();
        this.unResolvedObjectsSet = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startParsing() throws Exception {
        FwConfigMgmt confMgmt = FwConfigMgmt.getInstance();
        if (this.configData == null) {
            Long maxVersion = confMgmt.getMaxConfigVersion(this.rID, "running");
            DataObject confDo = confMgmt.getLatestConfigFromDB(maxVersion, "running", this.rID);
            InputStream dbConfigDataStream = (InputStream)confDo.getFirstValue("ConfigVersions", "FILE_CONTENTS");
            if (dbConfigDataStream != null) {
                BufferedReader reader = null;
                StringWriter writer = new StringWriter();
                char[] buffer = new char[1024];
                try {
                    int n;
                    reader = new BufferedReader(new InputStreamReader(dbConfigDataStream, "UTF-8"));
                    while ((n = reader.read(buffer)) != -1) {
                        ((Writer)writer).write(buffer, 0, n);
                    }
                    this.configData = ((Object)writer).toString();
                }
                finally {
                    this.configData = this.decryptionObj.decryptLog(this.configData);
                    try {
                        if (reader != null) {
                            ((Reader)reader).close();
                        }
                        dbConfigDataStream.close();
                        ((Writer)writer).close();
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
            }
            throw new Exception("Unable to Parse the Config as no Config exists....for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor...");
        }
        if (this.fpf == null) {
            throw new Exception("No Policy Format exists for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor...");
        }
        this.detectDeviceType(this.configData);
        LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap = new LinkedHashMap<FWAEnumConstants.ParserKeys, String>();
        this.parseAndProcessInterfaceDetails(this.configData, resultMap);
        this.parseAndProcessInterfaceIPDetailsForPIX(this.configData, resultMap);
        this.parseAndProcessAccessListInterfaceConfig(this.configData, resultMap);
        this.parseAndProcessNameObjects(this.configData, resultMap);
        this.parseAndProcessObjects(this.configData, resultMap);
        this.parseAndProcessOldNetworkObjects(this.configData, resultMap);
        this.parseAndProcessObjectGroups(this.configData, resultMap);
        this.parseAndProcessIPPoolConfig(this.configData, resultMap);
        this.parseAndProcessSiteToSiteVPNConfig(this.configData, resultMap);
        this.parseAndProcessGroupPolicyConfig(this.configData, resultMap);
        this.parseAndProcessTunnelGroupConfig(this.configData, resultMap);
        this.parseAndProcessDAPRecordConfig(this.configData, resultMap);
        this.groupVPNIPPool();
        this.parseAndProcessPolicyObjects(this.configData, resultMap);
        this.netObjList = null;
        this.serviceObjList = null;
        StringBuilder resultBuilder = new StringBuilder();
        this.parseAndProcessSnmpConfig(this.configData, this.fpf, resultMap, resultBuilder);
        this.parseAndProcessHttpConfig(this.configData, this.fpf, resultMap, resultBuilder);
        this.parseAndProcessTelnetConfig(this.configData, this.fpf, resultMap, resultBuilder);
        this.parseAndProcessSSHConfig(this.configData, this.fpf, resultMap, resultBuilder);
        this.parseAndProcessUserAccessConfig(this.configData, this.fpf, resultMap, resultBuilder);
        this.parseAndProcessNTPConfig(this.configData, this.fpf, resultMap, resultBuilder);
        this.parseAndProcessSyslogLoggingConfig(this.configData, this.fpf, resultMap, resultBuilder);
        resultMap = null;
        Object var3_3 = null;
    }

    public void groupVPNIPPool() {
        if (!this.vpnIPPoolList.isEmpty()) {
            String vpnIPPool = this.policyProcessorUtilityObject.toGroup(this.vpnIPPoolList);
            this.vpnIPPoolDetails = this.getIPLongDetailsList(vpnIPPool);
        }
    }

    private void detectDeviceType(String configData) throws Exception {
        block13: {
            BufferedReader reader = null;
            try {
                int startIndex = configData.indexOf("ASA Version ");
                if (startIndex > -1) {
                    String strLine;
                    String configToBeProcessed = configData.substring(startIndex);
                    reader = new BufferedReader(new StringReader(configToBeProcessed));
                    for (int i = 0; (strLine = reader.readLine()) != null && i < 5; ++i) {
                        Matcher mat = asaVersionPattern.matcher(strLine = strLine.trim());
                        if (!mat.matches()) continue;
                        long baseVersion = Long.parseLong(mat.group(1));
                        long subVersion = Long.parseLong(mat.group(2));
                        this.oldASA = baseVersion <= 8L && (baseVersion != 8L || subVersion < 3L);
                        LOGGER.log(Level.FINER, "baseVersion::" + baseVersion + " and subVersion::" + subVersion + " and oldASA:::" + this.oldASA);
                        break block13;
                    }
                    break block13;
                }
                if (configData.indexOf("PIX Version ") > -1) {
                    this.isPIX = true;
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while parsing model type and version Details for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    private void parseAndProcessInterfaceDetails(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block19: {
            BufferedReader reader = null;
            try {
                String strLine;
                int startIndex = configData.indexOf("\ninterface ");
                if (startIndex <= -1) break block19;
                String startExpression = this.fpf.getInterfaceStartExpression();
                Pattern startPattern = this.fpf.getInterfaceStartPattern();
                String endDecideExpression = this.fpf.getEndDecideExpression();
                Pattern endDecidePattern = this.fpf.getEndDecidePattern();
                boolean patternMatched = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                while ((strLine = reader.readLine()) != null) {
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!patternMatched) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> asaInterfaceNamePR = this.fpf.getASAInterfaceNameParserRules();
                    Vector<FirewallPolicyParserRule> asaInterfaceElementsPR = this.fpf.getASAInterfaceElementsParserRules();
                    Vector<FirewallPolicyParserRule> pixInterfaceDetailsPR = this.fpf.getPIXInterfaceDetailsParserRules();
                    while ((strLine = reader.readLine()) != null) {
                        patternMatched = false;
                        String origLine = strToProcess;
                        strToProcess = strToProcess.trim();
                        if (this.isPIX) {
                            patternMatched = this.executeParserRuleList(strToProcess, pixInterfaceDetailsPR, "pixInterfaceDetails", resultMap);
                            if (!patternMatched) {
                                break block19;
                            }
                        } else {
                            patternMatched = this.executeParserRuleList(strToProcess, asaInterfaceElementsPR, "asaInterfaceElements", resultMap);
                            if (!patternMatched && !(patternMatched = this.executeParserRuleList(strToProcess, asaInterfaceNamePR, "asaInterfaceName", resultMap))) {
                                patternMatched = this.executeParserRuleList(strToProcess, pixInterfaceDetailsPR, "pixInterfaceDetails", resultMap);
                                if (patternMatched) {
                                    this.isPIX = true;
                                } else {
                                    if (strToProcess.equals("!") || strToProcess.equals("") || this.policyProcessorUtilityObject.matchPattern(origLine, endDecideExpression, endDecidePattern)) {
                                        strToProcess = strLine;
                                        continue;
                                    }
                                    break block19;
                                }
                            }
                        }
                        if (strLine.equals("!") || strLine.equals("")) continue;
                        strToProcess = strLine;
                    }
                    break;
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Interface Details for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    private void parseAndProcessInterfaceIPDetailsForPIX(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block13: {
            BufferedReader reader = null;
            try {
                String strLine;
                int startIndex = configData.indexOf("\nip address ");
                if (startIndex <= -1) break block13;
                String startExpression = this.fpf.getPixInterfaceIPStartExpression();
                Pattern startPattern = this.fpf.getPixInterfaceIPStartPattern();
                boolean patternMatched = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                while ((strLine = reader.readLine()) != null) {
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!patternMatched) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> pixInterfaceIPDetailsPR = this.fpf.getPIXInterfaceIPDetailsParserRules();
                    while ((strLine = reader.readLine()) != null) {
                        patternMatched = false;
                        strToProcess = strToProcess.trim();
                        if (this.isPIX && !(patternMatched = this.executeParserRuleList(strToProcess, pixInterfaceIPDetailsPR, "pixInterfaceIPDetails", resultMap))) {
                            break block13;
                        }
                        if (strLine.equals("!") || strLine.equals("")) continue;
                        strToProcess = strLine;
                    }
                    break;
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Interface IP Details for the pix firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    private void parseAndProcessAccessListInterfaceConfig(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block13: {
            BufferedReader reader = null;
            try {
                String strLine;
                int startIndex = configData.indexOf("\naccess-group ");
                if (startIndex <= -1) break block13;
                Pattern startPattern = this.fpf.getAccessListConfigStartPattern();
                String startExpression = this.fpf.getAccessListConfigStartExpression();
                boolean patternMatched = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                while ((strLine = reader.readLine()) != null) {
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!patternMatched) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> aclInterfaceConfigPR = this.fpf.getACLInterfaceConfigParserRules();
                    while ((strLine = reader.readLine()) != null) {
                        patternMatched = false;
                        strLine = strLine.trim();
                        patternMatched = this.executeParserRuleList(strToProcess, aclInterfaceConfigPR, "aclInterfaceConfigDetails", resultMap);
                        if (!patternMatched) {
                            break block13;
                        }
                        strToProcess = strLine;
                    }
                    break;
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing ACLInterfaceConfigs for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    private void parseAndProcessStaticNATConfig(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block13: {
            BufferedReader reader = null;
            try {
                String strLine;
                int startIndex = configData.indexOf("\nstatic (");
                if (startIndex <= -1) break block13;
                String startExpression = this.fpf.getStaticNATConfigStartExpression();
                Pattern startPattern = this.fpf.getStaticNATConfigStartPattern();
                boolean patternMatched = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                while ((strLine = reader.readLine()) != null) {
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!patternMatched) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> natConfigPR = this.fpf.getStaticNATConfigParserRules();
                    while ((strLine = reader.readLine()) != null) {
                        patternMatched = false;
                        strLine = strLine.trim();
                        patternMatched = this.executeParserRuleList(strToProcess, natConfigPR, "staticNATConfigDetails", resultMap);
                        if (!patternMatched) {
                            break block13;
                        }
                        strToProcess = strLine;
                    }
                    break;
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing static NAT Config for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    private void parseAndProcessDynamicNATConfig(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block13: {
            BufferedReader reader = null;
            try {
                String strLine;
                int startIndex = configData.indexOf("\nglobal (");
                if (startIndex <= -1) break block13;
                String startExpression = this.fpf.getDynamicNATConfigStartExpression();
                Pattern startPattern = this.fpf.getDynamicNATConfigStartPattern();
                boolean patternMatched = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                while ((strLine = reader.readLine()) != null) {
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!patternMatched) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> natConfigPR = this.fpf.getDynamicNATConfigParserRules();
                    while ((strLine = reader.readLine()) != null) {
                        patternMatched = false;
                        strLine = strLine.trim();
                        patternMatched = this.executeParserRuleList(strToProcess, natConfigPR, "dynamicNATConfigDetails", resultMap);
                        if (!patternMatched) {
                            break block13;
                        }
                        strToProcess = strLine;
                    }
                    break;
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing dynamic NAT Config for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void correlateGlobalAndLocalNATConfigs() {
        Integer secLevel2 = null;
        Integer toInterfaceSecLevel = null;
        Iterator<Integer> secLevelItr = null;
        Set<String> fromInterfaceSet = null;
        ArrayList<String[]> globalNATDetailsList = null;
        TreeMap<Integer, Set<String>> localNATConfigInterfaceDetailsMap = null;
        TreeMap<Integer, Set<String>> localOutsideNATConfigInterfaceDetailsMap = null;
        for (String natID : this.dynamicGlobalNATConfig.keySet()) {
            globalNATDetailsList = this.dynamicGlobalNATConfig.get(natID);
            localNATConfigInterfaceDetailsMap = this.dynamicLocalNATConfig.get(natID);
            localOutsideNATConfigInterfaceDetailsMap = this.dynamicOutsideNATLocalConfig.get(natID);
            for (String[] globalNATDetails : globalNATDetailsList) {
                String tranIPRange;
                String toInterface = globalNATDetails[0];
                toInterfaceSecLevel = this.interfaceVsSecurityLevel.get(toInterface);
                if (localNATConfigInterfaceDetailsMap != null) {
                    for (Integer secLevel2 : localNATConfigInterfaceDetailsMap.keySet()) {
                        if (secLevel2.compareTo(toInterfaceSecLevel) < 0) continue;
                        tranIPRange = globalNATDetails[1];
                        fromInterfaceSet = localNATConfigInterfaceDetailsMap.get(secLevel2);
                        this.updateNATTable(tranIPRange, fromInterfaceSet, toInterface);
                    }
                }
                if (localOutsideNATConfigInterfaceDetailsMap == null) continue;
                for (Integer secLevel2 : localOutsideNATConfigInterfaceDetailsMap.keySet()) {
                    if (secLevel2.compareTo(toInterfaceSecLevel) >= 0) continue;
                    tranIPRange = globalNATDetails[1];
                    fromInterfaceSet = localOutsideNATConfigInterfaceDetailsMap.get(secLevel2);
                    this.updateNATTable(tranIPRange, fromInterfaceSet, toInterface);
                }
            }
        }
    }

    public void updateNATTable(String tranIPRange, Set<String> fromInterfaceSet, String toInterface) {
        ArrayList<Object> natInterfaceDetails = this.dynamicNATConfig.get(tranIPRange);
        if (natInterfaceDetails == null) {
            natInterfaceDetails = new ArrayList();
            this.dynamicNATConfig.put(tranIPRange, natInterfaceDetails);
        }
        Iterator<String> fromInterfaceItr = fromInterfaceSet.iterator();
        while (fromInterfaceItr.hasNext()) {
            String[] interfaceDetails = new String[]{fromInterfaceItr.next(), toInterface};
            natInterfaceDetails.add(interfaceDetails);
        }
    }

    private void parseAndProcessASASourceNATMappings(String strLine, BufferedReader reader, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block12: {
            try {
                String startExpression = this.fpf.getASASourceNATStartExpression();
                Pattern startPattern = this.fpf.getASASourceNATStartPattern();
                boolean patternMatched = false;
                strLine = strLine.trim();
                patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, startExpression, startPattern);
                if (!patternMatched) break block12;
                String strToProcess = strLine;
                Vector<FirewallPolicyParserRule> natObjNamePR = this.fpf.getASASourceNATObjNameParserRules();
                Vector<FirewallPolicyParserRule> natObjElementsPR = this.fpf.getASASourceNATConfigParserRules();
                while ((strLine = reader.readLine()) != null) {
                    patternMatched = false;
                    strLine = strLine.trim();
                    patternMatched = this.executeParserRuleList(strToProcess, natObjElementsPR, "asaSourceNATConfigDetails", resultMap);
                    if (!patternMatched && !(patternMatched = this.executeParserRuleList(strToProcess, natObjNamePR, "natObjName", resultMap))) {
                        break;
                    }
                    strToProcess = strLine;
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Firewall Object for the resource " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    private void parseAndProcessASAMultiNATMappings(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        BufferedReader reader = null;
        try {
            int startIndex = configData.indexOf("\nnat (");
            if (startIndex > -1) {
                String strLine;
                String startExpression = this.fpf.getASAMultiNATStartExpression();
                Pattern startPattern = this.fpf.getASAMultiNATStartPattern();
                boolean patternMatched = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                block9: while ((strLine = reader.readLine()) != null) {
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!patternMatched) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> asaMultiNATConfigPR = this.fpf.getASAMultiNATConfigParserRules();
                    while ((strLine = reader.readLine()) != null) {
                        patternMatched = false;
                        strLine = strLine.trim();
                        patternMatched = this.executeParserRuleList(strToProcess, asaMultiNATConfigPR, "asaMultiNATConfigDetails", resultMap);
                        if (!patternMatched) break block9;
                        strToProcess = strLine;
                    }
                    break block9;
                }
                this.parseAndProcessASASourceNATMappings(strLine, reader, resultMap);
            }
        }
        catch (Exception exp) {
            throw new Exception("Problem while processing ASA Source NAT Config for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void parseAndProcessStaticRouteConfig(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block13: {
            BufferedReader reader = null;
            try {
                String strLine;
                String startExpression = this.fpf.getStaticRouteConfigStartExpression();
                Pattern startPattern = this.fpf.getStaticRouteConfigStartPattern();
                int startIndex = configData.indexOf("\nroute ");
                if (startIndex <= -1) break block13;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                boolean patternMatched = false;
                while ((strLine = reader.readLine()) != null) {
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!patternMatched) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> staticRouteConfigPR = this.fpf.getStaticRouteConfigParserRules();
                    Vector<FirewallPolicyParserRule> defaultStaticRouteConfigPR = this.fpf.getDefaultStaticRouteConfigParserRules();
                    while ((strLine = reader.readLine()) != null) {
                        patternMatched = false;
                        strLine = strLine.trim();
                        patternMatched = this.executeParserRuleList(strToProcess, defaultStaticRouteConfigPR, "defaultStaticRouteDetails", resultMap);
                        if (!patternMatched && !(patternMatched = this.executeParserRuleList(strToProcess, staticRouteConfigPR, "staticRouteDetails", resultMap))) {
                            break block13;
                        }
                        strToProcess = strLine;
                    }
                    break;
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing ASA Static Routing Config for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    private void parseAndProcessOldNetworkObjects(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block13: {
            BufferedReader reader = null;
            try {
                String strLine;
                int startIndex = configData.indexOf("\nname ");
                if (startIndex <= -1) break block13;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                Vector<FirewallPolicyParserRule> objNamePR = this.fpf.getNetworkObjectNameParserRules();
                ArrayList<FirewallPolicyParserRuleAttribute> attributes = null;
                Pattern pattern = null;
                boolean patternMatched = false;
                NetworkObject netObj = null;
                long[] minMaxIPLong = new long[2];
                while ((strLine = reader.readLine()) != null) {
                    patternMatched = false;
                    if ((strLine = strLine.trim()).equals("")) continue;
                    for (FirewallPolicyParserRule rule : objNamePR) {
                        String expression = rule.getRegex();
                        patternMatched = this.policyProcessorUtilityObject.executeParserRule(strLine, expression, attributes = rule.getAttributes(), pattern = rule.getPattern(), resultMap);
                        if (!patternMatched) continue;
                        netObj = null;
                        String objName = resultMap.get((Object)FWAEnumConstants.ParserKeys.NETOBJNAME);
                        if (objName == null) continue;
                        netObj = this.netObjMap.get(objName);
                        if (netObj == null) {
                            netObj = new NetworkObject(objName);
                            this.netObjMap.put(objName, netObj);
                        }
                        String singleIP = resultMap.get((Object)FWAEnumConstants.ParserKeys.SINGLEIP);
                        String completeNetwork = InetAddress.getByAddress(completeSubnetAddr).getHostAddress();
                        netObj.setSubnet(singleIP);
                        netObj.setSubnetMask(completeNetwork);
                        String network = IPRange.getNetwork((String)completeNetwork, (String)singleIP);
                        minMaxIPLong = IPRange.getMinMaxLong((String)network, (String)completeNetwork);
                        if (minMaxIPLong == null) continue;
                        String ipRangeIDDBVal = minMaxIPLong[0] + "-" + minMaxIPLong[1];
                        netObj.setIPRangeID(ipRangeIDDBVal);
                        String ipRangeDBVal = IPRange.convertAddr((long)minMaxIPLong[0]) + "-" + IPRange.convertAddr((long)minMaxIPLong[1]);
                        netObj.setIPRange(ipRangeDBVal);
                    }
                    if (patternMatched) continue;
                    break;
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Firewall Object for the resource " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void parseAndProcessNameObjects(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block13: {
            BufferedReader reader = null;
            try {
                String strLine;
                String startExpression = this.fpf.getASANameObjectStartExpression();
                Pattern startPattern = this.fpf.getASANameObjectStartPattern();
                int startIndex = configData.indexOf("\nname ");
                if (startIndex <= -1) break block13;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                boolean patternMatched = false;
                while ((strLine = reader.readLine()) != null) {
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!patternMatched) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> asaNameObjConfigPR = this.fpf.getASANameObjectConfigParserRules();
                    while ((strLine = reader.readLine()) != null) {
                        patternMatched = false;
                        strLine = strLine.trim();
                        patternMatched = this.executeParserRuleList(strToProcess, asaNameObjConfigPR, "nameObjectElements", resultMap);
                        if (!patternMatched) {
                            break block13;
                        }
                        strToProcess = strLine;
                    }
                    break;
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Firewall Object for the resource " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    private void parseAndProcessObjects(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block15: {
            BufferedReader reader = null;
            try {
                String strLine;
                int startIndex = configData.indexOf("\nobject ");
                if (startIndex <= -1) break block15;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                String objNameTypeToPass = "";
                String objElementTypeToPass = "";
                Vector<FirewallPolicyParserRule> objNamePR = null;
                Vector<FirewallPolicyParserRule> objElementsPR = null;
                Vector<FirewallPolicyParserRule> netObjnamePR = this.fpf.getNetworkObjectNameParserRules();
                Vector<FirewallPolicyParserRule> netObjElementsPR = this.fpf.getNetworkObjectElementsParserRules();
                Vector<FirewallPolicyParserRule> serviceObjnamePR = this.fpf.getServiceObjectNameParserRules();
                Vector<FirewallPolicyParserRule> serviceObjElementsPR = this.fpf.getServiceObjectElementsParserRules();
                Vector<FirewallPolicyParserRule> objTypeDetectionPRs = this.fpf.getObjectTypeDetectionParserRules();
                FirewallPolicyParserRule rule = objTypeDetectionPRs.get(0);
                boolean objTypePatternMatched = false;
                boolean patternMatched = false;
                ArrayList<FirewallPolicyParserRuleAttribute> attributes = null;
                Pattern pattern = null;
                while ((strLine = reader.readLine()) != null) {
                    if ((strLine = strLine.trim()).equals("")) continue;
                    objTypePatternMatched = false;
                    patternMatched = false;
                    String expression = rule.getRegex();
                    objTypePatternMatched = this.policyProcessorUtilityObject.executeParserRule(strLine, expression, attributes = rule.getAttributes(), pattern = rule.getPattern(), resultMap);
                    if (objTypePatternMatched) {
                        String objType = resultMap.get((Object)FWAEnumConstants.ParserKeys.OBJTYPE);
                        if ("network".equals(objType)) {
                            objNamePR = netObjnamePR;
                            objElementsPR = netObjElementsPR;
                            objNameTypeToPass = "netObjName";
                            objElementTypeToPass = "netObjElements";
                        } else if ("service".equals(objType)) {
                            objNamePR = serviceObjnamePR;
                            objElementsPR = serviceObjElementsPR;
                            objNameTypeToPass = "serviceObjName";
                            objElementTypeToPass = "serviceObjElements";
                        }
                    }
                    if ((patternMatched = this.executeParserRuleList(strLine, objElementsPR, objElementTypeToPass, resultMap)) || (patternMatched = this.executeParserRuleList(strLine, objNamePR, objNameTypeToPass, resultMap)) || (patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, expression))) continue;
                    break;
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Firewall Object for the resource " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    private void parseAndProcessObjectGroups(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block19: {
            BufferedReader reader = null;
            try {
                String strLine;
                int startIndex = configData.indexOf("\nobject-group ");
                if (startIndex <= -1) break block19;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                String objGroupNameTypeToPass = "";
                String objGroupElementTypeToPass = "";
                Vector<FirewallPolicyParserRule> objGroupNamePR = null;
                Vector<FirewallPolicyParserRule> objGroupElementsPR = null;
                Vector<FirewallPolicyParserRule> netObjGroupNamePR = this.fpf.getNetworkObjectGroupNameParserRules();
                Vector<FirewallPolicyParserRule> netObjGroupElementsPR = this.fpf.getNetworkObjectGroupElementsParserRules();
                Vector<FirewallPolicyParserRule> serviceObjGroupNamePR = this.fpf.getServiceObjectGroupNameParserRules();
                Vector<FirewallPolicyParserRule> serviceObjGroupElementsPR = this.fpf.getServiceObjectGroupElementsParserRules();
                Vector<FirewallPolicyParserRule> protoObjGroupNamePR = this.fpf.getProtocolObjectGroupNameParserRules();
                Vector<FirewallPolicyParserRule> protoObjGroupElementsPR = this.fpf.getProtocolObjectGroupElementsParserRules();
                Vector<FirewallPolicyParserRule> icmpObjGroupNamePR = this.fpf.getICMPObjectGroupNameParserRules();
                Vector<FirewallPolicyParserRule> icmpObjGroupElementsPR = this.fpf.getICMPObjectGroupElementsParserRules();
                Vector<FirewallPolicyParserRule> objGroupTypeDetectionPRs = this.fpf.getObjectGroupTypeDetectionParserRules();
                FirewallPolicyParserRule rule = objGroupTypeDetectionPRs.get(0);
                ArrayList<FirewallPolicyParserRuleAttribute> attributes = null;
                Pattern pattern = null;
                while ((strLine = reader.readLine()) != null) {
                    if ((strLine = strLine.trim()).equals("")) continue;
                    boolean objGroupTypePatternMatched = false;
                    boolean patternMatched = false;
                    String expression = rule.getRegex();
                    objGroupTypePatternMatched = this.policyProcessorUtilityObject.executeParserRule(strLine, expression, attributes = rule.getAttributes(), pattern = rule.getPattern(), resultMap);
                    if (objGroupTypePatternMatched) {
                        String objGroupType = resultMap.get((Object)FWAEnumConstants.ParserKeys.OBJGROUPTYPE);
                        if ("network".equals(objGroupType)) {
                            objGroupNamePR = netObjGroupNamePR;
                            objGroupElementsPR = netObjGroupElementsPR;
                            objGroupNameTypeToPass = "netObjGroupName";
                            objGroupElementTypeToPass = "netObjGroupElements";
                        } else if ("service".equals(objGroupType)) {
                            objGroupNamePR = serviceObjGroupNamePR;
                            objGroupElementsPR = serviceObjGroupElementsPR;
                            objGroupNameTypeToPass = "serviceObjGroupName";
                            objGroupElementTypeToPass = "serviceObjGroupElements";
                        } else if ("protocol".equals(objGroupType)) {
                            objGroupNamePR = protoObjGroupNamePR;
                            objGroupElementsPR = protoObjGroupElementsPR;
                            objGroupNameTypeToPass = "protocolObjGroupName";
                            objGroupElementTypeToPass = "protocolObjGroupElements";
                        } else if ("icmp-type".equals(objGroupType)) {
                            objGroupNamePR = icmpObjGroupNamePR;
                            objGroupElementsPR = icmpObjGroupElementsPR;
                            objGroupNameTypeToPass = "icmpObjGroupName";
                            objGroupElementTypeToPass = "icmpObjGroupElements";
                        }
                    }
                    if ((patternMatched = this.executeParserRuleList(strLine, objGroupElementsPR, objGroupElementTypeToPass, resultMap)) || (patternMatched = this.executeParserRuleList(strLine, objGroupNamePR, objGroupNameTypeToPass, resultMap)) || (patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, expression))) continue;
                    break;
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Network Object Groups for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    private void parseAndProcessPolicyObjects(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block13: {
            BufferedReader reader = null;
            try {
                String strLine;
                String startExpression = this.fpf.getPolicyStartExpression();
                Pattern startPattern = this.fpf.getPolicyStartPattern();
                int startIndex = configData.indexOf("\naccess-list ");
                if (startIndex <= -1) break block13;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                boolean patternMatched = false;
                Vector<FirewallPolicyParserRule> ruleObjElementsPR = this.fpf.getRuleElementsParserRules();
                while ((strLine = reader.readLine()) != null) {
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, startExpression, startPattern);
                    if (!patternMatched) continue;
                    String strToProcess = strLine;
                    while ((strLine = reader.readLine()) != null) {
                        patternMatched = false;
                        patternMatched = this.executeParserRuleList(strToProcess, ruleObjElementsPR, "ruleObjElements", resultMap);
                        if (!patternMatched && !strToProcess.startsWith("access-list ")) {
                            break block13;
                        }
                        strToProcess = strLine;
                    }
                    break;
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Policy Objects for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void parseAndProcessSiteToSiteVPNConfig(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults) throws Exception {
        block14: {
            BufferedReader reader = null;
            try {
                String strLine;
                String startExpression = this.fpf.getSiteToSiteVPNStartExpression();
                Pattern startPattern = this.fpf.getSiteToSiteVPNStartPattern();
                int startIndex = configData.indexOf("\ncrypto map ");
                if (startIndex <= -1) break block14;
                Vector<FirewallPolicyParserRule> siteToSiteVPNPR = this.fpf.getSiteToSiteVPNConfigParserRules();
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                boolean patternMatched = false;
                while ((strLine = reader.readLine()) != null) {
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!patternMatched) continue;
                    String strToProcess = strLine;
                    while ((strLine = reader.readLine()) != null) {
                        patternMatched = false;
                        strLine = strLine.trim();
                        this.executeParserRuleListAndGetResultMap(strToProcess, siteToSiteVPNPR, parseResults);
                        if (parseResults.isEmpty()) {
                            break block14;
                        }
                        String siteToSiteACL = parseResults.get((Object)FWAEnumConstants.ParserKeys.ACLFORSITETOSITEVPN);
                        if (siteToSiteACL != null) {
                            this.siteToSiteVPNACLs.add(siteToSiteACL);
                        }
                        strToProcess = strLine;
                    }
                    break;
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Site to Site VPN config for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void parseAndProcessGroupPolicyConfig(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults) throws Exception {
        block15: {
            BufferedReader reader = null;
            try {
                String strLine;
                String startExpression = this.fpf.getGroupPolicyStartExpression();
                Pattern startPattern = this.fpf.getGroupPolicyStartPattern();
                int startIndex = configData.indexOf("\ngroup-policy ");
                if (startIndex <= -1) break block15;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                boolean matches = false;
                while ((strLine = reader.readLine()) != null) {
                    matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!matches) continue;
                    Vector<FirewallPolicyParserRule> groupPolicyPR = this.fpf.getGroupPolicyConfigParserRules();
                    String strToProcess = strLine;
                    String currentGroupPolicyName = null;
                    Iterator<FWAEnumConstants.ParserKeys> itr = null;
                    while ((strLine = reader.readLine()) != null) {
                        this.executeParserRuleListAndGetResultMap(strToProcess, groupPolicyPR, parseResults);
                        for (FWAEnumConstants.ParserKeys key : parseResults.keySet()) {
                            String value = parseResults.get((Object)key);
                            if (key == FWAEnumConstants.ParserKeys.GROUPPOLICYNAME) {
                                currentGroupPolicyName = value;
                                continue;
                            }
                            if (key != FWAEnumConstants.ParserKeys.GROUPPOLICYACL || currentGroupPolicyName == null) continue;
                            this.groupPolicyVsACLMap.put(currentGroupPolicyName, value);
                        }
                        if (parseResults.isEmpty()) {
                            break block15;
                        }
                        strToProcess = strLine;
                    }
                    break;
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Site to Site VPN config for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void parseAndProcessIPPoolConfig(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults) throws Exception {
        block19: {
            BufferedReader reader = null;
            try {
                String strLine;
                String startExpression = this.fpf.getIPPoolConfigStartExpression();
                Pattern startPattern = this.fpf.getIPPoolConfigStartPattern();
                int startIndex = configData.indexOf("\nip local pool ");
                if (startIndex <= -1) break block19;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                boolean matches = false;
                while ((strLine = reader.readLine()) != null) {
                    strLine = strLine.trim();
                    LOGGER.log(Level.FINER, "IP Pool config line..." + strLine);
                    matches = this.policyProcessorUtilityObject.matchPattern(strLine, startExpression, startPattern);
                    if (!matches) continue;
                    Vector<FirewallPolicyParserRule> ipPoolConfigPR = this.fpf.getIPPoolConfigParserRules();
                    String strToProcess = strLine;
                    Iterator<FWAEnumConstants.ParserKeys> itr = null;
                    while ((strLine = reader.readLine()) != null) {
                        String ipPoolName = null;
                        String ipPoolStart = null;
                        String ipPoolEnd = null;
                        long minIPID = 0L;
                        long maxIPID = 0L;
                        this.executeParserRuleListAndGetResultMap(strToProcess, ipPoolConfigPR, parseResults);
                        for (FWAEnumConstants.ParserKeys key : parseResults.keySet()) {
                            String value = parseResults.get((Object)key);
                            if (key == FWAEnumConstants.ParserKeys.IPPOOLNAME) {
                                ipPoolName = value;
                                continue;
                            }
                            if (key == FWAEnumConstants.ParserKeys.IPPOOLSTARTIP) {
                                if (!this.policyProcessorUtilityObject.checkForValidIP(value)) {
                                    this.usedObjects.add(value);
                                    value = this.nameObjMap.get(value);
                                }
                                ipPoolStart = value;
                                continue;
                            }
                            if (key == FWAEnumConstants.ParserKeys.IPPOOLENDIP && ipPoolStart != null) {
                                if (!this.policyProcessorUtilityObject.checkForValidIP(value)) {
                                    this.usedObjects.add(value);
                                    value = this.nameObjMap.get(value);
                                }
                                ipPoolEnd = value;
                                continue;
                            }
                            if (key != FWAEnumConstants.ParserKeys.IPPOOLMASK || ipPoolStart == null) continue;
                            String network = IPRange.getNetwork((String)value, (String)ipPoolStart);
                            long[] minMaxIPLong = IPRange.getMinMaxLong((String)network, (String)value);
                            minIPID = minMaxIPLong[0];
                            maxIPID = ipPoolEnd != null ? IPRange.getIPNumber((String)ipPoolEnd) : minMaxIPLong[1];
                            String ipRangeDBVal = minIPID + "-" + maxIPID;
                            this.ipPoolMap.put(ipPoolName, ipRangeDBVal);
                        }
                        if (parseResults.isEmpty()) {
                            break block19;
                        }
                        strToProcess = strLine;
                    }
                    break;
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Site to Site VPN config for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void parseAndProcessTunnelGroupConfig(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults) throws Exception {
        block17: {
            BufferedReader reader = null;
            try {
                String strLine;
                String startExpression = this.fpf.getTunnelGroupStartExpression();
                Pattern startPattern = this.fpf.getTunnelGroupStartPattern();
                int startIndex = configData.indexOf("\ntunnel-group ");
                if (startIndex <= -1) break block17;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                boolean matches = false;
                while ((strLine = reader.readLine()) != null) {
                    matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!matches) continue;
                    Vector<FirewallPolicyParserRule> tunnelGroupPR = this.fpf.getTunnelGroupConfigParserRules();
                    String strToProcess = strLine;
                    String currentTunnelType = null;
                    Iterator<FWAEnumConstants.ParserKeys> itr = null;
                    while ((strLine = reader.readLine()) != null) {
                        this.executeParserRuleListAndGetResultMap(strToProcess, tunnelGroupPR, parseResults);
                        for (FWAEnumConstants.ParserKeys key : parseResults.keySet()) {
                            String value = parseResults.get((Object)key);
                            if (key == FWAEnumConstants.ParserKeys.TUNNELTYPE) {
                                currentTunnelType = value;
                                continue;
                            }
                            if (key == FWAEnumConstants.ParserKeys.GROUPPOLICYNAME && currentTunnelType != null) {
                                String tunnelACL = this.groupPolicyVsACLMap.get(value);
                                if (tunnelACL == null) continue;
                                if (currentTunnelType.equals("ipsec-l2l")) {
                                    this.siteToSiteVPNACLs.add(tunnelACL);
                                    continue;
                                }
                                this.vpnACLs.add(tunnelACL);
                                continue;
                            }
                            if (key != FWAEnumConstants.ParserKeys.VPNADDRPOOL) continue;
                            String ipPool = this.ipPoolMap.get(value);
                            this.vpnIPPoolList.add(ipPool);
                        }
                        if (parseResults.isEmpty()) {
                            break block17;
                        }
                        strToProcess = strLine;
                    }
                    break;
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Site to Site VPN config for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void parseAndProcessDAPRecordConfig(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults) throws Exception {
        block14: {
            BufferedReader reader = null;
            try {
                String strLine;
                String startExpression = this.fpf.getDAPRecordStartExpression();
                Pattern startPattern = this.fpf.getDAPRecordStartPattern();
                int startIndex = configData.indexOf("\ndynamic-access-policy-record ");
                if (startIndex <= -1) break block14;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                boolean matches = false;
                while ((strLine = reader.readLine()) != null) {
                    Vector<FirewallPolicyParserRule> dapRecordPR = this.fpf.getDAPRecordConfigParserRules();
                    strLine = strLine.trim();
                    Iterator<FWAEnumConstants.ParserKeys> itr = null;
                    matches = this.policyProcessorUtilityObject.matchPattern(strLine, startExpression, startPattern);
                    if (!matches) continue;
                    String strToProcess = strLine;
                    while ((strLine = reader.readLine()) != null) {
                        this.executeParserRuleListAndGetResultMap(strToProcess, dapRecordPR, parseResults);
                        for (FWAEnumConstants.ParserKeys key : parseResults.keySet()) {
                            String value = parseResults.get((Object)key);
                            if (key != FWAEnumConstants.ParserKeys.DAPRECORDACL) continue;
                            this.vpnACLs.add(value);
                        }
                        if (parseResults.isEmpty()) {
                            break block14;
                        }
                        strToProcess = strLine;
                    }
                    break;
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Site to Site VPN config for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseAndProcessSnmpConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        sb.setLength(0);
        String snmpCommunityStr = null;
        String snmpCommunityConfigLine = null;
        BufferedReader reader = null;
        try {
            int startIndex = configData.indexOf("\nsnmp-server ");
            if (startIndex > -1) {
                String strLine;
                String startExpression = fpf.getSNMPConfigStartExpression();
                Pattern startPattern = fpf.getSNMPConfigStartPattern();
                boolean matches = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                block18: while ((strLine = reader.readLine()) != null) {
                    matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!matches) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> snmpConfigPR = fpf.getSNMPConfigParserRules();
                    Iterator<FWAEnumConstants.ParserKeys> itr = null;
                    while ((strLine = reader.readLine()) != null) {
                        strLine = strLine.trim();
                        this.executeParserRuleListAndGetResultMap(strToProcess, snmpConfigPR, parseResults);
                        if (parseResults.isEmpty()) break block18;
                        for (FWAEnumConstants.ParserKeys key : parseResults.keySet()) {
                            String value = parseResults.get((Object)key);
                            switch (key) {
                                case SNMPSERVERCONFIGLINE: {
                                    sb.append("<strong>");
                                    sb.append(value);
                                    sb.append("</strong>");
                                    break;
                                }
                                case SNMPACCESSCONFIGLINE: {
                                    sb.append("<strong>");
                                    sb.append(value);
                                    sb.append("</strong>");
                                    break;
                                }
                                case SNMPCOMMUNITYCONFIGLINE: {
                                    snmpCommunityConfigLine = value;
                                    break;
                                }
                                case SNMPCOMMUNITY: {
                                    snmpCommunityStr = value;
                                    if (snmpCommunityStr == null || snmpCommunityConfigLine == null) break;
                                    sb.append("<strong>");
                                    sb.append(snmpCommunityConfigLine);
                                    sb.append("</strong>");
                                    break;
                                }
                                case SNMPMISCELLANEOUS: {
                                    sb.append(value);
                                    break;
                                }
                            }
                            sb.append("<br>");
                        }
                        strToProcess = strLine;
                    }
                    break block18;
                }
            }
            Long genericSectionID = new Long(4L);
            String snmpServerData = this.policyProcessorUtilityObject.removeLastDelimeter(sb, "<br>");
            String status = null;
            if (snmpServerData == null || "".equals(snmpServerData.trim())) {
                snmpServerData = this.bundle.getString("SNMP_NOT_CONFIGURED");
                status = "Pass";
            } else {
                status = snmpServerData.indexOf("public") > 0 ? "Fail" : "Pass";
            }
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, snmpServerData, status, this.versionNo);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseAndProcessHttpConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        sb.setLength(0);
        String httpServerStatus = null;
        String httpServerConfigLine = null;
        BufferedReader reader = null;
        try {
            int startIndex = configData.indexOf("\nhttp server ");
            if (startIndex > -1) {
                String strLine;
                String startExpression = fpf.getHTTPConfigStartExpression();
                Pattern startPattern = fpf.getHTTPConfigStartPattern();
                boolean matches = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                block11: while ((strLine = reader.readLine()) != null) {
                    matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!matches) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> httpConfigPR = fpf.getHTTPConfigParserRules();
                    Iterator<FWAEnumConstants.ParserKeys> itr = null;
                    while ((strLine = reader.readLine()) != null) {
                        strLine = strLine.trim();
                        this.executeParserRuleListAndGetResultMap(strToProcess, httpConfigPR, parseResults);
                        if (parseResults.isEmpty()) break block11;
                        for (FWAEnumConstants.ParserKeys key : parseResults.keySet()) {
                            String value = parseResults.get((Object)key);
                            if (key == FWAEnumConstants.ParserKeys.HTTPACCESSCONFIGLINE) {
                                sb.append(value);
                            } else if (key == FWAEnumConstants.ParserKeys.HTTPSERVERCONFIGLINE) {
                                httpServerConfigLine = value;
                            } else if (key == FWAEnumConstants.ParserKeys.HTTPSERVERSTATUS) {
                                httpServerStatus = value;
                                if (httpServerConfigLine != null && httpServerStatus != null) {
                                    httpServerConfigLine = httpServerConfigLine.replaceAll(httpServerStatus, "<strong>" + httpServerStatus + "</strong>");
                                    sb.append(httpServerConfigLine);
                                }
                            }
                            sb.append("<br>");
                        }
                        strToProcess = strLine;
                    }
                    break block11;
                }
            }
            Long genericSectionID = new Long(1L);
            String httpServerData = this.policyProcessorUtilityObject.removeLastDelimeter(sb, "<br>");
            String status = null;
            if (httpServerData == null || "".equals(httpServerData.trim())) {
                httpServerData = this.bundle.getString("HTTP_NOT_CONFIGURED");
                status = "Pass";
            } else {
                String defaultStatus = this.getDefaultCheckListItemStatus(genericSectionID);
                status = httpServerData != null && httpServerData.indexOf("enable") > 0 ? defaultStatus : "Pass";
            }
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, httpServerData, status, this.versionNo);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseAndProcessTelnetConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        sb.setLength(0);
        BufferedReader reader = null;
        try {
            int startIndex = configData.indexOf("\ntelnet ");
            if (startIndex > -1) {
                String strLine;
                String startExpression = fpf.getTelnetConfigStartExpression();
                Pattern startPattern = fpf.getTelnetConfigStartPattern();
                boolean matches = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                block11: while ((strLine = reader.readLine()) != null) {
                    matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!matches) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> telnetConfigPR = fpf.getTelnetConfigParserRules();
                    Iterator<FWAEnumConstants.ParserKeys> itr = null;
                    while ((strLine = reader.readLine()) != null) {
                        strLine = strLine.trim();
                        this.executeParserRuleListAndGetResultMap(strToProcess, telnetConfigPR, parseResults);
                        if (parseResults.isEmpty()) break block11;
                        for (FWAEnumConstants.ParserKeys key : parseResults.keySet()) {
                            String value = parseResults.get((Object)key);
                            if (key == FWAEnumConstants.ParserKeys.TELNETACCESSCONFIGLINE) {
                                sb.append(value);
                            }
                            sb.append("<br>");
                        }
                        strToProcess = strLine;
                    }
                    break block11;
                }
            }
            Long genericSectionID = new Long(2L);
            String telnetServerData = this.policyProcessorUtilityObject.removeLastDelimeter(sb, "<br>");
            boolean dataExists = telnetServerData != null && !"".equals(telnetServerData.trim());
            String statusIfData = this.getDefaultCheckListItemStatus(genericSectionID);
            String statusToBeInDB = null;
            if (!dataExists) {
                telnetServerData = this.bundle.getString("TELNET_NOT_CONFIGURED");
                statusToBeInDB = "Pass";
            } else {
                statusToBeInDB = statusIfData;
            }
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, telnetServerData, statusToBeInDB, this.versionNo);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseAndProcessSSHConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        sb.setLength(0);
        BufferedReader reader = null;
        try {
            int startIndex = configData.indexOf("\nssh ");
            if (startIndex > -1) {
                String strLine;
                String startExpression = fpf.getSSHConfigStartExpression();
                Pattern startPattern = fpf.getSSHConfigStartPattern();
                boolean matches = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                block11: while ((strLine = reader.readLine()) != null) {
                    matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!matches) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> sshConfigPR = fpf.getSSHConfigParserRules();
                    Iterator<FWAEnumConstants.ParserKeys> itr = null;
                    while ((strLine = reader.readLine()) != null) {
                        strLine = strLine.trim();
                        this.executeParserRuleListAndGetResultMap(strToProcess, sshConfigPR, parseResults);
                        if (parseResults.isEmpty()) break block11;
                        for (FWAEnumConstants.ParserKeys key : parseResults.keySet()) {
                            String value = parseResults.get((Object)key);
                            if (key == FWAEnumConstants.ParserKeys.SSHACCESSCONFIGLINE) {
                                sb.append(value);
                            }
                            sb.append("<br>");
                        }
                        strToProcess = strLine;
                    }
                    break block11;
                }
            }
            Long genericSectionID = new Long(3L);
            String sshServerData = this.policyProcessorUtilityObject.removeLastDelimeter(sb, "<br>");
            boolean dataExists = sshServerData != null && !"".equals(sshServerData.trim());
            String statusIfData = this.getDefaultCheckListItemStatus(genericSectionID);
            String statusToBeInDB = null;
            if (!dataExists) {
                sshServerData = this.bundle.getString("SSH_NOT_CONFIGURED");
                statusToBeInDB = "UserCall";
            } else {
                statusToBeInDB = statusIfData;
            }
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, sshServerData, statusToBeInDB, this.versionNo);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    public String getDefaultCheckListItemStatus(Long genericSectionID) {
        try {
            Criteria crit = new Criteria(new Column("FWAConfigCheckListDetails", "GENERIC_SECTION_ID"), (Object)genericSectionID, 0);
            DataObject complianceCheckListSectionDO = DataAccess.get((String)"FWAConfigCheckListDetails", (Criteria)crit);
            if (!complianceCheckListSectionDO.isEmpty()) {
                String defaultStatus = (String)complianceCheckListSectionDO.getFirstValue("FWAConfigCheckListDetails", "STATUS_DECIDER");
                defaultStatus = "".equals(defaultStatus = defaultStatus.trim()) ? null : defaultStatus;
                return defaultStatus;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseAndProcessUserAccessConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        sb.setLength(0);
        BufferedReader reader = null;
        try {
            int startIndex = configData.indexOf("\nusername ");
            if (startIndex > -1) {
                String strLine;
                String startExpression = fpf.getUserAccessConfigStartExpression();
                Pattern startPattern = fpf.getUserAccessConfigStartPattern();
                boolean matches = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                while ((strLine = reader.readLine()) != null) {
                    matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!matches) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> userAccessConfigPR = fpf.getUserAccessConfigParserRules();
                    Iterator<FWAEnumConstants.ParserKeys> itr = null;
                    while ((strLine = reader.readLine()) != null) {
                        strLine = strLine.trim();
                        this.executeParserRuleListAndGetResultMap(strToProcess, userAccessConfigPR, parseResults);
                        for (FWAEnumConstants.ParserKeys key : parseResults.keySet()) {
                            String value = parseResults.get((Object)key);
                            if (key == FWAEnumConstants.ParserKeys.USERACCESSCONFIGLINE) {
                                sb.append(value);
                            }
                            sb.append("<br>");
                        }
                        strToProcess = strLine;
                    }
                    break block11;
                }
            }
            Long genericSectionID = new Long(5L);
            String userAccessServerData = this.policyProcessorUtilityObject.removeLastDelimeter(sb, "<br>");
            String status = null;
            if (userAccessServerData == null || "".equals(userAccessServerData.trim())) {
                userAccessServerData = this.bundle.getString("UserAccess_NOT_CONFIGURED");
                status = "Pass";
            }
            status = "UserCall";
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, userAccessServerData, status, this.versionNo);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseAndProcessNTPConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        sb.setLength(0);
        String ntpAuthConfigLine = null;
        String ntpAuthKeyID = null;
        String ntpTrustedKeyConfigLine = null;
        String ntpTrustedKeyID = null;
        String ntpServerConfigLine = null;
        String ntpServerTrustedKeyID = null;
        BufferedReader reader = null;
        try {
            StringBuilder dbDataSB;
            boolean isTrusted = false;
            boolean isAuthName = false;
            int startIndex = configData.indexOf("\nntp ");
            if (startIndex > -1) {
                String strLine;
                String startExpression = fpf.getNTPConfigStartExpression();
                Pattern startPattern = fpf.getNTPConfigStartPattern();
                boolean matches = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                block21: while ((strLine = reader.readLine()) != null) {
                    matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!matches) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> ntpConfigPR = fpf.getNTPConfigParserRules();
                    Iterator<FWAEnumConstants.ParserKeys> itr = null;
                    while ((strLine = reader.readLine()) != null) {
                        strLine = strLine.trim();
                        this.executeParserRuleListAndGetResultMap(strToProcess, ntpConfigPR, parseResults);
                        if (parseResults.isEmpty()) break block21;
                        for (FWAEnumConstants.ParserKeys key : parseResults.keySet()) {
                            String value = parseResults.get((Object)key);
                            switch (key) {
                                case NTPAUTHCONFIGLINE: {
                                    ntpAuthConfigLine = value;
                                    break;
                                }
                                case NTPAUTHKEYID: {
                                    ntpAuthKeyID = value;
                                    isTrusted = true;
                                    if (ntpAuthConfigLine != null && ntpAuthKeyID != null && ntpAuthKeyID.indexOf("*") < 0) {
                                        ntpAuthConfigLine = ntpAuthConfigLine.replaceAll(ntpAuthKeyID, "x");
                                    }
                                    if (parseResults.containsKey("NTPAuthKeyName")) break;
                                    sb.append(ntpAuthConfigLine);
                                    break;
                                }
                                case NTPAUTHKEYNAME: {
                                    isAuthName = true;
                                    isTrusted = true;
                                    if (ntpAuthConfigLine != null && value != null && !"".equals(value.trim()) && value.indexOf("*") < 0) {
                                        ntpAuthConfigLine = ntpAuthConfigLine.replaceAll(value, "xxxxx");
                                    }
                                    sb.append(ntpAuthConfigLine);
                                    break;
                                }
                                case NTPTRUSTEDKEYCONFIGLINE: {
                                    ntpTrustedKeyConfigLine = value;
                                    break;
                                }
                                case NTPTRUSTEDKEYID: {
                                    isTrusted = true;
                                    ntpTrustedKeyID = value;
                                    if (ntpTrustedKeyConfigLine != null && ntpTrustedKeyID != null && ntpTrustedKeyID.indexOf("*") < 0) {
                                        ntpTrustedKeyConfigLine = ntpTrustedKeyConfigLine.replaceAll(ntpTrustedKeyID, "x");
                                    }
                                    sb.append(ntpTrustedKeyConfigLine);
                                    break;
                                }
                                case NTPSERVERCONFIGLINE: {
                                    ntpServerConfigLine = value;
                                    break;
                                }
                                case NTPSERVERTRUSTEDKEYID: {
                                    ntpServerTrustedKeyID = value;
                                    if (ntpServerConfigLine != null && ntpServerTrustedKeyID != null && ntpServerTrustedKeyID.indexOf("*") < 0) {
                                        ntpServerConfigLine = ntpServerConfigLine.replaceAll(" " + ntpServerTrustedKeyID + " ", " x ");
                                    }
                                    sb.append(ntpServerConfigLine);
                                    break;
                                }
                                case NTPCONFIGLINE: {
                                    sb.append(value);
                                    break;
                                }
                            }
                            sb.append("<br>");
                        }
                        strToProcess = strLine;
                    }
                    break block21;
                }
            }
            String ntpServerData = sb.toString();
            String dataToPutInToDB = null;
            String status = null;
            if (!"".equals(ntpServerData.trim())) {
                dataToPutInToDB = ntpServerData;
                status = "Pass";
                dbDataSB = new StringBuilder();
                if (!isTrusted) {
                    dbDataSB.append(dataToPutInToDB);
                    dbDataSB.append("<br>");
                    dbDataSB.append("<strong>");
                    dbDataSB.append(this.bundle.getString("NTP_Recommendation_String"));
                    dbDataSB.append("</strong>");
                    dbDataSB.append("<br>");
                    dbDataSB.append(this.bundle.getString("NTP_NO_TRUSTED_KEY_ID"));
                    dbDataSB.append("<br>");
                    dbDataSB.append("ntp authenticate");
                    dbDataSB.append("<br>");
                    dbDataSB.append("ntp trusted-key <key_id>");
                    dbDataSB.append("<br>");
                    dbDataSB.append("ntp authentication-key <key_id> md5 <key>");
                    dbDataSB.append("<br>");
                    dbDataSB.append("ntp server <ip_address> [key key_id] [source interface_name] [prefer]");
                    dataToPutInToDB = dbDataSB.toString();
                } else if (!isAuthName) {
                    dbDataSB.append(dataToPutInToDB);
                    dbDataSB.append("<br>");
                    dbDataSB.append("<strong>");
                    dbDataSB.append(this.bundle.getString("NTP_Recommendation_String"));
                    dbDataSB.append("</strong>");
                    dbDataSB.append("<br>");
                    dbDataSB.append(this.bundle.getString("NTP_NO_AUTH_KEY"));
                    dbDataSB.append("<br>");
                    dbDataSB.append("ntp authenticate");
                    dbDataSB.append("<br>");
                    dbDataSB.append("ntp trusted-key <key_id>");
                    dbDataSB.append("<br>");
                    dbDataSB.append("ntp authentication-key <key_id> md5 <key>");
                    dbDataSB.append("<br>");
                    dbDataSB.append("ntp server <ip_address> [key key_id] [source interface_name] [prefer]");
                    dataToPutInToDB = dbDataSB.toString();
                }
            } else {
                status = "UserCall";
                dataToPutInToDB = this.bundle.getString("No_NTP_Generic_Messsage");
                dataToPutInToDB = dataToPutInToDB.replaceAll("FortiGate", this.deviceType);
                dbDataSB = new StringBuilder();
                dbDataSB.append(dataToPutInToDB);
                dbDataSB.append("ntp authenticate");
                dbDataSB.append("<br>");
                dbDataSB.append("ntp trusted-key <key_id>");
                dbDataSB.append("<br>");
                dbDataSB.append("ntp authentication-key <key_id> md5 <key>");
                dbDataSB.append("<br>");
                dbDataSB.append("ntp server <ip_address> [key key_id] [source interface_name] [prefer]");
                dataToPutInToDB = dbDataSB.toString();
            }
            Long genericSectionID = new Long(6L);
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, dataToPutInToDB, status, this.versionNo);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseAndProcessSyslogLoggingConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        BufferedReader reader = null;
        try {
            boolean isLoggingEnable = false;
            String severity = null;
            int startIndex = configData.indexOf("\nlogging ");
            if (startIndex > -1) {
                String strLine;
                String startExpression = fpf.getSyslogConfigStartExpression();
                Pattern startPattern = fpf.getSyslogConfigStartPattern();
                boolean matches = false;
                String configToBeProcessed = configData.substring(startIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                block11: while ((strLine = reader.readLine()) != null) {
                    matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (!matches) continue;
                    String strToProcess = strLine;
                    Vector<FirewallPolicyParserRule> syslogLoggingConfigPR = fpf.getSyslogLoggingConfigParserRules();
                    Iterator<FWAEnumConstants.ParserKeys> itr = null;
                    while ((strLine = reader.readLine()) != null) {
                        strLine = strLine.trim();
                        this.executeParserRuleListAndGetResultMap(strToProcess, syslogLoggingConfigPR, parseResults);
                        itr = parseResults.keySet().iterator();
                        if (parseResults.isEmpty()) break block11;
                        while (itr.hasNext()) {
                            FWAEnumConstants.ParserKeys key = itr.next();
                            String value = parseResults.get((Object)key);
                            if (key == FWAEnumConstants.ParserKeys.LOGENABLE) {
                                isLoggingEnable = true;
                                continue;
                            }
                            if (key != FWAEnumConstants.ParserKeys.LOGSEVERITY) continue;
                            severity = value;
                        }
                        strToProcess = strLine;
                    }
                    break block11;
                }
            }
            Long genericSectionID = new Long(8L);
            String status = "Fail";
            String data = this.bundle.getString("No_Logging_Messsage");
            if (isLoggingEnable) {
                status = "Pass";
                data = this.bundle.getString("Logging_Enabled");
                if (severity != null) {
                    String severityNumber = this.policyProcessorUtilityObject.getPriorityFrmMem(severity);
                    int sev = Integer.parseInt(severityNumber);
                    if (sev < 4) {
                        status = "Fail";
                        data = this.bundle.getString("Change_Logging_Severity");
                    } else {
                        data = this.bundle.getString("Logging_Enabled_With_Severity");
                    }
                    data = data.replaceAll("<data>", severity);
                }
            }
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, data, status, this.versionNo);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    private void executeParserRuleListAndGetResultMap(String data, Vector<FirewallPolicyParserRule> parserRules, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults) throws Exception {
        Pattern pattern;
        ArrayList<FirewallPolicyParserRuleAttribute> attributes;
        FirewallPolicyParserRule rule;
        String expression;
        boolean patternMatched;
        Iterator<FirewallPolicyParserRule> i$ = parserRules.iterator();
        while (i$.hasNext() && !(patternMatched = this.policyProcessorUtilityObject.executeParserRule(data, expression = (rule = i$.next()).getRegex(), attributes = rule.getAttributes(), pattern = rule.getPattern(), parseResults))) {
        }
    }

    private boolean executeParserRuleList(String data, Vector<FirewallPolicyParserRule> parserRules, String parserRuleType, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        boolean patternMatched = false;
        for (FirewallPolicyParserRule rule : parserRules) {
            Pattern pattern;
            ArrayList<FirewallPolicyParserRuleAttribute> attributes;
            String expression = rule.getRegex();
            patternMatched = this.policyProcessorUtilityObject.executeParserRule(data, expression, attributes = rule.getAttributes(), pattern = rule.getPattern(), resultMap);
            if (!patternMatched) continue;
            String objName = null;
            if (parserRuleType.equals("ruleObjElements")) {
                boolean isRuleCommentConfigLine = false;
                RuleObject ruleObj = new RuleObject();
                String aclType = "extended";
                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                    String ipRangeIDDBVal;
                    long[] minMaxIPLong;
                    String network;
                    String subnet;
                    String value = resultMap.get((Object)key);
                    switch (key) {
                        case POLICYNAME: {
                            this.currentPolicyName = value;
                            break;
                        }
                        case RULENAME: {
                            ruleObj.setName(value);
                            break;
                        }
                        case RULECOMMENT: {
                            this.currentACEComment = value;
                            isRuleCommentConfigLine = true;
                            break;
                        }
                        case ACTION: {
                            ruleObj.setAction(value);
                            break;
                        }
                        case ACLTYPE: {
                            aclType = value;
                            break;
                        }
                    }
                    if (aclType == null || isRuleCommentConfigLine) continue;
                    ruleObj.setType(aclType);
                    if (aclType.equals("extended")) {
                        String tmp = null;
                        String subnet2 = null;
                        switch (key) {
                            case PROTOCOLOBJGRP: {
                                if (this.serviceObjList.contains(value)) {
                                    ruleObj.setService(value);
                                    break;
                                }
                                ruleObj.setProtocol(value);
                                break;
                            }
                            case PROTOCOLOBJ: {
                                if (this.serviceObjList.contains(value)) {
                                    ruleObj.setService(value);
                                    break;
                                }
                                ruleObj.setProtocol(value);
                                break;
                            }
                            case PROTOCOL: {
                                if (this.serviceObjList.contains(value)) {
                                    ruleObj.setService(value);
                                    break;
                                }
                                ruleObj.setProtocol(value);
                                break;
                            }
                            case ANYSRC: {
                                ruleObj.setSrcAddr(value);
                                break;
                            }
                            case SRCOBJGRP: {
                                ruleObj.setSrcAddr(value);
                                break;
                            }
                            case SRCOBJ: {
                                ruleObj.setSrcAddr(value);
                                break;
                            }
                            case SRCADDR: {
                                ruleObj.setSrcAddr(value);
                                break;
                            }
                            case SRCNETWORK: {
                                ruleObj.setSrcAddr(value);
                                break;
                            }
                            case USERGRPASSRC: {
                                ruleObj.setSrcAddr(value);
                                break;
                            }
                            case USERASSRC: {
                                ruleObj.setSrcAddr(value);
                                break;
                            }
                            case USEROBJGRPASSRC: {
                                ruleObj.setSrcAddr(value);
                                break;
                            }
                            case SRCNETWORKMASK: {
                                String ipRangeIDDBVal2;
                                subnet2 = ruleObj.getSrcAddr();
                                if (subnet2 == null) break;
                                String network2 = IPRange.getNetwork((String)value, (String)subnet2);
                                long[] minMaxIPLong2 = IPRange.getMinMaxLong((String)network2, (String)value);
                                if (minMaxIPLong2 != null) {
                                    ipRangeIDDBVal2 = minMaxIPLong2[0] + "-" + minMaxIPLong2[1];
                                    ruleObj.setSrcIPIDRange(ipRangeIDDBVal2);
                                }
                                value = subnet2 + "/" + value;
                                ruleObj.setSrcAddr(value);
                                break;
                            }
                            case SRCPORTOPERATOR: {
                                ruleObj.setSrcPort(this.portOperatorMap.get(value.toLowerCase()));
                                break;
                            }
                            case SRCPORT: {
                                tmp = ruleObj.getSrcPort();
                                if (tmp == null) break;
                                value = "srcPort" + tmp + value;
                                ruleObj.setSrcPort(value);
                                break;
                            }
                            case SRCPORTFROM: {
                                ruleObj.setSrcPort(value);
                                break;
                            }
                            case SRCPORTTO: {
                                tmp = ruleObj.getSrcPort();
                                if (tmp == null) break;
                                value = "srcPort=" + tmp + " to " + value;
                                ruleObj.setSrcPort(value);
                                break;
                            }
                            case SRCSERVICEOBJGRP: {
                                if (this.netObjList.contains(value)) {
                                    ruleObj.setDstAddr(value);
                                    break;
                                }
                                ruleObj.setService("Source:" + value);
                                break;
                            }
                            case ICMPVALUE: {
                                tmp = ruleObj.getProtocol();
                                if (value.equals("log") || value.equals("time-range") || value.equals("inactive")) break;
                                value = tmp.toUpperCase() + " " + value;
                                ruleObj.setService(value);
                                break;
                            }
                            case ICMPOBJECT: {
                                if (this.netObjList.contains(value)) {
                                    ruleObj.setDstAddr(value);
                                    break;
                                }
                                ruleObj.setService(value);
                                break;
                            }
                            case ICMPOBJECTGROUP: {
                                if (this.netObjList.contains(value)) {
                                    ruleObj.setDstAddr(value);
                                    break;
                                }
                                ruleObj.setService(value);
                                break;
                            }
                            case ANYDST: {
                                ruleObj.setDstAddr(value);
                                break;
                            }
                            case DSTADDR: {
                                ruleObj.setDstAddr(value);
                                break;
                            }
                            case DSTNETWORK: {
                                ruleObj.setDstAddr(value);
                                break;
                            }
                            case USERGRPASDST: {
                                ruleObj.setDstAddr(value);
                                break;
                            }
                            case USERASDST: {
                                ruleObj.setDstAddr(value);
                                break;
                            }
                            case USEROBJGRPASDST: {
                                ruleObj.setDstAddr(value);
                                break;
                            }
                            case DSTOBJGRP: {
                                if (this.netObjList.contains(value)) {
                                    ruleObj.setDstAddr(value);
                                    break;
                                }
                                ruleObj.setService(value);
                                break;
                            }
                            case DSTOBJ: {
                                if (this.netObjList.contains(value)) {
                                    ruleObj.setDstAddr(value);
                                    break;
                                }
                                ruleObj.setService(value);
                                break;
                            }
                            case DSTNETWORKMASK: {
                                String ipRangeIDDBVal2;
                                subnet2 = ruleObj.getDstAddr();
                                if (subnet2 == null) break;
                                String network2 = IPRange.getNetwork((String)value, (String)subnet2);
                                long[] minMaxIPLong2 = IPRange.getMinMaxLong((String)network2, (String)value);
                                if (minMaxIPLong2 != null) {
                                    ipRangeIDDBVal2 = minMaxIPLong2[0] + "-" + minMaxIPLong2[1];
                                    ruleObj.setDstIPIDRange(ipRangeIDDBVal2);
                                }
                                value = subnet2 + "/" + value;
                                ruleObj.setDstAddr(value);
                                break;
                            }
                            case DSTPORTOPERATOR: {
                                value = this.portOperatorMap.get(value.toLowerCase());
                                ruleObj.setDstPort(value);
                                break;
                            }
                            case DSTPORT: {
                                tmp = ruleObj.getDstPort();
                                value = "dstPort" + tmp + value;
                                ruleObj.setDstPort(value);
                                break;
                            }
                            case DSTPORTFROM: {
                                ruleObj.setDstPort(value);
                                break;
                            }
                            case DSTPORTTO: {
                                tmp = ruleObj.getDstPort();
                                if (tmp == null) break;
                                value = "dstPort=" + tmp + " to " + value;
                                ruleObj.setDstPort(value);
                                break;
                            }
                            case DSTSERVICEOBJGRP: {
                                tmp = ruleObj.getService();
                                if (tmp != null) {
                                    value = tmp + " and Destination:" + value;
                                    ruleObj.setService(value);
                                    break;
                                }
                                ruleObj.setService(value);
                                break;
                            }
                            case LOGGING: {
                                ruleObj.setLog(value);
                                break;
                            }
                            case LOGSTATUS: {
                                if (value.equalsIgnoreCase("default")) {
                                    ruleObj.setLog("log");
                                    ruleObj.setLogInterval("300");
                                    ruleObj.setLogLevel("notifications");
                                    break;
                                }
                                if (!value.equalsIgnoreCase("disable")) break;
                                ruleObj.setLog(null);
                                break;
                            }
                            case LOGLEVEL: {
                                ruleObj.setLogLevel(value);
                                break;
                            }
                            case LOGINTERVAL: {
                                ruleObj.setLogInterval(value);
                                break;
                            }
                            case SCHEDULE: {
                                ruleObj.setSchedule(value);
                                break;
                            }
                            case INACTIVE: {
                                ruleObj.setStatus(value);
                                break;
                            }
                        }
                        continue;
                    }
                    if (aclType.equals("webtype")) {
                        switch (key) {
                            case WEBTYPEPROTO: {
                                ruleObj.setProtocol("tcp");
                                break;
                            }
                            case ANYURL: {
                                ruleObj.setURL(value);
                                break;
                            }
                            case URL: {
                                ruleObj.setURL(value);
                                break;
                            }
                            case ANYDESTSERVER: {
                                ruleObj.setDstAddr(value);
                                break;
                            }
                            case DESTSERVERIP: {
                                ruleObj.setDstAddr(value);
                                break;
                            }
                            case DESTSERVERNETWORK: {
                                ruleObj.setDstAddr(value);
                                break;
                            }
                            case DESTSERVERNAME: {
                                ruleObj.setDstAddr(value);
                                break;
                            }
                            case DESTSERVERNETWORKMASK: {
                                subnet = ruleObj.getDstAddr();
                                if (subnet == null) break;
                                network = IPRange.getNetwork((String)value, (String)subnet);
                                minMaxIPLong = IPRange.getMinMaxLong((String)network, (String)value);
                                if (minMaxIPLong != null) {
                                    ipRangeIDDBVal = minMaxIPLong[0] + "-" + minMaxIPLong[1];
                                    ruleObj.setDstIPIDRange(ipRangeIDDBVal);
                                }
                                value = subnet + "/" + value;
                                ruleObj.setDstAddr(value);
                                break;
                            }
                            case OPERATOR: {
                                value = this.portOperatorMap.get(value.toLowerCase());
                                ruleObj.setDstPort(value);
                                break;
                            }
                            case PORT: {
                                String op = ruleObj.getDstPort();
                                if (op == null || value == null) break;
                                value = "dstPort" + op + value;
                                ruleObj.setDstPort(value);
                                break;
                            }
                            case FROMPORT: {
                                ruleObj.setDstPort(value);
                                break;
                            }
                            case TOPORT: {
                                String tmp = ruleObj.getDstPort();
                                if (tmp == null || value == null) break;
                                value = "dstPort=" + tmp + " to " + value;
                                ruleObj.setDstPort(value);
                                break;
                            }
                            case LOGGING: {
                                ruleObj.setLog(value);
                                break;
                            }
                            case LOGSTATUS: {
                                if (value.equalsIgnoreCase("default")) {
                                    ruleObj.setLogInterval("300");
                                    ruleObj.setLogLevel("notifications");
                                    break;
                                }
                                if (!value.equalsIgnoreCase("disable")) break;
                                ruleObj.setLog(null);
                                break;
                            }
                            case LOGLEVEL: {
                                ruleObj.setLogLevel(value);
                                break;
                            }
                            case LOGINTERVAL: {
                                ruleObj.setLogInterval(value);
                                break;
                            }
                            case SCHEDULE: {
                                ruleObj.setSchedule(value);
                                break;
                            }
                            case INACTIVE: {
                                ruleObj.setStatus(value);
                                break;
                            }
                        }
                        continue;
                    }
                    if (!aclType.equals("standard")) continue;
                    switch (key) {
                        case ANYDESTSERVER: {
                            ruleObj.setDstAddr(value);
                            break;
                        }
                        case DESTSERVERIP: {
                            ruleObj.setDstAddr(value);
                            break;
                        }
                        case DESTSERVERNETWORK: {
                            ruleObj.setDstAddr(value);
                            break;
                        }
                        case DESTSERVERNAME: {
                            ruleObj.setDstAddr(value);
                            break;
                        }
                        case DESTSERVERNETWORKMASK: {
                            subnet = ruleObj.getDstAddr();
                            if (subnet == null) break;
                            network = IPRange.getNetwork((String)value, (String)subnet);
                            minMaxIPLong = IPRange.getMinMaxLong((String)network, (String)value);
                            if (minMaxIPLong != null) {
                                ipRangeIDDBVal = minMaxIPLong[0] + "-" + minMaxIPLong[1];
                                ruleObj.setDstIPIDRange(ipRangeIDDBVal);
                            }
                            value = subnet + "/" + value;
                            ruleObj.setDstAddr(value);
                            break;
                        }
                    }
                }
                if (isRuleCommentConfigLine) break;
                Vector<RuleObject> ruleObjList = (Vector<RuleObject>)this.policyObjMap.remove(this.currentPolicyName);
                if (ruleObjList == null) {
                    ruleObjList = new Vector<RuleObject>();
                }
                ruleObj.setRuleComment(this.currentACEComment);
                ruleObjList.add(ruleObj);
                this.currentACEComment = null;
                this.policyObjMap.put(this.currentPolicyName, ruleObjList);
                if (this.aclInterfaceConfigMap.containsKey(this.currentPolicyName)) break;
                this.nonAppliedPolicySet.add(this.currentPolicyName);
                break;
            }
            if (parserRuleType.equals("netObjName")) {
                NetworkObject netObj = null;
                objName = resultMap.get((Object)FWAEnumConstants.ParserKeys.NETOBJNAME);
                if (objName != null) {
                    netObj = this.netObjMap.get(objName);
                    if (netObj == null) {
                        netObj = new NetworkObject(objName);
                        this.netObjMap.put(objName, netObj);
                        this.netObjList.add(objName);
                    }
                    this.currentNetworkObject = netObj;
                    break;
                }
                return false;
            }
            if (parserRuleType.equals("netObjElements")) {
                String subnet = null;
                NetworkObject netObj = this.currentNetworkObject;
                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                    String value = resultMap.get((Object)key);
                    switch (key) {
                        case STARTIP: {
                            netObj.setStartIP(value);
                            break;
                        }
                        case ENDIP: {
                            netObj.setEndIP(value);
                            String minIP = netObj.getStartIP();
                            if (minIP == null || netObj.getIPRange() != null) break;
                            netObj.setIPRange(minIP + "-" + value);
                            netObj.setIPRangeID(this.policyProcessorUtilityObject.getIPIDRange(minIP, value));
                            break;
                        }
                        case SUBNET: {
                            if (!this.policyProcessorUtilityObject.checkForValidIP(value)) {
                                this.usedObjects.add(value);
                                value = this.nameObjMap.get(value);
                            }
                            subnet = value;
                            break;
                        }
                        case SUBNETMASK: {
                            netObj.setSubnet(subnet);
                            netObj.setSubnetMask(value);
                            this.policyProcessorUtilityObject.setIPAndIPIDInNetObj(value, subnet, netObj);
                            break;
                        }
                        case SINGLEIP: {
                            String completeNetwork = InetAddress.getByAddress(completeSubnetAddr).getHostAddress();
                            netObj.setSubnet(value);
                            netObj.setSubnetMask(completeNetwork);
                            this.policyProcessorUtilityObject.setIPAndIPIDInNetObj(completeNetwork, value, netObj);
                            break;
                        }
                        case COMMENT: {
                            netObj.setComment(value);
                            break;
                        }
                    }
                }
                break;
            }
            if (parserRuleType.equals("serviceObjName")) {
                ServiceObject serviceObj = null;
                objName = resultMap.get((Object)FWAEnumConstants.ParserKeys.SERVICEOBJNAME);
                if (objName != null) {
                    serviceObj = this.serviceObjMap.get(objName);
                    if (serviceObj == null) {
                        serviceObj = new ServiceObject(objName);
                        this.serviceObjMap.put(objName, serviceObj);
                        this.serviceObjList.add(objName);
                    }
                    this.currentServiceObject = serviceObj;
                    break;
                }
                return false;
            }
            if (parserRuleType.equals("serviceObjElements")) {
                ServiceObject serviceObj = this.currentServiceObject;
                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                    String value = resultMap.get((Object)key);
                    switch (key) {
                        case PROTOCOL: {
                            serviceObj.setProtocol(value);
                            break;
                        }
                        case SRCOPERATOR: {
                            serviceObj.setSRCPortOperator(value);
                            break;
                        }
                        case SRCPORTVALUE: {
                            serviceObj.setSRCPort(value);
                            break;
                        }
                        case SRCRANGESTR: {
                            serviceObj.setSRCPortRangeStr(value);
                            break;
                        }
                        case SRCRANGESTART: {
                            serviceObj.setSrcStartPort(value);
                            break;
                        }
                        case SRCRANGEEND: {
                            serviceObj.setSrcEndPort(value);
                            break;
                        }
                        case DSTOPERATOR: {
                            serviceObj.setDSTPortOperator(value);
                            break;
                        }
                        case DSTPORTVALUE: {
                            serviceObj.setDSTPort(value);
                            break;
                        }
                        case DSTRANGESTR: {
                            serviceObj.setDSTPortRangeStr(value);
                            break;
                        }
                        case DSTRANGESTART: {
                            serviceObj.setDstStartPort(value);
                            break;
                        }
                        case DSTRANGEEND: {
                            serviceObj.setDstEndPort(value);
                            break;
                        }
                        case COMMENT: {
                            serviceObj.setComment(value);
                            break;
                        }
                        case PROTOCOLSERVICE: {
                            serviceObj.setService(value);
                            break;
                        }
                        case ICMPTYPE: {
                            serviceObj.setICMPType(value);
                        }
                        case ICMPCODE: {
                            String icmpType = serviceObj.getICMPType();
                            icmpType = icmpType != null ? icmpType + " " + value : null;
                            serviceObj.setICMPType(icmpType);
                            break;
                        }
                    }
                }
                break;
            }
            if (parserRuleType.equals("netObjGroupName")) {
                FirewallGroupObject groupObj = null;
                objName = resultMap.get((Object)FWAEnumConstants.ParserKeys.NETOBJGROUPNAME);
                if (objName != null) {
                    groupObj = this.netObjGroupMap.get(objName);
                    if (groupObj == null) {
                        groupObj = new FirewallGroupObject(objName);
                        this.netObjGroupMap.put(objName, groupObj);
                        this.netObjList.add(objName);
                    }
                    this.currentGroupObject = groupObj;
                    break;
                }
                return false;
            }
            if (parserRuleType.equals("netObjGroupElements")) {
                FirewallGroupObject groupObj = this.currentGroupObject;
                String subnet = "";
                String members = null;
                String tempObjectName = null;
                NetworkObject netObj = null;
                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                    String value = resultMap.get((Object)key);
                    switch (key) {
                        case SINGLEIP: {
                            if (!this.policyProcessorUtilityObject.checkForValidIP(value)) {
                                this.usedObjects.add(value);
                                value = this.nameObjMap.get(value);
                            }
                            if ((netObj = this.netObjMap.get("fwaCreatedCustomObject")) == null) {
                                netObj = new NetworkObject("fwaCreatedCustomObject");
                                this.netObjMap.put("fwaCreatedCustomObject", netObj);
                            }
                            tempObjectName = value + "/255.255.255.255";
                            String completeNetwork = InetAddress.getByAddress(completeSubnetAddr).getHostAddress();
                            netObj.setSubnet(value);
                            netObj.setSubnetMask(completeNetwork);
                            this.policyProcessorUtilityObject.setIPAndIPIDInNetObj(completeNetwork, value, netObj);
                            break;
                        }
                        case SUBNET: {
                            if (!this.policyProcessorUtilityObject.checkForValidIP(value)) {
                                this.usedObjects.add(value);
                                value = this.nameObjMap.get(value);
                            }
                            subnet = value;
                            break;
                        }
                        case SUBNETMASK: {
                            netObj = this.netObjMap.get("fwaCreatedCustomObject");
                            if (netObj == null) {
                                netObj = new NetworkObject("fwaCreatedCustomObject");
                                this.netObjMap.put("fwaCreatedCustomObject", netObj);
                            }
                            tempObjectName = subnet + "/" + value;
                            netObj.setSubnet(subnet);
                            netObj.setSubnetMask(value);
                            this.policyProcessorUtilityObject.setIPAndIPIDInNetObj(value, subnet, netObj);
                            break;
                        }
                        case COMMENT: {
                            groupObj.setComment(value);
                        }
                        case MEMBERS: {
                            members = groupObj.getMembers();
                            members = members != null ? members + "," + value : value;
                        }
                    }
                }
                if (tempObjectName != null) {
                    tempObjectName = "fwaCreatedCustomObject_" + tempObjectName;
                    netObj = (NetworkObject)this.netObjMap.remove("fwaCreatedCustomObject");
                    netObj.setFWACreatedStatus(true);
                    this.netObjMap.put(tempObjectName, netObj);
                    members = groupObj.getMembers();
                    members = members != null ? members + "," + tempObjectName : tempObjectName;
                    tempObjectName = null;
                }
                groupObj.setMembers(members);
                groupObj.setType("Network");
                break;
            }
            if (parserRuleType.equals("protocolObjGroupName")) {
                FirewallGroupObject groupObj = null;
                objName = resultMap.get((Object)FWAEnumConstants.ParserKeys.PROTOOBJGROUPNAME);
                if (objName != null) {
                    groupObj = this.protoObjGroupMap.get(objName);
                    if (groupObj == null) {
                        groupObj = new FirewallGroupObject(objName);
                        this.protoObjGroupMap.put(objName, groupObj);
                    }
                    this.currentGroupObject = groupObj;
                    break;
                }
                return false;
            }
            if (parserRuleType.equals("protocolObjGroupElements")) {
                String members = null;
                FirewallGroupObject groupObj = this.currentGroupObject;
                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                    String value = resultMap.get((Object)key);
                    switch (key) {
                        case PROTO: {
                            value = this.policyProcessorUtilityObject.isDigit(value) ? this.policyProcessorUtilityObject.getIPProtocol(value) : value;
                            value = value.toUpperCase();
                            members = groupObj.getMembers();
                            members = members != null ? members + "," + value : value;
                            break;
                        }
                        case MEMBERS: {
                            members = groupObj.getMembers();
                            members = members != null ? members + "," + value : value;
                            break;
                        }
                        case PROTOCOLOBJECTGROUPCOMMENT: {
                            groupObj.setComment(value);
                            break;
                        }
                    }
                }
                groupObj.setMembers(members);
                groupObj.setType("Protocol");
                break;
            }
            if (parserRuleType.equals("serviceObjGroupName")) {
                FirewallGroupObject groupObj = null;
                objName = resultMap.get((Object)FWAEnumConstants.ParserKeys.SERVICEOBJGROUPNAME);
                this.currentServiceProtocol = resultMap.get((Object)FWAEnumConstants.ParserKeys.SERVICEOBJPROTOCOL);
                if (objName != null) {
                    groupObj = this.serviceObjGroupMap.get(objName);
                    if (groupObj == null) {
                        groupObj = new FirewallGroupObject(objName);
                        this.serviceObjGroupMap.put(objName, groupObj);
                        this.serviceObjList.add(objName);
                    }
                    this.currentGroupObject = groupObj;
                    break;
                }
                return false;
            }
            if (parserRuleType.equals("serviceObjGroupElements")) {
                String members = null;
                String tempObjectName = null;
                String protocol = null;
                String startPort = null;
                String endPort = null;
                FirewallGroupObject groupObj = this.currentGroupObject;
                Iterator<FWAEnumConstants.ParserKeys> itr = resultMap.keySet().iterator();
                ServiceObject serviceObj = null;
                while (itr.hasNext()) {
                    String serviceObjectName;
                    FWAEnumConstants.ParserKeys key = itr.next();
                    String value = resultMap.get((Object)key);
                    if (this.currentServiceProtocol != null && (key == FWAEnumConstants.ParserKeys.SERVICEPORT || key == FWAEnumConstants.ParserKeys.PORTRANGE)) {
                        value = key == FWAEnumConstants.ParserKeys.PORTRANGE ? value.replaceAll(" ", " to ") : value;
                        serviceObjectName = "fwaCreatedCustomObject";
                        serviceObj = this.serviceObjMap.get(serviceObjectName);
                        if (serviceObj == null) {
                            serviceObj = new ServiceObject(serviceObjectName);
                            this.serviceObjMap.put(serviceObjectName, serviceObj);
                        }
                        tempObjectName = value;
                        serviceObj.setProtocol(this.currentServiceProtocol);
                        if (value == null) continue;
                        if (key == FWAEnumConstants.ParserKeys.SERVICEPORT) {
                            serviceObj.setDSTPortOperator("eq");
                            serviceObj.setDSTPort(value);
                            continue;
                        }
                        serviceObj.setDSTPortRangeStr("range");
                        String[] portRangeArr = value.split(" to ");
                        serviceObj.setDstStartPort(portRangeArr[0]);
                        serviceObj.setDstEndPort(portRangeArr[1]);
                        continue;
                    }
                    if (key == FWAEnumConstants.ParserKeys.PROTOCOL) {
                        serviceObjectName = "fwaCreatedCustomObject";
                        serviceObj = this.serviceObjMap.get(serviceObjectName);
                        if (serviceObj == null) {
                            serviceObj = new ServiceObject(serviceObjectName);
                            this.serviceObjMap.put(serviceObjectName, serviceObj);
                        }
                        tempObjectName = value = value.toUpperCase();
                        protocol = value;
                        serviceObj.setProtocol(value);
                        continue;
                    }
                    if (key == FWAEnumConstants.ParserKeys.COMMENT) {
                        groupObj.setComment(value);
                        continue;
                    }
                    if (key == FWAEnumConstants.ParserKeys.MEMBERS) {
                        members = groupObj.getMembers();
                        members = members != null ? members + "," + value : value;
                        continue;
                    }
                    if (serviceObj == null) continue;
                    switch (key) {
                        case SRCOPERATOR: {
                            value = this.portOperatorMap.get(value.toLowerCase());
                            serviceObj.setSRCPortOperator(value);
                            tempObjectName = tempObjectName + " srcPort" + value;
                            break;
                        }
                        case SRCPORTVALUE: {
                            serviceObj.setSRCPort(value);
                            tempObjectName = tempObjectName + value;
                            break;
                        }
                        case SRCRANGESTR: {
                            serviceObj.setSRCPortRangeStr(value);
                            tempObjectName = tempObjectName + " srcPort=";
                            break;
                        }
                        case SRCRANGESTART: {
                            startPort = value;
                            serviceObj.setSrcStartPort(value);
                            break;
                        }
                        case SRCRANGEEND: {
                            endPort = value;
                            tempObjectName = tempObjectName + startPort + " to " + endPort;
                            serviceObj.setSrcEndPort(value);
                            break;
                        }
                        case DSTOPERATOR: {
                            value = this.portOperatorMap.get(value.toLowerCase());
                            serviceObj.setDSTPortOperator(value);
                            tempObjectName = tempObjectName != null && tempObjectName.indexOf("srcPort") > -1 ? tempObjectName + " and dstPort" + value : tempObjectName + " dstPort" + value;
                            break;
                        }
                        case DSTPORTVALUE: {
                            tempObjectName = tempObjectName + value;
                            serviceObj.setDSTPort(value);
                            break;
                        }
                        case DSTRANGESTR: {
                            serviceObj.setDSTPortRangeStr(value);
                            tempObjectName = tempObjectName != null && tempObjectName.indexOf("srcPort") > -1 ? tempObjectName + " and dstPort=" : tempObjectName + " dstPort=";
                            break;
                        }
                        case DSTRANGESTART: {
                            startPort = value;
                            serviceObj.setDstStartPort(value);
                            break;
                        }
                        case DSTRANGEEND: {
                            endPort = value;
                            tempObjectName = tempObjectName + startPort + " to " + endPort;
                            serviceObj.setDstEndPort(value);
                            break;
                        }
                        case PROTOCOLSERVICE: {
                            tempObjectName = protocol + " " + value;
                            serviceObj.setService(value);
                            break;
                        }
                        case ICMPTYPE: {
                            tempObjectName = protocol + " " + value;
                            serviceObj.setICMPType(value);
                            break;
                        }
                        case ICMPCODE: {
                            tempObjectName = tempObjectName + " " + value;
                            String icmpType = serviceObj.getICMPType();
                            value = icmpType != null ? icmpType + " " + value : null;
                            serviceObj.setICMPType(value);
                            break;
                        }
                    }
                }
                if (tempObjectName != null) {
                    tempObjectName = this.currentServiceProtocol != null ? "fwaCreatedCustomObject_" + tempObjectName + "_" + this.currentServiceProtocol : "fwaCreatedCustomObject_" + tempObjectName;
                    serviceObj = (ServiceObject)this.serviceObjMap.remove("fwaCreatedCustomObject");
                    serviceObj.setFWACreatedStatus(true);
                    this.serviceObjMap.put(tempObjectName, serviceObj);
                    members = groupObj.getMembers();
                    members = members != null ? members + "," + tempObjectName : tempObjectName;
                    tempObjectName = null;
                }
                groupObj.setMembers(members);
                groupObj.setType("Service");
                break;
            }
            if (parserRuleType.equals("icmpObjGroupName")) {
                FirewallGroupObject groupObj = null;
                objName = resultMap.get((Object)FWAEnumConstants.ParserKeys.ICMPOBJGROUPNAME);
                if (objName != null) {
                    groupObj = this.icmpObjGroupMap.get(objName);
                    if (groupObj == null) {
                        groupObj = new FirewallGroupObject(objName);
                        this.icmpObjGroupMap.put(objName, groupObj);
                    }
                    this.currentGroupObject = groupObj;
                    break;
                }
                return false;
            }
            if (parserRuleType.equals("icmpObjGroupElements")) {
                String members = null;
                String tempObjectName = null;
                FirewallGroupObject groupObj = this.currentGroupObject;
                ServiceObject serviceObj = null;
                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                    String value = resultMap.get((Object)key);
                    switch (key) {
                        case ICMPTYPE: {
                            serviceObj = this.icmpObjMap.get("fwaCreatedCustomObject");
                            if (serviceObj == null) {
                                serviceObj = new ServiceObject("fwaCreatedCustomObject");
                                this.icmpObjMap.put("fwaCreatedCustomObject", serviceObj);
                            }
                            tempObjectName = "ICMP " + value;
                            serviceObj.setProtocol("ICMP");
                            serviceObj.setICMPType(value);
                            break;
                        }
                        case MEMBERS: {
                            members = groupObj.getMembers();
                            members = members != null ? members + "," + value : value;
                            break;
                        }
                        case ICMPOBJECTGROUPCOMMENT: {
                            groupObj.setComment(value);
                            break;
                        }
                    }
                }
                if (tempObjectName != null) {
                    tempObjectName = "fwaCreatedCustomObject_" + tempObjectName;
                    serviceObj = (ServiceObject)this.icmpObjMap.remove("fwaCreatedCustomObject");
                    serviceObj.setFWACreatedStatus(true);
                    this.icmpObjMap.put(tempObjectName, serviceObj);
                    members = groupObj.getMembers();
                    members = members != null ? members + "," + tempObjectName : tempObjectName;
                    tempObjectName = null;
                }
                groupObj.setMembers(members);
                groupObj.setType("ICMP");
                break;
            }
            if (parserRuleType.equals("asaInterfaceName")) {
                InterfaceDetails interfaceDetailsObj = null;
                objName = resultMap.get((Object)FWAEnumConstants.ParserKeys.INTERFACEPHYSICALNAME);
                if (objName != null) {
                    interfaceDetailsObj = this.interfaceDetailsObjMap.get(objName);
                    if (interfaceDetailsObj == null) {
                        interfaceDetailsObj = new InterfaceDetails(objName);
                        this.interfaceDetailsObjMap.put(objName, interfaceDetailsObj);
                    }
                    this.currentInterfaceDetailsObject = interfaceDetailsObj;
                    break;
                }
                return false;
            }
            if (parserRuleType.equals("asaInterfaceElements")) {
                InterfaceDetails interfaceDetailsObj = this.currentInterfaceDetailsObject;
                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                    String value = resultMap.get((Object)key);
                    switch (key) {
                        case SHUTDOWN: {
                            interfaceDetailsObj.setStatus(value);
                            break;
                        }
                        case INTERFACENAME: {
                            String ifName = interfaceDetailsObj.getInterfaceName();
                            this.interfaceAliasVsOriginalNamesMap.put(value, ifName);
                            ifName = ifName + " (" + value + ")";
                            interfaceDetailsObj.setInterfaceName(ifName);
                            interfaceDetailsObj.setAliasName(value);
                            break;
                        }
                        case SECURITYLEVEL: {
                            interfaceDetailsObj.setSecurityLevel(value);
                            break;
                        }
                        case IPADD: {
                            interfaceDetailsObj.setIP(value);
                            break;
                        }
                        case SPEED: {
                            interfaceDetailsObj.setSpeed(value);
                            break;
                        }
                        case DUPLEX: {
                            interfaceDetailsObj.setDuplex(value);
                            break;
                        }
                        case INTERFACEDESC: {
                            interfaceDetailsObj.setInterfaceDesc(value);
                            break;
                        }
                        case VLAN: {
                            interfaceDetailsObj.setVdomName(value);
                            break;
                        }
                    }
                }
                break;
            }
            if (parserRuleType.equals("pixInterfaceDetails")) {
                InterfaceDetails interfaceDetailsObj = null;
                objName = resultMap.get((Object)FWAEnumConstants.ParserKeys.INTERFACEPHYSICALNAME);
                if (objName != null) {
                    interfaceDetailsObj = this.interfaceDetailsObjMap.get(objName);
                    if (interfaceDetailsObj == null) {
                        interfaceDetailsObj = new InterfaceDetails(objName);
                        this.interfaceDetailsObjMap.put(objName, interfaceDetailsObj);
                    }
                } else {
                    return false;
                }
                this.currentInterfaceDetailsObject = interfaceDetailsObj;
                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                    String value = resultMap.get((Object)key);
                    switch (key) {
                        case INTERFACENAME: {
                            String ifName = interfaceDetailsObj.getInterfaceName();
                            this.interfaceAliasVsOriginalNamesMap.put(value, ifName);
                            ifName = ifName + " (" + value + ")";
                            interfaceDetailsObj.setInterfaceName(ifName);
                            interfaceDetailsObj.setAliasName(value);
                            break;
                        }
                        case SECURITYLEVEL: {
                            interfaceDetailsObj.setSecurityLevel(value);
                            break;
                        }
                        case SHUTDOWN: {
                            interfaceDetailsObj.setStatus(value);
                            break;
                        }
                    }
                }
                break;
            }
            if (parserRuleType.equals("pixInterfaceIPDetails")) {
                String aliasName = resultMap.get((Object)FWAEnumConstants.ParserKeys.INTERFACENAME);
                String origName = this.interfaceAliasVsOriginalNamesMap.get(aliasName);
                InterfaceDetails interfaceDetailsObj = null;
                if (origName == null) {
                    return false;
                }
                interfaceDetailsObj = this.interfaceDetailsObjMap.get(origName);
                String net = null;
                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                    String value = resultMap.get((Object)key);
                    if (key == FWAEnumConstants.ParserKeys.IPADDRESS) {
                        net = value;
                        interfaceDetailsObj.setIP(value);
                        continue;
                    }
                    if (key != FWAEnumConstants.ParserKeys.IPNETWORKMASK || net == null) continue;
                    value = net + "/" + value;
                    interfaceDetailsObj.setIP(value);
                }
                break;
            }
            if (parserRuleType.equals("aclInterfaceConfigDetails")) {
                String tempPolicyName = "";
                String tmpValue = "";
                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                    String value = resultMap.get((Object)key);
                    if (key == FWAEnumConstants.ParserKeys.POLICYNAME) {
                        tempPolicyName = value;
                        continue;
                    }
                    if (key == FWAEnumConstants.ParserKeys.DIRECTION) {
                        tmpValue = "1:" + value;
                        continue;
                    }
                    if (key != FWAEnumConstants.ParserKeys.INTERFACE) continue;
                    this.usedInterfaces.add(value);
                    value = "2:" + value;
                    tmpValue = tmpValue != null ? tmpValue + "," + value : value;
                    this.aclInterfaceConfigMap.put(tempPolicyName, tmpValue);
                }
                break;
            }
            if (parserRuleType.equals("nameObjectElements")) {
                NetworkObject netObj = null;
                String ip = null;
                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                    String value = resultMap.get((Object)key);
                    if (key == FWAEnumConstants.ParserKeys.SINGLEIP) {
                        ip = value;
                        continue;
                    }
                    if (key == FWAEnumConstants.ParserKeys.NETOBJNAME) {
                        this.nameObjMap.put(value, ip);
                        netObj = this.netObjMap.get(value);
                        if (netObj == null) {
                            netObj = new NetworkObject(value);
                            this.netObjMap.put(value, netObj);
                            this.netObjList.add(value);
                        }
                        this.currentNetworkObject = netObj;
                        String completeNetwork = InetAddress.getByAddress(completeSubnetAddr).getHostAddress();
                        netObj.setSubnet(ip);
                        netObj.setSubnetMask(completeNetwork);
                        String network = IPRange.getNetwork((String)completeNetwork, (String)ip);
                        long[] minMaxIPLong = IPRange.getMinMaxLong((String)network, (String)completeNetwork);
                        if (minMaxIPLong == null) continue;
                        String ipRangeIDDBVal = "" + minMaxIPLong[0] + "-" + "" + minMaxIPLong[1];
                        netObj.setIPRangeID(ipRangeIDDBVal);
                        String ipRangeDBVal = IPRange.convertAddr((long)minMaxIPLong[0]) + "-" + IPRange.convertAddr((long)minMaxIPLong[1]);
                        netObj.setIPRange(ipRangeDBVal);
                        continue;
                    }
                    if (key != FWAEnumConstants.ParserKeys.COMMENT) continue;
                    netObj.setComment(value);
                }
                break;
            }
            if (parserRuleType.equals("staticNATConfigDetails")) {
                String fromInterface = null;
                String toInterface = null;
                String translatedIP = null;
                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                    String value = resultMap.get((Object)key);
                    switch (key) {
                        case FROMINTERFACE: {
                            fromInterface = value;
                            break;
                        }
                        case TOINTERFACE: {
                            toInterface = value;
                            break;
                        }
                        case TRANSLATEDIP: {
                            translatedIP = value;
                            break;
                        }
                        case ORIGINALIPNETMASK: {
                            long translatedIPNumber = IPRange.getIPNumber((String)translatedIP);
                            String tranIP = translatedIPNumber + "-" + translatedIPNumber;
                            ArrayList<Object> natDetailsList = this.staticNATConfig.get(tranIP);
                            if (natDetailsList == null) {
                                natDetailsList = new ArrayList();
                                this.staticNATConfig.put(tranIP, natDetailsList);
                            }
                            String[] natDetails = new String[]{fromInterface, toInterface};
                            natDetailsList.add(natDetails);
                            break;
                        }
                    }
                }
                break;
            }
            if (parserRuleType.equals("dynamicNATConfigDetails")) {
                String toInterface = null;
                String fromInterface = null;
                String dynamicNatRuleID = null;
                String translatedIP = null;
                boolean isDynamicNATLocal = false;
                ArrayList<Object> globalNATDetailsList = null;
                String[] globalNATDetails = null;
                Set<FWAEnumConstants.ParserKeys> st = resultMap.keySet();
                for (FWAEnumConstants.ParserKeys key : st) {
                    String value = resultMap.get((Object)key);
                    switch (key) {
                        case DYNAMICNATGLOBAL: {
                            isDynamicNATLocal = false;
                            break;
                        }
                        case DYNAMICNATLOCAL: {
                            isDynamicNATLocal = true;
                            break;
                        }
                        case TOINTERFACE: {
                            toInterface = value;
                            break;
                        }
                        case FROMINTERFACE: {
                            fromInterface = value;
                            break;
                        }
                        case NATRULEID: {
                            Integer secLevel;
                            Set<String> setOfInterfaces;
                            dynamicNatRuleID = value;
                            if (!isDynamicNATLocal) break;
                            boolean outsideNAT = st.contains("outsideNAT");
                            TreeMap<Integer, Set<String>> localNATConfigInterfaceDetailsMap = null;
                            if (outsideNAT) {
                                localNATConfigInterfaceDetailsMap = this.dynamicOutsideNATLocalConfig.get(dynamicNatRuleID);
                                if (localNATConfigInterfaceDetailsMap == null) {
                                    localNATConfigInterfaceDetailsMap = new TreeMap();
                                    this.dynamicOutsideNATLocalConfig.put(dynamicNatRuleID, localNATConfigInterfaceDetailsMap);
                                }
                            } else {
                                localNATConfigInterfaceDetailsMap = this.dynamicLocalNATConfig.get(dynamicNatRuleID);
                                if (localNATConfigInterfaceDetailsMap == null) {
                                    localNATConfigInterfaceDetailsMap = new TreeMap();
                                    this.dynamicLocalNATConfig.put(dynamicNatRuleID, localNATConfigInterfaceDetailsMap);
                                }
                            }
                            if ((setOfInterfaces = localNATConfigInterfaceDetailsMap.get(secLevel = this.interfaceVsSecurityLevel.get(fromInterface))) == null) {
                                setOfInterfaces = new HashSet<String>();
                                localNATConfigInterfaceDetailsMap.put(secLevel, setOfInterfaces);
                            }
                            setOfInterfaces.add(fromInterface);
                            break;
                        }
                        case TRANSLATEDIP: {
                            translatedIP = value;
                            if (st.contains("TranslatedIPNetMask")) break;
                            long tranIPLong = IPRange.getAddrLong((String)translatedIP);
                            globalNATDetailsList = this.dynamicGlobalNATConfig.get(dynamicNatRuleID);
                            if (globalNATDetailsList == null) {
                                globalNATDetailsList = new ArrayList();
                            }
                            globalNATDetails = new String[]{toInterface, tranIPLong + "-" + tranIPLong};
                            globalNATDetailsList.add(globalNATDetails);
                            this.dynamicGlobalNATConfig.put(dynamicNatRuleID, globalNATDetailsList);
                            break;
                        }
                        case TRANSLATEDIPNETMASK: {
                            String tranIPNetwork = IPRange.getNetwork((String)value, (String)translatedIP);
                            long[] array = IPRange.getMinMaxLong((String)tranIPNetwork, (String)value);
                            globalNATDetailsList = this.dynamicGlobalNATConfig.get(dynamicNatRuleID);
                            if (globalNATDetailsList == null) {
                                globalNATDetailsList = new ArrayList();
                            }
                            globalNATDetails = new String[]{toInterface, array[0] + "-" + array[1]};
                            globalNATDetailsList.add(globalNATDetails);
                            this.dynamicGlobalNATConfig.put(dynamicNatRuleID, globalNATDetailsList);
                            break;
                        }
                        case TRANSLATEDIPPOOL: {
                            String[] trannIPPool = value.split("-");
                            long tranIPPoolMin = IPRange.getAddrLong((String)trannIPPool[0]);
                            long tranIPPoolMax = IPRange.getAddrLong((String)trannIPPool[1]);
                            globalNATDetailsList = this.dynamicGlobalNATConfig.get(dynamicNatRuleID);
                            if (globalNATDetailsList == null) {
                                globalNATDetailsList = new ArrayList();
                            }
                            globalNATDetails = new String[]{toInterface, tranIPPoolMin + "-" + tranIPPoolMax};
                            globalNATDetailsList.add(globalNATDetails);
                            this.dynamicGlobalNATConfig.put(dynamicNatRuleID, globalNATDetailsList);
                            break;
                        }
                    }
                }
                break;
            }
            if (parserRuleType.equals("natObjName")) {
                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                    String value = resultMap.get((Object)key);
                    if (key != FWAEnumConstants.ParserKeys.NATTEDNETWORKOBJ) continue;
                    this.usedObjects.add(value);
                    this.currentNATObjName = value;
                }
                break;
            }
            if (parserRuleType.equals("asaSourceNATConfigDetails")) {
                String natSRCInterface = null;
                String natDSTInterface = null;
                Set<FWAEnumConstants.ParserKeys> st = resultMap.keySet();
                for (FWAEnumConstants.ParserKeys key : st) {
                    String value = resultMap.get((Object)key);
                    if (key == FWAEnumConstants.ParserKeys.NATSRCINTERFACE) {
                        natSRCInterface = value;
                        continue;
                    }
                    if (key == FWAEnumConstants.ParserKeys.NATDSTINTERFACE) {
                        natDSTInterface = value;
                        continue;
                    }
                    if (key != FWAEnumConstants.ParserKeys.NATTEDNETWORKINFO || this.policyProcessorUtilityObject.checkForValidIP(value)) continue;
                    this.usedObjects.add(value);
                }
                if (this.currentNATObjName != null && this.wanInterfaceList != null && this.wanInterfaceList.contains(natDSTInterface)) {
                    this.updateNATIPPoolWithNetworkObjDetails(this.currentNATObjName);
                }
                this.currentNATObjName = null;
                break;
            }
            if (parserRuleType.equals("asaMultiNATConfigDetails")) {
                String natObjName = null;
                String natSRCInterface = null;
                String natDSTInterface = null;
                Set<FWAEnumConstants.ParserKeys> st = resultMap.keySet();
                for (FWAEnumConstants.ParserKeys key : st) {
                    String value = resultMap.get((Object)key);
                    if (key == FWAEnumConstants.ParserKeys.NATTEDNETWORKOBJ) {
                        this.usedObjects.add(value);
                        natObjName = value;
                        continue;
                    }
                    if (key == FWAEnumConstants.ParserKeys.NATSRCINTERFACE) {
                        natSRCInterface = value;
                        continue;
                    }
                    if (key == FWAEnumConstants.ParserKeys.NATDSTINTERFACE) {
                        natDSTInterface = value;
                        continue;
                    }
                    if (key == FWAEnumConstants.ParserKeys.SRCORIGNETWORKOBJ && !this.policyProcessorUtilityObject.checkForValidIP(value)) {
                        this.usedObjects.add(value);
                        continue;
                    }
                    if (key == FWAEnumConstants.ParserKeys.DSTORIGNETWORKOBJ && !this.policyProcessorUtilityObject.checkForValidIP(value)) {
                        this.usedObjects.add(value);
                        continue;
                    }
                    if (key != FWAEnumConstants.ParserKeys.DSTNATTEDNETWORKOBJ || this.policyProcessorUtilityObject.checkForValidIP(value)) continue;
                    this.usedObjects.add(value);
                }
                if (this.wanInterfaceList == null || !this.wanInterfaceList.contains(natDSTInterface)) break;
                this.updateNATIPPoolWithNetworkObjDetails(natObjName);
                break;
            }
            if (parserRuleType.equals("defaultStaticRouteDetails")) {
                Iterator<FWAEnumConstants.ParserKeys> itr = resultMap.keySet().iterator();
                String interfaceName = null;
                String metric = "-1";
                while (itr.hasNext()) {
                    FWAEnumConstants.ParserKeys key = itr.next();
                    String value = resultMap.get((Object)key);
                    if (key == FWAEnumConstants.ParserKeys.INTERFACENAME) {
                        interfaceName = value;
                        continue;
                    }
                    if (key != FWAEnumConstants.ParserKeys.METRIC) continue;
                    metric = value;
                }
                this.defaultStaticRouteTable.put(interfaceName, new Long(metric));
                break;
            }
            if (!parserRuleType.equals("staticRouteDetails")) break;
            String interfaceName = null;
            String networkIP = null;
            String networkMask = null;
            for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                String value = resultMap.get((Object)key);
                if (key == FWAEnumConstants.ParserKeys.INTERFACENAME) {
                    interfaceName = value;
                    continue;
                }
                if (key == FWAEnumConstants.ParserKeys.NETWORKIP) {
                    if (!this.policyProcessorUtilityObject.checkForValidIP(value)) {
                        this.usedObjects.add(value);
                        value = this.nameObjMap.get(value);
                    }
                    networkIP = value;
                    continue;
                }
                if (key != FWAEnumConstants.ParserKeys.NETWORKMASK) continue;
                networkMask = value;
            }
            String network = IPRange.getNetwork(networkMask, networkIP);
            long[] minMaxIPLong = IPRange.getMinMaxLong((String)network, networkMask);
            String routingIPs = this.staticRouteTable.remove(interfaceName);
            routingIPs = routingIPs != null ? routingIPs + "," + minMaxIPLong[0] + "-" + minMaxIPLong[1] : minMaxIPLong[0] + "-" + minMaxIPLong[1];
            this.staticRouteTable.put(interfaceName, routingIPs);
            break;
        }
        return patternMatched;
    }

    public void updateNATIPPoolWithNetworkObjDetails(String objName) {
        String networkObjIPID = this.getNetworkObjectIPID(objName, this.rID, "Network");
        if (networkObjIPID != null) {
            if (networkObjIPID.indexOf(",") > -1) {
                String[] netObjIPID;
                for (String ipID : netObjIPID = networkObjIPID.split(",")) {
                    this.natIPPool.add(ipID);
                }
            } else {
                this.natIPPool.add(networkObjIPID);
            }
        }
    }

    private String getNetworkObjectIPID(String objName, Long rID, String objType) {
        try {
            NetworkObject netObj = this.netObjMap.get(objName);
            if (netObj != null) {
                return netObj.getIPRangeID();
            }
            Criteria detailsCrit = new Criteria(new Column("FirewallObjects", "RID"), (Object)rID, 0);
            DataObject doo = DataAccess.get((String)"FirewallObjects", (Criteria)(detailsCrit = detailsCrit.and(new Criteria(new Column("FirewallObjects", "NAME"), (Object)objName, 0))));
            if (!doo.isEmpty()) {
                return (String)doo.getFirstValue("FirewallObjects", "IPRANGE_ID");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public void processResultsAndPopulateIntoDB(Long rID, String deviceType, String resourceName) throws Exception {
        DataObject doo = DataAccess.constructDataObject();
        this.populateInterfaceDetailsIntoDB(rID, this.interfaceDetailsObjMap, deviceType, resourceName);
        this.populateNetworkObjectsDataIntoDB(doo, rID, this.netObjMap, deviceType, resourceName);
        this.populateServiceObjectsDataIntoDB(doo, rID, this.serviceObjMap, deviceType, resourceName);
        this.populateICMPObjectsDataIntoDB(doo, rID, this.icmpObjMap, deviceType, resourceName);
        DataAccess.add((DataObject)doo);
        doo = DataAccess.constructDataObject();
        this.populateObjectsGroup(doo, this.netObjGroupMap, rID, deviceType, resourceName, "Network");
        this.populateObjectsGroup(doo, this.protoObjGroupMap, rID, deviceType, resourceName, "Protocol");
        this.populateObjectsGroup(doo, this.serviceObjGroupMap, rID, deviceType, resourceName, "Service");
        this.populateObjectsGroup(doo, this.icmpObjGroupMap, rID, deviceType, resourceName, "ICMP");
        DataAccess.add((DataObject)doo);
        LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap = new LinkedHashMap<FWAEnumConstants.ParserKeys, String>();
        this.parseAndProcessStaticRouteConfig(this.configData, resultMap);
        this.groupStaticRoutingTable();
        this.parseAndProcessStaticNATConfig(this.configData, resultMap);
        this.parseAndProcessDynamicNATConfig(this.configData, resultMap);
        if (!this.dynamicLocalNATConfig.isEmpty() && !this.dynamicGlobalNATConfig.isEmpty()) {
            this.correlateGlobalAndLocalNATConfigs();
        }
        if (!this.oldASA && !this.isPIX) {
            this.parseAndProcessASAMultiNATMappings(this.configData, resultMap);
        }
        resultMap = null;
        this.populatePolicyInfoIntoDB(this.policyObjMap, rID, deviceType, resourceName);
        doo = DataAccess.constructDataObject();
        this.populateRuleInfoIntoDB(doo, this.policyObjMap, rID, deviceType, resourceName);
        LOGGER.info("unIdentifiedIPList for resource <-> " + resourceName + " is:::" + this.unIdentifiedIPList);
        LOGGER.fine("unIdentifiedIPIDList for resource <-> " + resourceName + " is:::" + this.unIdentifiedIPIDList);
        DataAccess.add((DataObject)doo);
        this.policyProcessorUtilityObject.updateObjectsWithUsageInfo(rID, deviceType, resourceName, this.usedObjects);
        this.policyProcessorUtilityObject.updateInterfaceDetailsWithUsageInfo(rID, deviceType, resourceName, this.usedInterfaces);
        LOGGER.log(Level.FINER, " ### IPs for which SRC Interfaces can not be determined ### " + this.unFoundSrcInterfaceSet);
        LOGGER.log(Level.FINER, " ### IPs for which DST Interfaces can not be determined ### " + this.unFoundDstInterfaceSet);
        LOGGER.log(Level.FINER, " ### ACLs that were not applied on any interface ### " + this.nonAppliedPolicySet);
        LOGGER.log(Level.INFO, " ### Services for which ports are not resolved ### " + this.unknownPorts);
    }

    private void populatePolicyInfoIntoDB(LinkedHashMap<String, Vector<RuleObject>> policyObjMap, Long rID, String deviceType, String resourceName) throws Exception {
        try {
            LOGGER.fine("populating Policy Details...");
            DataObject dObj = DataAccess.constructDataObject();
            Set<String> st = policyObjMap.keySet();
            Iterator<String> itr = st.iterator();
            String policyName = null;
            while (itr.hasNext()) {
                policyName = itr.next();
                Row policyDetailsRow = new Row("PolicyDetails");
                policyDetailsRow.set("POLICYNAME", (Object)policyName);
                policyDetailsRow.set("RID", (Object)rID);
                LOGGER.log(Level.FINE, " CiscoPolicyProcessor :::: PolicyDetails ROW is :::::::: {0} ", policyDetailsRow);
                dObj.addRow(policyDetailsRow);
            }
            dObj = DataAccess.add((DataObject)dObj);
            this.policyProcessorUtilityObject.updatePolicyDetailsMap(dObj, rID, resourceName, this.policyNameVsIDMap);
        }
        catch (Exception exp) {
            throw new Exception("Problem while populating Policy Details into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void populateRuleInfoIntoDB(DataObject doo, LinkedHashMap<String, Vector<RuleObject>> policyObjMap, Long rID, String deviceType, String resourceName) throws Exception {
        currentRuleObj = null;
        srcUnResolved = new HashSet<String>();
        dstUnResolved = new HashSet<String>();
        serviceUnResolved = new HashSet<String>();
        try {
            CiscoPolicyProcessor.LOGGER.fine("populating Rule Details..." + resourceName);
            this.ruleDetailsDataMap = new HashMap<K, V>();
            protoVsSRCPortSet = new HashMap<String, HashSet<String>>();
            protoVsDSTPortSet = new HashMap<String, HashSet<String>>();
            protoSetFromService = new HashSet<String>();
            isNAT = false;
            zoneBuilder = new StringBuilder();
            serviceBuilder = new StringBuilder();
            protoBuilder = new StringBuilder();
            dstPortSet = new HashSet<String>();
            srcInterface = new HashSet<String>();
            srcZone = new HashSet<String>();
            dstInterface = new HashSet<String>();
            dstZone = new HashSet<String>();
            isVPNRule = false;
            isAnySRC = false;
            isAnyDST = false;
            isAnyService = false;
            hasExplicitDenyRule = false;
            for (Map.Entry<String, Vector<RuleObject>> entry : policyObjMap.entrySet()) {
                hasExplicitDenyRule = false;
                policyObjName = entry.getKey();
                appliedOnInterface = null;
                appliedDirection = null;
                policyID = this.policyNameVsIDMap.get(policyObjName);
                if (policyID == null) {
                    policyIDCrit = new Criteria(new Column("PolicyDetails", "RID"), (Object)rID, 0);
                    dObj = DataAccess.get((String)"PolicyDetails", (Criteria)(policyIDCrit = policyIDCrit.and(new Criteria(new Column("PolicyDetails", "POLICYNAME"), (Object)policyObjName, 0))));
                    if (!dObj.isEmpty()) {
                        policyID = (Long)dObj.getFirstValue("PolicyDetails", "POLICYID");
                    }
                }
                ruleObjList = entry.getValue();
                if (policyID == null) continue;
                if (this.aclInterfaceConfigMap != null && (policyInterfaceConfigDetails = this.aclInterfaceConfigMap.get(policyObjName)) != null && (m = (p = Pattern.compile("(?:1:(in|out),)?(?:2:(\\S+))?")).matcher(policyInterfaceConfigDetails)).find()) {
                    appliedDirection = m.group(1);
                    appliedOnInterface = m.group(2).trim();
                    appliedOnInterface = appliedOnInterface != null ? appliedOnInterface.trim() : null;
                }
                i = 1;
                for (RuleObject ruleObj : ruleObjList) {
                    protoSetFromService.clear();
                    currentRuleObj = ruleObj;
                    this.hasUnknownPorts = false;
                    this.unResolvedObjectsSet.clear();
                    srcUnResolved.clear();
                    dstUnResolved.clear();
                    serviceUnResolved.clear();
                    isNAT = false;
                    isVPNRule = false;
                    isAnySRC = false;
                    isAnyDST = false;
                    isAnyService = false;
                    srcDetails = null;
                    dstDetails = null;
                    serviceDetails = null;
                    srcInterface.clear();
                    srcZone.clear();
                    dstInterface.clear();
                    dstZone.clear();
                    dstPortSet.clear();
                    protoSetFromService.clear();
                    zoneBuilder.setLength(0);
                    serviceBuilder.setLength(0);
                    protoBuilder.setLength(0);
                    ruleDetailsRow = new Row("RuleDetails");
                    ruleDetailsRow.set("RID", (Object)rID);
                    ruleDetailsRow.set("POLICYID", (Object)policyID);
                    ruleName = ruleObj.getName();
                    ruleName = ruleName != null && "".equals(ruleName.trim()) == false ? ruleName : "" + i;
                    ruleDetailsRow.set("RULENAME", (Object)ruleName);
                    ruleDetailsRow.set("INTERFACE", (Object)appliedOnInterface);
                    ruleType = ruleObj.getType();
                    src = ruleObj.getSrcAddr();
                    srcIPIDRange = ruleObj.getSrcIPIDRange();
                    srcIPIDRangeStr = null;
                    ruleSrc = src;
                    if (srcIPIDRange != null) {
                        srcIPIDRangeStr = srcIPIDRange;
                        ruleDetailsRow.set("RULE_SRC", (Object)src);
                        ruleDetailsRow.set("DETAILED_SRC", (Object)src);
                        ruleDetailsRow.set("SRCID_RANGE", (Object)srcIPIDRange);
                    } else if (src != null) {
                        srcDetails = this.getObjectDetails(src, rID, "Network");
                        if (srcDetails != null) {
                            ruleSrc = srcDetails[0];
                            ruleDetailsRow.set("RULE_SRC", (Object)ruleSrc);
                            temp = srcDetails[1];
                            ruleDetailsRow.set("DETAILED_SRC", (Object)temp);
                            if (temp != null) {
                                temp = temp.replace("<br>", "\n");
                                temp = temp.replace("&nbsp;", " ");
                            }
                            if ((srcIPIDRangeStr = srcDetails[5]) == null || srcIPIDRangeStr.equals("null") || "".equals(srcIPIDRangeStr.trim())) {
                                if (ruleSrc != null && this.policyProcessorUtilityObject.anyList.contains(ruleSrc.toLowerCase())) {
                                    srcIPIDRangeStr = "Any";
                                } else if (this.policyProcessorUtilityObject.matchPattern(ruleSrc, "\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")) {
                                    ipNumber = IPRange.getIPNumber((String)ruleSrc);
                                    srcIPIDRangeStr = "" + ipNumber + "-" + "" + ipNumber;
                                } else {
                                    this.unResolvedObjectsSet.add(src);
                                }
                            }
                            ruleDetailsRow.set("SRCID_RANGE", (Object)srcIPIDRangeStr);
                        } else if (this.policyProcessorUtilityObject.matchPattern(ruleSrc, "\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")) {
                            ruleDetailsRow.set("RULE_SRC", (Object)src);
                            ruleDetailsRow.set("DETAILED_SRC", (Object)src);
                            ipNumber = IPRange.getIPNumber((String)src);
                            srcIPIDRangeStr = ipNumber + "-" + ipNumber;
                            ruleDetailsRow.set("SRCID_RANGE", (Object)srcIPIDRangeStr);
                        }
                    }
                    if (srcIPIDRangeStr != null) {
                        ruleDetailsRow.set("GROUPED_SRCID", (Object)this.policyProcessorUtilityObject.toGroup(srcIPIDRangeStr));
                    }
                    srcUnResolved.addAll((HashSet)this.unResolvedObjectsSet.clone());
                    this.unResolvedObjectsSet.clear();
                    appliedIn = false;
                    v0 = thisInterfaceZone = this.hasInterfaceVsZoneMap != false ? this.interfaceVsZoneMap.get(appliedOnInterface) : null;
                    if ("in".equals(appliedDirection)) {
                        appliedIn = true;
                        ruleDetailsRow.set("SRC_INT", (Object)appliedOnInterface);
                        ruleDetailsRow.set("SRC_ZONE", (Object)thisInterfaceZone);
                    } else if (this.vpnACLs.contains(policyObjName) && appliedOnInterface == null) {
                        isVPNRule = true;
                        ruleDetailsRow.set("SRC_ZONE", (Object)"LAN");
                    } else if (this.siteToSiteVPNACLs.contains(policyObjName) && appliedOnInterface == null) {
                        isVPNRule = true;
                        ruleType = "LanToLanVPN";
                    } else if (ruleSrc != null && this.policyProcessorUtilityObject.anyList.contains(ruleSrc.toLowerCase())) {
                        ruleDetailsRow.set("RULE_SRC", (Object)"Any");
                        ruleDetailsRow.set("SRC_INT", (Object)"Any");
                        ruleDetailsRow.set("SRC_ZONE", (Object)"Any");
                        isAnySRC = true;
                    } else if (srcIPIDRangeStr != null && !"null".equals(srcIPIDRangeStr) && !"".equals(srcIPIDRangeStr)) {
                        srcZoneStr = null;
                        for (String ipID : ipIDArray = srcIPIDRangeStr.split(",")) {
                            for (String srcipID : srcIPIDArray = ipID.split(" && ")) {
                                srcInterfaceStr = this.getInterfaceUsingPhysicalIP(srcipID);
                                v1 = srcInterfaceStr = srcInterfaceStr == null ? this.getInterfaceUsingRoutingTables(appliedOnInterface, srcipID) : srcInterfaceStr;
                                if (srcInterfaceStr == null) {
                                    if (this.policyProcessorUtilityObject.isIPInRange(srcipID, this.vpnIPPoolDetails)) {
                                        srcZoneStr = "LAN";
                                    } else {
                                        srcInterfaceStr = this.getFromDefaultStaticRoute();
                                        this.unIdentifiedIPList.add(ruleSrc);
                                        this.unIdentifiedIPIDList.add(this.convertIpIDToIP(srcipID));
                                    }
                                }
                                if (srcInterfaceStr != null) {
                                    srcZoneStr = this.hasInterfaceVsZoneMap != false ? this.interfaceVsZoneMap.get(srcInterfaceStr) : null;
                                }
                                srcInterface.add(srcInterfaceStr);
                                srcZone.add(srcZoneStr);
                            }
                        }
                        srcIntToBeInDB = this.policyProcessorUtilityObject.converSetToString(srcInterface);
                        srcZoneToBeInDB = this.policyProcessorUtilityObject.converSetToString(srcZone);
                        ruleDetailsRow.set("SRC_INT", (Object)srcIntToBeInDB);
                        ruleDetailsRow.set("SRC_ZONE", (Object)srcZoneToBeInDB);
                    }
                    dstStart = System.currentTimeMillis();
                    dst = ruleObj.getDstAddr();
                    dstIPIDRange = ruleObj.getDstIPIDRange();
                    tmpService = ruleObj.getService();
                    if (dst == null && tmpService != null) {
                        ruleObj.setDstAddr(tmpService);
                        ruleObj.setService(null);
                        dst = tmpService;
                    }
                    dstIPIDRangeStr = null;
                    ruleDst = dst;
                    if (dstIPIDRange != null) {
                        ruleDetailsRow.set("RULE_DST", (Object)dst);
                        ruleDetailsRow.set("DETAILED_DST", (Object)dst);
                        ruleDetailsRow.set("DSTID_RANGE", (Object)dstIPIDRange);
                        dstIPIDRangeStr = dstIPIDRange;
                    } else if (dst != null) {
                        dstDetails = this.getObjectDetails(dst, rID, "Network");
                        if (dstDetails != null) {
                            ruleDst = dstDetails[0];
                            ruleDetailsRow.set("RULE_DST", (Object)ruleDst);
                            temp = dstDetails[1];
                            ruleDetailsRow.set("DETAILED_DST", (Object)temp);
                            if (temp != null) {
                                temp = temp.replace("<br>", "\n");
                                temp = temp.replace("&nbsp;", " ");
                            }
                            if ((dstIPIDRangeStr = dstDetails[5]) == null || dstIPIDRangeStr.equals("null") || "".equals(dstIPIDRangeStr.trim())) {
                                if (ruleDst != null && this.policyProcessorUtilityObject.anyList.contains(ruleDst.toLowerCase())) {
                                    dstIPIDRangeStr = "Any";
                                } else if (this.policyProcessorUtilityObject.matchPattern(ruleDst, "\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")) {
                                    ipNumber = IPRange.getIPNumber((String)ruleDst);
                                    dstIPIDRangeStr = "" + ipNumber + "-" + "" + ipNumber;
                                } else {
                                    this.unResolvedObjectsSet.add(dst);
                                }
                            }
                            ruleDetailsRow.set("DSTID_RANGE", (Object)dstIPIDRangeStr);
                        } else if (this.policyProcessorUtilityObject.matchPattern(ruleDst, "\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")) {
                            ruleDetailsRow.set("RULE_DST", (Object)dst);
                            ruleDetailsRow.set("DETAILED_DST", (Object)dst);
                            ipNumber = IPRange.getIPNumber((String)dst);
                            dstIPIDRangeStr = "" + ipNumber + "-" + "" + ipNumber;
                            ruleDetailsRow.set("DSTID_RANGE", (Object)dstIPIDRangeStr);
                        }
                    }
                    ruleDetailsRow.set("GROUPED_DSTID", (Object)this.policyProcessorUtilityObject.toGroup(dstIPIDRangeStr));
                    dstUnResolved.addAll((HashSet)this.unResolvedObjectsSet.clone());
                    this.unResolvedObjectsSet.clear();
                    v2 = thisInterfaceZone = this.hasInterfaceVsZoneMap != false ? this.interfaceVsZoneMap.get(appliedOnInterface) : null;
                    if ("out".equals(appliedDirection)) {
                        ruleDetailsRow.set("DST_INT", (Object)appliedOnInterface);
                        ruleDetailsRow.set("DST_ZONE", (Object)thisInterfaceZone);
                    } else if (!isVPNRule && appliedOnInterface == null && ruleType.equals("extended")) {
                        ruleType = "ACEForNAT";
                        ruleDetailsRow.set("SRC_INT", null);
                        ruleDetailsRow.set("SRC_ZONE", null);
                    } else if (ruleDst != null && this.policyProcessorUtilityObject.anyList.contains(ruleDst.toLowerCase())) {
                        ruleDetailsRow.set("RULE_DST", (Object)"Any");
                        ruleDetailsRow.set("DST_INT", (Object)"Any");
                        ruleDetailsRow.set("DST_ZONE", (Object)"Any");
                        isAnyDST = true;
                    } else if (dstIPIDRangeStr != null && !"null".equals(dstIPIDRangeStr) && !"".equals(dstIPIDRangeStr)) {
                        dstZoneStr = null;
                        for (String ipID : ipIDArray = dstIPIDRangeStr.split(",")) {
                            for (String dstipID : dstIPIDArray = ipID.split(" && ")) {
                                dstInterfaceStr = this.getInterfaceUsingPhysicalIP(dstipID);
                                v3 = dstInterfaceStr = dstInterfaceStr == null ? this.getInterfaceUsingRoutingTables(appliedOnInterface, dstipID) : dstInterfaceStr;
                                if (dstInterfaceStr == null) {
                                    if (this.policyProcessorUtilityObject.isIPInRange(dstipID, this.vpnIPPoolDetails)) {
                                        dstZoneStr = "LAN";
                                    } else {
                                        dstInterfaceStr = this.getFromDefaultStaticRoute();
                                        this.unIdentifiedIPList.add(ruleDst);
                                        this.unIdentifiedIPIDList.add(this.convertIpIDToIP(dstipID));
                                    }
                                }
                                if (dstInterfaceStr != null) {
                                    dstZoneStr = this.hasInterfaceVsZoneMap != false ? this.interfaceVsZoneMap.get(dstInterfaceStr) : null;
                                }
                                dstInterface.add(dstInterfaceStr);
                                dstZone.add(dstZoneStr);
                            }
                        }
                        dstIntToBeInDB = this.policyProcessorUtilityObject.converSetToString(dstInterface);
                        dstZoneToBeInDB = this.policyProcessorUtilityObject.converSetToString(dstZone);
                        ruleDetailsRow.set("DST_INT", (Object)dstIntToBeInDB);
                        ruleDetailsRow.set("DST_ZONE", (Object)dstZoneToBeInDB);
                    }
                    if (src != null && dst != null) {
                        src = src.trim();
                        dst = dst.trim();
                        if (this.policyProcessorUtilityObject.anyList.contains(src.toLowerCase())) {
                            ruleDetailsRow.set("RULE_SRC", (Object)"Any");
                            ruleDetailsRow.set("DETAILED_SRC", (Object)"Any");
                            isAnySRC = true;
                        }
                        if (this.policyProcessorUtilityObject.anyList.contains(dst.toLowerCase())) {
                            ruleDetailsRow.set("RULE_DST", (Object)"Any");
                            ruleDetailsRow.set("DETAILED_DST", (Object)"Any");
                            isAnyDST = true;
                        }
                        direction = "WAN".equals(srcZone) != false ? "inbound" : ("WAN".equals(dstZone) != false ? "outbound" : null);
                        ruleDetailsRow.set("DIRECTION", (Object)direction);
                    }
                    if (isNAT) {
                        ruleDetailsRow.set("NAT", (Object)"enable");
                    }
                    status = "inactive".equals(status = ruleObj.getStatus()) != false ? "No" : "Yes";
                    ruleDetailsRow.set("RULE_STATUS", (Object)status);
                    ruleProtocol = ruleObj.getProtocol();
                    if (ruleProtocol != null) {
                        if (this.protocolObjInfoMap.containsKey(ruleProtocol)) {
                            protocolDetailsArray = this.getObjectDetails(ruleProtocol, rID, "Protocol");
                            protoDetails = protocolDetailsArray[1];
                            for (String protocol : protoDetailsArray = protoDetails.split("<br>")) {
                                protoBuilder.append(protocol.toUpperCase());
                                protoBuilder.append(",");
                            }
                            ruleProtocol = this.policyProcessorUtilityObject.removeLastChar(protoBuilder, protoBuilder.length());
                        } else if (this.icmpObjInfoMap.containsKey(ruleProtocol)) {
                            ruleObj.setService(ruleProtocol);
                            ruleProtocol = "ICMP";
                        } else {
                            ruleProtocol = ruleProtocol.toUpperCase();
                        }
                        ruleDetailsRow.set("PROTOCOL", (Object)ruleProtocol);
                    } else {
                        ruleDetailsRow.set("PROTOCOL", (Object)"Any");
                        ruleProtocol = "Any";
                    }
                    ruleAction = ruleObj.getAction();
                    service = ruleObj.getService();
                    if (service != null) {
                        temp = null;
                        mat = CiscoPolicyProcessor.srcAndDstObjExtractPatternFromRuleService.matcher(service);
                        if (mat.matches()) {
                            try {
                                srcObj = mat.group(1);
                                dstObj = mat.group(2);
                                serviceDetails = this.getObjectDetails(srcObj, rID, "Service");
                                detailedSRCObj = serviceDetails[1];
                                detailedSRCObj = detailedSRCObj.replaceAll("dstPort", "srcPort");
                                detailedSRCObj = detailedSRCObj.replaceAll("<br>", "\n");
                                detailedSRCObj = detailedSRCObj.replaceAll("&nbsp", " ");
                                this.extractPortInfo(srcObj, detailedSRCObj, protoVsSRCPortSet, protoVsDSTPortSet, resourceName, "Cisco", true, protoSetFromService);
                                srcPorts = protoVsSRCPortSet.get("TCP");
                                if (srcPorts != null && protoVsSRCPortSet.get("UDP") != null) {
                                    srcPorts.addAll((Collection<String>)protoVsSRCPortSet.get("UDP"));
                                } else if (srcPorts == null) {
                                    srcPorts = protoVsSRCPortSet.get("UDP");
                                }
                                if (dstObj != null) {
                                    serviceDetails = this.getObjectDetails(dstObj, rID, "Service");
                                    detailedDSTObj = serviceDetails[1];
                                    detailedDSTObj = detailedDSTObj.replaceAll("<br>", "\n");
                                    detailedDSTObj = detailedDSTObj.replaceAll("&nbsp", " ");
                                    this.extractPortInfo(dstObj, detailedDSTObj, protoVsSRCPortSet, protoVsDSTPortSet, resourceName, "Cisco", true, protoSetFromService);
                                    dstPortSet = protoVsDSTPortSet.get("TCP");
                                    if (dstPortSet != null && protoVsDSTPortSet.get("UDP") != null) {
                                        dstPortSet.addAll((Collection<String>)protoVsDSTPortSet.get("UDP"));
                                    } else if (dstPortSet == null) {
                                        dstPortSet = protoVsDSTPortSet.get("UDP");
                                    }
                                } else {
                                    dstPortSet.add("Any");
                                }
                                temp = this.getDetailedServiceFromSrcAndDstObjects(ruleProtocol, srcPorts, dstPortSet);
                                ruleDetailsRow.set("SERVICE", (Object)service);
                                ruleDetailsRow.set("DETAILED_SERVICE", (Object)temp);
                                temp = temp.replace("<br>", "\n");
                                temp = temp.replace("&nbsp;", " ");
                                port_info = this.getGroupedSrcAndDstPortsWithProtocols(ruleProtocol, srcPorts, dstPortSet);
                                ruleDetailsRow.set("PORT_INFO", (Object)port_info);
                                if (this.hasUnknownPorts) ** GOTO lbl416
                                ruleDetailsRow.set("GROUPED_PORTS", (Object)this.policyProcessorUtilityObject.portGroup(port_info));
                            }
                            catch (Exception ee) {
                                throw new Exception("Problem while dealing with src and dst service objects for the service::" + service + " for the firewall::: " + resourceName + " of Cisco Vendor..", ee);
                            }
                        } else {
                            serviceDetails = ruleProtocol.contains("ICMP") != false ? this.getObjectDetails(service, rID, "ICMP") : this.getObjectDetails(service, rID, "Service");
                            ruleDetailsRow.set("SERVICE", (Object)serviceDetails[0]);
                            temp = serviceDetails[1];
                            if (ruleProtocol.equals("TCP") || ruleProtocol.equals("UDP")) {
                                temp = this.modifyServiceObjDetailsBasedOnProtocol(temp, ruleProtocol);
                            }
                            ruleDetailsRow.set("DETAILED_SERVICE", (Object)temp);
                            if (temp != null) {
                                temp = temp.replace("<br>", "\n");
                                temp = temp.replace("&nbsp;", " ");
                            }
                            port_info = this.extractPortInfo(service, temp, protoVsSRCPortSet, protoVsDSTPortSet, resourceName, "Cisco", false, protoSetFromService);
                            ruleDetailsRow.set("PORT_INFO", (Object)port_info);
                            if (!this.hasUnknownPorts) {
                                ruleDetailsRow.set("GROUPED_PORTS", (Object)this.policyProcessorUtilityObject.portGroup(port_info));
                            }
                            if (ruleProtocol.equals("Any") && !protoSetFromService.isEmpty()) {
                                ruleDetailsRow.set("PROTOCOL", (Object)this.policyProcessorUtilityObject.convertHashSetToString(protoSetFromService));
                            }
                        }
                    } else if (ruleProtocol != null && !"Any".equals(ruleProtocol)) {
                        srcPorts = ruleObj.getSrcPort();
                        dstPorts = ruleObj.getDstPort();
                        if (srcPorts != null || dstPorts != null) {
                            for (String protocol : protoDetailsArray = ruleProtocol.split(",")) {
                                srcPortExists = false;
                                serviceBuilder.append(protocol);
                                serviceBuilder.append(" ");
                                if (srcPorts != null) {
                                    srcPortExists = true;
                                    srcPorts = srcPorts.trim();
                                    serviceBuilder.append(srcPorts);
                                }
                                if (dstPorts != null) {
                                    dstPorts = dstPorts.trim();
                                    if (srcPortExists) {
                                        serviceBuilder.append(",");
                                    }
                                    serviceBuilder.append(dstPorts);
                                }
                                serviceBuilder.append(" |_| ");
                            }
                            service = serviceBuilder.substring(0, serviceBuilder.lastIndexOf(" |_| "));
                            ruleDetailsRow.set("SERVICE", (Object)service);
                            ruleDetailsRow.set("DETAILED_SERVICE", (Object)service);
                            port_info = this.extractPortInfo(service, service, protoVsSRCPortSet, protoVsDSTPortSet, resourceName, deviceType, false, protoSetFromService);
                            ruleDetailsRow.set("PORT_INFO", (Object)port_info);
                            if (!this.hasUnknownPorts) {
                                ruleDetailsRow.set("GROUPED_PORTS", (Object)this.policyProcessorUtilityObject.portGroup(port_info));
                            }
                        } else {
                            serviceNameinBig = "Any " + ruleProtocol;
                            if ("IP".equals(ruleProtocol)) {
                                ruleDetailsRow.set("SERVICE", (Object)"Any");
                                ruleDetailsRow.set("DETAILED_SERVICE", (Object)"Any");
                                ruleDetailsRow.set("PORT_INFO", (Object)"Any:dstPort=Any#srcPort=Any#");
                                ruleDetailsRow.set("GROUPED_PORTS", (Object)"Any:dstPort=Any#srcPort=Any#");
                                isAnyService = true;
                            } else {
                                ruleDetailsRow.set("SERVICE", (Object)serviceNameinBig);
                                ruleDetailsRow.set("DETAILED_SERVICE", (Object)serviceNameinBig);
                                ruleDetailsRow.set("PORT_INFO", (Object)(ruleProtocol + ":dstPort=Any#srcPort=Any#"));
                                ruleDetailsRow.set("GROUPED_PORTS", (Object)(ruleProtocol + ":dstPort=Any#srcPort=Any#"));
                            }
                        }
                    } else {
                        ruleDetailsRow.set("SERVICE", (Object)"Any");
                        ruleDetailsRow.set("DETAILED_SERVICE", (Object)"Any");
                        ruleDetailsRow.set("PORT_INFO", (Object)"Any:dstPort=Any#srcPort=Any#");
                        ruleDetailsRow.set("GROUPED_PORTS", (Object)"Any:dstPort=Any#srcPort=Any#");
                        isAnyService = true;
                    }
lbl416:
                    // 7 sources

                    cklServices = null;
                    if (!"deny".equals(ruleAction) && "Yes".equals(status)) {
                        try {
                            cklServices = this.policyProcessorUtilityObject.getAllowedChecklistServices((String)ruleDetailsRow.get("PORT_INFO"));
                            ruleDetailsRow.set("CHECKLIST_SERVICE", (Object)cklServices);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    serviceUnResolved.addAll((HashSet)this.unResolvedObjectsSet.clone());
                    this.unResolvedObjectsSet.clear();
                    unResolvedObjects = this.policyProcessorUtilityObject.getFinalUnResolvedObjs(srcUnResolved, dstUnResolved, serviceUnResolved);
                    ruleDetailsRow.set("UNRESOLVED_OBJECTS", (Object)unResolvedObjects);
                    logStatus = ruleObj.getLog();
                    logStatus = "log".equals(logStatus) != false ? "enable" : "disable";
                    ruleDetailsRow.set("LOG", (Object)logStatus);
                    logLevelValue = this.getLogLevelValue(ruleObj.getLogLevel());
                    ruleDetailsRow.set("LOG_LEVEL", (Object)logLevelValue);
                    ruleDetailsRow.set("LOG_INTERVAL", (Object)ruleObj.getLogInterval());
                    ruleDetailsRow.set("ACTION", (Object)ruleAction);
                    ruleDetailsRow.set("SCHEDULE", (Object)ruleObj.getSchedule());
                    ruleDetailsRow.set("AUTHETICATION", (Object)ruleObj.getUserGroup());
                    ruleDetailsRow.set("COMMENTS", (Object)ruleObj.getRuleComment());
                    ruleDetailsRow.set("RULE_TYPE", (Object)ruleType);
                    if ("webtype".equals(ruleType) || "standard".equals(ruleType)) {
                        ruleDetailsRow.set("RULE_SRC", (Object)"Any");
                        ruleDetailsRow.set("DETAILED_SRC", (Object)"Any");
                        if ("webtype".equals(ruleType)) {
                            ruleDetailsRow.set("SRC_ZONE", (Object)"LAN");
                            ruleDetailsRow.set("DIRECTION", (Object)"outbound");
                        }
                    }
                    if ((url = ruleObj.getURL()) != null) {
                        ruleDetailsRow.set("DST_ZONE", (Object)"WAN");
                        ruleDetailsRow.set("URL", (Object)url);
                    }
                    if (this.isInDebugMode && appliedOnInterface != null) {
                        tempSrcInt = (String)ruleDetailsRow.get("SRC_INT");
                        tempDstInt = (String)ruleDetailsRow.get("DST_INT");
                        tempRuleType = (String)ruleDetailsRow.get("RULE_TYPE");
                        if ("extended".equals(tempRuleType)) {
                            if (tempDstInt == null || "".equals(tempDstInt.trim())) {
                                this.unFoundDstInterfaceSet.add((String)ruleDetailsRow.get("RULE_DST"));
                            }
                            if (tempSrcInt == null || "".equals(tempSrcInt.trim())) {
                                this.unFoundSrcInterfaceSet.add((String)ruleDetailsRow.get("RULE_SRC"));
                            }
                        }
                    }
                    if (!hasExplicitDenyRule && "extended".equals(ruleType) && appliedOnInterface != null) {
                        securityLevel = this.interfaceVsSecurityLevel.get(appliedOnInterface);
                        if (securityLevel == null || securityLevel == 0 || isAnySRC && isAnyDST && isAnyService && "deny".equals(ruleAction)) {
                            hasExplicitDenyRule = true;
                        }
                    } else {
                        hasExplicitDenyRule = true;
                    }
                    srcVal = (String)ruleDetailsRow.get("RULE_SRC");
                    dstVal = (String)ruleDetailsRow.get("RULE_DST");
                    serviceVal = (String)ruleDetailsRow.get("SERVICE");
                    unResolvedVal = (String)ruleDetailsRow.get("UNRESOLVED_OBJECTS");
                    if ("Any".equals(srcVal) || "All".equals(srcVal)) {
                        ruleDetailsRow.set("ANY_SRC", (Object)Boolean.TRUE);
                    }
                    if ("Any".equals(dstVal) || "All".equals(dstVal)) {
                        ruleDetailsRow.set("ANY_DST", (Object)Boolean.TRUE);
                    }
                    if ("Any".equals(serviceVal) || "All".equals(serviceVal) || "Any TCP".equals(serviceVal) || "Any UDP".equals(serviceVal)) {
                        ruleDetailsRow.set("ANY_SERVICE", (Object)Boolean.TRUE);
                    }
                    if (unResolvedVal != null && !"".equals(unResolvedVal.trim())) {
                        ruleDetailsRow.set("IS_UNRESOLVED_DATA", (Object)Boolean.TRUE);
                    }
                    CiscoPolicyProcessor.LOGGER.log(Level.FINER, " CiscoPolicyProcessor :::: RuleDetails ROW is :::::::: {0} ", ruleDetailsRow);
                    var69_114 = this.policyProcessorUtilityObject.ruleDetailsAutoGenKeyLock;
                    synchronized (var69_114) {
                        DataAccess.generateValues((Row)ruleDetailsRow);
                    }
                    doo.addRow(ruleDetailsRow);
                    srcGrps = null;
                    dstGrps = null;
                    serviceGrps = null;
                    srcGrpStr = null;
                    dstGrpStr = null;
                    serviceGrpStr = null;
                    if (srcDetails != null) {
                        srcGrpStr = srcDetails[0];
                    }
                    if (dstDetails != null) {
                        dstGrpStr = dstDetails[0];
                    }
                    if (serviceDetails != null) {
                        serviceGrpStr = serviceDetails[0];
                    }
                    srcGrpLen = 1;
                    dstGrpLen = 1;
                    serviceGrpLen = 1;
                    if (srcGrpStr != null) {
                        srcGrps = srcGrpStr.split("<br>");
                        srcGrpLen = srcGrps.length;
                    }
                    if (dstGrpStr != null) {
                        dstGrps = dstGrpStr.split("<br>");
                        dstGrpLen = dstGrps.length;
                    }
                    if (serviceGrpStr != null) {
                        serviceGrps = serviceGrpStr.split("<br>");
                        serviceGrpLen = serviceGrps.length;
                    }
                    maxLength = srcGrpLen > dstGrpLen ? (srcGrpLen > serviceGrpLen ? srcGrpLen : serviceGrpLen) : (dstGrpLen > serviceGrpLen ? dstGrpLen : serviceGrpLen);
                    ruleID = ruleDetailsRow.get("RULEID");
                    srcElement = null;
                    dstElement = null;
                    serviceElement = null;
                    for (k = 0; k < maxLength; ++k) {
                        ruleVsDetailsRow = new Row("RuleToObjOneToNMapping");
                        ruleVsDetailsRow.set("RULEID", ruleID);
                        if (k < srcGrpLen) {
                            if (srcGrpLen == 1 && srcGrps == null) {
                                ruleVsDetailsRow.set("RULE_SRC", (Object)srcVal);
                            } else {
                                srcElement = srcGrps[k];
                                ruleVsDetailsRow.set("RULE_SRC", (Object)srcElement);
                            }
                        }
                        if (k < dstGrpLen) {
                            if (dstGrpLen == 1 && dstGrps == null) {
                                ruleVsDetailsRow.set("RULE_DST", (Object)dstVal);
                            } else {
                                dstElement = dstGrps[k];
                                ruleVsDetailsRow.set("RULE_DST", (Object)dstElement);
                            }
                        }
                        if (k < serviceGrpLen) {
                            if (serviceGrpLen == 1 && serviceGrps == null) {
                                ruleVsDetailsRow.set("SERVICE", (Object)serviceVal);
                            } else {
                                serviceElement = serviceGrps[k];
                                ruleVsDetailsRow.set("SERVICE", (Object)serviceElement);
                            }
                        }
                        var85_131 = this.policyProcessorUtilityObject.ruleObjMappingAutoGenKeyLock;
                        synchronized (var85_131) {
                            DataAccess.generateValues((Row)ruleVsDetailsRow);
                        }
                        doo.addRow(ruleVsDetailsRow);
                    }
                    ++i;
                }
                if (hasExplicitDenyRule) continue;
                this.updatePolicyDetailsNotes(policyID, appliedOnInterface);
            }
            protoVsSRCPortSet = null;
            protoVsDSTPortSet = null;
        }
        catch (Exception exp) {
            this.policyProcessorUtilityObject.printRuleObjDetails(currentRuleObj);
            throw new Exception("Problem while populating Rule Details into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
        }
    }

    private void updatePolicyDetailsNotes(Long policyID, String interfaceName) {
        try {
            UpdateQueryImpl uq = new UpdateQueryImpl("PolicyDetails");
            Criteria crit = new Criteria(new Column("PolicyDetails", "POLICYID"), (Object)policyID, 0);
            uq.setCriteria(crit);
            uq.setUpdateColumn("NON_EXPLICIT_DENY_INTERFACE", (Object)interfaceName);
            DataAccess.update((UpdateQuery)uq);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private String modifyServiceObjDetailsBasedOnProtocol(String temp, String ruleProtocol) throws Exception {
        String[] data;
        boolean isTCP = ruleProtocol.equals("TCP");
        StringBuilder modifiedServiceBuilder = new StringBuilder();
        for (String line : data = temp.split("<br>")) {
            String[] protoElements;
            boolean isBracketData = false;
            String bracketData = this.getDataFromBracket(line);
            if (!bracketData.equals(line) && !bracketData.equals("Group")) {
                isBracketData = true;
                line = bracketData;
            }
            for (String protoElement : protoElements = line.split(" \\|_\\| ")) {
                if (isTCP) {
                    if (protoElement.indexOf("TCP") <= -1) continue;
                    modifiedServiceBuilder.append(protoElement);
                    modifiedServiceBuilder.append("<br>");
                    continue;
                }
                if (protoElement.indexOf("UDP") <= -1) continue;
                modifiedServiceBuilder.append(protoElement);
                modifiedServiceBuilder.append("<br>");
            }
        }
        return this.policyProcessorUtilityObject.removeLastDelimeter(modifiedServiceBuilder, "<br>");
    }

    private String getDetailedServiceFromSrcAndDstObjects(String protocols, HashSet<String> srcPorts, HashSet<String> dstPorts) throws Exception {
        Matcher mat = null;
        if (protocols != null && srcPorts != null && dstPorts != null) {
            HashSet<String> srcAndDstPortCombinations = new HashSet<String>();
            StringBuilder sb = new StringBuilder();
            for (String srcPort : srcPorts) {
                for (String dstPort : dstPorts) {
                    srcPort = srcPort.trim();
                    dstPort = dstPort.trim();
                    sb.append("srcPort");
                    mat = srcAndDstPortOperatorPattern.matcher(srcPort);
                    if (!mat.matches()) {
                        sb.append("=");
                    }
                    sb.append(srcPort);
                    sb.append(",dstPort");
                    mat = srcAndDstPortOperatorPattern.matcher(dstPort);
                    if (!mat.matches()) {
                        sb.append("=");
                    }
                    sb.append(dstPort);
                    srcAndDstPortCombinations.add(sb.toString());
                    sb.setLength(0);
                }
            }
            String[] protoArray = protocols.split(",");
            StringBuilder protoBuilder = new StringBuilder();
            StringBuilder serviceBuilder = new StringBuilder();
            for (String portCombo : srcAndDstPortCombinations) {
                for (String protocol : protoArray) {
                    protoBuilder.append(protocol);
                    protoBuilder.append(" ");
                    protoBuilder.append(portCombo);
                    protoBuilder.append(" |_| ");
                }
                serviceBuilder.append(this.policyProcessorUtilityObject.removeLastDelimeter(protoBuilder, " |_| "));
                serviceBuilder.append("<br>");
                protoBuilder.setLength(0);
            }
            return this.policyProcessorUtilityObject.removeLastDelimeter(serviceBuilder, "<br>");
        }
        return null;
    }

    private String getGroupedSrcAndDstPortsWithProtocols(String protocols, HashSet<String> srcPorts, HashSet<String> dstPorts) throws Exception {
        if (protocols != null && srcPorts != null && dstPorts != null) {
            String srcPortString = this.policyProcessorUtilityObject.convertHashSetToString(srcPorts);
            srcPortString = srcPortString != null ? "srcPort=" + srcPortString : "srcPort=Any";
            String dstPortString = this.policyProcessorUtilityObject.convertHashSetToString(dstPorts);
            dstPortString = dstPortString != null ? "dstPort=" + dstPortString : "dstPort=Any";
            String[] protoArray = protocols.split(",");
            StringBuilder sb = new StringBuilder();
            for (String proto : protoArray) {
                sb.append(proto);
                sb.append(":");
                sb.append(dstPortString);
                sb.append("#");
                sb.append(srcPortString);
                sb.append("#");
                sb.append("&&");
            }
            return this.policyProcessorUtilityObject.removeLastDelimeter(sb, "&&");
        }
        return null;
    }

    public String getInterfaceUsingNATRules(String knownInterface, String ipID) {
        try {
            String foundInterface = this.matchWithNATRules(ipID, "static", knownInterface);
            if (foundInterface == null) {
                foundInterface = this.matchWithNATRules(ipID, "dynamic", knownInterface);
            }
            return foundInterface;
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return null;
        }
    }

    private String matchWithNATRules(String ipID, String natType, String knownInterface) {
        HashMap<String, ArrayList<String[]>> natConfig;
        String matchedKey = null;
        HashMap<String, ArrayList<String[]>> hashMap = natConfig = natType.equals("static") ? this.staticNATConfig : this.dynamicNATConfig;
        if (natConfig.containsKey(ipID)) {
            matchedKey = ipID;
        } else {
            String[] ipIDRange = ipID.split("-");
            long lowerIP = Long.parseLong(ipIDRange[0]);
            long higherIP = Long.parseLong(ipIDRange[1]);
            for (String key : natConfig.keySet()) {
                String[] translatedIPNumStrArr = key.split("-");
                long tranIPNumMin = Long.parseLong(translatedIPNumStrArr[0]);
                long tranIPNumMax = Long.parseLong(translatedIPNumStrArr[1]);
                if (tranIPNumMin >= lowerIP && tranIPNumMin <= higherIP) {
                    matchedKey = key;
                    break;
                }
                if (tranIPNumMax >= lowerIP && tranIPNumMax <= higherIP) {
                    matchedKey = key;
                    break;
                }
                if (lowerIP >= tranIPNumMin && lowerIP <= tranIPNumMax) {
                    matchedKey = key;
                    break;
                }
                if (higherIP < tranIPNumMin || higherIP > tranIPNumMax) continue;
                matchedKey = key;
                break;
            }
        }
        if (matchedKey != null) {
            ArrayList<String[]> natDetailsList = natConfig.get(matchedKey);
            if (knownInterface != null) {
                for (String[] natDetails : natDetailsList) {
                    String fromInterface = natDetails[0];
                    String toInterface = natDetails[1];
                    if (knownInterface.equals(fromInterface)) {
                        return toInterface;
                    }
                    if (!knownInterface.equals(toInterface)) continue;
                    return fromInterface;
                }
            }
        }
        return null;
    }

    private String getLogLevelValue(String logLevelString) {
        String toReturn = null;
        if (logLevelString != null) {
            toReturn = (logLevelString = logLevelString.toLowerCase()).equals("emergencies") ? "0" : (logLevelString.equals("alerts") ? "1" : (logLevelString.equals("critical") ? "2" : (logLevelString.equals("errors") ? "3" : (logLevelString.equals("warnings") ? "4" : (logLevelString.equals("notifications") ? "5" : (logLevelString.equals("informational") ? "6" : (logLevelString.equals("debugging") ? "7" : logLevelString)))))));
        }
        return toReturn;
    }

    private void populateInterfaceDetailsIntoDB(Long rID, LinkedHashMap<String, InterfaceDetails> interfaceDetailsObjMap, String deviceType, String resourceName) throws Exception {
        try {
            DataObject doo = DataAccess.constructDataObject();
            if (interfaceDetailsObjMap != null && !interfaceDetailsObjMap.isEmpty()) {
                LOGGER.fine("populating Interface Details.....");
                boolean hasIP = false;
                String objName = null;
                String vlan = null;
                InterfaceDetails interfaceDetailsObj = null;
                for (Map.Entry<String, InterfaceDetails> entry : interfaceDetailsObjMap.entrySet()) {
                    String ip;
                    hasIP = false;
                    objName = entry.getKey();
                    interfaceDetailsObj = entry.getValue();
                    objName = interfaceDetailsObj.getInterfaceName();
                    String aliasName = interfaceDetailsObj.getAliasName();
                    aliasName = aliasName != null ? aliasName : objName;
                    this.allInterfaces.add(objName);
                    Row interfaceDetailsRow = new Row("InterfaceDetails");
                    interfaceDetailsRow.set("RID", (Object)rID);
                    interfaceDetailsRow.set("INTERFACE_NAME", (Object)objName);
                    interfaceDetailsRow.set("ALIAS_NAME", (Object)aliasName);
                    if (this.hasInterfaceVsZoneMap) {
                        interfaceDetailsRow.set("INTERFACE_NETWORK_ZONE", (Object)this.interfaceVsZoneMap.get(aliasName));
                    }
                    if ((ip = interfaceDetailsObj.getIP()) != null && !"".equals(ip) && !"null".equals(ip)) {
                        hasIP = true;
                        ip = ip.replaceAll(" ", "/");
                        this.interfaceVsIPAddrMap.put(aliasName, ip);
                    }
                    interfaceDetailsRow.set("IPADDRESS", (Object)ip);
                    String status = interfaceDetailsObj.getStatus();
                    status = "shutdown".equals(status) ? "No" : "Yes";
                    interfaceDetailsRow.set("ACTIVE", (Object)status);
                    if (status.equals("Yes") && hasIP) {
                        interfaceDetailsRow.set("USED", (Object)1);
                    }
                    vlan = interfaceDetailsObj.getVdomName();
                    interfaceDetailsRow.set("VDOM_NAME", (Object)vlan);
                    if (vlan == null) {
                        interfaceDetailsRow.set("INTERFACE_TYPE", (Object)"physical");
                    } else {
                        interfaceDetailsRow.set("INTERFACE_TYPE", (Object)"logical");
                    }
                    String securityLevel = interfaceDetailsObj.getSecurityLevel();
                    if (securityLevel != null) {
                        this.interfaceVsSecurityLevel.put(aliasName, new Integer(securityLevel));
                    }
                    interfaceDetailsRow.set("SECURITY_LEVEL", (Object)securityLevel);
                    interfaceDetailsRow.set("SPEED", (Object)interfaceDetailsObj.getSpeed());
                    interfaceDetailsRow.set("DUPLEX", (Object)interfaceDetailsObj.getDuplex());
                    interfaceDetailsRow.set("DESCRIPTION", (Object)interfaceDetailsObj.getInterfaceDesc());
                    LOGGER.log(Level.FINER, " CiscoPolicyProcessor :::: InterfaceDetails ROW is :::::::: {0} ", interfaceDetailsRow);
                    doo.addRow(interfaceDetailsRow);
                }
                DataAccess.add((DataObject)doo);
            } else {
                LOGGER.info("No Interfaces Found.....");
            }
        }
        catch (Exception exp) {
            throw new Exception("Problem while populating Interface Details into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateNetworkObjectsDataIntoDB(DataObject doo, Long rID, LinkedHashMap<String, NetworkObject> netObjMap, String deviceType, String resourceName) throws Exception {
        block11: {
            try {
                if (netObjMap != null && !netObjMap.isEmpty()) {
                    LOGGER.fine("populating Network Objects.....");
                    NetworkObject netObj = null;
                    String[] minMaxID = null;
                    for (Map.Entry<String, NetworkObject> entry : netObjMap.entrySet()) {
                        String objName = entry.getKey();
                        netObj = entry.getValue();
                        String subnet = netObj.getSubnet();
                        String subnetMask = netObj.getSubnetMask();
                        String startIP = netObj.getStartIP();
                        String endIP = netObj.getEndIP();
                        String value = subnet != null && subnetMask != null ? subnet + "/" + subnetMask : (startIP != null && endIP != null ? startIP + "-" + endIP : null);
                        Row networkObjRow = new Row("FirewallObjects");
                        networkObjRow.set("RID", (Object)rID);
                        networkObjRow.set("NAME", (Object)netObj.getName());
                        networkObjRow.set("VALUE_IN_CONFIG", (Object)value);
                        subnet = IPRange.getNetwork((String)subnetMask, (String)subnet);
                        networkObjRow.set("SUBNET", (Object)subnet);
                        networkObjRow.set("SUBNETWORK_ID", (Object)String.valueOf(IPRange.getIPNumber((String)subnet)));
                        networkObjRow.set("SUBNET_MASK", (Object)subnetMask);
                        networkObjRow.set("START_IP", (Object)startIP);
                        networkObjRow.set("END_IP", (Object)endIP);
                        String ipIDRange = netObj.getIPRangeID();
                        if (startIP != null && ipIDRange != null) {
                            minMaxID = ipIDRange.split("-");
                            networkObjRow.set("STARTIP_ID", (Object)minMaxID[0]);
                            networkObjRow.set("ENDIP_ID", (Object)minMaxID[1]);
                        }
                        networkObjRow.set("IP_RANGE", (Object)netObj.getIPRange());
                        networkObjRow.set("IPRANGE_ID", (Object)ipIDRange);
                        networkObjRow.set("OBJECT_TYPE", (Object)"Network");
                        networkObjRow.set("TO_DISPLAY", (Object)value);
                        this.netObjInfoMap.put(objName, value);
                        LOGGER.log(Level.FINER, " CiscoPolicyProcessor :::: FirewallObjects ROW is :::::::: {0} ", networkObjRow);
                        Object object = this.policyProcessorUtilityObject.firewallObjAutoGenKeyLock;
                        synchronized (object) {
                            DataAccess.generateValues((Row)networkObjRow);
                        }
                        doo.addRow(networkObjRow);
                        if (netObj.isFWACreatedObject()) continue;
                        Object objID = networkObjRow.get("OBJID");
                        Row objToChildOneToNMapRow = new Row("ObjectToChildOneToNMapping");
                        objToChildOneToNMapRow.set("RID", (Object)rID);
                        objToChildOneToNMapRow.set("OBJID", objID);
                        objToChildOneToNMapRow.set("NAME", (Object)objName);
                        objToChildOneToNMapRow.set("OBJECT_DETAILS", (Object)value);
                        objToChildOneToNMapRow.set("LINK_NEEDED", (Object)"No");
                        Object object2 = this.policyProcessorUtilityObject.objOneToNMappingAutoGenKeyLock;
                        synchronized (object2) {
                            DataAccess.generateValues((Row)objToChildOneToNMapRow);
                        }
                        doo.addRow(objToChildOneToNMapRow);
                        this.allObjects.add(objName);
                    }
                    break block11;
                }
                LOGGER.info("No Network Objects Found.....");
            }
            catch (Exception exp) {
                throw new Exception("Problem while populating Network Objects Details into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateServiceObjectsDataIntoDB(DataObject doo, Long rID, LinkedHashMap<String, ServiceObject> serviceObjMap, String deviceType, String resourceName) throws Exception {
        block41: {
            try {
                if (serviceObjMap != null && !serviceObjMap.isEmpty()) {
                    LOGGER.fine("populating Service Objects.....");
                    String objName = null;
                    ServiceObject serviceObj = null;
                    boolean isICMP = false;
                    for (Map.Entry<String, ServiceObject> entry : serviceObjMap.entrySet()) {
                        Object icmpType;
                        objName = entry.getKey();
                        serviceObj = entry.getValue();
                        Row serviceObjRow = new Row("FirewallObjects");
                        serviceObjRow.set("RID", (Object)rID);
                        serviceObjRow.set("NAME", (Object)serviceObj.getName());
                        String serviceProtocol = serviceObj.getProtocol();
                        String service = serviceObj.getService();
                        String valueToBeInDB = null;
                        boolean bothTCPAndUDP = false;
                        isICMP = false;
                        if (serviceProtocol != null) {
                            if ((serviceProtocol = serviceProtocol.toUpperCase()).indexOf("TCP") > -1 || serviceProtocol.indexOf("UDP") > -1) {
                                String dstPortOperator;
                                String srcPortOperator;
                                if (serviceProtocol.equals("TCP-UDP")) {
                                    bothTCPAndUDP = true;
                                }
                                if ((srcPortOperator = serviceObj.getSRCPortOperator()) == null) {
                                    if (serviceObj.getSRCPortRangeStr() != null) {
                                        String srcStartPort = serviceObj.getSrcStartPort();
                                        String srcEndPort = serviceObj.getSrcEndPort();
                                        valueToBeInDB = !bothTCPAndUDP ? serviceProtocol + " " + "srcPort=" + srcStartPort + " to " + srcEndPort : "srcPort=" + srcStartPort + " to " + srcEndPort;
                                    }
                                } else {
                                    if ("lt".equals(srcPortOperator = srcPortOperator.toLowerCase())) {
                                        srcPortOperator = "<";
                                    } else if ("gt".equals(srcPortOperator)) {
                                        srcPortOperator = ">";
                                    } else if ("eq".equals(srcPortOperator)) {
                                        srcPortOperator = "=";
                                    } else if ("neq".equals(srcPortOperator)) {
                                        srcPortOperator = "!=";
                                    }
                                    String srcPort = serviceObj.getSRCPort();
                                    srcPort = "srcPort" + srcPortOperator + srcPort;
                                    String string = valueToBeInDB = !bothTCPAndUDP ? serviceProtocol + " " + srcPort : srcPort;
                                }
                                if ((dstPortOperator = serviceObj.getDSTPortOperator()) == null) {
                                    if (serviceObj.getDSTPortRangeStr() != null) {
                                        String dstStartPort = serviceObj.getDstStartPort();
                                        String dstEndPort = serviceObj.getDstEndPort();
                                        String destVal = "dstPort=" + dstStartPort + " to " + dstEndPort;
                                        valueToBeInDB = !bothTCPAndUDP ? (valueToBeInDB != null ? valueToBeInDB + "," + destVal : serviceProtocol + " " + destVal) : (valueToBeInDB != null ? valueToBeInDB + "," + destVal : destVal);
                                    }
                                } else {
                                    if ("lt".equals(dstPortOperator = dstPortOperator.toLowerCase())) {
                                        dstPortOperator = "<";
                                    } else if ("gt".equals(dstPortOperator)) {
                                        dstPortOperator = ">";
                                    } else if ("eq".equals(dstPortOperator)) {
                                        dstPortOperator = "=";
                                    } else if ("neq".equals(dstPortOperator)) {
                                        dstPortOperator = "!=";
                                    }
                                    String dstPort = serviceObj.getDSTPort();
                                    dstPort = "dstPort" + dstPortOperator + dstPort;
                                    if (!bothTCPAndUDP) {
                                        valueToBeInDB = valueToBeInDB != null ? valueToBeInDB + "," + dstPort : serviceProtocol + " " + dstPort;
                                    } else {
                                        String string = valueToBeInDB = valueToBeInDB != null ? valueToBeInDB + "," + dstPort : dstPort;
                                    }
                                }
                                if (bothTCPAndUDP && valueToBeInDB != null) {
                                    valueToBeInDB = "TCP " + valueToBeInDB + " |_| UDP " + valueToBeInDB;
                                }
                                valueToBeInDB = valueToBeInDB == null && serviceProtocol != null ? serviceProtocol : valueToBeInDB;
                                serviceProtocol = serviceProtocol.replaceAll("TCP-UDP", "TCP,UDP");
                            } else if (serviceProtocol.indexOf("ICMP") > -1 || serviceProtocol.indexOf("ICMP6") > -1) {
                                isICMP = true;
                                icmpType = serviceObj.getICMPType();
                                valueToBeInDB = icmpType != null ? serviceProtocol + " " + (String)icmpType : "Any " + serviceProtocol;
                            } else {
                                valueToBeInDB = service != null ? serviceProtocol + " " + service : serviceProtocol;
                            }
                            valueToBeInDB = valueToBeInDB != null ? valueToBeInDB.trim() : null;
                        }
                        serviceObjRow.set("PROTOCOL", (Object)serviceProtocol);
                        serviceObjRow.set("VALUE_IN_CONFIG", valueToBeInDB);
                        serviceObjRow.set("COMMENTS", (Object)serviceObj.getComment());
                        serviceObjRow.set("OBJECT_TYPE", (Object)"Service");
                        serviceObjRow.set("TO_DISPLAY", valueToBeInDB);
                        if (isICMP) {
                            this.icmpObjInfoMap.put(objName, valueToBeInDB);
                        } else {
                            this.serviceObjInfoMap.put(objName, valueToBeInDB);
                        }
                        LOGGER.log(Level.FINE, " CiscoPolicyProcessor :::: Firewall Service Objects ROW is :::::::: {0} ", serviceObjRow);
                        icmpType = this.policyProcessorUtilityObject.firewallObjAutoGenKeyLock;
                        synchronized (icmpType) {
                            DataAccess.generateValues((Row)serviceObjRow);
                        }
                        doo.addRow(serviceObjRow);
                        if (serviceObj.isFWACreatedObject()) continue;
                        Object objID = serviceObjRow.get("OBJID");
                        Row objToChildOneToNMapRow = new Row("ObjectToChildOneToNMapping");
                        objToChildOneToNMapRow.set("RID", (Object)rID);
                        objToChildOneToNMapRow.set("OBJID", objID);
                        objToChildOneToNMapRow.set("NAME", (Object)serviceObj.getName());
                        objToChildOneToNMapRow.set("OBJECT_DETAILS", (Object)valueToBeInDB);
                        objToChildOneToNMapRow.set("LINK_NEEDED", (Object)"No");
                        Object object = this.policyProcessorUtilityObject.objOneToNMappingAutoGenKeyLock;
                        synchronized (object) {
                            DataAccess.generateValues((Row)objToChildOneToNMapRow);
                        }
                        doo.addRow(objToChildOneToNMapRow);
                        this.allObjects.add(serviceObj.getName());
                    }
                    break block41;
                }
                LOGGER.info("No Service Objects Found.....");
            }
            catch (Exception exp) {
                throw new Exception("Problem while populating Service Objects Details into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateICMPObjectsDataIntoDB(DataObject doo, Long rID, LinkedHashMap<String, ServiceObject> icmpObjMap, String deviceType, String resourceName) throws Exception {
        block7: {
            try {
                if (icmpObjMap != null && !icmpObjMap.isEmpty()) {
                    LOGGER.fine("populating FWA created temporary ICMP Objects.....");
                    String objName = null;
                    ServiceObject serviceObj = null;
                    for (Map.Entry<String, ServiceObject> entry : icmpObjMap.entrySet()) {
                        objName = entry.getKey();
                        serviceObj = entry.getValue();
                        String valueToBeInDB = "ICMP " + serviceObj.getICMPType();
                        Row serviceObjRow = new Row("FirewallObjects");
                        serviceObjRow.set("RID", (Object)rID);
                        serviceObjRow.set("NAME", (Object)serviceObj.getName());
                        serviceObjRow.set("PROTOCOL", (Object)"ICMP");
                        serviceObjRow.set("VALUE_IN_CONFIG", (Object)valueToBeInDB);
                        serviceObjRow.set("OBJECT_TYPE", (Object)"Service");
                        serviceObjRow.set("TO_DISPLAY", (Object)valueToBeInDB);
                        this.icmpObjInfoMap.put(objName, valueToBeInDB);
                        LOGGER.log(Level.FINE, " CiscoPolicyProcessor :::: Firewall ICMP Objects ROW is :::::::: {0} ", serviceObjRow);
                        Object object = this.policyProcessorUtilityObject.firewallObjAutoGenKeyLock;
                        synchronized (object) {
                            DataAccess.generateValues((Row)serviceObjRow);
                        }
                        doo.addRow(serviceObjRow);
                    }
                    break block7;
                }
                LOGGER.info("No ICMP Service Objects Found.....");
            }
            catch (Exception exp) {
                throw new Exception("Problem while populating Service Objects Details into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateObjectsGroup(DataObject doo, LinkedHashMap<String, FirewallGroupObject> objGroupMap, Long rID, String deviceType, String resourceName, String objectGroupType) throws Exception {
        block24: {
            String objName = "";
            try {
                LOGGER.fine("populating " + objectGroupType + " Objects Groups.....");
                if (objGroupMap == null || objGroupMap.isEmpty()) break block24;
                for (Map.Entry<String, FirewallGroupObject> entry : objGroupMap.entrySet()) {
                    this.unResolvedObjectsSet.clear();
                    objName = entry.getKey();
                    FirewallGroupObject groupObj = entry.getValue();
                    String members = groupObj.getMembers();
                    String objGroupType = groupObj.getType();
                    String objGroupName = groupObj.getName();
                    String[] results = null;
                    if (members != null) {
                        results = this.getMembersRelatedInfoForDB(members, rID, objGroupType);
                        if (!this.unResolvedObjectsSet.isEmpty()) {
                            HashSet toMemorize = (HashSet)this.unResolvedObjectsSet.clone();
                            toMemorize.add(objName);
                            this.objGroupUnResolvedMembers.put(objName, toMemorize);
                        }
                    }
                    String memberDetails = null;
                    String memberSubNetworkDetails = null;
                    String memberSubnetMaskDetails = null;
                    String memberIPRangeDetails = null;
                    String memberIDDetails = null;
                    if (results != null) {
                        members = results[0];
                        memberDetails = results[1];
                        if (objGroupType.equals("Network")) {
                            memberSubNetworkDetails = results[2];
                            memberSubnetMaskDetails = results[3];
                            memberIPRangeDetails = results[4];
                            memberIDDetails = results[5];
                            ArrayList<String> netObjGroupMemberDetails = new ArrayList<String>();
                            netObjGroupMemberDetails.add(memberSubNetworkDetails);
                            netObjGroupMemberDetails.add(memberSubnetMaskDetails);
                            netObjGroupMemberDetails.add(memberIPRangeDetails);
                            netObjGroupMemberDetails.add(memberIDDetails);
                            this.netObjGroupMemberDetailsMap.put(objName, netObjGroupMemberDetails);
                        }
                    }
                    Row firewallObjRow = new Row("FirewallObjects");
                    firewallObjRow.set("RID", (Object)rID);
                    firewallObjRow.set("NAME", (Object)objGroupName);
                    if ("Network".equals(objectGroupType)) {
                        firewallObjRow.set("VALUE_IN_CONFIG", (Object)members);
                        firewallObjRow.set("SUBNET", (Object)memberSubNetworkDetails);
                        firewallObjRow.set("SUBNET_MASK", (Object)memberSubnetMaskDetails);
                        firewallObjRow.set("IP_RANGE", (Object)memberIPRangeDetails);
                        firewallObjRow.set("IPRANGE_ID", (Object)memberIDDetails);
                        firewallObjRow.set("OBJECT_TYPE", (Object)"Network");
                        firewallObjRow.set("COMMENTS", (Object)groupObj.getComment());
                        firewallObjRow.set("TO_DISPLAY", (Object)memberDetails);
                        this.netObjInfoMap.put(objGroupName, memberDetails);
                    } else if ("Protocol".equals(objectGroupType)) {
                        firewallObjRow.set("VALUE_IN_CONFIG", (Object)members);
                        firewallObjRow.set("COMMENTS", (Object)groupObj.getComment());
                        firewallObjRow.set("OBJECT_TYPE", (Object)"Protocol");
                        firewallObjRow.set("TO_DISPLAY", (Object)memberDetails);
                        this.protocolObjInfoMap.put(objGroupName, memberDetails);
                    } else if ("Service".equals(objectGroupType)) {
                        firewallObjRow.set("VALUE_IN_CONFIG", (Object)members);
                        firewallObjRow.set("COMMENTS", (Object)groupObj.getComment());
                        firewallObjRow.set("OBJECT_TYPE", (Object)"Service");
                        firewallObjRow.set("TO_DISPLAY", (Object)memberDetails);
                        this.serviceObjInfoMap.put(objGroupName, memberDetails);
                    } else if ("ICMP".equals(objectGroupType)) {
                        firewallObjRow.set("VALUE_IN_CONFIG", (Object)members);
                        firewallObjRow.set("COMMENTS", (Object)groupObj.getComment());
                        firewallObjRow.set("OBJECT_TYPE", (Object)"ICMP");
                        firewallObjRow.set("TO_DISPLAY", (Object)memberDetails);
                        this.icmpObjInfoMap.put(objGroupName, memberDetails);
                    }
                    LOGGER.log(Level.FINE, " CiscoPolicyProcessor :::: FirewallObjectsGroup ROW is :::::::: {0} ", firewallObjRow);
                    Object object = this.policyProcessorUtilityObject.firewallObjAutoGenKeyLock;
                    synchronized (object) {
                        DataAccess.generateValues((Row)firewallObjRow);
                    }
                    doo.addRow(firewallObjRow);
                    String[] ObjGrps = null;
                    int objGrpLen = 0;
                    if (members != null) {
                        ObjGrps = members.split("<br>");
                        objGrpLen = ObjGrps.length;
                    }
                    Object objID = firewallObjRow.get("OBJID");
                    String objElement = null;
                    for (int k = 0; k < objGrpLen; ++k) {
                        objElement = ObjGrps[k];
                        Row objToChildOneToNMapRow = new Row("ObjectToChildOneToNMapping");
                        objToChildOneToNMapRow.set("RID", (Object)rID);
                        objToChildOneToNMapRow.set("OBJID", objID);
                        objToChildOneToNMapRow.set("NAME", (Object)objGroupName);
                        objToChildOneToNMapRow.set("OBJECT_DETAILS", (Object)objElement);
                        if (objGroupMap.containsKey(objElement)) {
                            objToChildOneToNMapRow.set("LINK_NEEDED", (Object)"Yes");
                        } else {
                            objToChildOneToNMapRow.set("LINK_NEEDED", (Object)"No");
                        }
                        Object object2 = this.policyProcessorUtilityObject.objOneToNMappingAutoGenKeyLock;
                        synchronized (object2) {
                            DataAccess.generateValues((Row)objToChildOneToNMapRow);
                        }
                        doo.addRow(objToChildOneToNMapRow);
                    }
                    this.allObjects.add(objName);
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while populating " + objectGroupType + " Objects Groups Details with group name as::" + objName + " into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
            }
        }
    }

    private String[] getMembersRelatedInfoForDB(String members, Long rID, String objGroupType) throws Exception {
        String[] results = new String[6];
        try {
            StringBuilder memberBuffer = new StringBuilder();
            StringBuilder memberDetailsBuffer = new StringBuilder();
            StringBuilder memberSubNetworkDetailsBuffer = new StringBuilder();
            StringBuilder memberSubNetMaskDetailsBuffer = new StringBuilder();
            StringBuilder memberIPRangeDetailsBuffer = new StringBuilder();
            StringBuilder memberIPIDDetailsBuffer = new StringBuilder();
            String[] membersArray = null;
            membersArray = members.indexOf(",") > -1 ? members.split(",") : new String[]{members};
            int memberCount = membersArray.length;
            String member = null;
            String value = null;
            String temp = null;
            int length = 0;
            boolean fwaCreatedObject = false;
            boolean isServiceObj = false;
            for (int i = 0; i < memberCount; ++i) {
                String[] networkObjMetaData;
                fwaCreatedObject = false;
                member = membersArray[i];
                if ((member = member.trim()) == null) continue;
                Matcher mat = fwaCustomObjNameExractPattern.matcher(member);
                if (mat.find()) {
                    memberBuffer.append(mat.group(1));
                    fwaCreatedObject = true;
                } else {
                    memberBuffer.append(member);
                }
                if (!fwaCreatedObject && this.allObjects.contains(member)) {
                    this.usedObjects.add(member);
                }
                if (member.equalsIgnoreCase("Any") || member.equalsIgnoreCase("All")) {
                    value = member;
                } else {
                    HashMap<String, String> objInfoMap = null;
                    if ("Network".equals(objGroupType)) {
                        objInfoMap = this.netObjInfoMap;
                    } else if ("Protocol".equals(objGroupType)) {
                        objInfoMap = this.protocolObjInfoMap;
                    } else if ("Service".equals(objGroupType)) {
                        isServiceObj = true;
                        objInfoMap = this.serviceObjInfoMap;
                    } else if ("ICMP".equals(objGroupType)) {
                        objInfoMap = this.icmpObjInfoMap;
                    }
                    value = objInfoMap.get(member);
                    if (value == null) {
                        int protoIndex;
                        if (isServiceObj) {
                            value = this.icmpObjInfoMap.get(member);
                        }
                        if (value == null && (protoIndex = member.indexOf("(")) > 0) {
                            String objNameHead = member.substring(0, protoIndex);
                            value = objInfoMap.get(objNameHead);
                        }
                    }
                }
                if (value != null && value.indexOf("<br>") > 0) {
                    temp = member + "(Group): ";
                    memberDetailsBuffer.append(temp);
                    length = temp.length();
                    String spaceString = "";
                    for (int k = 0; k < length; ++k) {
                        spaceString = spaceString + " ";
                    }
                    spaceString = spaceString.substring(3);
                    String[] valArray = value.split("<br>");
                    int valLength = valArray.length;
                    for (int j = 0; j < valLength; ++j) {
                        temp = valArray[j];
                        memberDetailsBuffer.append(temp);
                        if (j >= valLength - 1) continue;
                        memberDetailsBuffer.append("<br>");
                        memberDetailsBuffer.append(spaceString);
                    }
                } else if (!member.equals(value) && value != null) {
                    if (fwaCreatedObject) {
                        memberDetailsBuffer.append(value);
                    } else {
                        memberDetailsBuffer.append(member);
                        memberDetailsBuffer.append("(");
                        memberDetailsBuffer.append(value);
                        memberDetailsBuffer.append(")");
                    }
                } else {
                    memberDetailsBuffer.append(member);
                }
                if (objGroupType.equals("Network") && (networkObjMetaData = this.getNetworkSpecificValuesFromObjectsTable(member, rID, objGroupType)) != null) {
                    temp = networkObjMetaData[0];
                    memberSubNetworkDetailsBuffer.append(temp);
                    memberSubNetworkDetailsBuffer.append(",");
                    temp = networkObjMetaData[1];
                    memberSubNetMaskDetailsBuffer.append(temp);
                    memberSubNetMaskDetailsBuffer.append(",");
                    temp = networkObjMetaData[2];
                    if (temp != null && !"null".equals(temp)) {
                        memberIPRangeDetailsBuffer.append(temp);
                        memberIPRangeDetailsBuffer.append(",");
                    }
                    if ((temp = networkObjMetaData[3]) != null && !"null".equals(temp) && !"".equals(temp.trim())) {
                        memberIPIDDetailsBuffer.append(temp);
                        memberIPIDDetailsBuffer.append(",");
                    } else if (!fwaCreatedObject) {
                        this.unResolvedObjectsSet.add(member);
                    }
                }
                memberBuffer.append("<br>");
                memberDetailsBuffer.append("<br>");
            }
            results[0] = this.policyProcessorUtilityObject.removeLastDelimeter(memberBuffer, "<br>");
            results[1] = this.policyProcessorUtilityObject.removeLastDelimeter(memberDetailsBuffer, "<br>");
            if (objGroupType.equals("Network")) {
                results[2] = this.policyProcessorUtilityObject.removeLastDelimeter(memberSubNetworkDetailsBuffer, ",");
                results[3] = this.policyProcessorUtilityObject.removeLastDelimeter(memberSubNetMaskDetailsBuffer, ",");
                results[4] = this.policyProcessorUtilityObject.removeLastDelimeter(memberIPRangeDetailsBuffer, ",");
                results[5] = this.policyProcessorUtilityObject.removeLastDelimeter(memberIPIDDetailsBuffer, ",");
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            throw ee;
        }
        return results;
    }

    private String[] getObjectDetails(String objName, Long rID, String objGroupType) throws Exception {
        String[] results = new String[6];
        try {
            StringBuffer memberBuffer = new StringBuffer();
            StringBuffer memberDetailsBuffer = new StringBuffer();
            StringBuffer memberSubNetworkDetailsBuffer = new StringBuffer();
            StringBuffer memberSubNetMaskDetailsBuffer = new StringBuffer();
            StringBuffer memberIPRangeDetailsBuffer = new StringBuffer();
            StringBuffer memberIPIDDetailsBuffer = new StringBuffer();
            boolean fwaCreatedObject = false;
            String member = objName.trim();
            String value = null;
            if (member != null) {
                Matcher mat = fwaCustomObjNameExractPattern.matcher(member);
                if (mat.find()) {
                    memberBuffer.append(mat.group(1));
                    fwaCreatedObject = true;
                } else {
                    memberBuffer.append(member);
                }
                if (this.allObjects.contains(member)) {
                    this.usedObjects.add(member);
                }
                if (member.equalsIgnoreCase("Any") || member.equalsIgnoreCase("All")) {
                    value = member;
                } else {
                    int protoIndex;
                    HashMap<String, String> objInfoMap = null;
                    if ("Network".equals(objGroupType)) {
                        objInfoMap = this.netObjInfoMap;
                    } else if ("Protocol".equals(objGroupType)) {
                        objInfoMap = this.protocolObjInfoMap;
                    } else if ("Service".equals(objGroupType)) {
                        objInfoMap = this.serviceObjInfoMap;
                    } else if ("ICMP".equals(objGroupType)) {
                        objInfoMap = this.icmpObjInfoMap;
                    }
                    value = objInfoMap.get(member);
                    if (value == null && (protoIndex = member.indexOf("(")) > 0) {
                        String objNameHead = member.substring(0, protoIndex);
                        value = objInfoMap.get(objNameHead);
                    }
                }
                if (value != null) {
                    memberDetailsBuffer.append(value);
                } else {
                    memberDetailsBuffer.append(member);
                }
                String temp = null;
                if (objGroupType.equals("Network")) {
                    String[] networkObjMetaData = this.getNetworkSpecificValuesFromObjectsTable(member, rID, objGroupType);
                    if (this.objGroupUnResolvedMembers.containsKey(member)) {
                        this.unResolvedObjectsSet.addAll((Collection<String>)this.objGroupUnResolvedMembers.get(member));
                        if (!fwaCreatedObject) {
                            this.unResolvedObjectsSet.add(member);
                        }
                    }
                    if (networkObjMetaData != null) {
                        temp = networkObjMetaData[0];
                        memberSubNetworkDetailsBuffer.append(temp);
                        temp = networkObjMetaData[1];
                        memberSubNetMaskDetailsBuffer.append(temp);
                        temp = networkObjMetaData[2];
                        memberIPRangeDetailsBuffer.append(temp);
                        temp = networkObjMetaData[3];
                        if ((temp == null || "null".equals(temp) || "".equals(temp.trim())) && !fwaCreatedObject) {
                            this.unResolvedObjectsSet.add(member);
                        } else {
                            memberIPIDDetailsBuffer.append(temp);
                        }
                    }
                }
            }
            results[0] = memberBuffer.toString();
            results[1] = memberDetailsBuffer.toString();
            if (objGroupType.equals("Network")) {
                results[2] = memberSubNetworkDetailsBuffer.toString();
                results[3] = memberSubNetMaskDetailsBuffer.toString();
                results[4] = memberIPRangeDetailsBuffer.toString();
                results[5] = memberIPIDDetailsBuffer.toString();
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            throw ee;
        }
        return results;
    }

    private String[] getNetworkSpecificValuesFromObjectsTable(String objName, Long rID, String objType) throws Exception {
        long endTime = 0L;
        String[] netObjMetaData = null;
        try {
            NetworkObject netObj = this.netObjMap.get(objName);
            if (netObj != null) {
                netObjMetaData = new String[]{netObj.getSubnet(), netObj.getSubnetMask(), netObj.getIPRange(), netObj.getIPRangeID()};
                return netObjMetaData;
            }
            ArrayList<String> tempObjGrpDetails = this.netObjGroupMemberDetailsMap.get(objName);
            if (tempObjGrpDetails != null) {
                netObjMetaData = new String[]{tempObjGrpDetails.get(0), tempObjGrpDetails.get(1), tempObjGrpDetails.get(2), tempObjGrpDetails.get(3)};
                return netObjMetaData;
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    private void groupStaticRoutingTable() {
        for (String interfaceName : this.staticRouteTable.keySet()) {
            String groupedInterfaceRoutes = this.policyProcessorUtilityObject.toGroup(this.staticRouteTable.get(interfaceName));
            this.staticRouteTable.put(interfaceName, groupedInterfaceRoutes);
        }
    }

    private String getInterfaceUsingRoutingTables(String appliedOn, String ipID) {
        try {
            if (ipID != null && !"null".equals(ipID)) {
                long lowerIP = -1L;
                long higherIP = -1L;
                if (ipID.indexOf("-") > 0) {
                    String[] ipIDRange = ipID.split("-");
                    lowerIP = Long.parseLong(ipIDRange[0]);
                    higherIP = Long.parseLong(ipIDRange[1]);
                } else {
                    higherIP = lowerIP = Long.parseLong(ipID);
                }
                String interfaceToRoute = null;
                boolean firstTime = true;
                long prefixLength = -1L;
                long prevPrefixLength = -1L;
                for (String interfaceName : this.staticRouteTable.keySet()) {
                    String[] routeArray;
                    if (interfaceName.equals(appliedOn)) continue;
                    String routeInfo = this.staticRouteTable.get(interfaceName);
                    for (String route : routeArray = routeInfo.split(",")) {
                        String[] routeRange = route.split("-");
                        long routeIPMin = Long.parseLong(routeRange[0]);
                        long routeIPMax = Long.parseLong(routeRange[1]);
                        if (routeIPMin >= lowerIP && routeIPMin <= higherIP) {
                            prefixLength = routeIPMax - routeIPMin;
                            if (firstTime) {
                                prevPrefixLength = prefixLength;
                                interfaceToRoute = interfaceName;
                                firstTime = false;
                                continue;
                            }
                            if (prefixLength >= prevPrefixLength) continue;
                            prevPrefixLength = prefixLength;
                            interfaceToRoute = interfaceName;
                            continue;
                        }
                        if (routeIPMax >= lowerIP && routeIPMax <= higherIP) {
                            prefixLength = routeIPMax - routeIPMin;
                            if (firstTime) {
                                prevPrefixLength = prefixLength;
                                interfaceToRoute = interfaceName;
                                firstTime = false;
                                continue;
                            }
                            if (prefixLength >= prevPrefixLength) continue;
                            prevPrefixLength = prefixLength;
                            interfaceToRoute = interfaceName;
                            continue;
                        }
                        if (lowerIP >= routeIPMin && lowerIP <= routeIPMax) {
                            prefixLength = routeIPMax - routeIPMin;
                            if (firstTime) {
                                prevPrefixLength = prefixLength;
                                interfaceToRoute = interfaceName;
                                firstTime = false;
                                continue;
                            }
                            if (prefixLength >= prevPrefixLength) continue;
                            prevPrefixLength = prefixLength;
                            interfaceToRoute = interfaceName;
                            continue;
                        }
                        if (higherIP < routeIPMin || higherIP > routeIPMax) continue;
                        prefixLength = routeIPMax - routeIPMin;
                        if (firstTime) {
                            prevPrefixLength = prefixLength;
                            interfaceToRoute = interfaceName;
                            firstTime = false;
                            continue;
                        }
                        if (prefixLength >= prevPrefixLength) continue;
                        prevPrefixLength = prefixLength;
                        interfaceToRoute = interfaceName;
                    }
                }
                return interfaceToRoute;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return null;
    }

    private String getFromDefaultStaticRoute() {
        boolean firstTime = true;
        String defaultInterface = null;
        long minMetric = -1L;
        if (!this.defaultStaticRouteTable.isEmpty()) {
            long metric = -1L;
            Set<Map.Entry<String, Long>> entrySet = this.defaultStaticRouteTable.entrySet();
            for (Map.Entry<String, Long> entry : entrySet) {
                metric = entry.getValue();
                if (firstTime) {
                    minMetric = metric;
                    defaultInterface = entry.getKey();
                    firstTime = false;
                    continue;
                }
                if (metric >= minMetric) continue;
                minMetric = metric;
                defaultInterface = entry.getKey();
            }
        }
        return defaultInterface;
    }

    private String getInterfaceUsingPhysicalIP(String ipID) {
        try {
            for (String interfaceName : this.interfaceVsIPAddrMap.keySet()) {
                String interfaceNetwork = this.interfaceVsIPAddrMap.get(interfaceName);
                ArrayList<long[]> interfaceIPDetails = this.policyProcessorUtilityObject.getIPLongDetails(interfaceNetwork);
                if (!this.policyProcessorUtilityObject.isIPInRange(ipID, interfaceIPDetails)) continue;
                return interfaceName;
            }
        }
        catch (Exception ee) {
            LOGGER.log(Level.FINER, "getInterfaceUsingPhysicalIP::::Exception while getting interface using physical IP::" + this.resourceName);
            ee.printStackTrace();
        }
        return null;
    }

    private String convertIpIDToIP(String ipID) {
        if (ipID != null && !"null".equals(ipID)) {
            if (ipID.indexOf("-") > -1) {
                String[] ipIDArr = ipID.split("-");
                String lowerIP = IPRange.convertAddr((long)Long.parseLong(ipIDArr[0]));
                String higherIP = IPRange.convertAddr((long)Long.parseLong(ipIDArr[1]));
                return lowerIP + "-" + higherIP;
            }
            return IPRange.convertAddr((long)Long.parseLong(ipID));
        }
        return ipID;
    }

    private ArrayList<long[]> getIPLongDetailsList(String ipDetails) {
        ArrayList<long[]> list = new ArrayList<long[]>();
        if (ipDetails != null && !"".equals(ipDetails)) {
            String[] ipAdds = ipDetails.split(",");
            for (int i = 0; i < ipAdds.length; ++i) {
                String val = ipAdds[i];
                if (val.indexOf("-") <= -1) continue;
                String[] vals = val.split("-");
                long[] array = new long[]{Long.parseLong(vals[0]), Long.parseLong(vals[1])};
                list.add(array);
            }
        }
        return list;
    }

    private String extractPortInfo(String service, String detailedService, HashMap<String, HashSet<String>> protoVsSRCPortSet, HashMap<String, HashSet<String>> protoVsDSTPortSet, String resourceName, String deviceType, boolean ignoreConstruct, HashSet<String> protoSetFromService) throws Exception {
        protoVsSRCPortSet.clear();
        protoVsDSTPortSet.clear();
        try {
            if (detailedService != null && !"".equals(detailedService)) {
                String[] memberArray;
                int matchedpatternIndex = -1;
                ArrayList matcherInfo = null;
                Pattern portSplit = Pattern.compile("([^\\s]*)( to ([^.]*))?");
                for (String member : memberArray = detailedService.split("\n")) {
                    if ((member = member.trim()).indexOf("(") > 0) {
                        member = this.getDataFromBracket(member);
                    }
                    String[] protocolPortsArray = member.split("\\|_\\|");
                    ArrayList<String> protocolPortsList = new ArrayList<String>(Arrays.asList(protocolPortsArray));
                    for (String protocolPortData : protocolPortsList) {
                        matcherInfo = this.getTheMatchedPattern(protocolPortData = protocolPortData.trim());
                        if (matcherInfo != null) {
                            HashSet<String> tempDSTPortSet;
                            matchedpatternIndex = (Integer)matcherInfo.get(0);
                            Matcher mat = (Matcher)matcherInfo.get(1);
                            String protocol = mat.group(1).toUpperCase();
                            protocol = protocol.trim();
                            protoSetFromService.add(protocol);
                            String srcPortInfo = null;
                            String dstPortInfo = null;
                            if (matchedpatternIndex == 1) {
                                String portNumber;
                                Matcher m;
                                String srcPortOperator = mat.group(2);
                                srcPortInfo = mat.group(3);
                                String dstPortOperator = mat.group(4);
                                dstPortInfo = mat.group(5);
                                if (srcPortInfo != null && srcPortOperator != null) {
                                    HashSet<String> tempSRCPortSet;
                                    srcPortInfo = srcPortInfo.trim();
                                    srcPortOperator = srcPortOperator.trim();
                                    m = portSplit.matcher(srcPortInfo);
                                    m.find();
                                    srcPortInfo = !this.policyProcessorUtilityObject.isDigit(m.group(1)) ? (portNumber = this.getPortNumber(m.group(1), protocol)) : m.group(1);
                                    if (m.group(3) != null) {
                                        srcPortInfo = !this.policyProcessorUtilityObject.isDigit(m.group(3)) ? ((portNumber = this.getPortNumber(m.group(3), protocol)) != null ? srcPortInfo + "-" + portNumber : portNumber) : srcPortInfo + "-" + m.group(3);
                                    }
                                    if ((tempSRCPortSet = protoVsSRCPortSet.get(protocol)) == null) {
                                        tempSRCPortSet = new HashSet();
                                    }
                                    if (srcPortInfo != null) {
                                        if (srcPortOperator.equals("<")) {
                                            try {
                                                int srcPort = Integer.parseInt(srcPortInfo);
                                                srcPortInfo = "1-" + --srcPort;
                                            }
                                            catch (NumberFormatException nfe) {
                                                srcPortInfo = srcPortOperator + srcPortInfo;
                                            }
                                            tempSRCPortSet.add(srcPortInfo);
                                        } else if (srcPortOperator.equals(">")) {
                                            try {
                                                int srcPort = Integer.parseInt(srcPortInfo);
                                                srcPortInfo = ++srcPort + "-65535";
                                            }
                                            catch (NumberFormatException nfe) {
                                                srcPortInfo = srcPortOperator + srcPortInfo;
                                            }
                                            tempSRCPortSet.add(srcPortInfo);
                                        } else if (srcPortOperator.equals("!=")) {
                                            try {
                                                int srcPort = Integer.parseInt(srcPortInfo);
                                                srcPortInfo = "1-" + --srcPort;
                                                tempSRCPortSet.add(srcPortInfo);
                                                srcPortInfo = (srcPort += 2) + "-65535";
                                                tempSRCPortSet.add(srcPortInfo);
                                            }
                                            catch (NumberFormatException nfe) {
                                                srcPortInfo = srcPortOperator + srcPortInfo;
                                                tempSRCPortSet.add(srcPortInfo);
                                            }
                                        } else {
                                            srcPortInfo = srcPortOperator.equals("=") ? srcPortInfo : srcPortOperator + srcPortInfo;
                                            tempSRCPortSet.add(srcPortInfo);
                                        }
                                    }
                                    protoVsSRCPortSet.put(protocol, tempSRCPortSet);
                                }
                                if (dstPortInfo == null || dstPortOperator == null) continue;
                                dstPortOperator = dstPortOperator.trim();
                                dstPortInfo = dstPortInfo.trim();
                                m = portSplit.matcher(dstPortInfo);
                                m.find();
                                dstPortInfo = !this.policyProcessorUtilityObject.isDigit(m.group(1)) ? (portNumber = this.getPortNumber(m.group(1), protocol)) : m.group(1);
                                if (m.group(3) != null) {
                                    dstPortInfo = !this.policyProcessorUtilityObject.isDigit(m.group(3)) ? ((portNumber = this.getPortNumber(m.group(3), protocol)) != null ? dstPortInfo + "-" + portNumber : portNumber) : dstPortInfo + "-" + m.group(3);
                                }
                                if ((tempDSTPortSet = protoVsDSTPortSet.get(protocol)) == null) {
                                    tempDSTPortSet = new HashSet();
                                }
                                if (dstPortInfo != null) {
                                    if (dstPortOperator.equals("<")) {
                                        try {
                                            int dstPort = Integer.parseInt(dstPortInfo);
                                            dstPortInfo = "1-" + --dstPort;
                                        }
                                        catch (NumberFormatException nfe) {
                                            dstPortInfo = dstPortOperator + dstPortInfo;
                                        }
                                        tempDSTPortSet.add(dstPortInfo);
                                    } else if (dstPortOperator.equals(">")) {
                                        try {
                                            int dstPort = Integer.parseInt(dstPortInfo);
                                            dstPortInfo = ++dstPort + "-65535";
                                        }
                                        catch (NumberFormatException nfe) {
                                            dstPortInfo = dstPortOperator + dstPortInfo;
                                        }
                                        tempDSTPortSet.add(dstPortInfo);
                                    } else if (dstPortOperator.equals("!=")) {
                                        try {
                                            int dstPort = Integer.parseInt(dstPortInfo);
                                            dstPortInfo = "1-" + --dstPort;
                                            tempDSTPortSet.add(dstPortInfo);
                                            dstPortInfo = (dstPort += 2) + "-65535";
                                            tempDSTPortSet.add(dstPortInfo);
                                        }
                                        catch (NumberFormatException nfe) {
                                            dstPortInfo = dstPortOperator + dstPortInfo;
                                            tempDSTPortSet.add(dstPortInfo);
                                        }
                                    } else {
                                        dstPortInfo = dstPortOperator.equals("=") ? dstPortInfo : dstPortOperator + dstPortInfo;
                                        tempDSTPortSet.add(dstPortInfo);
                                    }
                                }
                                protoVsDSTPortSet.put(protocol, tempDSTPortSet);
                                continue;
                            }
                            if (matchedpatternIndex == 2) {
                                String icmpType = mat.group(2);
                                String icmpCode = mat.group(3);
                                dstPortInfo = icmpType.trim();
                                dstPortInfo = this.getPortNumber(dstPortInfo, "ICMP");
                                tempDSTPortSet = protoVsDSTPortSet.get(protocol);
                                if (tempDSTPortSet == null) {
                                    tempDSTPortSet = new HashSet();
                                }
                                tempDSTPortSet.add(dstPortInfo);
                                protoVsDSTPortSet.put(protocol, tempDSTPortSet);
                                continue;
                            }
                            if (matchedpatternIndex == 3) {
                                tempDSTPortSet = protoVsDSTPortSet.get(protocol);
                                if (tempDSTPortSet == null) {
                                    tempDSTPortSet = new HashSet();
                                }
                                tempDSTPortSet.add("Any");
                                protoVsDSTPortSet.put(protocol, tempDSTPortSet);
                                continue;
                            }
                            if (matchedpatternIndex != 4) continue;
                            String protoService = mat.group(2);
                            tempDSTPortSet = protoVsDSTPortSet.get(protocol);
                            if (tempDSTPortSet == null) {
                                tempDSTPortSet = new HashSet();
                            }
                            if (protoService != null) {
                                protoService = protoService.trim();
                                tempDSTPortSet.add(dstPortInfo);
                            }
                            protoVsDSTPortSet.put(protocol, tempDSTPortSet);
                            continue;
                        }
                        throw new Exception("Problem while matching the portExtract Patterns for the line:::" + protocolPortData + " of service object::: " + service + " that have the data as:::" + detailedService + " for the firewall::: " + resourceName + " of Cisco Vendor..");
                    }
                }
                if (!ignoreConstruct) {
                    HashSet<String> dstPortSet = null;
                    HashSet<String> srcPortSet = null;
                    String completePortInfo = null;
                    StringBuilder servicePortBuilder = new StringBuilder();
                    StringBuilder protocolPortBuilder = new StringBuilder();
                    String tempValue = null;
                    for (String proto : protoVsDSTPortSet.keySet()) {
                        dstPortSet = protoVsDSTPortSet.get(proto);
                        srcPortSet = protoVsSRCPortSet.remove(proto);
                        completePortInfo = this.constructProtocolSpecificPorts(dstPortSet, srcPortSet, protocolPortBuilder, tempValue);
                        servicePortBuilder.append(proto);
                        servicePortBuilder.append(":");
                        servicePortBuilder.append(completePortInfo);
                        servicePortBuilder.append("&&");
                    }
                    for (String proto : protoVsSRCPortSet.keySet()) {
                        srcPortSet = protoVsSRCPortSet.get(proto);
                        completePortInfo = this.constructProtocolSpecificPorts(null, srcPortSet, protocolPortBuilder, tempValue);
                        servicePortBuilder.append(proto);
                        servicePortBuilder.append(":");
                        servicePortBuilder.append(completePortInfo);
                        servicePortBuilder.append("&&");
                    }
                    return this.policyProcessorUtilityObject.removeLastDelimeter(servicePortBuilder, "&&");
                }
                return "";
            }
            this.hasUnknownPorts = true;
            this.unResolvedObjectsSet.add(service);
            this.unknownPorts.add(service);
            return "";
        }
        catch (Exception ee) {
            throw new Exception("Problem while matching the portExtract Patterns for the service object " + service + " having the data:: " + detailedService + " for the firewall::: " + resourceName + " of " + deviceType + " Vendor..", ee);
        }
    }

    private String constructProtocolSpecificPorts(HashSet<String> dstPortSet, HashSet<String> srcPortSet, StringBuilder protocolPortBuilder, String tempValue) throws Exception {
        Iterator<String> itr;
        protocolPortBuilder.setLength(0);
        if (dstPortSet != null && !dstPortSet.isEmpty()) {
            protocolPortBuilder.append("dstPort=");
            itr = dstPortSet.iterator();
            while (itr.hasNext()) {
                protocolPortBuilder.append(itr.next());
                protocolPortBuilder.append(",");
            }
            tempValue = this.policyProcessorUtilityObject.removeLastChar(protocolPortBuilder, protocolPortBuilder.length());
            protocolPortBuilder.setLength(0);
            protocolPortBuilder.append(tempValue);
            protocolPortBuilder.append("#");
        } else {
            protocolPortBuilder.append("dstPort=Any#");
        }
        if (srcPortSet != null && !srcPortSet.isEmpty()) {
            protocolPortBuilder.append("srcPort=");
            itr = srcPortSet.iterator();
            while (itr.hasNext()) {
                protocolPortBuilder.append(itr.next());
                protocolPortBuilder.append(",");
            }
            tempValue = this.policyProcessorUtilityObject.removeLastChar(protocolPortBuilder, protocolPortBuilder.length());
            protocolPortBuilder.setLength(0);
            protocolPortBuilder.append(tempValue);
            protocolPortBuilder.append("#");
        } else {
            protocolPortBuilder.append("srcPort=Any#");
        }
        return protocolPortBuilder.toString();
    }

    private String getPortNumber(String service, String protocol) {
        String upperService = service.toUpperCase();
        if ("ICMP".equals(protocol)) {
            String icmpTypeNumber = this.policyProcessorUtilityObject.getICMPType(upperService);
            if (icmpTypeNumber != null) {
                return icmpTypeNumber;
            }
        } else if (this.serviceToPortMap.containsKey(upperService)) {
            String toReturn = this.serviceToPortMap.get(upperService);
            HashMap<String, HashSet<String>> tt1 = new HashMap<String, HashSet<String>>();
            HashMap<String, HashSet<String>> tt2 = new HashMap<String, HashSet<String>>();
            HashSet<String> tt3 = new HashSet<String>();
            try {
                this.extractPortInfo(upperService, toReturn, tt1, tt2, this.resourceName, "Cisco", true, tt3);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (String proto : tt3) {
                if (!proto.equals(protocol)) continue;
                String portNumber = "";
                try {
                    portNumber = this.policyProcessorUtilityObject.convertHashSetToString(tt2.get(proto));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return portNumber;
            }
        }
        this.hasUnknownPorts = true;
        this.unResolvedObjectsSet.add(service);
        this.unknownPorts.add(service);
        return service;
    }

    private String getDataFromBracket(String member) throws Exception {
        Matcher mat = bracketExtractPattern.matcher(member);
        if (mat.matches()) {
            member = mat.group(1);
        }
        return member;
    }

    private ArrayList getTheMatchedPattern(String protocolPortData) {
        ArrayList<Object> matcherInfo = new ArrayList<Object>();
        int i = 1;
        for (Pattern pat : this.portExtractPatternList) {
            Matcher mat = pat.matcher(protocolPortData);
            if (mat.find()) {
                matcherInfo.add(i);
                matcherInfo.add(mat);
                return matcherInfo;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void cleanupMemory() {
        this.currentNetworkObject = null;
        this.currentServiceObject = null;
        this.currentInterfaceDetailsObject = null;
        this.currentGroupObject = null;
        this.rID = null;
        this.versionNo = null;
        this.netObjMap = null;
        this.serviceObjMap = null;
        this.icmpObjMap = null;
        this.policyObjMap = null;
        this.netObjGroupMemberDetailsMap = null;
        this.netObjInfoMap = null;
        this.serviceObjInfoMap = null;
        this.protocolObjInfoMap = null;
        this.icmpObjInfoMap = null;
        this.netObjList = null;
        this.serviceObjList = null;
        this.netObjGroupMap = null;
        this.protoObjGroupMap = null;
        this.serviceObjGroupMap = null;
        this.icmpObjGroupMap = null;
        this.allObjects = null;
        this.usedObjects = null;
        this.nameObjMap = null;
        this.policyNameVsIDMap = null;
        this.interfaceDetailsObjMap = null;
        this.aclInterfaceConfigMap = null;
        this.interfaceAliasVsOriginalNamesMap = null;
        this.interfaceVsZoneMap = null;
        this.interfaceVsIPAddrMap = null;
        this.interfaceVsSecurityLevel = null;
        this.allInterfaces = null;
        this.usedInterfaces = null;
        this.wanInterfaceList = null;
        this.staticNATConfig = null;
        this.dynamicNATConfig = null;
        this.dynamicGlobalNATConfig = null;
        this.dynamicLocalNATConfig = null;
        this.dynamicOutsideNATLocalConfig = null;
        this.natIPPool = null;
        this.staticRouteTable = null;
        this.defaultStaticRouteTable = null;
        this.netObjGroupMemberDetailsMap = null;
        this.decryptionObj = null;
        this.fpf = null;
        this.portExtractPatternList = null;
        this.portOperatorMap = null;
        this.serviceToPortMap = null;
        this.unFoundSrcInterfaceSet = null;
        this.unFoundDstInterfaceSet = null;
        this.nonAppliedPolicySet = null;
        this.unknownPorts = null;
        this.vpnACLs = null;
        this.siteToSiteVPNACLs = null;
        this.groupPolicyVsACLMap = null;
        this.ipPoolMap = null;
        this.vpnIPPoolList = null;
        this.vpnIPPoolDetails = null;
        this.unIdentifiedIPList = null;
        this.unIdentifiedIPIDList = null;
        this.unResolvedObjectsSet = null;
        this.objGroupUnResolvedMembers = null;
    }
}

