/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.rules;

import com.adventnet.fa.server.rules.FWAAuthenticationProvider;
import com.maverick.events.EventListener;
import com.maverick.events.defaultlogger.J2SSHLoggingListener;
import com.maverick.nio.Daemon;
import com.maverick.nio.DaemonContext;
import com.maverick.nio.LicenseManager;
import com.maverick.nio.ProtocolContext;
import com.maverick.ssh.SshConnector;
import com.maverick.ssh.SshException;
import com.maverick.ssh.components.ComponentFactory;
import com.maverick.ssh.components.ComponentManager;
import com.maverick.sshd.SshContext;
import com.maverick.sshd.components.ServerComponentManager;
import com.maverick.sshd.platform.AuthenticationProvider;
import com.maverick.sshd.platform.NativeAuthenticationProvider;
import com.maverick.sshd.scp.ScpCommand;
import com.maverick.sshd.vfs.VirtualFileSystem;
import com.sshtools.publickey.InvalidPassphraseException;
import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.log4j.PropertyConfigurator;

public class FWASSHD
extends Daemon {
    private static Logger logger = Logger.getLogger(FWASSHD.class.getName());
    private static FWASSHD instance = null;
    public static boolean scpServerRunningStatus = false;
    private static String localIPAddress = null;
    private static boolean debug = false;
    String cipher = null;
    Class cipherClass;
    private int authmethods = 0;

    public void addCipher(SshContext context) throws IOException, SshException {
        if (this.cipherClass != null) {
            logger.fine(" ######### context.supportedCiphers().list()" + context.supportedCiphersSC().list(""));
            context.supportedCiphersSC().add(this.cipher, this.cipherClass);
            context.supportedCiphersCS().add(this.cipher, this.cipherClass);
        }
        if (this.cipher != null) {
            context.setPreferredCipherCS(this.cipher);
            logger.fine("context.supportedCiphersSC().list()" + context.supportedCiphersSC().list(""));
            logger.fine("context.supportedCiphersCS().list()" + context.supportedCiphersCS().list(""));
            context.setPreferredCipherSC(this.cipher);
            logger.fine("####### context.supportedCiphers().list()" + context.supportedCiphersSC().list(""));
        }
    }

    private void manageCiphers() {
        String userConfiguredBlockCiphersStr = System.getProperty("blocked_ciphers", "");
        String userConfiguredAllowedCiphersStr = System.getProperty("allowed_ciphers", "");
        List<String> blockedCiphersList = Arrays.asList(userConfiguredBlockCiphersStr.split(","));
        List<String> allowedCiphersList = userConfiguredAllowedCiphersStr.length() > 0 ? Arrays.asList(userConfiguredAllowedCiphersStr.split(",")) : null;
        ArrayList<ComponentFactory> componentFactoryList = new ArrayList<ComponentFactory>();
        ServerComponentManager sshdComponentManager = ServerComponentManager.getInstance();
        componentFactoryList.add(sshdComponentManager.supportedSsh2CiphersSC());
        componentFactoryList.add(sshdComponentManager.supportedSsh2CiphersCS());
        ComponentManager sshClientComponentManager = ComponentManager.getInstance();
        componentFactoryList.add(sshClientComponentManager.supportedSsh2CiphersCS());
        componentFactoryList.add(sshClientComponentManager.supportedSsh2CiphersSC());
        for (int listIndex = 0; listIndex < componentFactoryList.size(); ++listIndex) {
            ComponentFactory componentFactory = (ComponentFactory)componentFactoryList.get(listIndex);
            logger.fine("Before processing Component Factory " + componentFactory + " CipherList " + componentFactory.list(""));
            String[] totalCiphersArr = componentFactory.list("").split(",");
            for (int i = 0; i < totalCiphersArr.length; ++i) {
                if (!blockedCiphersList.contains(totalCiphersArr[i]) && (allowedCiphersList == null || allowedCiphersList.contains(totalCiphersArr[i]))) continue;
                componentFactory.remove(totalCiphersArr[i]);
            }
            logger.fine("After processing Component Factory " + componentFactory + " CipherList " + componentFactory.list(""));
        }
    }

    public void setRequiredAuthenticationMethods(int methods) {
        this.authmethods = methods;
    }

    protected void configure(DaemonContext context) throws IOException {
        AuthenticationProvider authProv;
        logger.info("Configuring Example SSHD");
        SshContext sshContext = new SshContext((Daemon)this);
        try {
            this.addCipher(sshContext);
        }
        catch (SshException e) {
            logger.log(Level.SEVERE, "Exception in configure method ", e);
        }
        sshContext.setChannelLimit(1000);
        try {
            sshContext.loadOrGenerateHostKey(new File("./.ssh_host_rsa_key"), "ssh-rsa", 1024);
            sshContext.loadOrGenerateHostKey(new File("./.ssh_host_dsa_key"), "ssh-dss", 1024);
        }
        catch (SshException ex) {
        }
        catch (InvalidPassphraseException ex) {
            // empty catch block
        }
        String scpAdd = null;
        try {
            scpAdd = FWASSHD.getServerIPAddress();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        context.addListeningInterface(scpAdd, 22, (ProtocolContext)sshContext);
        sshContext.setBannerMessage("Entering into Firewall Analyzer SSHD");
        try {
            authProv = new AuthenticationProvider((NativeAuthenticationProvider)FWAAuthenticationProvider.class.newInstance(), sshContext);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
        sshContext.setAuthenticationProvider(authProv);
        sshContext.setFileSystemProvider(VirtualFileSystem.class);
        sshContext.setAsynchronousFileOperations(false);
        sshContext.setRemoteForwardingCancelKillsTunnels(true);
        String tftpHome = this.getHomeDirectory();
        System.setProperty("com.maverick.sshd.vfs.VFSRoot", tftpHome);
        sshContext.addCommand("scp", ScpCommand.class);
        context.setPermanentTransferThreads(1);
        sshContext.setSoftwareVersionComments("Firewall Analyzer SCP Server");
        sshContext.setSocketOptionKeepAlive(true);
        sshContext.setSocketOptionTcpNoDelay(true);
        sshContext.setSocketOptionReuseAddress(false);
        sshContext.setRequiredAuthenticationMethods(this.authmethods);
        try {
            sshContext.setMaximumConnections(4);
            sshContext.setAllowDeniedKEX(true);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception in setting parallel connection count", e);
        }
        logger.info("Configuration SSHD is complete");
    }

    public static void main(String[] args) throws Exception {
        debug = "true".equals(System.getProperty("FWA_CLI_DEBUG"));
        PropertyConfigurator.configure((String)"../server/conf/sshdlog4j.conf");
        if (debug) {
            logger.info("CLI Debug enabled, so attaching logging listener to maverick");
            SshConnector.addEventListener((EventListener)new J2SSHLoggingListener(false));
        }
        LicenseManager.addLicense((String)"----BEGIN 3SP LICENSE----\r\nProduct : Maverick SSHD\r\nLicensee: Zoho Corporation Private Limited\r\nComments: Renewal Feb 2015\r\nType    : OEM License\r\nCreated : 21-Oct-2014\r\n\r\n378720407449DBDBA600F3CF9CCEF4C859B43E53A2872776\r\n38A780C235394FD7E3827474A6E335EA84ED4F785D955C43\r\nD5F918F02D78B7D58E30F8BAAB28304144F6567E7C7D0339\r\nC817B589BBB11964AC498276CA349B2FC449C95A5EBA55C5\r\n4B8101A9AFC702B4800F76D75E687377AFE2049BBDCA703A\r\n27E278EC22608C136D4D7B4340425A0C3733621DC9795AE5\r\n----END 3SP LICENSE----\r\n");
        if (instance == null) {
            instance = new FWASSHD();
            try {
                instance.manageCiphers();
                instance.startup();
                logger.info("SSHD Server Version " + Daemon.getVersion());
                logger.info("SSHD Server started " + instance.isStarted());
                if (Boolean.valueOf(instance.isStarted()).booleanValue()) {
                    scpServerRunningStatus = true;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception in starting SCP Server", e);
            }
        }
    }

    public static FWASSHD getInstance() {
        return instance;
    }

    public String getHomeDirectory() {
        String rootDir = System.getProperty("server.dir") + File.separator + "tftp_files";
        return rootDir;
    }

    public static String getServerIPAddress() throws Exception {
        if (localIPAddress != null) {
            logger.log(Level.FINER, "FAServerUtil: LocalIPAddress ::::" + localIPAddress);
            return localIPAddress;
        }
        InetAddress[] addr = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
        for (int i = 0; i < addr.length; ++i) {
            if (addr[i].isLoopbackAddress() || !addr[i].isReachable(5000)) continue;
            localIPAddress = addr[i].getHostAddress();
            break;
        }
        if (localIPAddress != null) {
            logger.log(Level.FINER, "FAServerUtil: LocalIPAddress1 ::::" + localIPAddress);
            return localIPAddress;
        }
        logger.log(Level.FINER, "FAServerUtil: loopback address issue. trying to get IP address in other possible ways.");
        NetworkInterface nic = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface nic1 = en.nextElement();
            Enumeration<InetAddress> en1 = nic1.getInetAddresses();
            while (en1.hasMoreElements()) {
                InetAddress inet1 = en1.nextElement();
                if (!(inet1 instanceof Inet4Address) || inet1.isLoopbackAddress()) continue;
                localIPAddress = inet1.getHostAddress();
                logger.log(Level.FINER, "FAServerUtil: LocalIPAddress2 ::::" + localIPAddress);
                return localIPAddress;
            }
        }
        throw new Exception("No proper IPAddress is returned from the system");
    }
}

