/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.rules;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.fa.server.FWAEnumConstants;
import com.adventnet.fa.server.rules.FirewallGroupObject;
import com.adventnet.fa.server.rules.FirewallPolicyFormat;
import com.adventnet.fa.server.rules.FirewallPolicyParserRule;
import com.adventnet.fa.server.rules.FirewallPolicyParserRuleAttribute;
import com.adventnet.fa.server.rules.FwConfigMgmt;
import com.adventnet.fa.server.rules.InterfaceDetails;
import com.adventnet.fa.server.rules.NetworkObject;
import com.adventnet.fa.server.rules.PolicyProcessor;
import com.adventnet.fa.server.rules.PolicyProcessorUtilityClass;
import com.adventnet.fa.server.rules.RuleObject;
import com.adventnet.fa.server.rules.ServiceObject;
import com.adventnet.fa.server.rules.StaticNATObject;
import com.adventnet.la.util.EncryptionAPI;
import com.adventnet.la.util.IPRange;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FortiGatePolicyProcessor
implements PolicyProcessor {
    ResourceBundle bundle = ProductBundle.getInstance().getBundle();
    private NetworkObject currentNetworkObject = null;
    private StaticNATObject currentStaticNATObject = null;
    private ServiceObject currentServiceObject = null;
    private RuleObject currentRuleObject = null;
    private InterfaceDetails currentInterfaceDetailsObject = null;
    private FirewallGroupObject currentGroupObject = null;
    private String currentPolicyName = null;
    private boolean duplicateRuleObj = false;
    private String netObjDetectionStr = null;
    private String staticNATObjDetectionStr = null;
    private String serviceObjDetectionStr = null;
    private String ruleObjDetectionStr = null;
    private String interfaceDetectionStr = null;
    private String netObjGroupDetectionStr = null;
    private String staticNATObjGroupDetectionStr = null;
    private String serviceObjGroupDetectionStr = null;
    private Long rID = null;
    private String deviceType = "FortiGate";
    private String resourceName = null;
    private String configData = null;
    private Long versionNo = null;
    private LinkedHashMap<String, NetworkObject> netObjMap = null;
    private LinkedHashMap<String, StaticNATObject> staticNATObjMap = null;
    private LinkedHashMap<String, ServiceObject> serviceObjMap = null;
    private LinkedHashMap<String, Vector<RuleObject>> policyObjMap = null;
    private LinkedHashMap<String, ArrayList<String>> netObjGroupMemberDetailsMap = null;
    private LinkedHashMap<String, ArrayList<String>> staticNATObjGroupMemberDetailsMap = null;
    private LinkedHashMap<String, HashSet<String>> objGroupUnResolvedMembers = null;
    private HashMap<String, String> netObjInfoMap = null;
    private HashMap<String, String> serviceObjInfoMap = null;
    private HashMap<String, String> staticNATObjInfoMap = null;
    private ArrayList<String> netObjList = null;
    private ArrayList<String> serviceObjList = null;
    private LinkedHashMap<String, FirewallGroupObject> netObjGroupMap = null;
    private LinkedHashMap<String, FirewallGroupObject> staticNATObjGroupMap = null;
    private LinkedHashMap<String, FirewallGroupObject> serviceObjGroupMap = null;
    private HashMap<String, String> serviceToPortMap = null;
    private HashMap<String, String> interfaceVsZoneMap = null;
    private HashMap<String, String> interfaceVsIPAddrMap = null;
    private LinkedHashMap<String, InterfaceDetails> interfaceDetailsObjMap = null;
    private HashMap<String, String> interfaceAliasVsOriginalNamesMap = null;
    private HashMap<String, Long> policyNameVsIDMap = null;
    private ArrayList<String> allObjects = null;
    private Set<String> usedObjects = null;
    private ArrayList<String> allInterfaces = null;
    private Set<String> usedInterfaces = null;
    private static final Logger LOGGER = Logger.getLogger(FortiGatePolicyProcessor.class.getName());
    private EncryptionAPI decryptionObj = null;
    private Pattern serviceObjsrcAndDstPortExtractPattern = Pattern.compile("([^\\-]+)?(\\-)?([^\\-]+)?\\:([^\\-]+)?(\\-)?([^\\-]+)?");
    private static Pattern bracketExtractPattern = Pattern.compile(".*\\(([^\\)]+)\\)");
    private static Pattern tcpudpsctpicmpPortExtractPattern = Pattern.compile("(?:.*\\(Group\\):\\s*)?((?i)tcp|udp|sctp|icmp|ip)?\\s*(?:srcPort=([^\\,]+)(?:\\,)?)?(?:dstPort=([^\\,]+))?");
    private static Pattern icmpPortExtractPattern = Pattern.compile("(?:.*\\(Group\\):\\s*)?(?i)(icmp|icmp6)\\s+(\\S+)(?:\\s+(\\S+))?");
    private static Pattern anyProtocolExtractPattern = Pattern.compile("(?:.*\\(Group\\):\\s*)?Any\\s+(\\S+)");
    private static Pattern otherProtocolPortExtractPattern = Pattern.compile("(?:.*\\(Group\\):\\s*)?([^:]+)\\s+(\\S+)");
    private static Pattern justAServiceExtractPattern = Pattern.compile("(?:.*\\(Group\\):\\s*)?(\\S+)");
    private static ArrayList<Pattern> portExtractPatternList = null;
    private byte[] completeSubnetAddr = new byte[]{-1, -1, -1, -1};
    private byte[] zeroAddr = new byte[]{0, 0, 0, 0};
    private ArrayList<String> staticNATObjList = new ArrayList();
    private PolicyProcessorUtilityClass policyProcessorUtilityObject = null;
    private FirewallPolicyFormat fpf = null;
    private HashSet<String> unFoundDstInterfaceSet = null;
    private HashSet<String> unFoundSrcInterfaceSet = null;
    public HashSet<String> unknownPorts = null;
    private boolean isInDebugMode = false;
    private boolean hasInterfaceVsZoneMap = false;
    private boolean hasUnknownPorts = false;
    private HashSet<String> unResolvedObjectsSet = null;

    public FortiGatePolicyProcessor(Long rID, String resourceName, String configData, Long versionNo) {
        Level loggerLevel = LOGGER.getLevel();
        if (loggerLevel != null && loggerLevel.intValue() < 0) {
            this.isInDebugMode = true;
        }
        this.initialize();
        this.decryptionObj = EncryptionAPI.getDecryptionObj();
        this.rID = rID;
        this.resourceName = resourceName;
        this.configData = configData;
        this.versionNo = versionNo;
        this.policyProcessorUtilityObject = PolicyProcessorUtilityClass.getInstance();
        this.serviceToPortMap = this.policyProcessorUtilityObject.getServiceToPortMap("FortiGate");
        this.fpf = this.policyProcessorUtilityObject.getVendorSpecificPolicyFormat("FortiGate");
        this.interfaceVsZoneMap = PolicyProcessorUtilityClass.getResourceSpecificInterfaceVsZoneMap(rID);
        if (this.interfaceVsZoneMap == null) {
            this.interfaceVsZoneMap = this.policyProcessorUtilityObject.populateInterfaceVsZoneMapFromDB(rID);
        }
        if (this.interfaceVsZoneMap != null && !this.interfaceVsZoneMap.isEmpty()) {
            this.hasInterfaceVsZoneMap = true;
        }
        portExtractPatternList = new ArrayList();
        portExtractPatternList.add(tcpudpsctpicmpPortExtractPattern);
        portExtractPatternList.add(icmpPortExtractPattern);
        portExtractPatternList.add(anyProtocolExtractPattern);
        portExtractPatternList.add(otherProtocolPortExtractPattern);
        portExtractPatternList.add(justAServiceExtractPattern);
    }

    public FortiGatePolicyProcessor(Long rID, String resourceName, String configData, Long versionNo, Boolean noDefaultInitialization) {
        this.rID = rID;
        this.resourceName = resourceName;
        this.configData = configData;
        this.versionNo = versionNo;
    }

    private void initialize() {
        this.netObjMap = new LinkedHashMap(50);
        this.serviceObjMap = new LinkedHashMap(50);
        this.staticNATObjMap = new LinkedHashMap(50);
        this.policyObjMap = new LinkedHashMap(25);
        this.netObjGroupMemberDetailsMap = new LinkedHashMap(50);
        this.staticNATObjGroupMemberDetailsMap = new LinkedHashMap(50);
        this.objGroupUnResolvedMembers = new LinkedHashMap();
        this.netObjInfoMap = new HashMap(50);
        this.serviceObjInfoMap = new HashMap(50);
        this.staticNATObjInfoMap = new HashMap(50);
        this.netObjList = new ArrayList(30);
        this.serviceObjList = new ArrayList(30);
        this.netObjGroupMap = new LinkedHashMap(50);
        this.serviceObjGroupMap = new LinkedHashMap(50);
        this.staticNATObjGroupMap = new LinkedHashMap(50);
        this.allObjects = new ArrayList(100);
        this.usedObjects = new HashSet<String>(100);
        this.interfaceDetailsObjMap = new LinkedHashMap(25);
        this.interfaceAliasVsOriginalNamesMap = new HashMap();
        this.interfaceVsZoneMap = new HashMap();
        this.interfaceVsIPAddrMap = new HashMap();
        this.allInterfaces = new ArrayList();
        this.usedInterfaces = new HashSet<String>();
        this.unFoundDstInterfaceSet = new HashSet();
        this.unFoundSrcInterfaceSet = new HashSet();
        this.unknownPorts = new HashSet();
        this.unResolvedObjectsSet = new HashSet();
        this.policyNameVsIDMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startParsing() {
        try {
            FwConfigMgmt confMgmt = FwConfigMgmt.getInstance();
            if (this.configData == null) {
                Long maxVersion = confMgmt.getMaxConfigVersion(this.rID, "running");
                DataObject confDo = confMgmt.getLatestConfigFromDB(maxVersion, "running", this.rID);
                InputStream dbConfigDataStream = (InputStream)confDo.getFirstValue("ConfigVersions", "FILE_CONTENTS");
                if (dbConfigDataStream != null) {
                    BufferedReader reader = null;
                    StringWriter writer = new StringWriter();
                    char[] buffer = new char[1024];
                    try {
                        int n;
                        reader = new BufferedReader(new InputStreamReader(dbConfigDataStream, "UTF-8"));
                        while ((n = reader.read(buffer)) != -1) {
                            ((Writer)writer).write(buffer, 0, n);
                        }
                        this.configData = ((Object)writer).toString();
                    }
                    finally {
                        this.configData = this.decryptionObj.decryptLog(this.configData);
                        try {
                            if (reader != null) {
                                ((Reader)reader).close();
                            }
                            dbConfigDataStream.close();
                            ((Writer)writer).close();
                        }
                        catch (Exception ee) {
                            ee.printStackTrace();
                        }
                    }
                }
                throw new Exception("Unable to Parse the Config as no Config exists....for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor...");
            }
            if (this.fpf == null) {
                throw new Exception("No Policy Formats exists for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor...");
            }
            LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap = new LinkedHashMap<FWAEnumConstants.ParserKeys, String>();
            this.parseAndProcessInterfaceDetails(this.configData, resultMap);
            this.parseAndProcessNetworkObjects(this.configData, resultMap);
            this.parseAndProcessNetworkObjectGroups(this.configData, resultMap);
            this.parseAndProcessStaticNATObjects(this.configData, resultMap);
            this.parseAndProcessStaticNATObjectGroups(this.configData, resultMap);
            this.parseAndProcessServiceObjects(this.configData, resultMap);
            this.parseAndProcessServiceObjectGroups(this.configData, resultMap);
            this.parseAndProcessPolicyObjects(this.configData, resultMap);
            this.netObjList = null;
            this.serviceObjList = null;
            StringBuilder resultBuilder = new StringBuilder();
            this.parseAndProcessHttpConfig(this.configData, this.fpf, resultMap, resultBuilder);
            this.parseAndProcessTelnetConfig(this.configData, this.fpf, resultMap, resultBuilder);
            this.parseAndProcessSSHConfig(this.configData, this.fpf, resultMap, resultBuilder);
            this.parseAndProcessUserAccessConfig(this.configData, this.fpf, resultMap, resultBuilder);
            this.parseAndProcessNTPConfig(this.configData, this.fpf, resultMap, resultBuilder);
            this.parseAndProcessSyslogLoggingConfig(this.configData, this.fpf, resultMap, resultBuilder);
            resultMap = null;
            Object var3_4 = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseAndProcessSnmpConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        FWAEnumConstants.ParserKeys[] keys = new FWAEnumConstants.ParserKeys[]{FWAEnumConstants.ParserKeys.SNMPSERVEREVENTCONFIGLINE, FWAEnumConstants.ParserKeys.SNMPACCESSINTERFACELINE, FWAEnumConstants.ParserKeys.SNMPCOMMUNITYIPSLINE};
        ArrayList<FWAEnumConstants.ParserKeys> keylist = new ArrayList<FWAEnumConstants.ParserKeys>(Arrays.asList(keys));
        String snmpcommunityline = null;
        String snmpcommunity = null;
        BufferedReader reader = null;
        try {
            String strLine;
            String startExpression = fpf.getSNMPConfigStartExpression();
            Pattern startPattern = fpf.getSNMPConfigStartPattern();
            int startIndex = configData.indexOf("\nconfig system snmp community");
            int endIndex = configData.indexOf("\nconfig ", ++startIndex);
            String configToBeProcessed = configData.substring(startIndex, --endIndex);
            reader = new BufferedReader(new StringReader(configToBeProcessed));
            boolean matches = false;
            while ((strLine = reader.readLine()) != null) {
                matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                if (!matches) continue;
                while ((strLine = reader.readLine()) != null) {
                    Vector<FirewallPolicyParserRule> snmpConfigPR = fpf.getSNMPConfigParserRules();
                    parseResults = this.executeParserRuleListAndGetResultMap(strLine.trim(), snmpConfigPR);
                    for (FWAEnumConstants.ParserKeys key : parseResults.keySet()) {
                        String value = parseResults.get((Object)key);
                        if (keylist.contains((Object)key)) {
                            sb.append(value);
                            sb.append("<br>");
                            continue;
                        }
                        if (key == FWAEnumConstants.ParserKeys.SNMPCOMMUNITYCONFIGLINE) {
                            snmpcommunityline = value;
                            continue;
                        }
                        if (key != FWAEnumConstants.ParserKeys.SNMPCOMMUNITY || snmpcommunityline == null) continue;
                        snmpcommunity = value;
                        sb.append(snmpcommunityline.replaceAll(value, "<strong>" + value + "</strong>"));
                        sb.append("<br>");
                    }
                }
                break block11;
            }
            String status = "Pass";
            ResourceBundle bundle = ProductBundle.getInstance().getBundle();
            StringBuilder dbDataSB = new StringBuilder();
            if ("".equals(sb.toString())) {
                status = "UserCall";
                dbDataSB.append("<br>");
                dbDataSB.append("<strong>");
                dbDataSB.append(bundle.getString("Forti_SNMP_Setting_Recommendation"));
                dbDataSB.append("</strong>");
            } else if (snmpcommunity != null && snmpcommunity.equalsIgnoreCase("public")) {
                status = "Fail";
                dbDataSB.append("<br>");
                dbDataSB.append("<strong>");
                dbDataSB.append(bundle.getString("Forti_SNMP_public_Recommendation"));
                dbDataSB.append("</strong>");
            }
            dbDataSB.append(sb.toString());
            Long genericSectionID = new Long(4L);
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, dbDataSB.toString(), status, this.versionNo);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            LOGGER.log(Level.WARNING, "Exception Problem while processing SNMPconfig Details for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor.." + exp);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    @Override
    public void parseAndProcessHttpConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        if (this.interfaceDetailsObjMap == null || this.interfaceDetailsObjMap.isEmpty()) {
            try {
                this.parseAndProcessInterfaceDetails(configData, parseResults);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList<String> httpinterfacelist = new ArrayList<String>();
        String status = "Pass";
        Long genericSectionID = new Long(1L);
        try {
            if (this.interfaceDetailsObjMap != null && !this.interfaceDetailsObjMap.isEmpty()) {
                String objName = null;
                InterfaceDetails interfaceDetailsObj = null;
                int i = 0;
                for (Map.Entry<String, InterfaceDetails> entry : this.interfaceDetailsObjMap.entrySet()) {
                    String[] servicesArray;
                    ArrayList<String> servicelist;
                    if (i > 0) {
                        status = this.getDefaultCheckListItemStatus(genericSectionID);
                    }
                    objName = entry.getKey();
                    interfaceDetailsObj = entry.getValue();
                    String servicesAllowed = interfaceDetailsObj.getAllowAccess();
                    if (servicesAllowed == null || interfaceDetailsObj != null && "down".equals(interfaceDetailsObj.getStatus()) || !(servicelist = new ArrayList<String>(Arrays.asList(servicesArray = servicesAllowed.split(" ")))).contains("http")) continue;
                    httpinterfacelist.add(interfaceDetailsObj.getInterfaceName());
                    sb.append("<strong>" + interfaceDetailsObj.getaliasOrName() + "</strong>     (" + interfaceDetailsObj.getIP() + ")");
                    sb.append("<br>");
                    i = (short)(i + 1);
                }
            }
            ResourceBundle bundle = ProductBundle.getInstance().getBundle();
            StringBuilder dbDataSB = new StringBuilder();
            if ("".equals(sb.toString())) {
                dbDataSB.append("<strong>");
                dbDataSB.append(bundle.getString("HTTP_NOT_CONFIGURED"));
                dbDataSB.append("</strong>");
            } else {
                status = this.getDefaultCheckListItemStatus(genericSectionID);
                dbDataSB.append(sb.toString());
                dbDataSB.append("<strong>");
                dbDataSB.append(bundle.getString("Forti_HTTP_Recommendation"));
                dbDataSB.append("</strong>");
            }
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, dbDataSB.toString(), status, this.versionNo);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    @Override
    public void parseAndProcessTelnetConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        if (this.interfaceDetailsObjMap == null || this.interfaceDetailsObjMap.isEmpty()) {
            try {
                this.parseAndProcessInterfaceDetails(configData, parseResults);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList<String> telnetinterfacelist = new ArrayList<String>();
        String status = "Pass";
        Long genericSectionID = new Long(2L);
        try {
            if (this.interfaceDetailsObjMap != null && !this.interfaceDetailsObjMap.isEmpty()) {
                InterfaceDetails interfaceDetailsObj = null;
                int i = 0;
                for (Map.Entry<String, InterfaceDetails> entry : this.interfaceDetailsObjMap.entrySet()) {
                    String[] servicesArray;
                    ArrayList<String> servicelist;
                    String servicesAllowed;
                    if (i > 0) {
                        status = this.getDefaultCheckListItemStatus(genericSectionID);
                    }
                    if ((servicesAllowed = (interfaceDetailsObj = entry.getValue()).getAllowAccess()) == null || interfaceDetailsObj != null && "down".equals(interfaceDetailsObj.getStatus()) || !(servicelist = new ArrayList<String>(Arrays.asList(servicesArray = servicesAllowed.split(" ")))).contains("telnet")) continue;
                    telnetinterfacelist.add(interfaceDetailsObj.getInterfaceName());
                    sb.append("<strong>" + interfaceDetailsObj.getaliasOrName() + "</strong>     (" + interfaceDetailsObj.getIP() + ")");
                    sb.append("<br>");
                    i = (short)(i + 1);
                }
            }
            ResourceBundle bundle = ProductBundle.getInstance().getBundle();
            StringBuilder dbDataSB = new StringBuilder();
            if ("".equals(sb.toString())) {
                dbDataSB.append("<strong>");
                dbDataSB.append(bundle.getString("TELNET_NOT_CONFIGURED"));
                dbDataSB.append("</strong>");
            } else {
                status = this.getDefaultCheckListItemStatus(genericSectionID);
                dbDataSB.append(sb.toString());
                dbDataSB.append("<strong>");
                dbDataSB.append(bundle.getString("Forti_TELNET_Recommendation"));
                dbDataSB.append("</strong>");
            }
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, dbDataSB.toString(), status, this.versionNo);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    @Override
    public void parseAndProcessSSHConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        if (this.interfaceDetailsObjMap == null || this.interfaceDetailsObjMap.isEmpty()) {
            try {
                this.parseAndProcessInterfaceDetails(configData, parseResults);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList<String> sshinterfacelist = new ArrayList<String>();
        String status = "Pass";
        Long genericSectionID = new Long(3L);
        try {
            if (this.interfaceDetailsObjMap != null && !this.interfaceDetailsObjMap.isEmpty()) {
                InterfaceDetails interfaceDetailsObj = null;
                int i = 0;
                for (Map.Entry<String, InterfaceDetails> entry : this.interfaceDetailsObjMap.entrySet()) {
                    String[] servicesArray;
                    ArrayList<String> servicelist;
                    String servicesAllowed;
                    if (i > 0) {
                        status = "UserCall";
                    }
                    if ((servicesAllowed = (interfaceDetailsObj = entry.getValue()).getAllowAccess()) == null || interfaceDetailsObj != null && "down".equals(interfaceDetailsObj.getStatus()) || !(servicelist = new ArrayList<String>(Arrays.asList(servicesArray = servicesAllowed.split(" ")))).contains("ssh")) continue;
                    sshinterfacelist.add(interfaceDetailsObj.getInterfaceName());
                    sb.append("<strong>" + interfaceDetailsObj.getaliasOrName() + "</strong>    (" + interfaceDetailsObj.getIP() + ")");
                    sb.append("<br>");
                    i = (short)(i + 1);
                }
            }
            ResourceBundle bundle = ProductBundle.getInstance().getBundle();
            StringBuilder dbDataSB = new StringBuilder();
            if ("".equals(sb.toString())) {
                status = "Pass";
                dbDataSB.append("<strong>");
                dbDataSB.append(bundle.getString("SSH_NOT_CONFIGURED"));
                dbDataSB.append("</strong>");
            } else {
                dbDataSB.append(sb.toString());
                dbDataSB.append("<strong>");
                dbDataSB.append(bundle.getString("Forti_SSH_Recommendation"));
                dbDataSB.append("</strong>");
            }
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, dbDataSB.toString(), status, this.versionNo);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseAndProcessUserAccessConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        FWAEnumConstants.ParserKeys[] keys = new FWAEnumConstants.ParserKeys[]{FWAEnumConstants.ParserKeys.USERACCESSVDOMLINE};
        ArrayList<FWAEnumConstants.ParserKeys> keylist = new ArrayList<FWAEnumConstants.ParserKeys>(Arrays.asList(keys));
        FWAEnumConstants.ParserKeys[] boldkeys = new FWAEnumConstants.ParserKeys[]{FWAEnumConstants.ParserKeys.USERACCESSPROFILELINE};
        ArrayList<FWAEnumConstants.ParserKeys> boldlist = new ArrayList<FWAEnumConstants.ParserKeys>(Arrays.asList(boldkeys));
        String UserAccesspasswordLine = null;
        String usernameline = null;
        BufferedReader reader = null;
        try {
            String strLine;
            String startExpression = fpf.getUserAccessConfigStartExpression();
            Pattern startPattern = fpf.getUserAccessConfigStartPattern();
            int startIndex = configData.indexOf("\nconfig system admin");
            int endIndex = configData.indexOf("\nconfig ", ++startIndex);
            String configToBeProcessed = configData.substring(startIndex, --endIndex);
            reader = new BufferedReader(new StringReader(configToBeProcessed));
            boolean matches = false;
            while ((strLine = reader.readLine()) != null) {
                matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                if (!matches) continue;
                while ((strLine = reader.readLine()) != null) {
                    Vector<FirewallPolicyParserRule> userConfigPR = fpf.getUserAccessConfigParserRules();
                    parseResults = this.executeParserRuleListAndGetResultMap(strLine.trim(), userConfigPR);
                    for (FWAEnumConstants.ParserKeys key : parseResults.keySet()) {
                        String value = parseResults.get((Object)key);
                        if (keylist.contains((Object)key)) {
                            sb.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                            sb.append(value);
                            sb.append("<br>");
                            continue;
                        }
                        if (boldlist.contains((Object)key)) {
                            sb.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                            sb.append("<strong>" + value + "</strong>");
                            sb.append("<br>");
                            continue;
                        }
                        if (key == FWAEnumConstants.ParserKeys.USERACCESSPASSWORDLINE) {
                            UserAccesspasswordLine = value;
                            continue;
                        }
                        if (key == FWAEnumConstants.ParserKeys.USERACCESSNAMELINE) {
                            usernameline = value;
                            continue;
                        }
                        if (key == FWAEnumConstants.ParserKeys.USERACCESSNAME && usernameline != null) {
                            sb.append(usernameline.replaceAll(value, "<strong>" + value + "</strong>"));
                            sb.append("<br>");
                            continue;
                        }
                        if (key != FWAEnumConstants.ParserKeys.USERACCESSPASSWORD || UserAccesspasswordLine == null) continue;
                        sb.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                        sb.append(UserAccesspasswordLine.replace(UserAccesspasswordLine.subSequence(UserAccesspasswordLine.indexOf(value), UserAccesspasswordLine.length()), "******"));
                        sb.append("<br>");
                    }
                }
                break block11;
            }
            ResourceBundle bundle = ProductBundle.getInstance().getBundle();
            StringBuilder dbDataSB = new StringBuilder();
            if ("".equals(sb.toString())) {
                dbDataSB.append("<strong>");
                dbDataSB.append(bundle.getString("Forti_User_Setting_Recommendation"));
                dbDataSB.append("</strong>");
            }
            dbDataSB.append(sb.toString());
            Long genericSectionID = new Long(5L);
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, dbDataSB.toString(), "UserCall", this.versionNo);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            LOGGER.log(Level.WARNING, "Exception Problem while processing userconfig Details for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor.." + exp);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseAndProcessNTPConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        FWAEnumConstants.ParserKeys[] keys = new FWAEnumConstants.ParserKeys[]{FWAEnumConstants.ParserKeys.NTPSRCIPLINE, FWAEnumConstants.ParserKeys.NTPCONFIGLINES, FWAEnumConstants.ParserKeys.NTPSERVERIPLINE, FWAEnumConstants.ParserKeys.NTPSYNCINTERVALLINE};
        ArrayList<FWAEnumConstants.ParserKeys> keylist = new ArrayList<FWAEnumConstants.ParserKeys>(Arrays.asList(keys));
        String ntpserverstatus = null;
        String ntpServerStatusLine = null;
        BufferedReader reader = null;
        try {
            String strLine;
            String startExpression = fpf.getNTPConfigStartExpression();
            Pattern startPattern = fpf.getNTPConfigStartPattern();
            int startIndex = configData.indexOf("\nconfig system ntp");
            int endIndex = configData.indexOf("\nconfig ", ++startIndex);
            String configToBeProcessed = configData.substring(startIndex, --endIndex);
            reader = new BufferedReader(new StringReader(configToBeProcessed));
            boolean matches = false;
            while ((strLine = reader.readLine()) != null) {
                matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                if (!matches) continue;
                while ((strLine = reader.readLine()) != null) {
                    Vector<FirewallPolicyParserRule> ntpConfigPR = fpf.getNTPConfigParserRules();
                    parseResults = this.executeParserRuleListAndGetResultMap(strLine.trim(), ntpConfigPR);
                    for (FWAEnumConstants.ParserKeys key : parseResults.keySet()) {
                        String value = parseResults.get((Object)key);
                        if (keylist.contains((Object)key)) {
                            sb.append(value);
                            sb.append("<br>");
                            continue;
                        }
                        if (key == FWAEnumConstants.ParserKeys.NTPSERVERSTATUSLINE) {
                            ntpServerStatusLine = value;
                            continue;
                        }
                        if (key != FWAEnumConstants.ParserKeys.NTPSERVERSTATUS) continue;
                        ntpserverstatus = value;
                        if (ntpServerStatusLine == null) continue;
                        sb.append(ntpServerStatusLine.replaceAll(value, "<strong>" + value + "</strong>"));
                        sb.append("<br>");
                    }
                }
                break block11;
            }
            String status = "Pass";
            ResourceBundle bundle = ProductBundle.getInstance().getBundle();
            StringBuilder dbDataSB = new StringBuilder();
            if ("".equals(sb.toString())) {
                status = "Usercall";
                dbDataSB.append("<strong>");
                dbDataSB.append(bundle.getString("Forti_NTP_Setting_Recommendation"));
                dbDataSB.append("</strong>");
            }
            dbDataSB.append(sb.toString());
            if (ntpserverstatus != null && !"enable".equalsIgnoreCase(ntpserverstatus)) {
                status = "Usercall";
                dbDataSB.append("<strong>");
                dbDataSB.append(bundle.getString("Forti_NTP_Disabled_Recommendation"));
                dbDataSB.append("</strong>");
            }
            Long genericSectionID = new Long(6L);
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, dbDataSB.toString(), status, this.versionNo);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            LOGGER.log(Level.WARNING, "Exception Problem while processing NTP Details for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor.." + exp);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseAndProcessSyslogLoggingConfig(String configData, FirewallPolicyFormat fpf, LinkedHashMap<FWAEnumConstants.ParserKeys, String> parseResults, StringBuilder sb) {
        FWAEnumConstants.ParserKeys[] keys = new FWAEnumConstants.ParserKeys[]{FWAEnumConstants.ParserKeys.LOGCONFIGLINES};
        ArrayList<FWAEnumConstants.ParserKeys> keylist = new ArrayList<FWAEnumConstants.ParserKeys>(Arrays.asList(keys));
        String logserverstatus = null;
        String logServerStatusLine = null;
        String logServerIPLine = null;
        BufferedReader reader = null;
        try {
            String strLine;
            String startExpression = fpf.getSyslogConfigStartExpression();
            Pattern startPattern = fpf.getSyslogConfigStartPattern();
            int startIndex = configData.indexOf("\nconfig log syslogd setting");
            int endIndex = configData.indexOf("\nconfig ", ++startIndex);
            String configToBeProcessed = configData.substring(startIndex, --endIndex);
            reader = new BufferedReader(new StringReader(configToBeProcessed));
            boolean matches = false;
            int i = 0;
            while ((strLine = reader.readLine()) != null) {
                matches = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                if (!matches) continue;
                while ((strLine = reader.readLine()) != null) {
                    Vector<FirewallPolicyParserRule> syslogConfigPR = fpf.getSyslogLoggingConfigParserRules();
                    parseResults = this.executeParserRuleListAndGetResultMap(strLine.trim(), syslogConfigPR);
                    Iterator<FWAEnumConstants.ParserKeys> itr = parseResults.keySet().iterator();
                    if (i > 0) {
                        sb.append("<br>");
                    }
                    block19: while (itr.hasNext()) {
                        FWAEnumConstants.ParserKeys key = itr.next();
                        String value = parseResults.get((Object)key);
                        switch (key) {
                            case LOGENABLELINE: {
                                logServerStatusLine = value;
                                continue block19;
                            }
                            case LOGENABLESTATUS: {
                                logserverstatus = value;
                                if (logServerStatusLine == null) continue block19;
                                sb.append(logServerStatusLine.replaceAll(value, "<strong>" + value + "</strong>"));
                                continue block19;
                            }
                            case LOGSEVERIPLINE: {
                                logServerIPLine = value;
                                continue block19;
                            }
                            case LOGSEVERIP: {
                                if (logServerIPLine == null) continue block19;
                                sb.append(logServerIPLine.replaceAll(value, "<strong>" + value + "</strong>"));
                                continue block19;
                            }
                        }
                        if (!keylist.contains((Object)key)) continue;
                        sb.append(value);
                    }
                    ++i;
                }
                break block17;
            }
            String status = "Pass";
            ResourceBundle bundle = ProductBundle.getInstance().getBundle();
            StringBuilder dbDataSB = new StringBuilder();
            if ("".equals(sb.toString())) {
                status = "Fail";
                dbDataSB.append("<br>");
                dbDataSB.append("<strong>");
                dbDataSB.append(bundle.getString("Forti_Syslog_Setting_Recommendation"));
                dbDataSB.append("</strong>");
            }
            dbDataSB.append(sb.toString());
            if (logserverstatus != null && !"enable".equalsIgnoreCase(logserverstatus)) {
                status = "Fail";
                dbDataSB.append("<br>");
                dbDataSB.append("<strong>");
                dbDataSB.append(bundle.getString("Forti_Syslog_Disabled_Recommendation"));
                dbDataSB.append("</strong>");
            }
            Long genericSectionID = new Long(8L);
            this.policyProcessorUtilityObject.deleteConfigCheckListEntry(this.rID, genericSectionID);
            this.policyProcessorUtilityObject.addConfigCheckListEntry(this.rID, genericSectionID, dbDataSB.toString(), status, this.versionNo);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            LOGGER.log(Level.WARNING, "Exception Problem while processing Syslog Details for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor.." + exp);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    private void parseAndProcessInterfaceDetails(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block13: {
            BufferedReader reader = null;
            try {
                int startIndex = configData.indexOf("\nconfig system interface");
                if (startIndex > -1) {
                    int endIndex = configData.indexOf("\nconfig ", ++startIndex);
                    --endIndex;
                    String startExpression = this.fpf.getInterfaceStartExpression();
                    Pattern startPattern = this.fpf.getInterfaceStartPattern();
                    String endExpression = this.fpf.getEndExpression();
                    Pattern endPattern = this.fpf.getEndPattern();
                    boolean patternMatched = false;
                    String configToBeProcessed = configData.substring(startIndex, endIndex);
                    reader = new BufferedReader(new StringReader(configToBeProcessed));
                    String strLine = reader.readLine();
                    if (strLine == null) break block13;
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine = strLine.trim(), startExpression, startPattern);
                    if (patternMatched) {
                        Vector<FirewallPolicyParserRule> interfaceNamePR = this.fpf.getInterfaceNameParserRules();
                        Vector<FirewallPolicyParserRule> interfaceElementsPR = this.fpf.getInterfaceElementsParserRules();
                        while ((strLine = reader.readLine()) != null) {
                            patternMatched = this.executeParserRuleList(strLine, interfaceElementsPR, "interfaceElements", resultMap);
                            if (patternMatched || (patternMatched = this.executeParserRuleList(strLine, interfaceNamePR, "interfaceName", resultMap)) || !(patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, endExpression, endPattern))) continue;
                            break block13;
                        }
                        break block13;
                    }
                    throw new Exception("Problem while processing Interface Details for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
                }
                LOGGER.log(Level.INFO, "No Interface Details for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Interface Details for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void parseAndProcessNetworkObjects(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block13: {
            BufferedReader reader = null;
            try {
                int startIndex = configData.indexOf("\nconfig firewall address");
                if (startIndex > -1) {
                    int endIndex = configData.indexOf("\nconfig ", ++startIndex);
                    --endIndex;
                    String startExpression = this.fpf.getNetObjStartExpression();
                    Pattern startPattern = this.fpf.getNetObjStartPattern();
                    String endExpression = this.fpf.getEndExpression();
                    Pattern endPattern = this.fpf.getEndPattern();
                    boolean patternMatched = false;
                    String configToBeProcessed = configData.substring(startIndex, endIndex);
                    reader = new BufferedReader(new StringReader(configToBeProcessed));
                    String strLine = reader.readLine();
                    if (strLine == null) break block13;
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, startExpression, startPattern);
                    if (patternMatched) {
                        Vector<FirewallPolicyParserRule> netObjNamePR = this.fpf.getNetworkObjectNameParserRules();
                        Vector<FirewallPolicyParserRule> netObjElementsPR = this.fpf.getNetworkObjectElementsParserRules();
                        while ((strLine = reader.readLine()) != null) {
                            patternMatched = this.executeParserRuleList(strLine, netObjElementsPR, "netObjElements", resultMap);
                            if (patternMatched || (patternMatched = this.executeParserRuleList(strLine, netObjNamePR, "netObjName", resultMap)) || !(patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, endExpression, endPattern))) continue;
                            break block13;
                        }
                        break block13;
                    }
                    throw new Exception("Problem while processing Network Objects for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
                }
                LOGGER.log(Level.INFO, "No Network Objects for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Network Objects for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void parseAndProcessNetworkObjectGroups(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block13: {
            BufferedReader reader = null;
            try {
                int startIndex = configData.indexOf("\nconfig firewall addrgrp");
                if (startIndex > -1) {
                    int endIndex = configData.indexOf("\nconfig ", ++startIndex);
                    --endIndex;
                    String startExpression = this.fpf.getNetObjGroupStartExpression();
                    Pattern startPattern = this.fpf.getNetObjGroupStartPattern();
                    String endExpression = this.fpf.getEndExpression();
                    Pattern endPattern = this.fpf.getEndPattern();
                    boolean patternMatched = false;
                    String configToBeProcessed = configData.substring(startIndex, endIndex);
                    reader = new BufferedReader(new StringReader(configToBeProcessed));
                    String strLine = reader.readLine();
                    if (strLine == null) break block13;
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, startExpression, startPattern);
                    if (patternMatched) {
                        Vector<FirewallPolicyParserRule> netObjGroupNamePR = this.fpf.getNetworkObjectGroupNameParserRules();
                        Vector<FirewallPolicyParserRule> netObjGroupElementsPR = this.fpf.getNetworkObjectGroupElementsParserRules();
                        while ((strLine = reader.readLine()) != null) {
                            patternMatched = this.executeParserRuleList(strLine, netObjGroupElementsPR, "netObjGroupElements", resultMap);
                            if (patternMatched || (patternMatched = this.executeParserRuleList(strLine, netObjGroupNamePR, "netObjGroupName", resultMap)) || !(patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, endExpression, endPattern))) continue;
                            break block13;
                        }
                        break block13;
                    }
                    throw new Exception("Problem while processing Network Objects Groups for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
                }
                LOGGER.log(Level.INFO, "No Network Object Groups for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Network Objects Groups for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void parseAndProcessStaticNATObjects(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block13: {
            BufferedReader reader = null;
            try {
                int startIndex = configData.indexOf("\nconfig firewall vip");
                if (startIndex > -1) {
                    int endIndex = configData.indexOf("\nconfig ", ++startIndex);
                    --endIndex;
                    String startExpression = this.fpf.getStaticNATObjStartExpression();
                    Pattern startPattern = this.fpf.getStaticNATObjStartPattern();
                    String endExpression = this.fpf.getEndExpression();
                    Pattern endPattern = this.fpf.getEndPattern();
                    boolean patternMatched = false;
                    String configToBeProcessed = configData.substring(startIndex, endIndex);
                    reader = new BufferedReader(new StringReader(configToBeProcessed));
                    String strLine = reader.readLine();
                    if (strLine == null) break block13;
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, startExpression, startPattern);
                    if (patternMatched) {
                        Vector<FirewallPolicyParserRule> staticNATObjNamePR = this.fpf.getStaticNATObjectNameParserRules();
                        Vector<FirewallPolicyParserRule> staticNATObjElementsPR = this.fpf.getStaticNATObjectElementsParserRules();
                        while ((strLine = reader.readLine()) != null) {
                            patternMatched = this.executeParserRuleList(strLine, staticNATObjElementsPR, "staticNATObjElements", resultMap);
                            if (patternMatched || (patternMatched = this.executeParserRuleList(strLine, staticNATObjNamePR, "staticNATObjName", resultMap)) || !(patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, endExpression, endPattern))) continue;
                            break block13;
                        }
                        break block13;
                    }
                    throw new Exception("Problem while processing Static NAT Objects for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
                }
                LOGGER.log(Level.INFO, "No Static NAT Objectsfor the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Static NAT Objects for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void parseAndProcessStaticNATObjectGroups(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block14: {
            InputStream is = null;
            BufferedReader reader = null;
            try {
                int startIndex = configData.indexOf("\nconfig firewall vipgrp");
                if (startIndex > -1) {
                    int endIndex = configData.indexOf("\nconfig ", ++startIndex);
                    --endIndex;
                    String startExpression = this.fpf.getStaticNATObjGroupStartExpression();
                    Pattern startPattern = this.fpf.getStaticNATObjGroupStartPattern();
                    String endExpression = this.fpf.getEndExpression();
                    Pattern endPattern = this.fpf.getEndPattern();
                    boolean patternMatched = false;
                    String configToBeProcessed = configData.substring(startIndex, endIndex);
                    reader = new BufferedReader(new StringReader(configToBeProcessed));
                    String strLine = reader.readLine();
                    if (strLine == null) break block14;
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, startExpression, startPattern);
                    if (patternMatched) {
                        Vector<FirewallPolicyParserRule> staticNATObjGroupNamePR = this.fpf.getStaticNATObjectGroupNameParserRules();
                        Vector<FirewallPolicyParserRule> staticNATObjGroupElementsPR = this.fpf.getStaticNATObjectGroupElementsParserRules();
                        while ((strLine = reader.readLine()) != null) {
                            patternMatched = this.executeParserRuleList(strLine, staticNATObjGroupElementsPR, "staticNATObjGroupElements", resultMap);
                            if (patternMatched || (patternMatched = this.executeParserRuleList(strLine, staticNATObjGroupNamePR, "staticNATObjGroupName", resultMap)) || !(patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, endExpression, endPattern))) continue;
                            break block14;
                        }
                        break block14;
                    }
                    throw new Exception("Problem while processing Static NAT Objects Groups for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
                }
                LOGGER.log(Level.INFO, "No Static NAT Object Groups for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Static NAT Objects Groups for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void parseAndProcessServiceObjects(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        int startIndex = configData.indexOf("\nconfig firewall service");
        if (startIndex > -1) {
            int endIndex = configData.indexOf("\nconfig ", ++startIndex);
            --endIndex;
            while (startIndex > 0 && endIndex > 0) {
                String configToBeProcessed = configData.substring(startIndex, endIndex);
                this.parseAndProcessServiceObjectBlock(resultMap, configToBeProcessed);
                startIndex = endIndex - 1;
                configData = configData.substring(startIndex);
                startIndex = configData.indexOf("\nconfig firewall service explicit-web");
                if (startIndex > -1) {
                    endIndex = configData.indexOf("\nconfig ", ++startIndex);
                    --endIndex;
                    continue;
                }
                startIndex = configData.indexOf("\nconfig firewall service\n");
                if (startIndex > -1) {
                    endIndex = configData.indexOf("\nconfig ", ++startIndex);
                    --endIndex;
                    continue;
                }
                startIndex = -1;
                endIndex = -1;
            }
        } else {
            LOGGER.log(Level.INFO, "No Service Objects for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
        }
    }

    public void parseAndProcessServiceObjectBlock(LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap, String configToBeProcessed) throws Exception {
        block12: {
            BufferedReader reader = null;
            try {
                String startExpression = this.fpf.getServiceObjStartExpression();
                Pattern startPattern = this.fpf.getServiceObjStartPattern();
                String endExpression = this.fpf.getEndExpression();
                Pattern endPattern = this.fpf.getEndPattern();
                boolean patternMatched = false;
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                String strLine = reader.readLine();
                if (strLine == null) break block12;
                patternMatched = this.matchObjStartPattern(strLine, startExpression, startPattern);
                if (patternMatched) {
                    Vector<FirewallPolicyParserRule> serviceObjNamePR = this.fpf.getServiceObjectNameParserRules();
                    Vector<FirewallPolicyParserRule> serviceObjElementsPR = this.fpf.getServiceObjectElementsParserRules();
                    while ((strLine = reader.readLine()) != null) {
                        patternMatched = this.executeParserRuleList(strLine, serviceObjElementsPR, "serviceObjElements", resultMap);
                        if (patternMatched || (patternMatched = this.executeParserRuleList(strLine, serviceObjNamePR, "serviceObjName", resultMap)) || !(patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, endExpression, endPattern))) continue;
                        break block12;
                    }
                    break block12;
                }
                throw new Exception("Problem while processing Service Objects for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Service Objects for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void parseAndProcessServiceObjectGroups(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        block13: {
            BufferedReader reader = null;
            try {
                int startIndex = configData.indexOf("\nconfig firewall service group");
                if (startIndex > -1) {
                    int endIndex = configData.indexOf("\nconfig ", ++startIndex);
                    --endIndex;
                    String startExpression = this.fpf.getServiceObjGroupStartExpression();
                    Pattern startPattern = this.fpf.getServiceObjGroupStartPattern();
                    String endExpression = this.fpf.getEndExpression();
                    Pattern endPattern = this.fpf.getEndPattern();
                    boolean patternMatched = false;
                    String configToBeProcessed = configData.substring(startIndex, endIndex);
                    reader = new BufferedReader(new StringReader(configToBeProcessed));
                    String strLine = reader.readLine();
                    if (strLine == null) break block13;
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, startExpression, startPattern);
                    if (patternMatched) {
                        Vector<FirewallPolicyParserRule> serviceObjGroupNamePR = this.fpf.getServiceObjectGroupNameParserRules();
                        Vector<FirewallPolicyParserRule> serviceObjGroupElementsPR = this.fpf.getServiceObjectGroupElementsParserRules();
                        while ((strLine = reader.readLine()) != null) {
                            patternMatched = this.executeParserRuleList(strLine, serviceObjGroupElementsPR, "serviceObjGroupElements", resultMap);
                            if (patternMatched || (patternMatched = this.executeParserRuleList(strLine, serviceObjGroupNamePR, "serviceObjGroupName", resultMap)) || !(patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, endExpression, endPattern))) continue;
                            break block13;
                        }
                        break block13;
                    }
                    throw new Exception("Problem while processing Service Objects Groups for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
                }
                LOGGER.log(Level.INFO, "No Service Object Groups for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
            }
            catch (Exception exp) {
                throw new Exception("Problem while processing Service Objects Groups for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void parseAndProcessPolicyObjects(String configData, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        String defaultPolicyName;
        BufferedReader reader = null;
        String policyName = defaultPolicyName = this.resourceName + "_Policy";
        try {
            int startIndex = configData.indexOf("\nconfig firewall policy");
            if (startIndex > -1) {
                String strLine;
                int endIndex = configData.indexOf("\nconfig ", ++startIndex);
                --endIndex;
                String startExpression = this.fpf.getPolicyStartExpression();
                Pattern startPattern = this.fpf.getPolicyStartPattern();
                String endExpression = this.fpf.getEndExpression();
                Pattern endPattern = this.fpf.getEndPattern();
                boolean patternMatched = false;
                String configToBeProcessed = configData.substring(startIndex, endIndex);
                reader = new BufferedReader(new StringReader(configToBeProcessed));
                while ((strLine = reader.readLine()) != null) {
                    patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, startExpression, startPattern);
                    if (!patternMatched) continue;
                    Vector<FirewallPolicyParserRule> ruleObjNamePR = this.fpf.getRuleNameParserRules();
                    Vector<FirewallPolicyParserRule> ruleObjElementsPR = this.fpf.getRuleElementsParserRules();
                    Vector ruleObjList = new Vector();
                    this.policyObjMap.put(policyName, ruleObjList);
                    this.currentPolicyName = policyName;
                    while ((strLine = reader.readLine()) != null && ((patternMatched = this.executeParserRuleList(strLine, ruleObjElementsPR, "ruleObjElements", resultMap)) || (patternMatched = this.executeParserRuleList(strLine, ruleObjNamePR, "ruleObjName", resultMap)) || !(patternMatched = this.policyProcessorUtilityObject.matchPattern(strLine, endExpression, endPattern)))) {
                    }
                    break block9;
                }
                if (this.currentRuleObject != null) {
                    Vector<RuleObject> ruleObjList = (Vector<RuleObject>)this.policyObjMap.remove(this.currentPolicyName);
                    if (ruleObjList == null) {
                        ruleObjList = new Vector<RuleObject>();
                    }
                    ruleObjList.add(this.currentRuleObject);
                    this.policyObjMap.put(this.currentPolicyName, ruleObjList);
                }
            } else {
                LOGGER.log(Level.INFO, "No Firewall Policies for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..");
            }
        }
        catch (Exception exp) {
            throw new Exception("Problem while processing Policy Objects for the firewall " + this.resourceName + " of " + this.deviceType + " Vendor..", exp);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private boolean executeParserRuleList(String data, Vector<FirewallPolicyParserRule> parserRules, String parserRuleType, LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap) throws Exception {
        boolean patternMatched = false;
        for (FirewallPolicyParserRule rule : parserRules) {
            String expression = rule.getRegex();
            Pattern pattern = rule.getPattern();
            ArrayList<FirewallPolicyParserRuleAttribute> attributes = rule.getAttributes();
            patternMatched = this.policyProcessorUtilityObject.executeParserRule(data, expression, attributes, pattern, resultMap);
            if (!patternMatched) continue;
            String objName = null;
            if (parserRuleType.equals("netObjName")) {
                NetworkObject netObj = null;
                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                    String value = resultMap.get((Object)key);
                    if (key == FWAEnumConstants.ParserKeys.NETOBJNAME) {
                        objName = value;
                        continue;
                    }
                    if (key != FWAEnumConstants.ParserKeys.NETOBJDETECTIONSTRING) continue;
                    if (this.netObjDetectionStr == null) {
                        this.netObjDetectionStr = value;
                        continue;
                    }
                    if (this.netObjDetectionStr.equals(value)) continue;
                    return false;
                }
                if (objName != null) {
                    netObj = this.netObjMap.get(objName);
                    if (netObj == null) {
                        netObj = new NetworkObject(objName);
                        this.netObjMap.put(objName, netObj);
                        this.netObjList.add(objName);
                    }
                    this.currentNetworkObject = netObj;
                    break;
                }
                return false;
            }
            if (parserRuleType.equals("netObjElements")) {
                String subnet = null;
                NetworkObject netObj = this.currentNetworkObject;
                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                    String value = resultMap.get((Object)key);
                    switch (key) {
                        case INTERFACE: {
                            netObj.setInterfaceName(value);
                            break;
                        }
                        case STARTIP: {
                            netObj.setStartIP(value);
                            String maxIP = netObj.getEndIP();
                            if (maxIP == null || netObj.getIPRange() != null) break;
                            netObj.setIPRange(value + "-" + maxIP);
                            netObj.setIPRangeID(this.policyProcessorUtilityObject.getIPIDRange(value, maxIP));
                            break;
                        }
                        case ENDIP: {
                            netObj.setEndIP(value);
                            String minIP = netObj.getStartIP();
                            if (minIP == null || netObj.getIPRange() != null) break;
                            netObj.setIPRange(minIP + "-" + value);
                            netObj.setIPRangeID(this.policyProcessorUtilityObject.getIPIDRange(minIP, value));
                            break;
                        }
                        case SUBNET: {
                            subnet = value;
                            break;
                        }
                        case SUBNETMASK: {
                            netObj.setSubnet(subnet);
                            netObj.setSubnetMask(value);
                            this.policyProcessorUtilityObject.setIPAndIPIDInNetObj(value, subnet, netObj);
                            break;
                        }
                        case COMMENT: {
                            netObj.setComment(value);
                            break;
                        }
                    }
                }
            } else {
                if (parserRuleType.equals("staticNATObjName")) {
                    StaticNATObject staticNATObj = null;
                    for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                        String value = resultMap.get((Object)key);
                        if (key == FWAEnumConstants.ParserKeys.STATICNATOBJNAME) {
                            objName = value;
                            continue;
                        }
                        if (key != FWAEnumConstants.ParserKeys.STATICNATOBJDETECTIONSTRING) continue;
                        if (this.staticNATObjDetectionStr == null) {
                            this.staticNATObjDetectionStr = value;
                            continue;
                        }
                        if (this.staticNATObjDetectionStr.equals(value)) continue;
                        return false;
                    }
                    if (objName != null) {
                        staticNATObj = this.staticNATObjMap.get(objName);
                        if (staticNATObj == null) {
                            staticNATObj = new StaticNATObject(objName);
                            this.staticNATObjMap.put(objName, staticNATObj);
                            this.staticNATObjList.add(objName);
                        }
                        this.currentStaticNATObject = staticNATObj;
                        break;
                    }
                    return false;
                }
                if (parserRuleType.equals("staticNATObjElements")) {
                    StaticNATObject staticNATObj = this.currentStaticNATObject;
                    for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                        String value = resultMap.get((Object)key);
                        switch (key) {
                            case EXTINTERFACE: {
                                staticNATObj.setExtInterface(value);
                                break;
                            }
                            case EXTIP: {
                                staticNATObj.setExternalIP(value);
                                break;
                            }
                            case MAPPEDIP: {
                                staticNATObj.setMappedIP(value);
                                String completeNetwork = InetAddress.getByAddress(this.completeSubnetAddr).getHostAddress();
                                staticNATObj.setSubnet(value);
                                staticNATObj.setSubnetMask(completeNetwork);
                                String network = IPRange.getNetwork((String)completeNetwork, (String)value);
                                long[] minMaxIPLong = IPRange.getMinMaxLong((String)network, (String)completeNetwork);
                                if (minMaxIPLong == null) break;
                                staticNATObj.setIPRangeID(minMaxIPLong[0] + "-" + minMaxIPLong[1]);
                                staticNATObj.setIPRange(IPRange.convertAddr((long)minMaxIPLong[0]) + "-" + IPRange.convertAddr((long)minMaxIPLong[1]));
                                break;
                            }
                            case EXTPORT: {
                                staticNATObj.setExternalPort(value);
                                break;
                            }
                            case MAPPEDPORT: {
                                staticNATObj.setMappedPort(value);
                                break;
                            }
                            case PROTOCOL: {
                                staticNATObj.setProtocol(value);
                                break;
                            }
                            case STATICNATCOMMENT: {
                                staticNATObj.setComment(value);
                                break;
                            }
                        }
                    }
                } else {
                    if (parserRuleType.equals("serviceObjName")) {
                        ServiceObject serviceObj = null;
                        for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                            String value = resultMap.get((Object)key);
                            if (key == FWAEnumConstants.ParserKeys.SERVICEOBJNAME) {
                                objName = value;
                                continue;
                            }
                            if (key != FWAEnumConstants.ParserKeys.SERVICEOBJDETECTIONSTRING) continue;
                            if (this.serviceObjDetectionStr == null) {
                                this.serviceObjDetectionStr = value;
                                continue;
                            }
                            if (this.serviceObjDetectionStr.equals(value)) continue;
                            return false;
                        }
                        if (objName != null) {
                            serviceObj = this.serviceObjMap.get(objName);
                            if (serviceObj == null) {
                                serviceObj = new ServiceObject(objName);
                                this.serviceObjMap.put(objName, serviceObj);
                                this.serviceObjList.add(objName);
                            }
                            this.currentServiceObject = serviceObj;
                            break;
                        }
                        return false;
                    }
                    if (parserRuleType.equals("serviceObjElements")) {
                        String tmpProto = null;
                        ServiceObject serviceObj = this.currentServiceObject;
                        for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                            String value = resultMap.get((Object)key);
                            switch (key) {
                                case PROTOCOL: {
                                    if (value.equals("TCP/UDP/SCTP")) break;
                                    serviceObj.setProtocol(value.replaceAll("/", ","));
                                    break;
                                }
                                case ICMPTYPE: {
                                    serviceObj.setICMPType(value);
                                    break;
                                }
                                case ICMPCODE: {
                                    String icmpType = serviceObj.getICMPType();
                                    value = icmpType != null ? icmpType + " " + value : null;
                                    serviceObj.setICMPType(value);
                                    break;
                                }
                                case IPPROTOCOLNUMBER: {
                                    serviceObj.setService(value);
                                    break;
                                }
                                case TCP_PORTRANGE: {
                                    value = this.getProcessedValue(value);
                                    serviceObj.setTCPPortRange(value);
                                    tmpProto = serviceObj.getProtocol();
                                    tmpProto = tmpProto != null ? tmpProto + ",TCP" : "TCP";
                                    serviceObj.setProtocol(tmpProto);
                                    break;
                                }
                                case UDP_PORTRANGE: {
                                    value = this.getProcessedValue(value);
                                    serviceObj.setUDPPortRange(value);
                                    tmpProto = serviceObj.getProtocol();
                                    tmpProto = tmpProto != null ? tmpProto + ",UDP" : "UDP";
                                    serviceObj.setProtocol(tmpProto);
                                    break;
                                }
                                case SCTP_PORTRANGE: {
                                    value = this.getProcessedValue(value);
                                    serviceObj.setSCTPPortRange(value);
                                    tmpProto = serviceObj.getProtocol();
                                    tmpProto = tmpProto != null ? tmpProto + ",SCTP" : "SCTP";
                                    serviceObj.setProtocol(tmpProto);
                                    break;
                                }
                                case SERVICEOBJCOMMENT: {
                                    serviceObj.setComment(value);
                                    break;
                                }
                            }
                        }
                    } else {
                        if (parserRuleType.equals("interfaceName")) {
                            InterfaceDetails interfaceDetailsObj = null;
                            for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                                String value = resultMap.get((Object)key);
                                if (key == FWAEnumConstants.ParserKeys.INTERFACENAME) {
                                    objName = value;
                                    continue;
                                }
                                if (key != FWAEnumConstants.ParserKeys.INTERFACEDETECTIONSTRING) continue;
                                if (this.interfaceDetectionStr == null) {
                                    this.interfaceDetectionStr = value;
                                    continue;
                                }
                                if (this.interfaceDetectionStr.equals(value)) continue;
                                return false;
                            }
                            if (objName != null) {
                                interfaceDetailsObj = this.interfaceDetailsObjMap.get(objName);
                                if (interfaceDetailsObj == null) {
                                    interfaceDetailsObj = new InterfaceDetails(objName);
                                    this.interfaceDetailsObjMap.put(objName, interfaceDetailsObj);
                                }
                                this.currentInterfaceDetailsObject = interfaceDetailsObj;
                                break;
                            }
                            LOGGER.log(Level.FINER, "No interfaceName...hence returning false..");
                            return false;
                        }
                        if (parserRuleType.equals("interfaceElements")) {
                            InterfaceDetails interfaceDetailsObj = this.currentInterfaceDetailsObject;
                            for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                                String value = resultMap.get((Object)key);
                                switch (key) {
                                    case ALIASNAME: {
                                        String ifName = interfaceDetailsObj.getInterfaceName();
                                        this.interfaceAliasVsOriginalNamesMap.put(value, ifName);
                                        ifName = ifName + " (" + value + ")";
                                        interfaceDetailsObj.setInterfaceName(ifName);
                                        interfaceDetailsObj.setAliasName(value);
                                        break;
                                    }
                                    case VDOMNAME: {
                                        interfaceDetailsObj.setVdomName(value);
                                        break;
                                    }
                                    case ALLOWACCESSVALUE: {
                                        interfaceDetailsObj.setAllowAccess(value);
                                        break;
                                    }
                                    case IPVALUE: {
                                        interfaceDetailsObj.setIP(value);
                                        break;
                                    }
                                    case LOG: {
                                        interfaceDetailsObj.setLogging(value);
                                        break;
                                    }
                                    case STATUS: {
                                        interfaceDetailsObj.setStatus(value);
                                        break;
                                    }
                                    case TYPE: {
                                        interfaceDetailsObj.setType(value);
                                        break;
                                    }
                                    case MODE: {
                                        interfaceDetailsObj.setMode(value);
                                        break;
                                    }
                                    case ARPFORWARD: {
                                        interfaceDetailsObj.setArpForwardStatus(value);
                                        break;
                                    }
                                }
                            }
                        } else {
                            if (parserRuleType.equals("netObjGroupName")) {
                                FirewallGroupObject groupObj = null;
                                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                                    String value = resultMap.get((Object)key);
                                    if (key == FWAEnumConstants.ParserKeys.NETOBJGROUPNAME) {
                                        objName = value;
                                        continue;
                                    }
                                    if (key != FWAEnumConstants.ParserKeys.NETOBJGROUPDETECTIONSTRING) continue;
                                    if (this.netObjGroupDetectionStr == null) {
                                        this.netObjGroupDetectionStr = value;
                                        continue;
                                    }
                                    if (this.netObjGroupDetectionStr.equals(value)) continue;
                                    return false;
                                }
                                if (objName != null) {
                                    groupObj = this.netObjGroupMap.get(objName);
                                    if (groupObj == null) {
                                        groupObj = new FirewallGroupObject(objName);
                                        groupObj.setType("Network");
                                        this.netObjGroupMap.put(objName, groupObj);
                                        this.netObjList.add(objName);
                                    }
                                    this.currentGroupObject = groupObj;
                                    break;
                                }
                                return false;
                            }
                            if (parserRuleType.equals("netObjGroupElements")) {
                                FirewallGroupObject groupObj = this.currentGroupObject;
                                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                                    String value = resultMap.get((Object)key);
                                    if (key == FWAEnumConstants.ParserKeys.NETOBJGROUPCOMMENT) {
                                        groupObj.setComment(value);
                                        continue;
                                    }
                                    if (key != FWAEnumConstants.ParserKeys.MEMBERS) continue;
                                    groupObj.setMembers(value);
                                }
                                groupObj.setType("Network");
                                break;
                            }
                            if (parserRuleType.equals("staticNATObjGroupName")) {
                                FirewallGroupObject groupObj = null;
                                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                                    String value = resultMap.get((Object)key);
                                    if (key == FWAEnumConstants.ParserKeys.STATICNATOBJGROUPNAME) {
                                        objName = value;
                                        continue;
                                    }
                                    if (key != FWAEnumConstants.ParserKeys.STATICNATOBJGROUPDETECTIONSTRING) continue;
                                    if (this.staticNATObjGroupDetectionStr == null) {
                                        this.staticNATObjGroupDetectionStr = value;
                                        continue;
                                    }
                                    if (this.staticNATObjGroupDetectionStr.equals(value)) continue;
                                    return false;
                                }
                                if (objName != null) {
                                    groupObj = this.staticNATObjGroupMap.get(objName);
                                    if (groupObj == null) {
                                        groupObj = new FirewallGroupObject(objName);
                                        groupObj.setType("StaticNAT");
                                        this.staticNATObjGroupMap.put(objName, groupObj);
                                        this.staticNATObjList.add(objName);
                                    }
                                    this.currentGroupObject = groupObj;
                                    break;
                                }
                                return false;
                            }
                            if (parserRuleType.equals("staticNATObjGroupElements")) {
                                FirewallGroupObject groupObj = this.currentGroupObject;
                                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                                    String value = resultMap.get((Object)key);
                                    if (key == FWAEnumConstants.ParserKeys.INTERFACENAME) {
                                        groupObj.setInterfaceName(value);
                                        continue;
                                    }
                                    if (key != FWAEnumConstants.ParserKeys.MEMBERS) continue;
                                    groupObj.setMembers(value);
                                }
                                groupObj.setType("StaticNAT");
                                break;
                            }
                            if (parserRuleType.equals("serviceObjGroupName")) {
                                FirewallGroupObject groupObj = null;
                                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                                    String value = resultMap.get((Object)key);
                                    LOGGER.log(Level.FINER, "serviceObjGroupName:::::For attributes...the key is::" + (Object)((Object)key) + " and the val is::" + value);
                                    if (key == FWAEnumConstants.ParserKeys.SERVICEOBJGROUPNAME) {
                                        objName = value;
                                        continue;
                                    }
                                    if (key != FWAEnumConstants.ParserKeys.SERVICEOBJGROUPDETECTIONSTRING) continue;
                                    if (this.serviceObjGroupDetectionStr == null) {
                                        this.serviceObjGroupDetectionStr = value;
                                        continue;
                                    }
                                    if (this.serviceObjGroupDetectionStr.equals(value)) continue;
                                    return false;
                                }
                                if (objName != null) {
                                    groupObj = this.serviceObjGroupMap.get(objName);
                                    if (groupObj == null) {
                                        groupObj = new FirewallGroupObject(objName);
                                        groupObj.setType("Service");
                                        this.serviceObjGroupMap.put(objName, groupObj);
                                    }
                                    this.currentGroupObject = groupObj;
                                    break;
                                }
                                LOGGER.log(Level.FINER, "No serviceObjGroupName...hence returning false..");
                                return false;
                            }
                            if (parserRuleType.equals("serviceObjGroupElements")) {
                                FirewallGroupObject groupObj = this.currentGroupObject;
                                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                                    String value = resultMap.get((Object)key);
                                    if (key == FWAEnumConstants.ParserKeys.SERVICEOBJGROUPCOMMENT) {
                                        groupObj.setComment(value);
                                        continue;
                                    }
                                    if (key != FWAEnumConstants.ParserKeys.MEMBERS) continue;
                                    groupObj.setMembers(value);
                                }
                                groupObj.setType("Service");
                                break;
                            }
                            if (parserRuleType.equals("ruleObjName")) {
                                if (this.currentRuleObject != null && !this.duplicateRuleObj) {
                                    Vector<RuleObject> ruleObjList = (Vector<RuleObject>)this.policyObjMap.remove(this.currentPolicyName);
                                    if (ruleObjList == null) {
                                        ruleObjList = new Vector<RuleObject>();
                                    }
                                    ruleObjList.add(this.currentRuleObject);
                                    this.policyObjMap.put(this.currentPolicyName, ruleObjList);
                                }
                                RuleObject ruleObj = null;
                                for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                                    String value = resultMap.get((Object)key);
                                    if (key == FWAEnumConstants.ParserKeys.RULENAME) {
                                        objName = value;
                                        continue;
                                    }
                                    if (key != FWAEnumConstants.ParserKeys.RULEDETECTIONSTRING) continue;
                                    if (this.ruleObjDetectionStr == null) {
                                        this.ruleObjDetectionStr = value;
                                        continue;
                                    }
                                    if (this.ruleObjDetectionStr.equals(value)) continue;
                                    this.duplicateRuleObj = true;
                                    return false;
                                }
                                if (objName != null) {
                                    ruleObj = new RuleObject();
                                    ruleObj.setName(objName);
                                    this.currentRuleObject = ruleObj;
                                    this.duplicateRuleObj = false;
                                    LOGGER.log(Level.FINER, "the current ruleobj name is:::" + this.currentRuleObject.getName());
                                    break;
                                }
                                return false;
                            }
                            if (!parserRuleType.equals("ruleObjElements")) break;
                            RuleObject ruleObj = this.currentRuleObject;
                            for (FWAEnumConstants.ParserKeys key : resultMap.keySet()) {
                                String value = resultMap.get((Object)key);
                                switch (key) {
                                    case SRCINT: {
                                        ruleObj.setSrcInt(value);
                                        break;
                                    }
                                    case DSTINT: {
                                        ruleObj.setDstInt(value);
                                        break;
                                    }
                                    case SRCADDR: {
                                        ruleObj.setSrcAddr(value);
                                        break;
                                    }
                                    case DSTADDR: {
                                        ruleObj.setDstAddr(value);
                                        break;
                                    }
                                    case SERVICE: {
                                        String service = ruleObj.getService();
                                        service = service != null ? service + " " + value : value;
                                        ruleObj.setService(value);
                                        break;
                                    }
                                    case ACTION: {
                                        ruleObj.setAction(value);
                                        break;
                                    }
                                    case STATUS: {
                                        ruleObj.setStatus(value);
                                        break;
                                    }
                                    case SCHEDULE: {
                                        String schedule = ruleObj.getSchedule();
                                        schedule = schedule != null ? schedule + "," + value : value;
                                        ruleObj.setSchedule(schedule);
                                        break;
                                    }
                                    case SCHEDULE_TIMEOUT: {
                                        ruleObj.setScheduleTimeout(value);
                                        break;
                                    }
                                    case UTM_STATUS: {
                                        String utmStatus = ruleObj.getUTMStatus();
                                        utmStatus = utmStatus != null ? utmStatus + "," + value : value;
                                        ruleObj.setUTMStatus(utmStatus);
                                        break;
                                    }
                                    case TRAFFIC_SHAPER: {
                                        ruleObj.setTrafficShaper(value);
                                        break;
                                    }
                                    case NAT_STATUS: {
                                        ruleObj.setNATStatus(value);
                                        break;
                                    }
                                    case LOG: {
                                        String log = ruleObj.getLog();
                                        log = log != null ? log + "," + value : value;
                                        ruleObj.setLog(log);
                                        break;
                                    }
                                    case USER_GROUP: {
                                        ruleObj.setUserGroup(value);
                                        break;
                                    }
                                    case RULECOMMENT: {
                                        ruleObj.setRuleComment(value);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            break;
        }
        return patternMatched;
    }

    private String getProcessedValue(String value) {
        value = value.trim();
        String[] valArr = value.split(" ");
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        Matcher mat = null;
        for (String tmpVal : valArr) {
            if (tmpVal.indexOf(":") > 0) {
                mat = this.serviceObjsrcAndDstPortExtractPattern.matcher(tmpVal);
                if (mat.find()) {
                    sb.append("srcPort=");
                    sb.append(mat.group(1));
                    if (mat.group(2) != null) {
                        sb.append(" to ");
                        sb.append(mat.group(3));
                    }
                    sb.append(",");
                    sb.append("dstPort=");
                    sb.append(mat.group(4));
                    if (mat.group(5) != null) {
                        sb.append(" to ");
                        sb.append(mat.group(6));
                    }
                }
            } else if (tmpVal.indexOf("-") > 0) {
                String[] rangePorts = tmpVal.split("-");
                sb.append("dstPort=");
                sb.append(rangePorts[0]);
                sb.append(" to ");
                sb.append(rangePorts[1]);
            } else {
                sb.append("dstPort=");
                sb.append(tmpVal);
            }
            sb.append(" and ");
        }
        return sb.substring(0, sb.lastIndexOf(" and "));
    }

    private boolean matchObjStartPattern(String data, String expression, Pattern pattern) throws Exception {
        Matcher m;
        if (pattern == null && expression != null) {
            pattern = Pattern.compile(expression);
        }
        if ((m = pattern.matcher(data)).find()) {
            String result = m.group(1);
            return result == null || !(result = result.trim()).equals("group");
        }
        LOGGER.log(Level.FINER, " FAILED Expression :: {0}", expression);
        return false;
    }

    @Override
    public void processResultsAndPopulateIntoDB(Long rID, String deviceType, String resourceName) {
        try {
            DataObject doo = DataAccess.constructDataObject();
            this.populateInterfaceDetailsIntoDB(rID, this.interfaceDetailsObjMap, deviceType, resourceName);
            this.populateNetworkObjectsDataIntoDB(doo, rID, this.netObjMap, deviceType, resourceName);
            this.populateStaticNATObjectsDataIntoDB(doo, rID, this.staticNATObjMap, deviceType, resourceName);
            this.populateServiceObjectsDataIntoDB(doo, rID, this.serviceObjMap, deviceType, resourceName);
            DataAccess.add((DataObject)doo);
            doo = DataAccess.constructDataObject();
            this.populateObjectsGroup(doo, this.netObjGroupMap, rID, deviceType, resourceName, "Network");
            this.populateObjectsGroup(doo, this.staticNATObjGroupMap, rID, deviceType, resourceName, "StaticNAT");
            this.populateObjectsGroup(doo, this.serviceObjGroupMap, rID, deviceType, resourceName, "Service");
            DataAccess.add((DataObject)doo);
            this.populatePolicyInfoIntoDB(this.policyObjMap, rID, deviceType, resourceName);
            doo = DataAccess.constructDataObject();
            this.populateRuleInfoIntoDB(doo, this.policyObjMap, rID, deviceType, resourceName);
            DataAccess.add((DataObject)doo);
            LOGGER.log(Level.INFO, " ### Services for which ports are not resolved ### " + this.unknownPorts);
            this.policyProcessorUtilityObject.updateObjectsWithUsageInfo(rID, deviceType, resourceName, this.usedObjects);
            this.policyProcessorUtilityObject.updateInterfaceDetailsWithUsageInfo(rID, deviceType, resourceName, this.usedInterfaces);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void populatePolicyInfoIntoDB(LinkedHashMap<String, Vector<RuleObject>> policyObjMap, Long rID, String deviceType, String resourceName) throws Exception {
        try {
            LOGGER.fine("populating Policy Details...");
            DataObject dObj = DataAccess.constructDataObject();
            for (String policyName : policyObjMap.keySet()) {
                Row policyDetailsRow = new Row("PolicyDetails");
                policyDetailsRow.set("POLICYNAME", (Object)policyName);
                policyDetailsRow.set("RID", (Object)rID);
                LOGGER.log(Level.FINE, " FortiGatePolicyProcessor :::: PolicyDetails ROW is :::::::: {0} ", policyDetailsRow);
                dObj.addRow(policyDetailsRow);
            }
            DataAccess.add((DataObject)dObj);
            this.policyProcessorUtilityObject.updatePolicyDetailsMap(dObj, rID, resourceName, this.policyNameVsIDMap);
        }
        catch (Exception exp) {
            throw new Exception("Problem while populating Policy Details into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateRuleInfoIntoDB(DataObject doo, LinkedHashMap<String, Vector<RuleObject>> policyObjMap, Long rID, String deviceType, String resourceName) throws Exception {
        RuleObject currentRuleObj = null;
        HashSet<String> srcUnResolved = new HashSet<String>();
        HashSet<String> dstUnResolved = new HashSet<String>();
        HashSet<String> serviceUnResolved = new HashSet<String>();
        try {
            LOGGER.fine("populating Rule Details...");
            String temp = null;
            HashMap<String, HashSet<String>> protoVsSRCPortSet = new HashMap<String, HashSet<String>>();
            HashMap<String, HashSet<String>> protoVsDSTPortSet = new HashMap<String, HashSet<String>>();
            HashSet serviceSet = new HashSet();
            HashSet<String> protoSetFromService = new HashSet<String>();
            LOGGER.log(Level.FINER, "policyObjMap is:::" + policyObjMap);
            for (Map.Entry<String, Vector<RuleObject>> entry : policyObjMap.entrySet()) {
                String policyObjName = entry.getKey();
                Long policyID = this.policyNameVsIDMap.get(policyObjName);
                if (policyID == null) {
                    Criteria policyIDCrit = new Criteria(new Column("PolicyDetails", "RID"), (Object)rID, 0);
                    DataObject dObj = DataAccess.get((String)"PolicyDetails", (Criteria)(policyIDCrit = policyIDCrit.and(new Criteria(new Column("PolicyDetails", "POLICYNAME"), (Object)policyObjName, 0))));
                    if (!dObj.isEmpty()) {
                        policyID = (Long)dObj.getFirstValue("PolicyDetails", "POLICYID");
                    }
                }
                Vector<RuleObject> ruleObjList = entry.getValue();
                if (policyID == null) continue;
                Iterator<RuleObject> i$ = ruleObjList.iterator();
                while (i$.hasNext()) {
                    String status;
                    RuleObject ruleObj;
                    currentRuleObj = ruleObj = i$.next();
                    protoSetFromService.clear();
                    this.hasUnknownPorts = false;
                    this.unResolvedObjectsSet.clear();
                    srcUnResolved.clear();
                    dstUnResolved.clear();
                    serviceUnResolved.clear();
                    String[] srcDetails = null;
                    String[] dstDetails = null;
                    String[] serviceDetails = null;
                    Row ruleDetailsRow = new Row("RuleDetails");
                    ruleDetailsRow.set("RID", (Object)rID);
                    ruleDetailsRow.set("POLICYID", (Object)policyID);
                    ruleDetailsRow.set("RULENAME", (Object)ruleObj.getName());
                    String src = ruleObj.getSrcAddr();
                    if (src != null) {
                        String unQuoteSRC = this.getUnQuoteVal(src = src.trim());
                        if (this.policyProcessorUtilityObject.anyList.contains(unQuoteSRC.toLowerCase())) {
                            ruleDetailsRow.set("RULE_SRC", (Object)"Any");
                            ruleDetailsRow.set("DETAILED_SRC", (Object)"Any");
                            ruleDetailsRow.set("SRCID_RANGE", (Object)"Any");
                            ruleDetailsRow.set("GROUPED_SRCID", (Object)"Any");
                        } else {
                            srcDetails = this.getMembersRelatedInfoForDB(src, rID, "Network", true);
                            if (srcDetails != null) {
                                String ipIDRangeStr;
                                ruleDetailsRow.set("RULE_SRC", (Object)srcDetails[0]);
                                temp = srcDetails[1];
                                ruleDetailsRow.set("DETAILED_SRC", (Object)temp);
                                if (temp != null) {
                                    temp = temp.replace("<br>", "\n");
                                    temp = temp.replace("&nbsp;", " ");
                                }
                                if ((ipIDRangeStr = srcDetails[5]) != null && !"null".equals(ipIDRangeStr) && !"".equals(ipIDRangeStr.trim())) {
                                    ruleDetailsRow.set("GROUPED_SRCID", (Object)this.policyProcessorUtilityObject.toGroup(ipIDRangeStr));
                                }
                                ruleDetailsRow.set("SRCID_RANGE", (Object)ipIDRangeStr);
                                ruleDetailsRow.set("GROUPED_SRCID", (Object)this.policyProcessorUtilityObject.toGroup(ipIDRangeStr));
                            }
                        }
                    }
                    srcUnResolved.addAll((HashSet)this.unResolvedObjectsSet.clone());
                    this.unResolvedObjectsSet.clear();
                    String dst = ruleObj.getDstAddr();
                    if (dst != null) {
                        String unQuoteDst = this.getUnQuoteVal(dst = dst.trim());
                        if (this.policyProcessorUtilityObject.anyList.contains(unQuoteDst.toLowerCase())) {
                            ruleDetailsRow.set("RULE_DST", (Object)"Any");
                            ruleDetailsRow.set("DETAILED_DST", (Object)"Any");
                            ruleDetailsRow.set("DSTID_RANGE", (Object)"Any");
                            ruleDetailsRow.set("GROUPED_DSTID", (Object)"all");
                        } else {
                            dstDetails = this.getMembersRelatedInfoForDB(dst, rID, "Network", true);
                            if (dstDetails != null) {
                                String ipIDRangeStr;
                                ruleDetailsRow.set("RULE_DST", (Object)dstDetails[0]);
                                temp = dstDetails[1];
                                ruleDetailsRow.set("DETAILED_DST", (Object)temp);
                                if (temp != null) {
                                    temp = temp.replace("<br>", "\n");
                                    temp = temp.replace("&nbsp;", " ");
                                }
                                if ((ipIDRangeStr = dstDetails[5]) != null && !"null".equals(ipIDRangeStr) && !"".equals(ipIDRangeStr.trim())) {
                                    ruleDetailsRow.set("GROUPED_DSTID", (Object)this.policyProcessorUtilityObject.toGroup(ipIDRangeStr));
                                }
                                ruleDetailsRow.set("DSTID_RANGE", (Object)ipIDRangeStr);
                            }
                        }
                    }
                    dstUnResolved.addAll((HashSet)this.unResolvedObjectsSet.clone());
                    this.unResolvedObjectsSet.clear();
                    String sInt = ruleObj.getSrcInt();
                    ruleDetailsRow.set("SRC_INT", (Object)sInt);
                    this.usedInterfaces.add(this.getAliasName(sInt));
                    String dInt = ruleObj.getDstInt();
                    ruleDetailsRow.set("DST_INT", (Object)dInt);
                    this.usedInterfaces.add(this.getAliasName(dInt));
                    if (this.hasInterfaceVsZoneMap) {
                        String srcZone = this.interfaceVsZoneMap.get(sInt);
                        ruleDetailsRow.set("SRC_ZONE", (Object)srcZone);
                        String dstZone = this.interfaceVsZoneMap.get(dInt);
                        ruleDetailsRow.set("DST_ZONE", (Object)dstZone);
                        String direction = "WAN".equals(srcZone) ? "inbound" : ("WAN".equals(dstZone) ? "outbound" : null);
                        ruleDetailsRow.set("DIRECTION", (Object)direction);
                    }
                    if (src != null && dst != null) {
                        src = src.replace("\"", "");
                        src = src.trim();
                        dst = dst.replace("\"", "");
                        dst = dst.trim();
                        if (this.policyProcessorUtilityObject.anyList.contains(src.trim().toLowerCase())) {
                            ruleDetailsRow.set("RULE_SRC", (Object)"Any");
                            ruleDetailsRow.set("DETAILED_SRC", (Object)"Any");
                        }
                        if (this.policyProcessorUtilityObject.anyList.contains(dst.trim().toLowerCase())) {
                            ruleDetailsRow.set("RULE_DST", (Object)"Any");
                            ruleDetailsRow.set("DETAILED_DST", (Object)"Any");
                        }
                    }
                    status = "disable".equals(status = ruleObj.getStatus()) ? "No" : "Yes";
                    ruleDetailsRow.set("RULE_STATUS", (Object)status);
                    String ruleAction = ruleObj.getAction();
                    String protoInfo = this.policyProcessorUtilityObject.convertHashSetToString(protoSetFromService);
                    protoInfo = protoInfo != null ? protoInfo : "Any";
                    ruleDetailsRow.set("PROTOCOL", (Object)protoInfo);
                    String service = ruleObj.getService();
                    if (service != null) {
                        String unQuoteService = this.getUnQuoteVal(service = service.trim());
                        if (this.policyProcessorUtilityObject.anyList.contains(unQuoteService.toLowerCase())) {
                            ruleDetailsRow.set("SERVICE", (Object)"Any");
                            ruleDetailsRow.set("DETAILED_SERVICE", (Object)"Any");
                            ruleDetailsRow.set("PORT_INFO", (Object)"Any:dstPort=Any#srcPort=Any#");
                            ruleDetailsRow.set("GROUPED_PORTS", (Object)"Any:dstPort=Any#srcPort=Any#");
                            temp = "Any";
                        } else {
                            serviceDetails = this.getMembersRelatedInfoForDB(service, rID, "Service", true);
                            String tempService = serviceDetails[0];
                            ruleDetailsRow.set("SERVICE", (Object)tempService);
                            temp = serviceDetails[1];
                            temp = temp.trim();
                            String unQuoteVal = this.getUnQuoteVal(temp);
                            if (this.policyProcessorUtilityObject.anyList.contains(unQuoteVal.toLowerCase())) {
                                ruleDetailsRow.set("DETAILED_SERVICE", (Object)"Any");
                                ruleDetailsRow.set("PORT_INFO", (Object)"Any:dstPort=Any#srcPort=Any#");
                                ruleDetailsRow.set("GROUPED_PORTS", (Object)"Any:dstPort=Any#srcPort=Any#");
                            } else {
                                ruleDetailsRow.set("DETAILED_SERVICE", (Object)temp);
                                if (temp != null) {
                                    temp = temp.replace("<br>", "\n");
                                    temp = temp.replace("&nbsp;", " ");
                                }
                                String port_info = this.extractPortInfo(service, temp, protoVsSRCPortSet, protoVsDSTPortSet, resourceName, "FortiGate", false, protoSetFromService);
                                ruleDetailsRow.set("PORT_INFO", (Object)port_info);
                                if (!this.hasUnknownPorts) {
                                    ruleDetailsRow.set("GROUPED_PORTS", (Object)this.policyProcessorUtilityObject.portGroup(port_info));
                                }
                            }
                        }
                        String cklServices = null;
                        if (!"deny".equals(ruleAction) && "Yes".equals(status)) {
                            try {
                                cklServices = this.policyProcessorUtilityObject.getAllowedChecklistServices((String)ruleDetailsRow.get("PORT_INFO"));
                                ruleDetailsRow.set("CHECKLIST_SERVICE", (Object)cklServices);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    serviceUnResolved.addAll((HashSet)this.unResolvedObjectsSet.clone());
                    this.unResolvedObjectsSet.clear();
                    String unResolvedObjects = this.policyProcessorUtilityObject.getFinalUnResolvedObjs(srcUnResolved, dstUnResolved, serviceUnResolved);
                    ruleDetailsRow.set("UNRESOLVED_OBJECTS", (Object)unResolvedObjects);
                    ruleDetailsRow.set("LOG", (Object)ruleObj.getLog());
                    if (ruleAction == null) {
                        unResolvedObjects = unResolvedObjects != null && !"".equals(unResolvedObjects) ? unResolvedObjects + ",@@@No Action" : "No Action";
                        ruleDetailsRow.set("UNRESOLVED_OBJECTS", (Object)unResolvedObjects);
                    }
                    ruleDetailsRow.set("ACTION", (Object)ruleAction);
                    ruleDetailsRow.set("NAT", (Object)ruleObj.getNATStatus());
                    ruleDetailsRow.set("UTM", (Object)ruleObj.getUTMStatus());
                    ruleDetailsRow.set("SCHEDULE", (Object)ruleObj.getSchedule());
                    ruleDetailsRow.set("SCHEDULE_TIMEOUT", (Object)ruleObj.getScheduleTimeout());
                    ruleDetailsRow.set("TRAFFIC_SHAPER", (Object)ruleObj.getTrafficShaper());
                    String userGroup = ruleObj.getUserGroup();
                    if (userGroup != null) {
                        String[] userGroupArray = userGroup.split(" ");
                        int userGroupCount = userGroupArray.length;
                        userGroup = null;
                        StringBuffer userGroupBuffer = new StringBuffer();
                        for (int i = 0; i < userGroupCount; ++i) {
                            userGroup = userGroupArray[i];
                            userGroup = userGroup.replace("\"", "");
                            userGroup = userGroup.trim();
                            userGroupBuffer.append(userGroup);
                            if (i >= userGroupCount - 1) continue;
                            userGroupBuffer.append(",");
                        }
                        userGroup = userGroupBuffer.toString();
                    }
                    ruleDetailsRow.set("USER_GROUP", (Object)userGroup);
                    ruleDetailsRow.set("AUTHETICATION", (Object)userGroup);
                    ruleDetailsRow.set("COMMENTS", (Object)ruleObj.getRuleComment());
                    if (this.isInDebugMode) {
                        String tempSrcInt = (String)ruleDetailsRow.get("SRC_INT");
                        String tempDstInt = (String)ruleDetailsRow.get("DST_INT");
                        if (tempDstInt == null || "".equals(tempDstInt.trim())) {
                            this.unFoundDstInterfaceSet.add((String)ruleDetailsRow.get("RULE_DST"));
                        }
                        if (tempSrcInt == null || "".equals(tempSrcInt.trim())) {
                            this.unFoundSrcInterfaceSet.add((String)ruleDetailsRow.get("RULE_SRC"));
                        }
                    }
                    String srcVal = (String)ruleDetailsRow.get("RULE_SRC");
                    String dstVal = (String)ruleDetailsRow.get("RULE_DST");
                    String serviceVal = (String)ruleDetailsRow.get("SERVICE");
                    String unResolvedVal = (String)ruleDetailsRow.get("UNRESOLVED_OBJECTS");
                    if ("Any".equals(srcVal) || "All".equals(srcVal)) {
                        ruleDetailsRow.set("ANY_SRC", (Object)Boolean.TRUE);
                    }
                    if ("Any".equals(dstVal) || "All".equals(dstVal)) {
                        ruleDetailsRow.set("ANY_DST", (Object)Boolean.TRUE);
                    }
                    if ("Any".equals(serviceVal) || "All".equals(serviceVal) || "Any TCP".equals(serviceVal) || "Any UDP".equals(serviceVal)) {
                        ruleDetailsRow.set("ANY_SERVICE", (Object)Boolean.TRUE);
                    }
                    if (unResolvedVal != null && !"".equals(unResolvedVal.trim())) {
                        ruleDetailsRow.set("IS_UNRESOLVED_DATA", (Object)Boolean.TRUE);
                    }
                    LOGGER.log(Level.FINE, " FortigatePolicyProcessor :::: RuleDetails ROW is :::::::: {0} ", ruleDetailsRow);
                    Object object = this.policyProcessorUtilityObject.ruleDetailsAutoGenKeyLock;
                    synchronized (object) {
                        DataAccess.generateValues((Row)ruleDetailsRow);
                    }
                    doo.addRow(ruleDetailsRow);
                    String[] srcGrps = null;
                    String[] dstGrps = null;
                    String[] serviceGrps = null;
                    int srcGrpLen = 1;
                    int dstGrpLen = 1;
                    int serviceGrpLen = 1;
                    if (srcDetails != null) {
                        String srcGrpStr = srcDetails[0];
                        srcGrps = srcGrpStr.split("<br>");
                        srcGrpLen = srcGrps.length;
                    }
                    if (dstDetails != null) {
                        String dstGrpStr = dstDetails[0];
                        dstGrps = dstGrpStr.split("<br>");
                        dstGrpLen = dstGrps.length;
                    }
                    if (serviceDetails != null) {
                        String serviceGrpStr = serviceDetails[0];
                        serviceGrps = serviceGrpStr.split("<br>");
                        serviceGrpLen = serviceGrps.length;
                    }
                    int maxLength = srcGrpLen > dstGrpLen ? (srcGrpLen > serviceGrpLen ? srcGrpLen : serviceGrpLen) : (dstGrpLen > serviceGrpLen ? dstGrpLen : serviceGrpLen);
                    Object ruleID = ruleDetailsRow.get("RULEID");
                    LOGGER.log(Level.FINER, "the ruleID from doo is::::" + ruleID);
                    String srcElement = null;
                    String dstElement = null;
                    String serviceElement = null;
                    for (int k = 0; k < maxLength; ++k) {
                        Row ruleVsDetailsRow = new Row("RuleToObjOneToNMapping");
                        ruleVsDetailsRow.set("RULEID", ruleID);
                        if (k < srcGrpLen) {
                            if (srcGrpLen == 1 && srcGrps == null) {
                                ruleVsDetailsRow.set("RULE_SRC", (Object)"Any");
                            } else {
                                srcElement = srcGrps[k];
                                ruleVsDetailsRow.set("RULE_SRC", (Object)srcElement);
                            }
                        }
                        if (k < dstGrpLen) {
                            if (dstGrpLen == 1 && dstGrps == null) {
                                ruleVsDetailsRow.set("RULE_DST", (Object)"Any");
                            } else {
                                dstElement = dstGrps[k];
                                ruleVsDetailsRow.set("RULE_DST", (Object)dstElement);
                            }
                        }
                        if (k < serviceGrpLen) {
                            if (serviceGrpLen == 1 && serviceGrps == null) {
                                ruleVsDetailsRow.set("SERVICE", (Object)"Any");
                            } else {
                                serviceElement = serviceGrps[k];
                                ruleVsDetailsRow.set("SERVICE", (Object)serviceElement);
                            }
                        }
                        Object object2 = this.policyProcessorUtilityObject.ruleObjMappingAutoGenKeyLock;
                        synchronized (object2) {
                            DataAccess.generateValues((Row)ruleVsDetailsRow);
                        }
                        doo.addRow(ruleVsDetailsRow);
                    }
                }
            }
        }
        catch (Exception exp) {
            this.policyProcessorUtilityObject.printRuleObjDetails(currentRuleObj);
            throw new Exception("Problem while populating Rule Details into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
        }
    }

    private String getUnQuoteVal(String val) {
        return val.replace("\"", "");
    }

    private String extractPortInfo(String service, String detailedService, HashMap<String, HashSet<String>> protoVsSRCPortSet, HashMap<String, HashSet<String>> protoVsDSTPortSet, String resourceName, String deviceType, boolean ignoreConstruct, HashSet<String> protoSetFromService) throws Exception {
        protoVsSRCPortSet.clear();
        protoVsDSTPortSet.clear();
        try {
            if (detailedService != null && !"".equals(detailedService)) {
                String[] memberArray;
                int matchedpatternIndex = -1;
                ArrayList matcherInfo = null;
                Pattern portSplit = Pattern.compile("([^\\s]*)( to ([^.]*))?");
                String currentProtocol = null;
                for (String member : memberArray = detailedService.split("\n")) {
                    if ((member = member.trim()).indexOf("(") > 0) {
                        member = this.getDataFromBracket(member);
                    }
                    String[] protocolPortsArray = member.split("\\|_\\|");
                    ArrayList<String> protocolPortsList = new ArrayList<String>(Arrays.asList(protocolPortsArray));
                    for (String protocolPortData : protocolPortsList) {
                        String[] protocolMemberElements;
                        protocolPortData = protocolPortData.trim();
                        for (String protocolMemberElement : protocolMemberElements = protocolPortData.split(" and ")) {
                            matcherInfo = this.getTheMatchedPattern(protocolMemberElement);
                            if (matcherInfo != null) {
                                String protoService;
                                HashSet<String> tempDSTPortSet;
                                HashSet<String> tempDSTPortSet2;
                                matchedpatternIndex = (Integer)matcherInfo.get(0);
                                Matcher mat = (Matcher)matcherInfo.get(1);
                                String protocol = mat.group(1);
                                if (protocol != null) {
                                    protocol = protocol.trim().toUpperCase();
                                    protoSetFromService.add(protocol);
                                    currentProtocol = protocol;
                                }
                                String srcPortInfo = null;
                                String dstPortInfo = null;
                                if (matchedpatternIndex == 1) {
                                    String portNumber;
                                    Matcher m;
                                    srcPortInfo = mat.group(2);
                                    dstPortInfo = mat.group(3);
                                    if (srcPortInfo != null) {
                                        if (this.policyProcessorUtilityObject.anyList.contains((srcPortInfo = srcPortInfo.trim()).toLowerCase())) {
                                            srcPortInfo = "1-65535";
                                        } else {
                                            m = portSplit.matcher(srcPortInfo);
                                            m.find();
                                            srcPortInfo = !this.policyProcessorUtilityObject.isDigit(m.group(1)) ? (portNumber = this.getPortNumber(m.group(1), currentProtocol)) : m.group(1);
                                            if (m.group(3) != null) {
                                                srcPortInfo = !this.policyProcessorUtilityObject.isDigit(m.group(3)) ? ((portNumber = this.getPortNumber(m.group(3), currentProtocol)) != null ? srcPortInfo + "-" + portNumber : portNumber) : srcPortInfo + "-" + m.group(3);
                                            }
                                        }
                                        HashSet<String> tempSRCPortSet = protoVsSRCPortSet.get(currentProtocol);
                                        if (tempSRCPortSet == null) {
                                            tempSRCPortSet = new HashSet();
                                        }
                                        tempSRCPortSet.add(srcPortInfo);
                                        protoVsSRCPortSet.put(currentProtocol, tempSRCPortSet);
                                    }
                                    if (dstPortInfo == null) continue;
                                    if (this.policyProcessorUtilityObject.anyList.contains((dstPortInfo = dstPortInfo.trim()).toLowerCase())) {
                                        dstPortInfo = "1-65535";
                                    } else {
                                        m = portSplit.matcher(dstPortInfo);
                                        m.find();
                                        dstPortInfo = !this.policyProcessorUtilityObject.isDigit(m.group(1)) ? (portNumber = this.getPortNumber(m.group(1), currentProtocol)) : m.group(1);
                                        if (m.group(3) != null) {
                                            dstPortInfo = !this.policyProcessorUtilityObject.isDigit(m.group(3)) ? ((portNumber = this.getPortNumber(m.group(3), currentProtocol)) != null ? dstPortInfo + "-" + portNumber : portNumber) : dstPortInfo + "-" + m.group(3);
                                        }
                                    }
                                    tempDSTPortSet2 = protoVsDSTPortSet.get(currentProtocol);
                                    if (tempDSTPortSet2 == null) {
                                        tempDSTPortSet2 = new HashSet();
                                    }
                                    tempDSTPortSet2.add(dstPortInfo);
                                    protoVsDSTPortSet.put(currentProtocol, tempDSTPortSet2);
                                    continue;
                                }
                                if (matchedpatternIndex == 2) {
                                    String icmpType = mat.group(2);
                                    String icmpCode = mat.group(3);
                                    dstPortInfo = icmpType.trim();
                                    dstPortInfo = this.getPortNumber(dstPortInfo, "ICMP");
                                    if (icmpCode != null) {
                                        icmpCode = icmpCode.trim();
                                        dstPortInfo = dstPortInfo + "/" + icmpCode;
                                    }
                                    if ((tempDSTPortSet2 = protoVsDSTPortSet.get(currentProtocol)) == null) {
                                        tempDSTPortSet2 = new HashSet();
                                    }
                                    tempDSTPortSet2.add(dstPortInfo);
                                    protoVsDSTPortSet.put(currentProtocol, tempDSTPortSet2);
                                    continue;
                                }
                                if (matchedpatternIndex == 3) {
                                    Pattern isTCPUDPSCTPAnyPattern = Pattern.compile("Any\\s+(TCP|UDP|SCTP)");
                                    Matcher matcher = isTCPUDPSCTPAnyPattern.matcher(protocolMemberElement);
                                    if (matcher.matches()) {
                                        HashSet<String> tempSRCPortSet = protoVsSRCPortSet.get(currentProtocol);
                                        if (tempSRCPortSet == null) {
                                            tempSRCPortSet = new HashSet();
                                        }
                                        tempSRCPortSet.add("1-65535");
                                        protoVsSRCPortSet.put(currentProtocol, tempSRCPortSet);
                                        tempDSTPortSet = protoVsDSTPortSet.get(currentProtocol);
                                        if (tempDSTPortSet == null) {
                                            tempDSTPortSet = new HashSet();
                                        }
                                        tempDSTPortSet.add("1-65535");
                                        protoVsDSTPortSet.put(currentProtocol, tempDSTPortSet);
                                        continue;
                                    }
                                    HashSet<String> tempDSTPortSet3 = protoVsDSTPortSet.get(currentProtocol);
                                    if (tempDSTPortSet3 == null) {
                                        tempDSTPortSet3 = new HashSet();
                                    }
                                    tempDSTPortSet3.add("Any");
                                    protoVsDSTPortSet.put(currentProtocol, tempDSTPortSet3);
                                    continue;
                                }
                                if (matchedpatternIndex == 4) {
                                    protoService = mat.group(2);
                                    tempDSTPortSet2 = protoVsDSTPortSet.get(currentProtocol);
                                    if (tempDSTPortSet2 == null) {
                                        tempDSTPortSet2 = new HashSet();
                                    }
                                    if (protoService != null) {
                                        protoService = protoService.trim();
                                        tempDSTPortSet2.add(protoService);
                                    }
                                    protoVsDSTPortSet.put(currentProtocol, tempDSTPortSet2);
                                    continue;
                                }
                                if (matchedpatternIndex != 5) continue;
                                protoService = mat.group(1);
                                HashMap serviceMap = this.getServiceDetails(protoService);
                                if (serviceMap != null) {
                                    for (String key : serviceMap.keySet()) {
                                        tempDSTPortSet = protoVsDSTPortSet.get(key);
                                        if (tempDSTPortSet == null) {
                                            tempDSTPortSet = new HashSet();
                                        }
                                        tempDSTPortSet.addAll((Collection)serviceMap.get(key));
                                        protoVsDSTPortSet.put(key, tempDSTPortSet);
                                    }
                                    continue;
                                }
                                this.hasUnknownPorts = true;
                                this.unResolvedObjectsSet.add(protoService);
                                this.unknownPorts.add(protoService);
                                return "";
                            }
                            throw new Exception("Problem while matching the portExtract Patterns for the line:::" + protocolPortData + " of service object::: " + service + " that have the data as:::" + detailedService + " for the firewall::: " + resourceName + " of Fortigate Vendor..");
                        }
                    }
                }
                if (!ignoreConstruct) {
                    HashSet<String> dstPortSet = null;
                    HashSet<String> srcPortSet = null;
                    String completePortInfo = null;
                    StringBuilder servicePortBuilder = new StringBuilder();
                    StringBuilder protocolPortBuilder = new StringBuilder();
                    String tempValue = null;
                    for (String proto : protoVsDSTPortSet.keySet()) {
                        dstPortSet = protoVsDSTPortSet.get(proto);
                        srcPortSet = protoVsSRCPortSet.remove(proto);
                        completePortInfo = this.constructProtocolSpecificPorts(dstPortSet, srcPortSet, protocolPortBuilder, tempValue);
                        servicePortBuilder.append(proto);
                        servicePortBuilder.append(":");
                        servicePortBuilder.append(completePortInfo);
                        servicePortBuilder.append("&&");
                    }
                    for (String proto : protoVsSRCPortSet.keySet()) {
                        srcPortSet = protoVsSRCPortSet.get(proto);
                        completePortInfo = this.constructProtocolSpecificPorts(null, srcPortSet, protocolPortBuilder, tempValue);
                        servicePortBuilder.append(proto);
                        servicePortBuilder.append(":");
                        servicePortBuilder.append(completePortInfo);
                        servicePortBuilder.append("&&");
                    }
                    return this.policyProcessorUtilityObject.removeLastDelimeter(servicePortBuilder, "&&");
                }
                return "";
            }
            this.hasUnknownPorts = true;
            this.unResolvedObjectsSet.add(service);
            this.unknownPorts.add(service);
            return "";
        }
        catch (Exception ee) {
            throw new Exception("Problem while matching the portExtract Patterns for the service object " + service + " having the data:: " + detailedService + " for the firewall::: " + resourceName + " of " + deviceType + " Vendor..", ee);
        }
    }

    private HashMap getServiceDetails(String defaultService) {
        HashMap<String, HashSet<String>> serviceMap = null;
        String upperService = defaultService.toUpperCase();
        if (this.serviceToPortMap.containsKey(upperService)) {
            String toReturn = this.serviceToPortMap.get(upperService);
            HashMap<String, HashSet<String>> tt1 = new HashMap<String, HashSet<String>>();
            serviceMap = new HashMap<String, HashSet<String>>();
            HashSet<String> tt3 = new HashSet<String>();
            try {
                this.extractPortInfo(upperService, toReturn, tt1, serviceMap, this.resourceName, "Fortigate", true, tt3);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return null;
        }
        return serviceMap;
    }

    private String getPortNumber(String service, String protocol) {
        String upperService = service.toUpperCase();
        if ("ICMP".equals(protocol)) {
            String icmpTypeNumber = this.policyProcessorUtilityObject.getICMPType(upperService);
            if (icmpTypeNumber != null) {
                return icmpTypeNumber;
            }
        } else if (this.serviceToPortMap.containsKey(upperService)) {
            String toReturn = this.serviceToPortMap.get(upperService);
            HashMap<String, HashSet<String>> tt1 = new HashMap<String, HashSet<String>>();
            HashMap<String, HashSet<String>> tt2 = new HashMap<String, HashSet<String>>();
            HashSet<String> tt3 = new HashSet<String>();
            try {
                this.extractPortInfo(upperService, toReturn, tt1, tt2, this.resourceName, "FortiGate", true, tt3);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Iterator i$ = tt3.iterator();
            if (i$.hasNext()) {
                String proto = (String)i$.next();
                String portNumber = "";
                try {
                    portNumber = this.policyProcessorUtilityObject.convertHashSetToString(tt2.get(proto));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return portNumber;
            }
        }
        this.hasUnknownPorts = true;
        this.unResolvedObjectsSet.add(service);
        this.unknownPorts.add(service);
        return service;
    }

    private String constructProtocolSpecificPorts(HashSet<String> dstPortSet, HashSet<String> srcPortSet, StringBuilder protocolPortBuilder, String tempValue) throws Exception {
        Iterator<String> itr;
        protocolPortBuilder.setLength(0);
        if (dstPortSet != null && !dstPortSet.isEmpty()) {
            protocolPortBuilder.append("dstPort=");
            itr = dstPortSet.iterator();
            while (itr.hasNext()) {
                protocolPortBuilder.append(itr.next());
                protocolPortBuilder.append(",");
            }
            tempValue = this.removeLastDelimeter(protocolPortBuilder, ",");
            protocolPortBuilder.setLength(0);
            protocolPortBuilder.append(tempValue);
            protocolPortBuilder.append("#");
        } else {
            protocolPortBuilder.append("dstPort=Any#");
        }
        if (srcPortSet != null && !srcPortSet.isEmpty()) {
            protocolPortBuilder.append("srcPort=");
            itr = srcPortSet.iterator();
            while (itr.hasNext()) {
                protocolPortBuilder.append(itr.next());
                protocolPortBuilder.append(",");
            }
            tempValue = this.removeLastDelimeter(protocolPortBuilder, ",");
            protocolPortBuilder.setLength(0);
            protocolPortBuilder.append(tempValue);
            protocolPortBuilder.append("#");
        } else {
            protocolPortBuilder.append("srcPort=Any#");
        }
        return protocolPortBuilder.toString();
    }

    private String removeLastDelimeter(StringBuilder protocolPortBuilder, String delimeter) throws Exception {
        return protocolPortBuilder.substring(0, protocolPortBuilder.lastIndexOf(delimeter));
    }

    private String getDataFromBracket(String member) throws Exception {
        Matcher mat = bracketExtractPattern.matcher(member);
        if (mat.matches()) {
            member = mat.group(1);
        }
        return member;
    }

    private ArrayList getTheMatchedPattern(String protocolPortData) {
        ArrayList<Object> matcherInfo = new ArrayList<Object>();
        int i = 1;
        for (Pattern pat : portExtractPatternList) {
            Matcher mat = pat.matcher(protocolPortData);
            if (mat.matches()) {
                matcherInfo.add(i);
                matcherInfo.add(mat);
                return matcherInfo;
            }
            ++i;
        }
        return null;
    }

    private void populateInterfaceDetailsIntoDB(Long rID, LinkedHashMap<String, InterfaceDetails> interfaceDetailsObjMap, String deviceType, String resourceName) throws Exception {
        try {
            DataObject doo = DataAccess.constructDataObject();
            if (interfaceDetailsObjMap != null && !interfaceDetailsObjMap.isEmpty()) {
                LOGGER.fine("populating Interface Details.....");
                String objName = null;
                InterfaceDetails interfaceDetailsObj = null;
                for (Map.Entry<String, InterfaceDetails> entry : interfaceDetailsObjMap.entrySet()) {
                    objName = entry.getKey();
                    interfaceDetailsObj = entry.getValue();
                    objName = interfaceDetailsObj.getInterfaceName();
                    String aliasName = interfaceDetailsObj.getAliasName();
                    aliasName = aliasName != null ? aliasName : objName;
                    this.allInterfaces.add(objName);
                    Row interfaceDetailsRow = new Row("InterfaceDetails");
                    interfaceDetailsRow.set("RID", (Object)rID);
                    interfaceDetailsRow.set("INTERFACE_NAME", (Object)objName);
                    interfaceDetailsRow.set("ALIAS_NAME", (Object)aliasName);
                    if (this.hasInterfaceVsZoneMap) {
                        interfaceDetailsRow.set("INTERFACE_NETWORK_ZONE", (Object)this.interfaceVsZoneMap.get(aliasName));
                    }
                    String vlan = interfaceDetailsObj.getVdomName();
                    interfaceDetailsRow.set("VDOM_NAME", (Object)vlan);
                    if (vlan == null || "root".equals(vlan)) {
                        interfaceDetailsRow.set("INTERFACE_TYPE", (Object)"physical");
                    } else {
                        interfaceDetailsRow.set("INTERFACE_TYPE", (Object)"logical");
                    }
                    String servicesAllowed = interfaceDetailsObj.getAllowAccess();
                    if (servicesAllowed != null) {
                        String[] servicesArray = servicesAllowed.split(" ");
                        int servicesCount = servicesArray.length;
                        String service = null;
                        StringBuffer servicesBuffer = new StringBuffer();
                        for (int i = 0; i < servicesCount; ++i) {
                            service = servicesArray[i];
                            service = service.trim();
                            servicesBuffer.append(service);
                            if (i >= servicesCount - 1) continue;
                            servicesBuffer.append(",");
                        }
                        servicesAllowed = servicesBuffer.toString();
                    }
                    interfaceDetailsRow.set("SERVICES_ALLOWED", (Object)servicesAllowed);
                    String ip = interfaceDetailsObj.getIP();
                    if (ip != null && !"".equals(ip) && !"null".equals(ip)) {
                        ip = ip.replaceAll(" ", "/");
                        this.interfaceVsIPAddrMap.put(aliasName, ip);
                    }
                    interfaceDetailsRow.set("IPADDRESS", (Object)ip);
                    String status = interfaceDetailsObj.getStatus();
                    status = "down".equals(status) ? "No" : "Yes";
                    interfaceDetailsRow.set("ACTIVE", (Object)status);
                    interfaceDetailsRow.set("LOG", (Object)interfaceDetailsObj.getLogging());
                    interfaceDetailsRow.set("INTERFACE_TYPE", (Object)interfaceDetailsObj.getType());
                    interfaceDetailsRow.set("MODE", (Object)interfaceDetailsObj.getMode());
                    interfaceDetailsRow.set("ARP_FORWARD", (Object)interfaceDetailsObj.getArpForwardStatus());
                    LOGGER.log(Level.FINE, " FortigatePolicyProcessor :::: InterfaceDetails ROW is :::::::: {0} ", interfaceDetailsRow);
                    doo.addRow(interfaceDetailsRow);
                }
                DataAccess.add((DataObject)doo);
            } else {
                LOGGER.info("No Interfaces Found.....");
            }
        }
        catch (Exception exp) {
            throw new Exception("Problem while populating Interface Details into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateNetworkObjectsDataIntoDB(DataObject doo, Long rID, LinkedHashMap<String, NetworkObject> netObjMap, String deviceType, String resourceName) throws Exception {
        block11: {
            try {
                if (netObjMap != null && !netObjMap.isEmpty()) {
                    LOGGER.fine("populating Network Objects.....");
                    NetworkObject netObj = null;
                    for (Map.Entry<String, NetworkObject> entry : netObjMap.entrySet()) {
                        Object minMaxID;
                        String objName = entry.getKey();
                        netObj = entry.getValue();
                        String subnet = netObj.getSubnet();
                        String subnetMask = netObj.getSubnetMask();
                        String startIP = netObj.getStartIP();
                        String endIP = netObj.getEndIP();
                        String value = subnet != null && subnetMask != null ? subnet + "/" + subnetMask : (startIP != null && endIP != null ? startIP + "-" + endIP : null);
                        Row networkObjRow = new Row("FirewallObjects");
                        networkObjRow.set("RID", (Object)rID);
                        networkObjRow.set("NAME", (Object)netObj.getName());
                        networkObjRow.set("INTERFACE_NAME", (Object)netObj.getInterfaceName());
                        networkObjRow.set("VALUE_IN_CONFIG", (Object)value);
                        subnet = IPRange.getNetwork((String)subnetMask, (String)subnet);
                        networkObjRow.set("SUBNET", (Object)subnet);
                        networkObjRow.set("SUBNETWORK_ID", (Object)String.valueOf(IPRange.getIPNumber((String)subnet)));
                        networkObjRow.set("SUBNET_MASK", (Object)subnetMask);
                        networkObjRow.set("START_IP", (Object)startIP);
                        networkObjRow.set("END_IP", (Object)endIP);
                        String ipIDRange = netObj.getIPRangeID();
                        if (startIP != null && ipIDRange != null) {
                            minMaxID = ipIDRange.split("-");
                            networkObjRow.set("STARTIP_ID", (Object)minMaxID[0]);
                            networkObjRow.set("ENDIP_ID", (Object)minMaxID[1]);
                        }
                        networkObjRow.set("IP_RANGE", (Object)netObj.getIPRange());
                        networkObjRow.set("IPRANGE_ID", (Object)ipIDRange);
                        networkObjRow.set("OBJECT_TYPE", (Object)"Network");
                        networkObjRow.set("TO_DISPLAY", (Object)value);
                        this.netObjInfoMap.put(objName, value);
                        LOGGER.log(Level.FINE, " FortigatePolicyProcessor :::: FirewallObjects ROW is :::::::: {0} ", networkObjRow);
                        minMaxID = this.policyProcessorUtilityObject.firewallObjAutoGenKeyLock;
                        synchronized (minMaxID) {
                            DataAccess.generateValues((Row)networkObjRow);
                        }
                        doo.addRow(networkObjRow);
                        Object objID = networkObjRow.get("OBJID");
                        Row objToChildOneToNMapRow = new Row("ObjectToChildOneToNMapping");
                        objToChildOneToNMapRow.set("RID", (Object)rID);
                        objToChildOneToNMapRow.set("OBJID", objID);
                        objToChildOneToNMapRow.set("NAME", (Object)objName);
                        objToChildOneToNMapRow.set("OBJECT_DETAILS", (Object)value);
                        objToChildOneToNMapRow.set("LINK_NEEDED", (Object)"No");
                        Object object = this.policyProcessorUtilityObject.objOneToNMappingAutoGenKeyLock;
                        synchronized (object) {
                            DataAccess.generateValues((Row)objToChildOneToNMapRow);
                        }
                        doo.addRow(objToChildOneToNMapRow);
                        this.allObjects.add(objName);
                    }
                    break block11;
                }
                LOGGER.info("No Network Objects Found.....");
            }
            catch (Exception exp) {
                throw new Exception("Problem while populating Network Objects Details into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateStaticNATObjectsDataIntoDB(DataObject doo, Long rID, LinkedHashMap<String, StaticNATObject> staticNATObjMap, String deviceType, String resourceName) throws Exception {
        block12: {
            try {
                if (staticNATObjMap != null && !staticNATObjMap.isEmpty()) {
                    LOGGER.fine("populating Static NAT Objects.....");
                    String objName = null;
                    String externalIP = null;
                    String mappedIP = null;
                    String externalPort = null;
                    String mappedPort = null;
                    String staticNATDetails = null;
                    StaticNATObject staticNATObj = null;
                    for (Map.Entry<String, StaticNATObject> entry : staticNATObjMap.entrySet()) {
                        objName = entry.getKey();
                        staticNATObj = entry.getValue();
                        externalIP = staticNATObj.getExternalIP();
                        mappedIP = staticNATObj.getMappedIP();
                        externalPort = staticNATObj.getExternalPort();
                        mappedPort = staticNATObj.getMappedPort();
                        if (externalIP != null && mappedIP != null) {
                            staticNATDetails = "IPMap:" + externalIP + "-->" + mappedIP;
                        }
                        if (externalPort != null && mappedPort != null) {
                            staticNATDetails = staticNATDetails + "and PortMap:" + externalPort + "-->" + mappedPort;
                        }
                        Row staticNATObjRow = new Row("FirewallObjects");
                        staticNATObjRow.set("RID", (Object)rID);
                        staticNATObjRow.set("NAME", (Object)staticNATObj.getName());
                        staticNATObjRow.set("INTERFACE_NAME", (Object)staticNATObj.getExtInterface());
                        staticNATObjRow.set("EXTERNAL_IP", (Object)staticNATObj.getExternalIP());
                        staticNATObjRow.set("EXTERNAL_PORT", (Object)staticNATObj.getExternalPort());
                        staticNATObjRow.set("MAPPED_IP", (Object)staticNATObj.getMappedIP());
                        staticNATObjRow.set("MAPPED_PORT", (Object)staticNATObj.getMappedPort());
                        staticNATObjRow.set("PROTOCOL", (Object)staticNATObj.getProtocol());
                        staticNATObjRow.set("COMMENTS", (Object)staticNATObj.getComment());
                        staticNATObjRow.set("OBJECT_TYPE", (Object)"StaticNAT");
                        staticNATObjRow.set("VALUE_IN_CONFIG", (Object)staticNATDetails);
                        staticNATObjRow.set("TO_DISPLAY", (Object)staticNATDetails);
                        staticNATObjRow.set("IP_RANGE", (Object)staticNATObj.getIPRange());
                        staticNATObjRow.set("IPRANGE_ID", (Object)staticNATObj.getIPRangeID());
                        this.staticNATObjInfoMap.put(staticNATObj.getName(), staticNATDetails);
                        Object object = this.policyProcessorUtilityObject.firewallObjAutoGenKeyLock;
                        synchronized (object) {
                            DataAccess.generateValues((Row)staticNATObjRow);
                        }
                        doo.addRow(staticNATObjRow);
                        Object objID = staticNATObjRow.get("OBJID");
                        Row objToChildOneToNMapRow = new Row("ObjectToChildOneToNMapping");
                        objToChildOneToNMapRow.set("RID", (Object)rID);
                        objToChildOneToNMapRow.set("OBJID", objID);
                        objToChildOneToNMapRow.set("NAME", (Object)staticNATObj.getName());
                        objToChildOneToNMapRow.set("OBJECT_DETAILS", (Object)staticNATDetails);
                        objToChildOneToNMapRow.set("LINK_NEEDED", (Object)"No");
                        Object object2 = this.policyProcessorUtilityObject.objOneToNMappingAutoGenKeyLock;
                        synchronized (object2) {
                            DataAccess.generateValues((Row)objToChildOneToNMapRow);
                        }
                        doo.addRow(objToChildOneToNMapRow);
                        this.allObjects.add(objName);
                    }
                    break block12;
                }
                LOGGER.info("No Static NAT Objects Found.....");
            }
            catch (Exception exp) {
                throw new Exception("Problem while populating Static NAT Objects Details into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateServiceObjectsDataIntoDB(DataObject doo, Long rID, LinkedHashMap<String, ServiceObject> serviceObjMap, String deviceType, String resourceName) throws Exception {
        block23: {
            try {
                if (serviceObjMap != null && !serviceObjMap.isEmpty()) {
                    LOGGER.fine("populating Service Objects.....");
                    String objName = null;
                    ServiceObject serviceObj = null;
                    for (Map.Entry<String, ServiceObject> entry : serviceObjMap.entrySet()) {
                        Object icmpType;
                        String sctpPortRange;
                        String udpPortRange;
                        objName = entry.getKey();
                        serviceObj = entry.getValue();
                        LOGGER.log(Level.FINER, "serviceObj Details:::key::" + objName + " and Name::" + serviceObj.getName() + " and Protocol::" + serviceObj.getProtocol() + " and TCPPortRange::" + serviceObj.getTCPPortRange() + " and UDPPortRange::" + serviceObj.getUDPPortRange() + " and SCTPPortRange::" + serviceObj.getSCTPPortRange() + " and Comment::" + serviceObj.getComment());
                        Row serviceObjRow = new Row("FirewallObjects");
                        serviceObjRow.set("RID", (Object)rID);
                        serviceObjRow.set("NAME", (Object)serviceObj.getName());
                        String protocol = serviceObj.getProtocol();
                        serviceObjRow.set("PROTOCOL", (Object)protocol);
                        String portDetails = null;
                        String tcpPortRange = serviceObj.getTCPPortRange();
                        if (tcpPortRange != null) {
                            if ("".equals(tcpPortRange.trim())) {
                                portDetails = portDetails != null ? portDetails + " |_| Any TCP" : "Any TCP";
                            } else {
                                String string = portDetails = portDetails != null ? portDetails + " |_| TCP " + tcpPortRange : "TCP " + tcpPortRange;
                            }
                        }
                        if ((udpPortRange = serviceObj.getUDPPortRange()) != null) {
                            if ("".equals(udpPortRange.trim())) {
                                portDetails = portDetails != null ? portDetails + " |_| Any UDP" : "Any UDP";
                            } else {
                                String string = portDetails = portDetails != null ? portDetails + " |_| UDP " + udpPortRange : "UDP " + udpPortRange;
                            }
                        }
                        if ((sctpPortRange = serviceObj.getSCTPPortRange()) != null) {
                            if ("".equals(sctpPortRange.trim())) {
                                portDetails = portDetails != null ? portDetails + " |_| Any SCTP" : "Any SCTP";
                            } else {
                                String string = portDetails = portDetails != null ? portDetails + " |_| SCTP " + sctpPortRange : "SCTP " + sctpPortRange;
                            }
                        }
                        if (portDetails == null && protocol != null) {
                            if (protocol.indexOf("ICMP") > -1) {
                                icmpType = serviceObj.getICMPType();
                                portDetails = icmpType != null ? protocol + " " + (String)icmpType : "Any " + protocol;
                            } else {
                                portDetails = serviceObj.getService();
                                if (portDetails != null) {
                                    portDetails = "".equals(portDetails = portDetails.trim()) ? "Any" : "Any " + portDetails;
                                }
                            }
                        }
                        serviceObjRow.set("VALUE_IN_CONFIG", (Object)portDetails);
                        serviceObjRow.set("COMMENTS", (Object)serviceObj.getComment());
                        serviceObjRow.set("OBJECT_TYPE", (Object)"Service");
                        serviceObjRow.set("TO_DISPLAY", (Object)portDetails);
                        this.serviceObjInfoMap.put(serviceObj.getName(), portDetails);
                        LOGGER.log(Level.FINE, " FortiGatePolicyProcessor :::: FirewallObjects ROW is :::::::: {0} ", serviceObjRow);
                        icmpType = this.policyProcessorUtilityObject.firewallObjAutoGenKeyLock;
                        synchronized (icmpType) {
                            DataAccess.generateValues((Row)serviceObjRow);
                        }
                        doo.addRow(serviceObjRow);
                        Object objID = serviceObjRow.get("OBJID");
                        Row objToChildOneToNMapRow = new Row("ObjectToChildOneToNMapping");
                        objToChildOneToNMapRow.set("RID", (Object)rID);
                        objToChildOneToNMapRow.set("OBJID", objID);
                        objToChildOneToNMapRow.set("NAME", (Object)serviceObj.getName());
                        objToChildOneToNMapRow.set("OBJECT_DETAILS", (Object)portDetails);
                        objToChildOneToNMapRow.set("LINK_NEEDED", (Object)"No");
                        Object object = this.policyProcessorUtilityObject.objOneToNMappingAutoGenKeyLock;
                        synchronized (object) {
                            DataAccess.generateValues((Row)objToChildOneToNMapRow);
                        }
                        doo.addRow(objToChildOneToNMapRow);
                        this.allObjects.add(objName);
                    }
                    break block23;
                }
                LOGGER.info("No Service Objects Found.....");
            }
            catch (Exception exp) {
                throw new Exception("Problem while populating Service Objects Details into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateObjectsGroup(DataObject doo, LinkedHashMap<String, FirewallGroupObject> objGroupMap, Long rID, String deviceType, String resourceName, String objectGroupType) throws Exception {
        block24: {
            String objName = "";
            try {
                LOGGER.fine("populating " + objectGroupType + " Objects Groups.....");
                if (objGroupMap == null || objGroupMap.isEmpty()) break block24;
                for (Map.Entry<String, FirewallGroupObject> entry : objGroupMap.entrySet()) {
                    this.unResolvedObjectsSet.clear();
                    objName = entry.getKey();
                    FirewallGroupObject groupObj = entry.getValue();
                    String members = groupObj.getMembers();
                    String objGroupType = groupObj.getType();
                    String objGroupName = groupObj.getName();
                    String[] results = null;
                    if (members != null) {
                        results = this.getMembersRelatedInfoForDB(members, rID, objGroupType, false);
                        if (!this.unResolvedObjectsSet.isEmpty()) {
                            HashSet toMemorize = (HashSet)this.unResolvedObjectsSet.clone();
                            this.objGroupUnResolvedMembers.put(objName, toMemorize);
                        }
                    }
                    String memberDetails = null;
                    String memberSubNetworkDetails = null;
                    String memberSubnetMaskDetails = null;
                    String memberIPRangeDetails = null;
                    String memberIDDetails = null;
                    if (results != null) {
                        members = results[0];
                        memberDetails = results[1];
                        if (objGroupType.equals("Network") || objGroupType.equals("StaticNAT")) {
                            memberSubNetworkDetails = results[2];
                            memberSubnetMaskDetails = results[3];
                            memberIPRangeDetails = results[4];
                            memberIDDetails = results[5];
                            ArrayList<String> objGroupMemberDetails = new ArrayList<String>();
                            objGroupMemberDetails.add(memberSubNetworkDetails);
                            objGroupMemberDetails.add(memberSubnetMaskDetails);
                            objGroupMemberDetails.add(memberIPRangeDetails);
                            objGroupMemberDetails.add(memberIDDetails);
                            if (objGroupType.equals("Network")) {
                                this.netObjGroupMemberDetailsMap.put(objName, objGroupMemberDetails);
                            } else {
                                this.staticNATObjGroupMemberDetailsMap.put(objName, objGroupMemberDetails);
                            }
                        }
                    }
                    Row firewallObjRow = new Row("FirewallObjects");
                    firewallObjRow.set("RID", (Object)rID);
                    firewallObjRow.set("NAME", (Object)objGroupName);
                    if (objGroupType.equals("Network")) {
                        firewallObjRow.set("INTERFACE_NAME", (Object)groupObj.getInterfaceName());
                        firewallObjRow.set("VALUE_IN_CONFIG", (Object)members);
                        firewallObjRow.set("SUBNET", (Object)memberSubNetworkDetails);
                        firewallObjRow.set("SUBNET_MASK", (Object)memberSubnetMaskDetails);
                        firewallObjRow.set("IP_RANGE", (Object)memberIPRangeDetails);
                        firewallObjRow.set("IPRANGE_ID", (Object)memberIDDetails);
                        firewallObjRow.set("OBJECT_TYPE", (Object)"Network");
                        firewallObjRow.set("COMMENTS", (Object)groupObj.getComment());
                        firewallObjRow.set("TO_DISPLAY", (Object)memberDetails);
                        this.netObjInfoMap.put(objGroupName, memberDetails);
                    } else if (objGroupType.equals("StaticNAT")) {
                        firewallObjRow.set("INTERFACE_NAME", (Object)groupObj.getInterfaceName());
                        firewallObjRow.set("VALUE_IN_CONFIG", (Object)members);
                        firewallObjRow.set("SUBNET", (Object)memberSubNetworkDetails);
                        firewallObjRow.set("SUBNET_MASK", (Object)memberSubnetMaskDetails);
                        firewallObjRow.set("IP_RANGE", (Object)memberIPRangeDetails);
                        firewallObjRow.set("IPRANGE_ID", (Object)memberIDDetails);
                        firewallObjRow.set("COMMENTS", (Object)groupObj.getComment());
                        firewallObjRow.set("OBJECT_TYPE", (Object)"StaticNAT");
                        firewallObjRow.set("TO_DISPLAY", (Object)memberDetails);
                        this.staticNATObjInfoMap.put(objGroupName, memberDetails);
                    } else if (objGroupType.equals("Service")) {
                        firewallObjRow.set("VALUE_IN_CONFIG", (Object)members);
                        firewallObjRow.set("COMMENTS", (Object)groupObj.getComment());
                        firewallObjRow.set("OBJECT_TYPE", (Object)"Service");
                        firewallObjRow.set("TO_DISPLAY", (Object)memberDetails);
                        this.serviceObjInfoMap.put(objGroupName, memberDetails);
                    }
                    Object object = this.policyProcessorUtilityObject.firewallObjAutoGenKeyLock;
                    synchronized (object) {
                        DataAccess.generateValues((Row)firewallObjRow);
                    }
                    doo.addRow(firewallObjRow);
                    Long objID = (Long)firewallObjRow.get("OBJID");
                    String[] ObjGrps = null;
                    if (members != null) {
                        for (String objElement : ObjGrps = members.split("<br>")) {
                            objElement = objElement != null ? objElement.replace("<br>", "\n") : objElement;
                            Row objToChildOneToNMapRow = new Row("ObjectToChildOneToNMapping");
                            objToChildOneToNMapRow.set("RID", (Object)rID);
                            objToChildOneToNMapRow.set("OBJID", (Object)objID);
                            objToChildOneToNMapRow.set("NAME", (Object)objGroupName);
                            objToChildOneToNMapRow.set("OBJECT_DETAILS", (Object)objElement);
                            if (objGroupMap.containsKey(objElement)) {
                                objToChildOneToNMapRow.set("LINK_NEEDED", (Object)"Yes");
                            } else {
                                objToChildOneToNMapRow.set("LINK_NEEDED", (Object)"No");
                            }
                            Object object2 = this.policyProcessorUtilityObject.objOneToNMappingAutoGenKeyLock;
                            synchronized (object2) {
                                DataAccess.generateValues((Row)objToChildOneToNMapRow);
                            }
                            doo.addRow(objToChildOneToNMapRow);
                        }
                    }
                    this.allObjects.add(objName);
                }
            }
            catch (Exception exp) {
                throw new Exception("Problem while populating " + objectGroupType + " Objects Groups Details with group name as::" + objName + " into DB for the firewall " + resourceName + " of " + deviceType + " Vendor..", exp);
            }
        }
    }

    private String[] getMembersRelatedInfoForDB(String members, Long rID, String objGroupType, boolean forRuleInfo) throws Exception {
        String[] results = new String[6];
        try {
            String[] membersArray;
            StringBuilder memberBuffer = new StringBuilder();
            StringBuilder memberDetailsBuffer = new StringBuilder();
            StringBuilder memberSubNetworkDetailsBuffer = new StringBuilder();
            StringBuilder memberSubNetMaskDetailsBuffer = new StringBuilder();
            StringBuilder memberIPRangeDetailsBuffer = new StringBuilder();
            StringBuilder memberIPIDDetailsBuffer = new StringBuilder();
            String value = null;
            String temp = null;
            int length = 0;
            for (String member : membersArray = members.split("\" \"")) {
                member = member.replace("\"", "");
                if ((member = member.trim()) == null) continue;
                if (this.allObjects.contains(member)) {
                    this.usedObjects.add(member);
                }
                memberBuffer.append(member);
                if (member.equalsIgnoreCase("Any") || member.equalsIgnoreCase("All")) {
                    value = member;
                } else {
                    int protoIndex;
                    HashMap<String, String> objInfoMap = null;
                    if ("Network".equals(objGroupType)) {
                        objInfoMap = this.netObjInfoMap;
                        if (forRuleInfo) {
                            objInfoMap.putAll(this.staticNATObjInfoMap);
                            if (this.staticNATObjInfoMap.containsKey(member)) {
                                objGroupType = "StaticNAT";
                            }
                        }
                    } else if ("StaticNAT".equals(objGroupType)) {
                        objInfoMap = this.staticNATObjInfoMap;
                    } else if ("Service".equals(objGroupType)) {
                        objInfoMap = this.serviceObjInfoMap;
                    }
                    if ((value = objInfoMap.get(member)) == null && (protoIndex = member.indexOf("(")) > 0) {
                        String objNameHead = member.substring(0, protoIndex);
                        value = objInfoMap.get(objNameHead);
                    }
                }
                if (value != null && value.indexOf("<br>") > 0) {
                    temp = member + "(Group): ";
                    memberDetailsBuffer.append(temp);
                    length = temp.length();
                    String spaceString = "";
                    for (int k = 0; k < length; ++k) {
                        spaceString = spaceString + " ";
                    }
                    String[] valArray = value.split("<br>");
                    int valLength = valArray.length;
                    for (int j = 0; j < valLength; ++j) {
                        temp = valArray[j];
                        memberDetailsBuffer.append(temp);
                        if (j >= valLength - 1) continue;
                        memberDetailsBuffer.append("<br>");
                        memberDetailsBuffer.append(spaceString);
                    }
                } else if (value != null && !member.equals(value)) {
                    memberDetailsBuffer.append(member);
                    memberDetailsBuffer.append("(");
                    memberDetailsBuffer.append(value);
                    memberDetailsBuffer.append(")");
                } else if ("Service".equals(objGroupType)) {
                    String defaultServiceObj = this.serviceToPortMap.get(member.toUpperCase());
                    if (defaultServiceObj != null) {
                        memberDetailsBuffer.append(defaultServiceObj);
                    } else {
                        this.unResolvedObjectsSet.add(member);
                        memberDetailsBuffer.append(member);
                    }
                } else {
                    memberDetailsBuffer.append(member);
                }
                if (objGroupType.equals("Network") || objGroupType.equals("StaticNAT")) {
                    String[] networkObjMetaData = this.getNetworkSpecificValuesFromObjectsTable(member, rID, objGroupType);
                    if (forRuleInfo && this.objGroupUnResolvedMembers.containsKey(member)) {
                        this.unResolvedObjectsSet.addAll((Collection<String>)this.objGroupUnResolvedMembers.get(member));
                        this.unResolvedObjectsSet.add(member);
                    }
                    if (networkObjMetaData != null) {
                        temp = networkObjMetaData[0];
                        memberSubNetworkDetailsBuffer.append(temp);
                        memberSubNetworkDetailsBuffer.append(",");
                        temp = networkObjMetaData[1];
                        memberSubNetMaskDetailsBuffer.append(temp);
                        memberSubNetMaskDetailsBuffer.append(",");
                        temp = networkObjMetaData[2];
                        memberIPRangeDetailsBuffer.append(temp);
                        memberIPRangeDetailsBuffer.append(",");
                        temp = networkObjMetaData[3];
                        if (temp == null || "null".equals(temp) || "".equals(temp.trim())) {
                            this.unResolvedObjectsSet.add(member);
                        } else {
                            memberIPIDDetailsBuffer.append(temp);
                            memberIPIDDetailsBuffer.append(",");
                        }
                    } else {
                        String ipIDRangeStr = this.policyProcessorUtilityObject.getIPNumber(member);
                        if (ipIDRangeStr == null || member.equals(ipIDRangeStr)) {
                            this.unResolvedObjectsSet.add(member);
                        } else {
                            memberIPIDDetailsBuffer.append(ipIDRangeStr);
                            memberIPIDDetailsBuffer.append(",");
                        }
                    }
                }
                memberBuffer.append("<br>");
                memberDetailsBuffer.append("<br>");
            }
            results[0] = this.policyProcessorUtilityObject.removeLastDelimeter(memberBuffer, "<br>");
            results[1] = this.policyProcessorUtilityObject.removeLastDelimeter(memberDetailsBuffer, "<br>");
            if (objGroupType.equals("Network") || objGroupType.equals("StaticNAT")) {
                results[2] = this.policyProcessorUtilityObject.removeLastDelimeter(memberSubNetworkDetailsBuffer, ",");
                results[3] = this.policyProcessorUtilityObject.removeLastDelimeter(memberSubNetMaskDetailsBuffer, ",");
                results[4] = this.policyProcessorUtilityObject.removeLastDelimeter(memberIPRangeDetailsBuffer, ",");
                results[5] = this.policyProcessorUtilityObject.removeLastDelimeter(memberIPIDDetailsBuffer, ",");
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            throw ee;
        }
        return results;
    }

    private String[] getNetworkSpecificValuesFromObjectsTable(String objName, Long rID, String objType) throws Exception {
        String[] objMetaData = new String[4];
        LinkedHashMap<String, ArrayList<String>> objGroupMemberDetailsMap = null;
        try {
            if (objType.equals("Network")) {
                NetworkObject netObj = this.netObjMap.get(objName);
                if (netObj != null) {
                    objMetaData[0] = netObj.getSubnet();
                    objMetaData[1] = netObj.getSubnetMask();
                    objMetaData[2] = netObj.getIPRange();
                    objMetaData[3] = netObj.getIPRangeID();
                    return objMetaData;
                }
                objGroupMemberDetailsMap = this.netObjGroupMemberDetailsMap;
            } else {
                StaticNATObject staticNATObj = this.staticNATObjMap.get(objName);
                if (staticNATObj != null) {
                    objMetaData[0] = staticNATObj.getSubnet();
                    objMetaData[1] = staticNATObj.getSubnetMask();
                    objMetaData[2] = staticNATObj.getIPRange();
                    objMetaData[3] = staticNATObj.getIPRangeID();
                    return objMetaData;
                }
                objGroupMemberDetailsMap = this.staticNATObjGroupMemberDetailsMap;
            }
            ArrayList<String> tempObjGrpDetails = objGroupMemberDetailsMap.get(objName);
            if (tempObjGrpDetails != null) {
                objMetaData[0] = tempObjGrpDetails.get(0);
                objMetaData[1] = tempObjGrpDetails.get(1);
                objMetaData[2] = tempObjGrpDetails.get(2);
                objMetaData[3] = tempObjGrpDetails.get(3);
                return objMetaData;
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    @Override
    public void cleanupMemory() {
        this.netObjMap = null;
        this.serviceObjMap = null;
        this.policyObjMap = null;
        this.staticNATObjMap = null;
        this.netObjGroupMap = null;
        this.serviceObjGroupMap = null;
        this.staticNATObjGroupMap = null;
        this.netObjInfoMap = null;
        this.serviceObjInfoMap = null;
        this.staticNATObjInfoMap = null;
        this.netObjList = null;
        this.serviceObjList = null;
        this.staticNATObjList = null;
        this.netObjGroupMemberDetailsMap = null;
        this.staticNATObjGroupMemberDetailsMap = null;
        this.allObjects = null;
        this.allInterfaces = null;
        this.usedObjects = null;
        this.usedInterfaces = null;
        this.interfaceDetailsObjMap = null;
        this.interfaceAliasVsOriginalNamesMap = null;
        this.interfaceVsZoneMap = null;
        this.interfaceVsIPAddrMap = null;
        this.unFoundDstInterfaceSet = null;
        this.unFoundSrcInterfaceSet = null;
        this.unknownPorts = null;
        this.policyNameVsIDMap = null;
        this.unResolvedObjectsSet = null;
        this.objGroupUnResolvedMembers = null;
    }

    private LinkedHashMap<FWAEnumConstants.ParserKeys, String> executeParserRuleListAndGetResultMap(String data, Vector<FirewallPolicyParserRule> parserRules) throws Exception {
        Pattern pattern;
        ArrayList<FirewallPolicyParserRuleAttribute> attributes;
        FirewallPolicyParserRule rule;
        String expression;
        boolean patternMatched;
        LinkedHashMap<FWAEnumConstants.ParserKeys, String> resultMap = new LinkedHashMap<FWAEnumConstants.ParserKeys, String>();
        Iterator<FirewallPolicyParserRule> i$ = parserRules.iterator();
        while (i$.hasNext() && !(patternMatched = this.policyProcessorUtilityObject.executeParserRule(data, expression = (rule = i$.next()).getRegex(), attributes = rule.getAttributes(), pattern = rule.getPattern(), resultMap))) {
        }
        return resultMap;
    }

    private String getDefaultCheckListItemStatus(Long genericSectionID) {
        try {
            Criteria crit = new Criteria(new Column("FWAConfigCheckListDetails", "GENERIC_SECTION_ID"), (Object)genericSectionID, 0);
            DataObject complianceCheckListSectionDO = DataAccess.get((String)"FWAConfigCheckListDetails", (Criteria)crit);
            if (!complianceCheckListSectionDO.isEmpty()) {
                String defaultStatus = (String)complianceCheckListSectionDO.getFirstValue("FWAConfigCheckListDetails", "STATUS_DECIDER");
                defaultStatus = "".equals(defaultStatus = defaultStatus.trim()) ? null : defaultStatus;
                return defaultStatus;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return null;
    }

    private String getAliasName(String ifName) {
        if (ifName == null || this.interfaceAliasVsOriginalNamesMap.containsKey(ifName) || !this.interfaceAliasVsOriginalNamesMap.containsValue(ifName)) {
            return ifName;
        }
        for (Map.Entry<String, String> entry : this.interfaceAliasVsOriginalNamesMap.entrySet()) {
            if (!ifName.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return ifName;
    }
}

